/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.cal.CostDiffGatherGistEnum;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.LocaleUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CostDiffGatherReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.StockGatherReportFacadeControllerBean");
    private static final String res = "com.kingdee.eas.scm.cal.CalRptResource";
    private String fiOrgUnitID = null;

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        int i;
        String sql;
        Context ctx = this.getContext();
        String tmpTable = this.createTempTable(filter);
        if (filter.getObject("company") instanceof OrgUnitInfo) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)filter.getObject("company");
            CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId().toString()));
            filter.setObject("company", (Object)curCompany);
            boolean checkPermission = SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (String)curCompany.getId().toString(), (String)"costdiffgatherreport_view");
            if (!checkPermission) {
                return null;
            }
        }
        String insertSql = this.getPeriodHappen(ctx, tmpTable, filter);
        DbUtil.execute((Context)ctx, (String)insertSql);
        int periodYFrom = Integer.parseInt(filter.getObject("yearFrom").toString());
        int endYear = Integer.parseInt(filter.getObject("yearTo").toString());
        int periodMFrom = Integer.parseInt(filter.getObject("periodFrom").toString());
        int endPeriod = Integer.parseInt(filter.getObject("periodTo").toString());
        int toPeriod = endYear * 100 + endPeriod;
        int beginOldYear = periodYFrom;
        int beginOldPeriod = periodMFrom;
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)filter.getObject("company")));
        int currentPeriod = currentPeriodInfo.getPeriodYear() * 100 + currentPeriodInfo.getPeriodNumber();
        PeriodInfo nextPeriodInfo = null;
        try {
            nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriodInfo);
        }
        catch (BOSException be) {
            logger.debug((Object)"next period is null ");
        }
        catch (EASBizException ee) {
            logger.debug((Object)"next period is null ");
        }
        int nextPeriod = -1;
        if (nextPeriodInfo != null) {
            nextPeriod = nextPeriodInfo.getPeriodYear() * 100 + nextPeriodInfo.getPeriodNumber();
        }
        if (100 * periodYFrom + periodMFrom > currentPeriod) {
            periodYFrom = currentPeriodInfo.getPeriodYear();
            periodMFrom = currentPeriodInfo.getPeriodNumber();
        }
        if (toPeriod > currentPeriod && nextPeriodInfo != null && (sql = this.getInsertNextPeriod(ctx, tmpTable, currentPeriodInfo, nextPeriodInfo)) != null) {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (toPeriod > nextPeriod && nextPeriod != -1) {
            try {
                PeriodInfo next2PeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriodInfo);
                String sql2 = this.getInsertNextPeriod(ctx, tmpTable, nextPeriodInfo, next2PeriodInfo);
                if (sql2 != null) {
                    DbUtil.execute((Context)ctx, (String)sql2);
                }
            }
            catch (BOSException be) {
                logger.debug((Object)"next 2 period is null");
            }
            catch (EASBizException ee) {
                logger.debug((Object)"next 2 period is null");
            }
        }
        if (toPeriod >= currentPeriod) {
            sql = this.updatePeriodLast(ctx, tmpTable, currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber());
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (toPeriod >= nextPeriod && nextPeriod != -1) {
            sql = this.updatePeriodFirst(ctx, tmpTable, currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber(), nextPeriodInfo.getPeriodYear(), nextPeriodInfo.getPeriodNumber());
            DbUtil.execute((Context)ctx, (String)sql);
            sql = this.updatePeriodLast(ctx, tmpTable, nextPeriodInfo.getPeriodYear(), nextPeriodInfo.getPeriodNumber());
            DbUtil.execute((Context)ctx, (String)sql);
        }
        if (filter.getBoolean("noInOrOutNoShow")) {
            sql = "delete from " + tmpTable + " where FInQty=0 and FOutQty=0 and FInStandardCost=0 and FInActualCost=0 and FOutStandardCost=0 and FOutActualCost=0";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        String totalSql = this.getPeriodHappenTotal(ctx, tmpTable, filter);
        DbUtil.execute((Context)ctx, (String)totalSql);
        CostDiffGatherGistEnum sumType = (CostDiffGatherGistEnum)((Object)filter.getObject("sumType"));
        boolean isCalculateType = CostDiffGatherGistEnum.CALCULATETYPE.equals((Object)sumType);
        String periodTotalSql = this.getPeriodTotal(ctx, tmpTable, isCalculateType);
        DbUtil.execute((Context)ctx, (String)periodTotalSql);
        this.getYearTotal(ctx, tmpTable, periodYFrom, periodMFrom, endYear, endPeriod, isCalculateType);
        this.getAllTotal(ctx, tmpTable, periodYFrom, periodMFrom, isCalculateType);
        this.insertSecondTotal(ctx, tmpTable, filter);
        String sql3 = "Update " + tmpTable + " Set FYear=null Where FYear=0 ";
        DbUtil.execute((Context)ctx, (String)sql3);
        sql3 = "Update " + tmpTable + " Set FPeriodNumber=null Where FPeriodNumber=0 ";
        DbUtil.execute((Context)ctx, (String)sql3);
        sql3 = isCalculateType ? "Update " + tmpTable + " Set FSUMTYPEID=null Where FSUMTYPEID=0 " : "Update " + tmpTable + " Set FSUMTYPEID=null Where FSUMTYPEID in('',' ')";
        DbUtil.execute((Context)ctx, (String)sql3);
        if (100 * beginOldYear + beginOldPeriod > currentPeriod) {
            sql3 = "delete from " + tmpTable + " where 100*fyear + FPeriodNumber < " + (100 * beginOldYear + beginOldPeriod);
            DbUtil.execute((Context)ctx, (String)sql3);
        }
        int materialGroupLevel = Integer.parseInt(filter.getObject("materialGroupLevel").toString());
        if (CostDiffGatherGistEnum.MATERIALTYPE.equals((Object)sumType)) {
            sql3 = "update " + tmpTable + " as  t2 set FSumTypeName=";
            sql3 = sql3 + "(select t3.flongnumber from t_bd_material t1,t_bd_materialgroup t3 where  t2.fmaterialid=t1.fid and t3.fid=t1.fmaterialgroupid) where findex=0";
            DbUtil.execute((Context)ctx, (String)sql3);
            sql3 = "update " + tmpTable + " as  t2 set FMATERIALGROUPID1=";
            sql3 = sql3 + "(select CASE CHARINDEX('!', t3.flongnumber) WHEN 0 THEN t3.flongnumber ELSE LEFT(t3.flongnumber,CHARINDEX('!', t3.flongnumber)-1) END from t_bd_material t1,t_bd_materialgroup t3 where  t2.fmaterialid=t1.fid and t3.fid=t1.fmaterialgroupid) ";
            DbUtil.execute((Context)ctx, (String)sql3);
            sql3 = "update " + tmpTable + " as  t1 set FMATERIALGROUPNAME1=";
            sql3 = sql3 + "(select t2.fname_" + this.getLoc(ctx) + " from t_bd_materialgroup t2 where t1.FMATERIALGROUPID1=t2.flongnumber and t2.FGROUPSTANDARD = 'dR8lnQEPEADgAAWKwKgSxZeb4R8=') ";
            DbUtil.execute((Context)ctx, (String)sql3);
            for (int i2 = 2; i2 <= materialGroupLevel; ++i2) {
                sql3 = "update " + tmpTable + " set FMATERIALGROUPID" + i2 + "=CASE LENGTH(FSumTypeName)-LENGTH(FMATERIALGROUPID" + (i2 - 1) + "||'') when 0 then '' when -1 then '' else SUBSTRING(FSumTypeName,length(FMATERIALGROUPID" + (i2 - 1) + ")+2,length(FSumTypeName)-length(FMATERIALGROUPID" + (i2 - 1) + ")) END";
                DbUtil.execute((Context)ctx, (String)sql3);
                sql3 = "update " + tmpTable + " set FMATERIALGROUPID" + i2 + "=CASE CHARINDEX('!', FMATERIALGROUPID" + i2 + " ) WHEN 0 THEN FMATERIALGROUPID" + i2 + "  ELSE LEFT(FMATERIALGROUPID" + i2 + " ,CHARINDEX('!',FMATERIALGROUPID" + i2 + " )-1) END";
                DbUtil.execute((Context)ctx, (String)sql3);
                sql3 = "update " + tmpTable + " set FMATERIALGROUPID" + i2 + "=case  FMATERIALGROUPID" + i2 + " WHEN '' then '' else FMATERIALGROUPID" + (i2 - 1) + "||'!'||FMATERIALGROUPID" + i2 + " END";
                DbUtil.execute((Context)ctx, (String)sql3);
                sql3 = "update " + tmpTable + " as  t1 set FMATERIALGROUPNAME" + i2;
                sql3 = sql3 + "=(select t2.fname_" + this.getLoc(ctx) + " from t_bd_materialgroup t2 where t1.FMATERIALGROUPID" + i2 + "=t2.flongnumber and t2.FGROUPSTANDARD = 'dR8lnQEPEADgAAWKwKgSxZeb4R8=') ";
                DbUtil.execute((Context)ctx, (String)sql3);
            }
            sql3 = "delete from " + tmpTable + " where findex=1";
            DbUtil.execute((Context)ctx, (String)sql3);
            sql3 = "update  " + tmpTable + " set FMATERIALGROUPNAME1=fsumtypename where findex<>0";
            DbUtil.execute((Context)ctx, (String)sql3);
            StringBuffer sqlbuff = new StringBuffer();
            for (i = 1; i <= materialGroupLevel; ++i) {
                int j;
                sqlbuff.setLength(0);
                sqlbuff.append("Insert Into " + tmpTable);
                sqlbuff.append("(\r\n FINDEX,FCompanyOrgUnitID,FCompanyOrg,FYear,FPeriodNumber,FMaterialID ,FMatName ,FMatNumber ,");
                sqlbuff.append("FMatModel,FMatUnitName,FSUMTYPEID ,FSUMTYPENAME ,");
                sqlbuff.append("FBeginQty,FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate,");
                sqlbuff.append("FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,FInDiffRate,");
                sqlbuff.append("FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,FOutDiffRate,");
                sqlbuff.append("FEndQty,FEndPrice,FEndStandardCost,FEndActualCost,FEndDiffCost,FEndDiffRate,FMatQtyPrecision,FPricePrecision,FAmountPrecision");
                for (j = 1; j <= i; ++j) {
                    sqlbuff.append(",FMATERIALGROUPID" + j + ",FMATERIALGROUPNAME" + j);
                }
                sqlbuff.append(")\r\n");
                sqlbuff.append(" Select 1 as FIndex,FCompanyOrgUnitID as FCompanyOrgUnitID,FCompanyOrg as FCompanyOrg,\r\n");
                sqlbuff.append("FYear,FPeriodNumber,\r\n");
                sqlbuff.append("' ' as FMaterialID,' ' as FMatName,\r\n");
                sqlbuff.append("' ' as FMatNumber,' ' as FMatModel,");
                sqlbuff.append("' ' as FMatUnitName,\r\n");
                if (isCalculateType) {
                    sqlbuff.append("0 as FSumTypeID, ");
                } else {
                    sqlbuff.append("' ' as FSumTypeID, ");
                }
                sqlbuff.append("'' FSumTypeName,\r\n");
                sqlbuff.append("sum(FBeginQty) as FBeginQty,");
                sqlbuff.append("(case sum(FBeginQty) when 0 then 0 else ");
                sqlbuff.append("TO_DECIMAL(to_decimal(sum(FBeginStandardCost),17,4)/sum(FBeginQty),17,6) end) as FBeginPrice,");
                sqlbuff.append("sum(FBeginStandardCost) as FBeginStandardCost,sum(FBeginActualCost) as FBeginActualCost,");
                sqlbuff.append("sum(FBeginDiffCost) as FBeginDiffCost,");
                sqlbuff.append("(case sum(FBeginStandardCost) when 0 then 0 else ");
                sqlbuff.append("TO_DECIMAL(Round(to_decimal(sum(FBeginDiffCost)*100,17,4)/sum(FBeginStandardCost),2),17,2) end) as FBeginDiffRate,\r\n");
                sqlbuff.append("sum(FInQty) as FInQty,");
                sqlbuff.append("(case sum(FInQty) when 0 then 0 else ");
                sqlbuff.append("TO_DECIMAL(to_decimal(sum(FInStandardCost),17,4)/sum(FInQty),17,6) end) as FInPrice,");
                sqlbuff.append("sum(FInStandardCost) as FInStandardCost,sum(FInActualCost) as FInActualCost,");
                sqlbuff.append("sum(FInActualCost)-sum(FInStandardCost) as FInDiffCost,");
                sqlbuff.append("(case sum(FInStandardCost) when 0 then 0 else ");
                sqlbuff.append("TO_DECIMAL(Round(to_decimal((sum(FInActualCost)-sum(FInStandardCost))*100,17,4)/sum(FInStandardCost),2),17,2) end) as FInDiffRate,\r\n");
                sqlbuff.append("sum(FOutQty) as FOutQty,");
                sqlbuff.append("(case sum(FOutQty) when 0 then 0 else ");
                sqlbuff.append("TO_DECIMAL(to_decimal(sum(FOutStandardCost),17,4)/sum(FOutQty),17,6) end) as FOutPrice,");
                sqlbuff.append("sum(FOutStandardCost) as FOutStandardCost,sum(FOutActualCost) as FOutActualCost,");
                sqlbuff.append("sum(FOutActualCost)-sum(FOutStandardCost) as FOutDiffCost,");
                sqlbuff.append("(case sum(FOutStandardCost) when 0 then 0 else ");
                sqlbuff.append("TO_DECIMAL(Round(to_decimal((sum(FOutActualCost)-sum(FOutStandardCost))*100,17,4)/sum(FOutStandardCost),2),17,2) end) as FOutDiffRate,\r\n");
                sqlbuff.append("sum(FBeginQty)+sum(FInQty)-sum(FOutQty) as FEndQty,");
                sqlbuff.append("(case (sum(FBeginQty)+sum(FInQty)-sum(FOutQty)) when 0 then 0 else ");
                sqlbuff.append("TO_DECIMAL(to_decimal(sum(FBeginStandardCost)+sum(FInStandardCost)-sum(FOutStandardCost),17,4)/((sum(FBeginQty)+sum(FInQty)-sum(FOutQty))),17,6) end) as FEndPrice,\r\n");
                sqlbuff.append("(sum(FBeginStandardCost)+sum(FInStandardCost)-sum(FOutStandardCost)) as FEndStandardCost,");
                sqlbuff.append("(sum(FBeginActualCost)+sum(FInActualCost)-sum(FOutActualCost)) as FEndActualCost,");
                sqlbuff.append("(sum(FBeginDiffCost)+(sum(FInActualCost)-sum(FInStandardCost))-(sum(FOutActualCost)-sum(FOutStandardCost))) as FEndDiffCost,");
                sqlbuff.append("(case (sum(FBeginStandardCost)+sum(FInStandardCost)-sum(FOutStandardCost)) when 0 then 0 else ");
                sqlbuff.append("TO_DECIMAL(Round(to_decimal((sum(FBeginDiffCost)+(sum(FInActualCost)-sum(FInStandardCost))-(sum(FOutActualCost)-sum(FOutStandardCost)))*100,17,4)/(sum(FBeginStandardCost)+sum(FInStandardCost)-sum(FOutStandardCost)),2),17,2) end) as FEndDiffRate,");
                sqlbuff.append("max(FMatQtyPrecision),max(FPricePrecision),max(FAmountPrecision) ");
                for (j = 1; j <= i; ++j) {
                    sqlbuff.append(",FMATERIALGROUPID" + j + ",FMATERIALGROUPNAME" + j);
                }
                sqlbuff.append("||'").append(SCMUtils.getResource((String)res, (String)"TOTAL", (Context)ctx));
                sqlbuff.append("' From " + tmpTable + "\r\n");
                sqlbuff.append("Where FIndex=0 \r\n");
                sqlbuff.append(" and length(FMATERIALGROUPNAME").append(i).append(")>0 ");
                sqlbuff.append("Group By FCompanyOrgUnitID,FCompanyOrg,FYear,FPeriodNumber \r\n");
                for (j = 1; j <= i; ++j) {
                    sqlbuff.append(",FMATERIALGROUPID" + j + ",FMATERIALGROUPNAME" + j);
                }
                DbUtil.execute((Context)ctx, (String)sqlbuff.toString());
            }
        }
        if (CostDiffGatherGistEnum.MATERIALTYPE.equals((Object)sumType)) {
            StringBuffer matLevelSelect = new StringBuffer();
            for (i = 1; i <= materialGroupLevel; ++i) {
                matLevelSelect.append("FMATERIALGROUPNAME" + i + " ,");
            }
            sql3 = "select FCompanyOrg,Fyear,FPeriodNumber," + matLevelSelect.toString() + "FSumTypeName2,\r\n" + this.getQueryDetail(filter) + " as FMaterialID \r\n,FMatNumber,FMatName,FShortName,FMatModel,FMatUnitName,FBeginQty,FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,\r\nconcat(TO_CHAR(FBeginDiffRate,'NUMBER',2),'%') as FBeginDiffRate,FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,\r\nconcat(TO_CHAR(FInDiffRate,'NUMBER',2),'%') as FInDiffRate,FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,concat(TO_CHAR(FOutDiffRate,'NUMBER',2),'%') as FOutDiffRate,FEndQty,FEndPrice,\r\nFEndStandardCost,FEndActualCost,FEndDiffCost,concat(TO_CHAR(FEndDiffRate,'NUMBER',2),'%') as FEndDiffRate,FMatQtyPrecision,FPricePrecision,FAmountPrecision,FSumTypeID  from " + tmpTable;
            if (filter.getBoolean("onlyViewSumRow")) {
                sql3 = sql3 + " Where Findex<>0 ";
            }
            StringBuffer matLevelGroup = new StringBuffer();
            for (int i3 = 1; i3 <= materialGroupLevel; ++i3) {
                matLevelGroup.append(",FMATERIALGROUPID" + i3 + ",FMATERIALGROUPNAME" + i3);
            }
            sql3 = sql3 + "  Order By isnull(FYear,2099) ,isnull(FPeriodNumber,99)" + matLevelGroup + ",FIndex,FMatNumber";
        } else {
            sql3 = "select FCompanyOrg,Fyear,FPeriodNumber,FSumTypeName,FSumTypeName2,\r\n" + this.getQueryDetail(filter) + " as FMaterialID \r\n,FMatNumber,FMatName,FShortName,FMatModel,FMatUnitName,FBeginQty,FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,\r\nconcat(TO_CHAR(FBeginDiffRate,'NUMBER',2),'%') as FBeginDiffRate,FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,concat(TO_CHAR(FInDiffRate,'NUMBER',2),'%') as FInDiffRate,FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,concat(TO_CHAR(FOutDiffRate,'NUMBER',2),'%') as FOutDiffRate,FEndQty,FEndPrice,FEndStandardCost,FEndActualCost,FEndDiffCost,concat(TO_CHAR(FEndDiffRate,'NUMBER',2),'%') as FEndDiffRate,FMatQtyPrecision,FPricePrecision,FAmountPrecision,FSumTypeID  from " + tmpTable;
            if (filter.getBoolean("onlyViewSumRow")) {
                sql3 = sql3 + " Where Findex<>0 ";
            }
            sql3 = sql3 + "  Order By isnull(FYear,2099) ,isnull(FPeriodNumber,99),FSumTypeid,FSumTypeName,FIndex,FMatNumber";
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql3.toString());
        return rs;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int materialGroupLevel = Integer.parseInt(filter.getObject("materialGroupLevel").toString());
        ReportHeader header = super.getReportHeader(reportID, filter);
        ArrayList headerList = header.getChilds();
        int headSize = headerList.size();
        for (int i = 0; i < headSize; ++i) {
            CostDiffGatherGistEnum gatherGist;
            ReportHeader headerItem = (ReportHeader)headerList.get(i);
            if (headerItem.getFieldName().equals("FMaterialID")) {
                headerItem.setVisible(false);
            }
            if (headerItem.getFieldName().equals("FSumTypeID")) {
                headerItem.setVisible(false);
            }
            if (headerItem.getFieldName().equals("FShortName") && !filter.getBoolean("ckBxMShortName")) {
                headerList.remove(i);
                --i;
                --headSize;
            }
            if ((headerItem.getFieldName().equals("FBegin") || headerItem.getFieldName().equals("FInput") || headerItem.getFieldName().equals("FOutput") || headerItem.getFieldName().equals("FEnd")) && !filter.getBoolean("ckDiffRate")) {
                headerItem.getChilds().remove(5);
            }
            Context ctx = this.getContext();
            if (!headerItem.getFieldName().equals("FSumTypeName")) continue;
            ReportHeader headerItem2 = (ReportHeader)headerList.get(i + 1);
            if (headerItem2.getFieldName().equals("FSumTypeName2")) {
                headerList.remove(i + 1);
                --headSize;
            }
            if ((gatherGist = (CostDiffGatherGistEnum)((Object)filter.getObject("sumType"))).equals((Object)CostDiffGatherGistEnum.CALCULATETYPE)) {
                headerItem.setCaption(SCMUtils.getResource((String)res, (String)"CalculateType", (Context)ctx));
            }
            if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKORGUNIT)) {
                headerItem.setCaption(SCMUtils.getResource((String)res, (String)"STORAGEORG", (Context)ctx));
            }
            if (gatherGist.equals((Object)CostDiffGatherGistEnum.STORAGE)) {
                headerItem.setCaption(SCMUtils.getResource((String)res, (String)"WAREHOUSENAME", (Context)ctx));
            }
            if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASS)) {
                headerItem.setCaption(SCMUtils.getResource((String)res, (String)"KAClassfication", (Context)ctx));
            }
            if (gatherGist.equals((Object)CostDiffGatherGistEnum.MATERIALTYPE)) {
                headerList.remove(i);
                for (int j = 1; j <= materialGroupLevel; ++j) {
                    ReportHeader materLevHead = new ReportHeader();
                    materLevHead.setCaption(j + SCMUtils.getResource((String)res, (String)"MATERIALGROUPLEVEL", (Context)ctx));
                    materLevHead.setFieldName("FMATERIALGROUPNAME" + j);
                    materLevHead.setLevel(1);
                    materLevHead.setMergeable(true);
                    materLevHead.setWidth(100);
                    materLevHead.setVisible(true);
                    materLevHead.setType(1);
                    headerList.add(i + j - 1, materLevHead);
                }
                headSize += materialGroupLevel - 1;
            }
            if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKANDKACLASS)) {
                headerItem.setCaption(SCMUtils.getResource((String)res, (String)"STORAGEORG", (Context)ctx));
                headerItem2.setCaption(SCMUtils.getResource((String)res, (String)"KAClassfication", (Context)ctx));
                headerList.add(i + 1, headerItem2);
                ++headSize;
            }
            if (!gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASSANDSTOCK)) continue;
            headerItem.setCaption(SCMUtils.getResource((String)res, (String)"KAClassfication", (Context)ctx));
            headerItem2.setCaption(SCMUtils.getResource((String)res, (String)"STORAGEORG", (Context)ctx));
            headerList.add(i + 1, headerItem2);
            ++headSize;
        }
        return header;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        return new ReportTitles();
    }

    public IRowSet getHiberarchyData(String reportID, RptParams filter, HashMap rowData) throws BaseException {
        return null;
    }

    private String getQueryDetail(RptParams filter) {
        StringBuffer filterString = new StringBuffer("(case findex when 0 then concat('");
        filterString.append(filter.getObject("yearFrom").toString());
        filterString.append("," + filter.getObject("periodFrom").toString());
        filterString.append("," + filter.getObject("yearTo").toString());
        filterString.append("," + filter.getObject("periodTo").toString());
        filterString.append("," + this.fiOrgUnitID);
        filterString.append("," + ((BillBaseStatusEnum)filter.getObject("cmbStatus")).getValue());
        filterString.append("," + filter.getBoolean("ckBxMShortName"));
        filterString.append("," + ((VoucheredEnum)((Object)filter.getObject("voucher"))).getValue());
        filterString.append("," + filter.getBoolean("ckShowNoCalculate"));
        filterString.append("," + filter.getBoolean("noInOrOutNoShow"));
        filterString.append(",',FMaterialID) else '' end)");
        return filterString.toString();
    }

    private String getPeriodHappen(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        CostDiffGatherGistEnum gatherGist = (CostDiffGatherGistEnum)((Object)params.getObject("sumType"));
        StringBuffer sqlAll = new StringBuffer();
        sqlAll.append("insert into " + tempTable);
        sqlAll.append("(\r\n FINDEX,FCompanyOrgUnitID,FCompanyOrg,FYear,FPeriodNumber,FMaterialID ,FMatName ,FMatNumber ,");
        sqlAll.append("FSHORTNAME,FMatModel,FMatUnitName,FSUMTYPEID ,FSUMTYPENAME ,FSUMTYPENAME2,");
        sqlAll.append("FBeginQty,FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate,");
        sqlAll.append("FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,FInDiffRate,");
        sqlAll.append("FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,FOutDiffRate,");
        sqlAll.append("FEndQty,FEndPrice,FEndStandardCost,FEndActualCost,FEndDiffCost,FEndDiffRate,FMatQtyPrecision,FPricePrecision,FAmountPrecision ) \r\n");
        sqlAll.append("Select 0 as FIndex,FCompanyOrgUnitID,FCompanyName,");
        sqlAll.append("FYear,FPeriod,FMaterialID,FMaterialName,");
        sqlAll.append("FMaterialNumber,FSHORTNAME,FMaterialModel,FBaseUnitName,FSumTypeID,FSumTypeName,FSUMTYPENAME2, \r\n");
        sqlAll.append("sum(FBeginQty) as FBeginQty,");
        sqlAll.append("(case sum(FBeginQty) when 0 then 0 else ");
        sqlAll.append("TO_DECIMAL(to_decimal(sum(FBeginStandardCost),17,4)/sum(FBeginQty),17,6) end) as FBeginPrice,");
        sqlAll.append("sum(FBeginStandardCost) as FBeginStandardCost,sum(FBeginActualCost) as FBeginActualCost,");
        sqlAll.append("sum(FBeginCostDiff) as FBeginDiffCost,");
        sqlAll.append("(case sum(FBeginStandardCost) when 0 then 0 else ");
        sqlAll.append("TO_DECIMAL(Round(to_decimal(sum(FBeginCostDiff)*100,17,4)/sum(FBeginStandardCost),2),17,2) end) as FBeginDiffRate,\r\n");
        sqlAll.append("sum(FInQty) as FInQty,");
        sqlAll.append("(case sum(FInQty) when 0 then 0 else ");
        sqlAll.append("TO_DECIMAL(to_decimal(sum(FInStandardCost),17,4)/sum(FInQty),17,6) end) as FInPrice,");
        sqlAll.append("sum(FInStandardCost) as FInStandardCost,sum(FInActualCost) as FInActualCost,");
        sqlAll.append("sum(FInActualCost)-sum(FInStandardCost) as FInDiffCost,");
        sqlAll.append("(case sum(FInStandardCost) when 0 then 0 else ");
        sqlAll.append("TO_DECIMAL(Round(to_decimal((sum(FInActualCost)-sum(FInStandardCost))*100,18,4)/sum(FInStandardCost),2),17,2) end) as FInDiffRate,\r\n");
        sqlAll.append("sum(FOutQty) as FOutQty,");
        sqlAll.append("(case sum(FOutQty) when 0 then 0 else ");
        sqlAll.append("TO_DECIMAL(to_decimal(sum(FOutStandardCost),17,4)/sum(FOutQty),17,6) end) as FOutPrice,");
        sqlAll.append("sum(FOutStandardCost) as FOutStandardCost,sum(FOutActualCost) as FOutActualCost,");
        sqlAll.append("sum(FOutActualCost)-sum(FOutStandardCost) as FOutDiffCost,");
        sqlAll.append("(case sum(FOutStandardCost) when 0 then 0 else ");
        sqlAll.append("TO_DECIMAL(Round(to_decimal((sum(FOutActualCost)-sum(FOutStandardCost))*100,17,4)/sum(FOutStandardCost),2),17,2) end) as FOutDiffRate,\r\n");
        sqlAll.append("sum(FBeginQty)+sum(FInQty)-sum(FOutQty) as FEndQty,");
        sqlAll.append("(case (sum(FBeginQty)+sum(FInQty)-sum(FOutQty)) when 0 then 0 else ");
        sqlAll.append("TO_DECIMAL(to_decimal((sum(FBeginStandardCost)+sum(FInStandardCost)-sum(FOutStandardCost)),17,4)/(sum(FBeginQty)+sum(FInQty)-sum(FOutQty)),17,6) end) as FEndPrice,\r\n");
        sqlAll.append("(sum(FBeginStandardCost)+sum(FInStandardCost)-sum(FOutStandardCost)) as FEndStandardCost,");
        sqlAll.append("(sum(FBeginActualCost)+sum(FInActualCost)-sum(FOutActualCost)) as FEndActualCost,");
        sqlAll.append("(sum(FBeginCostDiff)+(sum(FInActualCost)-sum(FInStandardCost))-(sum(FOutActualCost)-sum(FOutStandardCost))) as FEndDiffCost,");
        sqlAll.append("(case (sum(FBeginStandardCost)+sum(FInStandardCost)-sum(FOutStandardCost)) when 0 then 0 else ");
        sqlAll.append("TO_DECIMAL(Round(to_decimal((sum(FBeginCostDiff)+(sum(FInActualCost)-sum(FInStandardCost))-(sum(FOutActualCost)-sum(FOutStandardCost)))*100,18,4)/(sum(FBeginStandardCost)+sum(FInStandardCost)-sum(FOutStandardCost)),2),17,2) end) as FEndDiffRate,");
        sqlAll.append("FMatQtyPrecision,FPricePrecision,FAmountPrecision ");
        sqlAll.append("From ( \r\n");
        String sql = "";
        sql = this.getSelect(gatherGist) + this.getInSumSql();
        sql = sql + this.sqlFrom(ctx, "T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry", 0);
        sql = sql + this.getWhere(params, false) + this.getGroup(gatherGist);
        sqlAll.append(sql + "\r\n UNION All  \r\n");
        sql = this.getSelect(gatherGist) + this.getInSumSql();
        sql = sql + this.sqlFrom(ctx, "T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry", 0);
        sql = sql + this.getWhere(params, false) + this.getGroup(gatherGist);
        sqlAll.append(sql + "\r\n UNION All  \r\n");
        sql = this.getSelect(gatherGist) + this.getInSumSql();
        boolean noSelectStorageMoveBill = params.getBoolean("noSelectStorageMoveBill");
        boolean noSelectWarehouseMoveBill = params.getBoolean("noSelectWarehouseMoveBill");
        sql = sql + this.sqlFrom(ctx, "T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry", 0);
        sql = sql + this.getWhere(params, false);
        if (noSelectStorageMoveBill) {
            sql = sql + "and h.FBizTypeID <>'d8e80652-011a-1000-e000-04c5c0a812202407435C' ";
        }
        if (noSelectWarehouseMoveBill) {
            sql = sql + "and h.FBizTypeID <>'d8e80652-011b-1000-e000-04c5c0a812202407435C' ";
        }
        sql = sql + this.getGroup(gatherGist);
        sqlAll.append(sql + "\r\n UNION All  \r\n");
        sql = this.getSelect(gatherGist) + this.getInSumSql();
        sql = sql + this.sqlFrom(ctx, "T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry", 0);
        sql = sql + this.getWhere(params, false) + this.getGroup(gatherGist);
        sqlAll.append(sql + "\r\n UNION All  \r\n");
        sql = this.getSelect(gatherGist) + this.getOutSumSql();
        sql = sql + this.sqlFrom(ctx, "T_IM_SaleIssueBill", "T_IM_SaleIssueEntry", 1);
        sql = sql + this.getWhere(params, false) + this.getGroup(gatherGist);
        sqlAll.append(sql + "\r\n UNION All  \r\n");
        sql = this.getSelect(gatherGist) + this.getOutSumSql();
        sql = sql + this.sqlFrom(ctx, "T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry", 1);
        sql = sql + this.getWhere(params, false) + this.getGroup(gatherGist);
        sqlAll.append(sql + "\r\n UNION All  \r\n");
        StringBuffer sqlAll1 = new StringBuffer();
        sql = this.getSelect(gatherGist) + this.getOutSumSql();
        sql = sql + this.sqlFrom(ctx, "T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry", 1);
        sql = sql + this.getWhere(params, false);
        if (noSelectStorageMoveBill) {
            sql = sql + "and h.FBizTypeID <>'d8e80652-011a-1000-e000-04c5c0a812202407435C' ";
        }
        if (noSelectWarehouseMoveBill) {
            sql = sql + "and h.FBizTypeID <>'d8e80652-011b-1000-e000-04c5c0a812202407435C' ";
        }
        sql = sql + this.getGroup(gatherGist);
        sqlAll1.append(sql + "\r\n UNION All  \r\n");
        sql = this.getSelect(gatherGist) + this.getOutSumSql();
        sql = sql + this.sqlFrom(ctx, "T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry", 1);
        sql = sql + this.getWhere(params, false) + this.getGroup(gatherGist);
        sqlAll1.append(sql + "\r\n UNION All  \r\n");
        sql = this.getSelect(gatherGist) + this.getInOutSumSql();
        sql = sql + this.sqlFrom(ctx, "T_CL_CostAdjustBill", "T_CL_CostAdjustBillEntry", 2);
        sql = sql + this.getWhere(params, true) + this.getGroup(gatherGist) + ",h.FCalculateKind";
        sqlAll1.append(sql + "\r\n UNION All  \r\n");
        sql = this.GetStdAdjBillSQL(ctx, tempTable, params);
        sqlAll1.append(sql);
        sqlAll1.append("\r\n UNION All  \r\n");
        sql = this.getStockSQL(ctx, tempTable, params);
        sqlAll1.append(sql + " \r\n");
        sqlAll1.append(") T Group by FCompanyOrgUnitID,FCompanyName,");
        sqlAll1.append("FYear,FPeriod,FMaterialID,FMaterialName,");
        sqlAll1.append("FMaterialNumber,FSHORTNAME,FMaterialModel,");
        sqlAll1.append("FBaseUnitName,FSumTypeID,FSumTypeName,FSUMTYPENAME2,FMatQtyPrecision,FPricePrecision,FAmountPrecision");
        return sqlAll.toString() + sqlAll1.toString();
    }

    private String getPeriodHappenTotal(Context ctx, String tempTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable);
        sql.append("(\r\n FINDEX,FCompanyOrgUnitID,FCompanyOrg,FYear,FPeriodNumber,FMaterialID ,FMatName ,FMatNumber ,");
        sql.append("FSHORTNAME,FMatModel,FMatUnitName,FSUMTYPEID ,FSUMTYPENAME ,");
        sql.append("FBeginQty,FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate,");
        sql.append("FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,FInDiffRate,");
        sql.append("FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,FOutDiffRate,");
        sql.append("FEndQty,FEndPrice,FEndStandardCost,FEndActualCost,FEndDiffCost,FEndDiffRate,FMatQtyPrecision,FPricePrecision,FAmountPrecision ) \r\n");
        sql.append("Select 1,null,FCompanyOrg,FYear,FPeriodNumber,null,null,null,null,null,null,FSUMTYPEID,FSumTypeName || '" + SCMUtils.getResource((String)res, (String)"TOTAL", (Context)ctx) + "',");
        sql.append("sum(FBeginQty),case sum(FBeginQty) when 0 then 0 else TO_DECIMAL(to_decimal(sum(FBeginStandardCost),17,4)/sum(FBeginQty),21,8) END,sum(FBeginStandardCost),");
        sql.append("sum(FBeginActualCost),(sum(FBeginActualCost)-sum(FBeginStandardCost)) as FBeginDiffCost,");
        sql.append("case sum(FBeginStandardCost) when 0 then 0 else TO_DECIMAL(Round(to_decimal((sum(FBeginActualCost)-sum(FBeginStandardCost))*100,17,4)/sum(FBeginStandardCost),2),17,2) END,");
        sql.append("sum(FInQty),case sum(FInQty) when 0 then 0 else TO_DECIMAL(to_decimal(sum(FInStandardCost),17,4)/sum(FInQty),21,8) END,sum(FInStandardCost),");
        sql.append("sum(FInActualCost),(sum(FInActualCost)-sum(FInStandardCost)) as FInDiffCost,");
        sql.append("case sum(FInStandardCost) when 0 then 0 else TO_DECIMAL(Round(to_decimal((sum(FInActualCost)-sum(FInStandardCost))*100,18,4)/sum(FInStandardCost),2),17,2) END,");
        sql.append("sum(FOutQty),case sum(FOutQty) when 0 then 0 else TO_DECIMAL(to_decimal(sum(FOutStandardCost),17,4)/sum(FOutQty),21,8) END,sum(FOutStandardCost),");
        sql.append("sum(FOutActualCost),(sum(FOutActualCost)-sum(FOutStandardCost)) as FOutDiffCost,");
        sql.append("case sum(FOutStandardCost) when 0 then 0 else TO_DECIMAL(Round(to_decimal((sum(FOutActualCost)-sum(FOutStandardCost))*100,18,4)/sum(FOutStandardCost),2),17,2) END,");
        sql.append("sum(FEndQty),case sum(FEndQty) when 0 then 0 else TO_DECIMAL(to_decimal(sum(FEndStandardCost),17,4)/sum(FEndQty),21,8) END,sum(FEndStandardCost),");
        sql.append("sum(FEndActualCost),(sum(FEndActualCost)-sum(FEndStandardCost)) as FEndDiffCost,");
        sql.append("case sum(FEndStandardCost) when 0 then 0 else TO_DECIMAL(Round(to_decimal((sum(FEndActualCost)-sum(FEndStandardCost))*100,18,4)/sum(FEndStandardCost),2),17,2) END,");
        sql.append("max(FMatQtyPrecision),max(FPricePrecision),max(FAmountPrecision) ");
        sql.append("From " + tempTable + " \r\n");
        sql.append("Group By FCompanyOrg,FYear,FPeriodNumber,FSUMTYPEID,FSumTypeName");
        return sql.toString();
    }

    private void insertSecondTotal(Context ctx, String tempTable, RptParams params) throws BOSException {
        CostDiffGatherGistEnum gatherGist = (CostDiffGatherGistEnum)((Object)params.getObject("sumType"));
        if (CostDiffGatherGistEnum.STOCKANDKACLASS.equals((Object)gatherGist) || CostDiffGatherGistEnum.KACLASSANDSTOCK.equals((Object)gatherGist)) {
            StringBuffer sql = new StringBuffer();
            sql.append("Insert Into " + tempTable);
            sql.append("(\r\n FINDEX,FCompanyOrgUnitID,FCompanyOrg,FYear,FPeriodNumber,FMaterialID ,FMatName ,FMatNumber ,");
            sql.append("FSHORTNAME,FMatModel,FMatUnitName,FSUMTYPEID ,FSUMTYPENAME ,FSUMTYPENAME2,");
            sql.append("FBeginQty,FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate,");
            sql.append("FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,FInDiffRate,");
            sql.append("FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,FOutDiffRate,");
            sql.append("FEndQty,FEndPrice,FEndStandardCost,FEndActualCost,FEndDiffCost,FEndDiffRate,FMatQtyPrecision,FPricePrecision,FAmountPrecision ) \r\n");
            sql.append("Select 1,null,FCompanyOrg,FYear,FPeriodNumber,null,null,null,null,null,null,FSUMTYPEID,FSumTypeName ,FSUMTYPENAME2 || '" + SCMUtils.getResource((String)res, (String)"TOTAL", (Context)ctx) + "',");
            sql.append("sum(FBeginQty),case sum(FBeginQty) when 0 then 0 else TO_DECIMAL(to_decimal(sum(FBeginStandardCost),18,4)/sum(FBeginQty),21,8) END,sum(FBeginStandardCost),");
            sql.append("sum(FBeginActualCost),(sum(FBeginActualCost)-sum(FBeginStandardCost)) as FBeginDiffCost,");
            sql.append("case sum(FBeginStandardCost) when 0 then 0 else TO_DECIMAL(Round(to_decimal((sum(FBeginActualCost)-sum(FBeginStandardCost))*100,18,4)/sum(FBeginStandardCost),2),17,2) END,");
            sql.append("sum(FInQty),case sum(FInQty) when 0 then 0 else TO_DECIMAL(to_decimal(sum(FInStandardCost),18,4)/sum(FInQty),21,8) END,sum(FInStandardCost),");
            sql.append("sum(FInActualCost),(sum(FInActualCost)-sum(FInStandardCost)) as FInDiffCost,");
            sql.append("case sum(FInStandardCost) when 0 then 0 else TO_DECIMAL(Round(to_decimal((sum(FInActualCost)-sum(FInStandardCost))*100,18,4)/sum(FInStandardCost),2),17,2) END,");
            sql.append("sum(FOutQty),case sum(FOutQty) when 0 then 0 else TO_DECIMAL(to_decimal(sum(FOutStandardCost),18,4)/sum(FOutQty),21,8) END,sum(FOutStandardCost),");
            sql.append("sum(FOutActualCost),(sum(FOutActualCost)-sum(FOutStandardCost)) as FOutDiffCost,");
            sql.append("case sum(FOutStandardCost) when 0 then 0 else TO_DECIMAL(Round(to_decimal((sum(FOutActualCost)-sum(FOutStandardCost))*100,18,4)/sum(FOutStandardCost),2),17,2) END,");
            sql.append("sum(FEndQty),case sum(FEndQty) when 0 then 0 else TO_DECIMAL(to_decimal(sum(FEndStandardCost),18,4)/sum(FEndQty),21,8) END,sum(FEndStandardCost),");
            sql.append("sum(FEndActualCost),(sum(FEndActualCost)-sum(FEndStandardCost)) as FEndDiffCost,");
            sql.append("case sum(FEndStandardCost) when 0 then 0 else TO_DECIMAL(Round(to_decimal((sum(FEndActualCost)-sum(FEndStandardCost))*100,18,4)/sum(FEndStandardCost),2),17,2) END,");
            sql.append("max(FMatQtyPrecision),max(FPricePrecision),max(FAmountPrecision) ");
            sql.append("From " + tempTable + " \r\n");
            sql.append("where FINDEX=0 \r\n");
            sql.append("Group By FCompanyOrg,FYear,FPeriodNumber,FSUMTYPEID,FSumTypeName,FSUMTYPENAME2");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private String createTempTable(RptParams params) throws Exception {
        StringBuffer sql = new StringBuffer();
        CostDiffGatherGistEnum gatherGist = null;
        if (params.getObject("sumType") != null) {
            gatherGist = (CostDiffGatherGistEnum)((Object)params.getObject("sumType"));
        }
        sql.append("Create Table tmp_CostDiffGatherReport \r\n");
        sql.append("(FINDEX Int NOT NULL , \r\n");
        sql.append("FCompanyOrgUnitID Varchar(44), \r\n");
        sql.append("FCompanyOrg NVarchar(1000), \r\n");
        sql.append("FYear Int, \r\n");
        sql.append("FPeriodNumber Int, \r\n");
        sql.append("FMaterialID Varchar(44), \r\n");
        sql.append("FMatNumber NVarchar(500),\r\n");
        sql.append("FMatName NVarchar(1000),\r\n");
        sql.append("FShortName NVarchar(1000),\r\n");
        sql.append("FMatModel NVarchar(500),\r\n");
        sql.append("FMatUnitName NVarchar(500),\r\n");
        if (gatherGist != null) {
            if (gatherGist.equals((Object)CostDiffGatherGistEnum.CALCULATETYPE)) {
                sql.append("FSumTypeID int, \r\n");
            }
            if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKORGUNIT)) {
                sql.append("FSumTypeID Varchar(44), \r\n");
            }
            if (gatherGist.equals((Object)CostDiffGatherGistEnum.STORAGE)) {
                sql.append("FSumTypeID Varchar(44), \r\n");
            }
            if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASS)) {
                sql.append("FSumTypeID Varchar(44), \r\n");
            }
            if (gatherGist.equals((Object)CostDiffGatherGistEnum.MATERIALTYPE)) {
                sql.append("FSumTypeID Varchar(44), \r\n");
                int materialGroupLevel = Integer.parseInt(params.getObject("materialGroupLevel").toString());
                for (int i = 1; i <= materialGroupLevel; ++i) {
                    sql.append("FMATERIALGROUPID" + i + " Varchar(500),\r\n");
                    sql.append("FMATERIALGROUPNAME" + i + " Varchar(500),\r\n");
                }
            }
            if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKANDKACLASS)) {
                sql.append("FSumTypeID Varchar(88), \r\n");
            }
            if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASSANDSTOCK)) {
                sql.append("FSumTypeID Varchar(88), \r\n");
            }
        }
        sql.append("FSUMTYPENAME Varchar(500),\r\n");
        sql.append("FSUMTYPENAME2 Varchar(500),\r\n");
        sql.append("FBeginQty NUMERIC(28,16) ,\r\n");
        sql.append("FBeginPrice NUMERIC(21,8) ,\r\n");
        sql.append("FBeginStandardCost NUMERIC(19,4)  ,\r\n");
        sql.append("FBeginActualCost NUMERIC(19,4)  ,\r\n");
        sql.append("FBeginDiffCost NUMERIC(19,4)  ,\r\n");
        sql.append("FBeginDiffRate NUMERIC(19,2)  ,\r\n");
        sql.append("FInQty NUMERIC(28,16) ,\r\n");
        sql.append("FInPrice NUMERIC(21,8) ,\r\n");
        sql.append("FInStandardCost NUMERIC(19,4)  ,\r\n");
        sql.append("FInActualCost NUMERIC(19,4)  ,\r\n");
        sql.append("FInDiffCost NUMERIC(19,4)  ,\r\n");
        sql.append("FInDiffRate NUMERIC(19,2)  ,\r\n");
        sql.append("FOutQty NUMERIC(28,16) ,\r\n");
        sql.append("FOutPrice NUMERIC(21,8) ,\r\n");
        sql.append("FOutStandardCost NUMERIC(19,4)  ,\r\n");
        sql.append("FOutActualCost NUMERIC(19,4)  ,\r\n");
        sql.append("FOutDiffCost NUMERIC(19,4)  ,\r\n");
        sql.append("FOutDiffRate NUMERIC(19,2)  ,\r\n");
        sql.append("FEndQty NUMERIC(28,16) ,\r\n");
        sql.append("FEndPrice NUMERIC(21,8) ,\r\n");
        sql.append("FEndStandardCost NUMERIC(19,4)  ,\r\n");
        sql.append("FEndActualCost NUMERIC(19,4)  ,\r\n");
        sql.append("FEndDiffCost NUMERIC(19,4)  ,\r\n");
        sql.append("FEndDiffRate NUMERIC(19,2) ,\r\n");
        sql.append("FMatQtyPrecision Int, \r\n");
        sql.append("FPricePrecision Int, \r\n");
        sql.append("FAmountPrecision Int   ); \r\n");
        String sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(sql.toString());
        super.setTablename(sTmpTblName);
        return sTmpTblName;
    }

    private String getSelect(CostDiffGatherGistEnum gatherGist) throws BOSException {
        Context ctx = this.getContext();
        String loc = this.getLoc(ctx);
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("SELECT 0 as FIndex, ");
        sqlSelect.append("d.FCompanyOrgUnitID as FCompanyOrgUnitID, ");
        sqlSelect.append("fi.FName_" + loc + " as FCompanyName, ");
        sqlSelect.append("h.FYear as FYear, ");
        sqlSelect.append("h.FPeriod as FPeriod, ");
        sqlSelect.append("d.FMaterialID as FMaterialID, ");
        sqlSelect.append("m.FName_" + loc + " as FMaterialName, ");
        sqlSelect.append("m.FNumber as FMaterialNumber, ");
        sqlSelect.append("m.FSHORTNAME as FSHORTNAME, ");
        sqlSelect.append("m.FModel as FMaterialModel, ");
        sqlSelect.append("m.FPricePrecision as FPricePrecision, ");
        sqlSelect.append("mu.FName_" + loc + " as FBaseUnitName, ");
        sqlSelect.append("mmu.fqtyprecision as FMatQtyPrecision, ");
        sqlSelect.append("cr.FPrecision as FAmountPrecision, ");
        if (gatherGist.equals((Object)CostDiffGatherGistEnum.CALCULATETYPE)) {
            sqlSelect.append("mcom.FCalculateType as FSumTypeID,");
            sqlSelect.append("(case when mcom.FCalculateType=0 then '" + SCMUtils.getResource((String)res, (String)"PURCHASE", (Context)ctx) + "' else (case when mcom.FCalculateType=1 then '" + SCMUtils.getResource((String)res, (String)"CONSIGN", (Context)ctx) + "' else (case when mcom.FCalculateType=2 then '" + SCMUtils.getResource((String)res, (String)"MAKE", (Context)ctx) + "' else ' ' end) end) end) as FSumTypeName, ");
            sqlSelect.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKORGUNIT)) {
            sqlSelect.append("d.FStorageOrgUnitID as FSumTypeID, ");
            sqlSelect.append("so.FName_" + loc + " as FSumTypeName, ");
            sqlSelect.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STORAGE)) {
            sqlSelect.append("d.FWarehouseID as FSumTypeID, ");
            sqlSelect.append("wh.FName_" + loc + " as FSumTypeName, ");
            sqlSelect.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASS)) {
            sqlSelect.append("mcom.FKAClassID as FSumTypeID,");
            sqlSelect.append("ka.FName_" + loc + " as FSumTypeName, ");
            sqlSelect.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.MATERIALTYPE)) {
            sqlSelect.append("'1' as FSumTypeID,");
            sqlSelect.append("'2' as FSumTypeName, ");
            sqlSelect.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKANDKACLASS)) {
            sqlSelect.append("concat(concat(d.FStorageOrgUnitID,'--'),mcom.FKAClassID) as FSumTypeID, ");
            sqlSelect.append("so.FName_" + loc + " as FSumTypeName, ");
            sqlSelect.append("ka.FName_" + loc + " as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASSANDSTOCK)) {
            sqlSelect.append("concat(concat(mcom.FKAClassID,'--'),d.FStorageOrgUnitID) as FSumTypeID,");
            sqlSelect.append("ka.FName_" + loc + " as FSumTypeName, ");
            sqlSelect.append("so.FName_" + loc + " as FSumTypeName2, ");
        }
        sqlSelect.append("0 as FBeginQty, ");
        sqlSelect.append("0 as FBeginStandardCost,");
        sqlSelect.append("0 as FBeginActualCost,");
        sqlSelect.append("0 as FBeginCostDiff,");
        return sqlSelect.toString();
    }

    private String getWhere(RptParams params, boolean isCostAdj) throws EASBizException, BOSException {
        KAClassficationInfo prmtKAClass;
        String MaterialFrom = null;
        String MaterialTo = null;
        String MaterialIn = null;
        String txtMShortNameFrom = null;
        String txtMShortNameTo = null;
        String kaClassID = null;
        int billStatus = -1;
        int voucher = -1;
        boolean ckShowNoCalculate = params.getBoolean("ckShowNoCalculate");
        boolean ckBxMShortName = params.getBoolean("ckBxMShortName");
        if (params.getObject("company") != null) {
            this.fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    MaterialFrom = ((MaterialInfo)materials[0]).getNumber();
                } else {
                    MaterialIn = CalculateUtil.getObjArrayNumberWithQuote(materials);
                }
            } else {
                MaterialFrom = params.getObject("materialFrom").toString();
            }
        }
        if (params.getObject("materialTo") != null) {
            MaterialTo = params.getObject("materialTo") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialTo")).getNumber() : params.getObject("materialTo").toString();
        }
        if ((prmtKAClass = (KAClassficationInfo)params.getObject("KAClass")) != null) {
            kaClassID = prmtKAClass.getId().toString();
        }
        txtMShortNameFrom = params.getString("txtMShortNameFrom");
        txtMShortNameTo = params.getString("txtMShortNameTo");
        String warehouse = null;
        if (params.getObject("warehouse") != null) {
            warehouse = ((WarehouseInfo)params.getObject("warehouse")).getNumber();
        }
        voucher = ((VoucheredEnum)((Object)params.getObject("voucher"))).getValue();
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append("WHERE ");
        sqlWhere.append(" ( h.FBaseStatus = ").append(2).append("").append(" or").append(" h.FBaseStatus = ").append(4).append(" )");
        sqlWhere.append(" And (h.FIsInitBill = 0 or  h.FIsInitBill is null ) ");
        sqlWhere.append(" and mcom.FAccountType = 2 ");
        if (voucher != -1) {
            sqlWhere.append("And h.ffiVouchered = ").append(voucher).append(" ");
        }
        if (kaClassID != null) {
            sqlWhere.append("And mcom.FKAClassID = '").append(kaClassID).append("' ");
        }
        sqlWhere.append(" And d.FCompanyOrgUnitID = '" + this.fiOrgUnitID + "' ");
        if (params.getObject("cmbStatus") != null) {
            billStatus = ((BillBaseStatusEnum)params.getObject("cmbStatus")).getValue();
            if (billStatus == 2) {
                sqlWhere.append(" AND h.FBaseStatus = " + String.valueOf(billStatus) + " ");
            } else if (billStatus == 4) {
                sqlWhere.append(" AND h.FBaseStatus >= " + String.valueOf(billStatus) + " ");
            }
        }
        String psql = this.getWherePeriodSql(params);
        params.setString("wherePeriodSql", psql);
        sqlWhere.append(" AND (").append(psql).append(") ");
        if (MaterialFrom != null) {
            sqlWhere.append(" AND m.FNumber >= '" + MaterialFrom + "' ");
        }
        if (MaterialTo != null) {
            sqlWhere.append(" AND m.FNumber <= '" + MaterialTo + "' ");
        }
        if (MaterialIn != null) {
            sqlWhere.append(" AND m.FNumber in (" + MaterialIn + ") ");
        }
        if (ckBxMShortName && txtMShortNameFrom != null && txtMShortNameTo != null) {
            if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() > 0 && txtMShortNameTo.trim().length() > 0) {
                sqlWhere.append(" AND M.FShortName >= '" + txtMShortNameFrom + "' AND M.FShortName <= '" + txtMShortNameTo + "' ");
            } else if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() > 0 && txtMShortNameTo.trim().length() <= 0) {
                sqlWhere.append(" AND M.FShortName >= '" + txtMShortNameFrom + "' ");
            } else if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() <= 0 && txtMShortNameTo.trim().length() > 0) {
                sqlWhere.append(" AND M.FShortName <= '" + txtMShortNameTo + "' ");
            }
        }
        if (warehouse != null) {
            sqlWhere.append(" AND wh.FNumber in('" + warehouse + "')");
        }
        sqlWhere.append(" And stype.FIsForwardAmt = 1 ");
        String sqlWhereCostAdj = sqlWhere.toString();
        if (isCostAdj) {
            return sqlWhereCostAdj;
        }
        if (!ckShowNoCalculate) {
            sqlWhere.append(" And tr.FIsCalculate = 1 ");
        }
        return sqlWhere.toString();
    }

    private String getGroup(CostDiffGatherGistEnum gatherGist) throws BOSException {
        Context ctx = this.getContext();
        StringBuffer sqlGroup = new StringBuffer();
        sqlGroup.append("GRoup by d.FCompanyOrgUnitID,fi.FName_" + this.getLoc(ctx) + ",");
        sqlGroup.append("h.FYear,h.FPeriod,");
        sqlGroup.append("d.FMaterialID,m.FName_" + this.getLoc(ctx) + ",");
        sqlGroup.append("m.FNumber,m.FSHORTNAME,m.FModel,m.FPricePrecision,");
        sqlGroup.append("mu.FName_" + this.getLoc(ctx) + ",mmu.FQtyPrecision,cr.FPrecision,");
        sqlGroup.append("mcom.FAccountType");
        if (gatherGist.equals((Object)CostDiffGatherGistEnum.CALCULATETYPE)) {
            sqlGroup.append(",mcom.FCalculateType ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKORGUNIT)) {
            sqlGroup.append(",d.FStorageOrgUnitID,");
            sqlGroup.append("so.FName_" + this.getLoc(ctx) + " ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STORAGE)) {
            sqlGroup.append(",d.FWarehouseID,");
            sqlGroup.append("wh.FName_" + this.getLoc(ctx) + " ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASS)) {
            sqlGroup.append(",mcom.FKAClassID,");
            sqlGroup.append("ka.FName_" + this.getLoc(ctx) + " ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKANDKACLASS)) {
            sqlGroup.append(",concat(concat(d.FStorageOrgUnitID,'--'),mcom.FKAClassID), ");
            sqlGroup.append("so.FName_" + this.getLoc(ctx) + ", ");
            sqlGroup.append("ka.FName_" + this.getLoc(ctx) + " ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASSANDSTOCK)) {
            sqlGroup.append(",concat(concat(mcom.FKAClassID,'--'),d.FStorageOrgUnitID),");
            sqlGroup.append("ka.FName_" + this.getLoc(ctx) + " , ");
            sqlGroup.append("so.FName_" + this.getLoc(ctx) + "  ");
        }
        return sqlGroup.toString();
    }

    private String getInSumSql() {
        String sqlIn = "sum(d.FBaseQty) as FInQty,";
        sqlIn = sqlIn + "sum(d.FStandardCost) as FInStandardCost,";
        sqlIn = sqlIn + "sum(d.FActualCost) as FInActualCost,";
        sqlIn = sqlIn + "0 as FOutQty,0 as FOutStandardCost, 0 as FOutActualCost,";
        sqlIn = sqlIn + "0 as FEndQty,0 as FEndStandardCost, 0 as FEndActualCost ";
        return sqlIn;
    }

    private String getOutSumSql() {
        String sqlOut = "0 as FInQty,0 as FInStandardCost, 0 as FInActualCost,";
        sqlOut = sqlOut + "sum(d.FBaseQty) as FOutQty,";
        sqlOut = sqlOut + "sum(d.FStandardCost) as FOutStandardCost,";
        sqlOut = sqlOut + "sum(d.FActualCost) as FOutActualCost,";
        sqlOut = sqlOut + "0 as FEndQty,0 as FEndStandardCost, 0 as FEndActualCost ";
        return sqlOut;
    }

    private String getInOutSumSql() {
        String sqlInOut = "0 as FInQty,";
        sqlInOut = sqlInOut + "0 as FInStandardCost,";
        sqlInOut = sqlInOut + "case h.FCalculateKind when 0 then sum(d.FActualCost) else 0 end as FInActualCost,";
        sqlInOut = sqlInOut + "0 as FOutQty,";
        sqlInOut = sqlInOut + "0 as FOutStandardCost,";
        sqlInOut = sqlInOut + "case h.FCalculateKind when 1 then sum(d.FActualCost) else 0 end as FOutActualCost,";
        sqlInOut = sqlInOut + "0 as FEndQty,0 as FEndStandardCost, 0 as FEndActualCost ";
        return sqlInOut;
    }

    protected String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    private String getWherePeriodSql(RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)params.getObject("company");
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = null;
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext());
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        int beginYear = Integer.parseInt(params.getObject("yearFrom").toString());
        int beginPeriod = Integer.parseInt(params.getObject("periodFrom").toString());
        int endYear = Integer.parseInt(params.getObject("yearTo").toString());
        int endPeriod = Integer.parseInt(params.getObject("periodTo").toString());
        int fromPeriod = beginYear * 100 + beginPeriod;
        int toPeriod = endYear * 100 + endPeriod;
        StringBuffer wherePeriod = new StringBuffer();
        if (fromPeriod == toPeriod) {
            wherePeriod.append("(h.fyear = ").append(beginYear).append(" and h.fperiod = ").append(beginPeriod).append(")");
        } else {
            wherePeriod.append("(h.FYear * 100 + h.FPeriod >=").append(fromPeriod).append(" and h.FYear * 100 + h.FPeriod <=").append(toPeriod).append(")");
        }
        wherePeriod.append(" and p.FISADJUSTPERIOD = 0 ");
        wherePeriod.append(" and p.FTypeID = '" + companyInfo.getAccountPeriodType().getId().toString() + "' ");
        return wherePeriod.toString();
    }

    private String sqlFrom(Context ctx, String headTbale, String entryTable, int billType) {
        StringBuffer sql = new StringBuffer();
        sql.append(" From " + headTbale + " h \r\n");
        sql.append("INNER JOIN " + entryTable + " d ON h.FID = d.FParentID \r\n");
        sql.append("Inner Join T_BD_Material m On d.FMaterialID=m.FID \r\n");
        sql.append("INNER JOIN T_ORG_Company fi ON d.FCompanyOrgUnitID = fi.FID \r\n");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID  AND mcom.FCompanyID = d.FCompanyOrgUnitID \r\n");
        sql.append("Inner Join T_DB_WAREHOUSE wh on d.FWarehouseID = wh.FID \r\n");
        sql.append("Inner Join T_ORG_Storage so on h.FStorageOrgUnitID = so.FID \r\n");
        sql.append("Left Join T_SCM_TransactionType tr on h.FTransactionTypeID = tr.FID \r\n");
        sql.append("Inner Join T_BD_PERIOD p On h.FPERIOD = p.FPERIODNUMBER and h.FYEAR = p.FPERIODYEAR \r\n");
        if (billType == 0) {
            sql.append("Inner Join T_IM_InvUpdateType invupdate on d.FInvUpdateTypeID = invupdate.FID \r\n");
            sql.append("Inner Join T_IM_STORETYPE stype on invupdate.FSTORETYPEID = stype.FID \r\n");
        } else if (billType == 1) {
            sql.append("Inner Join T_IM_InvUpdateType invupdate on d.FInvUpdateTypeID = invupdate.FID \r\n");
            sql.append("Inner Join T_IM_STORETYPE stype on invupdate.FSTORETYPEPREID = stype.FID \r\n");
        } else if (billType == 2) {
            sql.append("Inner Join T_IM_STORETYPE stype on d.FSTORETYPEID = stype.FID \r\n");
        }
        sql.append("INNER JOIN T_BD_MeasureUnit mu ON m.FBaseUnit = mu.FID \r\n");
        sql.append("LEFT JOIN T_BD_KAClassfication ka ON mcom.FKAClassID = ka.FID \r\n");
        sql.append("inner JOIN T_BD_CURRENCY cr ON cr.fid = fi.fbasecurrencyid \r\n");
        sql.append("inner JOIN T_BD_MultiMeasureUnit mmu ON mmu.fmaterialid = m.FID and mmu.fmeasureunitid = mu.fid \r\n");
        return sql.toString();
    }

    private String GetStdAdjBillSQL(Context ctx, String tempTable, RptParams params) throws BOSException {
        KAClassficationInfo prmtKAClass;
        CostDiffGatherGistEnum gatherGist = (CostDiffGatherGistEnum)((Object)params.getObject("sumType"));
        String loc = this.getLoc(ctx);
        String fiOrgUnitID = null;
        fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        String MaterialFrom = null;
        String MaterialIn = null;
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    MaterialFrom = ((MaterialInfo)materials[0]).getNumber();
                } else {
                    MaterialIn = CalculateUtil.getObjArrayNumberWithQuote(materials);
                }
            } else {
                MaterialFrom = params.getObject("materialFrom").toString();
            }
        }
        String MaterialTo = null;
        if (params.getObject("materialTo") != null) {
            MaterialTo = params.getObject("materialTo") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialTo")).getNumber() : params.getObject("materialTo").toString();
        }
        String txtMShortNameFrom = params.getString("txtMShortNameFrom");
        String txtMShortNameTo = params.getString("txtMShortNameTo");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT 0 as FIndex, ");
        sql.append("i.FCompanyOrgUnitID as FCompanyOrgUnitID, ");
        sql.append("fi.FName_" + this.getLoc(ctx) + " as FCompanyName, ");
        sql.append("i.FYear as FYear, ");
        sql.append("i.FPeriod as FPeriod, ");
        sql.append("i.FMaterialID as FMaterialID, ");
        sql.append("m.FName_" + this.getLoc(ctx) + " as FMaterialName, ");
        sql.append("m.FNumber as FMaterialNumber, ");
        sql.append("m.FSHORTNAME as FSHORTNAME, ");
        sql.append("m.FModel as FMaterialModel, ");
        sql.append("m.FPricePrecision as FPricePrecision, ");
        sql.append("mu.FName_" + loc + " as FBaseUnitName, ");
        sql.append("mmu.FQtyPrecision as FMatQtyPrecision, ");
        sql.append("cr.FPrecision as FAmountPrecision, ");
        if (gatherGist.equals((Object)CostDiffGatherGistEnum.CALCULATETYPE)) {
            sql.append("mcom.FCalculateType as FSumTypeID,");
            sql.append("(case when mcom.FCalculateType=0 then '" + SCMUtils.getResource((String)res, (String)"PURCHASE", (Context)ctx) + "' else (case when mcom.FCalculateType=1 then '" + SCMUtils.getResource((String)res, (String)"CONSIGN", (Context)ctx) + "' else (case when mcom.FCalculateType=2 then '" + SCMUtils.getResource((String)res, (String)"MAKE", (Context)ctx) + "' else ' ' end) end) end) as FSumTypeName, ");
            sql.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKORGUNIT)) {
            sql.append("i.FStorageOrgUnitID as FSumTypeID, ");
            sql.append("so.FName_" + loc + " as FSumTypeName, ");
            sql.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STORAGE)) {
            sql.append("i.FWarehouseID as FSumTypeID, ");
            sql.append("wh.FName_" + loc + " as FSumTypeName, ");
            sql.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASS)) {
            sql.append("mcom.FKAClassID as FSumTypeID,");
            sql.append("ka.FName_" + loc + " as FSumTypeName, ");
            sql.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.MATERIALTYPE)) {
            sql.append("'1' as FSumTypeID,");
            sql.append("'2' as FSumTypeName, ");
            sql.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKANDKACLASS)) {
            sql.append("concat(concat(i.FStorageOrgUnitID,'--'),mcom.FKAClassID) as FSumTypeID, ");
            sql.append("so.FName_" + loc + " as FSumTypeName, ");
            sql.append("ka.FName_" + loc + " as FSumTypeName, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASSANDSTOCK)) {
            sql.append("concat(concat(mcom.FKAClassID,'--'),i.FStorageOrgUnitID) as FSumTypeID,");
            sql.append("ka.FName_" + loc + " as FSumTypeName, ");
            sql.append("so.FName_" + loc + " as FSumTypeName, ");
        }
        sql.append("0 as FBeginQty, ");
        sql.append("0 as FBeginStandardCost,");
        sql.append("0 as FBeginActualCost,");
        sql.append("0 as FBeginCostDiff,");
        sql.append("0 as FInQty,sum(1*i.FPeriodAdjustDiff) as FInStandardCost,0 as FInActualCost,");
        sql.append("0 as FOutQty,0 as FOutStandardCost,0 as FOutActualCost,");
        sql.append("0 as FEndQty,0 as FEndStandardCost,0 as FEndActualCost ");
        sql.append("From T_IM_InventoryBalance i \r\n");
        sql.append("INNER Join T_BD_Material m On i.FMaterialID=m.FID \r\n");
        sql.append("INNER JOIN T_ORG_Company fi ON i.FCompanyOrgUnitID = fi.FID \r\n");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On i.FMaterialID = mcom.FMaterialID  AND mcom.FCompanyID = i.FCompanyOrgUnitID \r\n");
        sql.append("INNER Join T_DB_WAREHOUSE wh on i.FWarehouseID = wh.FID \r\n");
        sql.append("INNER Join T_ORG_Storage so on i.FStorageOrgUnitID = so.FID \r\n");
        sql.append("INNER JOIN T_IM_STORETYPE stype on i.FStoreTypeID = stype.fid \r\n");
        sql.append("INNER JOIN T_BD_MeasureUnit mu ON m.FBaseUnit = mu.FID \r\n");
        sql.append("LEFT JOIN T_BD_KAClassfication ka ON mcom.FKAClassID = ka.FID \r\n");
        sql.append("INNER JOIN T_BD_CURRENCY cr ON cr.fid = fi.fbasecurrencyid \r\n");
        sql.append("INNER JOIN t_bd_MultiMeasureUnit mmu ON mmu.fmaterialid = m.FID and mmu.fmeasureunitid = mu.fid \r\n");
        sql.append("INNER JOIN T_BD_PERIOD p On i.FPERIOD = p.FPERIODNUMBER and i.FYEAR = p.FPERIODYEAR \r\n");
        sql.append("WHERE i.FPeriodAdjustDiff<>0 And i.FCompanyOrgUnitID = '" + fiOrgUnitID + "' ");
        sql.append(" and mcom.FAccountType = 2 ");
        sql.append(" and stype.FIsForwardAmt = 1 ");
        String psql = params.getString("wherePeriodSql");
        psql = psql.replaceAll("h.", "i.");
        sql.append(" AND (").append(psql).append(") ");
        if (MaterialFrom != null) {
            sql.append(" AND m.FNumber >= '" + MaterialFrom + "' ");
        }
        if (MaterialTo != null) {
            sql.append(" AND m.FNumber <= '" + MaterialTo + "' ");
        }
        if (MaterialIn != null) {
            sql.append(" AND m.FNumber in (" + MaterialIn + ") ");
        }
        if (params.getObject("ckBxMShortName") != null && params.getBoolean("ckBxMShortName") && txtMShortNameFrom != null && txtMShortNameTo != null) {
            if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() > 0 && txtMShortNameTo.trim().length() > 0) {
                sql.append(" AND M.FShortName >= '" + txtMShortNameFrom + "' AND M.FShortName <= '" + txtMShortNameTo + "' ");
            } else if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() > 0 && txtMShortNameTo.trim().length() <= 0) {
                sql.append(" AND M.FShortName >= '" + txtMShortNameFrom + "' ");
            } else if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() <= 0 && txtMShortNameTo.trim().length() > 0) {
                sql.append(" AND M.FShortName <= '" + txtMShortNameTo + "' ");
            }
        }
        String warehouse = null;
        if (params.getObject("warehouse") != null) {
            warehouse = ((WarehouseInfo)params.getObject("warehouse")).getNumber();
            sql.append(" AND wh.FNumber in('" + warehouse + "')");
        }
        if ((prmtKAClass = (KAClassficationInfo)params.getObject("prmtKAClass")) != null) {
            sql.append(" AND mcom.FKAClassID = '").append(prmtKAClass.getId().toString()).append("' ");
        }
        sql.append("\r\n GRoup by i.FCompanyOrgUnitID,fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("i.FYear,i.FPeriod,");
        sql.append("i.FMaterialID,m.FName_" + this.getLoc(ctx) + ",");
        sql.append("m.FNumber,m.FSHORTNAME,m.FModel,m.FModel,m.FPricePrecision,");
        sql.append("mu.FName_" + this.getLoc(ctx) + ",mmu.FQtyPrecision,cr.FPrecision,");
        sql.append("mcom.FAccountType");
        if (gatherGist.equals((Object)CostDiffGatherGistEnum.CALCULATETYPE)) {
            sql.append(",mcom.FCalculateType ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKORGUNIT)) {
            sql.append(",i.FStorageOrgUnitID,");
            sql.append("so.FName_" + this.getLoc(ctx) + " ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STORAGE)) {
            sql.append(",i.FWarehouseID,");
            sql.append("wh.FName_" + this.getLoc(ctx) + " ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASS)) {
            sql.append(",mcom.FKAClassID,");
            sql.append("ka.FName_" + this.getLoc(ctx) + " ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKANDKACLASS)) {
            sql.append(",concat(concat(i.FStorageOrgUnitID,'--'),mcom.FKAClassID),");
            sql.append("so.FName_" + this.getLoc(ctx) + ",");
            sql.append("ka.FName_" + this.getLoc(ctx) + " ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASSANDSTOCK)) {
            sql.append(",concat(concat(mcom.FKAClassID,'--'),i.FStorageOrgUnitID),");
            sql.append("ka.FName_" + this.getLoc(ctx) + ",");
            sql.append("so.FName_" + this.getLoc(ctx) + " ");
        }
        return sql.toString();
    }

    private String getStockSQL(Context ctx, String tempTable, RptParams params) throws BOSException {
        boolean ckShowNoCalculate;
        KAClassficationInfo prmtKAClass;
        String fiOrgUnitID = null;
        CostDiffGatherGistEnum gatherGist = (CostDiffGatherGistEnum)((Object)params.getObject("sumType"));
        String loc = this.getLoc(ctx);
        fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        String MaterialFrom = null;
        String MaterialIn = null;
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    MaterialFrom = ((MaterialInfo)materials[0]).getNumber();
                } else {
                    MaterialIn = CalculateUtil.getObjArrayNumberWithQuote(materials);
                }
            } else {
                MaterialFrom = params.getObject("materialFrom").toString();
            }
        }
        String MaterialTo = null;
        if (params.getObject("materialTo") != null) {
            MaterialTo = params.getObject("materialTo") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialTo")).getNumber() : params.getObject("materialTo").toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT 0 as FIndex, ");
        sql.append("d.FCompanyOrgUnitID as FCompanyOrgUnitID, ");
        sql.append("fi.FName_" + this.getLoc(ctx) + " as FCompanyName, ");
        sql.append("d.FYear as FYear, ");
        sql.append("d.FPeriod as FPeriod, ");
        sql.append("d.FMaterialID as FMaterialID, ");
        sql.append("m.FName_" + this.getLoc(ctx) + " as FMaterialName, ");
        sql.append("m.FNumber as FMaterialNumber, ");
        sql.append("m.FSHORTNAME as FSHORTNAME, ");
        sql.append("m.FModel as FMaterialModel, ");
        sql.append("m.FPricePrecision as FPricePrecision, ");
        sql.append("mu.FName_" + this.getLoc(ctx) + " as FBaseUnitName, ");
        sql.append("mmu.FQtyPrecision as FMatQtyPrecision, ");
        sql.append("cr.FPrecision as FAmountPrecision, ");
        if (gatherGist.equals((Object)CostDiffGatherGistEnum.CALCULATETYPE)) {
            sql.append("mcom.FCalculateType as FSumTypeID,");
            sql.append("(case when mcom.FCalculateType=0 then '" + SCMUtils.getResource((String)res, (String)"PURCHASE", (Context)ctx) + "' else (case when mcom.FCalculateType=1 then '" + SCMUtils.getResource((String)res, (String)"CONSIGN", (Context)ctx) + "' else (case when mcom.FCalculateType=2 then '" + SCMUtils.getResource((String)res, (String)"MAKE", (Context)ctx) + "' else ' ' end) end) end) as FSumTypeName, ");
            sql.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKORGUNIT)) {
            sql.append("d.FStorageOrgUnitID as FSumTypeID, ");
            sql.append("so.FName_" + loc + " as FSumTypeName, ");
            sql.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STORAGE)) {
            sql.append("d.FWarehouseID as FSumTypeID, ");
            sql.append("wh.FName_" + loc + " as FSumTypeName, ");
            sql.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASS)) {
            sql.append("mcom.FKAClassID as FSumTypeID,");
            sql.append("ka.FName_" + loc + " as FSumTypeName, ");
            sql.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.MATERIALTYPE)) {
            sql.append("'1' as FSumTypeID,");
            sql.append("'2' as FSumTypeName, ");
            sql.append("' ' as FSumTypeName2, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKANDKACLASS)) {
            sql.append("concat(concat(d.FStorageOrgUnitID,'--'),mcom.FKAClassID) as FSumTypeID, ");
            sql.append("so.FName_" + loc + " as FSumTypeName, ");
            sql.append("ka.FName_" + loc + " as FSumTypeName, ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASSANDSTOCK)) {
            sql.append("concat(concat(mcom.FKAClassID,'--'),d.FStorageOrgUnitID) as FSumTypeID,");
            sql.append("ka.FName_" + loc + " as FSumTypeName, ");
            sql.append("so.FName_" + loc + " as FSumTypeName, ");
        }
        sql.append("sum(d.FPeriodBeginQty) as FBeginQty, ");
        sql.append("sum(d.FPeriodBeginBalance) as FBeginStandardCost,");
        sql.append("sum(d.FPeriodBeginActualCost) as FBeginActualCost,");
        sql.append("sum(d.FPeriodBeginCostDiff) as FBeginCostDiff,");
        sql.append("0 as FInQty,0 as FInStandardCost,0 as FInActualCost,");
        sql.append("0 as FOutQty,0 as FOutStandardCost,0 as FOutActualCost,");
        sql.append("0 as FEndQty,0 as FEndStandardCost,0 as FEndActualCost ");
        sql.append("From T_IM_InventoryBalance d \r\n");
        sql.append("Inner Join T_BD_Material m On d.FMaterialID=m.FID \r\n");
        sql.append("INNER JOIN t_org_company fi ON d.FCompanyOrgUnitID = fi.FID \r\n");
        sql.append("INNER JOIN T_BD_MeasureUnit mu ON m.FBaseUnit = mu.FID \r\n");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID  AND mcom.FCompanyID = d.FCompanyOrgUnitID \r\n");
        sql.append("Inner Join T_DB_WAREHOUSE wh on d.FWarehouseID = wh.FID \r\n");
        sql.append("Inner Join T_ORG_Storage so on d.FStorageOrgUnitID = so.FID \r\n");
        sql.append("INNER JOIN T_IM_STORETYPE stype on d.FStoreTypeID = stype.fid \r\n");
        sql.append("LEFT JOIN T_BD_KAClassfication ka ON mcom.FKAClassID = ka.FID \r\n");
        sql.append("inner JOIN T_BD_CURRENCY cr ON cr.fid = fi.fbasecurrencyid \r\n");
        sql.append("inner JOIN t_bd_MultiMeasureUnit mmu ON mmu.fmaterialid = m.FID and mmu.fmeasureunitid = mu.fid \r\n");
        sql.append("INNER Join T_BD_PERIOD p On d.FPERIOD = p.FPERIODNUMBER and d.FYEAR = p.FPERIODYEAR \r\n");
        sql.append("Where d.FCompanyOrgUnitID = '" + fiOrgUnitID + "' ");
        sql.append(" and mcom.FAccountType = 2 ");
        sql.append(" and stype.FIsForwardAmt = 1 ");
        String psql = params.getString("wherePeriodSql");
        psql = psql.replaceAll("h.", "d.");
        sql.append(" AND (").append(psql).append(") ");
        if (MaterialFrom != null) {
            sql.append(" AND m.FNumber >= '" + MaterialFrom + "' ");
        }
        if (MaterialTo != null) {
            sql.append(" AND m.FNumber <= '" + MaterialTo + "' ");
        }
        if (MaterialIn != null) {
            sql.append(" AND m.FNumber in (" + MaterialIn + ") ");
        }
        String txtMShortNameFrom = params.getString("txtMShortNameFrom");
        String txtMShortNameTo = params.getString("txtMShortNameTo");
        if (params.getObject("ckBxMShortName") != null && params.getBoolean("ckBxMShortName") && txtMShortNameFrom != null && txtMShortNameTo != null) {
            if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() > 0 && txtMShortNameTo.trim().length() > 0) {
                sql.append(" AND M.FShortName >= '" + txtMShortNameFrom + "' AND M.FShortName <= '" + txtMShortNameTo + "' ");
            } else if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() > 0 && txtMShortNameTo.trim().length() <= 0) {
                sql.append(" AND M.FShortName >= '" + txtMShortNameFrom + "' ");
            } else if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() <= 0 && txtMShortNameTo.trim().length() > 0) {
                sql.append(" AND M.FShortName <= '" + txtMShortNameTo + "' ");
            }
        }
        String warehouse = null;
        if (params.getObject("warehouse") != null) {
            warehouse = ((WarehouseInfo)params.getObject("warehouse")).getNumber();
            sql.append(" AND wh.FNumber in('" + warehouse + "')");
        }
        if ((prmtKAClass = (KAClassficationInfo)params.getObject("prmtKAClass")) != null) {
            sql.append(" AND mcom.FKAClassID = '").append(prmtKAClass.getId().toString()).append("' ");
        }
        if (!(ckShowNoCalculate = params.getBoolean("ckShowNoCalculate"))) {
            sql.append(" AND d.FIsCalculate = 1 ");
        }
        boolean noSelectStorageMoveBill = params.getBoolean("noSelectStorageMoveBill");
        boolean noSelectWarehouseMoveBill = params.getBoolean("noSelectWarehouseMoveBill");
        if (noSelectStorageMoveBill) {
            sql.append("AND d.FMoveType <> 1 ");
        }
        if (noSelectWarehouseMoveBill) {
            sql.append("AND d.FMoveType <> 2 ");
        }
        sql.append("\r\n");
        sql.append("Group by d.FCompanyOrgUnitID,fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("d.FYear,d.FPeriod,");
        sql.append("d.FMaterialID,m.FName_" + this.getLoc(ctx) + ",");
        sql.append("m.FNumber,m.FSHORTNAME,m.FModel,m.FPricePrecision,");
        sql.append("mu.FName_" + this.getLoc(ctx) + ",mmu.FQtyPrecision,cr.FPrecision");
        if (gatherGist.equals((Object)CostDiffGatherGistEnum.CALCULATETYPE)) {
            sql.append(",mcom.FCalculateType ");
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKORGUNIT)) {
            sql.append(",d.FStorageOrgUnitID,");
            sql.append("so.FName_" + this.getLoc(ctx));
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STORAGE)) {
            sql.append(",d.FWarehouseID,");
            sql.append("wh.FName_" + this.getLoc(ctx));
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASS)) {
            sql.append(",mcom.FKAClassID,");
            sql.append("ka.FName_" + this.getLoc(ctx));
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.STOCKANDKACLASS)) {
            sql.append(",concat(concat(d.FStorageOrgUnitID,'--'),mcom.FKAClassID),");
            sql.append("so.FName_" + this.getLoc(ctx));
            sql.append(",ka.FName_" + this.getLoc(ctx));
        } else if (gatherGist.equals((Object)CostDiffGatherGistEnum.KACLASSANDSTOCK)) {
            sql.append(",concat(concat(mcom.FKAClassID,'--'),d.FStorageOrgUnitID),");
            sql.append("ka.FName_" + this.getLoc(ctx));
            sql.append(",so.FName_" + this.getLoc(ctx));
        }
        return sql.toString();
    }

    private String getInsertNextPeriod(Context ctx, String tempTable, PeriodInfo currentPeriodInfo, PeriodInfo nextPeriodInfo) throws BOSException {
        if (nextPeriodInfo.isIsAdjustPeriod()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTable).append(" ").append("(FINDEX,FCompanyOrgUnitID,FCompanyOrg,FYear,FPeriodNumber,FMaterialID,FMatName,").append("FMatNumber,FSHORTNAME,FMatModel,FMatUnitName,FSUMTYPEID,FSUMTYPENAME,FSUMTYPENAME2,FBeginQty,").append("FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate,").append("FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,FInDiffRate,").append("FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,FOutDiffRate,").append("FEndQty,FEndPrice,FEndStandardCost,FEndActualCost,FEndDiffCost,FEndDiffRate,FMatQtyPrecision,FPricePrecision,FAmountPrecision) ").append("select ").append(" ").append("a.FINDEX,a.FCompanyOrgUnitID,a.FCompanyOrg,").append(nextPeriodInfo.getPeriodYear()).append(" as FYear,").append(nextPeriodInfo.getPeriodNumber()).append(" as FPeriodNumber,a.FMaterialID,a.FMatName,").append("a.FMatNumber,a.FSHORTNAME,a.FMatModel,a.FMatUnitName,a.FSUMTYPEID,a.FSUMTYPENAME,a.FSUMTYPENAME2,").append("0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,a.FMatQtyPrecision,a.FPricePrecision,a.FAmountPrecision ").append("from ").append(tempTable).append(" a ").append("left join ").append("(select fIndex,fmaterialid from ").append(tempTable).append(" t where ").append("t.fyear = ").append(nextPeriodInfo.getPeriodYear()).append(" ").append("and t.fperiodNumber = ").append(nextPeriodInfo.getPeriodNumber()).append(" ").append(") b ").append("on a.fmaterialid = b.fmaterialid ").append("where ").append("a.fyear = ").append(currentPeriodInfo.getPeriodYear()).append(" ").append("and a.fperiodNumber = ").append(currentPeriodInfo.getPeriodNumber()).append(" ").append("and b.fIndex is null");
        return sql.toString();
    }

    private String updatePeriodLast(Context ctx, String tempTable, int pYear, int pMonth) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set FEndQty=Isnull(FBeginQty,0)+Isnull(FInQty,0)-Isnull(FOutQty,0),");
        sql.append("FEndPrice=(case (Isnull(FBeginQty,0)+Isnull(FInQty,0)-Isnull(FOutQty,0)) when 0 then 0 else \r\n");
        sql.append("TO_DECIMAL(to_decimal((Isnull(FBeginStandardCost,0)+Isnull(FInStandardCost,0)-Isnull(FOutStandardCost,0)),18,4)/(Isnull(FBeginQty,0)+Isnull(FInQty,0)-Isnull(FOutQty,0)),17,6) end), \r\n");
        sql.append("FEndStandardCost=Isnull(FBeginStandardCost,0)+Isnull(FInStandardCost,0)-Isnull(FOutStandardCost,0), \r\n");
        sql.append("FEndActualCost=Isnull(FBeginActualCost,0)+Isnull(FInActualCost,0)-Isnull(FOutActualCost,0), \r\n");
        sql.append("FEndDiffCost=Isnull(FBeginDiffCost,0)+Isnull(FInDiffCost,0)-Isnull(FOutDiffCost,0), \r\n");
        sql.append("FEndDiffRate=(case (Isnull(FBeginStandardCost,0)+Isnull(FInStandardCost,0)-Isnull(FOutStandardCost,0)) when 0 then 0 else  \r\n");
        sql.append("TO_DECIMAL(Round(to_decimal((Isnull(FBeginDiffCost,0)+Isnull(FInDiffCost,0)-Isnull(FOutDiffCost,0))*100,18,4)/(Isnull(FBeginStandardCost,0)+Isnull(FInStandardCost,0)-Isnull(FOutStandardCost,0)),2),17,2) end) \r\n");
        sql.append(" Where FYear=" + String.valueOf(pYear) + " And FPeriodNumber=" + String.valueOf(pMonth) + "\r\n");
        return sql.toString();
    }

    private String updatePeriodFirst(Context ctx, String tempTable, int prePeriodY, int prePeriodM, int nextPeriodY, int nextPeriodM) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " as t1 ");
        sql.append("Set(FBeginQty,FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate)=(");
        sql.append("\tselect t2.FEndQty,t2.FEndPrice,t2.FEndStandardCost,t2.FEndActualCost,t2.FEndDiffCost,t2.FEndDiffRate ");
        sql.append("\tFrom " + tempTable + " t3 ");
        sql.append("\tLeft join  " + tempTable + " t2 ");
        sql.append("\tOn t3.Findex=t2.Findex ");
        sql.append(" \tand t3.FSumTypeName=t2.FSumTypeName ");
        sql.append("\tand t3.FMaterialID=t2.FMaterialID ");
        sql.append("\tWhere t3.FYear=" + nextPeriodY);
        sql.append(" \tAnd t3.FperiodNumber=" + nextPeriodM);
        sql.append(" \tAnd t2.FYear=" + prePeriodY);
        sql.append(" \tAnd t2.FPeriodNumber=" + prePeriodM);
        sql.append(" \tAND T1.FINDEX = T2.FINDEX  ");
        sql.append("\tAND T1.FMATERIALID = T2.FMATERIALID ");
        sql.append("\tAND T1.FSUMTYPENAME = T2.FSUMTYPENAME)");
        sql.append("Where t1.FYear=" + nextPeriodY);
        sql.append(" And t1.FperiodNumber=" + nextPeriodM);
        return sql.toString();
    }

    private String getPeriodTotal(Context ctx, String tempTable, boolean isCalculateType) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable).append("(FINDEX,FCompanyOrgUnitID,FCompanyOrg,FYear,FPeriodNumber,FMaterialID,FMatName,").append("FMatNumber,FSHORTNAME,FMatModel,FMatUnitName,FSUMTYPEID,FSUMTYPENAME,FBeginQty,").append("FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate,").append("FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,FInDiffRate,").append("FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,FOutDiffRate,").append("FEndQty,FEndPrice,FEndStandardCost,FEndActualCost,FEndDiffCost,FEndDiffRate,FMatQtyPrecision,FPricePrecision,FAmountPrecision) ");
        sql.append(" Select 2 as FIndex,' ' as FCompanyOrgUnitID,' ' as FCompanyOrg,\r\n");
        sql.append("FYear,FPeriodNumber,\r\n");
        sql.append("' ' as FMaterialID,' ' as FMatName,\r\n");
        sql.append("' ' as FMatNumber,' 'AS FSHORTNAME,' ' as FMatModel,");
        sql.append("' ' as FMatUnitName,\r\n");
        if (isCalculateType) {
            sql.append("0 as FSumTypeID, ");
        } else {
            sql.append("' ' as FSumTypeID, ");
        }
        sql.append("'" + SCMUtils.getResource((String)res, (String)"PERIODTOTAL", (Context)ctx) + "' FSumTypeName,\r\n");
        sql.append("sum(FBeginQty),case sum(FBeginQty) when 0 then 0 else TO_DECIMAL(to_decimal(sum(FBeginStandardCost),17,4)/sum(FBeginQty),21,8) END,sum(FBeginStandardCost),");
        sql.append("sum(FBeginActualCost),(sum(FBeginActualCost)-sum(FBeginStandardCost)) as FBeginDiffCost,");
        sql.append("case sum(FBeginStandardCost) when 0 then 0 else TO_DECIMAL(Round(to_decimal((sum(FBeginActualCost)-sum(FBeginStandardCost))*100,18,4)/sum(FBeginStandardCost),2),17,2) END,");
        sql.append("sum(FInQty),case sum(FInQty) when 0 then 0 else TO_DECIMAL(to_decimal(sum(FInStandardCost),17,4)/sum(FInQty),21,8) END,sum(FInStandardCost),");
        sql.append("sum(FInActualCost),(sum(FInActualCost)-sum(FInStandardCost)) as FInDiffCost,");
        sql.append("case sum(FInStandardCost) when 0 then 0 else TO_DECIMAL(Round(to_decimal((sum(FInActualCost)-sum(FInStandardCost))*100,18,4)/sum(FInStandardCost),2),17,2) END,");
        sql.append("sum(FOutQty),case sum(FOutQty) when 0 then 0 else TO_DECIMAL(to_decimal(sum(FOutStandardCost),17,4)/sum(FOutQty),21,8) END,sum(FOutStandardCost),");
        sql.append("sum(FOutActualCost),(sum(FOutActualCost)-sum(FOutStandardCost)) as FOutDiffCost,");
        sql.append("case sum(FOutStandardCost) when 0 then 0 else TO_DECIMAL(Round(to_decimal((sum(FOutActualCost)-sum(FOutStandardCost))*100,18,4)/sum(FOutStandardCost),2),17,2) END,");
        sql.append("sum(FEndQty),case sum(FEndQty) when 0 then 0 else TO_DECIMAL(to_decimal(sum(FEndStandardCost),17,4)/sum(FEndQty),21,8) END,sum(FEndStandardCost),");
        sql.append("sum(FEndActualCost),(sum(FEndActualCost)-sum(FEndStandardCost)) as FEndDiffCost,");
        sql.append("case sum(FEndStandardCost) when 0 then 0 else TO_DECIMAL(Round(to_decimal((sum(FEndActualCost)-sum(FEndStandardCost))*100,18,4)/sum(FEndStandardCost),2),17,2) END,");
        sql.append("max(FMatQtyPrecision),max(FPricePrecision),max(FAmountPrecision) ");
        sql.append("From " + tempTable + "\r\n");
        sql.append("Where FIndex=1 \r\n");
        sql.append("Group By FYear,FPeriodNumber \r\n");
        return sql.toString();
    }

    private void getYearTotal(Context ctx, String tempTable, int beginYear, int beginPeriod, int endYear, int endPeroid, boolean isCalculateType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable).append("(FINDEX,FCompanyOrgUnitID,FCompanyOrg,FYear,FPeriodNumber,FMaterialID,FMatName,").append("FMatNumber,FSHORTNAME,FMatModel,FMatUnitName,FSUMTYPEID,FSUMTYPENAME,FBeginQty,").append("FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate,").append("FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,FInDiffRate,").append("FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,FOutDiffRate,").append("FEndQty,FEndPrice,FEndStandardCost,FEndActualCost,FEndDiffCost,FEndDiffRate,FMatQtyPrecision,FPricePrecision,FAmountPrecision) ");
        sql.append("Select 3 as FIndex,' ' as FCompanyOrgUnitID,' ' as FCompanyOrg,\r\n");
        sql.append("FYear, 0 as FPeriodNumber,\r\n");
        sql.append("' ' as FMaterialID,' ' as FMatName,\r\n");
        sql.append("' ' as FMatNumber,' ' as FSHORTNAME ,' ' as FMatModel,");
        sql.append("' ' as FMatUnitName,\r\n");
        if (isCalculateType) {
            sql.append("0 as FSumTypeID, ");
        } else {
            sql.append("' ' as FSumTypeID, ");
        }
        sql.append("'" + SCMUtils.getResource((String)res, (String)"YEARTOTAL", (Context)ctx) + "' FSumTypeName,\r\n");
        sql.append("FBeginQty,FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate,\r\n");
        sql.append("0 as FInQty,0 as FInPrice,0 as FInStandardCost,0 as FInActualCost,0 as FInDiffCost,0 as FInDiffRate,\r\n");
        sql.append("0 as FOutQty,0 as FOutPrice,0 as FOutStandardCost,0 as FOutActualCost,0 as FOutDiffCost,0 as FOutDiffRate,\r\n");
        sql.append("0 as FEndQty,0 as FEndPrice,0 as FEndStandardCost,0 as FEndActualCost,0 as FEndDiffCost,0 as FEndDiffRate,");
        sql.append("FMatQtyPrecision, FPricePrecision, FAmountPrecision \r\n");
        sql.append("From " + tempTable + "\r\n");
        sql.append("Where FIndex=2 And FYear=" + String.valueOf(beginYear) + " And FPeriodNumber=" + String.valueOf(beginPeriod) + "\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (endYear > beginYear) {
            sql = new StringBuffer();
            sql.append("Insert Into " + tempTable).append("(FINDEX,FCompanyOrgUnitID,FCompanyOrg,FYear,FPeriodNumber,FMaterialID,FMatName,").append("FMatNumber,FSHORTNAME,FMatModel,FMatUnitName,FSUMTYPEID,FSUMTYPENAME,").append("FBeginQty,FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate,").append("FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,FInDiffRate,").append("FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,FOutDiffRate,").append("FEndQty,FEndPrice,FEndStandardCost,FEndActualCost,FEndDiffCost,FEndDiffRate,FMatQtyPrecision,FPricePrecision,FAmountPrecision) ");
            sql.append("Select 3 as FIndex,' ' as FCompanyOrgUnitID,' ' as FCompanyOrg,\r\n");
            sql.append("FYear, 0 as FPeriodNumber,\r\n");
            sql.append("' ' as FMaterialID,' ' as FMatName,\r\n");
            sql.append("' ' as FMatNumber,' ' AS FSHORTNAME,' ' as FMatModel,");
            sql.append("' ' as FMatUnitName,\r\n");
            if (isCalculateType) {
                sql.append("0 as FSumTypeID, ");
            } else {
                sql.append("' ' as FSumTypeID, ");
            }
            sql.append("'" + SCMUtils.getResource((String)res, (String)"YEARTOTAL", (Context)ctx) + "' FSumTypeName,\r\n");
            sql.append("FBeginQty,FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate,\r\n");
            sql.append("0 as FInQty,0 as FInPrice,0 as FInStandardCost,0 as FInActualCost,0 as FInDiffCost,0 as FInDiffRate,\r\n");
            sql.append("0 as FOutQty,0 as FOutPrice,0 as FOutStandardCost,0 as FOutActualCost,0 as FOutDiffCost,0 as FOutDiffRate,\r\n");
            sql.append("0 as FEndQty,0 as FEndPrice,0 as FEndStandardCost,0 as FEndActualCost,0 as FEndDiffCost,0 as FEndDiffRate,");
            sql.append("FMatQtyPrecision, FPricePrecision,FAmountPrecision \r\n");
            sql.append("From " + tempTable + "\r\n");
            sql.append("Where FIndex=2 And FYear>" + String.valueOf(beginYear) + " And FPeriodNumber=1\r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        sql = new StringBuffer();
        sql.append("Update " + tempTable);
        sql.append(" Set(FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,FInDiffRate,\r\n");
        sql.append(" FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,FOutDiffRate)=\r\n");
        sql.append(" (Select FInTotalQty,");
        sql.append(" case FInTotalQty when 0 then 0 else TO_DECIMAL(to_decimal(FInTotalStandardCost,18,4)/FInTotalQty,17,6) end,\r\n");
        sql.append(" FInTotalStandardCost,FInTotalActualCost,FInTotalDiffCost, ");
        sql.append(" case FInTotalStandardCost when 0 then 0 else ");
        sql.append(" TO_DECIMAL(Round(to_decimal(FInTotalDiffCost*100,18,4)/FInTotalStandardCost,2),17,2) end,\r\n");
        sql.append(" FOutTotalQty,");
        sql.append(" case FOutTotalQty when 0 then 0 else TO_DECIMAL(to_decimal(FOutTotalStandardCost,18,4)/FOutTotalQty,17,6) end,\r\n");
        sql.append(" FOutTotalStandardCost,FOutTotalActualCost,FOutTotalDiffCost, ");
        sql.append(" case FOutTotalStandardCost when 0 then 0 else ");
        sql.append(" TO_DECIMAL(Round(to_decimal(FOutTotalDiffCost*100,18,4)/FOutTotalStandardCost,2),17,2) end \r\n");
        sql.append(" From \r\n");
        sql.append(" (Select FYear as FYear, \r\n");
        sql.append(" Sum(T1.FInQty) as FInTotalQty ,Sum(T1.FInStandardCost) as FInTotalStandardCost, \r\n");
        sql.append(" Sum(T1.FInActualCost) as FInTotalActualCost ,Sum(T1.FInDiffCost) as FInTotalDiffCost, \r\n");
        sql.append(" Sum(T1.FOutQty) as FOutTotalQty ,Sum(T1.FOutStandardCost) as FOutTotalStandardCost, \r\n");
        sql.append(" Sum(T1.FOutActualCost) as FOutTotalActualCost ,Sum(T1.FOutDiffCost) as FOutTotalDiffCost \r\n");
        sql.append(" From " + tempTable + " T1 \r\n");
        sql.append(" Where T1.FIndex=2 \r\n");
        sql.append(" Group By T1.FYear ) \r\n");
        sql.append(" i ");
        sql.append(" Where i.FYear = " + tempTable + ".FYear and " + tempTable + ".FIndex=3 )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set ");
        sql.append("FEndQty = isnull(FBeginQty,0)+isnull(FInQty,0)-isnull(FOutQty,0),");
        sql.append("FEndPrice=(case (Isnull(FBeginQty,0)+Isnull(FInQty,0)-Isnull(FOutQty,0)) when 0 then 0 else \r\n");
        sql.append("TO_DECIMAL(to_decimal((Isnull(FBeginStandardCost,0)+Isnull(FInStandardCost,0)-Isnull(FOutStandardCost,0)),18,4)/(Isnull(FBeginQty,0)+Isnull(FInQty,0)-Isnull(FOutQty,0)),17,6) end), \r\n");
        sql.append("FEndStandardCost=Isnull(FBeginStandardCost,0)+Isnull(FInStandardCost,0)-Isnull(FOutStandardCost,0), \r\n");
        sql.append("FEndActualCost=Isnull(FBeginActualCost,0)+Isnull(FInActualCost,0)-Isnull(FOutActualCost,0), \r\n");
        sql.append("FEndDiffCost=Isnull(FBeginDiffCost,0)+Isnull(FInDiffCost,0)-Isnull(FOutDiffCost,0), \r\n");
        sql.append("FEndDiffRate=(case (Isnull(FBeginStandardCost,0)+Isnull(FInStandardCost,0)-Isnull(FOutStandardCost,0)) when 0 then 0 else  \r\n");
        sql.append("TO_DECIMAL(Round(to_decimal((Isnull(FBeginDiffCost,0)+Isnull(FInDiffCost,0)-Isnull(FOutDiffCost,0))*100,18,4)/(Isnull(FBeginStandardCost,0)+Isnull(FInStandardCost,0)-Isnull(FOutStandardCost,0)),2),17,2) end) \r\n");
        sql.append("Where FIndex=3  \r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void getAllTotal(Context ctx, String tempTable, int beginYear, int beginPeriod, boolean isCalculateType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable).append("(FINDEX,FCompanyOrgUnitID,FCompanyOrg,FYear,FPeriodNumber,FMaterialID,FMatName,").append("FMatNumber,FSHORTNAME,FMatModel,FMatUnitName,FSUMTYPEID,FSUMTYPENAME,").append("FBeginQty,FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate,").append("FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,FInDiffRate,").append("FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,FOutDiffRate,").append("FEndQty,FEndPrice,FEndStandardCost,FEndActualCost,FEndDiffCost,FEndDiffRate,FMatQtyPrecision,FPricePrecision,FAmountPrecision) ");
        sql.append("Select 4 as FIndex,' ' as FCompanyOrgUnitID,' ' as FCompanyOrg,\r\n");
        sql.append("0 as FYear, 0 FPeriodNumber,\r\n");
        sql.append("' ' as FMaterialID,' ' as FMatName,\r\n");
        sql.append("' ' as FMatNumber,' ' AS FSHORTNAME,' ' as FMatModel,");
        sql.append("' ' as FMatUnitName,\r\n");
        if (isCalculateType) {
            sql.append("0 as FSumTypeID, ");
        } else {
            sql.append("' ' as FSumTypeID, ");
        }
        sql.append("'" + SCMUtils.getResource((String)res, (String)"SUMALL", (Context)ctx) + "' FSumTypeName,\r\n");
        sql.append("FBeginQty,FBeginPrice,FBeginStandardCost,FBeginActualCost,FBeginDiffCost,FBeginDiffRate,\r\n");
        sql.append("0 as FInQty,0 as FInPrice,0 as FInStandardCost,0 as FInActualCost,0 as FInDiffCost,0 as FInDiffRate,\r\n");
        sql.append("0 as FOutQty,0 as FOutPrice,0 as FOutStandardCost,0 as FOutActualCost,0 as FOutDiffCost,0 as FOutDiffRate,\r\n");
        sql.append("0 as FEndQty,0 as FEndPrice,0 as FEndStandardCost,0 as FEndActualCost,0 as FEndDiffCost,0 as FEndDiffRate,FMatQtyPrecision,FPricePrecision,FAmountPrecision \r\n");
        sql.append("From " + tempTable + "\r\n");
        sql.append("Where FIndex=2 And FYear=" + String.valueOf(beginYear) + " And FPeriodNumber=" + String.valueOf(beginPeriod) + "\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " AS T3 ");
        sql.append(" Set(FInQty,FInPrice,FInStandardCost,FInActualCost,FInDiffCost,FInDiffRate,\r\n");
        sql.append(" FOutQty,FOutPrice,FOutStandardCost,FOutActualCost,FOutDiffCost,FOutDiffRate)=\r\n");
        sql.append(" (Select FInTotalQty,");
        sql.append(" case FInTotalQty when 0 then 0 else TO_DECIMAL(to_decimal(FInTotalStandardCost,18,4)/FInTotalQty,17,6) end,\r\n");
        sql.append(" FInTotalStandardCost,FInTotalActualCost,FInTotalDiffCost, ");
        sql.append(" case FInTotalStandardCost when 0 then 0 else ");
        sql.append(" TO_DECIMAL(Round(to_decimal(FInTotalDiffCost*100,18,4)/FInTotalStandardCost,2),17,2) end,\r\n");
        sql.append(" FOutTotalQty,");
        sql.append(" case FOutTotalQty when 0 then 0 else TO_DECIMAL(to_decimal(FOutTotalStandardCost,18,4)/FOutTotalQty,17,6) end,\r\n");
        sql.append(" FOutTotalStandardCost,FOutTotalActualCost,FOutTotalDiffCost, ");
        sql.append(" case FOutTotalStandardCost when 0 then 0 else ");
        sql.append(" TO_DECIMAL(Round(to_decimal(FOutTotalDiffCost*100,18,4)/FOutTotalStandardCost,2),17,2) end \r\n");
        sql.append(" From \r\n");
        sql.append(" (Select Sum(T1.FInQty) as FInTotalQty ,Sum(T1.FInStandardCost) as FInTotalStandardCost,Sum(T1.FInActualCost) as FInTotalActualCost, \r\n");
        sql.append("   Sum(T1.FOutQty) as FOutTotalQty,Sum(T1.FOutStandardCost) as FOutTotalStandardCost,Sum(T1.FOutActualCost) as FOutTotalActualCost, \r\n");
        sql.append(" Sum(FInDiffCost) as FInTotalDiffCost,Sum(FOutDiffCost) as FOutTotalDiffCost ");
        sql.append("   From " + tempTable + " T1 \r\n");
        sql.append("   Where T1.FIndex=3 )\r\n");
        sql.append("   i," + tempTable + " T2 \r\n");
        sql.append("   Where T2.FIndex=4) Where T3.FIndex=4\r\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set ");
        sql.append("FEndQty = isnull(FBeginQty,0)+isnull(FInQty,0)-isnull(FOutQty,0),");
        sql.append("FEndPrice=(case (Isnull(FBeginQty,0)+Isnull(FInQty,0)-Isnull(FOutQty,0)) when 0 then 0 else \r\n");
        sql.append("TO_DECIMAL(to_decimal((Isnull(FBeginStandardCost,0)+Isnull(FInStandardCost,0)-Isnull(FOutStandardCost,0)),18,4)/(Isnull(FBeginQty,0)+Isnull(FInQty,0)-Isnull(FOutQty,0)),17,6) end), \r\n");
        sql.append("FEndStandardCost=Isnull(FBeginStandardCost,0)+Isnull(FInStandardCost,0)-Isnull(FOutStandardCost,0), \r\n");
        sql.append("FEndActualCost=Isnull(FBeginActualCost,0)+Isnull(FInActualCost,0)-Isnull(FOutActualCost,0), \r\n");
        sql.append("FEndDiffCost=Isnull(FBeginDiffCost,0)+Isnull(FInDiffCost,0)-Isnull(FOutDiffCost,0), \r\n");
        sql.append("FEndDiffRate=(case (Isnull(FBeginStandardCost,0)+Isnull(FInStandardCost,0)-Isnull(FOutStandardCost,0)) when 0 then 0 else  \r\n");
        sql.append("TO_DECIMAL(Round(to_decimal((Isnull(FBeginDiffCost,0)+Isnull(FInDiffCost,0)-Isnull(FOutDiffCost,0))*100,18,4)/(Isnull(FBeginStandardCost,0)+Isnull(FInStandardCost,0)-Isnull(FOutStandardCost,0)),2),17,2) end) \r\n");
        sql.append("Where FIndex=4 ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

