/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.IssueTypeEnum;
import com.kingdee.eas.scm.cal.app.AbstractDevolveCostCalculateFacadeControllerBean;
import com.kingdee.eas.scm.cal.onekey.multipleJob.ThreadLocalHelper;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.util.app.CheckVoucherUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class DevolveCostCalculateFacadeControllerBean
extends AbstractDevolveCostCalculateFacadeControllerBean {
    private static final long serialVersionUID = 8934221723511374851L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.DevolveCostCalculateFacadeControllerBean");
    private String companyOrgID;
    private int precision = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CalculateParams _costCalculate(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        String INSERT_INWAREHSBILL_SQL = "insert into {0}(FBillId, FEntryId, FNumber, FBillTypeId, FSupplierId, FBizDate, FYear, FPeriod, FMaterialId, FPricePrecision, FQty, FReverseQty, FCurrWriteOffQty, FCurrWriteOffAmount, FUnitMaterialCost, FMaterialCost, FFivouchered,fcoreBillEntryId) select bill.FID as FBillId, entry.FId as FEntryId, bill.FNumber, bill.FBillTypeId, bill.FSupplierId, bill.FBizDate, bill.FYear, bill.FPeriod, entry.FMaterialId, material.FPricePrecision, entry.FQty, entry.FReverseQty, 0.00 as FCurrWriteOffQty, 0.00 as FCurrWriteOffAmount, 0 as FUnitMaterialCost,0 as FMaterialCost, bill.FFivouchered,entry.FPurOrderEntryID from T_IM_PurInWarehsBill bill inner join T_IM_PurInWarehsEntry entry on entry.FParentId = bill.FID inner join T_BD_Material material on entry.FMaterialId = material.FID where bill.FBaseStatus = 4  and bill.FPurchaseType = 1 and entry.FSCWrittenOffBaseQty <> 0 and {1}";
        String GET_WRITEOFF_RECORD_SQL = "insert into {0}(FKEY,FID, FEntryId, FGroupNO, FCurrWriteOffQty,FIsDevolveMatReq) select newbosid(''88888888''),writeOffRecord.FParentID , inWarehs.FEntryId, writeOffRecord.FGroupNO ,sum(writeOffRecord.FCurrWriteOffQty),1 from T_CL_DevolveWriteOffRecord writeOffRecord inner join T_CL_DevolveWriteOffGroup bill on writeOffRecord.FParentId=bill.FId inner join {1} inWarehs on writeOffRecord.FBillEntryID = inWarehs.FEntryID where (bill.FCreateType = 0 or bill.FCreateType = 2) group by writeOffRecord.FParentID , inWarehs.FEntryId , writeOffRecord.FGroupNO, writeOffRecord.FBillEntryId";
        String UPDATE_CURRWRITEOFFQTY_SQL1 = " update {0} as inWarehs set (FCurrWriteOffQty) = (select FCurrWriteOffQty from  (select writeOffTemp.FEntryId as FEntryId, sum(writeOffTemp.FCurrWriteOffQty) as FCurrWriteOffQty from {1} writeOffTemp where FIsDevolveMatReq =1 group by writeOffTemp.FEntryId) as writeoff  where inWarehs.FEntryId = writeoff.FEntryId)";
        String UPDATE_CURRWRITEOFFQTY_SQL2 = " update {0} as inWarehs set (FCurrWriteOffQty) = (select FCurrWriteOffQty from  (select writeOffTemp.FEntryId as FEntryId, sum(writeOffTemp.FCurrWriteOffQty) as FCurrWriteOffQty from {1} writeOffTemp  group by writeOffTemp.FEntryId having sum(FIsDevolveMatReq)=0 ) as writeoff  where inWarehs.FEntryId = writeoff.FEntryId)";
        String GET_MATREQBILL_SQL = "insert into {0}(FID, FBillId, FEntryId, FUnitActualCost, FActualCost, FCurrWriteOffQty, FCurrWriteOffAmount, FBillUnWriteOffBaseQty, FInWarehsEntryId,fcoreBillEntryId,FWriteOffGroupId,FGroupNO) select writeOffRecord.FID, writeOffRecord.FBillID, writeOffRecord.FBillEntryID as FEntryId, 0.00 as FUnitActualCost, 0.00 as FActualCost, writeOffRecord.FCurrWriteOffQty, writeOffRecord.FCurrWriteOffAmount as FCurrWriteOffAmount, writeOffRecord.FBillUnWriteOffBaseQty, writeOffTemp.FEntryId as FInWarehsEntryId,entry.FCoreBillEntryID,writeOffRecord.FParentId,writeOffRecord.FGroupNO from {1} writeOffTemp inner join T_CL_DevolveWriteOffRecord writeOffRecord on writeOffRecord.FParentID = writeOffTemp.FID and writeOffRecord.FGroupNO = writeOffTemp.FGroupNO and writeOffRecord.FBillTypeNumber = ''{2}''inner join T_IM_MaterialReqBillEntry entry on writeOffRecord.FBillEntryID = entry.fid";
        String UPDATE_CURWRITEOFFAMOUNT_SQL = "update {0} as inWarehs set (FCurrWriteOffAmount) = (select FCurrWriteOffAmount from (select matReq.FInWarehsEntryId, sum(matReq.FCurrWriteOffAmount) as FCurrWriteOffAmount from {1} matReq group by matReq.FInWarehsEntryId) as matReq where matReq.FInWarehsEntryId = inWarehs.FEntryId)";
        String UPDATE_WRITEOFF_RECORD_SQL = "update {0} set FIsDevolveMatReq = 0 where FKEY in (select writeoff.FKEY from T_CL_DevolveWriteOffRecord writeOffRecord  inner join T_CL_DevolveWriteOffGroup bill on writeOffRecord.FParentId=bill.FId  inner join {1} inWarehs on writeOffRecord.FBillEntryID = inWarehs.FEntryID  inner join {0} writeoff on writeOff.fid = writeOffRecord.FParentID and writeOff.FGroupNO = writeOffRecord.FGroupNO  where inWarehs.FCurrWriteOffAmount = 0 or inWarehs.FCurrWriteOffAmount is null ) ";
        String UPDATE_MATERIALCOST_SQL = "update {0} set FUnitMaterialCost = ROUND(TO_DECIMAL((case when FCurrWriteOffQty =0 then 0 else FCurrWriteOffAmount / FCurrWriteOffQty end), 21, 8), FPricePrecision), FMaterialCost = ROUND(TO_DECIMAL(FCurrWriteOffAmount * TO_DECIMAL((case when FCurrWriteOffQty =0 then 0 else FQty/FCurrWriteOffQty end), 21, 8), 17, 4), {1})";
        String UPDATE_INP_RECORD_CURRAMOUNT_RB = "update T_CL_DevolveWriteOffRecord as record set (FCurrWriteOffAmount) = (select case when record.FCurrWriteOffQty = inWarehs.FQty then inWarehs.FMaterialCost else ROUND(TO_DECIMAL(record.FCurrWriteOffQty * inWarehs.FUnitMaterialCost, 17, 4), {1}) end from {0} as inWarehs where record.FBillEntryID = inWarehs.FEntryId)";
        String UPDATE_INP_RECORD_CURRAMOUNT_MAT = "update T_CL_DevolveWriteOffRecord as record set (FCurrWriteOffAmount) = (select FCurrWriteOffAmount from (select FWriteOffGroupId,FGroupNo,sum(matReq.FCurrWriteOffAmount) as FCurrWriteOffAmount from {0} matReq group by FWriteOffGroupId,FGroupNo) groupTemp where record.FParentId = groupTemp.FWriteOffGroupId and record.FGroupNo = groupTemp.FGroupNo and record.FBillTypeNumber = ''{1}'')";
        String REWRITE_INWAREHSBILL_SQL = "update T_IM_PurInWarehsEntry as entry set (FUnitMaterialCost, FMaterialCost) = (select inWarehs.FUnitMaterialCost, inWarehs.FMaterialCost from {0} as inWarehs where entry.FID = inWarehs.FEntryId and inWarehs.FYear*100 + inWarehs.FPeriod >= {1} and inWarehs.FFivouchered = 0 and inWarehs.FQty > 0)";
        String REWRITE_RED_INWAREHSBILL_SQL = "update T_IM_PurInWarehsEntry as entry set (FUnitMaterialCost, FMaterialCost) = (select inWarehs.FUnitMaterialCost, inWarehs.FMaterialCost from {0} as inWarehs where entry.FID = inWarehs.FEntryId and inWarehs.FYear*100 + inWarehs.FPeriod >= {1} and inWarehs.FFivouchered = 0 and exists(select 1 from T_CL_DevolveWriteOffRecord r INNER JOIN T_CL_DEVOLVEWRITEOFFGROUP g on g.fid = r.FPARENTID where g.FCREATETYPE = 3 and r.FBillEntryID = inWarehs.FEntryId ))";
        String UPDATE_ACTUALCOST_SQL = "update T_IM_PurInWarehsEntry as entry set (FUnitActualCost, FActualCost) = (select ROUND(TO_DECIMAL((entry.FPurchaseCost + entry.FMaterialCost + entry.FPurchaseFee) / entry.FQty, 17, 4), inWarehs.FPricePrecision), entry.FPurchaseCost + entry.FMaterialCost + entry.FPurchaseFee from {0} inWarehs where entry.FID = inWarehs.FEntryId and inWarehs.FYear*100 + inWarehs.FPeriod >= {1} and inWarehs.FFivouchered = 0)";
        String UPDATE_TOTAL_ACTUALCOST_SQL = "update T_IM_PurInWarehsBill as bill set (FTotalActualCost) = (select total.FActualCost from (select entry.FParentId, sum(entry.FActualCost) as FActualCost from T_IM_PurInWarehsEntry as entry inner join {0} as inWarehs on entry.FID = inWarehs.FEntryId where inWarehs.FYear*100 + inWarehs.FPeriod >= {1} and inWarehs.FFivouchered = 0 group by entry.FParentId) total where bill.FID = total.FParentId)";
        String CHECK_BEFORE_ADCOST_SQL = "select fid,fnumber from T_CL_CostAdjustBill where FID in (select entry.FParentID from T_CL_CostAdjustBillEntry as entry inner join {0} as inWarehs on entry.FSourceBillEntryId = inWarehs.FEntryId) and FCreateType = {1} and FFivouchered = 1";
        String GET_DELETE_BEFORE_ADCOST_SQL = "select fid from T_CL_CostAdjustBill where FID in (select entry.FParentID from T_CL_CostAdjustBillEntry as entry inner join {0} as inWarehs on entry.FSourceBillEntryId = inWarehs.FEntryId) and FCreateType = {1}";
        String GET_ADJUSTCOST_BILL_SQL = "select entry.FParentId, entry.FId, inWarehs.FNumber, inWarehs.FBizDate, inWarehs.FYear, inWarehs.FPeriod, entry.FMaterialId, inWarehs.FPricePrecision, inWarehs.FCurrWriteOffQty, inWarehs.FCurrWriteOffAmount, entry.FUnitMaterialCost, entry.FMaterialCost, inWarehs.FBillTypeId, inWarehs.FSupplierId, entry.FCompanyOrgUnitId, entry.FStorageOrgUnitId, entry.FWarehouseId, entry.FLocationid ,entry.FBaseUnitId, entry.FLot, entry.FAssistPropertyID, entry.FProjectID, entry.FTrackNumberID, entry.FSeq , bill.FAdminOrgUnitID, bill.FCostCenterOrgUnitID from {0} as inWarehs inner join T_IM_PurInWarehsEntry as entry on entry.FId = inWarehs.FEntryID inner join T_IM_PurInWarehsBill bill on entry.FParentId = bill.FId where inWarehs.FYear*100 + inWarehs.FPeriod < {1} or inWarehs.FFivouchered = 1";
        String GET_UPDATE_REDINWAREHSBILL_SQL_1 = "update {0} as inWarehs set (FUnitMaterialCost,FMaterialCost) = (select Top 1 entry.FUnitMaterialCost,ROUND(TO_DECIMAL(entry.FUnitMaterialCost*inWarehs.FQty, 21, 8), {1})  from  T_IM_PurInWarehsBill bill inner join T_IM_PurInWarehsEntry entry on entry.FParentId = bill.FID  inner join T_CL_WriteOffRecord record on  entry.fid = record.FBillEntryID  inner join T_CL_WriteOffGroup  writeoffgroup on record.FParentID = writeoffgroup.fid  inner join T_SCM_BillType billType on record.fbillTypeNumber = billType.fnumber  inner join T_CL_WriteOffRecord writeoffrecord on  writeoffgroup.fid = writeoffrecord.FParentID  where writeoffrecord.FBillEntryID = inWarehs.FEntryId and  inWarehs.FBillTypeId= billType.fid   and bill.FBaseStatus = 4 and bill.FIsReversed = 0 and bill.FPurchaseType = 1  and entry.FUnitMaterialCost<>0 and entry.FSCWrittenOffBaseQty>0  and writeoffgroup.FCREATETYPE = 3 ) where inWarehs.FUnitMaterialCost = 0 ";
        String GET_UPDATE_REDINWAREHSBILL_SQL_2 = "update {0} as inWarehs set (FUnitMaterialCost,FMaterialCost) = (select entry.FUnitMaterialCost,ROUND(TO_DECIMAL(entry.FUnitMaterialCost*inWarehs.FQty, 21, 8), {1}) from  T_IM_PurInWarehsBill bill inner join T_IM_PurInWarehsEntry entry on entry.FParentId = bill.FID inner join T_IM_PurInWarehsEntry inWarehsOwn on entry.fid = inWarehsOwn.FSourceBillEntryID where inWarehsOwn.fid = inWarehs.FEntryId and bill.FBaseStatus = 4 and bill.FIsReversed = 0 and bill.FPurchaseType = 1  and entry.FUnitMaterialCost<>0) where inWarehs.FUnitMaterialCost = 0 and exists(select 1 from T_CL_DevolveWriteOffRecord r INNER JOIN T_CL_DEVOLVEWRITEOFFGROUP g on g.fid = r.FPARENTID where g.FCREATETYPE = 3 and r.FBillEntryID = inWarehs.FEntryId  )";
        String GET_UPDATE_REDINWAREHSBILL_SQL_3 = " update {0} as inWarehs set (FUnitMaterialCost,FMaterialCost) = (select TOP 1 entry.FUnitMaterialCost ,ROUND(TO_DECIMAL(entry.FUnitMaterialCost*inWarehs.FQty, 21, 8), {1})\t from  T_IM_PurInWarehsBill bill inner join T_IM_PurInWarehsEntry entry on entry.FParentId = bill.FID  inner join T_IM_PurInWarehsEntry inWarehsOwn on  entry.FPurOrderEntryID = inWarehsOwn.FPurOrderEntryID  where inWarehsOwn.fid = inWarehs.FEntryId and bill.FBaseStatus = 4 and bill.FIsReversed = 0 and bill.FPurchaseType = 1  and entry.FUnitMaterialCost<>0  and entry.FSCWrittenOffBaseQty>0 ) where inWarehs.FUnitMaterialCost = 0and exists(select 1 from T_CL_DevolveWriteOffRecord r INNER JOIN T_CL_DEVOLVEWRITEOFFGROUP g on g.fid = r.FPARENTID where g.FCREATETYPE = 3 and r.FBillEntryID = inWarehs.FEntryId  )";
        String GET_INWAREHS_DIFF_SQL = "insert into {1} (fentryid,diff) select t0.fentryid,t0.fcurrwriteoffamount - t1.fmaterialcost as diff from (select writeoffrecord.fbillentryid fentryid,sum(writeoffrecord.fcurrwriteoffamount) as fcurrwriteoffamount from t_cl_devolvewriteoffrecord writeoffrecord inner join {0} writeofftemp on writeoffrecord.fbillentryid = writeofftemp.fentryid and writeofftemp.fqty > 0 group by writeoffrecord.fbillentryid) t0  inner join (select fid fentryid,fmaterialcost from t_im_purinwarehsentry where fid in (select fentryid from {0} where fqty > 0)) t1 on t0.fentryid = t1.fentryid where t0.fcurrwriteoffamount <> t1.fmaterialcost";
        String GET_MIN_RECORD_SQL = "INSERT INTO {2} (FQTY,FENTRYID,DIFF) SELECT MIN(ALLRECORD.FCURRWRITEOFFQTY),BLUERECORD.FBILLENTRYID,DIFFTEMP.DIFF FROM T_CL_DevolveWriteOffRecord BLUERECORD INNER JOIN {0} DIFFTEMP ON DIFFTEMP.FENTRYID = BLUERECORD.FBILLENTRYID INNER JOIN T_CL_DevolveWriteOffRecord ALLRECORD ON ALLRECORD.FPARENTID = BLUERECORD.FPARENTID INNER JOIN T_IM_PURINWAREHSENTRY ENTRY ON ENTRY.FID = ALLRECORD.FBILLENTRYID INNER JOIN T_IM_PURINWAREHSBILL UPDATEBILL ON UPDATEBILL.FID = ENTRY.FPARENTID WHERE ALLRECORD.FCURRWRITEOFFQTY < 0 AND UPDATEBILL.FFIVOUCHERED = 0 AND UPDATEBILL.FYEAR*100+UPDATEBILL.FPERIOD >= {1} GROUP BY BLUERECORD.FBILLENTRYID,DIFFTEMP.DIFF";
        String GET_ADJUSTREDBILL_SQL = "INSERT INTO {2} (FENTRYID,DIFF) SELECT MIN(ALLRECORD.FBILLENTRYID),DIFFTEMP.DIFF FROM T_CL_DevolveWriteOffRecord BLUERECORD INNER JOIN {0} DIFFTEMP ON DIFFTEMP.FENTRYID = BLUERECORD.FBILLENTRYID INNER JOIN T_CL_DevolveWriteOffRecord ALLRECORD ON ALLRECORD.FPARENTID = BLUERECORD.FPARENTID INNER JOIN T_IM_PURINWAREHSENTRY ENTRY ON ENTRY.FID = ALLRECORD.FBILLENTRYID INNER JOIN T_IM_PURINWAREHSBILL UPDATEBILL ON UPDATEBILL.FID = ENTRY.FPARENTID WHERE ALLRECORD.FCURRWRITEOFFQTY = DIFFTEMP.FQTY AND UPDATEBILL.FFIVOUCHERED = 0 AND UPDATEBILL.FYEAR*100+UPDATEBILL.FPERIOD >= {1} GROUP BY DIFFTEMP.FENTRYID,DIFFTEMP.DIFF";
        String UPDATE_REDBILLDIFF_SQL = "UPDATE T_IM_PURINWAREHSENTRY T1 SET (FMATERIALCOST,FUNITMATERIALCOST) = (SELECT ENTRY.FMATERIALCOST + DIFFTEMP.DIFF,ROUND(TO_DECIMAL((ENTRY.FMATERIALCOST + DIFFTEMP.DIFF)/ENTRY.FQTY,21,8),BILLINFO.FPRICEPRECISION) FROM T_IM_PURINWAREHSENTRY ENTRY INNER JOIN {0} DIFFTEMP ON ENTRY.FID = DIFFTEMP.FENTRYID INNER JOIN {1} BILLINFO ON ENTRY.FID = BILLINFO.FENTRYID WHERE T1.FID = ENTRY.FID)";
        String UPDATE_REDWRITEOFFRECORD_SQL = "UPDATE T_CL_DevolveWriteOffRecord T1 SET (FCURRWRITEOFFAMOUNT) = (SELECT CASE WHEN UPDATERECORD.FCURRWRITEOFFAMOUNT > 0 THEN UPDATERECORD.FCURRWRITEOFFAMOUNT - DIFF ELSE UPDATERECORD.FCURRWRITEOFFAMOUNT + DIFF END FROM ((SELECT FID,FCURRWRITEOFFAMOUNT,DIFF FROM T_CL_DevolveWriteOffRecord REDRECORD INNER JOIN {0} DIFFTEMP ON REDRECORD.FBILLENTRYID = DIFFTEMP.FENTRYID)  UNION ALL (SELECT MIN(ALLRECORD.FID) FID,ALLRECORD.FCURRWRITEOFFAMOUNT,DIFF FROM T_CL_DevolveWriteOffRecord REDRECORD INNER JOIN {0} DIFFTEMP ON REDRECORD.FBILLENTRYID = DIFFTEMP.FENTRYID INNER JOIN T_CL_DevolveWriteOffRecord ALLRECORD ON ALLRECORD.FPARENTID = REDRECORD.FPARENTID AND ALLRECORD.FGROUPNO = REDRECORD.FGROUPNO AND ALLRECORD.FCURRWRITEOFFQTY = ABS(REDRECORD.FCURRWRITEOFFQTY) GROUP BY ALLRECORD.FPARENTID,ALLRECORD.FGROUPNO,ALLRECORD.FCURRWRITEOFFAMOUNT,DIFF)) UPDATERECORD WHERE T1.FID = UPDATERECORD.FID)";
        CalculateParams result = new CalculateParams();
        String devInWarehsTempTable = null;
        String writeOffTempTable = null;
        String materialReqTempTable = null;
        String hasWriteOffMatReqTempTable = null;
        String inwarehsDiff = null;
        String minDiffRecord = null;
        String redInwarehsDiff = null;
        try {
            this.companyOrgID = params.getString("COMPANY_ID");
            CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
            try {
                companyOrgUnitInfo.setId(BOSUuid.read((String)this.companyOrgID));
            }
            catch (Exception e) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
            this.precision = CalculateUtil.getLocalCurrencyPrecision2(ctx, companyOrgUnitInfo);
            PeriodInfo periodInfo = null;
            periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            if (periodInfo == null) {
                throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{CalculateUtil.takeFormateDesc(companyOrgUnitInfo.getName(), companyOrgUnitInfo.getNumber())});
            }
            ICostAdjustBill costadjust = CostAdjustBillFactory.getLocalInstance(ctx);
            int currPeriod = periodInfo.getPeriodYear() * 100 + periodInfo.getPeriodNumber();
            ThreadLocalHelper.checkInterruptedForInCalc();
            if (CheckVoucherUtil.isCheckVoucherAndCal((Context)ctx)) {
                IRowSet rs1 = CheckVoucherUtil.checkGenVoucher((Context)ctx, (String)this.companyOrgID, (boolean)false);
                if (rs1.size() > 0) {
                    StringBuffer msg = new StringBuffer();
                    while (rs1.next()) {
                        msg.append("\n").append(rs1.getString("fbilltype")).append(rs1.getString("fnumber")).append(",").append(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"operatorInfo", (Locale)ctx.getLocale())).append(rs1.getString("fuser"));
                    }
                    throw new CalculateException(CalculateException.IS_GEN_VOUCHER_EXCEPTION, new Object[]{msg});
                }
                EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"insertGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, List.class, String.class, String.class, String.class}, (Object[])new Object[]{ctx, this.companyOrgID, null, null, null, ctx.getUserName(), "DevolveCostCalculate"}, (int)3);
            }
            devInWarehsTempTable = DBUtil.createTempTable(ctx, "INWAREHSBILL", this.getInWarehsTableField());
            DBUtil.createTempTableIndex(ctx, devInWarehsTempTable, "FEntryId", true);
            String filter = this.getFilterByParams(params);
            String sSQL = MessageFormat.format(INSERT_INWAREHSBILL_SQL, devInWarehsTempTable, filter);
            logger.debug((Object)("\u6839\u636e\u754c\u9762\u8fc7\u6ee4\u6761\u4ef6\u67e5\u8be2\u59d4\u5916\u5165\u5e93\u5355: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            ThreadLocalHelper.checkInterruptedForInCalc();
            writeOffTempTable = DBUtil.createTempTable(ctx, "WRITEOFFRECORD", this.getWriteOffRecordField());
            sSQL = MessageFormat.format(GET_WRITEOFF_RECORD_SQL, writeOffTempTable, devInWarehsTempTable);
            logger.debug((Object)("\u6839\u636e\u8fc7\u6ee4\u51fa\u7684\u59d4\u5916\u5165\u5e93\u5355\u67e5\u627e\u6838\u9500\u8bb0\u5f55: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            materialReqTempTable = DBUtil.createTempTable(ctx, "MATERIALREQBILL", this.getMatReqTableField());
            DBUtil.createTempTableIndex(ctx, materialReqTempTable, "FEntryId, FInWarehsEntryId", false);
            sSQL = MessageFormat.format(GET_MATREQBILL_SQL, materialReqTempTable, writeOffTempTable, "104");
            logger.debug((Object)("\u6839\u636e\u6838\u9500\u7ec4\uff29\uff24\u548c\u5206\u7ec4\u7f16\u7801\u67e5\u627e\u53d1\u6599\u5355\u6838\u9500\u4fe1\u606f: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(UPDATE_CURWRITEOFFAMOUNT_SQL, devInWarehsTempTable, materialReqTempTable);
            logger.debug((Object)("\u7528\u8ba1\u7b97\u7684\u53d1\u6599\u5355\u6210\u672c\u66f4\u65b0\u5165\u5e93\u5355\u7684\u672c\u6b21\u6838\u9500\u91d1\u989d: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(UPDATE_WRITEOFF_RECORD_SQL, writeOffTempTable, devInWarehsTempTable);
            logger.debug((Object)("\u66f4\u65b0\u6838\u9500\u8bb0\u5f55\u662f\u5426\u4e0e\u6750\u6599\u6838\u9500\u6807\u8bb0 \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(UPDATE_CURRWRITEOFFQTY_SQL1, devInWarehsTempTable, writeOffTempTable);
            logger.debug((Object)("\u66f4\u65b0\u6309\u6750\u6599\u6838\u9500\u7684\u5165\u5e93\u5355\u672c\u6b21\u6838\u9500\u6570\u91cf: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(UPDATE_CURRWRITEOFFQTY_SQL2, devInWarehsTempTable, writeOffTempTable);
            logger.debug((Object)("\u66f4\u65b0\u7ea2\u84dd\u6838\u9500\u7684\u5165\u5e93\u5355\u672c\u6b21\u6838\u9500\u6570\u91cf: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            ThreadLocalHelper.checkInterruptedForInCalc();
            sSQL = MessageFormat.format(UPDATE_MATERIALCOST_SQL, devInWarehsTempTable, String.valueOf(this.precision));
            logger.debug((Object)("\u66f4\u65b0\u5165\u5e93\u5355\u5355\u4f4d\u6750\u6599\u6210\u672c\u548c\u6750\u6599\u6210\u672c: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(REWRITE_INWAREHSBILL_SQL, devInWarehsTempTable, String.valueOf(currPeriod));
            logger.debug((Object)("\u53cd\u5199\u66f4\u65b0\u84dd\u5355(\u66f4\u65b0\u6761\u4ef6\uff1a\u672c\u671f\u6216\u4ee5\u540e\u671f\u95f4 && \u6ca1\u6709\u751f\u6210\u51ed\u8bc1): \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(GET_UPDATE_REDINWAREHSBILL_SQL_1, devInWarehsTempTable, String.valueOf(this.precision));
            logger.debug((Object)("\u901a\u8fc7\u6838\u9500\u5173\u7cfb\u66f4\u65b0\u7ea2\u84dd\u6838\u9500\u8bb0\u5f55\u5355\u4f4d\u6750\u6599\u6210\u672c: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(GET_UPDATE_REDINWAREHSBILL_SQL_2, devInWarehsTempTable, String.valueOf(this.precision));
            logger.debug((Object)("\u901a\u8fc7\u5173\u8054\u5173\u7cfb\u66f4\u65b0\u7ea2\u84dd\u6838\u9500\u8bb0\u5f55\u5355\u4f4d\u6750\u6599\u6210\u672c: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(GET_UPDATE_REDINWAREHSBILL_SQL_3, devInWarehsTempTable, String.valueOf(this.precision));
            logger.debug((Object)("\u901a\u8fc7\u6838\u5fc3\u5355\u5173\u7cfb\u66f4\u65b0\u7ea2\u84dd\u6838\u9500\u8bb0\u5f55\u5355\u4f4d\u6750\u6599\u6210\u672c: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(UPDATE_INP_RECORD_CURRAMOUNT_RB, devInWarehsTempTable, String.valueOf(this.precision));
            logger.debug((Object)("\u66f4\u65b0\u6838\u9500\u8bb0\u5f55\u4e0a\u5165\u5e93\u5355\u7684\u672c\u6b21\u6838\u9500\u91d1\u989d(\u7ea2\u84dd\u6838\u9500): \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(UPDATE_INP_RECORD_CURRAMOUNT_MAT, materialReqTempTable, "103");
            logger.debug((Object)("\u66f4\u65b0\u6838\u9500\u8bb0\u5f55\u4e0a\u5165\u5e93\u5355\u7684\u672c\u6b21\u6838\u9500\u91d1\u989d(\u6750\u6599\u6838\u9500\u518d\u6839\u636e\u53d1\u6599\u4fe1\u606f\u66f4\u65b0\u4e00\u6b21\uff0c\u540c\u4e00\u7ec4\u7684\u6570\u636e\u8981\u4fdd\u8bc1\u91d1\u989d\u76f8\u7b49\uff0c\u5c3e\u5dee\u4e5f\u4e0d\u80fd\u5904\u7406\u5728\u6750\u6599\u6838\u9500\u4e0a): \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(REWRITE_RED_INWAREHSBILL_SQL, devInWarehsTempTable, String.valueOf(currPeriod));
            logger.debug((Object)("\u53cd\u5199\u66f4\u65b0\u7ea2\u5355(\u66f4\u65b0\u6761\u4ef6\uff1a\u672c\u671f\u6216\u4ee5\u540e\u671f\u95f4 && \u6ca1\u6709\u751f\u6210\u51ed\u8bc1): \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            ThreadLocalHelper.checkInterruptedForInCalc();
            inwarehsDiff = DBUtil.createTempTable(ctx, "INWAREHSDIFF", this.getInwarehsDiffTableField());
            DBUtil.createTempTableIndex(ctx, inwarehsDiff, "FEntryId", false);
            sSQL = MessageFormat.format(GET_INWAREHS_DIFF_SQL, devInWarehsTempTable, inwarehsDiff);
            logger.debug((Object)("\u63d2\u5165\u5165\u5e93\u5355\u5206\u5f55\u5c3e\u5dee\u5230\u4e34\u65f6\u8868\uff08\u84dd\u5355id\uff0c\u5c3e\u5dee\u503c\uff09: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            minDiffRecord = DBUtil.createTempTable(ctx, "INWAREHSDIFF", this.getInwarehsDiffTableField());
            DBUtil.createTempTableIndex(ctx, inwarehsDiff, "FEntryId", false);
            sSQL = MessageFormat.format(GET_MIN_RECORD_SQL, inwarehsDiff, String.valueOf(currPeriod), minDiffRecord);
            logger.debug((Object)("\u6838\u9500\u8bb0\u5f55\u7ec4\u4e2d\u7edd\u5bf9\u503c\u6700\u5927\u7684\u7ea2\u5355\u8bb0\u5f55: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            redInwarehsDiff = DBUtil.createTempTable(ctx, "INWAREHSDIFF", this.getInwarehsDiffTableField());
            DBUtil.createTempTableIndex(ctx, inwarehsDiff, "FEntryId", false);
            sSQL = MessageFormat.format(GET_ADJUSTREDBILL_SQL, minDiffRecord, String.valueOf(currPeriod), redInwarehsDiff);
            logger.debug((Object)("\u628a\u5c3e\u5dee\u5904\u7406\u5728\u7edd\u5bf9\u503c\u6700\u5927\u7684\u7ea2\u5355\u4e0a\uff0c\u63d2\u5165\u7ea2\u5355\u4fe1\u606f\u5230\u4e34\u65f6\u8868\uff08\u7ea2\u5355id\uff0c\u5c3e\u5dee\u503c\uff09: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(UPDATE_REDBILLDIFF_SQL, redInwarehsDiff, devInWarehsTempTable);
            logger.debug((Object)("\u66f4\u65b0\u5355\u636e\u5c3e\u5dee\uff08\u5904\u7406\u5728\u7edd\u5bf9\u503c\u6700\u5927\u7684\u7ea2\u5355\u4e0a\uff09: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(UPDATE_REDWRITEOFFRECORD_SQL, redInwarehsDiff);
            logger.debug((Object)("\u66f4\u65b0\u5904\u7406\u5c3e\u5dee\u7684\u7ea2\u5355\u6240\u5728\u7684\u6838\u9500\u8bb0\u5f55\u7ec4: \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(UPDATE_ACTUALCOST_SQL, devInWarehsTempTable, String.valueOf(currPeriod));
            logger.debug((Object)("\u66f4\u65b0\u5b9e\u9645\u6210\u672c\uff0c\u5355\u4f4d\u5b9e\u9645\u6210\u672c(\u66f4\u65b0\u6761\u4ef6\uff1a\u672c\u671f\u6216\u4ee5\u540e\u671f\u95f4 && \u6ca1\u6709\u751f\u6210\u51ed\u8bc1): \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(UPDATE_TOTAL_ACTUALCOST_SQL, devInWarehsTempTable, String.valueOf(currPeriod));
            logger.debug((Object)("\u66f4\u65b0\u5355\u5934\u603b\u5b9e\u9645\u6210\u672c(\u66f4\u65b0\u6761\u4ef6\uff1a\u672c\u671f\u6216\u4ee5\u540e\u671f\u95f4 && \u6ca1\u6709\u751f\u6210\u51ed\u8bc1): \n" + sSQL));
            DBUtil.execute((Context)ctx, (String)sSQL);
            ThreadLocalHelper.checkInterruptedForInCalc();
            sSQL = MessageFormat.format(CHECK_BEFORE_ADCOST_SQL, devInWarehsTempTable, String.valueOf(8));
            logger.debug((Object)("\u83b7\u53d6\u4ee5\u524d\u521b\u5efa\u7c7b\u578b\u4e3a8\u7684\u6210\u672c\u8c03\u6574\u5355ID: \n" + sSQL));
            IRowSet checkRS = DBUtil.executeQuery((Context)ctx, (String)sSQL);
            StringBuffer voucheredNumber = new StringBuffer();
            while (checkRS.next()) {
                if (voucheredNumber.length() > 0) {
                    voucheredNumber.append(",");
                }
                voucheredNumber.append(checkRS.getString("fnumber"));
            }
            SQLUtils.cleanup((ResultSet)checkRS);
            if (voucheredNumber.length() > 0) {
                throw new CalculateException(CalculateException.COST_IS_VOUCHERED, new String[]{voucheredNumber.toString()});
            }
            sSQL = MessageFormat.format(GET_DELETE_BEFORE_ADCOST_SQL, devInWarehsTempTable, String.valueOf(8));
            IRowSet delRS = DBUtil.executeQuery((Context)ctx, (String)sSQL);
            ObjectUuidPK costID = null;
            while (delRS.next()) {
                costID = new ObjectUuidPK(delRS.getString("fid"));
                costadjust.unAudit((IObjectPK)costID);
                costadjust.delete((IObjectPK)costID);
            }
            SQLUtils.cleanup((ResultSet)delRS);
            sSQL = MessageFormat.format(GET_ADJUSTCOST_BILL_SQL, devInWarehsTempTable, String.valueOf(currPeriod));
            logger.debug((Object)("\u67e5\u8be2\u9700\u8981\u751f\u6210\u6210\u672c\u8c03\u6574\u5355\u7684\u59d4\u5916\u5165\u5e93\u5355: \n" + sSQL));
            IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sSQL);
            logger.debug((Object)"\u751f\u6210\u6210\u672c\u8c03\u6574\u5355");
            ArrayList billList = new ArrayList();
            while (rowSet.next()) {
                CostAdjustBillInfo bill = this.createAdCostBill(ctx, periodInfo, billList, rowSet);
                this.createAdCostBillEntry(rowSet, bill);
            }
            SQLUtils.cleanup((ResultSet)rowSet);
            logger.debug((Object)"\u4fdd\u5b58\u5e76\u5ba1\u6838\u6210\u672c\u8c03\u6574\u5355");
            for (int i = 0; i < billList.size(); ++i) {
                CostAdjustBillInfo costInfo = (CostAdjustBillInfo)billList.get(i);
                if (costInfo.getEntry().size() <= 0) continue;
                IObjectPK id = costadjust.addnew((CoreBaseInfo)costInfo);
                costadjust.audit(id);
            }
            logger.debug((Object)"\u59d4\u5916\u6210\u672c\u6838\u7b97\u5b8c\u6210");
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                if (!params.getBoolean("ONE_KEY_CALC")) {
                    if (e instanceof EASBizException) {
                        throw (EASBizException)((Object)e);
                    }
                    throw new BOSException((Throwable)e);
                }
                result.setObject("calcException", (Object)e);
            }
            catch (Throwable throwable) {
                DBUtil.releaseTempTable(ctx, devInWarehsTempTable);
                DBUtil.releaseTempTable(ctx, writeOffTempTable);
                DBUtil.releaseTempTable(ctx, materialReqTempTable);
                DBUtil.releaseTempTable(ctx, inwarehsDiff);
                DBUtil.releaseTempTable(ctx, redInwarehsDiff);
                DBUtil.releaseTempTable(ctx, minDiffRecord);
                DBUtil.releaseTempTable(ctx, hasWriteOffMatReqTempTable);
                EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, this.companyOrgID, null, "DevolveCostCalculate"}, (int)3);
                throw throwable;
            }
            DBUtil.releaseTempTable(ctx, devInWarehsTempTable);
            DBUtil.releaseTempTable(ctx, writeOffTempTable);
            DBUtil.releaseTempTable(ctx, materialReqTempTable);
            DBUtil.releaseTempTable(ctx, inwarehsDiff);
            DBUtil.releaseTempTable(ctx, redInwarehsDiff);
            DBUtil.releaseTempTable(ctx, minDiffRecord);
            DBUtil.releaseTempTable(ctx, hasWriteOffMatReqTempTable);
            EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, this.companyOrgID, null, "DevolveCostCalculate"}, (int)3);
        }
        DBUtil.releaseTempTable(ctx, devInWarehsTempTable);
        DBUtil.releaseTempTable(ctx, writeOffTempTable);
        DBUtil.releaseTempTable(ctx, materialReqTempTable);
        DBUtil.releaseTempTable(ctx, inwarehsDiff);
        DBUtil.releaseTempTable(ctx, redInwarehsDiff);
        DBUtil.releaseTempTable(ctx, minDiffRecord);
        DBUtil.releaseTempTable(ctx, hasWriteOffMatReqTempTable);
        EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, this.companyOrgID, null, "DevolveCostCalculate"}, (int)3);
        return result;
    }

    private CostAdjustBillInfo createAdCostBill(Context ctx, PeriodInfo periodInfo, List billList, IRowSet rowSet) throws SQLException {
        CostAdjustBillInfo costBill = null;
        for (int i = 0; i < billList.size(); ++i) {
            costBill = (CostAdjustBillInfo)billList.get(i);
            if (!costBill.getSourceBillId().equals(rowSet.getString("FParentId"))) continue;
            return costBill;
        }
        costBill = new CostAdjustBillInfo();
        costBill.setId(BOSUuid.create((BOSObjectType)costBill.getBOSType()));
        costBill.setNumber(String.valueOf(System.currentTimeMillis()));
        costBill.setIssueType(IssueTypeEnum.NULL);
        costBill.setCreateType(CostAdjuestCreateTypeEnum.DEVOLVE_COST_CALC);
        costBill.setCalculateKind(CalculateKindEnum.INPUT_WAREHOUSE);
        SupplierInfo supplier = null;
        String supplierId = rowSet.getString("FSupplierId");
        if (supplierId != null) {
            supplier = new SupplierInfo();
            supplier.setId(BOSUuid.read((String)supplierId));
        }
        costBill.setSupplier(supplier);
        StorageOrgUnitInfo storage = null;
        String storageId = rowSet.getString("FStorageOrgUnitId");
        if (storageId != null) {
            storage = new StorageOrgUnitInfo();
            storage.setId(BOSUuid.read((String)storageId));
        }
        costBill.setStorageOrgUnit(storage);
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552"));
        costBill.setBillType(billType);
        BillTypeInfo sourceBillType = null;
        String billTypeId = rowSet.getString("FBillTypeId");
        if (billTypeId != null) {
            sourceBillType = new BillTypeInfo();
            sourceBillType.setId(BOSUuid.read((String)billTypeId));
        }
        costBill.setSourceBillType(sourceBillType);
        AdminOrgUnitInfo adminOrg = null;
        String adminOrgId = rowSet.getString("FAdminOrgUnitId");
        if (adminOrgId != null) {
            adminOrg = new AdminOrgUnitInfo();
            adminOrg.setId(BOSUuid.read((String)adminOrgId));
        }
        costBill.setAdminOrgUnit(adminOrg);
        CostCenterOrgUnitInfo costCenter = null;
        String costCenterId = rowSet.getString("FCostCenterOrgUnitId");
        if (costCenterId != null) {
            costCenter = new CostCenterOrgUnitInfo();
            costCenter.setId(BOSUuid.read((String)costCenterId));
        }
        costBill.setCostCenterOrgUnit(costCenter);
        costBill.setYear(periodInfo.getPeriodYear());
        costBill.setPeriod(periodInfo.getPeriodNumber());
        costBill.setBizDate(periodInfo.getBeginDate());
        costBill.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        costBill.setCreateTime(new Timestamp(System.currentTimeMillis()));
        costBill.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        costBill.setAuditTime(new Timestamp(System.currentTimeMillis()));
        costBill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        costBill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        costBill.setSourceBillId(rowSet.getString("FParentId"));
        billList.add(costBill);
        return costBill;
    }

    private void createAdCostBillEntry(IRowSet rowSet, CostAdjustBillInfo costBillInfo) throws SQLException {
        BigDecimal inWarehsWriteOffAmount = rowSet.getBigDecimal("FMaterialCost");
        BigDecimal diffAmount = rowSet.getBigDecimal("FCurrWriteOffAmount").subtract(inWarehsWriteOffAmount);
        if (diffAmount.compareTo(CalculateUtil.ZERO) != 0) {
            CostAdjustBillEntryInfo costBillEntryInfo = new CostAdjustBillEntryInfo();
            costBillEntryInfo.setId(BOSUuid.create((BOSObjectType)costBillEntryInfo.getBOSType()));
            costBillEntryInfo.setParent(costBillInfo);
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)this.companyOrgID));
            costBillEntryInfo.setCompanyOrgUnit(company);
            StorageOrgUnitInfo storage = null;
            String storageId = rowSet.getString("FStorageOrgUnitId");
            if (storageId != null) {
                storage = new StorageOrgUnitInfo();
                storage.setId(BOSUuid.read((String)storageId));
            }
            costBillEntryInfo.setStorageOrgUnit(storage);
            WarehouseInfo warehouse = null;
            String warehouseId = rowSet.getString("FWarehouseId");
            if (warehouseId != null) {
                warehouse = new WarehouseInfo();
                warehouse.setId(BOSUuid.read((String)warehouseId));
            }
            costBillEntryInfo.setWarehouse(warehouse);
            LocationInfo location = null;
            String locationId = rowSet.getString("FLocationid");
            if (locationId != null) {
                location = new LocationInfo();
                location.setId(BOSUuid.read((String)locationId));
            }
            costBillEntryInfo.setLocation(location);
            MaterialInfo material = null;
            String materialId = rowSet.getString("FMaterialId");
            if (materialId != null) {
                material = new MaterialInfo();
                material.setId(BOSUuid.read((String)materialId));
            }
            costBillEntryInfo.setMaterial(material);
            MeasureUnitInfo baseUnit = null;
            String baseUnitId = rowSet.getString("FBaseUnitId");
            if (baseUnitId != null) {
                baseUnit = new MeasureUnitInfo();
                baseUnit.setId(BOSUuid.read((String)baseUnitId));
            }
            costBillEntryInfo.setBaseUnit(baseUnit);
            costBillEntryInfo.setUnit(baseUnit);
            AsstAttrValueInfo assistProperty = null;
            String assistPropertyId = rowSet.getString("FAssistPropertyID");
            if (assistPropertyId != null) {
                assistProperty = new AsstAttrValueInfo();
                assistProperty.setId(BOSUuid.read((String)assistPropertyId));
            }
            costBillEntryInfo.setAssistProperty(assistProperty);
            ProjectInfo project = null;
            String projectId = rowSet.getString("FProjectID");
            if (projectId != null) {
                project = new ProjectInfo();
                project.setId(BOSUuid.read((String)projectId));
            }
            costBillEntryInfo.setProject(project);
            TrackNumberInfo trackNumber = null;
            String trackNumberId = rowSet.getString("FTrackNumberID");
            if (trackNumberId != null) {
                trackNumber = new TrackNumberInfo();
                trackNumber.setId(BOSUuid.read((String)trackNumberId));
            }
            costBillEntryInfo.setTrackNumber(trackNumber);
            StoreTypeInfo storeType = new StoreTypeInfo();
            storeType.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-0111c0a812fd97D461A6"));
            costBillEntryInfo.setStoreType(storeType);
            StoreStateInfo storeState = new StoreStateInfo();
            storeState.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
            costBillEntryInfo.setStoreStatus(storeState);
            costBillEntryInfo.setLot(rowSet.getString("FLot"));
            costBillEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            costBillEntryInfo.setSourceBillId(rowSet.getString("FParentId"));
            costBillEntryInfo.setSourceBillEntryId(rowSet.getString("FId"));
            costBillEntryInfo.setSourceBillNumber(rowSet.getString("FNumber"));
            costBillEntryInfo.setSourceBillEntrySeq(rowSet.getInt("FSeq"));
            costBillEntryInfo.setBaseQty(new BigDecimal("0.0"));
            costBillEntryInfo.setAmount(diffAmount);
            costBillEntryInfo.setStandardCost(diffAmount);
            costBillEntryInfo.setActualCost(diffAmount);
            costBillEntryInfo.setBizDate(costBillInfo.getBizDate());
            costBillInfo.getEntry().add(costBillEntryInfo);
        }
    }

    private String getFilterByParams(CalculateParams params) {
        String materialSet;
        String materialIdTo;
        String materialIdFrom;
        Set idSet;
        if (params.getBoolean("ONE_KEY_CALC")) {
            return params.getString("EXT_SQL");
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entry.FCompanyOrgUnitId", (Object)this.companyOrgID));
        int beginPeriod = params.getInt("PERIOD_FROM");
        int endPeriod = params.getInt("PERIOD_TO");
        filter.getFilterItems().add(new FilterItemInfo("bill.FYear*100 + bill.FPeriod", (Object)new Integer(beginPeriod), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bill.FYear*100 + bill.FPeriod", (Object)new Integer(endPeriod), CompareType.LESS_EQUALS));
        String storageId = params.getString("STORAGEORGUNITID");
        if (storageId != null && storageId.length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("bill.FStorageOrgUnitId", (Object)storageId));
        }
        if ((idSet = (Set)params.getObject("WAREHOUSEID")) != null && idSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("entry.FWarehouseId", (Object)idSet, CompareType.INCLUDE));
        }
        if ((materialIdFrom = params.getString("MATERIAL_ID_FROM")) != null) {
            filter.getFilterItems().add(new FilterItemInfo("material.FNumber", (Object)materialIdFrom, CompareType.GREATER_EQUALS));
        }
        if ((materialIdTo = params.getString("MATERIAL_ID_TO")) != null) {
            filter.getFilterItems().add(new FilterItemInfo("material.FNumber", (Object)materialIdTo, CompareType.LESS_EQUALS));
        }
        if ((idSet = (Set)params.getObject("BILL_ID")) != null && idSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("bill.FID", (Object)idSet, CompareType.INCLUDE));
        }
        if ((idSet = (Set)params.getObject("ENTRY_ID")) != null && idSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("entry.FID", (Object)idSet, CompareType.INCLUDE));
        }
        if (null != (materialSet = params.getString("COSTMATERIAL_ID_SET"))) {
            filter.getFilterItems().add(new FilterItemInfo("material.FNumber", (Object)materialSet, CompareType.INCLUDE));
        }
        return filter.toString();
    }

    public String[][] getInWarehsTableField() {
        String[][] fields = new String[][]{{"FBillId", "varchar(44)"}, {"FEntryId", "varchar(44)"}, {"FNumber", "varchar(255)"}, {"FBillTypeId", "varchar(44)"}, {"FSupplierId", "varchar(44)"}, {"FBizDate", "DateTime"}, {"FYear", "int"}, {"FPeriod", "int"}, {"FMaterialId", "varchar(44)"}, {"FPricePrecision", "int"}, {"FQty", "Numeric(21, 8)"}, {"FReverseQty", "Numeric(21, 8)"}, {"FCurrWriteOffQty", "Numeric(21, 8)"}, {"FCurrWriteOffAmount", "Numeric(17, 4)"}, {"FUnitMaterialCost", "Numeric(21, 8)"}, {"FMaterialCost", "Numeric(17, 4)"}, {"FFivouchered", "int"}, {"fcoreBillEntryId", "varchar(44)"}};
        return fields;
    }

    public String[][] getWriteOffRecordField() {
        String[][] fields = new String[][]{{"FKEY", "varchar(44)"}, {"FID", "varchar(44)"}, {"FEntryId", "varchar(44)"}, {"FGroupNO", "int"}, {"FCurrWriteOffQty", "Numeric(21, 8)"}, {"FIsDevolveMatReq", "int"}};
        return fields;
    }

    public String[][] getMatReqTableField() {
        String[][] fields = new String[][]{{"FID", "varchar(44)"}, {"FBillId", "varchar(44)"}, {"FEntryId", "varchar(44)"}, {"FUnitActualCost", "Numeric(21, 8)"}, {"FActualCost", "Numeric(17, 4)"}, {"FCurrWriteOffQty", "Numeric(21, 8)"}, {"FCurrWriteOffAmount", "Numeric(17, 4)"}, {"FBillUnWriteOffBaseQty", "Numeric(21, 8)"}, {"FInWarehsEntryId", "varchar(44)"}, {"fcoreBillEntryId", "varchar(44)"}, {"FWriteOffGroupId", "varchar(44)"}, {"FGroupNO", "int"}};
        return fields;
    }

    public String[][] getHasWriteOffTableField() {
        String[][] fields = new String[][]{{"FEntryId", "varchar(44)"}, {"FCurrWriteOffAmount", "Numeric(17, 4)"}};
        return fields;
    }

    public String[][] getInwarehsDiffTableField() {
        String[][] fields = new String[][]{{"FEntryId", "varchar(44)"}, {"diff", "Numeric(17, 4)"}, {"fqty", "Numeric(17, 4)"}};
        return fields;
    }
}

