/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgFactory;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgInfo;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.DevolveCostCalculateFacadeFactory;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Locale;

public class DevolveCostCalculateJobHandler
implements IJobHandler {
    private static final long serialVersionUID = 1L;
    private static final String res = "com.kingdee.eas.basedata.common.perf.PerfResource";
    private static Locale locale = null;

    public Object execute(Job job) throws Exception {
        Context ctx = null;
        MessageInfo info = null;
        try {
            ctx = job.getContext();
            JobParam jobParam = (JobParam)job.getParameters();
            CalculateParams params = (CalculateParams)jobParam.getBizParam();
            ctx.put((Object)"UserInfo", params.getObject("CURRENT_USER"));
            ctx.put((Object)OrgType.Company, params.getObject("CURRENT_COMPANY"));
            ctx.put((Object)OrgType.ControlUnit, params.getObject("CURRENT_CU"));
            ctx.put((Object)"SCM_JOB_INST_ID", (Object)jobParam.getJobId());
            ctx.setLocale(jobParam.getLocale());
            boolean isSendMsg = true;
            locale = ctx.getLocale();
            info = new MessageInfo();
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            info.setUserID(userId);
            info.setbizAction(params.getString("title"));
            info.setOrgNumber(params.getObject("CURRENT_COMPANY").toString() + "  (" + ((CompanyOrgUnitInfo)params.getObject("CURRENT_COMPANY")).getNumber() + ")");
            String jobNum = jobParam.getJobNumber();
            String oql = " where number = '" + jobNum + "'";
            PerfSepCfgInfo pfInfo = PerfSepCfgFactory.getLocalInstance((Context)ctx).getPerfSepCfgInfo(oql);
            if (pfInfo != null) {
                isSendMsg = pfInfo.isIsSendMsg();
            }
            info.setSendMsg(isSendMsg);
            try {
                DevolveCostCalculateFacadeFactory.getLocalInstance(ctx).costCalculate(params);
            }
            catch (EASBizException e) {
                info.setExecption(e.getMessage());
                info.setSuccessed(false);
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
                throw e;
            }
            catch (BOSException e1) {
                info.setExecption(e1.getMessage());
                info.setSuccessed(false);
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
                throw e1;
            }
            JobLog log = new JobLog(JobLog.Type.Info, params.getString("title") + this.getResource("SUCCESS"));
            job.saveMessage(log);
            info.setSuccessed(true);
            MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
        }
        catch (Exception ex) {
            info.setExecption(ex.getMessage());
            info.setSuccessed(false);
            MessageUtil.sendMsg((Context)ctx, info);
            throw ex;
        }
        finally {
            PerfSepServerUtils.updateTaskState((Job)job);
        }
        return Boolean.TRUE;
    }

    private String getResource(String resName) {
        return ResourceBase.getString((String)res, (String)resName, (Locale)locale);
    }
}

