/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.ManualWriteOffException;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.AbstractExceptionBalanceReportFacadeControllerBean;
import com.kingdee.eas.scm.cal.app.help.CostAdjustHelp;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExceptionBalanceReportFacadeControllerBean
extends AbstractExceptionBalanceReportFacadeControllerBean {
    private static final long serialVersionUID = -2720741029307464639L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.ExceptionBalanceReportFacadeControllerBean");
    public final String resource = "com.kingdee.eas.scm.cal.CalCommonResource";
    private static final String tempTableMark = "tempTable";
    protected boolean isAutoGenVoucher = false;
    private int count = 1;

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TMP.FID,");
        sql.append("  '' AS SELECTED,");
        sql.append("  TMP.FISISSEBILL,");
        sql.append("  TMP.FYEAR,");
        sql.append("  TMP.FPERIOD,");
        sql.append("  TMP.FSTORAGEORGUNITNAME,");
        sql.append("  TMP.FASSTATTRVALUENAME,");
        sql.append("  TMP.FWAREHOUSENAME,");
        sql.append("  TMP.FLOCATIONNAME,");
        sql.append("  TMP.FMATERIALID,");
        sql.append("  TMP.FMATERIALNUMBER,");
        sql.append("  TMP.FMATERIALNAME,");
        sql.append("  TMP.FSHORTNAME,");
        sql.append("  TMP.FMODEL,");
        sql.append("  TMP.FLOT,");
        sql.append("  TMP.FPROJECTNUMBER,");
        sql.append("  TMP.FTRACKNUMBERNUMBER,");
        sql.append("  TMP.FBALANCEQTY,");
        sql.append("  TMP.FBALANCECOST,");
        sql.append("  TMP.FADJUSTAMOUNT,");
        sql.append("  TMP.FSUMDIFFAMOUNT,");
        sql.append("  TMP.FSTORETYPENAME,");
        sql.append("  TMP.FSTORESTATENAME,");
        sql.append("  TMP.FCUSTOMERNAME,");
        sql.append(" N'" + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"OUTPUT_WAREHOUSE", (Context)ctx) + "' AS FOUTTYPE, ");
        sql.append(" N'" + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SALEISSUEBILL", (Context)ctx) + "' AS FOUTWARETPYE, ");
        sql.append("  TMP.FQTYPRECISION ");
        sql.append("FROM " + params.getString(tempTableMark) + " AS TMP ");
        sql.append(" ORDER BY TMP.FYEAR,TMP.FPERIOD,TMP.FMATERIALNUMBER,TMP.FSTORAGEORGUNITNAME,TMP.FWAREHOUSENAME,TMP.FLOT,TMP.FPROJECTNUMBER,TMP.FTRACKNUMBERNUMBER  ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString(tempTableMark), ctx);
        String tempTable = this.createTempTable(ctx, this.getCreateTempSql(params));
        int count = 0;
        String couId = params.getString("COMPANY_ID");
        boolean checkPermission = SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (String)couId, (String)"exceptionbalancereport_view");
        if (checkPermission) {
            String insertSql = this.getInsertTempSql(ctx, params, tempTable);
            this.executeUpdate(insertSql, null, ctx);
            DBUtil.createTempTableIndex(ctx, tempTable, "FYear,FPeriod", false);
            String countSql = "select count(1) from " + tempTable;
            RptRowSet rsCount = this.executeQuery(countSql, null, ctx);
            rsCount.next();
            count = rsCount.getInt(0);
        }
        RptTableHeader header = this.createTableHeader(ctx, params);
        RptParams result = new RptParams();
        result.setString(tempTableMark, tempTable);
        result.setObject("header", (Object)header);
        result.setInt("totalCount", count);
        return result;
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        return this._query(ctx, params, 0, -1);
    }

    private RptTableHeader createTableHeader(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("SELECTED");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FISISSUEBILL");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FYEAR");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FPERIOD");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FSTORAGEORGUNITNAME");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FASSTATTRVALUENAME");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FWAREHOUSENAME");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FLOCATIONNAME");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FNUMBER");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FMATERIALNAME");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FMODE");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FLOT");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FPROJECTNUMBER");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FTRACKNUMBERNUMBER");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FPERIODBEGINBALANCE");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FADJUSTAMOUNT");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FADJUSTAMOUNT");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FDIFFAMOUNT");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FSTORETYPENAME");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FSTORESTATENAME");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FCUSTOMERNAME");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FOUTTYPE");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("FOUTWARETPYE");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("FQTYPRECISION");
        col.setWidth(0);
        header.addColumn(col);
        header.setLabels((Object[][])new Object[][]{{""}, {""}}, false);
        return header;
    }

    private String getInsertTempSql(Context ctx, RptParams params, String tempTable) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable + "(" + this.getInserTempFields(params));
        sql.append(")\r\n");
        sql.append(this.getSQLInvBill(ctx, params));
        return sql.toString();
    }

    private String getInserTempFields(RptParams pp) {
        StringBuffer sql = new StringBuffer();
        sql.append(" FID,");
        sql.append(" FISISSEBILL,");
        sql.append(" FYEAR,");
        sql.append(" FPERIOD,");
        sql.append(" FSTORAGEORGUNITID,");
        sql.append(" FSTORAGEORGUNITNAME,");
        sql.append(" FWAREHOUSEID,");
        sql.append(" FWAREHOUSENAME,");
        sql.append(" FLOCATIONID,");
        sql.append(" FLOCATIONNAME,");
        sql.append(" FASSTATTRVALUENAME,");
        sql.append(" FMATERIALID,");
        sql.append(" FSTORETYPEID,");
        sql.append(" FSTORESTATEID,");
        sql.append(" FSUPPLIERID,");
        sql.append(" FMATERIALNUMBER,");
        sql.append(" FMATERIALNAME,");
        sql.append(" FSHORTNAME,");
        sql.append(" FMODEL,");
        sql.append(" FLOT,");
        sql.append(" FPROJECTNUMBER,");
        sql.append(" FTRACKNUMBERNUMBER,");
        sql.append(" FBALANCEQTY,");
        sql.append(" FBALANCECOST,");
        sql.append(" FADJUSTAMOUNT,");
        sql.append(" FSUMDIFFAMOUNT,");
        sql.append(" FSTORETYPENAME,");
        sql.append(" FSTORESTATENAME,");
        sql.append(" FCUSTOMERNAME,");
        sql.append(" FQTYPRECISION");
        return sql.toString();
    }

    private String getCreateTempSql(RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create TABLE TEMPREPORTTABLE \r\n");
        sql.append("(FID VARCHAR(44)   , \r\n");
        sql.append("FISISSEBILL INT,\r\n");
        sql.append("FYEAR INT, \r\n");
        sql.append("FPERIOD INT, \r\n");
        sql.append("FSTORAGEORGUNITID VARCHAR(44), \r\n");
        sql.append("FSTORAGEORGUNITNAME VARCHAR(255), \r\n");
        sql.append("FASSTATTRVALUENAME NVARCHAR(255),\r\n");
        sql.append("FWAREHOUSEID NVARCHAR(44),\r\n");
        sql.append("FWAREHOUSENAME NVARCHAR(255),\r\n");
        sql.append("FLOCATIONID NVARCHAR(44),\r\n");
        sql.append("FLOCATIONNAME NVARCHAR(255),\r\n");
        sql.append("FMATERIALID NVARCHAR(44),\r\n");
        sql.append("FSTORESTATEID NVARCHAR(44),\r\n");
        sql.append("FSTORETYPEID NVARCHAR(44),\r\n");
        sql.append("FSUPPLIERID NVARCHAR(44),\r\n");
        sql.append("FMATERIALNUMBER NVARCHAR(80),\r\n");
        sql.append("FMATERIALNAME NVARCHAR(255),\r\n");
        sql.append("FSHORTNAME NVARCHAR(80),\r\n");
        sql.append("FMODEL NVARCHAR(255),\r\n");
        sql.append("FLOT NVARCHAR(255),\r\n");
        sql.append("FPROJECTNUMBER VARCHAR(80),\r\n");
        sql.append("FTRACKNUMBERNUMBER VARCHAR(256),\r\n");
        sql.append("FBALANCEQTY NUMERIC(28, 16),\r\n");
        sql.append("FBALANCECOST NUMERIC(19, 4),\r\n");
        sql.append("FADJUSTAMOUNT NUMERIC(19, 4),\r\n");
        sql.append("FSUMDIFFAMOUNT NUMERIC(19, 4),\r\n");
        sql.append("FSTORETYPENAME VARCHAR(255),\r\n");
        sql.append("FSTORESTATENAME VARCHAR(255),\r\n");
        sql.append("FCUSTOMERNAME VARCHAR(255),\r\n");
        sql.append("FQTYPRECISION INT )\r\n");
        return sql.toString();
    }

    private String getSQLInvBill(Context ctx, RptParams pp) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String midBalanceTable = this.createTempTable(ctx, this.createMidBalanceTable());
        String calRange = pp.getString("CALTYPE");
        if (StringUtil.isEmpty((String)calRange)) {
            calRange = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(pp.getString("COMPANY_ID")), "SCM_CAL_002");
        }
        pp.setString("calRange", calRange);
        this.insertIntoMidBalanceTable(ctx, midBalanceTable, pp);
        sql.append(" SELECT T1.* FROM ( ");
        sql.append(" SELECT MAX(FID) AS FID ");
        sql.append(" ,MAX(ISNULL(FISISSEBILL, 0)) AS ISISSUEBILL");
        sql.append(" ,FYEAR AS FYEAR ,FPERIOD AS FPERIOD ");
        if (1 == pp.getInt("sumType")) {
            if ("0".equals(calRange)) {
                sql.append(" ,'' AS FSTORAGEORGUNITID");
                sql.append(" ,'' AS FSTORAGEORGUNITNAME");
                sql.append(" ,'' AS FWAREHOUSEID");
                sql.append(" ,'' AS FWAREHOUSENAME");
            } else if ("1".equals(calRange)) {
                sql.append(" ,FSTORAGEORGUNITID");
                sql.append(" ,FSTORAGEORGUNITNAME");
                sql.append(" ,'' AS FWAREHOUSEID");
                sql.append(" ,'' AS FWAREHOUSENAME");
            } else if ("2".equals(calRange)) {
                sql.append(" ,FSTORAGEORGUNITID");
                sql.append(" ,FSTORAGEORGUNITNAME");
                sql.append(" ,FWAREHOUSEID");
                sql.append(" ,FWAREHOUSENAME");
            }
        } else {
            sql.append(" ,FSTORAGEORGUNITID");
            sql.append(" ,FSTORAGEORGUNITNAME");
            sql.append(" ,FWAREHOUSEID");
            sql.append(" ,FWAREHOUSENAME");
        }
        sql.append(" ,FLOCATIONID");
        sql.append(" ,FLOCATIONNAME");
        sql.append(" ,FASSTATTRVALUENAME");
        sql.append(" ,FMATERIALID ,FSTORETYPEID,FSTORESTATEID,FSUPPLIERID");
        sql.append(" ,FMATERIALNUMBER");
        sql.append(" ,FMATERIALNAME");
        sql.append(" ,FSHORTNAME");
        sql.append(" ,FMODEL");
        sql.append(" ,FLOT");
        sql.append(" ,FPROJECTNUMBER");
        sql.append(" ,FTRACKNUMBERNUMBER");
        sql.append(" ,SUM(FBALANCEQTY) AS FBALANCEQTY").append(",SUM(FBALANCECOST) AS FBALANCECOST");
        sql.append(" ,0.00 AS FADJUSTAMOUNT");
        sql.append(" ,(0 - SUM(FBALANCECOST)) AS FSUMDIFFAMOUNT");
        sql.append(" ,FSTORETYPENAME");
        sql.append(" ,FSTORESTATENAME");
        sql.append(" ,FCUSTOMERNAME");
        sql.append(" ,ISNULL(FQTYPRECISION,8) AS FQTYPRECISION");
        sql.append(" FROM ").append(midBalanceTable);
        sql.append(" GROUP BY FYEAR,FPERIOD");
        if (1 == pp.getInt("sumType")) {
            if ("1".equals(calRange)) {
                sql.append(",FSTORAGEORGUNITID ,FSTORAGEORGUNITNAME");
            } else if ("2".equals(calRange)) {
                sql.append(",FSTORAGEORGUNITID ,FSTORAGEORGUNITNAME");
                sql.append(",FWAREHOUSEID ,FWAREHOUSENAME");
            }
        } else {
            sql.append(" ,FSTORAGEORGUNITID,FSTORAGEORGUNITNAME");
            sql.append(" ,FWAREHOUSEID,FWAREHOUSENAME");
        }
        sql.append(" ,FLOCATIONID,FLOCATIONNAME");
        sql.append(" ,FASSTATTRVALUENAME");
        sql.append(" ,FMATERIALID ,FSTORETYPEID,FSTORESTATEID,FSUPPLIERID,FMATERIALNUMBER");
        sql.append(" ,FMATERIALNAME");
        sql.append(" ,FSHORTNAME  ,FMODEL, FLOT ,FPROJECTNUMBER  ,FTRACKNUMBERNUMBER");
        sql.append(" ,FSTORETYPENAME");
        sql.append(" ,FSTORESTATENAME");
        sql.append(" ,FCUSTOMERNAME");
        sql.append(" ,FQTYPRECISION ");
        sql.append(")  T1 WHERE 1 = 1 ");
        if (!pp.getBoolean("isShowAll")) {
            sql.append(" AND SIGN(T1.FBALANCEQTY) <> SIGN(T1.FBALANCECOST)");
        } else {
            sql.append(" AND (SIGN(T1.FBALANCEQTY) <> 0 OR  SIGN(T1.FBALANCECOST) <> 0)");
        }
        sql.append(this.getQtyAndAmountFilter(pp, "T1.FBALANCEQTY", "T1.FBALANCECOST"));
        sql.append(" ORDER BY T1.FYEAR,T1.FPERIOD,T1.FMATERIALNUMBER,T1.FSTORAGEORGUNITNAME,T1.FLOT,T1.FID  ");
        return sql.toString();
    }

    private void insertIntoMidBalanceTable(Context ctx, String midBalanceTable, RptParams pp) throws BOSException, EASBizException {
        String balanceQty = "FPeriodBeginQty";
        String balanceCost = "FPeriodBeginActualCost";
        if (pp.getBoolean("isPreCloseAccount")) {
            balanceQty = "FPeriodEndQty";
            balanceCost = "FPeriodEndActualCost";
        }
        String companyOrgId = pp.getString("COMPANY_ID");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("accountPeriodType.id");
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgId), selector);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(midBalanceTable).append("\n");
        sql.append("SELECT ENTRY.Fid, ENTRY.FIsIsseBill, ENTRY.FYear, ENTRY.FPeriod,ENTRY.FStorageOrgUnitID,ENTRY.FWareHouseID,").append("\n");
        sql.append("STORAGEORGUNIT.FName_").append(this.getLoc(ctx)).append(", WAREHOUSE.FName_").append(this.getLoc(ctx)).append("\n");
        sql.append(", ENTRY.FMaterialID, ENTRY.FSTORETYPEID, ENTRY.FSTORESTATUSID, ENTRY.FSUPPLIERID").append("\n");
        sql.append(",MATERIAL.FNumber, MATERIAL.FName_").append(this.getLoc(ctx)).append(", MATERIAL.FshortName, MATERIAL.FModel").append("\n");
        if (1 == pp.getInt("sumType")) {
            sql.append(",CASE WHEN MC.FACCOUNTTYPE = 5 AND MC.FISLOT = 1 THEN ENTRY.FLOT ELSE N'' END").append("\n");
            sql.append(",CASE WHEN MC.FACCOUNTTYPE = 5 AND MC.FISASSISTPROPERTY = 1 THEN ASSTATTRVALUE.FNAME_").append(this.getLoc(ctx)).append(" ELSE N'' END").append("\n");
            sql.append(",CASE WHEN MC.FACCOUNTTYPE = 5 AND MC.FISPROJECT = 1 THEN PROJECT.FNUMBER ELSE N'' END").append("\n");
            sql.append(",CASE WHEN MC.FACCOUNTTYPE = 5 AND MC.FISTRACKNUMBER = 1 THEN TRACKNUMBER.FNUMBER ELSE N'' END").append("\n");
            sql.append(",'' AS FLOCATIONID,'' AS FLOCATIONNAME,'' AS FCUSTOMERNAME");
        } else {
            sql.append(",ENTRY.FLOT,ASSTATTRVALUE.FNAME_").append(this.getLoc(ctx)).append(", PROJECT.FNUMBER, TRACKNUMBER.FNUMBER ").append("\n");
            sql.append(",ENTRY.FLocationID").append(",LOCATION.FName_").append(this.getLoc(ctx)).append(",CUSTOMER.FName_").append(this.getLoc(ctx));
        }
        sql.append(", ENTRY.").append(balanceQty).append(", ENTRY.").append(balanceCost);
        sql.append(", STORETYPE.FName_").append(this.getLoc(ctx)).append(", STORESTATE.FName_").append(this.getLoc(ctx)).append(", isnull(MMU.FQtyPrecision,8)").append("\n");
        sql.append(",MC.FACCOUNTTYPE");
        if (pp.getBoolean("isPreCloseAccount")) {
            sql.append(" FROM T_IM_PreInventoryBalance AS ENTRY");
        } else {
            sql.append(" FROM T_IM_InventoryBalance AS ENTRY");
        }
        sql.append(" INNER JOIN T_BD_Material AS MATERIAL");
        sql.append(" ON ENTRY.FMaterialID = MATERIAL.FID");
        sql.append(" INNER JOIN T_ORG_BaseUnit AS STORAGEORGUNIT ");
        sql.append(" ON ENTRY.FStorageOrgUnitID = STORAGEORGUNIT.FID");
        sql.append(" INNER JOIN T_DB_WAREHOUSE AS WAREHOUSE ");
        sql.append(" ON ENTRY.FWareHouseID = WAREHOUSE.FID");
        sql.append(" INNER JOIN T_BD_PERIOD p On ENTRY.FPERIOD = p.FPERIODNUMBER and ENTRY.FYEAR = p.FPERIODYEAR \r\n");
        sql.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSTATTRVALUE ON ENTRY.FAssistPropertyID = ASSTATTRVALUE.FID ");
        sql.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON ENTRY.FLocationID = LOCATION.FID ");
        sql.append(" LEFT OUTER JOIN T_IM_STORETYPE AS STORETYPE ON ENTRY.FStoreTypeID = STORETYPE.FID ");
        sql.append(" LEFT OUTER JOIN T_IM_STORESTATE AS STORESTATE ON ENTRY.FStoreStatusID = STORESTATE.FID ");
        sql.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON ENTRY.FCustomerID = CUSTOMER.FID ");
        sql.append(" Left OUTER JOIN T_BD_MATERIALCOMPANYINFO MC ON ENTRY.FMATERIALID = MC.FMATERIALID AND ENTRY.FCOMPANYORGUNITID = MC.FCOMPANYID ");
        sql.append(" LEFT OUTER JOIN T_MM_Project AS project ON ENTRY.FProjectID = project.FID ");
        sql.append(" LEFT OUTER JOIN T_MM_TrackNumber AS trackNumber ON ENTRY.FTrackNumberID = trackNumber.FID  ");
        sql.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MMU on MMU.FMaterialID = MATERIAL.FID AND MMU.FMeasureUnitID = MATERIAL.FBaseUnit ");
        sql.append("where");
        if (pp != null) {
            int i;
            sql.append(" ENTRY.FCompanyOrgUnitID = '").append(companyOrgId).append("'");
            if (pp.getInt("YEAR_FROM") == pp.getInt("YEAR_TO") && pp.getInt("PERIOD_FROM") == pp.getInt("PERIOD_TO")) {
                sql.append(" and ENTRY.FYear = ").append(pp.getInt("YEAR_FROM"));
                sql.append(" and ENTRY.FPeriod = ").append(pp.getInt("PERIOD_FROM"));
            } else if (pp.getInt("YEAR_FROM") == pp.getInt("YEAR_TO")) {
                sql.append(" and ENTRY.FYear = ").append(pp.getInt("YEAR_FROM"));
                sql.append(" and ENTRY.FPeriod >=").append(pp.getInt("PERIOD_FROM"));
                sql.append(" and ENTRY.FPeriod <=").append(pp.getInt("PERIOD_TO"));
            } else {
                sql.append(" and (ENTRY.FYear > ").append(pp.getInt("YEAR_FROM"));
                sql.append(" or (ENTRY.FYear = ").append(pp.getInt("YEAR_FROM"));
                sql.append(" and ENTRY.FPeriod >=").append(pp.getInt("PERIOD_FROM"));
                sql.append(" ))");
                sql.append(" and (ENTRY.FYear < ").append(pp.getInt("YEAR_TO"));
                sql.append(" or (ENTRY.FYear = ").append(pp.getInt("YEAR_TO"));
                sql.append(" and ENTRY.FPeriod <=").append(pp.getInt("PERIOD_TO"));
                sql.append(" ))");
            }
            sql.append(" and p.FTypeID = '" + company.getAccountPeriodType().getId().toString() + "' ");
            if (pp.getString("MATERIAL_FROM") != null && pp.getString("MATERIAL_FROM").length() != 0) {
                sql.append(" and MATERIAL.FNumber >= '").append(pp.getString("MATERIAL_FROM")).append("'");
            }
            if (pp.getString("MATERIAL_TO") != null && pp.getString("MATERIAL_TO").length() != 0) {
                sql.append(" and MATERIAL.FNumber <= '").append(pp.getString("MATERIAL_TO")).append("'");
            }
            if (pp.getString("MATERIAL_IN") != null && pp.getString("MATERIAL_IN").length() != 0) {
                sql.append(" and MATERIAL.FNumber in (").append(pp.getString("MATERIAL_IN")).append(")");
            }
            if (pp.getObject("STORAGEORGUNIT") != null) {
                StringBuffer inStorages = new StringBuffer(" and ENTRY.FSTORAGEORGUNITID in ('");
                Object[] storages = (Object[])pp.getObject("STORAGEORGUNIT");
                for (i = 0; i < storages.length; ++i) {
                    StorageOrgUnitInfo storage = (StorageOrgUnitInfo)storages[i];
                    inStorages.append(storage.getId().toString()).append("','");
                }
                inStorages.setLength(inStorages.length() - 2);
                inStorages.append(") ");
                sql.append(inStorages.toString());
            }
            if (pp.getObject("WAREHOUSE") != null) {
                StringBuffer inWarehs = new StringBuffer(" and ENTRY.FWAREHOUSEID in ('");
                Object[] warehouses = (Object[])pp.getObject("WAREHOUSE");
                for (i = 0; i < warehouses.length; ++i) {
                    WarehouseInfo warehs = (WarehouseInfo)warehouses[i];
                    inWarehs.append(warehs.getId().toString()).append("','");
                }
                inWarehs.setLength(inWarehs.length() - 2);
                inWarehs.append(") ");
                sql.append(inWarehs.toString());
            }
            if (pp.getInt("calcType") != 0) {
                sql.append(" and MC.FCALCULATETYPE = " + (pp.getInt("calcType") - 1));
            }
            sql.append(" and MC.FACCOUNTTYPE<>1");
            if (pp.getObject("costOutMark") != null) {
                Integer costOutMark = (Integer)pp.getObject("costOutMark");
                if (costOutMark == 1) {
                    sql.append(" and isnull(ENTRY.FISISSEBILL,0) = 1 ");
                } else if (costOutMark == 2) {
                    sql.append(" and isnull(ENTRY.FISISSEBILL,0) <> 1 ");
                }
            }
            if (!pp.getBoolean("ckShowNoCalculate")) {
                sql.append(" and ENTRY.FISCALCULATE = 1 ");
            }
        }
        sql.append(" AND STORETYPE.FIsForwardAmt = 1");
        if (pp.getInt("sumType") == 1) {
            if ("0".equals(pp.getString("calRange"))) {
                sql.append("\n AND ENTRY.FMOVETYPE = 0 ");
            } else if ("1".equals(pp.getString("calRange"))) {
                sql.append("\n AND ENTRY.FMOVETYPE <> 2 ");
            }
        }
        this.executeUpdate(sql.toString(), null, ctx);
    }

    private String createMidBalanceTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE TEMPREPORTTABLE \r\n");
        sql.append("(FID VARCHAR(44)   , ").append("\r\n");
        sql.append("FISISSEBILL INT,").append("\r\n");
        sql.append("FYEAR INT, ").append("\r\n");
        sql.append("FPERIOD INT, ").append("\r\n");
        sql.append("FSTORAGEORGUNITID VARCHAR(255), ").append("\r\n");
        sql.append("FWAREHOUSEID VARCHAR(255),").append("\r\n");
        sql.append("FSTORAGEORGUNITNAME NVARCHAR(255), ").append("\r\n");
        sql.append("FWAREHOUSENAME NVARCHAR(255),").append("\r\n");
        sql.append("FMATERIALID VARCHAR(44),").append("\r\n");
        sql.append("FSTORETYPEID VARCHAR(44),").append("\r\n");
        sql.append("FSTORESTATEID VARCHAR(44),").append("\r\n");
        sql.append("FSUPPLIERID VARCHAR(44),").append("\r\n");
        sql.append("FMATERIALNUMBER NVARCHAR(80),").append("\r\n");
        sql.append("FMATERIALNAME NVARCHAR(255),").append("\r\n");
        sql.append("FSHORTNAME NVARCHAR(80),").append("\r\n");
        sql.append("FMODEL NVARCHAR(255),").append("\r\n");
        sql.append("FLOT NVARCHAR(255),").append("\r\n");
        sql.append("FASSTATTRVALUENAME NVARCHAR(255),").append("\r\n");
        sql.append("FPROJECTNUMBER NVARCHAR(80),").append("\r\n");
        sql.append("FTRACKNUMBERNUMBER NVARCHAR(256),").append("\r\n");
        sql.append("FLOCATIONID VARCHAR(255),").append("\r\n");
        sql.append("FLOCATIONNAME NVARCHAR(255),").append("\r\n");
        sql.append("FCUSTOMERNAME NVARCHAR(255),").append("\r\n");
        sql.append("FBALANCEQTY NUMERIC(28, 16),").append("\r\n");
        sql.append("FBALANCECOST NUMERIC(19, 4),").append("\r\n");
        sql.append("FSTORETYPENAME NVARCHAR(255),").append("\r\n");
        sql.append("FSTORESTATENAME NVARCHAR(255),").append("\r\n");
        sql.append("FQTYPRECISION INT,").append("\r\n");
        sql.append("FACCOUNTTYPE INT)").append("\r\n");
        return sql.toString();
    }

    public String getQtyAndAmountFilter(RptParams pp, String fieldQty, String fieldAmount) {
        StringBuffer filterSql = new StringBuffer();
        if (pp.getInt("cbQty") != 0) {
            filterSql.append(" and ");
            if (pp.getInt("cbQty") == 1) {
                filterSql.append(fieldQty).append("  > 0 ");
            } else if (pp.getInt("cbQty") == 2) {
                filterSql.append(fieldQty).append("  = 0 ");
            } else if (pp.getInt("cbQty") == 3) {
                filterSql.append(fieldQty).append("  < 0 ");
            } else if (pp.getInt("cbQty") == 4) {
                filterSql.append(fieldQty).append("  != 0 ");
            }
        }
        if (pp.getInt("cbAmount") != 0) {
            filterSql.append(" AND ");
            if (pp.getInt("cbAmount") == 1) {
                filterSql.append(fieldAmount).append("  > 0 ");
            } else if (pp.getInt("cbAmount") == 2) {
                filterSql.append(fieldAmount).append("  = 0 ");
            } else if (pp.getInt("cbAmount") == 3) {
                filterSql.append(fieldAmount).append("  < 0 ");
            } else if (pp.getInt("cbAmount") == 4) {
                filterSql.append(fieldAmount).append("  != 0 ");
            }
        }
        return filterSql.toString();
    }

    private String getSQLForCostAdjBill(Context ctx, CalculateParams pp) throws BOSException, SQLException, CalculateException {
        boolean isEndAdjust = pp.getBoolean("isEndAdjust");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ");
        sql.append("  ENTRY.fid as Fid,ENTRY.FCompanyOrgUnitID as FCompanyOrgUnitID");
        sql.append(" ,ENTRY.FStorageOrgUnitID as Fstorageorgunitid");
        sql.append(" ,ENTRY.FWarehouseID as Fwarehouseid");
        sql.append(" ,ENTRY.FLocationID as FLocationID");
        sql.append(" ,ENTRY.FMaterialID as FMaterialId");
        sql.append(" ,MATERIAL.FBaseUnit as FBaseUnitId");
        sql.append(" ,ENTRY.FLot as FLot");
        sql.append(" ,ENTRY.FStoreTypeID as FStoreTypeID");
        sql.append(" ,ENTRY.FStoreStatusID as FStoreStatusID");
        sql.append(" ,ENTRY.FCustomerID as FCustomerID");
        sql.append(" ,ENTRY.FPeriodBeginQty as FBASEQTY");
        sql.append(" ,ENTRY.FPeriodBeginActualCost as FACTUALCOST");
        sql.append(" ,ENTRY.FAssistPropertyID as FAssistPropertyID");
        sql.append(" ,ENTRY.FProjectID as FProjectID");
        sql.append(" ,ENTRY.FTrackNumberID as FTrackNumberID");
        sql.append(" ,ENTRY.FSUPPLIERID as FSUPPLIERID");
        if (isEndAdjust) {
            sql.append(" FROM T_IM_PreInventoryBalance AS ENTRY");
        } else {
            sql.append(" FROM T_IM_InventoryBalance AS ENTRY");
        }
        sql.append(" INNER JOIN T_BD_Material AS MATERIAL ON ENTRY.FMaterialID = MATERIAL.FID");
        sql.append(" LEFT OUTER JOIN T_IM_STORETYPE AS STORETYPE ON ENTRY.FStoreTypeID = STORETYPE.FID ");
        sql.append(" WHERE 1=1 ");
        if (pp.getObject("globalList") != null) {
            ArrayList globalList = (ArrayList)pp.getObject("globalList");
            StringBuffer ids = new StringBuffer();
            ArrayList list = null;
            String fid = null;
            for (int n = 0; globalList != null && n < globalList.size(); ++n) {
                list = (ArrayList)globalList.get(n);
                fid = (String)list.get(0);
                if (n != 0) {
                    ids.append(",");
                }
                ids.append("'").append(fid).append("'");
            }
            if (ids.length() > 0) {
                if (globalList.size() > 500) {
                    ids = this.getTempTableForId(ctx, ids, pp);
                }
                if (isEndAdjust) {
                    this.checkExistsPreData(ctx, ids);
                }
                sql.append(" and ENTRY.fid IN (" + ids + ")");
            }
        }
        sql.append(" order by ENTRY.FYear,ENTRY.FPeriod,ENTRY.FMaterialID ");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getTempTableForId(Context ctx, StringBuffer ids, CalculateParams pp) throws BOSException, SQLException {
        StringBuffer stringBuffer;
        Connection conn = null;
        PreparedStatement stat = null;
        try {
            String[] idArr;
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("CREATE TABLE ").append("tmpTbaleName");
            sql.append("( FID VARCHAR(44) NOT NULL PRIMARY KEY )");
            String tmpTalbeName = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("INSERT INTO ").append(tmpTalbeName).append("(FID) values (?) ");
            stat = conn.prepareStatement(sql.toString());
            for (String id : idArr = ids.toString().split(",")) {
                stat.setString(1, id.substring(1, id.length() - 1));
                stat.addBatch();
            }
            stat.executeBatch();
            pp.setString("idTempTable", tmpTalbeName);
            sql.setLength(0);
            sql.append(" select fid from ").append(tmpTalbeName);
            stringBuffer = sql;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stat, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stat, (Connection)conn);
        return stringBuffer;
    }

    private void checkExistsPreData(Context ctx, StringBuffer ids) throws BOSException, SQLException, CalculateException {
        String checkExists = "select count(*) count from T_IM_PreInventoryBalance where fid in(" + ids + ")";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)checkExists);
        rs.next();
        if (rs.getInt("count") == 0) {
            throw new CalculateException(CalculateException.PREDATA_UPDATE);
        }
    }

    private String getPreparedInsertCostadjustBillSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into T_CL_CostAdjustBill(");
        sql.append("FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime");
        sql.append(",\n FControlUnitID,FNumber,FBizDate,FHasEffected,FAuditorID");
        sql.append(",\n FAuditTime,FBaseStatus,FStorageOrgUnitID,FVoucherID,FFiVouchered");
        sql.append(",\n FTotalQty,FTotalAmount,FCalculateKind,FIssueType,FTotalStandardCost");
        sql.append(",\n FTotalActualCost,FIsReversed,FBillTypeID,FPeriod,FYear");
        sql.append(",\n FIsInitBill,FCreateType,FSUPPLIERID");
        sql.append(") Values(");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?,?,?,");
        sql.append("?,?,?)");
        return sql.toString();
    }

    public static StringBuffer createCostAdjustBillSQL(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo periodInfo, ResultSet rs, ObjectUuidPK billid, String storageorgid, int outwarehouseType, String number, String CostCenter) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        StringBuffer sql = new StringBuffer();
        long time = new java.util.Date().getTime();
        if (periodInfo.getEndDate() != null) {
            time = periodInfo.getEndDate().getTime();
        }
        sql.append("Insert Into T_CL_CostAdjustBill(");
        sql.append("FID,FCreatorID,FCreateTime,FLastUpdateUserID,FLastUpdateTime");
        sql.append(",FControlUnitID,FNumber,FBizDate,FHasEffected,FAuditorID");
        sql.append(",FAuditTime,FBaseStatus,FStorageOrgUnitID,FVoucherID,FFiVouchered");
        sql.append(",FTotalQty,FTotalAmount,FCalculateKind,FIssueType,FTotalStandardCost");
        sql.append(",FTotalActualCost,FIsReversed,FBillTypeID,FPeriod,FYear");
        sql.append(",FIsInitBill,FCreateType,FCostCenterOrgUnitID ");
        sql.append(") Values(");
        sql.append("'").append(billid.toString()).append("'");
        sql.append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sql.append(",TO_DATE('").append(sdf.format(new java.util.Date())).append("')");
        sql.append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("'");
        sql.append(",TO_DATE('").append(sdf.format(new java.util.Date())).append("')");
        sql.append(",'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        sql.append(",'").append(number).append("'");
        sql.append(",TO_DATE('").append(sdf.format(new java.util.Date(time))).append("')");
        sql.append(",0");
        sql.append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx) == null ? "" : ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("'");
        sql.append(",TO_DATE('").append(sdf.format(new java.util.Date())).append("')");
        sql.append(",").append(4);
        sql.append(",'").append(storageorgid).append("'");
        sql.append(",").append("NULL").append("");
        sql.append(",0");
        sql.append(",0");
        sql.append(",0");
        sql.append(",").append(1).append("");
        sql.append(",").append(outwarehouseType).append("");
        sql.append(",0");
        sql.append(",0");
        sql.append(",0");
        sql.append(",'").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        sql.append(",").append(periodInfo.getPeriodNumber());
        sql.append(",").append(periodInfo.getPeriodYear());
        sql.append(",0");
        sql.append(",").append(10);
        if (CostCenter == null) {
            sql.append(",NULL");
        } else {
            sql.append(",'").append(CostCenter).append("'");
        }
        sql.append(")");
        return sql;
    }

    public static StringBuffer createCostAdjustEntrySQL(ObjectUuidPK billid, ObjectUuidPK entryid, ResultSet rs, int i, int Local_Currency_Presision) throws SQLException {
        String amount = StringUtil.toString((BigDecimal)rs.getBigDecimal("FIssueCostDiffAmt").setScale(Local_Currency_Presision, 4));
        StringBuffer sqlentry = new StringBuffer();
        sqlentry.append("Insert Into T_CL_CostAdjustBillEntry(");
        sqlentry.append("FID,FSeq,FAssCoefficient,FBaseStatus,FMaterialID");
        sqlentry.append(",FUnitID,FBaseUnitID,FStorageOrgUnitID,FCompanyOrgUnitID,FWarehouseID");
        sqlentry.append(",FLot,FQty,FBaseQty,FAssistQty,FReverseQty");
        sqlentry.append(",FReturnsQty,FPrice,FAmount,FUnitStandardCost,FStandardCost");
        sqlentry.append(",FUnitActualCost,FActualCost,FParentID,FIsPresent,FAssociateQty,FCostObjectId,FStoreTypeID,FStoreStatusID");
        sqlentry.append(")Values(");
        sqlentry.append("'").append(entryid.toString()).append("'");
        sqlentry.append(",").append(i);
        sqlentry.append(",0");
        sqlentry.append(",").append(4).append("");
        sqlentry.append(",'").append(rs.getString("FMaterialID")).append("'");
        sqlentry.append(",NULL");
        sqlentry.append(",NULL");
        sqlentry.append(",'").append(rs.getString("FStorageOrgUnitId")).append("'");
        sqlentry.append(",'").append(rs.getString("FCompanyOrgUnitId")).append("'");
        sqlentry.append(",'").append(rs.getString("FWarehouseId")).append("'");
        sqlentry.append(",NULL");
        sqlentry.append(",0");
        sqlentry.append(",0");
        sqlentry.append(",0");
        sqlentry.append(",0");
        sqlentry.append(",0");
        sqlentry.append(",0");
        sqlentry.append(",").append(amount).append("");
        sqlentry.append(",0");
        sqlentry.append(",").append(amount);
        sqlentry.append(",0");
        sqlentry.append(",").append(amount);
        sqlentry.append(",'").append(billid.toString()).append("'");
        sqlentry.append(",0");
        sqlentry.append(",0");
        String costObject = rs.getString("FCostObject");
        if (costObject == null) {
            sqlentry.append(",NULL");
        } else {
            sqlentry.append(",'").append(costObject).append("'");
        }
        sqlentry.append(",'").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("'");
        sqlentry.append(",'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'");
        sqlentry.append(")");
        return sqlentry;
    }

    protected String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    @Override
    protected CalculateParams _issueBill(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        logger.info((Object)"-------\u671f\u672b\u5df2\u6210\u4f59\u989d\u751f\u6210\u6210\u672c\u8c03\u6574\u5355\uff1a---------");
        this.initParams(ctx, params);
        this.handleExpDataAdjZero(ctx, params);
        CalculateParams cps = new CalculateParams();
        cps.setBoolean("boolean", true);
        cps.setObject("costAdjustNumberList", params.getObject("costAdjustNumberList"));
        cps.setObject("globalIDList", params.getObject("globalIDList"));
        return cps;
    }

    @Override
    protected CalculateParams _update(Context ctx, CalculateParams calculateParams) throws BOSException, EASBizException {
        CalculateParams calculateParams2;
        RptParams param = (RptParams)calculateParams.getObject("calculateParams");
        StringBuffer sql = new StringBuffer();
        String tbaleName = "T_IM_InventoryBalance";
        boolean isEndAdjust = param.getBoolean("isEndAdjust");
        if (isEndAdjust) {
            tbaleName = "T_IM_PreInventoryBalance";
        }
        if (param != null) {
            sql.append(" select ENTRY.FID, ENTRY.FIsIsseBill FROM " + tbaleName + " ENTRY");
            sql.append(" INNER JOIN T_BD_MATERIAL MATERIAL ON ENTRY.FMATERIALID=MATERIAL.FID");
            sql.append(" where ENTRY.FIsIsseBill = 1 AND ENTRY.FCompanyOrgUnitID ='").append(param.getString("COMPANY_ID")).append("'");
            if (param.getInt("YEAR_FROM") == param.getInt("YEAR_TO") && param.getInt("PERIOD_FROM") == param.getInt("PERIOD_TO")) {
                sql.append(" and ENTRY.FYear = ").append(param.getInt("YEAR_FROM"));
                sql.append(" and ENTRY.FPeriod = ").append(param.getInt("PERIOD_FROM"));
            } else if (param.getInt("YEAR_FROM") == param.getInt("YEAR_TO")) {
                sql.append(" and ENTRY.FYear = ").append(param.getInt("YEAR_FROM"));
                sql.append(" and ENTRY.FPeriod >=").append(param.getInt("PERIOD_FROM"));
                sql.append(" and ENTRY.FPeriod <=").append(param.getInt("PERIOD_TO"));
            } else {
                sql.append(" and (ENTRY.FYear > ").append(param.getInt("YEAR_FROM"));
                sql.append(" or (ENTRY.FYear = ").append(param.getInt("YEAR_FROM"));
                sql.append(" and ENTRY.FPeriod >=").append(param.getInt("PERIOD_FROM"));
                sql.append(" ))");
                sql.append(" and (ENTRY.FYear < ").append(param.getInt("YEAR_TO"));
                sql.append(" or (ENTRY.FYear = ").append(param.getInt("YEAR_TO"));
                sql.append(" and ENTRY.FPeriod <=").append(param.getInt("PERIOD_TO"));
                sql.append(" ))");
            }
            if (param.getString("MATERIAL_FROM") != null && param.getString("MATERIAL_FROM").length() != 0) {
                sql.append(" and MATERIAL.FNumber >= '").append(param.getString("MATERIAL_FROM")).append("'");
            }
            if (param.getString("MATERIAL_TO") != null && param.getString("MATERIAL_TO").length() != 0) {
                sql.append(" and MATERIAL.FNumber <= '").append(param.getString("MATERIAL_TO")).append("'");
            }
            if (param.getString("MATERIAL_IN") != null && param.getString("MATERIAL_IN").length() != 0) {
                sql.append(" and MATERIAL.FNumber in (").append(param.getString("MATERIAL_IN")).append(")");
            }
            if (param.getObject("ckBxMShortName") != null && param.getBoolean("ckBxMShortName")) {
                if (param.getString("txtMShortNameFrom").trim().length() > 0) {
                    sql.append(" and MATERIAL.FshortName >= '").append(param.getString("txtMShortNameFrom")).append("'");
                }
                if (param.getString("txtMShortNameTo").trim().length() > 0 && param.getString("txtMShortNameFrom").trim().length() > 0) {
                    sql.append(" and MATERIAL.FshortName <= '").append(param.getString("txtMShortNameTo")).append("'");
                }
                if (param.getString("txtMShortNameTo").trim().length() > 0 && param.getString("txtMShortNameFrom").trim().length() <= 0) {
                    sql.append(" and ( MATERIAL.FshortName <= '").append(param.getString("txtMShortNameTo")).append("' or MATERIAL.FshortName is null )");
                }
            }
        }
        IRowSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                list.add(rs.getString("Fid"));
            }
            calculateParams.setObject("ISSUEBILL_OBJ", list);
            calculateParams2 = calculateParams;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return calculateParams2;
    }

    private void initParams(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        String companyOrgID = params.getString("COMPANY_ID");
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        int presision = 2;
        try {
            companyOrgUnitInfo.setId(BOSUuid.read((String)params.getString("COMPANY_ID")));
            if (companyOrgUnitInfo == null || companyOrgUnitInfo.getId() == null) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
        }
        catch (Exception e) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        try {
            presision = params.getInt("Local_Currency_Presision");
            if (presision < 0) {
                presision = CalculateUtil.getLocalCurrencyPrecision2(ctx, companyOrgUnitInfo);
            }
        }
        catch (Exception e) {
            presision = CalculateUtil.getLocalCurrencyPrecision2(ctx, companyOrgUnitInfo);
        }
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        if (periodInfo == null) {
            companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId().toString()));
            throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{CalculateUtil.takeFormateDesc(companyOrgUnitInfo.getName(), companyOrgUnitInfo.getNumber())});
        }
        periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)periodInfo.getPeriodYear(), (int)periodInfo.getPeriodNumber(), (CompanyOrgUnitInfo)companyOrgUnitInfo);
        String strCalType = params.getString("CALTYPE");
        if (strCalType == null) {
            IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
            strCalType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyOrgID), "SCM_CAL_002");
        }
        params.setObject("COMPANY_OBJ", (Object)companyOrgUnitInfo);
        params.setInt("Local_Currency_Presision", presision);
        params.setObject("PERIOD_OBJ", (Object)periodInfo);
        params.setString("CALTYPE", strCalType);
    }

    public CalculateParams handleExpDataAdjZero(Context ctx, CalculateParams param) throws BOSException, EASBizException {
        String tmpTalbeName = KsqlUtil.createTempTable((Context)ctx, (String)this.getTmpTableSQL("tmptableName"));
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String billSQL = this.getSQLForCostAdjBill(ctx, param);
            StringBuffer sqlBuffer = this.getInsertSQL(tmpTalbeName);
            sqlBuffer.append(billSQL);
            DBUtil.execute(conn, sqlBuffer.toString());
            sqlBuffer.setLength(0);
            CalculateParams calculateParams = param = this.calculateZeroData(ctx, param, tmpTalbeName);
            return calculateParams;
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException ee) {
            throw ee;
        }
        catch (SQLException eee) {
            throw new BOSException((Throwable)eee);
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)tmpTalbeName);
            SQLUtils.cleanup((Connection)conn);
            KsqlUtil.releaseTempTable((Context)ctx, (String)param.getString("idTempTable"));
        }
    }

    private String getTmpTableSQL(String tmpTbaleName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE TABLE ").append(tmpTbaleName);
        buffer.append("(");
        buffer.append("\n FID VARCHAR(44) NOT NULL PRIMARY KEY,");
        buffer.append("\n FCompanyOrgUnitID VARCHAR(44) NOT NULL,");
        buffer.append("\n Fstorageorgunitid VARCHAR(44) ,");
        buffer.append("\n FwarehouseId VARCHAR(44),");
        buffer.append("\n FLocationId VARCHAR(44),");
        buffer.append("\n FMaterialId VARCHAR(44),");
        buffer.append("\n FBaseUnitId VARCHAR(44),");
        buffer.append("\n FLot NVARCHAR(255),");
        buffer.append("\n FStoreTypeID VARCHAR(44),");
        buffer.append("\n FStoreStatusID VARCHAR(44),");
        buffer.append("\n FCustomerID VARCHAR(44),");
        buffer.append("\n FBASEQTY NUMERIC(21,8) DEFAULT 0 NOT NULL,");
        buffer.append("\n FACTUALCOST NUMERIC(17,4) DEFAULT 0 NOT NULL,");
        buffer.append("\n FAssistPropertyID VARCHAR(44),");
        buffer.append("\n FProjectID VARCHAR(44),");
        buffer.append("\n FTrackNumberID VARCHAR(44),");
        buffer.append("\n FSUPPLIERID VARCHAR(44)");
        buffer.append(")");
        return buffer.toString();
    }

    private StringBuffer getInsertSQL(String tempTableName) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("INSERT INTO " + tempTableName + "(");
        sqlBuffer.append("FID,FCompanyOrgUnitID,Fstorageorgunitid,FwarehouseId,FLocationID,FMaterialId,FBaseUnitId,");
        sqlBuffer.append("FLot,FStoreTypeID,FStoreStatusID,FCustomerID,FBASEQTY,FACTUALCOST,FAssistPropertyID,FProjectID,FTrackNumberID,FSUPPLIERID)\n ");
        return sqlBuffer;
    }

    private CalculateParams calculateZeroData(Context ctx, CalculateParams param, String tempTableName) throws BOSException, EASBizException {
        int num = 100;
        IRowSet rs2 = null;
        HashMap<String, ArrayList> costAdjMap = new HashMap<String, ArrayList>();
        boolean isEndAdjust = param.getBoolean("isEndAdjust");
        String controlUnitid = ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        CoreBillBaseCollection costAdjCollection = new CoreBillBaseCollection();
        rs2 = DBUtil.executeQuery((Context)ctx, (String)("select * from " + tempTableName));
        num = this._getExceptionCostAdjustOption(ctx, param.getString("COMPANY_ID"));
        String calRange = param.getString("CALTYPE");
        if (StringUtil.isEmpty((String)calRange)) {
            calRange = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(param.getString("COMPANY_ID")), "SCM_CAL_002");
        }
        try {
            ArrayList costAdjList = null;
            ArrayList globalList = (ArrayList)param.getObject("globalList");
            ArrayList globalIDList = new ArrayList();
            BigDecimal diffAmount = null;
            String outWareTpye = null;
            RecentCostInfo info = null;
            String fd2 = null;
            String fid = null;
            String issueType = null;
            String bizType = null;
            ArrayList list = null;
            String key = null;
            while (rs2.next()) {
                diffAmount = BigDecimal.ZERO;
                info = new RecentCostInfo();
                fd2 = rs2.getString("Fid");
                if (param.getObject("globalList") == null) continue;
                for (int n = 0; n < globalList.size(); ++n) {
                    list = (ArrayList)globalList.get(n);
                    fid = (String)list.get(0);
                    if (!fd2.trim().equals(fid.trim())) continue;
                    issueType = (String)list.get(2);
                    bizType = (String)list.get(3);
                    diffAmount = (BigDecimal)list.get(1);
                    outWareTpye = (String)list.get(2);
                    if (CalculateUtil.ZERO.compareTo(diffAmount) == 0) continue;
                    info.setString("fid", fid);
                    info.setRecentCost((BigDecimal)list.get(1));
                    if (outWareTpye.equals("-1")) {
                        info.setBigDecimal("FACTUALCOST", diffAmount);
                    } else {
                        info.setBigDecimal("FACTUALCOST", diffAmount.negate());
                    }
                    info.setInt("outWareTpye", Integer.parseInt(list.get(2).toString()));
                    info.setString("FControlUnitID", controlUnitid);
                    info.setString("FCompanyOrgUnitID", rs2.getString("FCompanyOrgUnitID"));
                    info.setString("Fstorageorgunitid", rs2.getString("FStorageOrgUnitID"));
                    info.setString("Fwarehouseid", rs2.getString("FWarehouseID"));
                    info.setString("FLocationId", rs2.getString("FLocationID"));
                    info.setString("FMaterialId", rs2.getString("FMATERIALID"));
                    info.setString("FBaseUnitId", rs2.getString("FBASEUNITID"));
                    info.setString("FLOT", rs2.getString("FLOT"));
                    info.setString("FStoreTypeId", rs2.getString("FStoreTypeID"));
                    info.setString("FStoreStatusId", rs2.getString("FStoreStatusID"));
                    info.setString("FCustomerId", rs2.getString("FCustomerID"));
                    info.setString("FAssistPropertyID", rs2.getString("FAssistPropertyID"));
                    info.setString("FProjectID", rs2.getString("FProjectID"));
                    info.setString("FTrackNumberID", rs2.getString("FTrackNumberID"));
                    info.setPrice(CalculateUtil.ZERO);
                    info.setRecentQty(CalculateUtil.ZERO);
                    info.setString("CostType", bizType);
                    info.setString("ISSUE_COST_ADJUST", issueType);
                    info.setString("FSUPPLIERID", rs2.getString("FSUPPLIERID"));
                    costAdjList = costAdjMap.get(this.getCostAdjKey(info)) == null ? new ArrayList() : (ArrayList)costAdjMap.get(this.getCostAdjKey(info));
                    costAdjList.add(info);
                    key = this.getCostAdjKey(info);
                    costAdjMap.put(key, costAdjList);
                    if (costAdjList.size() < num) continue;
                    param = this.createCostAdjsutbill(ctx, param, costAdjMap, costAdjCollection, globalIDList, key);
                }
            }
            param = this.createCostAdjsutbill(ctx, param, costAdjMap, costAdjCollection, globalIDList, null);
            costAdjMap.clear();
            ICostAdjustBill costAdjust = CostAdjustBillFactory.getLocalInstance(ctx);
            String costAdjustid = null;
            ObjectUuidPK pk = null;
            String updateAuditSql = null;
            ArrayList<Object[]> updateAuditParamList = new ArrayList<Object[]>();
            PeriodInfo period = (PeriodInfo)param.getObject("PERIOD_OBJ");
            if (!isEndAdjust) {
                updateAuditSql = "update T_CL_COSTADJUSTBILL set FAUDITTIME = ? where fid = ?";
            }
            for (int i = 0; i < costAdjCollection.size(); ++i) {
                costAdjustid = costAdjCollection.get(i).getId().toString().trim();
                pk = new ObjectUuidPK(BOSUuid.read((String)costAdjustid));
                costAdjust.audit((IObjectPK)pk);
                Object[] updateAuditParam = new Object[]{period.getBeginDate(), costAdjustid};
                updateAuditParamList.add(updateAuditParam);
            }
            if (!isEndAdjust) {
                DBUtil.executeBatch((Context)ctx, (String)updateAuditSql, updateAuditParamList);
            }
            this.updateInventoryBalance(ctx, globalIDList, isEndAdjust, param.getInt("sumType"), calRange);
            param.setObject("globalIDList", globalIDList);
            CalculateParams calculateParams = param;
            return calculateParams;
        }
        catch (SQLException ee) {
            throw new BOSException((Throwable)ee);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs2);
        }
    }

    private CalculateParams createCostAdjsutbill(Context ctx, CalculateParams param, HashMap costAdjMap, CoreBillBaseCollection costCollection, ArrayList list, String key) throws BOSException {
        PeriodInfo period = (PeriodInfo)param.getObject("PERIOD_OBJ");
        boolean isEndAdjust = param.getBoolean("isEndAdjust");
        String insertCostajdSql = this.getPreparedInsertCostadjustBillSQL();
        long currentTime = System.currentTimeMillis();
        Date curTime = new Date(currentTime);
        PreparedStatement ps = null;
        Connection con = null;
        HashSet<String> costAdjustNumberList = new HashSet<String>();
        BOSUuid bosUid = null;
        CostAdjustBillInfo bill = null;
        ArrayList costadjList = null;
        ArrayList<String> idList = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userInfoId = null;
        String costAdjustNumber = null;
        Set<Object> keySet = new HashSet<String>();
        Timestamp endDate = period.getEndDate();
        java.util.Date beginDate = period.getBeginDate();
        if (!StringUtil.isEmpty((String)key)) {
            keySet.add(key);
        } else {
            keySet = costAdjMap.keySet();
        }
        if (userInfo != null) {
            userInfoId = userInfo.getId().toString();
        }
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(insertCostajdSql);
            Iterator<Object> iter = keySet.iterator();
            while (iter.hasNext()) {
                costadjList = (ArrayList)costAdjMap.get((String)iter.next());
                if (costadjList != null && costadjList.size() > 0) {
                    RecentCostInfo info = (RecentCostInfo)costadjList.get(0);
                    bill = new CostAdjustBillInfo();
                    if (info.getString("CostType").equals("1")) {
                        bill.setCalculateKind(CalculateKindEnum.OUTPUT_WAREHOUSE);
                    } else {
                        bill.setCalculateKind(CalculateKindEnum.INPUT_WAREHOUSE);
                    }
                    bosUid = BOSUuid.create((BOSObjectType)bill.getBOSType());
                    info.setId(bosUid);
                    bill.setId(bosUid);
                    costCollection.add((CoreBillBaseInfo)bill);
                    ps.setString(1, bosUid.toString());
                    ps.setString(2, userInfoId);
                    ps.setDate(3, curTime);
                    ps.setString(4, null);
                    ps.setDate(5, curTime);
                    ps.setString(6, info.getString("FControlUnitID"));
                    costAdjustNumber = "EXP-" + String.valueOf(System.currentTimeMillis()).substring(2) + this.count;
                    costAdjustNumberList.add(costAdjustNumber);
                    ps.setString(7, costAdjustNumber);
                    if (isEndAdjust) {
                        ps.setDate(8, new Date(endDate.getTime()));
                    } else {
                        ps.setDate(8, new Date(beginDate.getTime()));
                    }
                    ps.setInt(9, 0);
                    ps.setString(10, null);
                    ps.setDate(11, curTime);
                    ps.setInt(12, 2);
                    ps.setString(13, info.getString("FStorageOrgUnitID"));
                    ps.setString(14, null);
                    ps.setInt(15, 0);
                    ps.setBigDecimal(16, CalculateUtil.ZERO);
                    ps.setBigDecimal(17, CalculateUtil.ZERO);
                    ps.setInt(18, bill.getCalculateKind().getValue());
                    ps.setInt(19, this.getIssueType(info));
                    ps.setBigDecimal(20, CalculateUtil.ZERO);
                    ps.setBigDecimal(21, CalculateUtil.ZERO);
                    ps.setInt(22, 0);
                    ps.setString(23, "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552");
                    ps.setInt(24, period.getPeriodNumber());
                    ps.setInt(25, period.getPeriodYear());
                    ps.setInt(26, 0);
                    if (isEndAdjust) {
                        ps.setInt(27, 13);
                    } else {
                        ps.setInt(27, 10);
                    }
                    ps.setString(28, info.getString("FSUPPLIERID"));
                    ps.addBatch();
                    ++this.count;
                    for (int i = 0; costadjList != null && i < costadjList.size(); ++i) {
                        idList = new ArrayList<String>();
                        info = (RecentCostInfo)costadjList.get(i);
                        idList.add(info.getString("fid"));
                        idList.add(bosUid.toString());
                        list.add(idList);
                    }
                    this.createCostAdjsutbillEntry(ctx, costadjList, period, bosUid.toString(), bill, isEndAdjust);
                    ps.executeBatch();
                    costadjList.clear();
                }
                if (param.getObject("costAdjustNumberList") != null) {
                    costAdjustNumberList.addAll((Set)param.getObject("costAdjustNumberList"));
                }
                param.setObject("costAdjustNumberList", costAdjustNumberList);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
        return param;
    }

    private void createCostAdjsutbillEntry(Context ctx, ArrayList balanceList, PeriodInfo period, String billID, CostAdjustBillInfo costAjdBill, boolean isEndAdjust) throws BOSException {
        String insertCostajdSql = CostAdjustHelp.getPreparedInsertCostadjustEntrySQL();
        PreparedStatement ps = null;
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(insertCostajdSql);
            HashSet<String> entryIdSet = new HashSet<String>();
            int count = 0;
            for (int i = 0; i < balanceList.size(); ++i) {
                RecentCostInfo info = (RecentCostInfo)balanceList.get(i);
                BOSUuid bosUid = BOSUuid.create((String)"2774F28C");
                ps.setString(1, bosUid.toString());
                ps.setInt(2, ++count);
                ps.setBigDecimal(3, CalculateUtil.ZERO);
                ps.setInt(4, 2);
                ps.setString(5, info.getString("FMaterialId"));
                ps.setString(6, info.getString("FBaseUnitId"));
                ps.setString(7, info.getString("FBaseUnitId"));
                ps.setString(8, info.getString("Fstorageorgunitid"));
                ps.setString(9, info.getString("FCompanyOrgUnitID"));
                ps.setString(10, info.getString("Fwarehouseid"));
                ps.setString(11, info.getString("FLocationId"));
                ps.setString(12, info.getString("FLOT"));
                ps.setBigDecimal(13, CalculateUtil.ZERO);
                ps.setBigDecimal(14, CalculateUtil.ZERO);
                ps.setBigDecimal(15, CalculateUtil.ZERO);
                ps.setBigDecimal(16, CalculateUtil.ZERO);
                ps.setBigDecimal(17, CalculateUtil.ZERO);
                ps.setBigDecimal(18, info.getPrice());
                if (CalculateKindEnum.OUTPUT_WAREHOUSE.equals((Object)costAjdBill.getCalculateKind())) {
                    ps.setBigDecimal(19, info.getRecentCost().negate());
                } else {
                    ps.setBigDecimal(19, info.getRecentCost());
                }
                ps.setBigDecimal(20, CalculateUtil.ZERO);
                ps.setBigDecimal(21, CalculateUtil.ZERO);
                ps.setBigDecimal(22, info.getPrice());
                ps.setBigDecimal(23, info.getBigDecimal("factualcost"));
                ps.setString(24, billID);
                ps.setInt(25, 0);
                ps.setBigDecimal(26, CalculateUtil.ZERO);
                ps.setBigDecimal(27, CalculateUtil.ZERO);
                ps.setBigDecimal(28, CalculateUtil.ZERO);
                if (info.getString("FStoreTypeId") != null) {
                    ps.setString(29, info.getString("FStoreTypeId"));
                } else {
                    ps.setString(29, "181875d5-0105-1000-e000-0111c0a812fd97D461A6");
                }
                if (info.getString("FStoreStatusId") != null) {
                    ps.setString(30, info.getString("FStoreStatusId"));
                } else {
                    ps.setString(30, "181875d5-0105-1000-e000-012ec0a812fd62A73FA5");
                }
                ps.setString(31, info.getString("FCustomerId"));
                ps.setString(32, info.getString("FAssistPropertyID"));
                if (isEndAdjust) {
                    ps.setTimestamp(33, period.getEndDate());
                } else {
                    ps.setObject(33, (Date)period.getBeginDate());
                }
                ps.setString(34, info.getString("FProjectID"));
                ps.setString(35, info.getString("FTrackNumberID"));
                CostAdjustBillEntryInfo entry = new CostAdjustBillEntryInfo();
                entry.setId(bosUid);
                entryIdSet.add(bosUid.toString());
                entry.setSeq(count);
                costAjdBill.getEntry().add(entry);
                ps.addBatch();
            }
            ps.executeBatch();
            balanceList.clear();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
    }

    private String getCostAdjKey(RecentCostInfo bill) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(bill.getString("FCompanyOrgUnitID"));
        buffer.append("_$$$$_").append(bill.getString("FStorageOrgUnitId"));
        buffer.append("_$$$$_").append(bill.getString("costtype"));
        buffer.append("_$$$$_").append(bill.getString("issue_cost_adjust"));
        return buffer.toString();
    }

    @Override
    public CalculateParams _delBIll(Context ctx, CalculateParams param) throws BOSException, EASBizException {
        logger.info((Object)"--------\u5220\u9664\u6210\u672c\u8c03\u6574\u5355\u5f00\u59cb\uff1a---------");
        this.initParams(ctx, param);
        boolean isEndAdjust = param.getBoolean("isEndAdjust");
        boolean isDelBill = false;
        boolean isCanUnAudit = true;
        ArrayList costBillStatus = new ArrayList();
        CalculateParams cps = new CalculateParams();
        if ((PeriodInfo)param.getObject("PERIOD_OBJ") != null && param.getString("COMPANY_ID") != null) {
            String calRange = param.getString("CALTYPE");
            if (StringUtil.isEmpty((String)calRange)) {
                calRange = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(param.getString("COMPANY_ID")), "SCM_CAL_002");
            }
            String[] invBalanceIDs = (String[])param.getObject("INVBALANCEID");
            StringBuffer invBalanceID = new StringBuffer();
            for (int i = 0; i < invBalanceIDs.length; ++i) {
                if (i != 0) {
                    invBalanceID.append(",");
                }
                invBalanceID.append("'" + invBalanceIDs[i] + "'");
            }
            Set<Object> allIssueSet = new HashSet();
            try {
                allIssueSet = this.getAllIssueSet(ctx, invBalanceID.toString(), isEndAdjust, param.getInt("sumType"), calRange, "FCOSTADJUSTBILL");
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            String[] costAdjustBillId = new String[allIssueSet.size()];
            allIssueSet.toArray(costAdjustBillId);
            this.isExistExpAdjZeroCostAdjBill(ctx, costAdjustBillId, param);
            cps.setString("numberCount", param.getString("numberCount"));
            if (param.getBoolean("isVouchered")) {
                isDelBill = false;
            } else {
                String costAdjustBillNumber = this.getCostAdjustBillNumber(ctx, costAdjustBillId, costBillStatus);
                ICostAdjustBill costAdjust = CostAdjustBillFactory.getLocalInstance(ctx);
                if (costAdjustBillId.length > 0) {
                    CoreBaseInfo model = costAdjust.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)costAdjustBillId[0])));
                    isCanUnAudit = this.checkUnAuditInParam(ctx, (IObjectValue)model);
                }
                for (int i = 0; i < costAdjustBillId.length; ++i) {
                    String baseStatus;
                    String costAdjustid = costAdjustBillId[i].toString().trim();
                    if (StringUtils.isEmpty((String)costAdjustid) || 4 != Integer.parseInt(baseStatus = (String)costBillStatus.get(i))) continue;
                    if (!isCanUnAudit) {
                        throw new ManualWriteOffException(ManualWriteOffException.COSTADJBILL_UNAUDIT);
                    }
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)costAdjustid));
                    costAdjust.unAudit((IObjectPK)pk);
                }
                this.deleteCostAdjBill(ctx, costAdjustBillId);
                this.updateInventoryBalance(ctx, costAdjustBillId, isEndAdjust);
                isDelBill = true;
                cps.setString("COSTADJUSTBILLNUMBER", costAdjustBillNumber);
            }
        }
        cps.setBoolean("isSuccess", isDelBill);
        return cps;
    }

    private boolean checkUnAuditInParam(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        InvBillBaseInfo aInvBillBaseInfo = (InvBillBaseInfo)model;
        if (aInvBillBaseInfo.getBillType() != null) {
            String billTypeId = aInvBillBaseInfo.getBillType().getId().toString();
            String orgUnitID = aInvBillBaseInfo.getStorageOrgUnit().getId().toString();
            boolean isCanUnAudit = false;
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strCanUnAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 4, orgUnitID, billTypeId);
            if (strCanUnAudit != null && strCanUnAudit.trim().length() != 0 && "1".equalsIgnoreCase(strCanUnAudit.trim())) {
                isCanUnAudit = true;
            }
            return isCanUnAudit;
        }
        return true;
    }

    private CalculateParams isExistExpAdjZeroCostAdjBill(Context ctx, String[] costAdjustBillId, CalculateParams params) throws BOSException {
        if (costAdjustBillId == null || costAdjustBillId.length == 0) {
            return params;
        }
        StringBuffer costAdjustbillID = new StringBuffer("");
        for (int i = 0; i < costAdjustBillId.length; ++i) {
            if (i != 0) {
                costAdjustbillID.append(",");
            }
            costAdjustbillID.append("'" + costAdjustBillId[i] + "'");
        }
        String costAdjustNumber = "";
        boolean isVouchered = false;
        StringBuffer numberStr = new StringBuffer();
        String selectBillNumber = "SELECT FNumber as FNumber  FROM T_CL_COSTADJUSTBILL WHERE FFIVOUCHERED = 1 AND FID IN(" + costAdjustbillID.toString() + ")";
        try {
            IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)selectBillNumber);
            while (rowSet.next()) {
                costAdjustNumber = rowSet.getString("FNumber");
                numberStr.append(costAdjustNumber).append("\n");
                isVouchered = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        params.setString("numberCount", numberStr.toString());
        params.setBoolean("isVouchered", isVouchered);
        return params;
    }

    private String getCostAdjustBillNumber(Context ctx, String[] costAdjustBillId, List costBillStatus) throws BOSException {
        StringBuffer costAdjustBillNumber = new StringBuffer();
        if (costAdjustBillId == null || costAdjustBillId.length == 0) {
            return "";
        }
        StringBuffer costAdjustbillID = new StringBuffer("");
        for (int i = 0; i < costAdjustBillId.length; ++i) {
            if (i != 0) {
                costAdjustbillID.append(",");
            }
            costAdjustbillID.append("'" + costAdjustBillId[i] + "'");
        }
        String selectBillNumber = "SELECT FNUMBER,FBaseStatus FROM T_CL_COSTADJUSTBILL WHERE FID IN (" + costAdjustbillID.toString() + ")";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)selectBillNumber);
        try {
            while (rs.next()) {
                costAdjustBillNumber.append(rs.getString("FNumber")).append("\n");
                costBillStatus.add(rs.getString("FBaseStatus"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return costAdjustBillNumber.toString();
    }

    private void deleteCostAdjBill(Context ctx, String[] costAdjustBillId) throws BOSException {
        if (costAdjustBillId == null || costAdjustBillId.length == 0) {
            return;
        }
        StringBuffer costAdjustbillID = new StringBuffer("");
        for (int i = 0; i < costAdjustBillId.length; ++i) {
            if (i != 0) {
                costAdjustbillID.append(",");
            }
            costAdjustbillID.append("'" + costAdjustBillId[i] + "'");
        }
        String delEntrySQL = "DELETE FROM T_CL_COSTADJUSTBILLENTRY WHERE FPARENTID IN (" + costAdjustbillID.toString() + ")";
        DBUtil.execute((Context)ctx, (String)delEntrySQL);
        String delBillSQL = "DELETE FROM T_CL_COSTADJUSTBILL WHERE FID IN (" + costAdjustbillID.toString() + ")";
        DBUtil.execute((Context)ctx, (String)delBillSQL);
    }

    private void updateInventoryBalance(Context ctx, String[] costAdjustBillId, boolean isEndAdjust) throws BOSException {
        if (costAdjustBillId == null || costAdjustBillId.length == 0) {
            return;
        }
        StringBuffer costAdjustID = new StringBuffer("");
        for (int i = 0; i < costAdjustBillId.length; ++i) {
            if (i != 0) {
                costAdjustID.append(",");
            }
            costAdjustID.append("'" + costAdjustBillId[i] + "'");
        }
        StringBuffer sql3 = new StringBuffer();
        if (isEndAdjust) {
            sql3.append(" update T_IM_PreInventoryBalance ");
        } else {
            sql3.append(" update T_IM_InventoryBalance");
        }
        sql3.append(" set FIsIsseBill = 0, FCostadjustbill =''");
        sql3.append(" where FCostadjustbill in (" + costAdjustID.toString() + ") ");
        DBUtil.execute((Context)ctx, (String)sql3.toString());
    }

    private void updateInventoryBalance(Context ctx, ArrayList list, boolean isEndAdjust, int sumType, String calRange) throws BOSException, SQLException, EASBizException {
        if (list == null || list.size() == 0) {
            return;
        }
        String tableName = null;
        tableName = isEndAdjust ? "T_IM_PreInventoryBalance" : "T_IM_InventoryBalance";
        StringBuffer selectedIds = null;
        HashMap<String, StringBuffer> idMap = new HashMap<String, StringBuffer>();
        for (int i = 0; i < list.size(); ++i) {
            ArrayList list2 = (ArrayList)list.get(i);
            selectedIds = idMap.containsKey(list2.get(1)) ? (StringBuffer)idMap.get(list2.get(1)) : new StringBuffer();
            selectedIds.append("'").append((String)list2.get(0)).append("',");
            idMap.put(list2.get(1).toString(), selectedIds);
        }
        Set idMapKeySet = idMap.keySet();
        for (String key : idMapKeySet) {
            selectedIds = (StringBuffer)idMap.get(key);
            selectedIds.setLength(selectedIds.length() - 1);
            Set<String> allIds = this.getAllIssueSet(ctx, selectedIds.toString(), isEndAdjust, sumType, calRange, "FID");
            String costAdjustBillID = key;
            try {
                if (allIds.size() <= 0) continue;
                StringBuffer strIds = new StringBuffer();
                for (String s : allIds) {
                    strIds.append("'").append(s).append("',");
                }
                strIds.setLength(strIds.length() - 1);
                if (!isEndAdjust) {
                    StringBuffer lockSql = new StringBuffer();
                    lockSql.append("update ").append(tableName).append(" set fid = fid where fid in(").append(strIds).append(")");
                    DBUtil.execute((Context)ctx, (String)lockSql.toString());
                    StringBuffer ckechLockSql = new StringBuffer();
                    ckechLockSql.append("select 1 from ").append(tableName).append(" where FISISSEBILL = 1 and fid in(").append(strIds).append(")");
                    IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)ckechLockSql.toString());
                    if (rs.next()) {
                        throw new CalculateException(CalculateException.HAS_ISSUE_BILL);
                    }
                }
                StringBuffer updateSql = new StringBuffer();
                updateSql.append("update ").append(tableName).append(" set FIsIsseBill = 1, FCostadjustbill ='").append(costAdjustBillID).append("' where fid in(").append(strIds).append(")");
                DBUtil.execute((Context)ctx, (String)updateSql.toString());
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private Set<String> getAllIssueSet(Context ctx, String selectedIds, boolean isEndAdjust, int sumType, String calRange, String key) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        if (isEndAdjust) {
            sql.append("SELECT  B.").append(key).append(" FROM T_IM_PreInventoryBalance A INNER JOIN T_BD_MATERIALCOMPANYINFO MC ON A.FMATERIALID = MC.FMATERIALID AND A.FCOMPANYORGUNITID = MC.FCOMPANYID INNER JOIN T_IM_PreInventoryBalance B").append("\r\n");
        } else {
            sql.append("SELECT  B.").append(key).append(" FROM T_IM_INVENTORYBALANCE A INNER JOIN T_BD_MATERIALCOMPANYINFO MC ON A.FMATERIALID = MC.FMATERIALID AND A.FCOMPANYORGUNITID = MC.FCOMPANYID INNER JOIN T_IM_INVENTORYBALANCE B").append("\r\n");
        }
        sql.append("ON A.FCOMPANYORGUNITID = B.FCOMPANYORGUNITID and A.FYEAR = B.FYEAR AND A.FPERIOD = B.FPERIOD AND A.FMATERIALID = B.FMATERIALID").append("\r\n");
        sql.append("AND A.FSTORETYPEID = B.FSTORETYPEID AND A.FSTORESTATUSID = B.FSTORESTATUSID").append("\r\n");
        sql.append("AND ISNULL(A.FSUPPLIERID,'null') = ISNULL(B.FSUPPLIERID,'null')").append("\r\n");
        if (sumType == 1) {
            if ("1".equals(calRange)) {
                sql.append(" AND A.FSTORAGEORGUNITID = B.FSTORAGEORGUNITID").append("\r\n");
            } else if ("2".equals(calRange)) {
                sql.append(" AND A.FSTORAGEORGUNITID = B.FSTORAGEORGUNITID AND A.FWAREHOUSEID = B.FWAREHOUSEID").append("\r\n");
            }
            sql.append("AND (CASE WHEN MC.FISLOT = 0 THEN 1 WHEN MC.FISLOT = 1 AND A.FLOT = B.FLOT THEN 1 ELSE 0 END) = 1").append("\r\n");
            sql.append("AND (CASE WHEN MC.FISASSISTPROPERTY = 0 THEN 1 WHEN MC.FISASSISTPROPERTY = 1 AND A.FASSISTPROPERTYID = B.FASSISTPROPERTYID THEN 1 ELSE 0 END) = 1").append("\r\n");
            sql.append("AND (CASE WHEN MC.FISPROJECT = 0 THEN 1 WHEN MC.FISPROJECT = 1 AND A.FPROJECTID = B.FPROJECTID THEN 1 ELSE 0 END) = 1").append("\r\n");
            sql.append("AND (CASE WHEN MC.FISTRACKNUMBER = 0 THEN 1 WHEN MC.FISTRACKNUMBER = 1 AND A.FTRACKNUMBERID = B.FTRACKNUMBERID THEN 1 ELSE 0 END) = 1").append("\r\n");
        } else if (sumType == 0) {
            sql.append("AND A.FSTORAGEORGUNITID = B.FSTORAGEORGUNITID AND A.FWAREHOUSEID = B.FWAREHOUSEID").append("\r\n");
            sql.append("AND ISNULL(A.FCustomerID,'null') = ISNULL(B.FCustomerID,'null') AND ISNULL(A.FAssistPropertyID,'null') = ISNULL(B.FAssistPropertyID,'null') AND ISNULL(A.FLocationID,'null') = ISNULL(B.FLocationID,'null')").append("\r\n");
            sql.append("AND ISNULL(A.FLOT,'null') = ISNULL(B.FLOT,'null')").append("\r\n");
            sql.append("AND ISNULL(A.FPROJECTID,'null') = ISNULL(B.FPROJECTID,'null') AND ISNULL(A.FTRACKNUMBERID,'null') = ISNULL(B.FTRACKNUMBERID,'null')").append("\r\n");
        }
        sql.append("WHERE A.FID IN(").append(selectedIds).append(")");
        sql.append(" AND B.").append(key).append(" IS NOT NULL");
        HashSet<String> allIds = new HashSet<String>();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            allIds.add(rs.getString(key));
        }
        return allIds;
    }

    private int getIssueType(RecentCostInfo info) {
        int issueType = -1;
        if (0 == info.getInt("ISSUE_COST_ADJUST")) {
            issueType = 0;
        } else if (1 == info.getInt("ISSUE_COST_ADJUST")) {
            issueType = 1;
        } else if (2 == info.getInt("ISSUE_COST_ADJUST")) {
            issueType = 2;
        } else if (3 == info.getInt("ISSUE_COST_ADJUST")) {
            issueType = 3;
        }
        return issueType;
    }

    @Override
    protected int _getExceptionCostAdjustOption(Context ctx, String companyid) throws BOSException {
        int num = 100;
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(fexBalCAEntryNum) as num from T_CAL_INVCKACCOUNT where fcompanyid = '").append(companyid).append("' and fperiodid is null group by fexBalCAEntryNum");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                num = rs.getInt("num");
            } else {
                sql.setLength(0);
                sql.append(" insert into T_CAL_INVCKACCOUNT (FID,FCOMPANYID,fexBalCAEntryNum) values (newbosid('B1834F6C'),'").append(companyid).append("',100)");
                DBUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return num;
    }

    @Override
    protected void _setExceptionCostAdjustOption(Context ctx, String companyID, int num) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_CAL_INVCKACCOUNT set fexBalCAEntryNum = ").append(num).append(" where fcompanyid = '").append(companyID).append("' and fperiodid is null");
        DBUtil.execute((Context)ctx, (String)sql.toString());
    }
}

