/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.app.AbstractInvCKAccountBCCDetailFacadeControllerBean;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class InvCKAccountBCCDetailFacadeControllerBean
extends AbstractInvCKAccountBCCDetailFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.InvCKAccountBCCDetailFacadeControllerBean");
    private String loc;

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.loc = this.getLoc(ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        this.dropTempTable(params.getString("billDisTable"), ctx);
        this.dropTempTable(params.getString("billPurTable"), ctx);
        String invBillTable = null;
        String billTempTable = null;
        String billDisTable = null;
        String billPurTable = null;
        String tempVoucherTable = null;
        String dischgVoucherTable = null;
        String purInVoucherTable = null;
        String dischargeType = params.getString("dischargeType");
        BigDecimal disAmt = BigDecimal.ZERO;
        try {
            invBillTable = "1".equals(dischargeType) ? this.buildinvBillTable4Moth(ctx, params) : this.buildinvBillTable(ctx, params);
            billTempTable = KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateTempSql());
            if ("2".equals(dischargeType)) {
                billDisTable = KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateTempSql());
            }
            billPurTable = KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateTempSql());
            tempVoucherTable = this.buildTempVoucherTable(ctx, params);
            dischgVoucherTable = "1".equals(dischargeType) ? this.buildDischgVoucherTable4Moth(ctx, params) : this.buildDischgVoucherTable(ctx, params);
            purInVoucherTable = this.buildPurInVoucherTable(ctx, params);
            this.insertBillVoucherData(ctx, invBillTable, billTempTable, tempVoucherTable, 1, params);
            this.insertVoucherWithoutBill(ctx, billTempTable, tempVoucherTable);
            if ("1".equals(dischargeType)) {
                IRowSet disRowSet = DbUtil.executeQuery((Context)ctx, (String)("select isnull(FdischgAmount,0) as amt from " + dischgVoucherTable));
                if (disRowSet.next()) {
                    disAmt = disRowSet.getBigDecimal("amt");
                }
            } else {
                this.insertBillVoucherData(ctx, invBillTable, billDisTable, dischgVoucherTable, 2, params);
                this.insertVoucherWithoutBill(ctx, billDisTable, dischgVoucherTable);
            }
            this.insertBillVoucherData(ctx, invBillTable, billPurTable, purInVoucherTable, 0, params);
            this.insertVoucherWithoutBill(ctx, billPurTable, purInVoucherTable);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.dropTempTable(purInVoucherTable, ctx);
                this.dropTempTable(tempVoucherTable, ctx);
                this.dropTempTable(dischgVoucherTable, ctx);
                this.dropTempTable(invBillTable, ctx);
                throw throwable;
            }
        }
        this.dropTempTable(purInVoucherTable, ctx);
        this.dropTempTable(tempVoucherTable, ctx);
        this.dropTempTable(dischgVoucherTable, ctx);
        this.dropTempTable(invBillTable, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", billTempTable);
        result.setString("billDisTable", billDisTable);
        result.setString("billPurTable", billPurTable);
        result.setBigDecimal("disAmt", disAmt);
        return result;
    }

    private void insertVoucherWithoutBill(Context ctx, String billTempTable, String tempVoucherTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(billTempTable).append(" ");
        sql.append(" (FVoucherID,FVoucherNumber,FVoucherAmt)  \n");
        sql.append(" select B.FVoucherID,B.FVoucherNumber,B.FVoucherAmount from \n");
        sql.append(tempVoucherTable).append(" B \n");
        sql.append(" where not exists(select 1 from ").append(billTempTable);
        sql.append(" A where A.FVoucherID = B.FVoucherID )");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertBillVoucherData(Context ctx, String invBillTable, String billTempTable, String voucherTable, int voucherType, RptParams params) throws BOSException {
        Integer spnYear = (Integer)params.getObject("Year");
        Integer spnPeriod = (Integer)params.getObject("Period");
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(billTempTable).append(" ");
        sql.append(" (FBillPeriod,FBillID,FBillTypeID,FBillTypeName,FBillNumber,FTempAmount,");
        sql.append(" FVoucherID,FVoucherNumber,FVoucherAmt)  \n");
        sql.append(" select b.FbillPeriod,b.FbillID,b.FbillTypeID,b.FbillTypeName,b.FbillNumber,");
        if (voucherType == 0) {
            sql.append(" isnull(b.FPurAmount,0),");
        } else if (voucherType == 1) {
            sql.append(" isnull(b.FtempAmount,0),");
        } else {
            sql.append(" isnull(b.Fdischgamt,0),");
        }
        sql.append("tmp.FVoucherID,tmp.FVoucherNumber,tmp.FVoucherAmount");
        sql.append(" from \n");
        sql.append(invBillTable).append(" b ");
        if (voucherType == 2) {
            sql.append(" left join t_cl_writeoffrecord C on b.FbillID = C.FBILLID \n");
        }
        sql.append("  left join(");
        sql.append(" select r.fsrcobjectid,");
        sql.append(" vo.FVoucherID,vo.FVoucherNumber,isnull(vo.FVoucherAmount,0) as FVoucherAmount");
        sql.append(" from t_bot_relation r");
        sql.append(" inner join ").append(voucherTable).append(" vo");
        sql.append(" on vo.FVoucherID = r.fdestObjectid ");
        sql.append(" )tmp ");
        if (voucherType == 2) {
            sql.append(" on C.FPARENTID = tmp.fsrcobjectid");
        } else {
            sql.append(" on b.FbillID = tmp.fsrcobjectid");
        }
        if (voucherType == 0) {
            sql.append(" where (b.FPurAmount != 0 or tmp.FVoucherAmount != 0)");
        } else if (voucherType == 1) {
            sql.append(" where (b.FtempAmount != 0 or tmp.FVoucherAmount != 0)");
        } else {
            sql.append(" where C.FWRITEOFFYEAR = ");
            sql.append(spnYear).append(" and C.FWRITEOFFPERIOD = ").append(spnPeriod);
            sql.append(" and (b.Fdischgamt != 0 or tmp.FVoucherAmount != 0)");
        }
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String buildPurInVoucherTable(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table VoucherTempReportTable (");
        sql.append("FVoucherID Varchar(44) NOT NULL,");
        sql.append("FVoucherNumber Varchar(255),");
        sql.append("FVoucherAmount decimal(17, 4)");
        sql.append(")");
        String purInVoucherTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" insert into ").append(purInVoucherTable);
        sql.append(" (FVoucherID,FVoucherNumber,FVoucherAmount)");
        sql.append(" Select bill.FID, bill.FNumber, sum(entry.FLocalAmount) ");
        sql.append(" From T_GL_Voucher bill ");
        sql.append(" Inner Join T_GL_VoucherEntry entry on bill.FID = entry.FBillID ");
        sql.append(" Inner Join T_BD_AccountView accView on entry.FAccountID = accView.FID ");
        sql.append(" Inner Join T_BD_Period prd on bill.FPeriodID = prd.FID ");
        sql.append(this.getGLWhereSQL(params));
        sql.append(" and exists (select 1 from t_im_purinwarehsvoucher PV ");
        sql.append("  where PV.FVOUCHERID = bill.fid and PV.FVOUCHERTYPE =  0 ) ");
        sql.append(" group by bill.FID, bill.FNumber ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        return purInVoucherTable;
    }

    private String buildDischgVoucherTable(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table VoucherTempReportTable (");
        sql.append("FVoucherID Varchar(44) NOT NULL ,");
        sql.append("FVoucherNumber Varchar(255),");
        sql.append("FVoucherAmount decimal(17, 4)");
        sql.append(")");
        String dischgVoucherTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" insert into ").append(dischgVoucherTable);
        sql.append(" (FVoucherID,FVoucherNumber,FVoucherAmount)");
        sql.append(" Select bill.FID, bill.FNumber, sum(isnull(entry.FLocalAmount,0)) ");
        sql.append(" From T_GL_Voucher bill ");
        sql.append(" Inner Join T_GL_VoucherEntry entry on bill.FID = entry.FBillID ");
        sql.append(" Inner Join T_BD_AccountView accView on entry.FAccountID = accView.FID ");
        sql.append(" Inner Join T_BD_Period prd on bill.FPeriodID = prd.FID ");
        sql.append(this.getGLWhereSQL(params));
        sql.append(" and exists (select 1 from t_im_purinwarehsvoucher PV ");
        sql.append("  where PV.FVOUCHERID = bill.fid and PV.FVOUCHERTYPE =  2 ) ");
        sql.append(" group by bill.FID, bill.FNumber ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        return dischgVoucherTable;
    }

    private String buildTempVoucherTable(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table VoucherTempReportTable (");
        sql.append("FVoucherID Varchar(44) NOT NULL,");
        sql.append("FVoucherNumber Varchar(255),");
        sql.append("FVoucherAmount decimal(17, 4)");
        sql.append(")");
        String tempVoucherTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" insert into ").append(tempVoucherTable);
        sql.append(" (FVoucherID,FVoucherNumber,FVoucherAmount)");
        sql.append(" Select bill.FID, bill.FNumber, sum(entry.FLocalAmount) ");
        sql.append(" From T_GL_Voucher bill ");
        sql.append(" Inner Join T_GL_VoucherEntry entry on bill.FID = entry.FBillID ");
        sql.append(" Inner Join T_BD_AccountView accView on entry.FAccountID = accView.FID ");
        sql.append(" Inner Join T_BD_Period prd on bill.FPeriodID = prd.FID ");
        sql.append(this.getGLWhereSQL(params));
        sql.append(" and exists (select 1 from t_im_purinwarehsvoucher PV ");
        sql.append("  where PV.FVOUCHERID = bill.fid and PV.FVOUCHERTYPE =  1 ) ");
        sql.append(" group by bill.FID, bill.FNumber ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        return tempVoucherTable;
    }

    private String getGLWhereSQL(RptParams params) {
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("bizCompnayOrg");
        Integer spnYear = (Integer)params.getObject("Year");
        Integer spnPeriod = (Integer)params.getObject("Period");
        String actNumber = (String)params.getObject("ActNumber");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Where bill.FCompanyID = '").append(companyOrgUnitInfo.getId().toString()).append("'");
        sSQL.append(" And prd.FPeriodYear = ").append(spnYear);
        sSQL.append(" And prd.FPeriodNumber = ").append(spnPeriod);
        sSQL.append(" And accView.FNumber = '").append(actNumber).append("'");
        sSQL.append(" And entry.FEntryDC = 1");
        sSQL.append(" And (bill.FBizStatus = ").append(1);
        sSQL.append(" or bill.FBizStatus = ").append(3);
        sSQL.append(" or bill.FBizStatus = ").append(5).append(")");
        return sSQL.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildinvBillTable(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" create table temp ( FbillPeriod INT,FbillID varchar(44),FbillTypeID varchar(44),");
        sql.append(" FbillTypeName nvarchar(255),FbillNumber nvarchar(80), ");
        sql.append(" FtempAmount Decimal(17,4),FTempVoucherID varchar(44),");
        sql.append(" FTempVoucherNumber nvarchar(80),FTempVoucheramt Decimal(17,4),");
        sql.append(" FTempDiff Decimal(17,4),");
        sql.append(" Fdischgamt Decimal(17,4),FdischgVoucherId varchar(44),");
        sql.append(" FdischgVoucherNumber nvarchar(80),FdischgVoucheramt Decimal(17,4),");
        sql.append(" Fdischgdiff Decimal(17,4),");
        sql.append(" FPurAmount Decimal(17,4) ,FpurinVoucherId varchar(44),");
        sql.append(" FpurinVoucherNumber nvarchar(80),FpurinVoucheramt Decimal(17,4),FpurinDiff Decimal(17,4) ");
        sql.append(" )");
        String invBillTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        KsqlUtil.createTempTableIndex((Context)ctx, (String)invBillTable, (String)"FTempVoucherID", (boolean)false);
        KsqlUtil.createTempTableIndex((Context)ctx, (String)invBillTable, (String)"FdischgVoucherId", (boolean)false);
        KsqlUtil.createTempTableIndex((Context)ctx, (String)invBillTable, (String)"FpurinVoucherId", (boolean)false);
        sql.setLength(0);
        sql.append(" create table temp ( FbillPeriod INT, FbillID varchar(44), fentryID varchar(44),FbillTypeID varchar(44),");
        sql.append(" FbillTypeName nvarchar(255),FbillNumber nvarchar(80), FAccountType int,FAmtPrecision int, ");
        sql.append(" FBASECONVSRATE Decimal(28,10),FStandUnitCost Decimal(21,8),fMaterialAmt Decimal(17,4) default 0 not null ,");
        sql.append(" funwriteOffamt Decimal(17,4) default 0 not null ,fwriteAmtAfter Decimal(17,4) default 0 not null,FwriteAmtcur Decimal(17,4)default 0 not null,");
        sql.append(" funwriteOffQty Decimal(21,8) default 0 not null,fwriteQtyAfter Decimal(21,8) default 0 not null,FwriteQtycur Decimal(21,8) default 0 not null");
        sql.append(")");
        String idDetailTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        try {
            Integer spnYear = (Integer)params.getObject("Year");
            Integer spnPeriod = (Integer)params.getObject("Period");
            boolean isMulti = params.getBoolean("isMulti");
            String subTitle = SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.sc.SubContractResource", (String)"SubContractInWarehs_BillName", (Context)ctx);
            String purTitle = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"PurInWarehsBill", (Context)ctx);
            sql.append(" insert into ").append(idDetailTable).append(" \n");
            sql.append(" ( FbillPeriod,FbillID,fentryID,FbillTypeID,FbillTypeName,FbillNumber,FAccountType,");
            sql.append(" FAmtPrecision,FBASECONVSRATE,FStandUnitCost,fMaterialAmt,funwriteOffQty,funwriteOffamt )\n");
            sql.append(" select distinct Bill.Fyear*100+Bill.fperiod,Bill.fid,entry.fid,Bill.fbillTypeID,\n");
            sql.append(" case when bill.FPURCHASETYPE = 0 then '").append(purTitle);
            sql.append("' else '").append(subTitle).append("' end \n ");
            sql.append(" ,bill.fnumber ,matCom.FAccountType,currency.FPRECISION,unit.FBASECONVSRATE,entry.FUNITSTANDARDCOST,");
            sql.append(" case when bill.FPURCHASETYPE = 0 then 0 else entry.FMATERIALCOST end,");
            sql.append(" entry.FUNWRITEOFFQTY,entry.FUNWRITEOFFAMOUNT").append(" \n");
            sql.append(" from T_im_purinwarehsbill Bill ").append(" \n");
            sql.append(" inner join T_im_purinwarehsentry entry on Bill.fid = entry.fparentid ").append(" \n");
            sql.append(" left join t_cl_writeOffrecord record on entry.fid = record.FBILLENTRYID");
            sql.append(" inner join T_scm_transactiontype transType on Bill.ftransactiontypeid = transType.fid ").append(" \n");
            sql.append(" inner Join T_IM_InvUpdateType invType on entry.FInvUpdateTypeID = invType.FID ").append(" \n");
            sql.append(" Inner Join T_IM_StoreType sType on invType.FStoreTypeID = sType.FID ").append(" \n");
            sql.append(" Inner Join T_BD_MaterialCompanyInfo matCom ON entry.FMaterialID = matCom.FMaterialID AND entry.FCompanyOrgUnitID = matCom.FCompanyID ").append(" \n");
            sql.append(" Inner Join T_BD_MultiMeasureUnit unit ON entry.FMaterialID = unit.FMaterialID AND entry.FUNITID = unit.FMEASUREUNITID ").append(" \n");
            sql.append(" Inner Join T_org_company comp ON entry.FCompanyOrgUnitID = comp.FID  ").append(" \n");
            sql.append(" Inner Join t_bd_currency currency ON comp.FBASECURRENCYID = currency.FID ").append(" \n");
            String actItemNumber = (String)params.getObject("ActItemNumber");
            if (isMulti && "1001".equals(actItemNumber)) {
                sql.append(" Inner Join T_BD_AccountView accView ON entry.FAccountViewInId = accView.FID  ").append(" \n");
            } else {
                sql.append(" Inner Join T_BD_KAClassificationDetail kaClass ON matCom.FKAClassID = kaClass.FKAClassFicLink ").append(" \n");
                sql.append(" Inner Join T_BD_KAccountItem kaItem ON kaClass.FAccountitemlinkID = kaItem.FID ").append(" \n");
                sql.append(" Inner Join T_BD_AccountView accView ON kaClass.FAccountLinkID = accView.FID  ").append(" \n");
            }
            sql.append(this.getCommonWhereSQL(params, isMulti && "1001".equals(actItemNumber)));
            if ("1005".equals(actItemNumber)) {
                sql.append(" And matCom.FAccountType = 2 ").append(" \n");
            }
            sql.append(" And transType.FISMANUCHECKACCOUNT = 1 ").append(" \n");
            sql.append(" and ((Bill.Fyear*100+Bill.fperiod =");
            sql.append(spnYear * 100 + spnPeriod).append(") \n");
            sql.append(" or (Bill.Fyear*100+Bill.fperiod <");
            sql.append(spnYear * 100 + spnPeriod).append(" and  record.fwriteoffyear*100+record.FWRITEOFFPERIOD =");
            sql.append(spnYear * 100 + spnPeriod).append(")) \n");
            sql.append(this.getIsCalculateWhereSQL(params));
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(idDetailTable).append(" A set (fwriteAmtAfter,fwriteQtyAfter) = ").append(" \n");
            sql.append(" (select T.fwriteOffamt,T.fwriteOffqty from ( select sum(B.FCURRWRITTENOFFAMOUNT) fwriteOffamt, ").append(" \n");
            sql.append(" sum(isnull(B.FCURRWRITTENOFFQTY,0)*C.FBASECONVSRATE) fwriteOffqty,");
            sql.append(" B.FBILLENTRYID FentryID from  ").append(" \n");
            sql.append(" t_cl_writeOffrecord B  ").append(" \n");
            sql.append(" inner join ").append(idDetailTable).append(" C on B.FBILLENTRYID = C.fentryID ").append(" \n");
            sql.append(" where B.FWRITEOFFYEAR *100 +B.FWRITEOFFPERIOD >").append(" \n");
            sql.append(spnYear * 100 + spnPeriod);
            sql.append(" group by B.FBILLENTRYID) T where A.Fentryid = T.FentryID) ");
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(idDetailTable).append(" A set (FwriteAmtcur,FwriteQtycur) = ").append(" \n");
            sql.append(" (select T.fwriteOffamt,T.FwriteOffQty ");
            sql.append("from ( select sum(isnull(B.FCURRWRITTENOFFAMOUNT,0)) fwriteOffamt, ").append(" \n");
            sql.append(" sum(isnull(B.FCURRWRITTENOFFQTY,0)*C.FBASECONVSRATE) FwriteOffQty ").append(" \n");
            sql.append(" ,B.FBILLENTRYID FentryID from  ").append(" \n");
            sql.append(" t_cl_writeOffrecord B  ").append(" \n");
            sql.append(" inner join ").append(idDetailTable).append(" C on B.FBILLENTRYID = C.fentryID ").append(" \n");
            sql.append(" where B.FWRITEOFFYEAR = ").append(spnYear);
            sql.append(" AND B.FWRITEOFFPERIOD = ").append(spnPeriod).append(" \n");
            sql.append(" group by B.FBILLENTRYID) T where A.Fentryid = T.FentryID) ");
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" insert into ").append(invBillTable).append(" \n");
            sql.append(" (FbillPeriod,FbillID,FbillTypeID,FbillTypeName,FbillNumber,");
            sql.append(" FtempAmount,FPurAmount ,Fdischgamt)").append(" \n");
            sql.append(" select A.FbillPeriod,A.FbillID ,A.FbillTypeID,A.FbillTypeName,A.FbillNumber, ");
            if ("1001".equals(actItemNumber)) {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(Round((isnull(A.funwriteOffQty,0)+isnull(A.fwriteQtyAfter,0)+isnull(A.FwriteQtycur,0))*A.FStandUnitCost,A.FAmtPrecision)) ");
            } else {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(isnull(A.funwriteOffamt,0) + isnull(A.fwriteAmtAfter,0)+isnull(A.FwriteAmtcur,0)+isnull(A.fMaterialAmt,0) ");
                sql.append(" - Round((isnull(A.funwriteOffQty,0)+isnull(A.fwriteQtyAfter,0)+isnull(A.FwriteQtycur,0))*A.FStandUnitCost,A.FAmtPrecision)) ");
            }
            sql.append(" else sum(isnull(A.funwriteOffamt,0) + isnull(A.FwriteAmtcur,0)+isnull(A.fwriteAmtAfter,0)+isnull(A.fMaterialAmt,0)) end , ");
            if ("1001".equals(actItemNumber)) {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(Round(isnull(A.FwriteQtycur,0) * A.FStandUnitCost,A.FAmtPrecision)) ");
            } else {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(isnull(A.fwriteAmtCur,0) ");
                sql.append(" - Round(isnull(A.FwriteQtycur,0) * A.FStandUnitCost,A.FAmtPrecision)) ");
            }
            sql.append(" else sum(isnull(A.fwriteAmtCur,0)) end,  ").append(" \n");
            if ("1001".equals(actItemNumber)) {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(Round(isnull(A.FwriteQtycur,0) * A.FStandUnitCost,A.FAmtPrecision))*-1 ");
            } else {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" (sum(isnull(A.fwriteAmtCur,0) ");
                sql.append(" - Round(isnull(A.FwriteQtycur,0) * A.FStandUnitCost,A.FAmtPrecision)))*-1 ");
            }
            sql.append(" else sum(isnull(A.fwriteAmtCur,0))*-1 end  ").append(" \n");
            sql.append(" from ").append(idDetailTable).append(" A ").append(" \n");
            sql.append(" group by A.FbillPeriod,A.FbillID ,A.FbillTypeID,A.FbillTypeName,A.FbillNumber,A.FAccountType");
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(invBillTable).append(" set FtempAmount = 0 where FbillPeriod < ");
            sql.append(spnYear * 100 + spnPeriod);
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" insert into ").append(invBillTable).append(" \n");
            sql.append(" (FbillPeriod,FbillID,FbillTypeID,FbillTypeName,FbillNumber,");
            sql.append(" FtempAmount,FPurAmount ,Fdischgamt)").append(" \n");
            sql.append(" select  Bill.Fyear*100+Bill.fperiod,Bill.fid,Bill.fbillTypeID,\n");
            sql.append(" billType.fname_").append(this.loc);
            sql.append(" ,bill.fnumber ,0,");
            if ("1001".equals(actItemNumber)) {
                sql.append(" sum(Case matCom.FAccountType when 2 then 0 else entry.FAmount end),");
            } else {
                sql.append(" sum(Case matCom.FAccountType when 2 then entry.FAmount else 0 end),");
            }
            sql.append(" 0");
            sql.append(" from T_CL_CostAdjustBill Bill ").append(" \n");
            sql.append(" inner join t_cl_costadjustbillentry entry on Bill.fid = entry.fparentid ").append(" \n");
            sql.append(" Inner Join T_SCM_BillType billType on bill.FBillTypeID = billType.FID ");
            sql.append(" Inner Join T_IM_StoreType sType on entry.FStoreTypeID = sType.FID ").append(" \n");
            sql.append(" Inner Join T_BD_MaterialCompanyInfo matCom ON entry.FMaterialID = matCom.FMaterialID AND entry.FCompanyOrgUnitID = matCom.FCompanyID ").append(" \n");
            if (isMulti && "1001".equals(actItemNumber)) {
                sql.append(" Inner Join T_BD_AccountView accView ON entry.FAccountViewInId = accView.FID  ").append(" \n");
            } else {
                sql.append(" Inner Join T_BD_KAClassificationDetail kaClass ON matCom.FKAClassID = kaClass.FKAClassFicLink ").append(" \n");
                sql.append(" Inner Join T_BD_KAccountItem kaItem ON kaClass.FAccountitemlinkID = kaItem.FID ").append(" \n");
                sql.append(" Inner Join T_BD_AccountView accView ON kaClass.FAccountLinkID = accView.FID  ").append(" \n");
            }
            sql.append(this.getCommonWhereSQL(params, isMulti && "1001".equals(actItemNumber)));
            if ("1005".equals(actItemNumber)) {
                sql.append(" And matCom.FAccountType = 2 ").append(" \n");
            }
            sql.append(" And bill.FCalculateKind = 0");
            sql.append(" and bill.FCREATETYPE in (0,11)");
            sql.append(" and Bill.Fyear*100+Bill.fperiod =");
            sql.append(spnYear * 100 + spnPeriod).append(" \n");
            sql.append(" group by Bill.Fyear*100+Bill.fperiod,Bill.fid,Bill.fbillTypeID,bill.fnumber,billType.fname_").append(this.loc);
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            String string = invBillTable;
            return string;
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)idDetailTable);
        }
    }

    private String getIsCalculateWhereSQL(RptParams params) {
        Boolean ckShowNoCalculate = (Boolean)params.getObject("ckShowNoCalculate");
        StringBuffer sSQL = new StringBuffer();
        if (ckShowNoCalculate != null && !ckShowNoCalculate.booleanValue()) {
            sSQL.append(" And transType.FIsCalculate = 1 ");
        }
        return sSQL.toString();
    }

    private String getCommonWhereSQL(RptParams params, boolean isMulti) {
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("bizCompnayOrg");
        String actItemNumber = (String)params.getObject("ActItemNumber");
        String actNumber = (String)params.getObject("ActNumber");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(" Where entry.FCompanyOrgUnitID = '").append(companyOrgUnitInfo.getId().toString()).append("'");
        sSQL.append(" And bill.FBaseStatus = ").append(4);
        if (!isMulti && !StringUtils.isEmpty((String)actItemNumber)) {
            sSQL.append(" And kaItem.FNumber = '").append(actItemNumber).append("'");
        }
        sSQL.append(" And accView.FNumber = '").append(actNumber).append("'");
        sSQL.append(" And sType.FIsForwardAmt = 1");
        return sSQL.toString();
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptParams rptParam = new RptParams();
        String reportDataTable = params.getString("tempTable");
        rptParam.setObject("rowset", (Object)this.getBillVoucherRowSet(ctx, reportDataTable));
        if ("2".equals(params.getString("dischargeType"))) {
            String invBTableDis = params.getString("billDisTable");
            rptParam.setObject("disRowSet", (Object)this.getBillVoucherRowSet(ctx, invBTableDis));
        }
        String invBTablePur = params.getString("billPurTable");
        rptParam.setObject("purRowSet", (Object)this.getBillVoucherRowSet(ctx, invBTablePur));
        return rptParam;
    }

    private RptRowSet getBillVoucherRowSet(Context ctx, String tempTable) throws BOSException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select FBillPeriod,FBillTypeID,FBillTypeName,FBillID,FBillNumber,FTempAmount,\n");
        sSQL.append("FVoucherID,FVoucherNumber,FVoucheramt \n");
        sSQL.append(" From ").append(tempTable);
        sSQL.append(" order by FbillNumber ");
        RptRowSet rs = this.executeQuery(sSQL.toString(), null, ctx);
        return rs;
    }

    private String getCreateTempSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" create table temp ( FBillPeriod INT,FBillID varchar(44),FBillTypeID varchar(44),");
        sql.append(" FBillTypeName nvarchar(255),FBillNumber nvarchar(80), ");
        sql.append(" FTempAmount Decimal(17,4),FVoucherID varchar(44),");
        sql.append(" FVoucherNumber nvarchar(80),FVoucherAmt Decimal(17,4),");
        sql.append(" FDiffAmt Decimal(17,4)");
        sql.append(" )");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildinvBillTable4Moth(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" create table temp ( FbillPeriod INT,FbillID varchar(44),FbillTypeID varchar(44),FIsInitBill int,");
        sql.append(" FbillTypeName nvarchar(255),FbillNumber nvarchar(80), ");
        sql.append(" FtempAmount Decimal(17,4),FTempVoucherID varchar(44),");
        sql.append(" FTempVoucherNumber nvarchar(80),FTempVoucheramt Decimal(17,4),");
        sql.append(" FTempDiff Decimal(17,4),FdischgVoucheramt Decimal(17,4),");
        sql.append(" FPurAmount Decimal(17,4) ,FpurinVoucherId varchar(44),");
        sql.append(" FpurinVoucherNumber nvarchar(80),FpurinVoucheramt Decimal(17,4),FpurinDiff Decimal(17,4) ");
        sql.append(" )");
        String invBillTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        KsqlUtil.createTempTableIndex((Context)ctx, (String)invBillTable, (String)"FTempVoucherID", (boolean)false);
        KsqlUtil.createTempTableIndex((Context)ctx, (String)invBillTable, (String)"FpurinVoucherId", (boolean)false);
        sql.setLength(0);
        sql.append(" create table temp ( FbillPeriod INT, FbillID varchar(44), fentryID varchar(44),FbillTypeID varchar(44),FIsInitBill int,");
        sql.append(" FbillTypeName nvarchar(255),FbillNumber nvarchar(80), FAccountType int,FAmtPrecision int, ");
        sql.append(" FBASECONVSRATE Decimal(28,10),FStandUnitCost Decimal(21,8),fMaterialAmt Decimal(17,4) default 0 not null ,");
        sql.append(" funwriteOffamt Decimal(17,4) default 0 not null ,fwriteAmtAfter Decimal(17,4) default 0 not null,FwriteAmtcur Decimal(17,4)default 0 not null,");
        sql.append(" funwriteOffQty Decimal(21,8) default 0 not null,fwriteQtyAfter Decimal(21,8) default 0 not null,FwriteQtycur Decimal(21,8) default 0 not null");
        sql.append(")");
        String idDetailTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        try {
            Integer spnYear = (Integer)params.getObject("Year");
            Integer spnPeriod = (Integer)params.getObject("Period");
            boolean isMulti = params.getBoolean("isMulti");
            String subTitle = SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.sc.SubContractResource", (String)"SubContractInWarehs_BillName", (Context)ctx);
            String purTitle = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"PurInWarehsBill", (Context)ctx);
            sql.append(" insert into ").append(idDetailTable).append(" \n");
            sql.append(" ( FbillPeriod,FbillID,fentryID,FbillTypeID,FIsInitBill,FbillTypeName,FbillNumber,FAccountType,");
            sql.append(" FAmtPrecision,FBASECONVSRATE,FStandUnitCost,fMaterialAmt,funwriteOffQty,funwriteOffamt )\n");
            sql.append(" select distinct Bill.Fyear*100+Bill.fperiod,Bill.fid,entry.fid,Bill.fbillTypeID,bill.FIsInitBill,\n");
            sql.append(" case when bill.FPURCHASETYPE = 0 then '").append(purTitle);
            sql.append("' else '").append(subTitle).append("' end \n ");
            sql.append(" ,bill.fnumber ,matCom.FAccountType,currency.FPRECISION,unit.FBASECONVSRATE,entry.FUNITSTANDARDCOST,");
            sql.append(" case when bill.FPURCHASETYPE = 0 then 0 else entry.FMATERIALCOST end,");
            sql.append(" entry.FUNWRITEOFFQTY,entry.FUNWRITEOFFAMOUNT").append(" \n");
            sql.append(" from T_im_purinwarehsbill Bill ").append(" \n");
            sql.append(" inner join T_im_purinwarehsentry entry on Bill.fid = entry.fparentid ").append(" \n");
            sql.append(" left join t_cl_writeOffrecord record on entry.fid = record.FBILLENTRYID");
            sql.append(" inner join T_scm_transactiontype transType on Bill.ftransactiontypeid = transType.fid ").append(" \n");
            sql.append(" inner Join T_IM_InvUpdateType invType on entry.FInvUpdateTypeID = invType.FID ").append(" \n");
            sql.append(" Inner Join T_IM_StoreType sType on invType.FStoreTypeID = sType.FID ").append(" \n");
            sql.append(" Inner Join T_BD_MaterialCompanyInfo matCom ON entry.FMaterialID = matCom.FMaterialID AND entry.FCompanyOrgUnitID = matCom.FCompanyID ").append(" \n");
            sql.append(" Inner Join T_BD_MultiMeasureUnit unit ON entry.FMaterialID = unit.FMaterialID AND entry.FUNITID = unit.FMEASUREUNITID ").append(" \n");
            sql.append(" Inner Join T_org_company comp ON entry.FCompanyOrgUnitID = comp.FID  ").append(" \n");
            sql.append(" Inner Join t_bd_currency currency ON comp.FBASECURRENCYID = currency.FID ").append(" \n");
            String actItemNumber = (String)params.getObject("ActItemNumber");
            if (isMulti && "1001".equals(actItemNumber)) {
                sql.append(" Inner Join T_BD_AccountView accView ON entry.FAccountViewInId = accView.FID  ").append(" \n");
            } else {
                sql.append(" Inner Join T_BD_KAClassificationDetail kaClass ON matCom.FKAClassID = kaClass.FKAClassFicLink ").append(" \n");
                sql.append(" Inner Join T_BD_KAccountItem kaItem ON kaClass.FAccountitemlinkID = kaItem.FID ").append(" \n");
                sql.append(" Inner Join T_BD_AccountView accView ON kaClass.FAccountLinkID = accView.FID  ").append(" \n");
            }
            sql.append(this.getCommonWhereSQL(params, isMulti && "1001".equals(actItemNumber)));
            if ("1005".equals(actItemNumber)) {
                sql.append(" And matCom.FAccountType = 2 ").append(" \n");
            }
            sql.append(" And transType.FISMANUCHECKACCOUNT = 1 ").append(" \n");
            sql.append(" and (entry.FUNWRITEOFFAMOUNT <> 0 or record.fwriteoffyear*100+record.FWRITEOFFPERIOD >=");
            sql.append(spnYear * 100 + spnPeriod).append(") \n");
            sql.append(" and Bill.Fyear*100+Bill.fperiod <=");
            sql.append(spnYear * 100 + spnPeriod).append(" \n");
            sql.append(this.getIsCalculateWhereSQL(params));
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(idDetailTable).append(" A set (fwriteAmtAfter,fwriteQtyAfter) = ").append(" \n");
            sql.append(" (select T.fwriteOffamt,T.fwriteOffqty from ( select sum(B.FCURRWRITTENOFFAMOUNT) fwriteOffamt, ").append(" \n");
            sql.append(" sum(isnull(B.FCURRWRITTENOFFQTY,0)*C.FBASECONVSRATE) fwriteOffqty,");
            sql.append(" B.FBILLENTRYID FentryID from  ").append(" \n");
            sql.append(" t_cl_writeOffrecord B  ").append(" \n");
            sql.append(" inner join ").append(idDetailTable).append(" C on B.FBILLENTRYID = C.fentryID ").append(" \n");
            sql.append(" where B.FWRITEOFFYEAR *100 +B.FWRITEOFFPERIOD >").append(" \n");
            sql.append(spnYear * 100 + spnPeriod);
            sql.append(" group by B.FBILLENTRYID) T where A.Fentryid = T.FentryID) ");
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(idDetailTable).append(" A set (FwriteAmtcur,FwriteQtycur) = ").append(" \n");
            sql.append(" (select T.fwriteOffamt,T.FwriteOffQty ");
            sql.append("from ( select sum(isnull(B.FCURRWRITTENOFFAMOUNT,0)) fwriteOffamt, ").append(" \n");
            sql.append(" sum(isnull(B.FCURRWRITTENOFFQTY,0)*C.FBASECONVSRATE) FwriteOffQty ").append(" \n");
            sql.append(" ,B.FBILLENTRYID FentryID from  ").append(" \n");
            sql.append(" t_cl_writeOffrecord B  ").append(" \n");
            sql.append(" inner join ").append(idDetailTable).append(" C on B.FBILLENTRYID = C.fentryID ").append(" \n");
            sql.append(" where B.FWRITEOFFYEAR = ").append(spnYear);
            sql.append(" AND B.FWRITEOFFPERIOD = ").append(spnPeriod).append(" \n");
            sql.append(" group by B.FBILLENTRYID) T where A.Fentryid = T.FentryID) ");
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" insert into ").append(invBillTable).append(" \n");
            sql.append(" (FbillPeriod,FbillID,FbillTypeID,FIsInitBill,FbillTypeName,FbillNumber,");
            sql.append(" FtempAmount,FPurAmount )").append(" \n");
            sql.append(" select A.FbillPeriod,A.FbillID ,A.FbillTypeID,A.FIsInitBill,A.FbillTypeName,A.FbillNumber, ");
            if ("1001".equals(actItemNumber)) {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(Round((isnull(A.funwriteOffQty,0)+isnull(A.fwriteQtyAfter,0))*A.FStandUnitCost,A.FAmtPrecision)) ");
            } else {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(isnull(A.funwriteOffamt,0) + isnull(A.fwriteAmtAfter,0)+isnull(A.fMaterialAmt,0) ");
                sql.append(" - Round((A.funwriteOffQty+A.fwriteQtyAfter)*A.FStandUnitCost,A.FAmtPrecision)) ");
            }
            sql.append(" else sum(isnull(A.funwriteOffamt,0) + isnull(A.fwriteAmtAfter,0)+isnull(A.fMaterialAmt,0)) end , ");
            if ("1001".equals(actItemNumber)) {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(Round(isnull(A.FwriteQtycur,0) * A.FStandUnitCost,A.FAmtPrecision)) ");
            } else {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(isnull(A.fwriteAmtCur,0) ");
                sql.append(" - Round(isnull(A.FwriteQtycur,0) * A.FStandUnitCost,A.FAmtPrecision)) ");
            }
            sql.append(" else sum(isnull(A.fwriteAmtCur,0)) end from ").append(" \n");
            sql.append(idDetailTable).append(" A ").append(" \n");
            sql.append(" group by A.FbillPeriod,A.FbillID ,A.FbillTypeID,FIsInitBill,A.FbillTypeName,A.FbillNumber,A.FAccountType");
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("update ").append(invBillTable).append(" set FtempAmount = 0 where isnull(FIsInitBill,0) = 1 ");
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" insert into ").append(invBillTable).append(" \n");
            sql.append(" (FbillPeriod,FbillID,FbillTypeID,FbillTypeName,FbillNumber,");
            sql.append(" FtempAmount,FPurAmount )").append(" \n");
            sql.append(" select  Bill.Fyear*100+Bill.fperiod,Bill.fid,Bill.fbillTypeID,\n");
            sql.append(" billType.fname_").append(this.loc);
            sql.append(" ,bill.fnumber ,0,");
            if ("1001".equals(actItemNumber)) {
                sql.append(" sum(Case matCom.FAccountType when 2 then 0 else entry.FAmount end)");
            } else {
                sql.append(" sum(Case matCom.FAccountType when 2 then entry.FAmount else 0 end)");
            }
            sql.append(" from T_CL_CostAdjustBill Bill ").append(" \n");
            sql.append(" inner join t_cl_costadjustbillentry entry on Bill.fid = entry.fparentid ").append(" \n");
            sql.append(" Inner Join T_SCM_BillType billType on bill.FBillTypeID = billType.FID ");
            sql.append(" Inner Join T_IM_StoreType sType on entry.FStoreTypeID = sType.FID ").append(" \n");
            sql.append(" Inner Join T_BD_MaterialCompanyInfo matCom ON entry.FMaterialID = matCom.FMaterialID AND entry.FCompanyOrgUnitID = matCom.FCompanyID ").append(" \n");
            if (isMulti && "1001".equals(actItemNumber)) {
                sql.append(" Inner Join T_BD_AccountView accView ON entry.FAccountViewInId = accView.FID  ").append(" \n");
            } else {
                sql.append(" Inner Join T_BD_KAClassificationDetail kaClass ON matCom.FKAClassID = kaClass.FKAClassFicLink ").append(" \n");
                sql.append(" Inner Join T_BD_KAccountItem kaItem ON kaClass.FAccountitemlinkID = kaItem.FID ").append(" \n");
                sql.append(" Inner Join T_BD_AccountView accView ON kaClass.FAccountLinkID = accView.FID  ").append(" \n");
            }
            sql.append(this.getCommonWhereSQL(params, isMulti && "1001".equals(actItemNumber)));
            if ("1005".equals(actItemNumber)) {
                sql.append(" And matCom.FAccountType = 2 ").append(" \n");
            }
            sql.append(" And bill.FCalculateKind = 0");
            sql.append(" and bill.FCREATETYPE in (0,11)");
            sql.append(" and Bill.Fyear*100+Bill.fperiod =");
            sql.append(spnYear * 100 + spnPeriod).append(" \n");
            sql.append(" group by Bill.Fyear*100+Bill.fperiod,Bill.fid,Bill.fbillTypeID,bill.fnumber,billType.fname_").append(this.loc);
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            String string = invBillTable;
            return string;
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)idDetailTable);
        }
    }

    private String buildDischgVoucherTable4Moth(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table VoucherTempReportTable (");
        sql.append("FdischgAmount decimal(17, 4)");
        sql.append(")");
        String dischgVoucherTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" insert into ").append(dischgVoucherTable);
        sql.append(" (FdischgAmount)");
        sql.append(" Select sum(entry.FLocalAmount) ");
        sql.append(" From T_GL_Voucher bill ");
        sql.append(" Inner Join T_GL_VoucherEntry entry on bill.FID = entry.FBillID ");
        sql.append(" Inner Join T_BD_AccountView accView on entry.FAccountID = accView.FID ");
        sql.append(" Inner Join T_BD_Period prd on bill.FPeriodID = prd.FID ");
        sql.append(this.getGLWhereSQL(params));
        sql.append(" and exists (select 1 from t_im_purinwarehsvoucher PV ");
        sql.append("  where PV.FVOUCHERID = bill.fid and PV.FVOUCHERTYPE =  2 ) ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        return dischgVoucherTable;
    }
}

