/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.app.AbstractInvCKAccountBPCDetailFacadeControllerBean;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class InvCKAccountBPCDetailFacadeControllerBean
extends AbstractInvCKAccountBPCDetailFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.InvCKAccountBPCDetailFacadeControllerBean");
    private String loc;

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.loc = this.getLoc(ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        String invBillTable = this.buildinvBillTable(ctx, params);
        String tempVoucherTable = this.buildTempVoucherTable(ctx, params);
        String dischgVoucherTable = this.buildDischgVoucherTable(ctx, params);
        String purInVoucherTable = this.buildPurInVoucherTable(ctx, params);
        try {
            this.dealTempField(ctx, invBillTable, tempVoucherTable);
            this.dealDischgField(ctx, invBillTable, dischgVoucherTable);
            this.dealPurInField(ctx, invBillTable, purInVoucherTable);
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new EASBizException(new NumericExceptionSubItem("01", SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"INVACCOUNT_DETAILED_TIP", (Context)ctx)));
        }
        int count = this.getRecordCount(ctx, params, invBillTable);
        this.dropTempTable(purInVoucherTable, ctx);
        this.dropTempTable(tempVoucherTable, ctx);
        this.dropTempTable(dischgVoucherTable, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", invBillTable);
        result.setInt("recordCount", count);
        try {
            this.getTotalRowData(ctx, result);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private int getRecordCount(Context ctx, RptParams params, String invBillTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) num from ").append(invBillTable);
        boolean isShowException = params.getBoolean("isShowException");
        if (isShowException) {
            sql.append(" Where FTempDiff <> 0 or FpurinDiff <> 0");
        }
        IRowSet rs = KsqlUtil.executeQuery((Context)ctx, (String)sql.toString());
        int count = 0;
        try {
            if (rs.next()) {
                count = rs.getInt("num");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return count;
    }

    private void dealPurInField(Context ctx, String invBillTable, String purInVoucherTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(invBillTable).append(" T \n");
        sql.append(" set (FpurinVoucherId,FpurinVoucherNumber,FpurinVoucheramt) = \n");
        sql.append(" (select B.FpurInVoucherID,B.FpurInVoucherNumber ,B.FpurInAmount from \n");
        sql.append(invBillTable).append(" A \n");
        sql.append(" inner join t_bot_relation R on a.FbillID = R.fsrcobjectid \n");
        sql.append(" inner join ").append(purInVoucherTable).append(" B on R.fdestObjectid = B.FpurInVoucherID \n");
        sql.append(" where T.FbillID = A.FbillID ) ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" insert into ").append(invBillTable).append(" ");
        sql.append(" (FpurinVoucherId,FpurinVoucherNumber,FpurinVoucheramt)  \n");
        sql.append(" select B.FpurInVoucherID,B.FpurInVoucherNumber ,B.FpurInAmount from \n");
        sql.append(purInVoucherTable).append(" B \n");
        sql.append(" where not exists(select 1 from  ").append(invBillTable);
        sql.append(" A where A.FpurinVoucherId = B.FpurInVoucherID) ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update ").append(invBillTable).append(" T set FpurinDiff = ( ");
        sql.append(" select famt from (select sum(isnull(A.FPurAmount,0)) - max(isnull(A.FpurinVoucheramt,0)) famt, ");
        sql.append(" A.FpurInVoucherID fvoucherid ");
        sql.append(" from  ").append(invBillTable).append(" A ");
        sql.append(" group by A.FpurinVoucherId ) B where B.fvoucherid = T.FpurinVoucherId )");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update ").append(invBillTable).append(" T set FpurinDiff = FPurAmount ");
        sql.append("   where  T.FpurinVoucherId is null ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
    }

    private void dealDischgField(Context ctx, String invBillTable, String dischgVoucherTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(invBillTable).append(" T \n");
        sql.append(" set FdischgVoucheramt = \n");
        sql.append(" (select isnull(A.FdischgAmount,0) from \n");
        sql.append(dischgVoucherTable).append(" A ) \n");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
    }

    private void dealTempField(Context ctx, String invBillTable, String tempVoucherTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(invBillTable).append(" T \n");
        sql.append(" set (FTempVoucherID,FTempVoucherNumber,FTempVoucheramt) = \n");
        sql.append(" (select B.FtempVoucherID,B.FtempVoucherNumber ,B.FtempAmount from \n");
        sql.append(invBillTable).append(" A \n");
        sql.append(" inner join t_bot_relation R on a.FbillID = R.fsrcobjectid \n");
        sql.append(" inner join ").append(tempVoucherTable).append(" B on R.fdestObjectid = B.FtempVoucherID \n");
        sql.append(" where T.FbillID = A.FbillID ) ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" insert into ").append(invBillTable).append(" ");
        sql.append(" (FTempVoucherID,FTempVoucherNumber,FTempVoucheramt)  \n");
        sql.append(" select B.FtempVoucherID,B.FtempVoucherNumber ,B.FtempAmount from \n");
        sql.append(tempVoucherTable).append(" B \n");
        sql.append(" where not exists(select 1 from  ").append(invBillTable);
        sql.append(" A where A.FTempVoucherID = B.FtempVoucherID) ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update ").append(invBillTable).append(" T set FTempDiff = ( ");
        sql.append(" select famt from (select sum(isnull(A.FtempAmount,0)) - max(isnull(A.FTempVoucheramt,0)) famt, ");
        sql.append(" A.FTempVoucherID fvoucherid ");
        sql.append(" from  ").append(invBillTable).append(" A ");
        sql.append(" group by A.FTempVoucherID ) B where B.fvoucherid = T.FTempVoucherID )");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update ").append(invBillTable).append(" T set FTempDiff = FtempAmount");
        sql.append("  where T.FTempVoucherID is null ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
    }

    private void getTotalRowData(Context ctx, RptParams result) throws Exception {
        String invTbl = result.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(isnull(FtempAmount,0)) ftempAmt,sum(isnull(FPurAmount,0)) fPurInAmt from ");
        sql.append(invTbl);
        IRowSet rs = KsqlUtil.executeQuery((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        if (rs.next()) {
            result.setBigDecimal("totalTempAmt", rs.getBigDecimal("ftempAmt"));
            result.setBigDecimal("totalPurinAmt", rs.getBigDecimal("fPurInAmt"));
        }
        sql.append(" select sum(isnull(FTempVoucheramt,0)) ftotalTempVAmt,sum(isnull(FTempDiff,0)) FTotalTempDiff from ");
        sql.append(" (select distinct FTempVoucherID,FTempVoucheramt,FTempDiff from ");
        sql.append(invTbl);
        sql.append("  )");
        rs = KsqlUtil.executeQuery((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        if (rs.next()) {
            result.setBigDecimal("totalTempVoucherAmt", rs.getBigDecimal("ftotalTempVAmt"));
            result.setBigDecimal("totalTempDiff", rs.getBigDecimal("FTotalTempDiff"));
        }
        sql.append(" select distinct isnull(FdischgVoucheramt,0) FdischgVoucheramt from ");
        sql.append(invTbl);
        rs = KsqlUtil.executeQuery((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        if (rs.next()) {
            result.setBigDecimal("totalDischgAmt", rs.getBigDecimal("FdischgVoucheramt"));
        }
        sql.append(" select sum(isnull(FpurinVoucheramt,0)) ftotalPurinVAmt,sum(isnull(FpurinDiff,0)) FTotalPurDiff from ");
        sql.append(" (select distinct FpurinVoucherId,FpurinVoucheramt,FpurinDiff from ");
        sql.append(invTbl);
        sql.append("  )");
        rs = KsqlUtil.executeQuery((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        if (rs.next()) {
            result.setBigDecimal("totalPurVoucherAmt", rs.getBigDecimal("ftotalPurinVAmt"));
            result.setBigDecimal("totalPurDiff", rs.getBigDecimal("FTotalPurDiff"));
        }
    }

    private String buildPurInVoucherTable(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table VoucherTempReportTable (");
        sql.append("FpurInVoucherID Varchar(44) NOT NULL,");
        sql.append("FpurInVoucherNumber Varchar(255),");
        sql.append("FpurInAmount decimal(17, 4)");
        sql.append(")");
        String purInVoucherTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" insert into ").append(purInVoucherTable);
        sql.append(" (FpurInVoucherID,FpurInVoucherNumber,FpurInAmount)");
        sql.append(" Select bill.FID, bill.FNumber, sum(entry.FLocalAmount) ");
        sql.append(" From T_GL_Voucher bill ");
        sql.append(" Inner Join T_GL_VoucherEntry entry on bill.FID = entry.FBillID ");
        sql.append(" Inner Join T_BD_AccountView accView on entry.FAccountID = accView.FID ");
        sql.append(" Inner Join T_BD_Period prd on bill.FPeriodID = prd.FID ");
        sql.append(this.getGLWhereSQL(params));
        sql.append(" and exists (select 1 from t_im_purinwarehsvoucher PV ");
        sql.append("  where PV.FVOUCHERID = bill.fid and PV.FVOUCHERTYPE =  0 ) ");
        sql.append(" group by bill.FID, bill.FNumber ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        return purInVoucherTable;
    }

    private String buildDischgVoucherTable(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table VoucherTempReportTable (");
        sql.append("FdischgAmount decimal(17, 4)");
        sql.append(")");
        String dischgVoucherTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" insert into ").append(dischgVoucherTable);
        sql.append(" (FdischgAmount)");
        sql.append(" Select sum(entry.FLocalAmount) ");
        sql.append(" From T_GL_Voucher bill ");
        sql.append(" Inner Join T_GL_VoucherEntry entry on bill.FID = entry.FBillID ");
        sql.append(" Inner Join T_BD_AccountView accView on entry.FAccountID = accView.FID ");
        sql.append(" Inner Join T_BD_Period prd on bill.FPeriodID = prd.FID ");
        sql.append(this.getGLWhereSQL(params));
        sql.append(" and exists (select 1 from t_im_purinwarehsvoucher PV ");
        sql.append("  where PV.FVOUCHERID = bill.fid and PV.FVOUCHERTYPE =  2 ) ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        return dischgVoucherTable;
    }

    private String buildTempVoucherTable(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table VoucherTempReportTable (");
        sql.append("FtempVoucherID Varchar(44) NOT NULL,");
        sql.append("FtempVoucherNumber Varchar(255),");
        sql.append("FtempAmount decimal(17, 4)");
        sql.append(")");
        String tempVoucherTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" insert into ").append(tempVoucherTable);
        sql.append(" (FtempVoucherID,FtempVoucherNumber,FtempAmount)");
        sql.append(" Select bill.FID, bill.FNumber, sum(entry.FLocalAmount) ");
        sql.append(" From T_GL_Voucher bill ");
        sql.append(" Inner Join T_GL_VoucherEntry entry on bill.FID = entry.FBillID ");
        sql.append(" Inner Join T_BD_AccountView accView on entry.FAccountID = accView.FID ");
        sql.append(" Inner Join T_BD_Period prd on bill.FPeriodID = prd.FID ");
        sql.append(this.getGLWhereSQL(params));
        sql.append(" and exists (select 1 from t_im_purinwarehsvoucher PV ");
        sql.append("  where PV.FVOUCHERID = bill.fid and PV.FVOUCHERTYPE =  1 ) ");
        sql.append(" group by bill.FID, bill.FNumber ");
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
        return tempVoucherTable;
    }

    private String getGLWhereSQL(RptParams params) {
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("bizCompnayOrg");
        Integer spnYear = (Integer)params.getObject("Year");
        Integer spnPeriod = (Integer)params.getObject("Period");
        String actNumber = (String)params.getObject("ActNumber");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Where bill.FCompanyID = '").append(companyOrgUnitInfo.getId().toString()).append("'");
        sSQL.append(" And prd.FPeriodYear = ").append(spnYear);
        sSQL.append(" And prd.FPeriodNumber = ").append(spnPeriod);
        sSQL.append(" And accView.FNumber = '").append(actNumber).append("'");
        sSQL.append(" And entry.FEntryDC = 1");
        sSQL.append(" And (bill.FBizStatus = ").append(1);
        sSQL.append(" or bill.FBizStatus = ").append(3);
        sSQL.append(" or bill.FBizStatus = ").append(5).append(")");
        return sSQL.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildinvBillTable(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" create table temp ( FbillPeriod INT,FbillID varchar(44),FbillTypeID varchar(44),");
        sql.append(" FbillTypeName nvarchar(255),FbillNumber nvarchar(80), ");
        sql.append(" FtempAmount Decimal(17,4),FTempVoucherID varchar(44),");
        sql.append(" FTempVoucherNumber nvarchar(80),FTempVoucheramt Decimal(17,4),");
        sql.append(" FTempDiff Decimal(17,4),FdischgVoucheramt Decimal(17,4),");
        sql.append(" FPurAmount Decimal(17,4) ,FpurinVoucherId varchar(44),");
        sql.append(" FpurinVoucherNumber nvarchar(80),FpurinVoucheramt Decimal(17,4),FpurinDiff Decimal(17,4) ");
        sql.append(" )");
        String invBillTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        KsqlUtil.createTempTableIndex((Context)ctx, (String)invBillTable, (String)"FTempVoucherID", (boolean)false);
        KsqlUtil.createTempTableIndex((Context)ctx, (String)invBillTable, (String)"FpurinVoucherId", (boolean)false);
        sql.setLength(0);
        sql.append(" create table temp ( FbillPeriod INT, FbillID varchar(44), fentryID varchar(44),FbillTypeID varchar(44),");
        sql.append(" FbillTypeName nvarchar(255),FbillNumber nvarchar(80), FAccountType int,FAmtPrecision int, ");
        sql.append(" FBASECONVSRATE Decimal(28,10),FStandUnitCost Decimal(21,8),fMaterialAmt Decimal(17,4) default 0 not null ,");
        sql.append(" funwriteOffamt Decimal(17,4) default 0 not null ,fwriteAmtAfter Decimal(17,4) default 0 not null,FwriteAmtcur Decimal(17,4)default 0 not null,");
        sql.append(" funwriteOffQty Decimal(21,8) default 0 not null,fwriteQtyAfter Decimal(21,8) default 0 not null,FwriteQtycur Decimal(21,8) default 0 not null");
        sql.append(")");
        String idDetailTable = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        try {
            Integer spnYear = (Integer)params.getObject("Year");
            Integer spnPeriod = (Integer)params.getObject("Period");
            boolean isMulti = params.getBoolean("isMulti");
            String subTitle = SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.sc.SubContractResource", (String)"SubContractInWarehs_BillName", (Context)ctx);
            String purTitle = SCMUtils.getResource((String)"com.kingdee.eas.scm.im.inv.WarehsManageResource", (String)"PurInWarehsBill", (Context)ctx);
            sql.append(" insert into ").append(idDetailTable).append(" \n");
            sql.append(" ( FbillPeriod,FbillID,fentryID,FbillTypeID,FbillTypeName,FbillNumber,FAccountType,");
            sql.append(" FAmtPrecision,FBASECONVSRATE,FStandUnitCost,fMaterialAmt,funwriteOffQty,funwriteOffamt )\n");
            sql.append(" select distinct Bill.Fyear*100+Bill.fperiod,Bill.fid,entry.fid,Bill.fbillTypeID,\n");
            sql.append(" case when bill.FPURCHASETYPE = 0 then '").append(purTitle);
            sql.append("' else '").append(subTitle).append("' end \n ");
            sql.append(" ,bill.fnumber ,matCom.FAccountType,currency.FPRECISION,unit.FBASECONVSRATE,entry.FUNITSTANDARDCOST,");
            sql.append(" case when bill.FPURCHASETYPE = 0 then 0 else entry.FMATERIALCOST end,");
            sql.append(" entry.FUNWRITEOFFQTY,entry.FUNWRITEOFFAMOUNT").append(" \n");
            sql.append(" from T_im_purinwarehsbill Bill ").append(" \n");
            sql.append(" inner join T_im_purinwarehsentry entry on Bill.fid = entry.fparentid ").append(" \n");
            sql.append(" left join t_cl_writeOffrecord record on entry.fid = record.FBILLENTRYID");
            sql.append(" inner join T_scm_transactiontype transType on Bill.ftransactiontypeid = transType.fid ").append(" \n");
            sql.append(" inner Join T_IM_InvUpdateType invType on entry.FInvUpdateTypeID = invType.FID ").append(" \n");
            sql.append(" Inner Join T_IM_StoreType sType on invType.FStoreTypeID = sType.FID ").append(" \n");
            sql.append(" Inner Join T_BD_MaterialCompanyInfo matCom ON entry.FMaterialID = matCom.FMaterialID AND entry.FCompanyOrgUnitID = matCom.FCompanyID ").append(" \n");
            sql.append(" Inner Join T_BD_MultiMeasureUnit unit ON entry.FMaterialID = unit.FMaterialID AND entry.FUNITID = unit.FMEASUREUNITID ").append(" \n");
            sql.append(" Inner Join T_org_company comp ON entry.FCompanyOrgUnitID = comp.FID  ").append(" \n");
            sql.append(" Inner Join t_bd_currency currency ON comp.FBASECURRENCYID = currency.FID ").append(" \n");
            String actItemNumber = (String)params.getObject("ActItemNumber");
            if (isMulti && "1001".equals(actItemNumber)) {
                sql.append(" Inner Join T_BD_AccountView accView ON entry.FAccountViewInId = accView.FID  ").append(" \n");
            } else {
                sql.append(" Inner Join T_BD_KAClassificationDetail kaClass ON matCom.FKAClassID = kaClass.FKAClassFicLink ").append(" \n");
                sql.append(" Inner Join T_BD_KAccountItem kaItem ON kaClass.FAccountitemlinkID = kaItem.FID ").append(" \n");
                sql.append(" Inner Join T_BD_AccountView accView ON kaClass.FAccountLinkID = accView.FID  ").append(" \n");
            }
            sql.append(this.getCommonWhereSQL(params, isMulti && actItemNumber.equals("1001")));
            if ("1005".equals(actItemNumber)) {
                sql.append(" And matCom.FAccountType = 2 ").append(" \n");
            }
            sql.append(" And transType.FISMANUCHECKACCOUNT = 1 ").append(" \n");
            sql.append(" And ISNULL(bill.FIsInitBill, 0) = 0").append(" \n");
            sql.append(" and (entry.FUNWRITEOFFAMOUNT <> 0 or record.fwriteoffyear*100+record.FWRITEOFFPERIOD >=");
            sql.append(spnYear * 100 + spnPeriod).append(") \n");
            sql.append(" and Bill.Fyear*100+Bill.fperiod <=");
            sql.append(spnYear * 100 + spnPeriod).append(" \n");
            sql.append(this.getIsCalculateWhereSQL(params));
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(idDetailTable).append(" A set (fwriteAmtAfter,fwriteQtyAfter) = ").append(" \n");
            sql.append(" (select T.fwriteOffamt,T.fwriteOffqty from ( select sum(B.FCURRWRITTENOFFAMOUNT) fwriteOffamt, ").append(" \n");
            sql.append(" sum(isnull(B.FCURRWRITTENOFFQTY,0)*C.FBASECONVSRATE) fwriteOffqty,");
            sql.append(" B.FBILLENTRYID FentryID from  ").append(" \n");
            sql.append(" t_cl_writeOffrecord B  ").append(" \n");
            sql.append(" inner join ").append(idDetailTable).append(" C on B.FBILLENTRYID = C.fentryID ").append(" \n");
            sql.append(" where B.FWRITEOFFYEAR *100 +B.FWRITEOFFPERIOD >").append(" \n");
            sql.append(spnYear * 100 + spnPeriod);
            sql.append(" group by B.FBILLENTRYID) T where A.Fentryid = T.FentryID) ");
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(idDetailTable).append(" A set (FwriteAmtcur,FwriteQtycur) = ").append(" \n");
            sql.append(" (select T.fwriteOffamt,T.FwriteOffQty ");
            sql.append("from ( select sum(isnull(B.FCURRWRITTENOFFAMOUNT,0)) fwriteOffamt, ").append(" \n");
            sql.append(" sum(isnull(B.FCURRWRITTENOFFQTY,0)*C.FBASECONVSRATE) FwriteOffQty ").append(" \n");
            sql.append(" ,B.FBILLENTRYID FentryID from  ").append(" \n");
            sql.append(" t_cl_writeOffrecord B  ").append(" \n");
            sql.append(" inner join ").append(idDetailTable).append(" C on B.FBILLENTRYID = C.fentryID ").append(" \n");
            sql.append(" where B.FWRITEOFFYEAR = ").append(spnYear);
            sql.append(" AND B.FWRITEOFFPERIOD = ").append(spnPeriod).append(" \n");
            sql.append(" group by B.FBILLENTRYID) T where A.Fentryid = T.FentryID) ");
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" insert into ").append(invBillTable).append(" \n");
            sql.append(" (FbillPeriod,FbillID,FbillTypeID,FbillTypeName,FbillNumber,");
            sql.append(" FtempAmount,FPurAmount )").append(" \n");
            sql.append(" select A.FbillPeriod,A.FbillID ,A.FbillTypeID,A.FbillTypeName,A.FbillNumber, ");
            if ("1001".equals(actItemNumber)) {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(Round((isnull(A.funwriteOffQty,0)+isnull(A.fwriteQtyAfter,0))*A.FStandUnitCost,A.FAmtPrecision)) ");
            } else {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(isnull(A.funwriteOffamt,0) + isnull(A.fwriteAmtAfter,0)+isnull(A.fMaterialAmt,0) ");
                sql.append(" - Round((A.funwriteOffQty+A.fwriteQtyAfter)*A.FStandUnitCost,A.FAmtPrecision)) ");
            }
            sql.append(" else sum(isnull(A.funwriteOffamt,0) + isnull(A.fwriteAmtAfter,0)+isnull(A.fMaterialAmt,0)) end , ");
            if ("1001".equals(actItemNumber)) {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(Round(isnull(A.FwriteQtycur,0) * A.FStandUnitCost,A.FAmtPrecision)) ");
            } else {
                sql.append(" case when A.FAccountType = 2 then ");
                sql.append(" sum(isnull(A.fwriteAmtCur,0) ");
                sql.append(" - Round(isnull(A.FwriteQtycur,0) * A.FStandUnitCost,A.FAmtPrecision)) ");
            }
            sql.append(" else sum(isnull(A.fwriteAmtCur,0)) end from ").append(" \n");
            sql.append(idDetailTable).append(" A ").append(" \n");
            sql.append(" group by A.FbillPeriod,A.FbillID ,A.FbillTypeID,A.FbillTypeName,A.FbillNumber,A.FAccountType");
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" insert into ").append(invBillTable).append(" \n");
            sql.append(" (FbillPeriod,FbillID,FbillTypeID,FbillTypeName,FbillNumber,");
            sql.append(" FtempAmount,FPurAmount )").append(" \n");
            sql.append(" select  Bill.Fyear*100+Bill.fperiod,Bill.fid,Bill.fbillTypeID,\n");
            sql.append(" billType.fname_").append(this.loc);
            sql.append(" ,bill.fnumber ,0,");
            if (actItemNumber.equals("1001")) {
                sql.append(" sum(Case matCom.FAccountType when 2 then 0 else entry.FAmount end)");
            } else {
                sql.append(" sum(Case matCom.FAccountType when 2 then entry.FAmount else 0 end)");
            }
            sql.append(" from T_CL_CostAdjustBill Bill ").append(" \n");
            sql.append(" inner join t_cl_costadjustbillentry entry on Bill.fid = entry.fparentid ").append(" \n");
            sql.append(" Inner Join T_SCM_BillType billType on bill.FBillTypeID = billType.FID ");
            sql.append(" Inner Join T_IM_StoreType sType on entry.FStoreTypeID = sType.FID ").append(" \n");
            sql.append(" Inner Join T_BD_MaterialCompanyInfo matCom ON entry.FMaterialID = matCom.FMaterialID AND entry.FCompanyOrgUnitID = matCom.FCompanyID ").append(" \n");
            if (isMulti && "1001".equals(actItemNumber)) {
                sql.append(" Inner Join T_BD_AccountView accView ON entry.FAccountViewInId = accView.FID  ").append(" \n");
            } else {
                sql.append(" Inner Join T_BD_KAClassificationDetail kaClass ON matCom.FKAClassID = kaClass.FKAClassFicLink ").append(" \n");
                sql.append(" Inner Join T_BD_KAccountItem kaItem ON kaClass.FAccountitemlinkID = kaItem.FID ").append(" \n");
                sql.append(" Inner Join T_BD_AccountView accView ON kaClass.FAccountLinkID = accView.FID  ").append(" \n");
            }
            sql.append(this.getCommonWhereSQL(params, isMulti && actItemNumber.equals("1001")));
            if ("1005".equals(actItemNumber)) {
                sql.append(" And matCom.FAccountType = 2 ").append(" \n");
            }
            sql.append(" And bill.FCalculateKind = 0");
            sql.append(" and bill.FCREATETYPE in (0,11)");
            sql.append(" and Bill.Fyear*100+Bill.fperiod =");
            sql.append(spnYear * 100 + spnPeriod).append(" \n");
            sql.append(" group by Bill.Fyear*100+Bill.fperiod,Bill.fid,Bill.fbillTypeID,bill.fnumber,billType.fname_").append(this.loc);
            KsqlUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            String string = invBillTable;
            return string;
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)idDetailTable);
        }
    }

    private String getIsCalculateWhereSQL(RptParams params) {
        Boolean ckShowNoCalculate = (Boolean)params.getObject("ckShowNoCalculate");
        StringBuffer sSQL = new StringBuffer();
        if (ckShowNoCalculate != null && !ckShowNoCalculate.booleanValue()) {
            sSQL.append(" And transType.FIsCalculate = 1 ");
        }
        return sSQL.toString();
    }

    private String getCommonWhereSQL(RptParams params, boolean isMulti) {
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("bizCompnayOrg");
        String actItemNumber = (String)params.getObject("ActItemNumber");
        String actNumber = (String)params.getObject("ActNumber");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(" Where entry.FCompanyOrgUnitID = '").append(companyOrgUnitInfo.getId().toString()).append("'");
        sSQL.append(" And bill.FBaseStatus = ").append(4);
        if (!isMulti) {
            sSQL.append(" And kaItem.FNumber = '").append(actItemNumber).append("'");
        }
        sSQL.append(" And accView.FNumber = '").append(actNumber).append("'");
        sSQL.append(" And sType.FIsForwardAmt = 1");
        return sSQL.toString();
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        String reportDataTable = params.getString("tempTable");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select FbillPeriod,FbillTypeID,FbillTypeName,FbillID,FbillNumber,FtempAmount,\n");
        sSQL.append("FTempVoucherID,FTempVoucherNumber,FTempVoucheramt,\n");
        sSQL.append("FTempDiff,FdischgVoucheramt,FPurAmount,FpurinVoucherId,\n");
        sSQL.append("FpurinVoucherNumber,FpurinVoucheramt,FpurinDiff \n");
        sSQL.append(" From ").append(reportDataTable);
        boolean isShowException = params.getBoolean("isShowException");
        if (isShowException) {
            sSQL.append(" Where FTempDiff <> 0 or FpurinDiff <> 0");
        }
        sSQL.append(" order by FTempVoucherID,FpurinVoucherId");
        RptRowSet rs = this.executeQuery(sSQL.toString(), null, ctx);
        RptParams rptParam = new RptParams();
        rptParam.setObject("rowset", (Object)rs);
        return rptParam;
    }
}

