/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.cal.LotAccountContrastCollection;
import com.kingdee.eas.scm.cal.LotAccountContrastFactory;
import com.kingdee.eas.scm.cal.LotAccountContrastInfo;
import com.kingdee.eas.scm.cal.app.AbstractLotAccountContrastControllerBean;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LotAccountContrastControllerBean
extends AbstractLotAccountContrastControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.LotAccountContrastControllerBean");

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LotAccountContrastInfo info = (LotAccountContrastInfo)model;
        String companyID = info.getCompanyOrgUnit().getId().toString();
        this.checkPermission(ctx, new IObjectPK[]{new ObjectUuidPK(companyID)}, "accountContrast_update");
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LotAccountContrastInfo info = (LotAccountContrastInfo)model;
        String companyID = info.getCompanyOrgUnit().getId().toString();
        this.checkPermission(ctx, new IObjectPK[]{new ObjectUuidPK(companyID)}, "accountContrast_new");
        return super._addnew(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LotAccountContrastInfo info = this.getLotAccountContrastInfo(ctx, pk);
        String companyID = info.getCompanyOrgUnit().getId().toString();
        this.checkPermission(ctx, new IObjectPK[]{new ObjectUuidPK(companyID)}, "accountContrast_delete");
        super._delete(ctx, pk);
    }

    @Override
    protected int _setStatus(Context ctx, ArrayList pks, UseStatusEnum status) throws BOSException, EASBizException {
        LotAccountContrastCollection coll;
        if (UseStatusEnum.ACTIVE.equals((Object)status)) {
            coll = this.getInfoCollByID(ctx, pks);
            IObjectPK[] companyIDs = this.getOrgPKs(coll);
            this.checkPermission(ctx, companyIDs, "accountConstrast_able");
            for (int i = 0; i < coll.size(); ++i) {
                LotAccountContrastInfo bill = coll.get(i);
                StringBuffer querySql = new StringBuffer();
                querySql.append("SELECT * FROM T_cl_lotaccountcontrast WHERE ").append("FCompanyOrgUnitID = '" + bill.getCompanyOrgUnit().getId() + "' AND ").append("FBillTypeID = '" + bill.getBillType().getId() + "' AND ").append("FTransactionTypeID = '" + bill.getTransactionType().getId() + "' AND ").append("FUpdateTypeID = '" + bill.getUpdateType().getId() + "' AND ").append("FBIZTYPEID = '" + bill.getBizType().getId() + "' AND ").append("FStatus = '1'");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
                try {
                    if (!rowSet.next()) continue;
                    pks.remove(bill.getId().toString());
                    continue;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        } else {
            coll = this.getInfoCollByID(ctx, pks);
            IObjectPK[] companyIDs = this.getOrgPKs(coll);
            this.checkPermission(ctx, companyIDs, "accountConstrast_unable");
        }
        if (pks.size() != 0) {
            String sql = "update T_cl_lotaccountcontrast set fstatus=" + status.getValue() + " where fid in(" + CollectionUtil.convertList2String((List)pks) + ")";
            DbUtil.execute((Context)ctx, (String)sql);
        }
        return pks.size();
    }

    private LotAccountContrastCollection getInfoCollByID(Context ctx, ArrayList pks) throws BOSException {
        HashSet entryIdSet = new HashSet(pks);
        EntityViewInfo view = this.getViewInfo(entryIdSet);
        LotAccountContrastCollection coll = LotAccountContrastFactory.getLocalInstance(ctx).getLotAccountContrastCollection(view);
        return coll;
    }

    private IObjectPK[] getOrgPKs(LotAccountContrastCollection coll) {
        HashSet<ObjectUuidPK> pks = new HashSet<ObjectUuidPK>();
        int size = coll.size();
        LotAccountContrastInfo info = null;
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            BOSUuid id = info.getCompanyOrgUnit().getId();
            pks.add(new ObjectUuidPK(id));
        }
        return pks.toArray(new IObjectPK[pks.size()]);
    }

    private void checkPermission(Context ctx, IObjectPK[] orgPKs, String permissionItem) throws BOSException, EASBizException {
        IPermission ipermission = PermissionFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < orgPKs.length; ++i) {
            ipermission.checkFunctionPermission(ctx.getCaller(), orgPKs[i], permissionItem);
        }
    }

    private EntityViewInfo getViewInfo(Set entryIdSet) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)entryIdSet, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        return view;
    }

    @Override
    protected Map _batchOperation(Context ctx, Set ids, BatchActionEnum action) throws BOSException, EASBizException {
        Map resultMap = new HashMap();
        if (BatchActionEnum.DELETE.equals((Object)action)) {
            resultMap = this.batchDelete(ctx, ids);
        } else if (BatchActionEnum.ENABLE.equals((Object)action)) {
            resultMap = this.batchEnable(ctx, ids);
        } else if (BatchActionEnum.DISABLE.equals((Object)action)) {
            resultMap = this.batchDisable(ctx, ids);
        }
        return resultMap;
    }

    private Map batchEnable(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int errorCount = 0;
        StringBuffer errorMsg = new StringBuffer();
        this.bacthCheckPermission(ctx, ids, "accountContrast_delete");
        ArrayList idList = new ArrayList();
        if (ids.size() > 0) {
            idList.addAll(ids);
            StringBuffer querySql = new StringBuffer();
            querySql.append("SELECT * FROM T_CL_LOTACCOUNTCONTRAST WHERE ").append("FID\u3000IN ( ").append(CollectionUtil.convertList2String(idList)).append(" ) ").append(" and FStatus = '1' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            try {
                String id = null;
                String number = null;
                while (rs.next()) {
                    id = rs.getString("FID");
                    number = rs.getString("FNumber");
                    ids.remove(id);
                    errorMsg.append(this.getResource(ctx, "Cannot_Enable_Detail_01", new Object[]{number})).append("\n");
                    ++errorCount;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        LotAccountContrastCollection coll = null;
        HashMap<String, String> sameDeleteMap = new HashMap<String, String>();
        if (ids.size() > 0) {
            LotAccountContrastInfo bill;
            idList.clear();
            idList.addAll(ids);
            coll = this.getInfoCollByID(ctx, idList);
            for (int i = 0; i < coll.size(); ++i) {
                bill = coll.get(i);
                for (int j = i + 1; j < coll.size(); ++j) {
                    LotAccountContrastInfo otherBill = coll.get(j);
                    if (!bill.equals(otherBill)) continue;
                    ids.remove(otherBill.getId().toString());
                    sameDeleteMap.put(otherBill.getId().toString(), otherBill.getNumber());
                }
            }
            for (Map.Entry entry : sameDeleteMap.entrySet()) {
                errorMsg.append(this.getResource(ctx, "Cannot_Enable_Detail_02", new Object[]{entry.getValue()})).append("\n");
                ++errorCount;
            }
            idList.clear();
            idList.addAll(ids);
            coll = this.getInfoCollByID(ctx, idList);
            for (int i = 0; i < coll.size(); ++i) {
                bill = coll.get(i);
                StringBuffer querySql = new StringBuffer();
                querySql.append("SELECT 1 FROM T_CL_LOTACCOUNTCONTRAST WHERE ").append("FCompanyOrgUnitID = '" + bill.getCompanyOrgUnit().getId() + "' AND ").append("FBillTypeID = '" + bill.getBillType().getId() + "' AND ").append("FTransactionTypeID = '" + bill.getTransactionType().getId() + "' AND ").append("FUpdateTypeID = '" + bill.getUpdateType().getId() + "' AND ").append("FBIZTYPEID = '" + bill.getBizType().getId() + "' AND ").append("FStatus = '1'");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
                try {
                    if (!rs.next()) continue;
                    ids.remove(bill.getId().toString());
                    errorMsg.append(this.getResource(ctx, "Cannot_Enable_Detail_02", new Object[]{bill.getNumber()})).append("\n");
                    ++errorCount;
                    continue;
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (ids.size() > 0) {
            idList.clear();
            idList.addAll(ids);
            StringBuffer delSql = new StringBuffer();
            delSql.append("UPDATE T_CL_LOTACCOUNTCONTRAST set fstatus = 1 WHERE ").append("FID\u3000IN ( ").append(CollectionUtil.convertList2String(idList)).append(" ) ");
            DbUtil.execute((Context)ctx, (String)delSql.toString());
        }
        resultMap.put("ERROR_COUNT", errorCount);
        resultMap.put("ERROR_MSG", errorMsg.toString());
        return resultMap;
    }

    private Map batchDisable(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int errorCount = 0;
        StringBuffer errorMsg = new StringBuffer();
        this.bacthCheckPermission(ctx, ids, "accountContrast_delete");
        ArrayList idList = new ArrayList();
        if (ids.size() > 0) {
            idList.addAll(ids);
            StringBuffer querySql = new StringBuffer();
            querySql.append("SELECT * FROM T_CL_LOTACCOUNTCONTRAST WHERE ").append("FID\u3000IN ( ").append(CollectionUtil.convertList2String(idList)).append(" ) ").append(" and FStatus <> '1' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            try {
                String id = null;
                String number = null;
                while (rs.next()) {
                    id = rs.getString("FID");
                    number = rs.getString("FNumber");
                    ids.remove(id);
                    errorMsg.append(this.getResource(ctx, "Cannot_Disable_Detail_01", new Object[]{number})).append("\n");
                    ++errorCount;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (ids.size() > 0) {
            idList.clear();
            idList.addAll(ids);
            StringBuffer delSql = new StringBuffer();
            delSql.append("UPDATE T_CL_LOTACCOUNTCONTRAST set fstatus = 2 WHERE ").append("FID\u3000IN ( ").append(CollectionUtil.convertList2String(idList)).append(" ) ");
            DbUtil.execute((Context)ctx, (String)delSql.toString());
        }
        resultMap.put("ERROR_COUNT", errorCount);
        resultMap.put("ERROR_MSG", errorMsg.toString());
        return resultMap;
    }

    private Map batchDelete(Context ctx, Set ids) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int errorCount = 0;
        StringBuffer errorMsg = new StringBuffer();
        this.bacthCheckPermission(ctx, ids, "accountContrast_delete");
        ArrayList idList = new ArrayList();
        idList.addAll(ids);
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT FID,FNumber FROM T_CL_LOTACCOUNTCONTRAST WHERE ").append(" FID\u3000IN ( ").append(CollectionUtil.convertList2String(idList)).append(" ) ").append(" and FStatus <> '0' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            String id = null;
            String number = null;
            while (rs.next()) {
                id = rs.getString("FID");
                number = rs.getString("FNumber");
                ids.remove(id);
                errorMsg.append(this.getResource(ctx, "Cannot_Del_Detail_01", new Object[]{number})).append("\n");
                ++errorCount;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (ids.size() > 0) {
            idList.clear();
            idList.addAll(ids);
            StringBuffer delSql = new StringBuffer();
            delSql.append("DELETE FROM T_CL_LOTACCOUNTCONTRAST WHERE ").append("FID\u3000IN ( ").append(CollectionUtil.convertList2String(idList)).append(" ) ");
            DbUtil.execute((Context)ctx, (String)delSql.toString());
        }
        resultMap.put("ERROR_COUNT", errorCount);
        resultMap.put("ERROR_MSG", errorMsg.toString());
        return resultMap;
    }

    private LotAccountContrastCollection bacthCheckPermission(Context ctx, Set ids, String permItem) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        LotAccountContrastCollection coll = LotAccountContrastFactory.getLocalInstance(ctx).getLotAccountContrastCollection(view);
        HashSet<String> companyIdSet = new HashSet<String>();
        String companyId = null;
        LotAccountContrastInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            companyId = info.getCompanyOrgUnit().getId().toString();
            companyIdSet.add(companyId);
        }
        IObjectPK[] companyIdPKs = new IObjectPK[companyIdSet.size()];
        Iterator iter = companyIdSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            companyIdPKs[i] = new ObjectUuidPK(iter.next().toString());
        }
        this.checkPermission(ctx, companyIdPKs, permItem);
        return coll;
    }

    private String getResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.cal.LotAccountContrastResource", (String)key, (Locale)ctx.getLocale());
    }

    private String getResource(Context ctx, String key, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.cal.LotAccountContrastResource", (String)key, (Locale)ctx.getLocale(), (Object[])params);
    }
}

