/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalInEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.app.AbstractMatChangeCalculateFacadeControllerBean;
import com.kingdee.eas.scm.cal.onekey.multipleJob.ThreadLocalHelper;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.util.app.CheckVoucherUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MatChangeCalculateFacadeControllerBean
extends AbstractMatChangeCalculateFacadeControllerBean {
    private static final long serialVersionUID = -1790679038653491335L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.MatChangeCalculateFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.scm.cal.CalCommonResource";
    private String companyOrgID = null;
    private int precision = 2;
    protected int currPeriod;
    protected final String INSERT_INWAREHSBILL_SQL = new StringBuffer().append("insert into {0} (FBillID, FEntryID, FSeq, FIssueEntryID, FSourceBillEntryID, FNumber, FYear, FPeriod, FMaterialID, FPricePrecision, FQty, FBaseQty, FIssueActualCost, FFivouchered, FAccountType, FOldInActualCost) ").append("select bill.FID as FBillID,entry.FID as FEntryID,entry.FSeq,issueEntry.FID as FIssueEntryID,entry.FSourceBillEntryID,bill.FNumber,bill.FYear,bill.FPeriod, ").append("entry.FMaterialID,material.FPricePrecision,entry.FQty,entry.FBaseQty,issueEntry.FActualCost as FIssueActualCost,bill.FFivouchered,matCompany.FAccountType,entry.FActualCost as FOldInActualCost ").append("from T_IM_OtherInWarehsBill bill ").append("inner join T_IM_OtherInWarehsBillEntry entry on entry.FParentId = bill.FID ").append("inner join T_BD_Material material on entry.FMaterialId = material.FID ").append("inner join T_IM_OtherIssueBillEntry issueEntry on issueEntry.FSourceBillEntryID = entry.FSourceBillEntryID ").append("inner join T_BD_MaterialCompanyInfo matCompany on matCompany.FMaterialID = entry.FMaterialID and matCompany.FCompanyID = entry.FCompanyOrgUnitID ").append("where bill.FBaseStatus = 4 and bill.FIsReversed = 0 and {1} ").append("order by issueEntry.FID,entry.FSeq asc").toString();
    protected final String IS_FIVOUCHERED = "select distinct inWarehs.FNumber from {0} inWarehs where inWarehs.FFivouchered = 1";
    protected final String IS_OLD_PERIOD = "select distinct inWarehs.FNumber from {0} inWarehs where (inWarehs.FYear * 100 + inWarehs.FPeriod) < {1}";
    protected final String IS_ACTUALCOST_EQUALS_ZERO = "select distinct inWarehs.FNumber from {0} inWarehs where inWarehs.FIssueActualCost = 0";
    protected final String IS_ALLENTRY_MOVEAVG = new StringBuffer().append("select distinct T1.FNumber ").append("from (select inWarehs.FNumber, count(inWarehs.FEntryID) as FMoveAvgNum ").append("from {0} inWarehs ").append("where inWarehs.FAccountType = ").append(1).append(" ").append("group by inWarehs.FNumber) T1 ").append("inner join (select inWarehs.FNumber, count(inWarehs.FEntryID) as FEntryNum ").append("from {1} inWarehs group by inWarehs.FNumber) T2 on T1.FNumber = T2.FNumber ").append("where T1.FMoveAvgNum = T2.FEntryNum ").toString();
    protected final String TEMP_SAVE_COST = new StringBuffer().append("insert into {0} (FIssueEntryID, FEntryID, FSeq, FIssueActualCost, FInActualCost, FInUnitActualCost, FBaseQty, FQty, FPricePrecision) ").append("select inWarehs.FIssueEntryID,inWarehs.FEntryID,inWarehs.FSeq,inWarehs.FIssueActualCost, ").append("round(TO_DECIMAL(inWarehs.FIssueActualCost * round(inWarehs.FBaseQty / tmp.FTotalBaseQty, 10), 17, 4), {1}) as FInActualCost, ").append("round(TO_DECIMAL(round(TO_DECIMAL(inWarehs.FIssueActualCost * round(inWarehs.FBaseQty / tmp.FTotalBaseQty, 10), 17, 4), {2}) / inWarehs.FQty, 21, 8), inWarehs.FPricePrecision) as FInUnitActualCost, ").append("inWarehs.FBaseQty,inWarehs.FQty,inWarehs.FPricePrecision ").append("from ").append("(select noMoveAvgEntries.FIssueEntryID,noMoveAvgEntries.FEntryID,noMoveAvgEntries.FSeq, ").append("noMoveAvgEntries.FIssueActualCost - isnull(moveAvgEntries.FMoveAvgCostSum, 0) as FIssueActualCost, ").append("noMoveAvgEntries.FQty,noMoveAvgEntries.FBaseQty,noMoveAvgEntries.FPricePrecision ").append("from (select * from {3} inWarehs where inWarehs.FAccountType <> ").append(1).append(") noMoveAvgEntries ").append("left join (select inWarehs.FIssueEntryID, sum(inWarehs.FOldInActualCost) as FMoveAvgCostSum ").append("from {4} inWarehs where inWarehs.FAccountType = ").append(1).append(" group by inWarehs.FIssueEntryID) moveAvgEntries ").append("on noMoveAvgEntries.FIssueEntryID = moveAvgEntries.FIssueEntryID ").append(") inWarehs ").append("inner join (select inWarehs.FIssueEntryID, TO_DECIMAL(sum(inWarehs.FBaseQty),21,8) as FTotalBaseQty ").append("from {5} inWarehs where inWarehs.FAccountType <> ").append(1).append(" ").append("group by inWarehs.FIssueEntryID) tmp on inWarehs.FIssueEntryID = tmp.FIssueEntryID ").append("order by inWarehs.FIssueEntryID, inWarehs.FSeq ").toString();
    protected final String DEAL_TAIL_BALANCE_ENTRY = new StringBuffer().append("insert {0} (FEntryID) ").append("select distinct tmp1.FEntryID from {1} tmp1 ").append("inner join (select tmp.FIssueEntryID,max(tmp.FSeq) as FMaxSeq from {2} tmp group by tmp.FIssueEntryID) tmp2 ").append("on tmp1.FIssueEntryID= tmp2.FIssueEntryID and tmp1.FSeq = tmp2.FMaxSeq").toString();
    protected final String INSERT_TO_UPDATE_TABLE = new StringBuffer().append("insert into {0} (FEntryID,FActualCost,FUnitActualCost) ").append("( select t1.FEntryID,(isnull(t1.FIssueActualCost,0)-isnull(t3.FTotalNoLastCost,0)) as FInActualCost, ").append("round(TO_DECIMAL((isnull(t1.FIssueActualCost,0)-isnull(t3.FTotalNoLastCost,0)) / t1.FQty, 21,8), t1.FPricePrecision) as FInUnitActualCost ").append(" from {1} t1  ").append("inner join {2} t2 on t1.FEntryID = t2.FEntryID ").append("left join (select t1.FIssueEntryID,sum(t1.FInActualCost) FTotalNoLastCost from {3} t1 ").append("where not exists (select 1 from {4} t2 where t2.FEntryID = t1.FEntryID) group by t1.FIssueEntryID) t3 on t1.FIssueEntryID=t3.FIssueEntryID ").append("union all ").append("select t1.FEntryID,t1.FInActualCost,t1.FInUnitActualCost from {5} t1  ").append("where not exists (select 1 from {6} t2 where t2.FEntryID = t1.FEntryID) )").toString();
    protected final String UPDATE_ACTUALCOST = new StringBuffer().append("update T_IM_OtherInwarehsBillEntry as entry set (FActualCost, FUnitActualCost) = ").append("(select FActualCost,FUnitActualCost from {0} updateTable where updateTable.FEntryID = entry.FID)").toString();
    protected final String UPDATE_BILL_TOTALACTUALCOST = new StringBuffer().append("update T_IM_OtherInWarehsBill as srcBill set (FTotalActualCost)= ").append("(select tmp.FNewActualCost from ").append("(select bill.FID,sum(entry.FActualCost) as FNewActualCost ").append("from T_IM_OtherInWarehsBill bill ").append("left join T_IM_OtherInWarehsBillEntry entry on entry.FParentID = bill.FID ").append("where {0} ").append("group by bill.FID) tmp ").append("where srcBill.FID = tmp.FID) ").toString();
    protected final String UPDATE_ENTRY_AMOUNT_PRICE = new StringBuffer().append("update T_IM_OtherInWarehsBillEntry as srcEntry set (FAmount,FPrice)= ").append("(select tmp.FAmount, tmp.FPrice from ").append("(select entry.FID,entry.FActualCost as FAmount,round(TO_DECIMAL(entry.FActualCost / entry.FQty, 21, 8), material.FPricePrecision) as FPrice ").append("from T_IM_OtherInWarehsBill bill ").append("inner join T_IM_OtherInWarehsBillEntry entry on entry.FParentID = bill.FID ").append("inner join T_BD_Material material on entry.FMaterialId = material.FID ").append("where {0}) tmp ").append("where tmp.FID=srcEntry.FID) ").toString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CalculateParams _costCalculate(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        this.initParams(ctx, params);
        String inWarehsTempTable = null;
        String updateInWarehsTempTable = null;
        String tempSaveCostTempTable = null;
        String inLastEntryIDTempTable = null;
        CalculateParams cps = new CalculateParams();
        try {
            ThreadLocalHelper.checkInterruptedForInCalc();
            if (CheckVoucherUtil.isCheckVoucherAndCal((Context)ctx)) {
                IRowSet rs1 = CheckVoucherUtil.checkGenVoucher((Context)ctx, (String)this.companyOrgID, (boolean)false);
                if (rs1.size() > 0) {
                    StringBuffer msg = new StringBuffer();
                    while (rs1.next()) {
                        msg.append("\n").append(rs1.getString("fbilltype")).append(rs1.getString("fnumber")).append(",").append(ResourceBase.getString((String)RESOURCE, (String)"operatorInfo", (Locale)ctx.getLocale())).append(rs1.getString("fuser"));
                    }
                    throw new CalculateException(CalculateException.IS_GEN_VOUCHER_EXCEPTION, new Object[]{msg});
                }
                EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"insertGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, List.class, String.class, String.class, String.class}, (Object[])new Object[]{ctx, this.companyOrgID, null, null, null, ctx.getUserName(), CalInEnum.MATCHANGECAL.getName()}, (int)3);
            }
            inWarehsTempTable = DBUtil.createTempTable(ctx, "INWAREHSBILL", this.getInWarehsTableFields());
            DBUtil.createTempTableIndex(ctx, inWarehsTempTable, "FEntryID", true);
            updateInWarehsTempTable = DBUtil.createTempTable(ctx, "INWAREHSBILL", this.getUpdateInWarehsFields());
            DBUtil.createTempTableIndex(ctx, updateInWarehsTempTable, "FEntryID", true);
            String filter = this.getFilterByParams(params);
            String sSQL = MessageFormat.format(this.INSERT_INWAREHSBILL_SQL, inWarehsTempTable, filter);
            DBUtil.execute((Context)ctx, (String)sSQL);
            ThreadLocalHelper.checkInterruptedForInCalc();
            this.checkCanCalculate(ctx, inWarehsTempTable, cps);
            logger.debug((Object)"\u5355\u636e\u6821\u9a8c\u901a\u8fc7\uff0c\u5f00\u59cb\u6838\u7b97\u5904\u7406\u3002\u3002\u3002");
            tempSaveCostTempTable = DBUtil.createTempTable(ctx, "INWAREHSBILL", this.getDealTailDiffFields());
            DBUtil.createTempTableIndex(ctx, tempSaveCostTempTable, "FEntryID", true);
            sSQL = MessageFormat.format(this.TEMP_SAVE_COST, tempSaveCostTempTable, String.valueOf(this.precision), String.valueOf(this.precision), inWarehsTempTable, inWarehsTempTable, inWarehsTempTable);
            DBUtil.execute((Context)ctx, (String)sSQL);
            inLastEntryIDTempTable = DBUtil.createTempTable(ctx, "INWAREHSBILL", this.getInLastEntryIDFields());
            sSQL = MessageFormat.format(this.DEAL_TAIL_BALANCE_ENTRY, inLastEntryIDTempTable, tempSaveCostTempTable, tempSaveCostTempTable);
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(this.INSERT_TO_UPDATE_TABLE, updateInWarehsTempTable, tempSaveCostTempTable, inLastEntryIDTempTable, tempSaveCostTempTable, inLastEntryIDTempTable, tempSaveCostTempTable, inLastEntryIDTempTable);
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(this.UPDATE_ACTUALCOST, updateInWarehsTempTable);
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(this.UPDATE_BILL_TOTALACTUALCOST, filter);
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(this.UPDATE_ENTRY_AMOUNT_PRICE, filter);
            DBUtil.execute((Context)ctx, (String)sSQL);
            logger.debug((Object)"\u7269\u6599\u8f6c\u6362\u5165\u5e93\u6838\u7b97\u5b8c\u6210");
        }
        catch (Exception e) {
            try {
                if (!params.getBoolean("ONE_KEY_CALC")) {
                    if (e instanceof EASBizException) {
                        throw (EASBizException)((Object)e);
                    }
                    throw new BOSException((Throwable)e);
                }
                cps.setObject("calcException", (Object)e);
            }
            catch (Throwable throwable) {
                DBUtil.releaseTempTable(ctx, inWarehsTempTable);
                DBUtil.releaseTempTable(ctx, updateInWarehsTempTable);
                DBUtil.releaseTempTable(ctx, tempSaveCostTempTable);
                DBUtil.releaseTempTable(ctx, inLastEntryIDTempTable);
                EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, this.companyOrgID, null, CalInEnum.MATCHANGECAL.getName()}, (int)3);
                throw throwable;
            }
            DBUtil.releaseTempTable(ctx, inWarehsTempTable);
            DBUtil.releaseTempTable(ctx, updateInWarehsTempTable);
            DBUtil.releaseTempTable(ctx, tempSaveCostTempTable);
            DBUtil.releaseTempTable(ctx, inLastEntryIDTempTable);
            EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, this.companyOrgID, null, CalInEnum.MATCHANGECAL.getName()}, (int)3);
        }
        DBUtil.releaseTempTable(ctx, inWarehsTempTable);
        DBUtil.releaseTempTable(ctx, updateInWarehsTempTable);
        DBUtil.releaseTempTable(ctx, tempSaveCostTempTable);
        DBUtil.releaseTempTable(ctx, inLastEntryIDTempTable);
        EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, this.companyOrgID, null, CalInEnum.MATCHANGECAL.getName()}, (int)3);
        return cps;
    }

    protected void initParams(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        this.companyOrgID = params.getString("COMPANY_ID");
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        try {
            companyOrgUnitInfo.setId(BOSUuid.read((String)this.companyOrgID));
        }
        catch (Exception e) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        this.precision = CalculateUtil.getLocalCurrencyPrecision2(ctx, companyOrgUnitInfo);
        PeriodInfo periodInfo = null;
        periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        if (periodInfo == null) {
            throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{CalculateUtil.takeFormateDesc(companyOrgUnitInfo.getName(), companyOrgUnitInfo.getNumber())});
        }
        this.currPeriod = periodInfo.getPeriodYear() * 100 + periodInfo.getPeriodNumber();
    }

    protected void checkCanCalculate(Context ctx, String tempTable, CalculateParams cps) throws BOSException, EASBizException {
        StringBuffer numSB = new StringBuffer("\n");
        StringBuffer sb = new StringBuffer();
        String notSuccessMsg = "";
        try {
            String sql = MessageFormat.format("select distinct inWarehs.FNumber from {0} inWarehs where inWarehs.FFivouchered = 1", tempTable);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                numSB.append(rs.getString("FNumber")).append("\n");
            }
            if (rs.size() > 0) {
                throw new CalculateException(CalculateException.BILL_EXISTS_VOUCHER, new String[]{numSB.toString()});
            }
            numSB.setLength(1);
            sql = MessageFormat.format("select distinct inWarehs.FNumber from {0} inWarehs where (inWarehs.FYear * 100 + inWarehs.FPeriod) < {1}", tempTable, String.valueOf(this.currPeriod));
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                numSB.append(rs.getString("FNumber")).append("\n");
            }
            if (rs.size() > 0) {
                throw new CalculateException(CalculateException.BILL_IS_OLDPERIOD, new String[]{numSB.toString()});
            }
            if (!cps.getBoolean("ONE_KEY_CALC")) {
                numSB.setLength(1);
                sql = MessageFormat.format("select distinct inWarehs.FNumber from {0} inWarehs where inWarehs.FIssueActualCost = 0", tempTable);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rs.next()) {
                    numSB.append("[" + rs.getString("FNumber") + "]\t").append(EASResource.getString((String)RESOURCE, (String)"EntryHasZeroCost") + "\n");
                }
                if (rs.size() > 0) {
                    notSuccessMsg = notSuccessMsg + numSB.toString();
                }
                if (!StringUtils.isEmpty((String)notSuccessMsg)) {
                    cps.setObject("hasZeroEntryOtherBill", (Object)notSuccessMsg);
                }
                numSB.setLength(1);
                sql = MessageFormat.format(this.IS_ALLENTRY_MOVEAVG, tempTable, tempTable);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rs.next()) {
                    numSB.append(rs.getString("FNumber")).append("\n");
                }
                if (rs.size() > 0) {
                    throw new CalculateException(CalculateException.BILL_ALLENTRY_IS_MOVEAVG, new String[]{numSB.toString()});
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getFilterByParams(CalculateParams params) {
        FilterInfo filter = new FilterInfo();
        List idList = (List)params.getObject("BILL_ID");
        List entryIdList = (List)params.getObject("ENTRY_ID");
        HashSet idSet = new HashSet();
        String billFilter = "bill.FID";
        if (entryIdList != null) {
            billFilter = "entry.fid";
            idSet.addAll(entryIdList);
        } else {
            idSet.addAll(idList);
        }
        filter.getFilterItems().add(new FilterItemInfo(billFilter, idSet, CompareType.INCLUDE));
        return filter.toString();
    }

    public String[][] getInWarehsTableFields() {
        String[][] fields = new String[][]{{"FBillID", "varchar(44)"}, {"FEntryID", "varchar(44)"}, {"FSeq", "int"}, {"FIssueEntryID", "varchar(44)"}, {"FSourceBillEntryID", "varchar(44)"}, {"FNumber", "varchar(44)"}, {"FYear", "int"}, {"FPeriod", "int"}, {"FMaterialID", "varchar(44)"}, {"FPricePrecision", "int"}, {"FQty", "decimal(21, 8)"}, {"FBaseQty", "decimal(21, 8)"}, {"FIssueActualCost", "decimal(21, 8)"}, {"FFivouchered", "int"}, {"FAccountType", "int"}, {"FOldInActualCost", "decimal(21, 8)"}};
        return fields;
    }

    public String[][] getUpdateInWarehsFields() {
        String[][] fields = new String[][]{{"FEntryID", "varchar(44)"}, {"FActualCost", "decimal(21, 8)"}, {"FUnitActualCost", "decimal(21,8)"}};
        return fields;
    }

    public String[][] getDealTailDiffFields() {
        String[][] fields = new String[][]{{"FIssueEntryID", "varchar(44)"}, {"FEntryID", "varchar(44)"}, {"FSeq", "int"}, {"FIssueActualCost", "decimal(21, 8)"}, {"FInActualCost", "decimal(21, 8)"}, {"FInUnitActualCost", "decimal(21, 8)"}, {"FBaseQty", "decimal(21, 8)"}, {"FQty", "decimal(21, 8)"}, {"FPricePrecision", "int"}};
        return fields;
    }

    public String[][] getInLastEntryIDFields() {
        String[][] fields = new String[][]{{"FEntryID", "varchar(44)"}};
        return fields;
    }
}

