/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.ExpenseApportionCreateTypeEnum;
import com.kingdee.eas.scm.cal.ExpenseApportionEntryInfo;
import com.kingdee.eas.scm.cal.ExpenseApportionException;
import com.kingdee.eas.scm.cal.ExpenseApportionFacadeFactory;
import com.kingdee.eas.scm.cal.ExpenseApportionFactory;
import com.kingdee.eas.scm.cal.ExpenseApportionInfo;
import com.kingdee.eas.scm.cal.IExpenseApportion;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.framework.writeoff.IWriteOffStrategy;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.IllegalConversionException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SaleExpenseApportionStrategy
implements IWriteOffStrategy {
    public static final String RES = "com.kingdee.eas.scm.cal.ManualWriteOffResource";

    public List buildWriteOffBillInfo(Context ctx, Map mainMap, Map secMap, MappingConditionEntryInfo conditionEntryInfo, WriteOffCommonParams params) throws BOSException, EASBizException {
        String supplierId;
        IObjectCollection entryColl;
        ExpenseApportionInfo billInfo;
        CoreBaseCollection billColl;
        PeriodInfo curPeriodInfo;
        block19: {
            Map.Entry me2;
            block18: {
                curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)params.getCompanyId())));
                params.put((Object)"currentPeriod", (Object)curPeriodInfo);
                HashMap paramMap = new HashMap();
                paramMap.put("SCM_CAL_011", params.getCompanyId());
                paramMap.put("SCM_CAL_008", params.getCompanyId());
                paramMap = ParamManager.getParamHashMap((Context)ctx, paramMap);
                params.put((Object)"isExpenseEstimate", (Object)"true".equalsIgnoreCase(paramMap.get("SCM_CAL_011").toString()));
                billColl = new CoreBaseCollection();
                billInfo = null;
                entryColl = null;
                supplierId = null;
                if (!"handDeal".equals(params.get((Object)"apportionStd"))) break block18;
                billInfo = new ExpenseApportionInfo();
                entryColl = (IObjectCollection)billInfo.get("entry");
                if (mainMap.get("") == null || secMap.get("") == null) break block19;
                me2 = null;
                for (Map.Entry me2 : mainMap.entrySet()) {
                    if (!secMap.containsKey(me2.getKey())) continue;
                    List secList = (List)secMap.get(me2.getKey());
                    this.checkData((List)me2.getValue(), secList, params);
                }
                Iterator it = ((List)mainMap.get("")).iterator();
                while (it.hasNext()) {
                    entryColl.addObject((IObjectValue)it.next());
                }
                supplierId = ((ExpenseApportionEntryInfo)((List)mainMap.get("")).get(0)).getString("supplierId");
                it = ((List)secMap.get("")).iterator();
                while (it.hasNext()) {
                    entryColl.addObject((IObjectValue)it.next());
                }
                if (entryColl.size() <= 0) break block19;
                billColl.add((CoreBaseInfo)billInfo);
                break block19;
            }
            me2 = null;
            Map newMainMap = this.getGroupMap(mainMap);
            for (Map.Entry me2 : newMainMap.entrySet()) {
                String secMapkey = this.getsecMapKey((String)me2.getKey(), true);
                String asstActID = this.getsecMapKey((String)me2.getKey(), false);
                if (!secMap.containsKey(secMapkey)) continue;
                List secList = (List)secMap.get(secMapkey);
                billInfo = this.buildExpenseApportionInfo(ctx, (List)me2.getValue(), secList, conditionEntryInfo, asstActID, params);
                if (billInfo == null) continue;
                billColl.add((CoreBaseInfo)billInfo);
            }
        }
        ArrayList<IObjectPK> result = new ArrayList<IObjectPK>();
        if (billColl.size() > 0) {
            ArrayList sqlList = new ArrayList();
            ExpenseApportionEntryInfo entryInfo = null;
            HashSet<String> saleIdSet = new HashSet<String>();
            HashSet<String> apIdSet = new HashSet<String>();
            int size = billColl.size();
            for (int i = 0; i < size; ++i) {
                entryColl = (IObjectCollection)billColl.get(i).get("entry");
                int k = entryColl.size();
                for (int j = 0; j < k; ++j) {
                    entryInfo = (ExpenseApportionEntryInfo)entryColl.getObject(j);
                    if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(entryInfo.getBillType().getId().toString())) {
                        saleIdSet.add(entryInfo.getSourceBillId());
                        if ("handDeal".equals(params.get((Object)"apportionStd"))) {
                            entryInfo.setString("asstActID", supplierId);
                        }
                        this.buildUpdateIMBillSql(ctx, entryInfo, sqlList);
                        continue;
                    }
                    if (!"510b6503-0105-1000-e000-010fc0a812fd463ED552".equals(entryInfo.getBillType().getId().toString())) continue;
                    apIdSet.add(entryInfo.getSourceBillId());
                    this.buildUpdateAPBillSql(ctx, entryInfo, params, sqlList);
                }
            }
            this.updateHead(ctx, saleIdSet, "T_IM_SaleIssueBill");
            this.updateHead(ctx, apIdSet, "T_AP_OtherBill");
            HashSet<String> imBillNumber = new HashSet<String>();
            HashSet<String> invoiceBillNumber = new HashSet<String>();
            ArrayList apIdList = new ArrayList();
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            int size2 = billColl.size();
            for (int i = 0; i < size2; ++i) {
                billInfo = (ExpenseApportionInfo)billColl.get(i);
                billInfo.setNumber(sf.format(new Date()) + i);
                Timestamp maxBizDate = CalculateUtil.getTime("1900-01-01 00:00:00.000");
                int maxPeriodNumber = 190001;
                int k = billInfo.getEntry().size();
                for (int j = 0; j < k; ++j) {
                    if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billInfo.getEntry().get(j).getBillType().getId().toString())) {
                        imBillNumber.add(billInfo.getEntry().get(j).getSourceNumber());
                    } else if ("510b6503-0105-1000-e000-010fc0a812fd463ED552".equals(billInfo.getEntry().get(j).getBillType().getId().toString())) {
                        invoiceBillNumber.add(billInfo.getEntry().get(j).getSourceNumber());
                    }
                    billInfo.getEntry().get(j).setId(null);
                    if (maxBizDate.compareTo(billInfo.getEntry().get(j).getBizDate()) >= 0) continue;
                    maxBizDate = CalculateUtil.getTime(billInfo.getEntry().get(j).getBizDate());
                    maxPeriodNumber = billInfo.getEntry().get(j).getInt("year") * 100 + billInfo.getEntry().get(j).getInt("period");
                }
                int periodNumber = curPeriodInfo.getNumber();
                if (maxBizDate.compareTo(curPeriodInfo.getBeginDate()) < 0) {
                    maxBizDate = CalculateUtil.getTime(curPeriodInfo.getBeginDate());
                } else if (maxBizDate.compareTo(curPeriodInfo.getEndDate()) > 0) {
                    periodNumber = maxPeriodNumber;
                }
                billInfo.setYear(periodNumber / 100);
                billInfo.setPeriod(periodNumber % 100);
                Timestamp now = new Timestamp(Calendar.getInstance().getTimeInMillis());
                billInfo.setApportionDate(now);
                billInfo.setCreateType(ExpenseApportionCreateTypeEnum.SALE_APPORTION);
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)params.getCompanyId()));
                billInfo.setCompanyOrgUnit(company);
                billInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                billInfo.setCreateTime(now);
                Object apBillId = null;
                apIdList.add(apBillId);
            }
            IExpenseApportion iBill = ExpenseApportionFactory.getLocalInstance(ctx);
            IObjectPK[] pks = iBill.submitBatchData(billColl);
            result.addAll(Arrays.asList(pks));
            DBUtil.execute(ctx, sqlList.toArray(new String[sqlList.size()]));
            int size3 = apIdList.size();
            for (int i = 0; i < size3; ++i) {
                this.reverseApportionDetail(ctx, billColl);
            }
            ExpenseApportionFacadeFactory.getLocalInstance(ctx).setApportionStandard(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), params.getCompanyId(), String.valueOf(params.get((Object)"apportionStd")));
            this.writeLog(ctx, imBillNumber, invoiceBillNumber);
        }
        return result;
    }

    protected void checkData(List mainList, List secList, WriteOffCommonParams params) throws EASBizException {
        ExpenseApportionEntryInfo entryInfo2 = null;
        BigDecimal totalApportionAmt = BigDecimal.ZERO;
        HashSet<String> billIdSet = new HashSet<String>();
        for (ExpenseApportionEntryInfo entryInfo2 : mainList) {
            totalApportionAmt = totalApportionAmt.add(entryInfo2.getCurrApportionAmt());
            billIdSet.add(entryInfo2.getSourceBillId());
        }
        if (billIdSet.size() > 1) {
            throw new ExpenseApportionException(ExpenseApportionException.NOTSUPPORTMULTISELECTED);
        }
        BigDecimal totalApportionStd = BigDecimal.ZERO;
        Iterator it = secList.iterator();
        while (it.hasNext()) {
            totalApportionStd = totalApportionStd.add(((ExpenseApportionEntryInfo)it.next()).getBigDecimal("currapportionamt"));
        }
        if (totalApportionStd.signum() == 0) {
            throw new ExpenseApportionException(ExpenseApportionException.ZEROTOTAL_APPORTIONSTANDARD, new String[]{String.valueOf(params.get((Object)"apportionStdAlias"))});
        }
        BigDecimal sumApportionAmt = BigDecimal.ZERO;
        BigDecimal currApportionAmt = null;
        int signum = 0;
        int size = secList.size();
        for (int i = 0; i < size; ++i) {
            entryInfo2 = (ExpenseApportionEntryInfo)secList.get(i);
            currApportionAmt = i == size - 1 ? totalApportionAmt.subtract(sumApportionAmt) : totalApportionAmt.multiply(entryInfo2.getBigDecimal("currapportionamt")).divide(totalApportionStd, entryInfo2.getInt("basePrecision"), 4);
            sumApportionAmt = sumApportionAmt.add(currApportionAmt);
            signum = currApportionAmt.add(entryInfo2.getBigDecimal("totalSaleFee")).signum();
            if (signum == 0 || signum == entryInfo2.getBigDecimal("qty").signum()) continue;
            throw new ExpenseApportionException(ExpenseApportionException.ACTUALCOST_SIGN_DIFF, new String[]{entryInfo2.getSourceNumber(), String.valueOf(entryInfo2.getSourceSeq())});
        }
    }

    protected void reverseApportionDetail(Context ctx, CoreBaseCollection billColl) throws BOSException, EASBizException {
        String apId = null;
        String fAsstactId = null;
        String expId = null;
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        if (billColl.size() > 0) {
            expId = billColl.get(0).getId().toString();
            IObjectCollection entryColl = (IObjectCollection)billColl.get(0).get("entry");
            int k = entryColl.size();
            for (int j = 0; j < k; ++j) {
                ExpenseApportionEntryInfo entryInfo = (ExpenseApportionEntryInfo)entryColl.getObject(j);
                if (!"510b6503-0105-1000-e000-010fc0a812fd463ED552".equals(entryInfo.getBillType().getId().toString())) continue;
                fAsstactId = entryInfo.getString("customerId");
                apId = entryInfo.getSourceBillId();
                break;
            }
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into T_AP_OtherBillExpApportion (FID,FParentID,FEntryId,FCostAdjustBillId,FCostCenterID,FIssueType,FCreateType,");
        sqlBuffer.append("FCalculateKind,FCustomerId,FMaterialID,FCompanyOrgUnitID,FWarehouseID,FUnitID,FLot,");
        sqlBuffer.append("FAmount,FSourceBillNumber,FSourceBillEntrySeq,FStorageOrgUnitID,FAdminOrgUnitID,");
        sqlBuffer.append("FAuditTime ,FBaseStatus,FSourceBillTypeID,FBillTypeID,FYear,FPeriod,");
        sqlBuffer.append("FNumber,FBizDate,FAuditorID,FSourceBillID,FCreatorID,FCreateTime,FControlUnitID,FSourceType)\n");
        sqlBuffer.append("select NEWBOSID('87E4684C'),'").append(apId).append("',saleEntry.fid,exp.fid as fcostAdjustId,saleBill.FCOSTCENTERORGUNITID, \n");
        sqlBuffer.append(0).append(",").append(4).append(",");
        sqlBuffer.append(1).append(",'").append(fAsstactId).append("',");
        sqlBuffer.append("saleEntry.FMATERIALID,saleEntry.FCOMPANYORGUNITID,saleEntry.FWAREHOUSEID,saleEntry.FBASEUNITID ,saleEntry.FLOT , \n");
        sqlBuffer.append("entry.FCURRAPPORTIONAMT as FAmount,saleBill.FNUMBER ,saleEntry.fseq,saleBill.FSTORAGEORGUNITID ,saleBill.FADMINORGUNITID , \n");
        sqlBuffer.append("exp.FCREATETIME as FAuditTime,saleBill.FBASESTATUS, \n");
        sqlBuffer.append("saleBill.FBILLTYPEID as FSourceBillTypeID,saleBill.FBILLTYPEID,exp.FYEAR ,exp.FPERIOD ,exp.FNUMBER ,exp.FCREATETIME as FBizDate, \n");
        sqlBuffer.append("exp.FCREATORID as FAuditorID,saleBill.fid as FSourceBillID,exp.FCREATORID ,exp.FCREATETIME,");
        sqlBuffer.append("'").append(cuId).append("',").append(13).append(" \n");
        sqlBuffer.append("from T_CL_ExpenseApportion exp \n");
        sqlBuffer.append("INNER JOIN T_CL_ExpenseApportionEntry entry ON EXP.FID = entry.FPARENTID \n");
        sqlBuffer.append("INNER JOIN T_IM_SaleIssueBill saleBill on saleBill.fid = entry.FSOURCEBILLID  \n");
        sqlBuffer.append("INNER JOIN T_IM_SaleIssueEntry saleEntry on saleEntry.fid = entry.FSOURCEENTRYID  \n");
        sqlBuffer.append("where exp.fid ='").append(expId).append("' ");
        DBUtil.execute((Context)ctx, (String)sqlBuffer.toString());
    }

    protected void buildUpdateAPBillSql(Context ctx, ExpenseApportionEntryInfo entryInfo, WriteOffCommonParams params, List sqlList) {
        StringBuffer sb = new StringBuffer("");
        sb.append("UPDATE T_AP_OTHERBILLENTRY SET FUNAPPORTIONAMOUNT = FUNAPPORTIONAMOUNT - ");
        sb.append(entryInfo.getCurrApportionAmt()).append(", FAPPORTIONAMOUNT = FAPPORTIONAMOUNT + ");
        sb.append(entryInfo.getCurrApportionAmt());
        sb.append(" WHERE FID = '").append(entryInfo.getSourceEntryId()).append("'");
        sqlList.add(sb.toString());
    }

    protected ExpenseApportionInfo buildExpenseApportionInfo(Context ctx, List mainList, List secList, MappingConditionEntryInfo conditionEntryInfo, String asstActID, WriteOffCommonParams params) throws EASBizException {
        ExpenseApportionInfo billInfo = new ExpenseApportionInfo();
        IObjectCollection entryColl = (IObjectCollection)billInfo.get("entry");
        ExpenseApportionEntryInfo entryInfo2 = null;
        ExpenseApportionEntryInfo entryInfoc = null;
        BigDecimal totalApportionAmt = BigDecimal.ZERO;
        HashSet<String> billIdSet = new HashSet<String>();
        for (ExpenseApportionEntryInfo entryInfo2 : mainList) {
            totalApportionAmt = totalApportionAmt.add(entryInfo2.getCurrApportionAmt());
            entryColl.addObject((IObjectValue)entryInfo2);
            billIdSet.add(entryInfo2.getSourceBillId());
        }
        BigDecimal totalApportionStd = BigDecimal.ZERO;
        Iterator it = secList.iterator();
        while (it.hasNext()) {
            totalApportionStd = totalApportionStd.add(((ExpenseApportionEntryInfo)it.next()).getBigDecimal("apportionStd"));
        }
        if (totalApportionStd.signum() == 0) {
            throw new ExpenseApportionException(ExpenseApportionException.ZEROTOTAL_APPORTIONSTANDARD, new String[]{String.valueOf(params.get((Object)"apportionStdAlias"))});
        }
        BigDecimal sumApportionAmt = BigDecimal.ZERO;
        BigDecimal currApportionAmt = null;
        int size = secList.size();
        for (int i = 0; i < size; ++i) {
            entryInfo2 = (ExpenseApportionEntryInfo)secList.get(i);
            currApportionAmt = i == size - 1 ? totalApportionAmt.subtract(sumApportionAmt) : totalApportionAmt.multiply(entryInfo2.getBigDecimal("apportionStd")).divide(totalApportionStd, entryInfo2.getInt("basePrecision"), 4);
            sumApportionAmt = sumApportionAmt.add(currApportionAmt);
            entryInfo2.setCurrApportionAmt(currApportionAmt);
            if (entryInfo2.getCurrApportionAmt().signum() == 0) continue;
            entryInfoc = (ExpenseApportionEntryInfo)entryInfo2.clone();
            entryInfoc.setString("asstActID", asstActID);
            entryColl.addObject((IObjectValue)entryInfoc);
        }
        if (entryColl.size() > 0) {
            return billInfo;
        }
        return null;
    }

    protected void buildUpdateIMBillSql(Context ctx, ExpenseApportionEntryInfo entryInfo, List sqlList) throws EASBizException, IllegalConversionException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_im_saleIssueEntry set FTOTALSALEFEE = isnull(FTOTALSALEFEE,0) + ");
        sql.append(entryInfo.getCurrApportionAmt());
        sql.append(" where fid = '").append(entryInfo.getSourceEntryId()).append("'");
        sqlList.add(sql.toString());
    }

    public IObjectValue buildWriteOffEntryInfo(Context ctx, IRowSet rs, WriteOffCommonInfo info, WriteOffCommonParams params) throws SQLException {
        ExpenseApportionEntryInfo entryInfo = new ExpenseApportionEntryInfo();
        entryInfo.setId(BOSUuid.create((String)"1F91CDEF"));
        entryInfo.setSourceBillId(rs.getString("id"));
        entryInfo.setSourceEntryId(rs.getString("entry.id"));
        entryInfo.setSourceNumber(rs.getString("number"));
        entryInfo.setSourceSeq(rs.getInt("entry.seq"));
        entryInfo.setObjectID(rs.getString("material.id"));
        String bosType = BOSUuid.read((String)rs.getString("id")).getType().toString();
        if (info != null) {
            entryInfo.setCurrApportionAmt(info.getLocalAmount());
        } else if ("48DA3A71".equals(bosType)) {
            entryInfo.setCurrApportionAmt(rs.getBigDecimal("entry.unApportionAmount"));
        }
        entryInfo.setBoolean("fiVouchered", rs.getBoolean("fiVouchered"));
        entryInfo.setInt("year", rs.getInt("year"));
        entryInfo.setInt("period", rs.getInt("period"));
        if ("48DA3A71".equals(bosType)) {
            entryInfo.setBizDate(rs.getDate("billDate"));
            if (entryInfo.getObjectID() == null) {
                entryInfo.setObjectID(rs.getString("expenseItem.id"));
            }
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-010fc0a812fd463ED552"));
            entryInfo.setBillType(billType);
            entryInfo.setString("customerId", rs.getString("asstActID"));
        } else if ("CC3E933B".equals(bosType)) {
            entryInfo.setBizDate(rs.getDate("bizDate"));
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015bc0a812fd463ED552"));
            entryInfo.setBillType(billType);
            if (!"handDeal".equals(params.get((Object)"apportionStd"))) {
                entryInfo.setBigDecimal("apportionStd", rs.getBigDecimal(String.valueOf(params.get((Object)"apportionStd"))));
            }
            entryInfo.setInt("basePrecision", rs.getInt("currency2.precision"));
            entryInfo.setString("warehouseId", rs.getString("warehouse.id"));
            entryInfo.setString("locationId", rs.getString("location.id"));
            entryInfo.setString("projectId", rs.getString("project.id"));
            entryInfo.setString("trackNumberId", rs.getString("trackNumber.id"));
            entryInfo.setString("lot", rs.getString("entry.lot"));
            entryInfo.setString("storageOrgUnitId", rs.getString("storageOrgUnit1.id"));
            entryInfo.setString("baseUnitId", rs.getString("baseUnit.id"));
            entryInfo.setString("assistPropertyId", rs.getString("assistProperty.id"));
            entryInfo.setString("supplierId", rs.getString("supplier.id"));
            entryInfo.setString("costCenterOrgUnitId", rs.getString("costCenterOrgUnit.id"));
            entryInfo.setString("adminOrgUnitId", rs.getString("adminOrgUnit.id"));
            entryInfo.setInt("accountType", rs.getInt("materialCompany.accountType"));
            entryInfo.setBigDecimal("qty", rs.getBigDecimal("entry.qty"));
        }
        return entryInfo;
    }

    public SelectorItemCollection getSelector(String bosType, WriteOffCommonParams params) {
        SelectorItemCollection sic = new SelectorItemCollection();
        String[] selectors = null;
        if ("48DA3A71".equals(bosType)) {
            selectors = new String[]{"billDate", "entry.seq", "material.id", "expenseItem.id", "entry.unApportionAmount", "year", "period", "fiVouchered", "asstActID"};
        } else if ("CC3E933B".equals(bosType)) {
            selectors = new String[]{"bizDate", "entry.seq", "material.id", "currency2.precision", "materialCompany.accountType", "storageOrgUnit1.id", "warehouse.id", "baseUnit.id", "assistProperty.id", "entry.lot", "project.id", "trackNumber.id", "location.id", "supplier.id", "materialCompany.accountType", "fiVouchered", "year", "period", "entry.qty", "costCenterOrgUnit.id", "adminOrgUnit.id", "entry.totalSaleFee"};
        }
        if (selectors != null) {
            int len = selectors.length;
            for (int i = 0; i < len; ++i) {
                sic.add(new SelectorItemInfo((String)selectors[i]));
            }
            if ("CC3E933B".equals(bosType) && !"handDeal".equals(params.get((Object)"apportionStd"))) {
                sic.add(new SelectorItemInfo(String.valueOf(params.get((Object)"apportionStd"))));
            }
        }
        return sic;
    }

    protected Map getGroupMap(Map mainMap) {
        LinkedHashMap<String, ArrayList<ExpenseApportionEntryInfo>> groupMap = new LinkedHashMap<String, ArrayList<ExpenseApportionEntryInfo>>();
        Map.Entry me2 = null;
        ExpenseApportionEntryInfo entryInfo2 = null;
        String supplier = null;
        ArrayList<ExpenseApportionEntryInfo> newMainList = null;
        for (Map.Entry me2 : mainMap.entrySet()) {
            String oriKey = (String)me2.getKey();
            List mainList = (List)me2.getValue();
            for (ExpenseApportionEntryInfo entryInfo2 : mainList) {
                supplier = entryInfo2.getString("supplierId");
                newMainList = (ArrayList<ExpenseApportionEntryInfo>)groupMap.get(oriKey + "_@_" + supplier);
                if (null == newMainList) {
                    newMainList = new ArrayList<ExpenseApportionEntryInfo>();
                }
                newMainList.add(entryInfo2);
                groupMap.put(oriKey + "_@_" + supplier, newMainList);
            }
        }
        return groupMap;
    }

    protected String getsecMapKey(String key, boolean iskey) {
        String[] secMapKey = key.split("_@_");
        if (iskey) {
            return secMapKey[0];
        }
        return secMapKey[1];
    }

    public void writeLog(Context ctx, Set imBillNumber, Set invoiceBillNumber) {
        Iterator it2;
        StringBuffer msg = new StringBuffer();
        String number = null;
        ArrayList<String> msgList = new ArrayList<String>();
        String[] title = new String[3];
        String msgToContinueTitle = EASResource.getString((String)RES, (String)"msgToContinue");
        int limitLength = 1024;
        title[0] = EASResource.getString((String)RES, (String)"saleExpenseApportion");
        title[1] = EASResource.getString((String)RES, (String)"saleIssueBill");
        title[2] = EASResource.getString((String)RES, (String)"otherApBill");
        Iterator it = imBillNumber.iterator();
        if (it.hasNext()) {
            msg.append(title[1]).append(":");
            while (it.hasNext()) {
                number = it.next().toString();
                if (msg.length() + number.length() > limitLength) {
                    msg.append(msgToContinueTitle);
                    msgList.add(msg.toString());
                    msg.setLength(0);
                    msg.append(title[1]).append(":");
                }
                msg.append(number).append(", ");
            }
        }
        if ((it2 = invoiceBillNumber.iterator()).hasNext()) {
            msg.append(title[2]).append(":");
            while (it2.hasNext()) {
                number = it2.next().toString();
                if (msg.length() + number.length() > limitLength) {
                    msg.append(msgToContinueTitle);
                    msgList.add(msg.toString());
                    msg.setLength(0);
                    msg.append(title[2]).append(":");
                }
                msg.append(number).append(", ");
            }
        }
        if (msg.length() > 0) {
            msgList.add(msg.toString());
        }
        IObjectPK pklog = null;
        for (int i = 0; i < msgList.size(); ++i) {
            pklog = LogUtil.beginLogWithDescription((Context)ctx, (String)"1", (BOSObjectType)new BOSObjectType("FDB07C43"), null, (String)((String)msgList.get(i)), (String)title[0]);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
        }
    }

    private void updateHead(Context ctx, Set<String> idSet, String tblName) throws BOSException {
        if (idSet.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("update ").append(tblName);
            sql.append(" set  FLastUpdateTime = getDate() where fid in (").append(CalculateUtil.getSqlInString(idSet)).append(")");
            DBUtil.execute((Context)ctx, (String)sql.toString());
        }
    }
}

