/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.IStandardCostAdjBill;
import com.kingdee.eas.scm.cal.StandardCostAdjBillEntryCollection;
import com.kingdee.eas.scm.cal.StandardCostAdjBillEntryInfo;
import com.kingdee.eas.scm.cal.StandardCostAdjBillException;
import com.kingdee.eas.scm.cal.StandardCostAdjBillFactory;
import com.kingdee.eas.scm.cal.StandardCostAdjBillInfo;
import com.kingdee.eas.scm.cal.app.AbstractStandardCostAdjBillControllerBean;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.BillTypeUtils;
import com.kingdee.eas.scm.im.inv.IInventoryBalance;
import com.kingdee.eas.scm.im.inv.InventoryBalanceFactory;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

public class StandardCostAdjBillControllerBean
extends AbstractStandardCostAdjBillControllerBean {
    private static final long serialVersionUID = 1L;
    private String[] standardcostadjUpdateFields = new String[]{"FBIZDATE"};

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkBizDate(ctx, model);
        IObjectPK pk = super._submit(ctx, model);
        StandardCostAdjBillInfo aStandardCostAdjBillInfo = (StandardCostAdjBillInfo)model;
        if (aStandardCostAdjBillInfo.getBillType() == null) {
            BillTypeInfo aBillTypeInfo = new BillTypeInfo();
            aBillTypeInfo.setId(BOSUuid.read((String)"3a3b5446-0106-1000-e000-01c3c0a812e6463ED552"));
            aStandardCostAdjBillInfo.setBillType(aBillTypeInfo);
        }
        this.checkCurrPeriodData(ctx, (StandardCostAdjBillInfo)model);
        String billTypeId = "3a3b5446-0106-1000-e000-01c3c0a812e6463ED552";
        String orgUnitID = aStandardCostAdjBillInfo.getCompanyOrgUnit().getId().toString();
        boolean isAutoAudit = false;
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String strAutoAudit = scmParam.getParamByBillTypeID("SCM_Submit_01", 1, orgUnitID, billTypeId);
        if (strAutoAudit != null && strAutoAudit.trim().length() != 0 && strAutoAudit.trim().equalsIgnoreCase("1")) {
            isAutoAudit = true;
        }
        if (isAutoAudit) {
            this._passAudit(ctx, pk, (IObjectValue)aStandardCostAdjBillInfo);
        }
        this.updateEntryFields(ctx, model);
        this.updateAccountView(ctx, model);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._save(ctx, model);
        this.updateEntryFields(ctx, model);
        return pk;
    }

    private void checkCurrPeriodData(Context ctx, StandardCostAdjBillInfo aStandardCostAdjBillInfo) throws EASBizException, BOSException {
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aStandardCostAdjBillInfo.getCompanyOrgUnit());
        PeriodInfo billPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)aStandardCostAdjBillInfo.getBizDate(), (CompanyOrgUnitInfo)aStandardCostAdjBillInfo.getCompanyOrgUnit());
        String BillID = aStandardCostAdjBillInfo.getId().toString();
        String companyId = aStandardCostAdjBillInfo.getCompanyOrgUnit().getId().toString();
        if (aStandardCostAdjBillInfo.getBizDate().compareTo(currPeriod.getEndDate()) <= 0) {
            return;
        }
        StringBuffer sSQL = new StringBuffer();
        StringBuffer happenWhere = new StringBuffer();
        happenWhere.append("Where d.FCompanyOrgUnitID = '").append(companyId).append("' \r\n");
        happenWhere.append("And h.FYear * 100 + h.FPeriod >= ").append(currPeriod.getNumber()).append(" And h.FYear * 100 + h.FPeriod < ").append(billPeriod.getNumber()).append(" \r\n");
        happenWhere.append("And h.FBaseStatus IN (1,2,4) \r\n");
        happenWhere.append("And ah.FID='").append(BillID).append("' \r\n");
        StringBuffer beginSQL = new StringBuffer();
        beginSQL.append("Select top 1 temp.* from (Select a.FMaterialId,to_char('InventoryBalance') as FNumber from T_IM_InventoryBalance a \r\n");
        beginSQL.append("INNER JOIN T_CL_StandardCostAdjEntry ae on ae.FMaterialID=a.FMaterialID \r\n");
        beginSQL.append("INNER JOIN T_CL_StandardCostAdjBill ah on ae.FParentID=ah.FID \r\n");
        beginSQL.append("Where a.FCompanyOrgUnitID = '").append(companyId).append("' \r\n");
        beginSQL.append("And a.FYear = ").append(currPeriod.getPeriodYear()).append(" And a.FPeriod = ").append(currPeriod.getPeriodNumber()).append(" \r\n");
        beginSQL.append("And ah.FID='").append(BillID).append("' \r\n");
        sSQL.append(beginSQL.toString());
        sSQL.append(" UNION ALL \r\n");
        sSQL.append(this.getSelectAllBillData(happenWhere.toString()) + ") as temp");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sSQL.toString());
        try {
            if (rs.next()) {
                throw new StandardCostAdjBillException(StandardCostAdjBillException.EXIST_BEFORE_BILL);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BigDecimal[] newPrices;
        String[] materials;
        if (pk == null && model == null) {
            return;
        }
        StandardCostAdjBillInfo info = this.getStandardCostAdjBillInfo(ctx, pk, SCMSelectorFactory.getStandardCostAdjSelector());
        BillBaseStatusEnum billStatus = info.getBaseStatus();
        if (billStatus.getValue() == 3) {
            throw new StandardCostAdjBillException(StandardCostAdjBillException.PRICEUNEQUAL);
        }
        this.isSamePerson4Audit(ctx, info);
        boolean isRight = true;
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = info.getCompanyOrgUnit();
        if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getId() != null) {
            aCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getId().toString()));
        }
        int currencyPresion = 2;
        if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getBaseCurrency() != null) {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getBaseCurrency().getId()), SCMSelectorFactory.getCurrencySelector());
            currencyPresion = currency.getPrecision();
        }
        StandardCostAdjBillEntryCollection entry = info.getEntry();
        int maxRow = entry.size();
        int pricePrecision = 0;
        for (int i = 0; i < maxRow; ++i) {
            StandardCostAdjBillEntryInfo entryInfo = (StandardCostAdjBillEntryInfo)entry.getObject(i);
            MaterialInfo aMaterialInfo = entryInfo.getMaterial();
            pricePrecision = aMaterialInfo.getPricePrecision();
            IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            MaterialCompanyInfoInfo aMaterialCompanyInfo = iMaterial.getCompanyInfo(aMaterialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString());
            BigDecimal standardPrice = aMaterialCompanyInfo.getStandardCost();
            standardPrice = standardPrice.setScale(pricePrecision, 4);
            if (null != entryInfo.getNewStandardPrice() && CalculateUtil.ZERO.compareTo(entryInfo.getNewStandardPrice()) == 0) {
                isRight = false;
                throw new StandardCostAdjBillException(StandardCostAdjBillException.MUSTINPUTNEWPRICE);
            }
            BigDecimal oldPrice = entryInfo.getOldStandardPrice();
            if ((oldPrice = oldPrice.setScale(pricePrecision, 4)).compareTo(standardPrice) == 0) continue;
            isRight = false;
            throw new StandardCostAdjBillException(StandardCostAdjBillException.PRICEUNEQUAL);
        }
        this.recalculateCost(ctx, info, currencyPresion);
        Connection conn = null;
        PreparedStatement stmt = null;
        Statement stmtUpdate = null;
        ResultSet rs = null;
        try {
            IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
            conn = EJBFactory.getConnection((Context)ctx);
            String sql = this.GetVoucheredSQL(info.getId().toString()).toString();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) {
                isRight = false;
                MaterialInfo mi = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(rs.getString("FMaterialID")), SCMSelectorFactory.getMaterialInfoSelector());
                throw new StandardCostAdjBillException(StandardCostAdjBillException.MATERIEL_HAS_CHECKED, new String[]{CalculateUtil.takeFormateDesc(mi.getName(), mi.getNumber()), CalculateUtil.takeFormateDesc(rs.getString("FNumber"))});
            }
            sql = this.GetWrittenSQL(info.getId().toString()).toString();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new StandardCostAdjBillException(StandardCostAdjBillException.WRITTENOFFBASEQTYNOTISZERO);
            }
            stmtUpdate = conn.createStatement();
            this.UpdateBillPrice(info.getId().toString(), stmtUpdate, currencyPresion);
            stmtUpdate.executeBatch();
        }
        catch (SQLException ex) {
            try {
                isRight = false;
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                SQLUtils.cleanup(stmtUpdate);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)stmtUpdate);
        if (isRight) {
            this.updateBillStatus(ctx, info);
            StandardCostAdjBillEntryCollection billEntry = info.getEntry();
            int recs = billEntry.size();
            materials = new String[recs];
            BigDecimal[] priceDiffs = new BigDecimal[recs];
            newPrices = new BigDecimal[recs];
            for (int i = 0; i < billEntry.size(); ++i) {
                StandardCostAdjBillEntryInfo entryInfo = billEntry.get(i);
                materials[i] = entryInfo.getMaterial().getId().toString();
                priceDiffs[i] = entryInfo.getDiffPrice();
                newPrices[i] = entryInfo.getNewStandardPrice();
            }
        } else {
            throw new StandardCostAdjBillException(StandardCostAdjBillException.PRICEUNEQUAL);
        }
        this.updateInvBalanceCostAdjDiff(ctx, info, currencyPresion, true);
        IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
        im.adjustStandardCost(info.getCompanyOrgUnit().getId().toString(), materials, newPrices);
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        super.audit(ctx, pk);
        StandardCostAdjBillInfo info = this.getStandardCostAdjBillInfo(ctx, pk, SCMSelectorFactory.getStandardCostAdjSelector());
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = info.getCompanyOrgUnit();
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        if (info.getYear() * 100 + info.getPeriod() < currPeriod.getPeriodYear() * 100 + currPeriod.getPeriodNumber()) {
            throw new StandardCostAdjBillException(StandardCostAdjBillException.OUTOFDATE);
        }
        if (info.getBaseStatus().getValue() != 4) {
            throw new StandardCostAdjBillException(StandardCostAdjBillException.NOAUDIT);
        }
        if (info.isFiVouchered()) {
            throw new StandardCostAdjBillException(StandardCostAdjBillException.ISVOUCHERED);
        }
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String strCanUnAudit = scmParam.getParamByBillTypeID("SCM_UnAudit_01", 1, aCompanyOrgUnitInfo.getId().toString(), "3a3b5446-0106-1000-e000-01c3c0a812e6463ED552");
        if (strCanUnAudit == null || strCanUnAudit.trim().equals("0")) {
            throw new SCMBillException(SCMBillException.CHECK_UNAUDIT_PARAM);
        }
        int currencyPresion = 2;
        if (aCompanyOrgUnitInfo != null && aCompanyOrgUnitInfo.getBaseCurrency() != null) {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(aCompanyOrgUnitInfo.getBaseCurrency().getId()), SCMSelectorFactory.getCurrencySelector());
            currencyPresion = currency.getPrecision();
        }
        this.isPriceEqual(ctx, info, true);
        this.isExistNewBill(ctx, info);
        this.updateBillStandardCost(ctx, info, currencyPresion, true);
        this.updateBillAndMatCost(ctx, info, true);
        this.updateInvBalanceCostAdjDiff(ctx, info, currencyPresion, false);
    }

    private void isPriceEqual(Context ctx, StandardCostAdjBillInfo info, boolean isUnAudit) throws EASBizException, BOSException {
        StandardCostAdjBillEntryCollection entry = info.getEntry();
        int maxRow = entry.size();
        int pricePrecision = 0;
        for (int i = 0; i < maxRow; ++i) {
            StandardCostAdjBillEntryInfo entryInfo = (StandardCostAdjBillEntryInfo)entry.getObject(i);
            MaterialInfo aMaterialInfo = entryInfo.getMaterial();
            pricePrecision = aMaterialInfo.getPricePrecision();
            IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = info.getCompanyOrgUnit();
            MaterialCompanyInfoInfo aMaterialCompanyInfo = iMaterial.getCompanyInfo(aMaterialInfo.getId().toString(), aCompanyOrgUnitInfo.getId().toString());
            BigDecimal standardPrice = aMaterialCompanyInfo.getStandardCost();
            standardPrice = standardPrice.setScale(pricePrecision, 4);
            if (null != entryInfo.getNewStandardPrice() && CalculateUtil.ZERO.compareTo(entryInfo.getNewStandardPrice()) == 0) {
                throw new StandardCostAdjBillException(StandardCostAdjBillException.MUSTINPUTNEWPRICE);
            }
            BigDecimal price = null;
            price = isUnAudit ? entryInfo.getNewStandardPrice().setScale(pricePrecision, 4) : entryInfo.getOldStandardPrice().setScale(pricePrecision, 4);
            if (price.compareTo(standardPrice) == 0) continue;
            if (isUnAudit) {
                throw new StandardCostAdjBillException(StandardCostAdjBillException.NEWPRICEUNEQUAL);
            }
            throw new StandardCostAdjBillException(StandardCostAdjBillException.PRICEUNEQUAL);
        }
    }

    private void isExistNewBill(Context ctx, StandardCostAdjBillInfo info) throws EASBizException, BOSException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("select bill.FID from T_CL_StandardCostAdjBill bill inner join T_CL_StandardCostAdjEntry entry");
        sSQL.append(" on bill.FID=entry.FParentID inner join");
        sSQL.append(" (select bill.FCompanyOrgUnitID,entry.FMaterialID,bill.FAuditTime from T_CL_StandardCostAdjBill bill");
        sSQL.append(" inner join T_CL_StandardCostAdjEntry entry on bill.FID=entry.FParentID where bill.FID=?) AS A");
        sSQL.append(" on bill.FCompanyOrgUnitID = A.FCompanyOrgUnitID and entry.FMaterialID=A.FMaterialID");
        sSQL.append(" and bill.FAuditTime > A.FAuditTime");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sSQL.toString());
            stmt.setString(1, info.getId().toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new StandardCostAdjBillException(StandardCostAdjBillException.EXISTNEWCOSTADJBILL);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }

    private void updateBillStandardCost(Context ctx, StandardCostAdjBillInfo info, int currencyPresion, boolean isUnAudit) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement stmt = null;
        Statement stmtUpdate = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String sql = this.GetVoucheredSQL(info.getId().toString()).toString();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) {
                IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                MaterialInfo mi = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(rs.getString("FMaterialID")), SCMSelectorFactory.getMaterialInfoSelector());
                throw new StandardCostAdjBillException(StandardCostAdjBillException.MATERIEL_HAS_CHECKED, new String[]{CalculateUtil.takeFormateDesc(mi.getName(), mi.getNumber()), CalculateUtil.takeFormateDesc(rs.getString("FNumber"))});
            }
            sql = this.GetWrittenSQL(info.getId().toString()).toString();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            if (rs.next()) {
                throw new StandardCostAdjBillException(StandardCostAdjBillException.WRITTENOFFBASEQTYNOTISZERO);
            }
            stmtUpdate = conn.createStatement();
            this.UpdateBillPrice(info.getId().toString(), stmtUpdate, currencyPresion, isUnAudit);
            stmtUpdate.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                SQLUtils.cleanup(stmtUpdate);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        SQLUtils.cleanup((Statement)stmtUpdate);
    }

    private void UpdateBillPrice(String BillID, Statement stmtUpdate, int currencyPresion, boolean isUnAudit) throws SQLException {
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL("T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry", BillID, currencyPresion, isUnAudit));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL("T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry", BillID, currencyPresion, isUnAudit));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL("T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry", BillID, currencyPresion, isUnAudit));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL("T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry", BillID, currencyPresion, isUnAudit));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL_2("T_IM_SaleIssueBill", "T_IM_SaleIssueEntry", BillID, currencyPresion, isUnAudit));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL_1("T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry", BillID, currencyPresion, isUnAudit));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL_1("T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry", BillID, currencyPresion, isUnAudit));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL_1("T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry", BillID, currencyPresion, isUnAudit));
        stmtUpdate.addBatch(this.UpdateBillsWriteoffSQL("T_IM_SaleIssueBill", "T_IM_SaleIssueEntry", BillID));
    }

    private String UpdateBillsPriceSQL(String billHead, String billEntry, String billID, int currencyPresion, boolean isUnAudit) {
        String standardPrice = "ae.FNewStandardPrice";
        if (isUnAudit) {
            standardPrice = "ae.FOldStandardPrice";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + billEntry + " as T  ");
        sql.append("SET (FStandardCost, FUnitStandardCost) = ( ");
        sql.append("\n SELECT ROUND(").append(standardPrice).append(" * d.FbaseQty,").append(currencyPresion).append("), ");
        sql.append(" CASE WHEN d.FQty = 0 THEN");
        sql.append(" 0 ");
        sql.append(" ELSE ");
        sql.append("ROUND((").append(standardPrice).append(" * d.FbaseQty) / d.FQty").append(",MATERIAL.FPRICEPRECISION)");
        sql.append(" END ");
        sql.append("FROM " + billEntry + " as D  ");
        sql.append("INNER JOIN " + billHead + " as H ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry as AE ON ae.FMaterialID = d.FMaterialID  ");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill as AH ON ae.FParentID = ah.FID  ");
        sql.append("INNER JOIN T_BD_MATERIAL as MATERIAL ON MATERIAL.FID = D.FMATERIALID ");
        sql.append("INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE ON H.FTransactionTypeID = SCMTRANSACTIONTYPE.FID ");
        sql.append("WHERE d.FCompanyOrgUnitID = ah.FCompanyOrgUnitID ");
        sql.append("AND ((h.FYear = ah.FYear AND h.FPeriod >= ah.FPeriod) OR h.FYear > ah.FYear) ");
        if (!"T_IM_ManufactureRecBill".equalsIgnoreCase(billHead)) {
            sql.append("AND (d.FISPRESENT = 0 or (d.FISPRESENT = 1 and SCMTRANSACTIONTYPE.FIsUpdatePresent = 0)) ");
        }
        sql.append("AND h.FBaseStatus IN (1,2,4) ");
        sql.append("AND ah.FID = '" + billID + "' ");
        sql.append("And T.FID=D.FID)");
        return sql.toString();
    }

    private String UpdateBillsPriceSQL_2(String billHead, String billEntry, String billID, int currencyPresion, boolean isUnAudit) {
        String standardPrice = "ae.FNewStandardPrice";
        if (isUnAudit) {
            standardPrice = "ae.FOldStandardPrice";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + billEntry + " as T  ");
        sql.append("SET (FStandardCost, FUnitStandardCost,FActualCost,FUnitActualCost,FUnWriteOffAmount) = ( ");
        sql.append("\n SELECT ROUND((").append(standardPrice).append(" * d.FbaseQty),").append(currencyPresion + "),");
        sql.append(" Case when d.FQty = 0 then");
        sql.append(" 0 ");
        sql.append(" else ");
        sql.append("ROUND((").append(standardPrice).append(" * d.FbaseQty) / d.FQty").append(",MATERIAL.FPRICEPRECISION)");
        sql.append(" END, ");
        sql.append(" ROUND((").append(standardPrice).append(" * d.FbaseQty),").append(currencyPresion + "),");
        sql.append(" Case when d.FQty = 0 then");
        sql.append(" 0 ");
        sql.append(" else ");
        sql.append("ROUND((").append(standardPrice).append(" * d.FbaseQty) / d.FQty").append(",MATERIAL.FPRICEPRECISION)");
        sql.append(" END, ");
        sql.append(" Case when d.FIsPresent=1 then");
        sql.append(" 0 ");
        sql.append(" else ");
        sql.append(" ROUND((").append(standardPrice).append(" * d.FbaseQty),").append(currencyPresion + ")");
        sql.append(" END ");
        sql.append("\n FROM " + billEntry + " as D  ");
        sql.append("\n INNER JOIN " + billHead + " as H ON h.FID = d.FParentID  ");
        sql.append("\n INNER JOIN T_CL_StandardCostAdjEntry as AE ON ae.FMaterialID = d.FMaterialID  ");
        sql.append("\n INNER JOIN T_CL_StandardCostAdjBill as AH ON ae.FParentID = ah.FID  ");
        sql.append("\n INNER JOIN T_BD_MATERIAL as MATERIAL ON MATERIAL.FID = D.FMATERIALID ");
        sql.append("\n INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE ON H.FTransactionTypeID = SCMTRANSACTIONTYPE.FID ");
        sql.append("\n WHERE d.FCompanyOrgUnitID = ah.FCompanyOrgUnitID  ");
        sql.append("\n AND ((h.FYear = ah.FYear AND h.FPeriod >= ah.FPeriod) OR h.FYear > ah.FYear)  ");
        sql.append("\n AND (d.FISPRESENT = 0 or (d.FISPRESENT = 1 and SCMTRANSACTIONTYPE.FIsUpdatePresent = 0)) ");
        sql.append("\n AND h.FBaseStatus IN (1,2,4) ");
        sql.append("\n AND ah.FID = '" + billID + "'  ");
        sql.append("\n And T.FID=D.FID  ");
        sql.append(")  ");
        return sql.toString();
    }

    private String UpdateBillsPriceSQL_1(String billHead, String billEntry, String billID, int currencyPresion, boolean isUnAudit) {
        String standardPrice = "ae.FNewStandardPrice";
        if (isUnAudit) {
            standardPrice = "ae.FOldStandardPrice";
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + billEntry + " as T  ");
        sql.append("SET (FStandardCost, FUnitStandardCost,FActualCost,FUnitActualCost) = ( ");
        sql.append("SELECT ROUND((").append(standardPrice).append(" * d.FbaseQty),").append(currencyPresion + "),");
        sql.append(" Case when d.FQty = 0 then");
        sql.append(" 0 ");
        sql.append(" else ");
        sql.append(" ROUND((").append(standardPrice).append(" * d.FbaseQty) / d.FQty").append(",MATERIAL.FPRICEPRECISION)");
        sql.append(" END, ");
        sql.append(" ROUND((").append(standardPrice).append(" * d.FbaseQty),").append(currencyPresion + "),");
        sql.append(" Case when d.FQty = 0 then");
        sql.append(" 0 ");
        sql.append(" else ");
        sql.append(" ROUND((").append(standardPrice).append(" * d.FbaseQty) / d.FQty ").append(",MATERIAL.FPRICEPRECISION)");
        sql.append(" END ");
        sql.append("FROM " + billEntry + " as D  ");
        sql.append("INNER JOIN " + billHead + " as H ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry as AE ON ae.FMaterialID = d.FMaterialID  ");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill as AH ON ae.FParentID = ah.FID  ");
        sql.append("INNER JOIN T_BD_MATERIAL as MATERIAL ON MATERIAL.FID = D.FMATERIALID ");
        sql.append("INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE ON H.FTransactionTypeID = SCMTRANSACTIONTYPE.FID ");
        sql.append("WHERE d.FCompanyOrgUnitID = ah.FCompanyOrgUnitID  ");
        sql.append("AND ((h.FYear = ah.FYear AND h.FPeriod >= ah.FPeriod) OR h.FYear > ah.FYear)  ");
        sql.append("AND (d.FISPRESENT = 0 or (d.FISPRESENT = 1 and SCMTRANSACTIONTYPE.FIsUpdatePresent = 0)) ");
        sql.append("AND h.FBaseStatus IN (1,2,4) ");
        sql.append("AND ah.FID = '" + billID + "'  ");
        sql.append("And T.FID=D.FID  ");
        sql.append(")  ");
        return sql.toString();
    }

    private void updateBillAndMatCost(Context ctx, StandardCostAdjBillInfo info, boolean isUnAudit) throws EASBizException, BOSException {
        this.updateBillStatus(ctx, info, isUnAudit);
        StandardCostAdjBillEntryCollection billEntry = info.getEntry();
        int recs = billEntry.size();
        String[] materials = new String[recs];
        BigDecimal[] priceDiffs = new BigDecimal[recs];
        BigDecimal[] newPrices = new BigDecimal[recs];
        for (int i = 0; i < billEntry.size(); ++i) {
            StandardCostAdjBillEntryInfo entryInfo = billEntry.get(i);
            materials[i] = entryInfo.getMaterial().getId().toString();
            priceDiffs[i] = entryInfo.getDiffPrice();
            newPrices[i] = isUnAudit ? entryInfo.getOldStandardPrice() : entryInfo.getNewStandardPrice();
        }
        IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
        im.adjustStandardCost(info.getCompanyOrgUnit().getId().toString(), materials, newPrices);
    }

    private void updateBillStatus(Context ctx, StandardCostAdjBillInfo info, boolean isUnAudit) throws BOSException {
        Connection conn = null;
        PreparedStatement pm = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String updateSql = "update T_CL_StandardCostAdjBill set FBaseStatus=?, FAuditorID=?, FAuditTime=? where FID=?";
            pm = conn.prepareStatement(updateSql);
            if (isUnAudit) {
                pm.setInt(1, 1);
                pm.setString(2, null);
                pm.setTimestamp(3, null);
                pm.setString(4, info.getId().toString());
            } else {
                pm.setInt(1, 4);
                pm.setString(2, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                pm.setTimestamp(3, new Timestamp(new Date().getTime()));
                pm.setString(4, info.getId().toString());
            }
            pm.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, pm);
                throw throwable;
            }
        }
        DBUtil.close(conn, pm);
    }

    private void recalculateCost(Context ctx, StandardCostAdjBillInfo info, int currencyPresion) throws EASBizException, BOSException {
        boolean isNeedUpdate = false;
        CompanyOrgUnitInfo company = info.getCompanyOrgUnit();
        PeriodInfo billPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)info.getBizDate(), (CompanyOrgUnitInfo)company);
        IInventoryBalance invBalance = InventoryBalanceFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < info.getEntry().size(); ++i) {
            StandardCostAdjBillEntryInfo entry = info.getEntry().get(i);
            MaterialInfo aMaterialInfo = entry.getMaterial();
            BigDecimal qty = invBalance.getPeriodBeginQty(aMaterialInfo.getId().toString(), company.getId().toString(), null, null, billPeriodInfo);
            if (qty.compareTo(entry.getBaseQty()) == 0) continue;
            isNeedUpdate = true;
            entry.setBaseQty(qty);
            BigDecimal oldAmount = new BigDecimal(String.valueOf("0"));
            BigDecimal newAmount = new BigDecimal(String.valueOf("0"));
            if (entry.getOldStandardPrice() == null || entry.getNewStandardPrice() == null) continue;
            oldAmount = qty.multiply(entry.getOldStandardPrice()).setScale(currencyPresion, 4);
            entry.setOldStandardAmount(oldAmount);
            newAmount = qty.multiply(entry.getNewStandardPrice()).setScale(currencyPresion, 4);
            entry.setNewStandardAmount(newAmount);
            BigDecimal diffPrice = entry.getNewStandardPrice().subtract(entry.getOldStandardPrice());
            BigDecimal diffAmount = qty.multiply(diffPrice).setScale(currencyPresion, 4);
            entry.setDiffAmount(diffAmount);
        }
        if (isNeedUpdate) {
            this.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInvBalanceCostAdjDiff(Context ctx, StandardCostAdjBillInfo info, int currencyPresion, boolean isAudit) throws BOSException, EASBizException {
        String costAdjTempTable = DBUtil.createTempTable(ctx, "COSTADJUSTDIFF", this.getCostDiffTableField());
        String maxIdTempTable = DBUtil.createTempTable(ctx, "MAXFID", this.getMaxIdTableField());
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = info.getCompanyOrgUnit();
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        try {
            StringBuffer sSQL = new StringBuffer();
            sSQL.append("Insert Into ").append(costAdjTempTable).append("(FId,FCompanyOrgUnitId,FMaterialId,FPriceDiff,FPeriodBeginQty,FDiffAmount,FPeriodAdjustDiff,FStoreTypeID)").append("\r\n");
            sSQL.append("SELECT A.FID,A.FCompanyOrgUnitId,T1.FMaterialId,T1.FDiffPrice,A.FPeriodBeginQty,").append("\r\n");
            sSQL.append("T1.FDiffAmount,ROUND(TO_Decimal(T1.FDiffPrice*A.FPeriodBeginQty, 17, 4), ").append(currencyPresion).append(") as FPeriodAdjustDiff, A.FStoreTypeID ").append("\r\n");
            sSQL.append("From T_IM_InventoryBalance A Inner Join (").append("\r\n");
            sSQL.append("  SELECT A.FCompanyOrgUnitID,B.FMaterialID,B.FDiffPrice,B.FDiffAmount").append("\r\n");
            sSQL.append("  FROM  T_CL_StandardCostAdjBill A INNER JOIN T_CL_StandardCostAdjEntry B ON A.FID = B.FParentID").append("\r\n");
            sSQL.append("  WHERE A.FID = '").append(info.getId().toString()).append("'").append("\r\n");
            sSQL.append(") AS T1 ON (A.FCompanyOrgUnitID = T1.FCompanyOrgUnitID AND A.FMATERIALID = T1.FMATERIALID)").append("\r\n");
            sSQL.append("Inner Join T_IM_StoreType C ON A.FStoreTypeID = C.FID ").append("\r\n");
            sSQL.append("WHERE A.FPeriod = ").append(currPeriod.getPeriodNumber()).append(" AND A.FYear = ").append(currPeriod.getPeriodYear()).append("\r\n");
            sSQL.append("  AND A.FCompanyOrgUnitID='").append(info.getCompanyOrgUnit().getId().toString()).append("'").append("\r\n");
            sSQL.append("  AND A.FISCALCULATE = 1 AND C.FIsForwardAmt = 1");
            DBUtil.execute((Context)ctx, (String)sSQL.toString());
            sSQL.setLength(0);
            sSQL.append("Insert into ").append(maxIdTempTable).append("(FID,FCompanyOrgUnitId,FMaterialId)").append("\r\n");
            sSQL.append("Select Max(TMP.FID),TMP.FCompanyOrgUnitId,TMP.FMaterialId from (").append("\r\n");
            sSQL.append("Select t.FID,t.FCompanyOrgUnitId,t.FMaterialId from (").append("\r\n");
            sSQL.append("Select Max(FPeriodBeginQty) as FPeriodBeginQty,FCompanyOrgUnitId,FMaterialId from ").append(costAdjTempTable).append("\r\n");
            sSQL.append("Group by FCompanyOrgUnitId, FMaterialId) tmp Inner Join ").append(costAdjTempTable).append(" t ");
            sSQL.append("ON tmp.FCompanyOrgUnitId = t.FCompanyOrgUnitId AND tmp.FMaterialId = t.FMaterialId AND tmp.FPeriodBeginQty = t.FPeriodBeginQty");
            sSQL.append(" ) TMP Group by TMP.FCompanyOrgUnitId,TMP.FMaterialId");
            DBUtil.execute((Context)ctx, (String)sSQL.toString());
            sSQL.setLength(0);
            sSQL.append("Update ").append(costAdjTempTable).append(" AS T1 Set (FPeriodAdjustDiff) = (").append("\r\n");
            sSQL.append(" Select T1.FDiffAmount - T2.FSumCost From (").append("\r\n");
            sSQL.append("  Select A.FID, Sum(B.FPeriodAdjustDiff) as FSumCost From ").append(maxIdTempTable).append(" A").append("\r\n");
            sSQL.append("  Inner Join ").append(costAdjTempTable).append(" B ").append("\r\n");
            sSQL.append("  On (B.FID <> A.FID And B.FCompanyOrgUnitId = A.FCompanyOrgUnitId And B.FMaterialId = A.FMaterialId)").append("\r\n");
            sSQL.append("  Group by A.FID,B.FCompanyOrgUnitID,B.FMaterialId").append("\r\n");
            sSQL.append(" ) T2 Where T1.FId = T2.FId").append("\r\n");
            sSQL.append(")");
            DBUtil.execute((Context)ctx, (String)sSQL.toString());
            sSQL.setLength(0);
            sSQL.append("Update T_IM_InventoryBalance AS T set (FPeriodAdjustDiff) = (").append("\r\n");
            if (isAudit) {
                sSQL.append(" Select T.FPeriodAdjustDiff + A.FPeriodAdjustDiff From ").append(costAdjTempTable).append(" AS A").append("\r\n");
            } else {
                sSQL.append(" Select T.FPeriodAdjustDiff - A.FPeriodAdjustDiff From ").append(costAdjTempTable).append(" AS A").append("\r\n");
            }
            sSQL.append(" Where T.FID = A.FID)");
            DBUtil.execute((Context)ctx, (String)sSQL.toString());
        }
        finally {
            DBUtil.releaseTempTable(ctx, costAdjTempTable);
            DBUtil.releaseTempTable(ctx, maxIdTempTable);
        }
    }

    public String[][] getCostDiffTableField() {
        String[][] fields = new String[][]{{"FId", "varchar(44)"}, {"FCompanyOrgUnitId", "varchar(44)"}, {"FMaterialId", "varchar(44)"}, {"FPriceDiff", "Numeric(21, 8) default 0"}, {"FPeriodBeginQty", "Numeric(21, 8) default 0"}, {"FDiffAmount", "Numeric(17, 4) default 0"}, {"FPeriodAdjustDiff", "Numeric(17, 4) default 0"}, {"FStoreTypeID", "varchar(44)"}};
        return fields;
    }

    public String[][] getMaxIdTableField() {
        String[][] fields = new String[][]{{"FId", "varchar(44)"}, {"FCompanyOrgUnitId", "varchar(44)"}, {"FMaterialId", "varchar(44)"}};
        return fields;
    }

    private void updateBillStatus(Context ctx, StandardCostAdjBillInfo info) throws BOSException {
        Connection conn = null;
        PreparedStatement pm = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String updateSql = "update T_CL_StandardCostAdjBill set FBaseStatus=?, FAuditorID=?, FAuditTime=? where FID=?";
            pm = conn.prepareStatement(updateSql);
            pm.setInt(1, 4);
            pm.setString(2, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            pm.setTimestamp(3, new Timestamp(new Date().getTime()));
            pm.setString(4, info.getId().toString());
            pm.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pm, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pm, (Connection)conn);
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandardCostAdjBillInfo info = (StandardCostAdjBillInfo)model;
        return info.getCompanyOrgUnit();
    }

    private StringBuffer GetWrittenSQL(String BillID) {
        StringBuffer sql = new StringBuffer();
        sql.append("Select Top 1 h.FNumber from T_IM_SaleIssueEntry d ");
        sql.append("INNER JOIN T_IM_SaleIssueBill h ");
        sql.append("\tON h.FID = d.FParentID ");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry ae ");
        sql.append("\tON ae.FMaterialID=d.FMaterialID ");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill ah ");
        sql.append("\tON ae.FParentID=ah.FID ");
        sql.append("Where d.FCompanyOrgUnitID=ah.FCompanyOrgUnitID ");
        sql.append("And ((h.FYear = ah.FYear and h.FPeriod >= ah.FPeriod) ");
        sql.append("Or (h.FYear > ah.FYear)) ");
        sql.append("And d.FWrittenOffBaseQty<>0 ");
        sql.append("And ah.FID='" + BillID + "' and d.FIsPresent=0 ");
        return sql;
    }

    private String GetVoucheredSQL(String BillID) {
        StringBuffer sqlwhere = new StringBuffer();
        sqlwhere.append("Where d.FCompanyOrgUnitID=ah.FCompanyOrgUnitID ");
        sqlwhere.append(" and ((h.FYear = ah.FYear and h.FPeriod >= ah.FPeriod) ");
        sqlwhere.append(" or (h.FYear > ah.FYear))");
        sqlwhere.append(" and h.FFiVouchered = 1 \r\n");
        sqlwhere.append(" and h.FBaseStatus = 4");
        sqlwhere.append(" And ah.FID='" + BillID + "' \r\n");
        return "Select top 1 temp.* from (" + this.getSelectAllBillData(sqlwhere.toString()) + ") as temp";
    }

    private String getSelectAllBillData(String sqlwhere) {
        StringBuffer sql = new StringBuffer();
        sql.append("Select d.FMaterialID,to_char(h.FNumber) FNumber from T_IM_PurInWarehsEntry d \r\n");
        sql.append("INNER JOIN T_IM_PurInWarehsBill h ON h.FID = d.FParentID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry ae on ae.FMaterialID=d.FMaterialID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill ah on ae.FParentID=ah.FID \r\n");
        sql.append(sqlwhere);
        sql.append(" UNION ALL \r\n");
        sql.append("Select d.FMaterialID,to_char(h.FNumber) FNumber from T_IM_ManufactureRecBillEntry d \r\n");
        sql.append("INNER JOIN T_IM_ManufactureRecBill h ON h.FID = d.FParentID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry ae on ae.FMaterialID=d.FMaterialID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill ah on ae.FParentID=ah.FID \r\n");
        sql.append(sqlwhere);
        sql.append(" UNION ALL \r\n");
        sql.append("Select d.FMaterialID,to_char(h.FNumber) FNumber from T_IM_MoveInWarehsBillEntry d \r\n");
        sql.append("INNER JOIN T_IM_MoveInWarehsBill h ON h.FID = d.FParentID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry ae on ae.FMaterialID=d.FMaterialID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill ah on ae.FParentID=ah.FID \r\n");
        sql.append(sqlwhere);
        sql.append(" UNION ALL \r\n");
        sql.append("Select d.FMaterialID,to_char(h.FNumber) FNumber from T_IM_OtherInWarehsBillEntry d \r\n");
        sql.append("INNER JOIN T_IM_OtherInWarehsBill h ON h.FID = d.FParentID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry ae on ae.FMaterialID=d.FMaterialID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill ah on ae.FParentID=ah.FID \r\n");
        sql.append(sqlwhere);
        sql.append(" UNION ALL \r\n");
        sql.append("Select d.FMaterialID,to_char(h.FNumber) FNumber from T_IM_SaleIssueEntry d \r\n");
        sql.append("INNER JOIN T_IM_SaleIssueBill h ON h.FID = d.FParentID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry ae on ae.FMaterialID=d.FMaterialID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill ah on ae.FParentID=ah.FID \r\n");
        sql.append(sqlwhere);
        sql.append(" UNION ALL \r\n");
        sql.append("Select d.FMaterialID,to_char(h.FNumber) FNumber from T_IM_MaterialReqBillEntry d \r\n");
        sql.append("INNER JOIN T_IM_MaterialReqBill h ON h.FID = d.FParentID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry ae on ae.FMaterialID=d.FMaterialID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill ah on ae.FParentID=ah.FID \r\n");
        sql.append(sqlwhere);
        sql.append(" UNION ALL \r\n");
        sql.append("Select d.FMaterialID,to_char(h.FNumber) FNumber from T_IM_MoveIssueBillEntry d \r\n");
        sql.append("INNER JOIN T_IM_MoveIssueBill h ON h.FID = d.FParentID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry ae on ae.FMaterialID=d.FMaterialID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill ah on ae.FParentID=ah.FID \r\n");
        sql.append(sqlwhere);
        sql.append(" UNION ALL \r\n");
        sql.append("Select d.FMaterialID,to_char(h.FNumber) FNumber from T_IM_OtherIssueBillEntry d \r\n");
        sql.append("INNER JOIN T_IM_OtherIssueBill h ON h.FID = d.FParentID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry ae on ae.FMaterialID=d.FMaterialID \r\n");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill ah on ae.FParentID=ah.FID \r\n");
        sql.append(sqlwhere);
        return sql.toString();
    }

    private void UpdateBillPrice(String BillID, Statement stmtUpdate, int currencyPresion) throws SQLException {
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL("T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry", BillID, currencyPresion));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL("T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry", BillID, currencyPresion));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL("T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry", BillID, currencyPresion));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL("T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry", BillID, currencyPresion));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL_2("T_IM_SaleIssueBill", "T_IM_SaleIssueEntry", BillID, currencyPresion));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL_1("T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry", BillID, currencyPresion));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL_1("T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry", BillID, currencyPresion));
        stmtUpdate.addBatch(this.UpdateBillsPriceSQL_1("T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry", BillID, currencyPresion));
        stmtUpdate.addBatch(this.UpdateBillsWriteoffSQL("T_IM_SaleIssueBill", "T_IM_SaleIssueEntry", BillID));
    }

    private String UpdateBillsPriceSQL(String billHead, String billEntry, String billID, int currencyPresion) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + billEntry + " as T  ");
        sql.append("SET (FStandardCost, FUnitStandardCost) = ( ");
        sql.append("\n SELECT ROUND(ae.FNewStandardPrice * d.FbaseQty,").append(currencyPresion).append("), ");
        sql.append(" CASE WHEN d.FQty = 0 THEN");
        sql.append(" 0 ");
        sql.append(" ELSE ");
        sql.append("ROUND((ae.FNewStandardPrice * d.FbaseQty) / d.FQty").append(",MATERIAL.FPRICEPRECISION)");
        sql.append(" END ");
        sql.append("FROM " + billEntry + " as D  ");
        sql.append("INNER JOIN " + billHead + " as H ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry as AE ON ae.FMaterialID = d.FMaterialID  ");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill as AH ON ae.FParentID = ah.FID  ");
        sql.append("INNER JOIN T_BD_MATERIAL as MATERIAL ON MATERIAL.FID = D.FMATERIALID ");
        sql.append("WHERE d.FCompanyOrgUnitID = ah.FCompanyOrgUnitID  ");
        sql.append("AND ((h.FYear = ah.FYear AND h.FPeriod >= ah.FPeriod) OR h.FYear > ah.FYear)  ");
        sql.append("AND h.FBaseStatus IN (1,2,4) ");
        sql.append("AND ah.FID = '" + billID + "'  ");
        sql.append("And T.FID=D.FID  ");
        sql.append(")  ");
        return sql.toString();
    }

    private String UpdateBillsPriceSQL_1(String billHead, String billEntry, String billID, int currencyPresion) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + billEntry + " as T  ");
        sql.append("SET (FStandardCost, FUnitStandardCost,FActualCost,FUnitActualCost) = ( ");
        sql.append("SELECT ROUND((ae.FNewStandardPrice * d.FbaseQty),").append(currencyPresion + "),");
        sql.append(" Case when d.FQty = 0 then");
        sql.append(" 0 ");
        sql.append(" else ");
        sql.append("ROUND((ae.FNewStandardPrice * d.FbaseQty) / d.FQty").append(",MATERIAL.FPRICEPRECISION)");
        sql.append(" END, ");
        sql.append(" ROUND((ae.FNewStandardPrice * d.FbaseQty),").append(currencyPresion + "),");
        sql.append(" Case when d.FQty = 0 then");
        sql.append(" 0 ");
        sql.append(" else ");
        sql.append("ROUND((ae.FNewStandardPrice * d.FbaseQty) / d.FQty ").append(",MATERIAL.FPRICEPRECISION)");
        sql.append(" END ");
        sql.append("FROM " + billEntry + " as D  ");
        sql.append("INNER JOIN " + billHead + " as H ON h.FID = d.FParentID  ");
        sql.append("INNER JOIN T_CL_StandardCostAdjEntry as AE ON ae.FMaterialID = d.FMaterialID  ");
        sql.append("INNER JOIN T_CL_StandardCostAdjBill as AH ON ae.FParentID = ah.FID  ");
        sql.append("INNER JOIN T_BD_MATERIAL as MATERIAL ON MATERIAL.FID = D.FMATERIALID ");
        sql.append("WHERE d.FCompanyOrgUnitID = ah.FCompanyOrgUnitID  ");
        sql.append("AND ((h.FYear = ah.FYear AND h.FPeriod >= ah.FPeriod) OR h.FYear > ah.FYear)  ");
        sql.append("AND h.FBaseStatus IN (1,2,4) ");
        sql.append("AND ah.FID = '" + billID + "'  ");
        sql.append("And T.FID=D.FID  ");
        sql.append(")  ");
        return sql.toString();
    }

    private String UpdateBillsPriceSQL_2(String billHead, String billEntry, String billID, int currencyPresion) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + billEntry + " as T  ");
        sql.append("SET (FStandardCost, FUnitStandardCost,FActualCost,FUnitActualCost,FUnWriteOffAmount) = ( ");
        sql.append("\n SELECT ROUND((ae.FNewStandardPrice * d.FbaseQty),").append(currencyPresion + "),");
        sql.append(" Case when d.FQty = 0 then");
        sql.append(" 0 ");
        sql.append(" else ");
        sql.append("ROUND((ae.FNewStandardPrice * d.FbaseQty) / d.FQty").append(",MATERIAL.FPRICEPRECISION)");
        sql.append(" END, ");
        sql.append(" ROUND((ae.FNewStandardPrice * d.FbaseQty),").append(currencyPresion + "),");
        sql.append(" Case when d.FQty = 0 then");
        sql.append(" 0 ");
        sql.append(" else ");
        sql.append("ROUND((ae.FNewStandardPrice * d.FbaseQty) / d.FQty").append(",MATERIAL.FPRICEPRECISION)");
        sql.append(" END, ");
        sql.append(" Case when d.FIsPresent=1 then");
        sql.append(" 0 ");
        sql.append(" else ");
        sql.append(" ROUND((ae.FNewStandardPrice * d.FbaseQty),").append(currencyPresion + ")");
        sql.append(" END ");
        sql.append("\n FROM " + billEntry + " as D  ");
        sql.append("\n INNER JOIN " + billHead + " as H ON h.FID = d.FParentID  ");
        sql.append("\n INNER JOIN T_CL_StandardCostAdjEntry as AE ON ae.FMaterialID = d.FMaterialID  ");
        sql.append("\n INNER JOIN T_CL_StandardCostAdjBill as AH ON ae.FParentID = ah.FID  ");
        sql.append("\n INNER JOIN T_BD_MATERIAL as MATERIAL ON MATERIAL.FID = D.FMATERIALID ");
        sql.append("\n WHERE d.FCompanyOrgUnitID = ah.FCompanyOrgUnitID  ");
        sql.append("\n AND ((h.FYear = ah.FYear AND h.FPeriod >= ah.FPeriod) OR h.FYear > ah.FYear)  ");
        sql.append("\n AND h.FBaseStatus IN (1,2,4) ");
        sql.append("\n AND ah.FID = '" + billID + "'  ");
        sql.append("\n And T.FID=D.FID  ");
        sql.append(")  ");
        return sql.toString();
    }

    private String UpdateBillsWriteoffSQL(String billHead, String billEntry, String billID) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + billEntry + " as T  ");
        sql.append("SET (FWrittenOffAmount) = ( ");
        sql.append("\n SELECT D.FActualCost-D.FUnWriteOffAmount ");
        sql.append("\n FROM " + billEntry + " as D  ");
        sql.append("\n INNER JOIN " + billHead + " as H ON h.FID = d.FParentID  ");
        sql.append("\n INNER JOIN T_CL_StandardCostAdjEntry as AE ON ae.FMaterialID = d.FMaterialID  ");
        sql.append("\n INNER JOIN T_CL_StandardCostAdjBill as AH ON ae.FParentID = ah.FID  ");
        sql.append("\n INNER JOIN T_BD_MATERIAL as MATERIAL ON MATERIAL.FID = D.FMATERIALID ");
        sql.append("\n WHERE d.FCompanyOrgUnitID = ah.FCompanyOrgUnitID  ");
        sql.append("\n AND ((h.FYear = ah.FYear AND h.FPeriod >= ah.FPeriod) OR h.FYear > ah.FYear)  ");
        sql.append("\n AND h.FBaseStatus IN (1,2,4) ");
        sql.append("\n AND ah.FID = '" + billID + "'  ");
        sql.append("\n And T.FID=D.FID  ");
        sql.append(")  ");
        return sql.toString();
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IStandardCostAdjBill isc = StandardCostAdjBillFactory.getLocalInstance(ctx);
        StandardCostAdjBillInfo scb = isc.getStandardCostAdjBillInfo(pk);
        if (scb != null && scb.getCompanyOrgUnit() != null) {
            ICompanyOrgUnit icou = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = icou.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(scb.getCompanyOrgUnit().getId()));
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._audit(ctx, pk);
    }

    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandardCostAdjBillInfo info = (StandardCostAdjBillInfo)model;
        if (info != null && info.getCompanyOrgUnit() != null) {
            return info.getCompanyOrgUnit().getId().toString();
        }
        return null;
    }

    private void updateEntryFields(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandardCostAdjBillInfo aStandardCostAdjBillInfo = (StandardCostAdjBillInfo)model;
        String tableName = "";
        String entryTableName = "";
        if (aStandardCostAdjBillInfo.getBillType() != null) {
            tableName = BillTypeUtils.getBillHeadTableName((Context)ctx, (String)aStandardCostAdjBillInfo.getBillType().getId().toString());
            entryTableName = BillTypeUtils.getBillEntryTableName((Context)ctx, (String)aStandardCostAdjBillInfo.getBillType().getId().toString());
        }
        if (tableName.equals("") || entryTableName.equals("")) {
            return;
        }
        StringBuffer updateEntryFields = new StringBuffer();
        StringBuffer selectBillFields = new StringBuffer();
        int size = this.standardcostadjUpdateFields.length;
        for (int i = 0; i < size; ++i) {
            updateEntryFields.append(this.standardcostadjUpdateFields[i]);
            if (this.standardcostadjUpdateFields[i].equals("FBILLBASESTATUS")) {
                selectBillFields.append("BILL.FBASESTATUS");
            } else {
                selectBillFields.append("BILL." + this.standardcostadjUpdateFields[i]);
            }
            if (size - 1 == i) continue;
            updateEntryFields.append(",");
            selectBillFields.append(",");
        }
        String sql = "update " + entryTableName + " set (" + updateEntryFields.toString() + ") = (select " + selectBillFields.toString() + " from " + tableName + " bill where bill.fid = '" + aStandardCostAdjBillInfo.getId().toString() + "') where " + entryTableName + ".fparentid = '" + aStandardCostAdjBillInfo.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        super._batchReverseSave(ctx, srcBillPKs, srcBillVOs, bOTBillOperStateEnum, bOTRelationInfos);
        this.syncEntryVoucherField(ctx, srcBillPKs, "T_CL_StandardCostAdjBill", "T_CL_StandardCostAdjentry");
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection selector = super.getSelector();
        selector.addObjectCollection((IObjectCollection)SCMSelectorFactory.getStandardCostAdjSelector());
        return selector;
    }

    protected void _generateVoucher(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        block21: {
            String id = null;
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            SCMBillBaseInfo model = (SCMBillBaseInfo)this.getValue(ctx, pk, selector);
            try {
                if (model != null && model.getId() != null) {
                    id = model.getId().toString();
                    IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                    boolean tag = mutexService.requestObjIDForUpdate(id);
                    if (!tag) {
                        throw new SCMBillException(SCMBillException.GENERATEVOUCHER_CONFLICT);
                    }
                }
                CoreBillBaseCollection collection = new CoreBillBaseCollection();
                collection.add((CoreBillBaseInfo)model);
                ObjectUuidPK botMappingPk = null;
                CompanyOrgUnitInfo cou = this.getCompanyOrgUnit(ctx, (IObjectPK)new ObjectUuidPK(model.getId()));
                if (cou == null) break block21;
                CtrlUnitInfo cu = cou.getCU();
                if (cu != null) {
                    IBOTMapping iBotMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
                    HashMap<String, CtrlUnitInfo> curCtx = new HashMap<String, CtrlUnitInfo>();
                    curCtx.put("TRANSMITCU", cu);
                    String voucherBosType = new VoucherInfo().getBOSType().toString();
                    BOTMappingCollection bc = iBotMapping.getMappingCollectionForSelect(collection, voucherBosType, DefineSysEnum.DAP, curCtx);
                    if (bc.get(0) != null) {
                        botMappingPk = new ObjectUuidPK(bc.get(0).getId());
                    }
                }
                boolean b = WfEventListenerStateManager.getInstance().isEnable();
                try {
                    if (!b) {
                        WfEventListenerStateManager.getInstance().enableEventListener();
                    }
                    IDAPTransformer dapTrans = DAPTransformerFactory.getLocalInstance((Context)ctx);
                    dapTrans.transform(collection, DAPVoucherTypeEnum.FIVoucher, botMappingPk);
                }
                catch (EASBizException e) {
                    throw e;
                }
                finally {
                    if (!b) {
                        WfEventListenerStateManager.getInstance().disableEventListener();
                    }
                }
            }
            catch (EASBizException e) {
                throw e;
            }
            finally {
                try {
                    if (id != null) {
                        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                        mutexService.releaseObjIDForUpdate(id);
                    }
                }
                catch (Exception ex) {
                    throw new BOSException((Throwable)ex);
                }
            }
        }
    }

    protected void syncEntryVoucherField(Context ctx, IObjectPK[] billPks, String billTableName, String entryTableName) throws BOSException {
    }

    public String getParamCon4Audit() {
        return "SCM_CAL_A02";
    }

    public String getParamCon4UnAudit() {
        return "SCM_CAL_A01";
    }

    private void updateAccountView(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.updateAccountViewMat(ctx, model);
        this.updateAccountViewDiff(ctx, model);
    }

    private void updateAccountViewMat(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandardCostAdjBillInfo billInfo = (StandardCostAdjBillInfo)model;
        String entryTableName = BillTypeUtils.getBillEntryTableName((Context)ctx, (String)billInfo.getBillType().getId().toString());
        StringBuffer sql = new StringBuffer();
        sql.append("update " + entryTableName + " T \r\n");
        sql.append("set (FaccountviewMatId) = \r\n");
        sql.append("(select T4.FID as faccount from  \r\n");
        sql.append(" T_CL_StandardCostAdjEntry T5 \r\n");
        sql.append("inner join T_cl_standardcostadjbill T6 on T5.Fparentid = T6.FId \r\n");
        sql.append("inner join  T_BD_MaterialCompanyInfo T1  on  T5.FmaterialId = T1.FmaterialId  and T6.Fcompanyorgunitid = T1.Fcompanyid\r\n");
        sql.append("INNER JOIN T_BD_KAClassificationDetail T2 on T1.FKAClassID = T2.FKaclassficlink \r\n");
        sql.append("INNER JOIN T_BD_KAccountItem T3 on T2.FAccountitemlinkID = T3.FID \r\n");
        sql.append("INNER JOIN T_BD_AccountView T4  ON T2.FAccountlinkID = T4.FID  \r\n");
        sql.append("where T5.Fid = T.Fid and T3.FNumber = '1001')\r\n");
        sql.append("where T.fparentId ='" + model.get("id").toString() + "'\r\n");
        DBUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateAccountViewDiff(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        StandardCostAdjBillInfo billInfo = (StandardCostAdjBillInfo)model;
        String entryTableName = BillTypeUtils.getBillEntryTableName((Context)ctx, (String)billInfo.getBillType().getId().toString());
        StringBuffer sql = new StringBuffer();
        sql.append("update " + entryTableName + " T \r\n");
        sql.append("set (FaccountviewDiffId) = \r\n");
        sql.append("(select T4.FID as faccount from  \r\n");
        sql.append(" T_CL_StandardCostAdjEntry T5 \r\n");
        sql.append("inner join T_cl_standardcostadjbill T6 on T5.Fparentid = T6.FId \r\n");
        sql.append("inner join  T_BD_MaterialCompanyInfo T1  on  T5.FmaterialId = T1.FmaterialId  and T6.Fcompanyorgunitid = T1.Fcompanyid\r\n");
        sql.append("INNER JOIN T_BD_KAClassificationDetail T2 on T1.FKAClassID = T2.FKaclassficlink \r\n");
        sql.append("INNER JOIN T_BD_KAccountItem T3 on T2.FAccountitemlinkID = T3.FID \r\n");
        sql.append("INNER JOIN T_BD_AccountView T4  ON T2.FAccountlinkID = T4.FID  \r\n");
        sql.append("where T5.Fid = T.Fid and T3.FNumber = '1005')\r\n");
        sql.append("where T.fparentId ='" + model.get("id").toString() + "'\r\n");
        DBUtil.execute((Context)ctx, (String)sql.toString());
    }
}

