/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgFactory;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgInfo;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.scm.cal.StockPriceFactory;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;

public class StockPriceCalculateJobHandler
implements IJobHandler {
    private static final long serialVersionUID = 1L;
    private static final String res = "com.kingdee.eas.basedata.common.perf.PerfResource";

    public Object execute(Job job) throws Exception {
        CompanyOrgUnitInfo company = null;
        Context ctx = null;
        MessageInfo info = null;
        ctx = job.getContext();
        try {
            JobParam jobParam = (JobParam)job.getParameters();
            CalculateParams bizParam = (CalculateParams)jobParam.getBizParam();
            Locale locale = null;
            company = (CompanyOrgUnitInfo)bizParam.getObject("COMPANY_OBJ");
            ctx.setLocale(jobParam.getLocale());
            String userId = ctx.getCaller().toString();
            info = new MessageInfo();
            info.setUserID(userId);
            info.setbizAction(job.getTitle());
            info.setOrgNumber(company.getName(locale) + "(" + company.getNumber() + ")");
            boolean isSendMsg = true;
            String jobNum = jobParam.getJobNumber();
            String oql = " where number = '" + jobNum + "'";
            PerfSepCfgInfo pfInfo = PerfSepCfgFactory.getLocalInstance((Context)ctx).getPerfSepCfgInfo(oql);
            if (pfInfo != null) {
                isSendMsg = pfInfo.isIsSendMsg();
            }
            info.setSendMsg(isSendMsg);
            StockPriceFactory.getLocalInstance(ctx).calculateNewPrice(bizParam);
            JobLog log = new JobLog(JobLog.Type.Info, job.getTitle() + this.getResource("SUCCESS", jobParam.getLocale()));
            job.saveMessage(log);
            info.setSuccessed(true);
            MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
        }
        catch (Exception e) {
            info.setExecption(e.getMessage());
            info.setSuccessed(false);
            MessageUtil.sendMsg((Context)ctx, info);
            throw e;
        }
        finally {
            PerfSepServerUtils.updateTaskState((Job)job);
        }
        return true;
    }

    private String getResource(String resName, Locale locale) {
        return ResourceBase.getString((String)res, (String)resName, (Locale)locale);
    }
}

