/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.StockPriceTypeEnum;
import com.kingdee.eas.scm.cal.app.AbstractStockPriceControllerBean;
import com.kingdee.eas.scm.cal.app.calculate.StockPriceCalculate;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import org.apache.log4j.Logger;

public class StockPriceControllerBean
extends AbstractStockPriceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.StockPriceControllerBean");

    @Override
    protected void _calculateNewPrice(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        String warehouseIds;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("COMPANY_OBJ");
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
        boolean isCloseAccount = params.getBoolean("IsCloseAccount");
        if (isCloseAccount) {
            params.setString("tempTable", "T_IM_INVENTORYBALANCE");
        }
        params.setString("COMPANY_ID", company.getId().toString());
        params.setBoolean("isGetPrePeriod", true);
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_CL_StockPrice where FCompanyOrgUnitID = '" + company.getId().toString() + "'");
        sql.append(" and FYear = ").append(currPeriod.getPeriodYear());
        sql.append(" and FPeriod = ").append(currPeriod.getPeriodNumber());
        sql.append(" and FPriceType in (0,1)");
        String storageOrgIds = params.getString("STORAGEORGUNITID");
        if (!StringUtil.isEmpty((String)storageOrgIds)) {
            sql.append(" and FStorageOrgUnitId in (" + storageOrgIds + ")");
        }
        if (!StringUtil.isEmpty((String)(warehouseIds = params.getString("WAREHOUSEID")))) {
            sql.append(" and FWarehouseID in (" + warehouseIds + ")");
        }
        String materialNumber = params.getString("MATERIAL_FROM");
        String materialNumberTo = params.getString("MATERIAL_TO");
        if (!StringUtil.isEmpty((String)materialNumber) && !StringUtil.isEmpty((String)materialNumberTo)) {
            sql.append(" and FMaterialId in (select fid from t_bd_material where fnumber >= '" + materialNumber + "' and fnumber <= '" + materialNumberTo + "')");
        }
        DBUtil.execute((Context)ctx, (String)sql.toString());
        this.insertNewPrice(ctx, company, currPeriod, params, CalculateKindEnum.INPUT_WAREHOUSE, StockPriceTypeEnum.PREPREIOD_NEW_INPRICE);
        this.insertNewPrice(ctx, company, currPeriod, params, CalculateKindEnum.OUTPUT_WAREHOUSE, StockPriceTypeEnum.PREPREIOD_NEW_OUTPRICE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNewPrice(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currPeriod, CalculateParams params, CalculateKindEnum inWhs, StockPriceTypeEnum priceType) throws BOSException, EASBizException {
        String maxBizDateTable = null;
        String newPriceTable = null;
        String newline = "\n\r";
        try {
            StringBuffer sql = new StringBuffer();
            StockPriceCalculate stockPriceCalculate = new StockPriceCalculate();
            IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
            String calType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId()), "SCM_CAL_002");
            stockPriceCalculate.setCalType(Integer.parseInt(calType));
            maxBizDateTable = stockPriceCalculate.getNewPriceData(ctx, params, currPeriod, inWhs);
            newPriceTable = stockPriceCalculate.getTheNewPriceTmpTable(ctx, maxBizDateTable);
            sql.setLength(0);
            sql.append("insert into T_CL_StockPrice(FID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FMaterialID").append(newline);
            sql.append(",FLot,FAssistPropertyID,FProjectID,FTrackNumberID,FYear,FPeriod,FPrice,FPriceType)").append(newline);
            sql.append("select newbosid('E4BFDAF6'),'").append(company.getId().toString());
            sql.append("',isnull(FStorageOrgUnitID,'93uhNTdxcafgUztAqMC5Zusff9I=')").append(newline);
            sql.append(",isnull(FWarehouseID,'93uhNTdycafgUztAqMC5Zrvp+K4=')").append(newline);
            sql.append(",FMaterialID,FLot,FAssistPropertyID,FProjectID,FTrackNumberID,").append(currPeriod.getPeriodYear()).append(newline);
            sql.append(",").append(currPeriod.getPeriodNumber()).append(",").append("FBaseUnitActualCost").append(newline);
            sql.append(",").append(priceType.getValue()).append(newline);
            sql.append("from ").append(newPriceTable);
            DBUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Throwable throwable) {
            DBUtil.releaseTempTable(ctx, newPriceTable);
            DBUtil.releaseTempTable(ctx, maxBizDateTable);
            throw throwable;
        }
        DBUtil.releaseTempTable(ctx, newPriceTable);
        DBUtil.releaseTempTable(ctx, maxBizDateTable);
    }
}

