/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.WriteOffGroupCollection;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.WriteOffRecordInfo;
import com.kingdee.eas.scm.cal.newutil.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.framework.log.listener.SCMBizLogAdapter;
import com.kingdee.eas.scm.framework.writeoff.IWriteOffStrategy;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WriteOffStrategy
implements IWriteOffStrategy {
    public static final String RES = "com.kingdee.eas.scm.cal.ManualWriteOffResource";

    public List buildWriteOffBillInfo(Context ctx, Map mainMap, Map secMap, MappingConditionEntryInfo conditionEntryInfo, WriteOffCommonParams params) throws BOSException, EASBizException {
        return null;
    }

    protected void wrietOffBizLog(Context ctx, List result) {
        if (result.size() == 0) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        HashMap<String, String> hashLog = new HashMap<String, String>(10);
        hashLog.put("FMethodName", "doWriteOff");
        hashLog.put("FMethodAlias", "\u6838\u9500");
        SCMBizLogAdapter.writeBizLogForWriteOff((Context)ctx, hashLog, (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), new HashSet(result));
    }

    protected void updateInvoiceBill(Context ctx, List invoiceBill, Map mainMap, String tblName) throws BOSException {
        if (invoiceBill.isEmpty()) {
            return;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("update ").append(tblName);
        bf.append(" set FUnWriteOffBaseQty=FUnWriteOffBaseQty-?");
        bf.append(" ,FWrittenOffBaseQty=FWrittenOffBaseQty+?");
        bf.append(" ,FLocalUnWriteOffAmount=FLocalUnWriteOffAmount-?");
        bf.append(" ,FLocalWrittenOffAmount=FLocalWrittenOffAmount+?");
        bf.append(" where FID=?");
        String updatePurInVoiceSQL = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pm = conn.prepareStatement(updatePurInVoiceSQL);
            WriteOffRecordInfo recordInfo2 = null;
            for (WriteOffRecordInfo recordInfo2 : invoiceBill) {
                pm.setBigDecimal(1, recordInfo2.getCurrWrittenOffQty());
                pm.setBigDecimal(2, recordInfo2.getCurrWrittenOffQty());
                pm.setBigDecimal(3, recordInfo2.getCurrWrittenOffAmount());
                pm.setBigDecimal(4, recordInfo2.getCurrWrittenOffAmount());
                pm.setString(5, recordInfo2.getBillEntryID());
                pm.addBatch();
            }
            pm.executeBatch();
            HashMap<String, WriteOffRecordInfo> cacheMainMap = new HashMap<String, WriteOffRecordInfo>();
            for (List secList : mainMap.values()) {
                for (WriteOffRecordInfo entryInfo : secList) {
                    cacheMainMap.put(entryInfo.getBillEntryID(), entryInfo);
                }
            }
            for (WriteOffRecordInfo recordInfo2 : invoiceBill) {
                if (cacheMainMap == null || cacheMainMap.isEmpty() || recordInfo2.getBillEntryID() == null || !cacheMainMap.containsKey(recordInfo2.getBillEntryID())) continue;
                WriteOffRecordInfo entryInfo = (WriteOffRecordInfo)cacheMainMap.get(recordInfo2.getBillEntryID());
                entryInfo.setUnWirteOffQty(entryInfo.getUnWirteOffQty().subtract(recordInfo2.getCurrWrittenOffQty()));
                entryInfo.setWirttenOffQty(entryInfo.getWirttenOffQty().add(recordInfo2.getCurrWrittenOffQty()));
                entryInfo.setUnWriteOffAmount(entryInfo.getUnWriteOffAmount().subtract(recordInfo2.getCurrWrittenOffAmount()));
                entryInfo.setWrittenOffAmount(entryInfo.getWrittenOffAmount().add(recordInfo2.getCurrWrittenOffAmount()));
                entryInfo.setCurrWrittenOffAmount(entryInfo.getUnWriteOffAmount());
                entryInfo.setCurrWrittenOffQty(entryInfo.getUnWirteOffQty());
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, pm);
                throw throwable;
            }
        }
        DBUtil.close(conn, pm);
    }

    private String getUpdatePurSQL(String purEntryID, String otherEntryID, boolean isLocalCurrency) {
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_IM_PurInWarehsEntry as t set ( ");
        sb.append(" FPrice,");
        sb.append(" FTaxPrice,");
        sb.append(" FActualPrice,");
        sb.append(" FActualTaxPrice,");
        sb.append(" FPurchaseCost,");
        sb.append(" FUnitPurchaseCost,");
        sb.append(" FAmount,");
        sb.append(" FTax,");
        sb.append(" FLocalTax,");
        sb.append(" FTaxAmount,");
        sb.append(" FLocalTaxAmount )  ");
        sb.append(" = (select entry.FPrice,");
        sb.append("  entry.FTaxPrice,");
        sb.append("  entry.FRealPrice,");
        sb.append("  entry.FactualPrice,");
        sb.append("  entry.FAmountLocal,");
        if (isLocalCurrency) {
            sb.append("  entry.FRealPrice,");
        } else {
            sb.append("  ROUND(TO_DECIMAL(entry.FAmountLocal/entry.Fquantity,21,8),mt.FPriceprecision ),");
        }
        sb.append("  entry.FAmount,");
        sb.append("  entry.FTaxAmount,");
        sb.append("  entry.FTaxAmountLocal,");
        sb.append("  entry.FRecievePayAmount,");
        sb.append("  entry.FRecievePayAmountLocal ");
        sb.append("  from T_AP_Otherbillentry as entry inner join T_BD_Material mt on entry.fmaterialid = mt.fid ");
        sb.append(" where entry.fid = '").append(otherEntryID).append("' ) ");
        sb.append(" where t.fid = '").append(purEntryID).append("'");
        return sb.toString();
    }

    private String getUpdatePurCostSQL(String purEntryID, String otherEntryID) {
        StringBuffer sb = new StringBuffer();
        sb.append("  update T_IM_PurInWarehsEntry as t set (FActualCost,FUnitActualCost) =  ");
        sb.append("  ( select isnull(t1.FPurchaseCost,0) + isnull(t1.FPurchaseFee,0) + isnull(t1.FMaterialCost,0),");
        sb.append(" case WHEN t1.FPurchaseFee = 0 AND t1.FMaterialCost = 0 then t1.FUnitPurchaseCost else ");
        sb.append("  ROUND(TO_DECIMAL(TO_DECIMAL(isnull(t1.FPurchaseCost,0) + isnull(t1.FPurchaseFee,0) +");
        sb.append(" isnull(t1.FMaterialCost,0),17,4)/t1.Fqty,21,8),t2.FPriceprecision ) end ");
        sb.append("  from T_IM_PurInWarehsEntry t1 inner join T_BD_Material t2 on t1.fmaterialid=t2.fid ");
        sb.append(" where t1.fid =  '").append(purEntryID).append("' )");
        sb.append(" where t.fid = '").append(purEntryID).append("' ");
        return sb.toString();
    }

    private String getUpdateExchangerRateSQL(String purID, BigDecimal exchangeRate) {
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_IM_PurInWarehsBill set FExchangeRate = ").append(exchangeRate.toString());
        sb.append(" where fid = '").append(purID).append("'");
        return sb.toString();
    }

    protected Map getUnWriteOffBill(Context ctx, Set idSet) throws BOSException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select FParentID from t_im_purinwarehsentry");
        sql.append(" where fparentid IN (").append(com.kingdee.eas.scm.cal.util.CalculateUtil.getSqlInString(idSet)).append(")");
        sql.append(" GROUP BY FParentID HAVING sum(abs(isnull(fwrittenOffQty,0))) = 0");
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                result.put(rs.getString(1), Boolean.TRUE);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected Map getMoveMateiralBill(Context ctx, Set idSet) throws BOSException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        StringBuffer sql = new StringBuffer();
        sql.append(" select DISTINCT entry.FParentid from t_im_purinwarehsentry entry INNER JOIN t_bd_materialcompanyinfo mcom ");
        sql.append(" ON entry.FMaterialID = mcom.FMaterialID and entry.FCompanyOrgUnitID = mcom.FCompanyID");
        sql.append(" WHERE mcom.FAccountType = 1 and entry.FParentid IN (").append(com.kingdee.eas.scm.cal.util.CalculateUtil.getSqlInString(idSet)).append(")");
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                result.put(rs.getString(1), Boolean.TRUE);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected void updateIMBill(Context ctx, List imBill, Map secMap, boolean isSaleWriteOff) throws BOSException, EASBizException {
        if (imBill.isEmpty()) {
            return;
        }
        WriteOffRecordInfo recordInfo2 = null;
        Map unWriteOffBill = new HashMap(0);
        Map moveMateiralBill = new HashMap(0);
        if (!isSaleWriteOff) {
            HashSet<String> idSet = new HashSet<String>();
            for (WriteOffRecordInfo recordInfo2 : imBill) {
                if (recordInfo2.getBigDecimal("reWriteExchangeRate") == null) continue;
                idSet.add(recordInfo2.getBillID());
            }
            if (idSet.size() > 0) {
                unWriteOffBill = this.getUnWriteOffBill(ctx, idSet);
                moveMateiralBill = this.getMoveMateiralBill(ctx, idSet);
            }
        }
        StringBuffer bf = new StringBuffer();
        bf.append("update ").append(isSaleWriteOff ? "T_IM_SaleIssueEntry" : "T_IM_PurInWarehsEntry");
        bf.append(" set FUnWriteOffBaseQty=FUnWriteOffBaseQty-?");
        bf.append(" ,FWrittenOffBaseQty=FWrittenOffBaseQty+?");
        bf.append(" ,FUnWriteOffQty=FUnWriteOffQty-?");
        bf.append(" ,FWrittenOffQty=FWrittenOffQty+?");
        bf.append(" ,FUnWriteOffAmount=?-(FWrittenOffAmount+?)");
        bf.append(" ,FWrittenOffAmount=FWrittenOffAmount+?");
        if (isSaleWriteOff) {
            bf.append(" ,FUnitActualCost=?");
            bf.append(" ,FActualCost=?");
        } else {
            bf.append(" ,FUnitPurchaseCost=?");
            bf.append(" ,FPurchaseCost=?");
        }
        bf.append(" where FID=?");
        String updatePurInWarehsSQL = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pm = conn.prepareStatement(updatePurInWarehsSQL);
            BigDecimal curWriteOffQty = null;
            for (WriteOffRecordInfo recordInfo2 : imBill) {
                curWriteOffQty = recordInfo2.getCurrWrittenOffQty().equals(recordInfo2.getUnWirteOffQty()) ? recordInfo2.getBigDecimal("unWriteOffQty") : recordInfo2.getCurrWrittenOffQty().divide(recordInfo2.getBigDecimal("baseConvsRate"), recordInfo2.getInt("qtyPrecision"), 4);
                pm.setBigDecimal(1, recordInfo2.getCurrWrittenOffQty());
                pm.setBigDecimal(2, recordInfo2.getCurrWrittenOffQty());
                pm.setBigDecimal(3, curWriteOffQty);
                pm.setBigDecimal(4, curWriteOffQty);
                pm.setBigDecimal(5, isSaleWriteOff ? recordInfo2.getActualCost() : recordInfo2.getBigDecimal("purchaseCost"));
                pm.setBigDecimal(6, recordInfo2.getCurrWrittenOffAmount());
                pm.setBigDecimal(7, recordInfo2.getCurrWrittenOffAmount());
                pm.setBigDecimal(8, isSaleWriteOff ? recordInfo2.getBigDecimal("unitActualCost") : recordInfo2.getBigDecimal("unitPurchaseCost"));
                pm.setBigDecimal(9, isSaleWriteOff ? recordInfo2.getActualCost() : recordInfo2.getBigDecimal("purchaseCost"));
                pm.setString(10, recordInfo2.getBillEntryID());
                pm.addBatch();
            }
            pm.executeBatch();
            if (!isSaleWriteOff) {
                ArrayList<String> sqlList = new ArrayList<String>();
                ArrayList<String> idList = new ArrayList<String>();
                ArrayList<String> fwIdList = new ArrayList<String>();
                for (WriteOffRecordInfo recordInfo2 : imBill) {
                    if (!recordInfo2.getBoolean("isWriteCost")) continue;
                    if (recordInfo2.getBigDecimal("reWriteExchangeRate") != null && unWriteOffBill.containsKey(recordInfo2.getBillID()) && !moveMateiralBill.containsKey(recordInfo2.getBillID())) {
                        sqlList.add(this.getUpdateExchangerRateSQL(recordInfo2.getBillID(), recordInfo2.getBigDecimal("reWriteExchangeRate")));
                    }
                    if (recordInfo2.getBoolean("isOverWrite")) {
                        sqlList.add(this.getUpdatePurSQL(recordInfo2.getBillEntryID(), recordInfo2.getString("apEntryId"), recordInfo2.getString("currencyId").equals(recordInfo2.getString("baseCurrencyId"))));
                        sqlList.add(this.getUpdatePurCostSQL(recordInfo2.getBillEntryID(), recordInfo2.getString("apEntryId")));
                        continue;
                    }
                    if (recordInfo2.getBoolean("isFullWriteOff")) {
                        fwIdList.add(recordInfo2.getBillEntryID());
                        continue;
                    }
                    idList.add(recordInfo2.getBillEntryID());
                }
                DBUtil.execute(conn, sqlList.toArray(new String[sqlList.size()]));
                if (recordInfo2 != null) {
                    CalculateUtil.writeOffUpdatePurInfo(ctx, fwIdList, recordInfo2.getInt("basePrecision"), true);
                    CalculateUtil.writeOffUpdatePurInfo(ctx, idList, recordInfo2.getInt("basePrecision"), false);
                }
            }
            HashMap<String, WriteOffRecordInfo> cacheSecMap = new HashMap<String, WriteOffRecordInfo>();
            for (List secList : secMap.values()) {
                for (WriteOffRecordInfo entryInfo : secList) {
                    cacheSecMap.put(entryInfo.getBillEntryID(), entryInfo);
                }
            }
            for (WriteOffRecordInfo recordInfo2 : imBill) {
                if (cacheSecMap == null || cacheSecMap.isEmpty() || recordInfo2.getBillEntryID() == null || !cacheSecMap.containsKey(recordInfo2.getBillEntryID())) continue;
                WriteOffRecordInfo entryInfo = (WriteOffRecordInfo)cacheSecMap.get(recordInfo2.getBillEntryID());
                entryInfo.setUnWirteOffQty(entryInfo.getUnWirteOffQty().subtract(recordInfo2.getCurrWrittenOffQty()));
                entryInfo.setWirttenOffQty(entryInfo.getWirttenOffQty().add(recordInfo2.getCurrWrittenOffQty()));
                if (isSaleWriteOff) {
                    entryInfo.setBigDecimal("unWriteOffQty", entryInfo.getBigDecimal("unWriteOffQty").subtract(curWriteOffQty));
                }
                entryInfo.setUnWriteOffAmount((isSaleWriteOff ? recordInfo2.getActualCost() : recordInfo2.getBigDecimal("purchaseCost")).subtract(entryInfo.getWrittenOffAmount().add(recordInfo2.getCurrWrittenOffAmount())));
                entryInfo.setWrittenOffAmount(entryInfo.getWrittenOffAmount().add(recordInfo2.getCurrWrittenOffAmount()));
                entryInfo.setCurrWrittenOffAmount(entryInfo.getUnWriteOffAmount());
                entryInfo.setCurrWrittenOffQty(entryInfo.getUnWirteOffQty());
                if (isSaleWriteOff) {
                    entryInfo.setBigDecimal("unitActualCost", recordInfo2.getBigDecimal("unitActualCost"));
                    entryInfo.setActualCost(recordInfo2.getActualCost());
                    continue;
                }
                entryInfo.setBigDecimal("unitPurchaseCost", recordInfo2.getBigDecimal("unitPurchaseCost"));
                entryInfo.setBigDecimal("purchaseCost", recordInfo2.getBigDecimal("purchaseCost"));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, new PreparedStatement[]{pm}, new ResultSet[0]);
                throw throwable;
            }
        }
        DBUtil.close(conn, new PreparedStatement[]{pm}, new ResultSet[0]);
    }

    protected WriteOffGroupInfo buildSingleBillInfo(Context ctx, List mainList, List secList) {
        Iterator it;
        WriteOffGroupInfo billInfo = new WriteOffGroupInfo();
        if (mainList != null) {
            it = mainList.iterator();
            while (it.hasNext()) {
                ((IObjectCollection)billInfo.get("entry")).addObject((IObjectValue)((WriteOffRecordInfo)it.next()));
            }
        }
        if (secList != null) {
            it = secList.iterator();
            while (it.hasNext()) {
                ((IObjectCollection)billInfo.get("entry")).addObject((IObjectValue)((WriteOffRecordInfo)it.next()));
            }
        }
        if (((IObjectCollection)billInfo.get("entry")).size() > 0) {
            return billInfo;
        }
        return null;
    }

    protected WriteOffGroupCollection buildSameSideBillInfoByRelation(Context ctx, List list, WriteOffCommonParams params) throws BOSException, EASBizException {
        WriteOffGroupCollection coll = new WriteOffGroupCollection();
        HashMap<String, WriteOffRecordInfo> entryIdMap = new HashMap<String, WriteOffRecordInfo>();
        HashMap sourceEntryIdMap = new HashMap();
        WriteOffRecordInfo entryInfo2 = null;
        List<WriteOffRecordInfo> currList = null;
        for (WriteOffRecordInfo entryInfo2 : list) {
            entryIdMap.put(entryInfo2.getBillEntryID(), entryInfo2);
            if (sourceEntryIdMap.containsKey(entryInfo2.getString("sourceBillEntryId"))) {
                currList = (List)sourceEntryIdMap.get(entryInfo2.getString("sourceBillEntryId"));
                currList.add(entryInfo2);
                continue;
            }
            currList = new ArrayList<WriteOffRecordInfo>();
            currList.add(entryInfo2);
            sourceEntryIdMap.put(entryInfo2.getString("sourceBillEntryId"), currList);
        }
        int dischargeType = (Integer)params.get((Object)"dischargeType");
        WriteOffRecordInfo mainEntryInfo = null;
        WriteOffRecordInfo secEntryInfo = null;
        WriteOffGroupInfo billInfo = null;
        Map.Entry me2 = null;
        ArrayList removeItem = new ArrayList();
        boolean isCrossPeriodNotWriteOff = (Boolean)params.get((Object)"isCrossPeriodNotWriteOff");
        for (Map.Entry me2 : entryIdMap.entrySet()) {
            if (!sourceEntryIdMap.containsKey(me2.getKey())) continue;
            mainEntryInfo = (WriteOffRecordInfo)me2.getValue();
            currList = (List)sourceEntryIdMap.get(me2.getKey());
            billInfo = new WriteOffGroupInfo();
            for (int i = 0; i < currList.size(); ++i) {
                secEntryInfo = (WriteOffRecordInfo)currList.get(i);
                if (mainEntryInfo.getCurrWrittenOffQty().signum() * secEntryInfo.getCurrWrittenOffQty().signum() >= 0 || (!params.isFlowWriteOff() || !mainEntryInfo.getBillID().equals(params.getFlowWfBillId()) && !secEntryInfo.getBillID().equals(params.getFlowWfBillId()) || !this.isWriteOff(params, mainEntryInfo, secEntryInfo)) && params.isFlowWriteOff()) continue;
                if (Boolean.TRUE.equals(params.get((Object)"isDevolve")) && mainEntryInfo.getInt("dosingType") != 4 && mainEntryInfo.getBigDecimal("scunwrittenoffqty").compareTo(BigDecimal.ZERO) != 0) {
                    billInfo.setBoolean("isDevolveWriteOff", Boolean.TRUE);
                }
                removeItem.clear();
                this.addEntryInfo(ctx, (IObjectCollection)billInfo.get("entry"), mainEntryInfo, secEntryInfo, removeItem, true, params);
                if (removeItem.size() <= 0) continue;
                list.removeAll(removeItem);
            }
            if (mainEntryInfo.getBoolean("isInitBill")) {
                billInfo.put("isInitBill", true);
            }
            coll.add(billInfo);
        }
        return coll;
    }

    protected boolean isWriteOff(WriteOffCommonParams params, WriteOffRecordInfo mainEntryInfo, WriteOffRecordInfo secEntryInfo) {
        String writeoffParam;
        boolean isWriteOff = false;
        int dischargeType = (Integer)params.get((Object)"dischargeType");
        boolean isSaleWriteOff = (Boolean)params.get((Object)"isSaleWriteOff");
        PeriodInfo curPeriodInfo = (PeriodInfo)params.get((Object)"currentPeriod");
        String string = writeoffParam = isSaleWriteOff ? params.get((Object)"SCM_CAL_020").toString() : params.get((Object)"SCM_CAL_018").toString();
        if ("1".equals(writeoffParam)) {
            isWriteOff = false;
            return isWriteOff;
        }
        if ("0".equals(writeoffParam)) {
            if (!isSaleWriteOff && dischargeType != 0 && mainEntryInfo.getInt("year") * 100 + mainEntryInfo.getInt("period") != secEntryInfo.getInt("year") * 100 + secEntryInfo.getInt("period") && mainEntryInfo.getInt("year") * 100 + mainEntryInfo.getInt("period") > curPeriodInfo.getPeriodYear() * 100 + curPeriodInfo.getPeriodNumber() && secEntryInfo.getInt("year") * 100 + secEntryInfo.getInt("period") > curPeriodInfo.getPeriodYear() * 100 + curPeriodInfo.getPeriodNumber()) {
                isWriteOff = false;
                return isWriteOff;
            }
            isWriteOff = true;
            return isWriteOff;
        }
        if ("2".equals(writeoffParam) && mainEntryInfo.getInt("year") * 100 + mainEntryInfo.getInt("period") == secEntryInfo.getInt("year") * 100 + secEntryInfo.getInt("period")) {
            isWriteOff = true;
            return isWriteOff;
        }
        return isWriteOff;
    }

    protected WriteOffGroupInfo buildSameSideBillInfo(Context ctx, List list, WriteOffCommonParams params) throws BOSException, EASBizException {
        ArrayList<WriteOffRecordInfo> positive = new ArrayList<WriteOffRecordInfo>();
        ArrayList<WriteOffRecordInfo> negative = new ArrayList<WriteOffRecordInfo>();
        boolean isSaleWriteOff = (Boolean)params.get((Object)"isSaleWriteOff");
        boolean isNotBalanceAdjust = (Integer)params.get((Object)"dischargeType") != 0;
        WriteOffRecordInfo entryInfo = null;
        WriteOffRecordInfo preEntryInfo = null;
        boolean isInitBill = false;
        for (int i = 0; i < list.size(); ++i) {
            entryInfo = (WriteOffRecordInfo)list.get(i);
            if (entryInfo.getBoolean("isinitbill")) {
                isInitBill = true;
            }
            if (!isSaleWriteOff && isNotBalanceAdjust && preEntryInfo != null && entryInfo.getBoolean("isinitbill") != preEntryInfo.getBoolean("isinitbill")) {
                throw new CalculateException(CalculateException.NOT_MIX_WRITEOFF);
            }
            preEntryInfo = entryInfo;
            if (entryInfo.getCurrWrittenOffQty().signum() > 0) {
                entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
                positive.add(entryInfo);
                continue;
            }
            if (entryInfo.getCurrWrittenOffQty().signum() >= 0) continue;
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            negative.add(entryInfo);
        }
        StringBuffer sql = new StringBuffer();
        IRowSet rs = null;
        if (positive.size() > 0 && negative.size() > 0) {
            WriteOffGroupInfo billInfo = new WriteOffGroupInfo();
            billInfo.setBoolean("isinitbill", isInitBill);
            IObjectCollection entryColl = (IObjectCollection)billInfo.get("entry");
            WriteOffRecordInfo mainEntryInfo2 = null;
            WriteOffRecordInfo secEntryInfo2 = null;
            HashMap costReturn2CostIssueMap = new HashMap();
            Set destBillIdSet = null;
            HashMap<String, Boolean> billCanFindRelationMap = new HashMap<String, Boolean>();
            ArrayList removeItem = new ArrayList();
            for (WriteOffRecordInfo secEntryInfo2 : negative) {
                destBillIdSet = new HashSet<String>();
                if (!"DawAAAAPoA+wCNyn".equals(secEntryInfo2.getTransactionType()) && !"DawAAAAPoASwCNyn".equals(secEntryInfo2.getTransactionType()) || billCanFindRelationMap.get(secEntryInfo2.getString("sourcebillentryid")) != null) continue;
                sql.append("select botRel.FDESTOBJECTID as fdestBillId from T_IM_SaleIssueEntry saleBillEntry").append(" inner join T_bot_relation botRel on saleBillEntry.fsourcebillid = botRel.FSRCOBJECTID").append(" where saleBillEntry.fid = '").append(secEntryInfo2.getString("sourcebillentryid")).append("'");
                rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                try {
                    while (rs.next()) {
                        destBillIdSet.add(rs.getString("fdestBillId"));
                    }
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs);
                }
                costReturn2CostIssueMap.put(secEntryInfo2.getString("sourcebillentryid"), destBillIdSet);
                boolean canFindSourceRelation = false;
                int size = positive.size();
                for (int i = 0; i < size; ++i) {
                    mainEntryInfo2 = (WriteOffRecordInfo)positive.get(i);
                    if (mainEntryInfo2.getString("billid") == null || !destBillIdSet.contains(mainEntryInfo2.getString("billid"))) continue;
                    canFindSourceRelation = true;
                }
                billCanFindRelationMap.put(secEntryInfo2.getString("sourcebillentryid"), canFindSourceRelation);
            }
            for (WriteOffRecordInfo mainEntryInfo2 : positive) {
                if (Boolean.TRUE.equals(params.get((Object)"isDevolve")) && mainEntryInfo2.getInt("dosingType") != 4) {
                    billInfo.setBoolean("isDevolveWriteOff", Boolean.TRUE);
                }
                removeItem.clear();
                int size = negative.size();
                for (int i = 0; i < size; ++i) {
                    secEntryInfo2 = (WriteOffRecordInfo)negative.get(i);
                    if (params.isFlowWriteOff() && (!mainEntryInfo2.getBillID().equals(params.getFlowWfBillId()) && !secEntryInfo2.getBillID().equals(params.getFlowWfBillId()) || ((Boolean)params.get((Object)"isCrossPeriodNotWriteOff")).booleanValue() && mainEntryInfo2.getInt("year") * 100 + mainEntryInfo2.getInt("period") != secEntryInfo2.getInt("year") * 100 + secEntryInfo2.getInt("period")) || (Integer)params.get((Object)"dischargeType") != 0 && mainEntryInfo2.getInt("year") * 100 + mainEntryInfo2.getInt("period") != secEntryInfo2.getInt("year") * 100 + secEntryInfo2.getInt("period") && !this.isBeforeCurrentPeriod(params, mainEntryInfo2)) continue;
                    if ("DawAAAAPoA+wCNyn".equals(secEntryInfo2.getTransactionType()) || "DawAAAAPoASwCNyn".equals(secEntryInfo2.getTransactionType())) {
                        destBillIdSet = (Set)costReturn2CostIssueMap.get(secEntryInfo2.getString("sourcebillentryid"));
                        if (mainEntryInfo2.getString("billid") != null && !destBillIdSet.contains(mainEntryInfo2.getString("billid")) && ((Boolean)billCanFindRelationMap.get(secEntryInfo2.getString("sourcebillentryid"))).booleanValue()) continue;
                    }
                    if (this.addEntryInfo(ctx, entryColl, mainEntryInfo2, secEntryInfo2, removeItem, true, params)) break;
                }
                if (removeItem.size() <= 0) continue;
                negative.removeAll(removeItem);
                list.removeAll(removeItem);
            }
            if (entryColl.size() > 0) {
                return billInfo;
            }
        }
        return null;
    }

    private boolean isBeforeCurrentPeriod(WriteOffCommonParams params, WriteOffRecordInfo mainEntryInfo) {
        Object tempPeriod;
        boolean retValue = false;
        boolean isVoucher = false;
        PeriodInfo currentPeriod = null;
        Object value = mainEntryInfo.get("fivouchered");
        if (value != null) {
            isVoucher = Boolean.valueOf(value.toString());
        }
        if ((tempPeriod = params.get((Object)"currentPeriod")) != null) {
            currentPeriod = (PeriodInfo)tempPeriod;
        }
        if (currentPeriod == null) {
            return false;
        }
        int billPeriod = mainEntryInfo.getInt("year") * 100 + mainEntryInfo.getInt("period");
        int period = currentPeriod.getPeriodYear() * 100 + currentPeriod.getPeriodNumber();
        if (isVoucher || billPeriod < period) {
            retValue = true;
        }
        return retValue;
    }

    protected WriteOffGroupInfo buildTwoSideBillInfo(Context ctx, List mainList, List secList, MappingConditionEntryInfo conditionEntryInfo, WriteOffCommonParams params, Map costAdjustMap) throws BOSException, EASBizException {
        boolean isEntryFullWriteOff = false;
        WriteOffRecordInfo entryInfo2 = null;
        Iterator it = mainList.iterator();
        while (it.hasNext()) {
            if (!((WriteOffRecordInfo)it.next()).getBoolean("entry.isFullWriteOff")) continue;
            isEntryFullWriteOff = true;
            break;
        }
        if (!isEntryFullWriteOff) {
            it = secList.iterator();
            while (it.hasNext()) {
                if (!((WriteOffRecordInfo)it.next()).getBoolean("entry.isFullWriteOff")) continue;
                isEntryFullWriteOff = true;
                break;
            }
        }
        params.put((Object)"isEntryFullWriteOff", (Object)isEntryFullWriteOff);
        WriteOffGroupInfo billInfo = new WriteOffGroupInfo();
        IObjectCollection entryColl = (IObjectCollection)billInfo.get("entry");
        if (conditionEntryInfo.isIsMappingQtyAmt() && !isEntryFullWriteOff) {
            WriteOffRecordInfo mainEntryInfo = null;
            WriteOffRecordInfo secEntryInfo = null;
            ArrayList removeItem = new ArrayList();
            Iterator it2 = mainList.iterator();
            while (it2.hasNext()) {
                mainEntryInfo = (WriteOffRecordInfo)it2.next();
                removeItem.clear();
                int size = secList.size();
                for (int i = 0; i < size; ++i) {
                    secEntryInfo = (WriteOffRecordInfo)secList.get(i);
                    if (params.isFlowWriteOff() && !mainEntryInfo.getBillID().equals(params.getFlowWfBillId()) && !secEntryInfo.getBillID().equals(params.getFlowWfBillId()) || !this.addEntryInfo(ctx, entryColl, mainEntryInfo, secEntryInfo, removeItem, false, params)) continue;
                    it2.remove();
                    break;
                }
                if (removeItem.size() <= 0) continue;
                secList.removeAll(removeItem);
            }
        } else {
            int mainCount = 0;
            int secCount = 0;
            for (WriteOffRecordInfo entryInfo2 : mainList) {
                if (params.isFlowWriteOff() && params.isFromMain() && !entryInfo2.getBillID().equals(params.getFlowWfBillId())) continue;
                entryColl.addObject((IObjectValue)entryInfo2);
                ++mainCount;
            }
            for (WriteOffRecordInfo entryInfo2 : secList) {
                if (params.isFlowWriteOff() && !params.isFromMain() && !entryInfo2.getBillID().equals(params.getFlowWfBillId())) continue;
                entryColl.addObject((IObjectValue)entryInfo2);
                ++secCount;
            }
            if (mainCount == 0 || secCount == 0) {
                entryColl.clear();
            }
        }
        if (entryColl.size() > 0) {
            return billInfo;
        }
        return null;
    }

    protected boolean addEntryInfo(Context ctx, IObjectCollection entryColl, WriteOffRecordInfo mainEntryInfo, WriteOffRecordInfo secEntryInfo, List removeItem, boolean isSameSide, WriteOffCommonParams params) throws EASBizException, BOSException {
        return false;
    }

    public IObjectValue buildWriteOffEntryInfo(Context ctx, IRowSet rs, WriteOffCommonInfo info, WriteOffCommonParams params) throws SQLException {
        return null;
    }

    public SelectorItemCollection getSelector(String bosType, WriteOffCommonParams params) {
        return null;
    }

    public void writeLog(Context ctx, Set imBillNumber, Set invoiceBillNumber, String strategy) {
        Iterator it2;
        StringBuffer msg = new StringBuffer();
        String number = null;
        ArrayList<String> msgList = new ArrayList<String>();
        String[] title = new String[3];
        String msgToContinueTitle = EASResource.getString((String)RES, (String)"msgToContinue");
        int limitLength = 1024;
        if ("saleWriteOff".equals(strategy)) {
            title[0] = EASResource.getString((String)RES, (String)"saleWriteOff");
            title[1] = EASResource.getString((String)RES, (String)"saleIssueBill");
            title[2] = EASResource.getString((String)RES, (String)"otherArBill");
        } else if ("inComeConfirmWriteOff".equals(strategy)) {
            title[0] = EASResource.getString((String)RES, (String)"incomeConfirmWriteOff");
            title[1] = EASResource.getString((String)RES, (String)"saleIssueBill");
            title[2] = EASResource.getString((String)RES, (String)"incomeConfirmBill");
        } else {
            title[0] = EASResource.getString((String)RES, (String)"purWriteOff");
            title[1] = "purWriteOff".equals(strategy) ? EASResource.getString((String)RES, (String)"purInWarehsBill") : EASResource.getString((String)RES, (String)"devPurInWarehsBill");
            title[2] = EASResource.getString((String)RES, (String)"otherApBill");
        }
        Iterator it = imBillNumber.iterator();
        if (it.hasNext()) {
            msg.append(title[1]).append(":");
            while (it.hasNext()) {
                number = it.next().toString();
                if (msg.length() + number.length() > limitLength) {
                    msg.append(msgToContinueTitle);
                    msgList.add(msg.toString());
                    msg.setLength(0);
                    msg.append(title[1]).append(":");
                }
                msg.append(number).append(", ");
            }
        }
        if ((it2 = invoiceBillNumber.iterator()).hasNext()) {
            msg.append(title[2]).append(":");
            while (it2.hasNext()) {
                number = it2.next().toString();
                if (msg.length() + number.length() > limitLength) {
                    msg.append(msgToContinueTitle);
                    msgList.add(msg.toString());
                    msg.setLength(0);
                    msg.append(title[2]).append(":");
                }
                msg.append(number).append(", ");
            }
        }
        if (msg.length() > 0) {
            msgList.add(msg.toString());
        }
        IObjectPK pklog = null;
        for (int i = 0; i < msgList.size(); ++i) {
            pklog = LogUtil.beginLogWithDescription((Context)ctx, (String)"1", (BOSObjectType)new BOSObjectType("13AF665D"), null, (String)((String)msgList.get(i)), (String)title[0]);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
        }
    }
}

