/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.bizimpl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.WriteOffGroupCollection;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.WriteOffRecordCollection;
import com.kingdee.eas.scm.cal.WriteOffRecordInfo;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class WriteOffFilterHelper {
    private String selectInitBillSql;
    public static final String PUR_WRITE_OFF_COLL = "purWriteOffColl";
    public static final String SALE_WRITE_OFF_COLL = "saleWriteOffColl";

    public WriteOffFilterHelper() {
        StringBuffer tmpStrBuffer = new StringBuffer();
        tmpStrBuffer.append(" select distinct purBill.FId, purBill.FFIVouchered as isVouchered from T_IM_PurInWarehsBill purBill ");
        tmpStrBuffer.append(" inner join T_CL_WriteOffRecord record on purBill.FID = record.FBillId ");
        tmpStrBuffer.append(" inner join T_CL_WriteOffGroup writeOffGroup on writeOffGroup.FID = record.FParentId ");
        tmpStrBuffer.append(" where writeOffGroup.FId = ? and record.FBillTypeNumber = '103' and purBill.FIsInitBill = 1 ");
        this.selectInitBillSql = tmpStrBuffer.toString();
    }

    public int isCreateVoucher(Context ctx, int count, String idStr, boolean isAllPurBill) throws BOSException, EASBizException {
        String selectVoucherSql = "select count(FId) as count from T_IM_PurInWarehsBill where FId in ({0}) and (FFiVouchered = 1 OR FIsInitBill = 1)";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)MessageFormat.format(selectVoucherSql, idStr));
        try {
            rs.next();
            int num = rs.getInt("count");
            if (num == count) {
                return 0;
            }
            if (num == 0) {
                return 1;
            }
            return -1;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public int isInitBill(Context ctx, WriteOffGroupInfo writeOffGroupInfo) throws BOSException {
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)this.selectInitBillSql, (Object[])new Object[]{writeOffGroupInfo.getId().toString()});
        try {
            if (rs.next()) {
                if (rs.getInt("isVouchered") == 0) {
                    return 1;
                }
                return 2;
            }
            return 0;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public boolean isEqualWriteOff(WriteOffGroupInfo writeOffGroupInfo) {
        BigDecimal positive = BigDecimal.ZERO;
        BigDecimal negative = BigDecimal.ZERO;
        for (int i = 0; i < writeOffGroupInfo.getEntry().size(); ++i) {
            WriteOffRecordInfo recordInfo = writeOffGroupInfo.getEntry().get(i);
            if (recordInfo.getCurrWrittenOffAmount().signum() == 1) {
                positive = positive.add(recordInfo.getCurrWrittenOffAmount());
                continue;
            }
            negative = negative.add(recordInfo.getCurrWrittenOffAmount());
        }
        return positive.compareTo(negative.abs()) == 0;
    }

    public static Map<String, WriteOffGroupCollection> getGroupingCollAndType(WriteOffGroupCollection coll) {
        if (CollectionUtil.isEmpty((AbstractObjectCollection)coll)) {
            return new HashMap<String, WriteOffGroupCollection>();
        }
        WriteOffGroupCollection purWriteColl = new WriteOffGroupCollection();
        WriteOffGroupCollection saleWriteColl = new WriteOffGroupCollection();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            WriteOffGroupInfo groupInfo = coll.get(i);
            WriteOffRecordCollection recordCollection = groupInfo.getEntry();
            if (recordCollection.size() <= 0) continue;
            WriteOffRecordInfo recordInfo = recordCollection.get(0);
            if (!"103".equals(recordInfo.getBillTypeNumber()) && !"230".equals(recordInfo.getBillTypeNumber())) {
                saleWriteColl.add(groupInfo);
                continue;
            }
            purWriteColl.add(groupInfo);
        }
        HashMap<String, WriteOffGroupCollection> result = new HashMap<String, WriteOffGroupCollection>();
        result.put(PUR_WRITE_OFF_COLL, purWriteColl);
        result.put(SALE_WRITE_OFF_COLL, saleWriteColl);
        return result;
    }
}

