/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculate;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffHashMap;
import com.kingdee.eas.scm.cal.app.newutil.InventoryBillHelper;
import com.kingdee.eas.scm.cal.newutil.CalculateUtil;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.common.RedBlueEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.security.util.SCMSqlUtil;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class AbstractInventoryCalculate
extends AbstractCalculate {
    protected RedBlueEnum billDirection = RedBlueEnum.BLUE;
    public boolean returnFromCoreBill = false;

    @Override
    protected void init(Context ctx, CoreBillBaseInfo scminfo) throws BOSException, EASBizException {
        InvBillBaseInfo bill;
        super.init(ctx, scminfo);
        if (scminfo instanceof InvBillBaseInfo && (bill = (InvBillBaseInfo)scminfo).isIsReversed() && !StringUtil.isEmpty((String)bill.getSourceBillId())) {
            String str = InventoryBillHelper.updateFullReverseBill(ctx, bill, bill.getId(), bill.getSourceBillId());
            DBUtil.execute((Context)ctx, (String)str);
        }
    }

    @Override
    protected CompanyOrgUnitInfo takeFinanceOrg(Context ctx, CoreBillBaseInfo scminfo) throws EASBizException, BOSException {
        return CalculateUtil.takeFinanceOrgFromEntry((SCMBillBaseInfo)scminfo);
    }

    protected OrgUnitInfo takeMasterBizOrg(Context ctx, CoreBillBaseInfo scminfo) throws EASBizException, BOSException {
        return ((InvBillBaseInfo)scminfo).getStorageOrgUnit();
    }

    protected void takeArApBills(Context ctx, CalculateWrittenOffBill bill, String tableName, CalculateWrittenOffHashMap writeOffBillMap) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.takeSQLAccountReceivableOrPayable(ctx, tableName));
        sql.append(this.getArApBillWhereSQL(ctx, bill.getId()));
        sql.append(this.getOrderBySQL());
        this.buildBillMap(ctx, tableName, sql, writeOffBillMap, this.getIDList(bill, false), false);
    }

    protected String getArApBillWhereSQL(Context ctx, String billID) throws BOSException {
        return "";
    }

    protected String getOrderBySQL() {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(" Order by Bill.FBizDate,Bill.FNumber,Entry.FSeq");
        return sSQL.toString();
    }

    protected String getSourceBillEntryId(Context ctx, CalculateWrittenOffBill bill) throws BOSException {
        StringBuffer ids = new StringBuffer();
        ArrayList entry = bill.getEntry();
        CalculateWrittenOffEntry calEntry = null;
        if (entry.size() > 500) {
            String[] idArr = new String[entry.size()];
            for (int i = 0; i < entry.size(); ++i) {
                calEntry = (CalculateWrittenOffEntry)entry.get(i);
                idArr[i] = calEntry.getSourceBillEntryId();
            }
            String tempTableName = SCMSqlUtil.convertIdArrToTempTab((Context)ctx, (String[])idArr);
            ids.append(tempTableName).append(" ");
        } else {
            for (int i = 0; i < entry.size(); ++i) {
                calEntry = (CalculateWrittenOffEntry)entry.get(i);
                ids.append("'").append(calEntry.getSourceBillEntryId()).append("',");
            }
        }
        return ids.substring(0, ids.length() - 1);
    }

    protected void takeSQLSourceBill(Context ctx, String tableName, StringBuffer selectSQL, CalculateWrittenOffHashMap writeOffBillMap, CalculateWrittenOffBill bill) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer(selectSQL);
        String tempName = null;
        if (!this.returnFromCoreBill) {
            String ids = null;
            ids = this.getSourceBillEntryId(ctx, bill);
            if (bill.getEntry().size() > 500) {
                tempName = ids;
                ids = "select fid from " + tempName;
            }
            sql.append(" where ENTRY.FID in (").append(ids).append(") ");
        } else {
            sql.append(" where Entry.FCOREBILLID = '").append(bill.getCoreBillId()).append("' ");
        }
        sql.append(this.getSubBlueBillWhereSQL(ctx, bill));
        sql.append(" order by Entry.FBizDate,bill.FAUDITTIME,Entry.FSeq");
        this.buildBillMap(ctx, tableName, sql, writeOffBillMap, this.getIDList(bill, true), true);
        DBUtil.releaseTempTable(ctx, tempName);
    }

    @Override
    protected String getExtendInvBillSelector() {
        StringBuffer selector = new StringBuffer();
        selector.append(" ,NULL AS ").append("fsupplier");
        selector.append(" ,NULL AS ").append("fcustomer");
        selector.append(" ,'' AS ").append("fcoreBillNumber");
        selector.append(" ,'' AS ").append("fcoreBillId");
        selector.append(" ,0 AS ").append("fcoreBillEntrySeq");
        selector.append(" ,'' AS ").append("fcoreBillEntryId");
        selector.append(" ,0 AS ").append("funWriteOffAmt");
        selector.append(" ,0 AS ").append("fwrittenOffAmt");
        selector.append(" ,0 AS ").append("funWriteOffQty");
        selector.append(" ,0 AS ").append("fwrittenOffQty");
        return selector.toString();
    }

    protected void takeBlueBill(Context ctx, CalculateWrittenOffBill bill, String tableName, CalculateWrittenOffHashMap writeOffBillMap) throws EASBizException, BOSException {
        this.setBillDirection(bill);
        StringBuffer sql = new StringBuffer();
        sql.append(this.takeSQLBill(ctx, tableName));
        sql.append(this.getBlueBillWhereSQL(ctx, bill));
        sql.append(this.getOrderBySQL());
        this.buildBillMap(ctx, tableName, sql, writeOffBillMap, this.getIDList(bill, true), true);
    }

    protected String getBlueBillWhereSQL(Context ctx, CalculateWrittenOffBill bill) throws BOSException {
        return "";
    }

    protected String getSubBlueBillWhereSQL(Context ctx, CalculateWrittenOffBill bill) throws BOSException {
        return "";
    }

    @Override
    protected String getKeyValue(List idList, ResultSet rs, boolean isTakeInvSrcBill) throws SQLException {
        String destBillIID = rs.getString("fid");
        String sourceBillID = rs.getString("fsourceBillId");
        String coreBillId = rs.getString("fcoreBillId");
        String key = null;
        key = isTakeInvSrcBill ? (idList.contains(destBillIID) ? "SRC_" + destBillIID : "CORE_" + coreBillId) : (idList.contains(sourceBillID) ? "SRC_" + sourceBillID : "CORE_" + coreBillId);
        return key;
    }

    protected boolean writeOffBill(Context ctx, CalculateWrittenOffBill arBill, CalculateWrittenOffBill invBill, CalculateWrittenOffEntry invEntry, WriteOffGroupInfo writeoffgroupinfo, BigDecimal[] writeOffQtyAndAmount, Vector vDiffAmount) throws EASBizException, BOSException {
        boolean isFullWriteOff = false;
        ArrayList entrys = arBill.getEntry();
        if (entrys == null || entrys.isEmpty()) {
            return isFullWriteOff;
        }
        List entryList = this.getEntryBySrcEntryId(arBill, invBill, invEntry);
        if (entryList == null || entryList.size() == 0) {
            entryList = this.getEntryByCoreEntryId(arBill, invEntry.getOrderBillEntryId());
        }
        CalculateWrittenOffEntry arEntry = null;
        for (int i = 0; i < entryList.size(); ++i) {
            arEntry = (CalculateWrittenOffEntry)entryList.get(i);
            isFullWriteOff = this.writeOffEntry(ctx, invEntry, arEntry, arBill, writeoffgroupinfo, invBill, writeOffQtyAndAmount, vDiffAmount);
        }
        return isFullWriteOff;
    }

    protected boolean writeOffEntry(Context ctx, CalculateWrittenOffEntry invEntry, CalculateWrittenOffEntry arEntry, CalculateWrittenOffBill arBill, WriteOffGroupInfo writeoffgroupinfo, CalculateWrittenOffBill invBill, BigDecimal[] writeOffQtyAndAmount, Vector vDiffAmount) throws EASBizException, BOSException {
        return false;
    }

    protected void setBillDirection(CalculateWrittenOffBill writtenOffBill) {
        if (writtenOffBill != null && writtenOffBill.getEntry() != null && writtenOffBill.getEntry().size() > 0) {
            CalculateWrittenOffEntry entry = (CalculateWrittenOffEntry)writtenOffBill.getEntry().get(0);
            this.billDirection = entry != null && entry.getBaseUnitQty() != null && entry.getBaseUnitQty().signum() == -1 ? RedBlueEnum.RED : RedBlueEnum.BLUE;
        }
    }
}

