/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.framework.app.thread.QueryDataSyncLock;
import com.kingdee.eas.scm.framework.app.thread.QueryDataTask;
import com.kingdee.eas.scm.framework.app.thread.ThreadPool;
import java.util.Map;

public class CalculateDataSourceProvider {
    protected static final String OUT_EFFECT = "OUT_EFFECT";
    protected static final String IN_EFFECT = "IN_EFFECT";
    private static final long serialVersionUID = 2309587345891L;

    protected static String getCreateTempTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table T_IM_Inventory_temp (").append("FID VARCHAR(44),").append("FCompanyOrgUnitID VARCHAR(44),").append("FStorageOrgUnitID VARCHAR(44),").append("FWarehouseID VARCHAR(44),").append("FLocationID VARCHAR(44),").append("FStoreTypeID VARCHAR(44),").append("FStoreStatusID VARCHAR(44),").append("FLot NVARCHAR(80),").append("FSupplierID VARCHAR(44),").append("FCustomerID VARCHAR(44),").append("FMaterialID VARCHAR(44),").append("FAssistQty NUMERIC(28,16),").append("FBaseQty NUMERIC(28,16) NOT NULL DEFAULT 0,").append("FAssistPropertyID VARCHAR(44),").append("FStandardCost NUMERIC(19,4) NOT NULL DEFAULT 0,").append("FActualCost  NUMERIC(19,4) NOT NULL DEFAULT 0,").append("FAccountType INT NOT NULL DEFAULT 0,").append("FRIFlag INT NOT NULL DEFAULT 0,").append("FYear INT NOT NULL DEFAULT 1900,").append("FPeriod INT NOT NULL DEFAULT 0,").append("FIsCalculate INT NOT NULL DEFAULT 0,").append("FBizTypeId  VARCHAR(44),").append("FBillTypeId  VARCHAR(44) ,").append("FPeriodAdjustDiff NUMERIC(28,16) NOT NULL DEFAULT 0").append(");");
        return sql.toString();
    }

    private static String getArBillSql(String sqlIn, String msWhere) {
        String where = msWhere.replaceAll("b.FCompanyOrgUnitId", "a.FCompanyID");
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("select B.FID,a.FCompanyID,c.fstorageorgunitid,b.fmaterialid,b.fassistpropertyid,");
        sqlSelect.append("'").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("',");
        sqlSelect.append("'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("',null,b.FServiceCustomerID,null,null,null,");
        sqlSelect.append("(CASE  ISNULL(MATERIALINVENTORY.FIsProjectNumber,0) WHEN 0 THEN null ELSE B.FProjectID END) AS FProjectID, ");
        sqlSelect.append("(CASE ISNULL(MATERIALINVENTORY.FIsTrackingNumber,0) WHEN 0 THEN null ELSE B.FTrackNumberzcID END) AS FTrackNumberID, ");
        sqlSelect.append("sum(b.fbaseqty),sum(b.FAssistQty),0,0,");
        sqlSelect.append("a.FYear,a.FPeriod,1 as FIsCalculate,a.FBizTypeId,");
        sqlSelect.append("'").append("510b6503-0105-1000-e000-0117c0a812fd463ED552").append("',mc.FAccountType,-1 ");
        sqlSelect.append("FROM T_AR_OtherBill A ");
        sqlSelect.append("INNER JOIN T_AR_OTHERBILLENTRY B on A.FID = B.FParentID ");
        sqlSelect.append("INNER JOIN T_BD_MaterialCompanyInfo mc on mc.FCompanyId = A.FCompanyId and mc.FMaterialId = B.FMaterialId ");
        sqlSelect.append("INNER JOIN T_MR_SourceBillEntry C on C.FID = B.FSOURCEBILLENTRYID ");
        sqlSelect.append(" LEFT JOIN T_BD_MaterialInventory MATERIALINVENTORY ");
        sqlSelect.append(" ON B.FMaterialID = MATERIALINVENTORY.FMaterialID AND B.FRecSendOrgUnitID = MATERIALINVENTORY.FOrgUnit ");
        sqlSelect.append(" INNER JOIN T_BD_Material as MATERIAL on B.FMaterialID = MATERIAL.FID ");
        sqlSelect.append(where).append("AND (A.FBizTypeId = '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ");
        sqlSelect.append("OR A.FBizTypeId = '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("') ");
        sqlSelect.append("AND isnull(A.FIsInitializeBill,0) = 0 AND A.FBillStatus = 3 ");
        sqlSelect.append("GROUP BY B.FID,a.FCompanyID,c.fstorageorgunitid,b.FServiceCustomerID,b.fmaterialid,");
        sqlSelect.append("b.fassistpropertyid,a.fbiztypeid,a.fyear,a.fperiod,mc.FAccountType,");
        sqlSelect.append("(CASE ISNULL(MATERIALINVENTORY.FIsProjectNumber,0) WHEN 0 THEN null ELSE B.FProjectID END),");
        sqlSelect.append("(CASE ISNULL(MATERIALINVENTORY.FIsTrackingNumber,0) WHEN 0 THEN null ELSE B.FTrackNumberzcID END)");
        StringBuffer result = new StringBuffer(sqlIn);
        result.append(sqlSelect.toString().replaceAll("T_MR_SourceBillEntry", "T_IM_SaleIssueEntry"));
        return result.toString();
    }

    private static String getDecomposeBillSql(String sqlIn, String msWhere) {
        String[] entryNames = new String[]{"T_IM_DecomposeEntry", "T_IM_DecomposeEntryDetail"};
        String[] riFlag = new String[]{"-1", "1"};
        StringBuffer sql = new StringBuffer(sqlIn);
        sql.append("(");
        StringBuffer sqlSelect = new StringBuffer();
        for (int i = 0; i < 2; ++i) {
            sqlSelect.append("select newbosid('BA8AD747'),b.fcompanyorgunitid,b.fstorageorgunitid,b.fmaterialid,b.fassistpropertyid,b.fstoretypeid,");
            sqlSelect.append("isnull(b.fstorestatusid,'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'),");
            sqlSelect.append("b.fsupplierid,b.fcustomerid,b.fwarehouseid,b.flocationid,b.flot,");
            sqlSelect.append("(CASE ISNULL(MATERIALINVENTORY.FIsProjectNumber,0) WHEN 0 THEN null ELSE b.FProjectID END) AS FProjectID, ");
            sqlSelect.append("(CASE ISNULL(MATERIALINVENTORY.FIsTrackingNumber,0) WHEN 0 THEN null ELSE b.FTrackNumberID END) AS FTrackNumberID, ");
            sqlSelect.append("sum(b.fbaseqty),sum(b.fassistqty),0,0,a.FYear,a.FPeriod,0, ");
            sqlSelect.append("a.FBizTypeId,a.FBillTypeId,mc.FAccountType,").append(riFlag[i]).append(" ");
            sqlSelect.append("FROM ").append(entryNames[i]).append(" b ");
            if ("T_IM_DecomposeEntryDetail".equalsIgnoreCase(entryNames[i])) {
                sqlSelect.append("inner join T_IM_DecomposeEntry c on b.FDecompEntryID = c.fid ");
                sqlSelect.append("inner join T_IM_DecomposeBill a on a.fid = c.fparentid ");
            } else {
                sqlSelect.append("inner join T_IM_DecomposeBill a on a.fid = b.fparentid ");
            }
            sqlSelect.append(" inner join T_SCM_TransactionType tt on tt.FId = a.FTransactionTypeId ");
            sqlSelect.append(" inner join t_bd_material as MATERIAL on b.fmaterialid = MATERIAL.FID ");
            sqlSelect.append(" inner join T_BD_MaterialCompanyInfo mc on mc.FCompanyId = b.FCompanyOrgUnitId and mc.FMaterialId = B.FMaterialId ");
            sqlSelect.append(" LEFT JOIN T_BD_MaterialInventory MATERIALINVENTORY ");
            sqlSelect.append(" ON b.FMaterialID = MATERIALINVENTORY.FMaterialID ");
            sqlSelect.append(" AND a.FSTORAGEORGUNITID = MATERIALINVENTORY.FOrgUnit ");
            sqlSelect.append(msWhere).append(" AND a.fbasestatus = 4 AND isnull(a.fisinitbill,0) = 0 ");
            sqlSelect.append("GROUP BY b.fcompanyorgunitid,b.fstorageorgunitid,b.fwarehouseid, b.flocationid,b.fstoretypeid,");
            sqlSelect.append("b.fsupplierid,b.fcustomerid,b.fstorestatusid,b.flot,a.FYear,a.FPeriod,mc.FAccountType,");
            sqlSelect.append("b.fmaterialid,b.fassistpropertyid,a.FBillTypeId,a.FBizTypeId,");
            sqlSelect.append("(CASE ISNULL(MATERIALINVENTORY.FIsProjectNumber,0) WHEN 0 THEN null ELSE b.FProjectID END), ");
            sqlSelect.append("(CASE ISNULL(MATERIALINVENTORY.FIsTrackingNumber,0) WHEN 0 THEN null ELSE b.FTrackNumberID END)");
            if (i >= 1) continue;
            sqlSelect.append(" union all ");
        }
        sql.append(sqlSelect).append(")");
        return sql.toString();
    }

    public static String[] getInsertDataSql(Context ctx, String tmpTableName, Map paramMap) throws BOSException, EASBizException {
        String[][] tableName = new String[][]{{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry"}, {"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"}, {"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}, {"T_IM_PurReceivalBill", "T_IM_PurReceivalEntry"}, {"T_IM_MoveLocationBill", "T_IM_MoveLocationBillEntry"}, {"T_IM_InvStateAdjustBill", "T_IM_InvStateAdjustBillEntry"}};
        SysTempTableHelper helper = (SysTempTableHelper)paramMap.get("sysTempTableHelper");
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String isUpdateByARBILL = ipc.getParamValue((IObjectPK)new ObjectUuidPK((String)paramMap.get("CompanyOrgUnitId")), "CONSIGNSALES");
        boolean isArUpdateInventory = isUpdateByARBILL == null ? false : isUpdateByARBILL.trim().equals("true");
        StringBuffer msWhere = new StringBuffer();
        msWhere.append(" where b.FCompanyOrgUnitId = '").append(paramMap.get("CompanyOrgUnitId")).append("' and ");
        msWhere.append(" a.FYear = ").append(paramMap.get("Year")).append(" and a.FPeriod = ").append(paramMap.get("Period"));
        msWhere.append(" ");
        String billTempTable = helper.createTempTable(ctx, CalculateDataSourceProvider.getMiddleTempTableFields());
        CalculateDataSourceProvider.insertBillsDataToTempTable(helper, billTempTable, tableName, msWhere.toString(), isArUpdateInventory);
        StringBuffer sqlIn = new StringBuffer();
        sqlIn.append("insert into ").append(tmpTableName);
        sqlIn.append("(FId,FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FAssistPropertyID,");
        sqlIn.append("FStoreTypeID,FStoreStatusID,FSupplierID,FCustomerID,FWarehouseID,");
        sqlIn.append("FLocationID,FLot,FProjectID,FTrackNumberID,FBaseQty,FAssistQty,FStandardCost,FActualCost,");
        sqlIn.append("FYear,FPeriod,FIsCalculate,FBizTypeId,FBillTypeId,FAccountType,FRIFlag) ");
        String whereSql = CalculateDataSourceProvider.getWhereSQL(paramMap, "a", "a").toString();
        StringBuffer sql = new StringBuffer();
        sql.append(sqlIn.toString()).append(CalculateDataSourceProvider.getBillSql(billTempTable, whereSql));
        helper.execute(sql.toString());
        helper.releaseTempTable(billTempTable);
        String[] sqls = isArUpdateInventory ? new String[2] : new String[]{CalculateDataSourceProvider.getDecomposeBillSql(sqlIn.toString(), msWhere.toString())};
        if (isArUpdateInventory) {
            sqls[1] = CalculateDataSourceProvider.getArBillSql(sqlIn.toString(), msWhere.toString());
        }
        return sqls;
    }

    private static StringBuffer getWhereSQL(Map paramMap, String headTable, String entryTable) {
        StringBuffer msWhere = new StringBuffer();
        msWhere.append(" where " + entryTable + ".FCompanyOrgUnitId = '").append(paramMap.get("CompanyOrgUnitId")).append("' ");
        msWhere.append("   and " + headTable + ".FYear = ").append(paramMap.get("Year"));
        msWhere.append("   and " + headTable + ".FPeriod = ").append(paramMap.get("Period"));
        if (paramMap.get("isPreWAREHOUSEIDS") != null) {
            msWhere.append(" and " + entryTable + ".FWarehsID IN " + (String)paramMap.get("isPreWAREHOUSEIDS"));
        }
        if (paramMap.get("isPreSTORAGEORGUNITIDS") != null) {
            msWhere.append(" and " + entryTable + ".FStorageOrgUnitID IN " + (String)paramMap.get("isPreSTORAGEORGUNITIDS"));
        }
        if (paramMap.get("isPreCloseAccount") != null && ((Boolean)paramMap.get("isPreCloseAccount")).booleanValue()) {
            msWhere.append(" and MC.FACCOUNTTYPE<>1 ");
        }
        if (paramMap.get("isPreFCALCULATETYPE") != null) {
            msWhere.append(" and MC.FCALCULATETYPE = " + (Integer)paramMap.get("isPreFCALCULATETYPE"));
        }
        if (paramMap.get("isPreMATERIAL_FROM") != null) {
            msWhere.append(" and MATERIAL.FNumber >= '" + (String)paramMap.get("isPreMATERIAL_FROM")).append("'");
        }
        if (paramMap.get("isPreMATERIAL_TO") != null) {
            msWhere.append(" and MATERIAL.FNumber <= '" + (String)paramMap.get("isPreMATERIAL_TO")).append("'");
        }
        return msWhere;
    }

    protected static String getBillSql2(String billHead, String billEntry, String msWhere, String effectString, boolean isArUpdateInventory) {
        String groupIsCalculate;
        String fieldIsCalculate;
        String fieldStoreStatusId;
        String fieldStoreTypeId;
        String fieldLocationId;
        String fieldWarehouseId;
        String fieldSupplierId;
        String fieldCustomerId;
        StringBuffer sql = new StringBuffer();
        boolean isInEffect = IN_EFFECT.endsWith(effectString);
        boolean isOutEffect = OUT_EFFECT.endsWith(effectString);
        StringBuffer existingQtyWhere = new StringBuffer();
        int customerValue = 3;
        int toCustomerValue = 4;
        int supplierValue = 2;
        int toSupplierValue = 5;
        int generalValue = 1;
        if ("T_IM_SaleIssueBill".equals(billHead)) {
            fieldCustomerId = "a.FCustomerId";
            fieldSupplierId = "b.FSupplierId";
        } else if ("T_IM_PurInWarehsBill".equals(billHead)) {
            fieldCustomerId = "b.FCustomerId";
            fieldSupplierId = "a.FSupplierId";
        } else if ("T_IM_PurReceivalBill".equals(billHead)) {
            fieldCustomerId = "a.FCustomerId";
            fieldSupplierId = "a.FSupplierId";
        } else {
            fieldCustomerId = "b.FCustomerId";
            fieldSupplierId = "b.FSupplierId";
        }
        if ("T_IM_MoveLocationBill".equals(billHead) && isInEffect) {
            fieldWarehouseId = "b.FWarehouseId";
            fieldLocationId = "b.FReceiptLocationID";
        } else if ("T_IM_PurInWarehsBill".equals(billHead) && isOutEffect) {
            fieldWarehouseId = "b.FOutWarehouseId";
            fieldLocationId = "b.FOutLocationId";
        } else {
            fieldWarehouseId = "b.FWarehouseId";
            fieldLocationId = "b.FLocationId";
        }
        if (isInEffect) {
            if ("T_IM_MoveLocationBill".equals(billHead)) {
                fieldStoreTypeId = "b.FStoreTypeId";
                fieldStoreStatusId = "b.FStoreStatusId";
            } else if ("T_IM_InvStateAdjustBill".equals(billHead)) {
                fieldStoreTypeId = "b.FStoreTypeId";
                fieldStoreStatusId = "b.FDestStoreStatusID";
            } else {
                fieldStoreTypeId = "e.FStoreTypeId";
                fieldStoreStatusId = "e.FStoreStateId";
            }
        } else if ("T_IM_MoveLocationBill".equals(billHead)) {
            fieldStoreTypeId = "b.FStoreTypeId";
            fieldStoreStatusId = "b.FStoreStatusId";
        } else if ("T_IM_InvStateAdjustBill".equals(billHead)) {
            fieldStoreTypeId = "b.FStoreTypeId";
            fieldStoreStatusId = "b.FSrcStoreStatusID";
        } else {
            fieldStoreTypeId = "e.FStoreTypePreId";
            fieldStoreStatusId = "e.FStoreStatePreId";
        }
        if ("T_IM_MoveLocationBill".equalsIgnoreCase(billHead) || "T_IM_PurReceivalBill".equalsIgnoreCase(billHead) || "T_IM_InvStateAdjustBill".equalsIgnoreCase(billHead)) {
            fieldIsCalculate = "0";
            groupIsCalculate = "";
        } else {
            fieldIsCalculate = "c.FIsCalculate";
            groupIsCalculate = "c.FIsCalculate,";
        }
        String storeFlagValue = "d.FStoreFlag";
        String fieldEffectQty = isInEffect ? "FExistingQty" : "FExistingQtyPre";
        existingQtyWhere.append("(e.").append(fieldEffectQty).append(" <> 0)");
        sql.append("select b.FId,b.fcompanyorgunitid,b.fstorageorgunitid,b.fmaterialid,b.fassistpropertyid,");
        sql.append(fieldStoreTypeId).append(",");
        sql.append(" isnull(").append(fieldStoreStatusId).append(",'").append("181875d5-0105-1000-e000-012ec0a812fd62A73FA5").append("'), ");
        sql.append("case d.FStoreFlag when ").append(toSupplierValue).append(" then ");
        sql.append(fieldSupplierId);
        sql.append(" when ").append(supplierValue).append(" then ");
        sql.append(fieldSupplierId);
        sql.append(" else null end,");
        sql.append("case d.FStoreFlag when ").append(toCustomerValue).append(" then ");
        sql.append(fieldCustomerId);
        sql.append(" when ").append(customerValue).append(" then ");
        sql.append(fieldCustomerId);
        sql.append(" else null end,");
        if (isArUpdateInventory) {
            sql.append("case ").append(fieldStoreTypeId).append(" ");
            sql.append("when '").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("' then null ");
            sql.append("else ").append(fieldWarehouseId).append(" end, ");
            sql.append("case ").append(fieldStoreTypeId).append(" ");
            sql.append("when '").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("' then null ");
            sql.append("else ").append(fieldLocationId).append(" end, ");
            sql.append("case ").append(fieldStoreTypeId).append(" ");
            sql.append("when '").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("' then null ");
            sql.append("else b.FLot end, ");
        } else {
            sql.append(fieldWarehouseId).append(",").append(fieldLocationId).append(",FLot, ");
        }
        sql.append("(case isnull(materialinventory.fisprojectnumber,0) when 0 then null else b.fprojectid end) as fprojectid, ");
        sql.append("(case isnull(materialinventory.fistrackingnumber,0) when 0 then null else b.ftracknumberid end) as ftracknumberid, ");
        sql.append("sum(b.fbaseqty) as fbaseqty,sum(b.fassistqty) as fassistqty, ");
        sql.append("sum(case ").append(storeFlagValue).append(" when ").append(toSupplierValue).append(" then b.FStandardCost ");
        sql.append(" when ").append(toCustomerValue).append(" then b.FStandardCost ");
        sql.append(" when ").append(generalValue).append(" then b.FStandardCost ");
        sql.append(" else 0 end),");
        sql.append("sum(case  ").append(storeFlagValue).append(" when ").append(toSupplierValue).append(" then b.FActualCost ");
        sql.append(" when ").append(toCustomerValue).append(" then b.FActualCost ");
        sql.append(" when ").append(generalValue).append(" then b.FActualCost ");
        sql.append(" else 0 end),");
        sql.append("a.FYear,a.FPeriod,").append(fieldIsCalculate);
        sql.append(",a.FBizTypeId,a.FBillTypeId,");
        sql.append(IN_EFFECT.endsWith(effectString) ? "1 " : "-1 ");
        sql.append("from ").append(billHead).append(" a ");
        sql.append("inner join ").append(billEntry).append(" b on a.fid = b.fparentid ");
        if (!"T_IM_MoveLocationBill".equalsIgnoreCase(billHead) && !"T_IM_InvStateAdjustBill".equalsIgnoreCase(billHead)) {
            sql.append("inner join t_scm_transactiontype c on a.ftransactiontypeid = c.fid ");
            sql.append("inner join t_im_invupdatetype e on e.fid = b.finvupdatetypeid ");
        }
        sql.append("inner join t_im_storetype d on d.fid = ").append(fieldStoreTypeId);
        sql.append(" inner join t_bd_materialinventory materialinventory ");
        sql.append(" on b.fmaterialid = materialinventory.fmaterialid AND a.fstorageorgunitid = materialinventory.forgunit ");
        sql.append(msWhere).append(" and (a.fbasestatus = 4 or a.fbasestatus = 7) and isnull(a.fisinitbill,0) = 0 ");
        if (!"T_IM_MoveLocationBill".equalsIgnoreCase(billHead) && !"T_IM_InvStateAdjustBill".equalsIgnoreCase(billHead)) {
            sql.append("and ").append(existingQtyWhere).append(" ");
        }
        sql.append("group by b.FId,b.fcompanyorgunitid,b.fstorageorgunitid,b.fmaterialid,b.fassistpropertyid,b.FLot,");
        sql.append("d.fstoreflag,a.FYear,a.FPeriod,a.FBizTypeId,a.FBillTypeId,").append(groupIsCalculate);
        sql.append(fieldStoreTypeId).append(",").append(fieldStoreStatusId).append(",");
        sql.append(fieldWarehouseId).append(",").append(fieldLocationId).append(",");
        sql.append(fieldSupplierId).append(",").append(fieldCustomerId).append(",");
        sql.append("(case isnull(materialinventory.fisprojectnumber,0) when 0 then null else b.fprojectid end),");
        sql.append("(case isnull(materialinventory.fistrackingnumber,0) when 0 then null else b.ftracknumberid end)");
        return sql.toString();
    }

    protected static String getBillSql(String tempTable, String msWhere) {
        StringBuffer sql = new StringBuffer();
        sql.append("select a.FId,a.FCompanyOrgUnitID,a.FStorageOrgUnitID,a.FMaterialID,a.FAssistPropertyID,");
        sql.append("a.FStoreTypeID,a.FStoreStatusID,a.FSupplierID,a.FCustomerID,a.FWarehouseID,a.FLocationID,");
        sql.append("a.FLot,a.FProjectID,a.FTrackNumberID,a.FBaseQty,a.FAssistQty,a.FStandardCost,a.FActualCost,a.FYear,a.FPeriod,a.FIsCalculate,");
        sql.append("a.FBizTypeId,a.FBillTypeId,mc.FAccountType,a.FRIFlag ");
        sql.append("from ").append(tempTable).append(" a ");
        sql.append("inner join T_BD_MaterialCompanyInfo mc ");
        sql.append("on mc.FCompanyId = a.FCompanyOrgUnitId and mc.FMaterialId = a.FMaterialId ");
        sql.append("inner join t_bd_material as material on a.fmaterialid = material.FID ");
        sql.append(msWhere);
        return sql.toString();
    }

    private static void insertBillsDataToTempTable(SysTempTableHelper helper, String billTempTable, String[][] tableName, String whereSql, boolean isArUpdateInventory) throws BOSException {
        String[] dataLock = new String[]{"PURINWAREHS_LOCK", "MANUFACTUREREC_LOCK", "MOVEINWAREHS_LOCK", "OTHERINWAREHS_LOCK", "SALEISSUE_LOCK", "MATERIALREQ_LOCK", "MOVEISSUE_LOCK", "OTHERISSUE_LOCK", "PurReceival_LOCK", "MoveLocation_LOCK", "InvStateAdjust_LOCK"};
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(CalculateDataSourceProvider.getInsertMiddleSql(billTempTable));
        int billCount = tableName.length;
        QueryDataSyncLock lock = new QueryDataSyncLock();
        QueryDataTask[] tasks = new QueryDataTask[billCount];
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < billCount; ++i) {
            String[] sqlList = new String[2];
            sql.setLength(0);
            sql.append(insertSql).append(CalculateDataSourceProvider.getBillSql2(tableName[i][0], tableName[i][1], whereSql, IN_EFFECT, isArUpdateInventory));
            sqlList[0] = sql.toString();
            sql.setLength(0);
            sql.append(insertSql).append(CalculateDataSourceProvider.getBillSql2(tableName[i][0], tableName[i][1], whereSql, OUT_EFFECT, isArUpdateInventory));
            sqlList[1] = sql.toString();
            tasks[i] = new QueryDataTask(lock, dataLock[i], helper.getConn(), sqlList);
            lock.addLock(dataLock[i]);
        }
        try {
            ThreadPool.getInstance().addTask((Runnable[])tasks);
            lock.waitFinish();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static String getInsertMiddleSql(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tableName);
        sql.append("(FId,FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,");
        sql.append("FAssistPropertyID, FStoreTypeID,FStoreStatusID,FSupplierID,");
        sql.append("FCustomerID,FWarehouseID,FLocationID,FLot,FProjectID,FTrackNumberID,FBaseQty,FAssistQty,");
        sql.append("FStandardCost,FActualCost,FYear,FPeriod,FIsCalculate,FBizTypeId,");
        sql.append("FBillTypeId,FRIFlag)");
        sql.append("\n");
        return sql.toString();
    }

    private static String[][] getMiddleTempTableFields() {
        String[][] fields = new String[][]{{"FID", "varchar(44) NOT NULL"}, {"FCompanyOrgUnitID", "varchar(44) NULL"}, {"FStorageOrgUnitID", "varchar(44) NULL"}, {"FWarehouseID", "varchar(44) NULL"}, {"FLocationID", "varchar(44) NULL"}, {"FYear", "int NULL"}, {"FPeriod", "int NULL"}, {"FSupplierId", "varchar(44) NULL"}, {"FCustomerId", "varchar(44) NULL"}, {"FMaterialID", "varchar(44) NULL"}, {"FLot", "nvarchar(255) NULL"}, {"FProjectID", "varchar(44) NULL"}, {"FTrackNumberID", "varchar(44) NULL"}, {"FAssistPropertyID", "varchar(44) NULL"}, {"FBizTypeId", "varchar(44) NULL"}, {"FBillTypeId", "varchar(44) NULL"}, {"FBaseQty", "numeric(21, 8) DEFAULT 0"}, {"FAssistQty", "numeric(21, 8) DEFAULT 0"}, {"FActualCost", "numeric(17, 4) DEFAULT 0"}, {"FStandardCost", "numeric(17, 4) DEFAULT 0"}, {"FRIFlag", "int DEFAULT 1"}, {"FIsCalculate", "int DEFAULT 0"}, {"FStoreTypeID", "varchar(44) NULL"}, {"FStoreStatusID", "varchar(44) NULL"}};
        return fields;
    }
}

