/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.calculate.InvBillShareSqlGenerator;
import com.kingdee.eas.scm.cal.app.help.CostAdjustHelp;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExceptionDataAdjZero {
    private static Logger logger = Logger.getLogger(ExceptionDataAdjZero.class);
    private boolean isAutoGenVoucher = false;

    public void handleExpDataAdjZero(Context ctx, CalculateParams param, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        String tmpTalbeName = this.createTmpTable(ctx, sysTempTableHelper);
        String companyOrgID = param.getString("COMPANY_ID");
        if (companyOrgID == null) {
            return;
        }
        String calType = param.getString("CALTYPE");
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        try {
            companyOrgUnitInfo.setId(BOSUuid.read((String)companyOrgID));
            if (companyOrgUnitInfo == null || companyOrgUnitInfo.getId() == null) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
        }
        catch (Exception e) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        param.setInt("Local_Currency_Presision", CalculateUtil.getLocalCurrencyPrecision2(ctx, companyOrgUnitInfo));
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        if (periodInfo == null) {
            throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST);
        }
        param.setObject("PERIOD_OBJ", (Object)periodInfo);
        this.isAutoGenVoucher = SCMServerUtils.isVoucherWhenAudit((Context)ctx, (String)companyOrgID, (String)"410");
        StringBuffer accountSql = new StringBuffer();
        accountSql.append("SELECT DISTINCT FAccountType FROM T_BD_MaterialCompanyInfo WHERE FCompanyID = '");
        accountSql.append(companyOrgID).append("'");
        accountSql.append("\n AND (FAccountType =").append(3);
        accountSql.append(" OR FAccountType =").append(4);
        accountSql.append(" OR FAccountType =").append(5);
        accountSql.append(")");
        IRowSet rs = null;
        try {
            String sqlAccount = accountSql.toString();
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlAccount);
            int accountType = 0;
            boolean isSpecialAccountTyupe = false;
            LowTimer t = new LowTimer();
            int i = 1;
            while (rs.next()) {
                accountType = rs.getInt("FAccountType");
                isSpecialAccountTyupe = 5 == accountType;
                t.reset();
                logger.info((Object)("\u7b2c" + i + "\u79cd\u8ba1\u4ef7\u65b9\u6cd5\u8c03\u96f6\u5f00\u59cb" + accountType));
                this.insertBillData(sysTempTableHelper, param, companyOrgID, calType, tmpTalbeName, accountType);
                logger.info((Object)("\u51c6\u5907\u6570\u636e\u5171\u8017\u65f6(ms):" + t.msValue()));
                t.reset();
                this.calculateZeroData(ctx, sysTempTableHelper, periodInfo, tmpTalbeName, calType, isSpecialAccountTyupe, companyOrgID);
                logger.info((Object)("\u8c03\u96f6\u5171\u8017\u65f6(ms):" + t.msValue()));
                sysTempTableHelper.execute("TRUNCATE TABLE " + tmpTalbeName);
                ++i;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException ee) {
            throw ee;
        }
        catch (SQLException eee) {
            throw new BOSException((Throwable)eee);
        }
    }

    private void insertBillData(SysTempTableHelper sysTempTableHelper, CalculateParams param, String companyOrgID, String calType, String tmpTalbeName, int accountType) throws BOSException, SQLException {
        String orgIds;
        Set storageOrgBegs;
        PeriodInfo period = (PeriodInfo)param.getObject("PERIOD_OBJ");
        InvBillShareSqlGenerator sqlGenertor = new InvBillShareSqlGenerator();
        sqlGenertor.setPeriod(period);
        sqlGenertor.setCompanyOrgUnitId(companyOrgID);
        sqlGenertor.setAccountType(accountType);
        sqlGenertor.setFilterAccountType(true);
        sqlGenertor.setFilterIsCalculate(true);
        sqlGenertor.setCalcualte(true);
        if ("1".equals(calType)) {
            storageOrgBegs = (Set)param.getObject("STORAGEORGUNITID");
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                sqlGenertor.setQueryStorageIds(orgIds);
                sqlGenertor.setIsFilterStorage(true);
            }
        } else if ("2".equals(calType)) {
            Set wareHouseIds;
            storageOrgBegs = (Set)param.getObject("STORAGEORGUNITID");
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                sqlGenertor.setQueryStorageIds(orgIds);
                sqlGenertor.setIsFilterStorage(true);
            }
            if ((wareHouseIds = (Set)param.getObject("WAREHOUSEID")) != null && wareHouseIds.size() > 0) {
                String warehouseIds = CalculateUtil.getSqlIn(wareHouseIds);
                sqlGenertor.setQueryWarehsoueNumbers(warehouseIds);
                sqlGenertor.setIsFilterWarehouse(true);
            }
        }
        String billSQL = sqlGenertor.getPeriodBeginSql(null, period);
        boolean isSpecialAccountTyupe = 5 == accountType;
        StringBuffer bufferSql = this.getSumSelectSql(billSQL, calType, isSpecialAccountTyupe, true);
        bufferSql.append(this.getSumGroupSql(calType, isSpecialAccountTyupe));
        StringBuffer sqlBuffer = this.getInsertSQL(tmpTalbeName);
        sqlBuffer.append(bufferSql);
        sysTempTableHelper.execute(sqlBuffer.toString());
        billSQL = sqlGenertor.getInBillSql();
        bufferSql = this.getSumSelectSql(billSQL, calType, isSpecialAccountTyupe, true);
        bufferSql.append(this.getSumGroupSql(calType, isSpecialAccountTyupe));
        sqlBuffer = this.getInsertSQL(tmpTalbeName);
        sqlBuffer.append(bufferSql);
        sysTempTableHelper.execute(sqlBuffer.toString());
        billSQL = sqlGenertor.getCostAdjustBillSql(0);
        bufferSql.setLength(0);
        bufferSql = this.getSumSelectSql(billSQL, calType, isSpecialAccountTyupe, true);
        bufferSql.append(this.getSumGroupSql(calType, isSpecialAccountTyupe));
        sqlBuffer.setLength(0);
        sqlBuffer = this.getInsertSQL(tmpTalbeName);
        sqlBuffer.append(bufferSql);
        sysTempTableHelper.execute(sqlBuffer.toString());
        billSQL = sqlGenertor.getOutBillSql();
        bufferSql.setLength(0);
        bufferSql = this.getSumSelectSql(billSQL, calType, isSpecialAccountTyupe, false);
        bufferSql.append(this.getSumGroupSql(calType, isSpecialAccountTyupe));
        sqlBuffer.setLength(0);
        sqlBuffer = this.getInsertSQL(tmpTalbeName);
        sqlBuffer.append(bufferSql);
        sysTempTableHelper.execute(sqlBuffer.toString());
        billSQL = sqlGenertor.getCostAdjustBillSql(1);
        bufferSql.setLength(0);
        bufferSql = this.getSumSelectSql(billSQL, calType, isSpecialAccountTyupe, false);
        bufferSql.append(this.getSumGroupSql(calType, isSpecialAccountTyupe));
        sqlBuffer.setLength(0);
        sqlBuffer = this.getInsertSQL(tmpTalbeName);
        sqlBuffer.append(bufferSql);
        sysTempTableHelper.execute(sqlBuffer.toString());
    }

    private StringBuffer getInsertSQL(String tempTableName) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("INSERT INTO " + tempTableName + "(");
        sqlBuffer.append("FID,FCompanyOrgUnitID,Fwarehouseid,\n");
        sqlBuffer.append("FMaterialId,FBaseUnitId,Fstorageorgunitid,\n");
        sqlBuffer.append("FLot,FAssistPropertyID,FProjectID,FTrackNumberID,\n");
        sqlBuffer.append("FBASEQTY,FACTUALCOST) \n");
        return sqlBuffer;
    }

    private String createTmpTable(Context ctx, SysTempTableHelper sysTempTableHelper) throws BOSException {
        String tmpTalbeName = sysTempTableHelper.createTempTable(ctx, ExceptionDataAdjZero.getTmpTableFields());
        sysTempTableHelper.createTempTableIndex(tmpTalbeName, "FID", true, false);
        sysTempTableHelper.createTempTableIndex(tmpTalbeName, "FMaterialId", false, false);
        return tmpTalbeName;
    }

    public static String[][] getTmpTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FMaterialId", "VARCHAR(44)"}, {"FBaseUnitId", "VARCHAR(44)"}, {"FLot", "NVARCHAR(80)"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}, {"FBASEQTY", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FACTUALCOST", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    private StringBuffer getSumSelectSql(String billsql, String calType, boolean isSpceialAccount, boolean isIn) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n SELECT  newbosID('88888888'),T1.FCompanyOrgUnitID,T1.FWarehouseID,T1.FMATERIALID,T1.FBASEUNITID");
        buffer.append(",T1.FStorageOrgUnitID");
        if (isSpceialAccount) {
            buffer.append(",T1.FLot");
            buffer.append(",T1.FAssistPropertyID");
            buffer.append(",T1.FProjectID");
            buffer.append(",T1.FTrackNumberID");
        } else {
            buffer.append(",NULL AS FLot");
            buffer.append(",NULL AS FAssistPropertyID");
            buffer.append(",NULL AS FProjectID");
            buffer.append(",NULL AS FTrackNumberID");
        }
        if (isIn) {
            buffer.append(",SUM(T1.FBASEQTY) AS FABASEQTY ,SUM(T1.FACTUALCOST) AS FACTUALCOST FROM (\n ");
        } else {
            buffer.append(",SUM(-1*T1.FBASEQTY) AS FABASEQTY ,SUM(-1*T1.FACTUALCOST) AS FACTUALCOST FROM (\n ");
        }
        buffer.append(billsql);
        buffer.append(") AS T1\n  ");
        return buffer;
    }

    private String getSumGroupSql(String calType, boolean isSpceialAccount) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("GROUP BY T1.FCompanyOrgUnitID,T1.FWarehouseID,T1.FMATERIALID,T1.FBASEUNITID");
        buffer.append(",T1.FStorageOrgUnitID");
        if (isSpceialAccount) {
            buffer.append(",T1.FLot");
            buffer.append(",T1.FAssistPropertyID");
            buffer.append(",T1.FProjectID");
            buffer.append(",T1.FTrackNumberID");
        }
        return buffer.toString();
    }

    private void calculateZeroData(Context ctx, SysTempTableHelper sysTempTableHelper, PeriodInfo period, String tempTableName, String calType, boolean isSpecialAccounttype, String companyId) throws BOSException, EASBizException {
        IRowSet rs = null;
        IRowSet rs2 = null;
        Connection conn = null;
        try {
            String controlUnitid = ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            HashMap<String, ArrayList> costAdjMap = new HashMap<String, ArrayList>();
            ArrayList costAdjList = null;
            CoreBillBaseCollection costAdjCollection = new CoreBillBaseCollection();
            conn = sysTempTableHelper.getConn();
            rs = sysTempTableHelper.executeQuery(this.getChecksumGroupSql(tempTableName, calType, isSpecialAccounttype));
            HashSet<String> allAdjSet = new HashSet<String>();
            StringBuffer key = new StringBuffer();
            while (rs.next()) {
                key.setLength(0);
                key.append(rs.getString("FMATERIALID"));
                if ("0".equals(calType)) {
                    key.append(rs.getString("FCompanyOrgUnitID"));
                } else if ("1".equals(calType)) {
                    key.append(rs.getString("FCompanyOrgUnitID"));
                    key.append(rs.getString("FStorageOrgUnitID"));
                } else {
                    key.append(rs.getString("FCompanyOrgUnitID"));
                    key.append(rs.getString("FStorageOrgUnitID"));
                    key.append(rs.getString("FWarehouseID"));
                }
                if (isSpecialAccounttype) {
                    key.append(rs.getString("FLOT"));
                    key.append(rs.getString("FAssistPropertyID"));
                    key.append(rs.getString("FProjectID"));
                    key.append(rs.getString("FTrackNumberID"));
                }
                allAdjSet.add(key.toString());
            }
            rs2 = sysTempTableHelper.executeQuery(this.getCalculAdjZeroSql(tempTableName, calType, isSpecialAccounttype));
            while (rs2.next()) {
                key.setLength(0);
                key.append(rs2.getString("FMATERIALID"));
                if ("0".equals(calType)) {
                    key.append(rs2.getString("FCompanyOrgUnitID"));
                } else if ("1".equals(calType)) {
                    key.append(rs2.getString("FCompanyOrgUnitID"));
                    key.append(rs2.getString("FStorageOrgUnitID"));
                } else {
                    key.append(rs2.getString("FCompanyOrgUnitID"));
                    key.append(rs2.getString("FStorageOrgUnitID"));
                    key.append(rs2.getString("FWarehouseID"));
                }
                if (isSpecialAccounttype) {
                    key.append(rs2.getString("FLOT"));
                    key.append(rs2.getString("FAssistPropertyID"));
                    key.append(rs2.getString("FProjectID"));
                    key.append(rs2.getString("FTrackNumberID"));
                }
                if (!allAdjSet.contains(key.toString()) || CalculateUtil.ZERO.compareTo(rs2.getBigDecimal("FBASEQTY")) == 0) continue;
                allAdjSet.remove(key.toString());
            }
            rs2.beforeFirst();
            while (rs2.next()) {
                key.setLength(0);
                key.append(rs2.getString("FMATERIALID"));
                if ("0".equals(calType)) {
                    key.append(rs2.getString("FCompanyOrgUnitID"));
                } else if ("1".equals(calType)) {
                    key.append(rs2.getString("FCompanyOrgUnitID"));
                    key.append(rs2.getString("FStorageOrgUnitID"));
                } else {
                    key.append(rs2.getString("FCompanyOrgUnitID"));
                    key.append(rs2.getString("FStorageOrgUnitID"));
                    key.append(rs2.getString("FWarehouseID"));
                }
                if (isSpecialAccounttype) {
                    key.append(rs2.getString("FLOT"));
                    key.append(rs2.getString("FAssistPropertyID"));
                    key.append(rs2.getString("FProjectID"));
                    key.append(rs2.getString("FTrackNumberID"));
                }
                if (!allAdjSet.contains(key.toString()) || CalculateUtil.ZERO.compareTo(rs2.getBigDecimal("FACTUALCOST")) == 0) continue;
                RecentCostInfo info = new RecentCostInfo();
                info.setString("FControlUnitID", controlUnitid);
                info.setString("FCompanyOrgUnitID", rs2.getString("FCompanyOrgUnitID"));
                info.setString("Fstorageorgunitid", rs2.getString("FStorageOrgUnitID"));
                info.setString("Fwarehouseid", rs2.getString("FWarehouseID"));
                info.setString("FMaterialId", rs2.getString("FMATERIALID"));
                info.setString("FBaseUnitId", rs2.getString("FBASEUNITID"));
                if (isSpecialAccounttype) {
                    info.setString("FLOT", rs2.getString("FLOT"));
                    info.setString("FAssistPropertyID", rs2.getString("FAssistPropertyID"));
                    info.setString("FProjectID", rs2.getString("FProjectID"));
                    info.setString("FTrackNumberID", rs2.getString("FTrackNumberID"));
                }
                info.setRecentCost(rs2.getBigDecimal("FACTUALCOST"));
                info.setPrice(CalculateUtil.ZERO);
                info.setRecentQty(CalculateUtil.ZERO);
                info.setBigDecimal("FACTUALCOST", rs2.getBigDecimal("FACTUALCOST"));
                costAdjList = costAdjMap.get(this.getCostAdjKey(info)) == null ? new ArrayList() : (ArrayList)costAdjMap.get(this.getCostAdjKey(info));
                costAdjList.add(info);
                costAdjMap.put(this.getCostAdjKey(info), costAdjList);
                if (costAdjList.size() <= 100) continue;
                this.createCostAdjsutbill(conn, costAdjMap, period, true, costAdjCollection, ctx);
            }
            if (costAdjMap.size() > 0) {
                this.createCostAdjsutbill(conn, costAdjMap, period, true, costAdjCollection, ctx);
            }
            costAdjMap.clear();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs2);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs2);
        SQLUtils.cleanup((ResultSet)rs);
    }

    private String getChecksumGroupSql(String tempTableName, String calType, boolean isSpecialAccounttype) {
        StringBuffer checkSql = new StringBuffer();
        StringBuffer groupSql = new StringBuffer();
        groupSql.append("\n GROUP BY ");
        checkSql.append("SELECT ");
        if ("0".equals(calType)) {
            checkSql.append(" T1.FCompanyOrgUnitID ");
            groupSql.append(" T1.FCompanyOrgUnitID ");
        } else if ("1".equals(calType)) {
            checkSql.append(" T1.FCompanyOrgUnitID,T1.FStorageOrgUnitID");
            groupSql.append(" T1.FCompanyOrgUnitID,T1.FStorageOrgUnitID ");
        } else {
            checkSql.append(" T1.FCompanyOrgUnitID,T1.FStorageOrgUnitID,T1.FWarehouseID ");
            groupSql.append("T1.FCompanyOrgUnitID,T1.FStorageOrgUnitID,T1.FWarehouseID ");
        }
        checkSql.append(",T1.FMATERIALID ");
        if (isSpecialAccounttype) {
            checkSql.append(",T1.FLOT ");
            checkSql.append(",T1.FAssistPropertyID ");
            checkSql.append(",T1.FProjectID ");
            checkSql.append(",T1.FTrackNumberID ");
            groupSql.append(",T1.FLOT ");
            groupSql.append(",T1.FAssistPropertyID ");
            groupSql.append(",T1.FProjectID ");
            groupSql.append(",T1.FTrackNumberID ");
        }
        checkSql.append(",SUM(T1.FBASEQTY) AS FBASEQTY,SUM(T1.FACTUALCOST) AS FACTUALCOST FROM ").append(tempTableName).append(" AS T1 ");
        groupSql.append(",T1.FMATERIALID ");
        checkSql.append(groupSql);
        checkSql.append("\n HAVING SUM(T1.FBASEQTY)=0 ");
        return checkSql.toString();
    }

    private String getCalculAdjZeroSql(String tempTableName, String calType, boolean isSpecialAccounttype) {
        StringBuffer adjSql = new StringBuffer();
        adjSql.append("SELECT T1.FCompanyOrgUnitID,T1.FStorageOrgUnitID,T1.FWarehouseID,T1.FMATERIALID,T1.FBASEUNITID");
        if (isSpecialAccounttype) {
            adjSql.append(",T1.FLOT");
            adjSql.append(",T1.FAssistPropertyID");
            adjSql.append(",T1.FProjectID");
            adjSql.append(",T1.FTrackNumberID");
        }
        adjSql.append(",\n SUM(ISNULL(T1.FBASEQTY,0)) AS FBASEQTY,SUM(ISNULL(T1.FACTUALCOST,0)) AS FACTUALCOST");
        adjSql.append("\n FROM ").append(tempTableName).append(" AS T1 ");
        adjSql.append(this.getSumGroupSql(calType, isSpecialAccounttype));
        return adjSql.toString();
    }

    private void createCostAdjsutbill(Connection con, HashMap costAdjMap, PeriodInfo period, boolean isMiddatelyExe, CoreBillBaseCollection costCollection, Context ctx) throws BOSException, EASBizException {
        HashSet<String> costAdjustBillIds = new HashSet<String>();
        if (isMiddatelyExe) {
            String insertCostajdSql = CostAdjustHelp.getPreparedInsertCostadjustBillSQL();
            Timestamp beginDate = period.getEndDate();
            Date sqlBeginDate = new Date(((java.util.Date)beginDate).getTime());
            PreparedStatement ps = null;
            try {
                ps = con.prepareStatement(insertCostajdSql);
                CostAdjustBillInfo bill = null;
                ArrayList costadjList = null;
                Iterator iter = costAdjMap.keySet().iterator();
                while (iter.hasNext()) {
                    costadjList = (ArrayList)costAdjMap.get((String)iter.next());
                    for (int i = 0; costadjList != null && i < costadjList.size(); ++i) {
                        bill = new CostAdjustBillInfo();
                        RecentCostInfo info = (RecentCostInfo)costadjList.get(i);
                        BOSUuid bosUid = BOSUuid.create((BOSObjectType)bill.getBOSType());
                        info.setId(bosUid);
                        bill.setId(bosUid);
                        costAdjustBillIds.add(bosUid.toString());
                        if (this.isAutoGenVoucher) {
                            costCollection.add((CoreBillBaseInfo)bill);
                        }
                        ps.setString(1, bosUid.toString());
                        ps.setString(2, null);
                        ps.setDate(3, sqlBeginDate);
                        ps.setString(4, null);
                        ps.setDate(5, sqlBeginDate);
                        ps.setString(6, info.getString("FControlUnitID"));
                        ps.setString(7, "EXP-" + String.valueOf(System.currentTimeMillis()).substring(2));
                        ps.setDate(8, sqlBeginDate);
                        ps.setInt(9, 0);
                        ps.setString(10, null);
                        ps.setDate(11, sqlBeginDate);
                        ps.setInt(12, 2);
                        ps.setString(13, info.getString("FStorageOrgUnitID"));
                        ps.setString(14, null);
                        ps.setInt(15, 0);
                        ps.setBigDecimal(16, CalculateUtil.ZERO);
                        ps.setBigDecimal(17, CalculateUtil.ZERO);
                        ps.setInt(18, 1);
                        ps.setInt(19, 2);
                        ps.setBigDecimal(20, CalculateUtil.ZERO);
                        ps.setBigDecimal(21, CalculateUtil.ZERO);
                        ps.setInt(22, 0);
                        ps.setString(23, "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552");
                        ps.setInt(24, period.getPeriodNumber());
                        ps.setInt(25, period.getPeriodYear());
                        ps.setInt(26, 0);
                        ps.setInt(27, 7);
                        this.createCostAdjsutbillEntry(con, costadjList, period, bosUid.toString(), isMiddatelyExe, bill);
                        ps.addBatch();
                    }
                    ps.executeBatch();
                    costadjList.clear();
                }
                if (costAdjustBillIds != null && costAdjustBillIds.size() > 0) {
                    Iterator costIterator = costAdjustBillIds.iterator();
                    ICostAdjustBill iCostAdjust = CostAdjustBillFactory.getLocalInstance(ctx);
                    while (costIterator.hasNext()) {
                        String billId = (String)costIterator.next();
                        iCostAdjust.audit((IObjectPK)new ObjectUuidPK(billId));
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
    }

    private void createCostAdjsutbillEntry(Connection con, ArrayList balanceList, PeriodInfo period, String billID, boolean isMiddatelyExe, CostAdjustBillInfo costAjdBill) throws BOSException {
        if (isMiddatelyExe || balanceList.size() >= 100) {
            String insertCostajdSql = CostAdjustHelp.getPreparedInserCostadjustEntrySQL();
            Date sqlBeginDate = new Date(period.getEndDate().getTime());
            PreparedStatement ps = null;
            try {
                ps = con.prepareStatement(insertCostajdSql);
                HashSet<String> entryIdSet = new HashSet<String>();
                int count = 0;
                for (int i = 0; i < balanceList.size(); ++i) {
                    RecentCostInfo info = (RecentCostInfo)balanceList.get(i);
                    BOSUuid bosUid = BOSUuid.create((String)"2774F28C");
                    ps.setString(1, bosUid.toString());
                    ps.setInt(2, ++count);
                    ps.setBigDecimal(3, CalculateUtil.ZERO);
                    ps.setInt(4, 4);
                    ps.setString(5, info.getString("FMaterialId"));
                    ps.setString(6, info.getString("FBaseUnitId"));
                    ps.setString(7, info.getString("FBaseUnitId"));
                    ps.setString(8, info.getString("Fstorageorgunitid"));
                    ps.setString(9, info.getString("FCompanyOrgUnitID"));
                    ps.setString(10, info.getString("Fwarehouseid"));
                    ps.setString(11, info.getString("FLOT"));
                    ps.setBigDecimal(12, CalculateUtil.ZERO);
                    ps.setBigDecimal(13, CalculateUtil.ZERO);
                    ps.setBigDecimal(14, CalculateUtil.ZERO);
                    ps.setBigDecimal(15, CalculateUtil.ZERO);
                    ps.setBigDecimal(16, CalculateUtil.ZERO);
                    ps.setBigDecimal(17, info.getPrice());
                    ps.setBigDecimal(18, info.getRecentCost());
                    ps.setBigDecimal(19, CalculateUtil.ZERO);
                    ps.setBigDecimal(20, CalculateUtil.ZERO);
                    ps.setBigDecimal(21, info.getPrice());
                    ps.setBigDecimal(22, info.getRecentCost());
                    ps.setString(23, billID);
                    ps.setInt(24, 0);
                    ps.setBigDecimal(25, CalculateUtil.ZERO);
                    ps.setBigDecimal(26, CalculateUtil.ZERO);
                    ps.setBigDecimal(27, CalculateUtil.ZERO);
                    ps.setString(28, "181875d5-0105-1000-e000-0111c0a812fd97D461A6");
                    ps.setString(29, "181875d5-0105-1000-e000-012ec0a812fd62A73FA5");
                    ps.setDate(30, sqlBeginDate);
                    ps.setString(31, info.getString("FAssistPropertyID"));
                    ps.setString(32, info.getString("FProjectID"));
                    ps.setString(33, info.getString("FTrackNumberID"));
                    ps.setInt(34, 0);
                    CostAdjustBillEntryInfo entry = new CostAdjustBillEntryInfo();
                    entry.setId(bosUid);
                    entryIdSet.add(bosUid.toString());
                    entry.setSeq(count);
                    costAjdBill.getEntry().add(entry);
                    ps.addBatch();
                }
                ps.executeBatch();
                if (entryIdSet.size() != 0) {
                    String[] sql = new String[2];
                    StringBuffer updateSql = new StringBuffer();
                    updateSql.append(" update T_CL_CostAdjustBillEntry as t  ");
                    updateSql.append(" set (FLocationID) = ( ");
                    updateSql.append(" select  t1.FLOCATIONID from T_DB_MaterialStorageAssign as t1 inner join T_DB_WAREHOUSE as t2 on t1.FWAREHOUSEID = t2.fid ");
                    updateSql.append(" where t.FLocationID is null and t2.fid = t.fwarehouseid and  t2.FHasLocation = 1 and t1.FISDEFAULTLOCATION = 1 and t.fmaterialid=t1.fmaterialid and t.FSTORAGEORGUNITID=t1.FSTORAGEORGID ");
                    updateSql.append(" and t.fid in (" + CalculateUtil.getSqlInString(entryIdSet) + ") ");
                    updateSql.append(" ) ");
                    sql[0] = updateSql.toString();
                    updateSql.setLength(0);
                    updateSql.append(" update T_CL_CostAdjustBillEntry as t  ");
                    updateSql.append(" set (FLocationID) = ( ");
                    updateSql.append(" select top 1  t1.fid from (SELECT t1.fid,t2.fid fwarehouseid,t2.FHasLocation FROM  T_DB_Location as t1 inner join T_DB_WAREHOUSE as t2 on t1.fwarehouseid = t2.fid order by t1.fnumber ) t1 ");
                    updateSql.append(" where t.FLocationID is null and t1.fwarehouseid = t.fwarehouseid and  t1.FHasLocation = 1 ");
                    updateSql.append(" and t.fid in (" + CalculateUtil.getSqlInString(entryIdSet) + ")");
                    updateSql.append(" ) ");
                    sql[1] = updateSql.toString();
                    DBUtil.execute(con, sql);
                }
                balanceList.clear();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
    }

    private String getCostAdjKey(RecentCostInfo bill) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(bill.getString("FCompanyOrgUnitID"));
        buffer.append("_$$$$_").append(bill.getString("FStorageOrgUnitId"));
        return buffer.toString();
    }
}

