/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculateCost;
import com.kingdee.eas.scm.cal.app.help.InventoryBalanceHelp;
import com.kingdee.eas.scm.cal.app.newutil.RecentCostHelper;
import com.kingdee.eas.scm.cal.newutil.CalConstant;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FIFOCalculate
extends AbstractCalculateCost {
    private Logger logger = Logger.getLogger(FIFOCalculate.class);
    private List<RecentCostInfo> inventoryBalanceList = null;

    @Override
    protected AccountType[] takeMaterialAccountType() {
        return new AccountType[]{AccountType.FIN_FOUT};
    }

    @Override
    protected boolean calculateStrategy(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        this.logger.debug((Object)("\u5f53\u524d\u5904\u7406\u7684\u671f\u95f4\uff1a" + periodInfo.getPeriodNumber() + "." + periodInfo.getPeriodYear()));
        Connection conn = null;
        IRowSet rsMaterial = null;
        try {
            conn = sysTempTableHelper.getConn();
            LowTimer t = new LowTimer();
            this.logger.debug((Object)("\u5148\u8fdb\u5148\u51fa\u8ba1\u7b97\u5f00\u59cb\uff1a" + t.msValue()));
            params.setBoolean("isCalReversed", true);
            params.setBoolean("IsNeedReWork", true);
            this.inventoryBalanceList = new ArrayList<RecentCostInfo>();
            params.setBoolean("calculteCostPriceMovein", true);
            String fifoBillTmpTableName = params.getString("T_Temp_FIFOBills");
            this.buildInOutBillsData(ctx, sysTempTableHelper, periodInfo, strCalType, params, fifoBillTmpTableName);
            this.adjustPrePeriodData(conn, params, periodInfo, fifoBillTmpTableName);
            this.updateReverseBill(ctx, periodInfo, strCalType, params, fifoBillTmpTableName, sysTempTableHelper);
            StringBuffer sqlmaterial = this.takeMatrialList(ctx, strCalType, fifoBillTmpTableName);
            String tempTableNameMaterial = params.getString("T_Temp_FIFOMaterialList");
            Map<String, MaterailInventoryInfo> materialBalanceMap = this.getMaterialBalance(ctx, params, strCalType, sysTempTableHelper);
            params.setObject("MATERIAL_BALANCE_MAP", materialBalanceMap);
            this.insertFIFOMaterialTMPTable(sysTempTableHelper, sqlmaterial, tempTableNameMaterial);
            this.logger.debug((Object)("\u51c6\u5907\u6570\u636e\u8017\u65f6\uff1a" + t.msValue()));
            String companyOrgID = params.getString("COMPANY_ID");
            this.deleteFIFOBalance(sysTempTableHelper, companyOrgID, periodInfo);
            params.setObject("connection", (Object)conn);
            StringBuffer s = new StringBuffer();
            int kk = 0;
            String materialSql = null;
            materialSql = KsqlUtil.isDB2((Context)ctx) ? "select * from SESSION." + tempTableNameMaterial : "select * from " + tempTableNameMaterial;
            int count = sysTempTableHelper.getRowsCount(tempTableNameMaterial);
            int start = 0;
            int length = 10000;
            int batch = 0;
            batch = count % length == 0 ? count / length : count / length + 1;
            for (int i = 0; i < batch; ++i) {
                start = length * i;
                rsMaterial = sysTempTableHelper.batchExecuteQuery(materialSql, start, length);
                while (rsMaterial.next()) {
                    ++kk;
                    s.setLength(0);
                    s.append("deal material:" + rsMaterial.getString("FMaterialId"));
                    s.append("-- deal company:" + rsMaterial.getString("FCompanyOrgUnitId"));
                    this.logger.debug((Object)s);
                    params.setObject("MATERIAL_LIST", (Object)rsMaterial);
                    this.fifoCalculate(ctx, params, (JdbcRowSet)params.getObject("MATERIAL_LIST"), params.getString("CALTYPE"), (PeriodInfo)params.getObject("PERIOD_OBJ"));
                }
            }
            this.updateNextBalance(conn, this.inventoryBalanceList, (PeriodInfo)params.getObject("nextPeriod"), true);
            this.logger.debug((Object)("\u5148\u8fdb\u5148\u51fa\u7ed3\u8d26\u5171\u7528(ms):" + t.msValue()));
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rsMaterial);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rsMaterial);
        return true;
    }

    @Override
    protected void adjustPrePeriodData(Connection conn, CalculateParams params, PeriodInfo periodInfo, String tempTableFIFOBills) throws BOSException, SQLException {
        LowTimer tt = new LowTimer();
        this.updateCombitionRetBill(conn, params, tempTableFIFOBills);
        this.logger.debug((Object)("\u5904\u7406\u671f\u9000\u8d27\u5355\u4e0e\u539f\u5355\u7684\u6570\u91cf\u4e0e\u91d1\u989d\u505a\u4e3a\u4e00\u7b14\u5f71\u54cd\u7ed3\u5b58(ms)" + tt.msValue()));
        tt.reset();
        DBUtil.execute(conn, this.getUpateCostAdjustBillDate(tempTableFIFOBills, periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u6210\u672c\u8c03\u6574\u5355\u65e5\u671f\u4e3a\u5f53\u671f\u7b2c\u4e00\u5929(ms)" + tt.msValue()));
        tt.reset();
        DBUtil.execute(conn, this.getUpdateCombitionBizDateSQL(tempTableFIFOBills));
        this.logger.debug((Object)("\u66f4\u5408\u5e76\u7684\u6e90\u5355\u7684\u4e1a\u52a1\u671f\u5230\u4e0b\u6e38\u5355\u636e\u4e0a\u6765(ms)" + tt.msValue()));
        tt.reset();
    }

    private Map<String, MaterailInventoryInfo> getMaterialBalance(Context ctx, CalculateParams params, String strCalType, SysTempTableHelper sysTempTableHelper) throws BOSException, SQLException {
        HashMap<String, MaterailInventoryInfo> result = new HashMap<String, MaterailInventoryInfo>();
        BigDecimal periodEndQty = null;
        BigDecimal periodEndBalance = null;
        String materialId = null;
        String companyId = null;
        String storageId = null;
        String warehsId = null;
        String keyId = null;
        IRowSet rs = null;
        try {
            String sql = this.getPeriodEndQtyAndBalanceSql(ctx, params, strCalType);
            String countSql = "(" + sql + ") T";
            int count = sysTempTableHelper.getRowsCount(countSql);
            int start = 0;
            int length = 10000;
            int batch = 0;
            batch = count % length == 0 ? count / length : count / length + 1;
            for (int i = 0; i < batch; ++i) {
                start = length * i;
                rs = sysTempTableHelper.batchExecuteQuery(sql, start, length);
                while (rs.next()) {
                    materialId = rs.getString("FMaterialID");
                    companyId = rs.getString("FCompanyOrgUnitID");
                    if (!"0".equals(strCalType)) {
                        storageId = rs.getString("FStorageOrgUnitID");
                    }
                    if ("2".equals(strCalType)) {
                        warehsId = rs.getString("FWarehouseID");
                    }
                    keyId = materialId + "_" + companyId;
                    if (!"0".equals(strCalType)) {
                        keyId = keyId + "_" + storageId;
                    }
                    if ("2".equals(strCalType)) {
                        keyId = keyId + "_" + warehsId;
                    }
                    periodEndQty = rs.getBigDecimal("PERIODENDQTY");
                    periodEndBalance = rs.getBigDecimal("FPERIODACTUALCOST");
                    result.put(keyId, new MaterailInventoryInfo(periodEndQty, periodEndBalance));
                }
            }
            HashMap<String, MaterailInventoryInfo> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs);
        }
    }

    public void fifoCalculate(Context ctx, CalculateParams params, JdbcRowSet rsMaterial, String strCalType, PeriodInfo periodInfo) throws EASBizException, BOSException {
        String tempTableNameData = params.getString("T_Temp_FIFOBills");
        Statement stmt = null;
        ResultSet rs = null;
        try {
            RecentCostInfo bill;
            MaterailInventoryInfo info;
            Connection conn = (Connection)params.getObject("connection");
            String materialId = rsMaterial.getString("FMaterialID");
            String key = materialId + "_" + rsMaterial.getString("fcompanyorgunitid");
            StringBuffer sql = new StringBuffer();
            sql.append("select * from ").append(tempTableNameData);
            sql.append(" where fmaterialid = '").append(materialId).append("'");
            sql.append("   and fcompanyorgunitid = '").append(rsMaterial.getString("fcompanyorgunitid")).append("'");
            if (!"0".equals(strCalType)) {
                sql.append(" AND fstorageorgunitid = '").append(rsMaterial.getString("fstorageorgunitid")).append("'");
                key = key + "_" + rsMaterial.getString("fstorageorgunitid");
            }
            if ("2".equals(strCalType)) {
                sql.append(" AND fwarehouseid = '").append(rsMaterial.getString("fwarehouseid")).append("'");
                key = key + "_" + rsMaterial.getString("fwarehouseid");
            }
            sql.append(this.getSQLOrderBy());
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            ArrayList<RecentCostInfo> listInBill = new ArrayList<RecentCostInfo>();
            ArrayList<RecentCostInfo> handredAdjustList = new ArrayList<RecentCostInfo>();
            RecentCostInfo lastOutWarehInfo = null;
            long timeSerialNumber = new Date().getTime();
            int lastPeriodStartIndex = 0;
            BigDecimal balanceQty = CalConstant.ZERO;
            BigDecimal balanceCost = CalConstant.ZERO;
            Map materialBalanceMap = (Map)params.getObject("MATERIAL_BALANCE_MAP");
            if (materialBalanceMap != null && (info = (MaterailInventoryInfo)materialBalanceMap.get(key)) != null) {
                balanceQty = info.getPeriodEndQty();
                balanceCost = info.getPeriodEndBalance();
            }
            while (rs.next()) {
                RecentCostInfo tempbill;
                ++timeSerialNumber;
                bill = this.convertRecentCostInfo(rs, ++timeSerialNumber);
                if (lastOutWarehInfo == null) {
                    lastOutWarehInfo = (RecentCostInfo)bill.clone();
                }
                if (bill.getInt("FisSrcBilInCurrPid") == 1) {
                    bill.setDealComplete(true);
                }
                if (bill.isMatAttrChange() || !RecentCostHelper.isEffectBalance(bill, strCalType)) continue;
                if (2 == bill.getInt("FCalculateKind")) {
                    if (CalConstant.ZERO.compareTo(bill.getRecentQty()) != 0) {
                        bill.setPrice(bill.getRecentCost().divide(bill.getRecentQty(), bill.getInt("FPricePrecision"), 4));
                    }
                    listInBill.add((RecentCostInfo)bill.clone());
                    ++lastPeriodStartIndex;
                    continue;
                }
                if (0 == bill.getInt("FCalculateKind")) {
                    if (bill.isCostAdjustBill()) {
                        handredAdjustList.add((RecentCostInfo)bill.clone());
                        continue;
                    }
                    if (!bill.isCalculate() || bill.isRedBill() || bill.getInt("FisCombition") == 2) continue;
                    listInBill.add((RecentCostInfo)bill.clone());
                    continue;
                }
                if (1 != bill.getInt("FCalculateKind")) continue;
                if (bill.isCostAdjustBill()) {
                    tempbill = (RecentCostInfo)bill.clone();
                    tempbill.setRecentCost(tempbill.getRecentCost().multiply(CalConstant.ONE_MINUS));
                    handredAdjustList.add(tempbill);
                    continue;
                }
                if (!bill.isCalculate()) continue;
                if (bill.isRedBill() && bill.getInt("FisSrcBilInCurrPid") != 1 && RecentCostHelper.isEffectBalance(bill, strCalType)) {
                    tempbill = (RecentCostInfo)bill.clone();
                    tempbill.setRecentCost(tempbill.getRecentCost().multiply(CalConstant.ONE_MINUS));
                    tempbill.setRecentQty(tempbill.getRecentQty().multiply(CalConstant.ONE_MINUS));
                    listInBill.add(tempbill);
                }
                lastOutWarehInfo = (RecentCostInfo)bill.clone();
            }
            if (handredAdjustList.size() > 0) {
                bill = this.getCombitionList(ctx, handredAdjustList);
                if (listInBill.size() >= lastPeriodStartIndex) {
                    listInBill.add(lastPeriodStartIndex, bill);
                } else {
                    listInBill.add(0, bill);
                }
            }
            this.getCalNewperiodBalance(conn, listInBill, balanceQty, balanceCost, lastOutWarehInfo);
            this.updateNextBalance(conn, this.inventoryBalanceList, (PeriodInfo)params.getObject("nextPeriod"), false);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private RecentCostInfo convertRecentCostInfo(ResultSet rs, long timeSerialNumber) throws SQLException {
        RecentCostInfo bill = new RecentCostInfo();
        bill.setPrice(rs.getBigDecimal("FPrice").setScale(rs.getInt("FPricePrecision"), 4));
        bill.setRecentCost(rs.getBigDecimal("FActualCost").setScale(rs.getInt("FLocalCurrencyPrecision"), 4));
        bill.setRecentQty(rs.getBigDecimal("FBaseQty").setScale(rs.getInt("FQtyPrecision"), 4));
        bill.setInt("FPricePrecision", rs.getInt("FPricePrecision"));
        bill.setInt("FLocalCurrencyPrecision", rs.getInt("FLocalCurrencyPrecision"));
        bill.setInt("FQtyPrecision", rs.getInt("FQtyPrecision"));
        bill.setString("FBillEntryId", rs.getString("FBillEntryId"));
        bill.setString("FBillId", rs.getString("FBillId"));
        bill.setString("FEntryTableMame", rs.getString("FEntryTableMame"));
        bill.setString("FNumber", rs.getString("FNumber"));
        bill.setInt("FFiVouchered", rs.getInt("FFiVouchered"));
        bill.setLong("timeSerialNumber", timeSerialNumber);
        bill.setBigDecimal("FReverseQty", rs.getBigDecimal("FReverseQty"));
        bill.setBigDecimal("FBaseQtyBak", rs.getBigDecimal("FBaseQtyBak"));
        bill.setInt("FCalculateKind", rs.getInt("FCalculateKind"));
        bill.setBigDecimal("freverseqty", rs.getBigDecimal("freverseqty"));
        bill.setString("FStorageOrgUnitId", rs.getString("FStorageOrgUnitId"));
        bill.setString("FWarehouseId", rs.getString("FWarehouseId"));
        bill.setString("FMaterialID", rs.getString("FMaterialID"));
        bill.setString("FCompanyOrgUnitID", rs.getString("FCompanyOrgUnitID"));
        bill.setString("FLot", rs.getString("FLot"));
        bill.setTimestamp("FBizDate", rs.getTimestamp("FBizDate"));
        bill.setString("FNumber", rs.getString("FNumber"));
        bill.setString("FBillTypeName", rs.getString("FBillTypeName"));
        bill.setDealComplete(false);
        bill.setBoolean("IS_MINUS_SETTLEACCOUNT", false);
        bill.setBigDecimal("addUpQty", CalConstant.ZERO);
        bill.setBigDecimal("addUpAmount", CalConstant.ZERO);
        bill.setString("FBizTypeID", rs.getString("FBizTypeID"));
        bill.setString("FStoreTypeID", rs.getString("FStoreTypeID"));
        bill.setString("FStoreTypePreID", rs.getString("FStoreTypePreID"));
        bill.setString("FSourceBillEntryID", rs.getString("FSourceBillEntryID"));
        bill.setBigDecimal("FSourceUnitActualCost", rs.getBigDecimal("FSourceUnitActualCost"));
        bill.setBigDecimal("FActualCostBak", rs.getBigDecimal("FActualCostBak"));
        bill.setString("FBillTypeID", rs.getString("FBillTypeID"));
        bill.setString("FmaterialNumber", rs.getString("FmaterialNumber"));
        bill.setInt("FisCombition", rs.getInt("FisCombition"));
        bill.setInt("FisSrcBilInCurrPid", rs.getInt("FisSrcBilInCurrPid"));
        bill.setBoolean("IsCalculate", true);
        return bill;
    }

    private StringBuffer getUpdateOffSetSumBill(PeriodInfo periodInfo, String strCalType, CalculateParams params, String tempTableName, String tempAssistTable) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ").append(tempTableName).append(" as t ");
        sql.append(" SET (FBaseQty,FActualCost) = ");
        sql.append(" (SELECT tempAssistTable.FBaseQty AS FBaseQty,tempAssistTable.FActualCost AS FActualCost FROM " + tempAssistTable + " AS tempAssistTable");
        sql.append(" WHERE tempAssistTable.Fid = t.Fid )");
        return sql;
    }

    protected StringBuffer getSQLOrderBy() {
        StringBuffer sql = new StringBuffer();
        sql.append(" Order by FBizdate,FAuditTime,FNumber,FSeqNum");
        return sql;
    }

    @Override
    public String[][] getTempTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FBillId", "VARCHAR(44) NOT NULL"}, {"FBillEntryId", "VARCHAR(44) NOT NULL"}, {"FEntryTableMame", "VARCHAR(44) NOT NULL"}, {"FNumber", "NVARCHAR(80)"}, {"FBizDate", "DateTime"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"Fstorageorg", "NVARCHAR(80)"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouse", "NVARCHAR(80)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseQtyBak", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPrice", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FReverseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPricePrecision", "INT DEFAULT 2"}, {"FQtyPrecision", "INT DEFAULT 4"}, {"FLocalCurrencyPrecision", "INT DEFAULT 2"}, {"FCalculateKind", "INT DEFAULT 0"}, {"FBillTypeName", "NVARCHAR(80)"}, {"FSeqNum", "INT DEFAULT 0"}, {"FFiVouchered", "INT DEFAULT 0"}, {"FBizTypeID", "VARCHAR(44)"}};
        return fields;
    }

    @Override
    public String getTempTableSerialVersionUID() {
        return null;
    }

    private String getReverseBillSql(PeriodInfo periodInfo, String strCalType, CalculateParams params, String tempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT tempTableName.FID,tempTableName.FbaseQty + offSetbill.fqty,tempTableName.FActualCost + offSetbill.factualcost");
        sql.append(" FROM ").append(tempTableName).append(" as tempTableName  ");
        sql.append(" INNER JOIN (").append("\t\n");
        sql.append(" SELECT bill.fsourcebillid,bill.fsourcebillentryid");
        sql.append(" ,sum(bill.fbaseqty) as fqty ,sum(bill.factualcost) as factualcost");
        sql.append(" FROM ").append(tempTableName).append(" as bill");
        sql.append(" WHERE bill.FIsReversed  = 1 ").append("\t\n");
        sql.append(" GROUP BY bill.fsourcebillid,bill.fsourcebillentryid");
        sql.append(" ) offSetbill");
        sql.append(" ON (tempTableName.fbillid = offSetbill.fsourcebillid ").append("\t\n");
        sql.append(" and tempTableName.fbillentryid = offSetbill.fsourcebillentryid)");
        return sql.toString();
    }

    private void updateReverseBill(Context ctx, PeriodInfo periodInfo, String strCalType, CalculateParams params, String tempTableName, SysTempTableHelper sysTempTableHelper) throws BOSException {
        String tempAssistTable = params.getString("T_Temp_ASSISTTABLE");
        sysTempTableHelper.execute("insert into " + tempAssistTable + "(FID,FBaseQty,FActualCost) " + this.getReverseBillSql(periodInfo, strCalType, params, tempTableName));
        sysTempTableHelper.execute(this.getUpdateOffSetSumBill(periodInfo, strCalType, params, tempTableName, tempAssistTable).toString());
    }

    private String getPeriodEndQtyAndBalanceSql(Context ctx, CalculateParams param, String strCalType) throws SQLException {
        String companyOrgID = param.getString("COMPANY_ID");
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT FMaterialId,FCompanyOrgUnitID,");
        if (!"0".equals(strCalType)) {
            buffer.append("FStorageOrgUnitID,");
        }
        if ("2".equals(strCalType)) {
            buffer.append("FWarehouseID,");
        }
        buffer.append(" SUM(FPeriodBeginQty + FPeriodReceiptQty - FPeriodIssueQty) AS PERIODENDQTY,").append("\t\n");
        buffer.append(" SUM(FPeriodBeginBalance + FPeriodReceiptAmount - FPeriodIssueAmount + FPeriodAdjustDiff+ FPeriodEndCostDiff) AS FPERIODACTUALCOST ").append("\t\n");
        buffer.append(" FROM ").append(param.getString("tempTalbeNameKEY")).append("\t\n");
        buffer.append(" Where FCompanyOrgUnitID = '").append(companyOrgID).append("'").append("\t\n");
        if ("0".equals(strCalType)) {
            buffer.append(" AND FIsCalculate = 1 ").append("\t\n");
            buffer.append(" AND FMoveType = 0 ").append("\t\n");
        } else if ("1".equals(strCalType)) {
            buffer.append(" AND (FMoveType <> 2 and FIsCalculate = 1)").append("\t\n");
        } else if ("2".equals(strCalType)) {
            buffer.append(" AND FIsCalculate = 1 ").append("\t\n");
        }
        buffer.append(" AND FStoreTypeId IN (Select FID From T_IM_StoreType Where FIsForwardAmt = 1)").append("\t\n");
        buffer.append(" Group by FMaterialId, FCompanyOrgUnitID");
        if (!"0".equals(strCalType)) {
            buffer.append(",FStorageOrgUnitID");
        }
        if ("2".equals(strCalType)) {
            buffer.append(",FWarehouseID");
        }
        return buffer.toString();
    }

    protected StringBuffer getSQLCostAdjJoinExtends() {
        return this.null_string;
    }

    protected void getCalNewperiodBalance(Connection conn, List<RecentCostInfo> inBillList, BigDecimal balanceQty, BigDecimal balanceCost, RecentCostInfo lastOutInfo) throws BOSException {
        int size = inBillList.size();
        BigDecimal qty = CalculateUtil.ZERO;
        BigDecimal cost = CalculateUtil.ZERO;
        RecentCostInfo info = null;
        boolean isExistsExpcep = true;
        if (CalculateUtil.ZERO.compareTo(balanceQty) == 0 && CalculateUtil.ZERO.compareTo(balanceCost) == 0) {
            return;
        }
        if (size == 0 && CalculateUtil.ZERO.compareTo(balanceQty) > 0) {
            lastOutInfo.setRecentQty(balanceQty);
            lastOutInfo.setRecentCost(balanceCost);
            lastOutInfo.setPrice(balanceCost.divide(lastOutInfo.getRecentQty(), lastOutInfo.getInt("FPricePrecision"), 4));
            this.inventoryBalanceList.add(lastOutInfo);
            isExistsExpcep = false;
            return;
        }
        BigDecimal excpAmount = CalculateUtil.ZERO;
        for (int i = size - 1; i >= 0; --i) {
            info = inBillList.get(i);
            if (CalculateUtil.ZERO.compareTo(balanceQty) > 0) {
                info.setRecentQty(balanceQty);
                info.setRecentCost(balanceCost);
                info.setPrice(balanceCost.divide(info.getRecentQty(), info.getInt("FPricePrecision"), 4));
                this.inventoryBalanceList.add(info);
                break;
            }
            if (CalculateUtil.ZERO.compareTo(info.getRecentQty()) == 0) {
                excpAmount = excpAmount.add(info.getRecentCost());
                continue;
            }
            qty = qty.add(info.getRecentQty());
            cost = cost.add(info.getRecentCost());
            if (qty.compareTo(balanceQty) >= 0) {
                info.setRecentQty(info.getRecentQty().subtract(qty.subtract(balanceQty)));
                info.setRecentCost(info.getRecentCost().subtract(cost.subtract(balanceCost)));
                if (CalculateUtil.ZERO.compareTo(info.getRecentQty()) != 0) {
                    info.setPrice(balanceCost.divide(info.getRecentQty(), info.getInt("FPricePrecision"), 4));
                } else {
                    info.setPrice(CalculateUtil.ZERO);
                }
                this.inventoryBalanceList.add(info);
                isExistsExpcep = false;
                break;
            }
            this.inventoryBalanceList.add(info);
        }
        if (isExistsExpcep && CalculateUtil.ZERO.compareTo(excpAmount) != 0) {
            if (lastOutInfo == null) {
                if (info != null) {
                    info.setRecentQty(CalculateUtil.ZERO);
                    info.setRecentCost(excpAmount);
                    this.inventoryBalanceList.add(info);
                }
            } else {
                lastOutInfo.setRecentQty(CalculateUtil.ZERO);
                lastOutInfo.setRecentCost(excpAmount);
                this.inventoryBalanceList.add(lastOutInfo);
            }
        }
    }

    protected void updateNextBalance(Connection con, List<RecentCostInfo> balanceList, PeriodInfo period, boolean isMiddatelyExe) throws BOSException {
        if (isMiddatelyExe || balanceList.size() >= 100) {
            String inserBalanceSql = InventoryBalanceHelp.getInsertCalBalancePreSQL("T_CL_INVENTORYBALANCE");
            PreparedStatement ps = null;
            try {
                ps = con.prepareStatement(inserBalanceSql);
                int count = 0;
                for (int i = balanceList.size() - 1; i >= 0; --i) {
                    ++count;
                    RecentCostInfo info = balanceList.get(i);
                    BOSUuid bosUid = BOSUuid.create((String)"7159C195");
                    ps.setString(1, bosUid.toString());
                    ps.setString(2, info.getString("FCompanyOrgUnitID"));
                    ps.setString(3, info.getString("FStorageOrgUnitID"));
                    ps.setString(4, info.getString("FWarehouseID"));
                    ps.setInt(5, period.getPeriodNumber());
                    ps.setInt(6, period.getPeriodYear());
                    ps.setString(7, info.getString("FMaterialID"));
                    ps.setString(8, info.getString("FLot"));
                    ps.setString(9, null);
                    ps.setString(10, null);
                    ps.setInt(11, Integer.parseInt(Long.toString(info.getLong("timeSerialNumber")).substring(5)));
                    ps.setBigDecimal(12, CalculateUtil.ZERO);
                    ps.setBigDecimal(13, info.getRecentCost());
                    ps.setBigDecimal(14, info.getRecentQty());
                    ps.setBigDecimal(15, CalculateUtil.ZERO);
                    ps.setBigDecimal(16, CalculateUtil.ZERO);
                    ps.setBigDecimal(17, CalculateUtil.ZERO);
                    ps.setBigDecimal(18, CalculateUtil.ZERO);
                    ps.setBigDecimal(19, CalculateUtil.ZERO);
                    ps.setBigDecimal(20, CalculateUtil.ZERO);
                    ps.setBigDecimal(21, CalculateUtil.ZERO);
                    ps.setBigDecimal(22, CalculateUtil.ZERO);
                    ps.setBigDecimal(23, CalculateUtil.ZERO);
                    ps.setBigDecimal(24, CalculateUtil.ZERO);
                    ps.setBigDecimal(25, CalculateUtil.ZERO);
                    ps.setBigDecimal(26, CalculateUtil.ZERO);
                    ps.setBigDecimal(27, CalculateUtil.ZERO);
                    ps.setBigDecimal(28, CalculateUtil.ZERO);
                    ps.setBigDecimal(29, CalculateUtil.ZERO);
                    ps.setBigDecimal(30, CalculateUtil.ZERO);
                    ps.setBigDecimal(31, CalculateUtil.ZERO);
                    ps.setBigDecimal(32, CalculateUtil.ZERO);
                    ps.setBigDecimal(33, CalculateUtil.ZERO);
                    ps.setBigDecimal(34, CalculateUtil.ZERO);
                    ps.setBigDecimal(35, CalculateUtil.ZERO);
                    ps.setBigDecimal(36, CalculateUtil.ZERO);
                    if (info.isOutBill()) {
                        ps.setString(37, info.getString("FStoreTypePreID"));
                    } else {
                        ps.setString(37, info.getString("FStoreTypeID"));
                    }
                    ps.addBatch();
                }
                ps.executeBatch();
                balanceList.clear();
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Statement)ps);
            }
        }
    }

    private void deleteFIFOBalance(SysTempTableHelper sysTempTableHelper, String companyId, PeriodInfo periodInfo) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Delete from T_CL_InventoryBalance ");
        buffer.append("\n where fcompanyorgunitid ='" + companyId + "'");
        buffer.append("\n and ((FYear = " + periodInfo.getPeriodYear());
        buffer.append("\n and FPeriod > " + periodInfo.getPeriodNumber());
        buffer.append("\n ) OR FYear > " + periodInfo.getPeriodYear() + ")");
        sysTempTableHelper.execute(buffer.toString());
    }

    class MaterailInventoryInfo {
        BigDecimal PeriodEndQty = null;
        BigDecimal PeriodEndBalance = null;

        public BigDecimal getPeriodEndQty() {
            return this.PeriodEndQty;
        }

        public BigDecimal getPeriodEndBalance() {
            return this.PeriodEndBalance;
        }

        public MaterailInventoryInfo(BigDecimal PeriodEndQty, BigDecimal PeriodEndBalance) {
            this.PeriodEndQty = PeriodEndQty;
            this.PeriodEndBalance = PeriodEndBalance;
        }
    }
}

