/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculateBill;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.List;

public class InvBillPriceCalculate
extends AbstractCalculateBill {
    int calType = 0;

    public int getCalType() {
        return this.calType;
    }

    public void setCalType(int calType) {
        this.calType = calType;
    }

    @Override
    protected AccountType[] takeMaterialAccountType() {
        List it = AccountType.getEnumList();
        AccountType[] type = new AccountType[it.size() - 1];
        int j = 0;
        for (int i = 0; i < it.size(); ++i) {
            if (AccountType.MOVE_ADD_AVERAGE.equals((Object)((AccountType)it.get(i)))) continue;
            type[j] = (AccountType)it.get(i);
            ++j;
        }
        return type;
    }

    protected boolean calculateStrategy(Context ctx, CalculateParams params, String tempTableName, String strCalType, PeriodInfo periodInfo) throws BOSException, EASBizException {
        return false;
    }

    public void updateLastTimeNewPayoutPrice(Context ctx, PeriodInfo period, String tempTableName, CalculateParams params) throws CalculateException, BOSException {
        PeriodInfo periodLastTime = period;
        try {
            periodLastTime = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
        }
        catch (Exception e) {
            throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{""});
        }
        this.updateNewPayoutPrice(ctx, periodLastTime, tempTableName, params);
    }

    public String updateUnitStandardPrice(PeriodInfo period, String tempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ").append(tempTableName).append(" AS T");
        sql.append(" SET (FActualBaseUnitCost,FActualCost) = (");
        sql.append(" SELECT ");
        sql.append("  ROUND(MATERIALCOMPANY.FStandardCost,TempT.FPricePrecision)");
        sql.append(" ,ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("TempT.FBASEQTY*MATERIALCOMPANY.FStandardCost")).append(",TempT.FLocalCurrencyPrecision)");
        sql.append(" FROM ").append(tempTableName).append(" AS TempT");
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (TempT.FMaterialID = MATERIALCOMPANY.FMaterialID");
        sql.append(" AND TempT.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )");
        sql.append(" WHERE TempT.FID = T.FID");
        sql.append("   AND MATERIALCOMPANY.FStandardCost <> 0 ");
        sql.append(" AND MATERIALCOMPANY.FStandardCost is not null ");
        sql.append(" )");
        return sql.toString();
    }

    public String getBeginDataSQL(PeriodInfo period, String tempTableName, String beginTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(beginTempTable).append("(FMaterialid,FCompanyOrgUnitID,FPeriodBeginQty,FPeriodBeginBalance");
        sql.append(this.getCalTypeSelectSql("", false)).append(")");
        sql.append(" SELECT ENTRY.FMaterialid ,ENTRY.FCompanyOrgUnitID");
        sql.append(" ,SUM(ENTRY.FPeriodBeginQty)as FPeriodBeginQty");
        sql.append(" ,SUM(ENTRY.FPeriodBeginBalance) as FPeriodBeginBalance");
        sql.append(this.getCalTypeSelectSql("ENTRY.", true));
        sql.append(" FROM ").append(tempTableName).append(" AS TempT");
        sql.append(" INNER JOIN T_IM_InventoryBalance ENTRY");
        sql.append(" ON (TempT.FMaterialID = ENTRY.FMaterialid");
        sql.append(" AND TempT.FCompanyOrgUnitID = ENTRY.FCompanyOrgUnitID)");
        sql.append(" INNER JOIN T_IM_StoreType StoreType ON ENTRY.FStoreTypeId = StoreType.FID");
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY  ON (ENTRY.FMaterialid = MATERIALCOMPANY.FMaterialID AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID)");
        sql.append(" Where ENTRY.FYear = ").append(period.getPeriodYear());
        sql.append(" AND ENTRY.FPeriod = ").append(period.getPeriodNumber());
        sql.append(" AND ENTRY.FIsCalculate = 1");
        sql.append(" AND StoreType.FisForwardAmt = 1");
        sql.append(" GROUP BY ENTRY.FMaterialid ,ENTRY.FCompanyOrgUnitID");
        sql.append(this.getCalTypeGroupSql("ENTRY.", true));
        sql.append(" having SUM(ENTRY.FPeriodBeginBalance) > 0");
        return sql.toString();
    }

    public String updateBeginWeightedAveragePrice(PeriodInfo period, String tempTableName, String beginTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ").append(tempTableName).append(" AS T");
        sql.append(" SET (FActualBaseUnitCost,FActualCost) = (");
        sql.append(" SELECT ");
        sql.append("  case when ENTRY.FPeriodBeginQty=0 then 0 else ");
        sql.append("       ROUND(" + CalculateUtil.TO_DECIMAL_DIVIDE(CalculateUtil.TO_DECIMAL_AMT("ENTRY.FPeriodBeginBalance") + "/ENTRY.FPeriodBeginQty") + ",TempT.FPricePrecision) end");
        sql.append(" ,case when ENTRY.FPeriodBeginQty=0 then 0 else ");
        sql.append("       ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("TempT.FBASEQTY*ROUND(" + CalculateUtil.TO_DECIMAL_DIVIDE(CalculateUtil.TO_DECIMAL_AMT("ENTRY.FPeriodBeginBalance") + "/ENTRY.FPeriodBeginQty") + ",TempT.FPricePrecision)")).append(",TempT.FLocalCurrencyPrecision) end");
        sql.append(" FROM ").append(tempTableName).append(" AS TempT");
        sql.append(" INNER JOIN ").append(beginTempTable).append(" AS ENTRY");
        sql.append(" ON (TempT.FMaterialID = ENTRY.FMaterialid AND TempT.FCompanyOrgUnitID = ENTRY.FCompanyOrgUnitID");
        sql.append(this.getCalTypeJoinSql("TempT", "ENTRY"));
        sql.append(")");
        sql.append(" WHERE TempT.FID = T.FID");
        sql.append(" )");
        return sql.toString();
    }

    public String updateReferrencePurchasePrice(PeriodInfo period, String tempTableName, CalculateParams params) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNewPrice(Context ctx, PeriodInfo period, String tempTableName, CalculateParams params, CalculateKindEnum kingenum) throws BOSException {
        params.setBoolean("includePreAndcurPeriod", true);
        params.setString("tempTable", tempTableName);
        String middlTempTableName = DBUtil.createTempTable(ctx, this.getCreateNewPriceMiddleTempTableSQL("NewPriceMiddleTable"));
        String newPriceTmpTable = null;
        try {
            this.getNewPriceData(ctx, params, middlTempTableName, period, kingenum.getValue());
            newPriceTmpTable = this.getTheNewPriceTmpTable(ctx, middlTempTableName);
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE ").append(tempTableName).append(" AS T").append("\t\n");
            sql.append("SET (FActualBaseUnitCost,FActualCost) = ( ").append("\t\n");
            sql.append("SELECT ROUND(maxCost.FBaseUnitActualCost,TempT.FPricePrecision),ROUND(TempT.FBaseQty*maxCost.FBaseUnitActualCost,TempT.FLocalCurrencyPrecision)").append("\t\n");
            sql.append("FROM ").append(tempTableName).append(" TempT").append("\t\n");
            sql.append("INNER JOIN ").append("\t\n");
            sql.append(newPriceTmpTable);
            sql.append(" maxCost ON maxCost.FMaterialID = TempT.FMaterialID").append("\t\n");
            sql.append(this.getCalTypeJoinSql("maxCost", "TempT")).append("\t\n");
            sql.append("WHERE TempT.FID = T.FID").append("\t\n");
            sql.append(")");
            DBUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Throwable throwable) {
            DBUtil.releaseTempTable(ctx, middlTempTableName);
            DBUtil.releaseTempTable(ctx, newPriceTmpTable);
            throw throwable;
        }
        DBUtil.releaseTempTable(ctx, middlTempTableName);
        DBUtil.releaseTempTable(ctx, newPriceTmpTable);
    }

    public String getTheNewPriceTmpTable(Context ctx, String newPriceTmpTable) throws BOSException {
        String newPriceTemp = DBUtil.createTempTable(ctx, this.getCreateMiddleTempTableSQL("newPriceTemp"));
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert into ").append(newPriceTemp).append("(FBaseUnitActualCost, FMaterialId").append("\t\n");
        sql.append(this.getCalTypeGroupSql("")).append(")").append("\t\n");
        sql.append("  SELECT Max(middle.FBaseUnitActualCost) AS FBaseUnitActualCost,middle.FMaterialID").append("\t\n");
        sql.append(this.getCalTypeSelectSql("middle.", false)).append("\t\n");
        sql.append("  FROM ").append(newPriceTmpTable).append(" middle").append("\t\n");
        sql.append("  INNER JOIN (").append("\t\n");
        sql.append(" \tSelect MAX(FBizDate) as FBizDate, FMaterialId").append("\t\n");
        sql.append(this.getCalTypeGroupSql("")).append("\t\n");
        sql.append(" \tFROM ").append(newPriceTmpTable).append("\t\n");
        sql.append(" \tGroup by FMaterialId").append("\t\n");
        sql.append(this.getCalTypeGroupSql("")).append("\t\n");
        sql.append("  ) maxBizDate on middle.FMaterialID = maxBizDate.FMaterialID and maxBizDate.FBizDate = middle.FBizDate").append("\t\n");
        sql.append(this.getCalTypeJoinSql("maxBizDate", "middle")).append("\t\n");
        sql.append("  Group by middle.FMaterialId").append("\t\n");
        sql.append(this.getCalTypeGroupSql("middle.")).append("\t\n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        return newPriceTemp;
    }

    private void getNewPriceData(Context ctx, CalculateParams params, String middlTempTableName, PeriodInfo period, int billType) throws BOSException {
        int start = 0;
        int end = 4;
        if (billType == 1) {
            start = 4;
            end = 8;
        }
        StringBuffer sql = new StringBuffer();
        String maxBizDateTemp = DBUtil.createTempTable(ctx, this.getCreateMiddleTempTableSQL("maxBizDateTemp"));
        for (int i = start; i < end; ++i) {
            DBUtil.execute((Context)ctx, (String)("truncate table " + maxBizDateTemp));
            this.insertTempTable(ctx, params, INVENTORYBILL_TABLENAME[i], period, billType, maxBizDateTemp);
            sql.setLength(0);
            sql.append(this.getInsertNewPriceSQL(middlTempTableName));
            sql.append(this.getSingleBillNewPriceSQL(params, INVENTORYBILL_TABLENAME[i], period, billType, maxBizDateTemp));
            DBUtil.execute((Context)ctx, (String)sql.toString());
        }
        DBUtil.releaseTempTable(ctx, maxBizDateTemp);
    }

    private String getInsertNewPriceSQL(String middlTempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert into ").append(middlTempTableName).append("(FMaterialId, FBizDate").append(this.getCalTypeGroupSql("")).append(",FBaseUnitActualCost)").append("\t\n");
        return sql.toString();
    }

    private String getSingleBillNewPriceSQL(CalculateParams params, String[] tabName, PeriodInfo period, int billType, String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("Select ENTRY.FMaterialId, ENTRY.FBizDate").append("\t\n");
        sql.append(this.getCalTypeSelectSql("ENTRY.", true));
        sql.append(", MAX(CASE WHEN ENTRY.FUNITID=ENTRY.FBASEUNITID OR ENTRY.FBaseQty=0 THEN ISNULL(ENTRY.FUNITACTUALCOST,0)").append("\t\n");
        sql.append("ELSE ROUND(TO_DECIMAL(TO_DECIMAL(ENTRY.FActualCost, 17, 4)/ENTRY.FBaseQty, 21, 8),MA.FPRICEPRECISION) END) AS FBaseUnitActualCost").append("\t\n");
        sql.append("FROM ").append(tabName[0]).append(" ENTRY").append("\t\n");
        sql.append("INNER JOIN ").append(tabName[1]).append(" BILL ON BILL.FID = ENTRY.FParentID ").append("\t\n");
        sql.append("INNER JOIN T_BD_MATERIAL MA ON ENTRY.FMaterialId = MA.FID ").append("\t\n");
        sql.append(this.getSQLJOIN(params, billType));
        sql.append("INNER JOIN ").append("\t\n");
        sql.append(tempTable);
        sql.append(" maxBizDate ON maxBizDate.fbizdate = ENTRY.FBizDate and maxBizDate.FMaterialId = ENTRY.FMaterialId").append("\t\n");
        sql.append(this.getCalTypeJoinSql("maxBizDate", "ENTRY", true));
        sql.append(this.getSQLWhere(period, params, true));
        sql.append(this.getFilterByCalType("0", params, this.INVENTORY_FIELD));
        if (!params.getBoolean("calculteCostPriceMovein") && INVENTORYBILL_TABLENAME[6][0].equals(tabName[0])) {
            sql.append(" AND BILL.FBizTypeID NOT IN (");
            sql.append("'").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
            sql.append(",'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
            sql.append(")").append("\t\n");
        }
        sql.append("AND Entry.FUnitActualCost > 0").append("\t\n");
        sql.append("GROUP BY ENTRY.FMaterialId, ENTRY.FBizDate").append("\t\n");
        sql.append(this.getCalTypeGroupSql("ENTRY.", true));
        return sql.toString();
    }

    private void insertTempTable(Context ctx, CalculateParams params, String[] tabName, PeriodInfo period, int billType, String maxBizDateTemp) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(maxBizDateTemp).append("\t\n");
        sql.append("(FBizDate,FMaterialId").append("\t\n");
        if (this.calType == 1 || this.calType == 2) {
            sql.append(",FSTORAGEORGUNITID").append("\t\n");
        }
        if (this.calType == 2) {
            sql.append(",FWAREHOUSEID").append("\t\n");
        }
        sql.append(",FLot,FAssistPropertyID,FProjectID,FTrackNumberID)").append("\t\n");
        sql.append("Select MAX(ENTRY.FBizDate) bizdate,ENTRY.FMaterialId").append("\t\n");
        sql.append(this.getCalTypeSelectSql("ENTRY.", true));
        sql.append(" \tFROM ").append(tabName[0]).append(" ENTRY").append("\t\n");
        sql.append(" \tINNER JOIN ").append(tabName[1]).append(" BILL ON BILL.FID = ENTRY.FParentID ").append("\t\n");
        sql.append(this.getSQLJOIN(params, billType));
        if (!StringUtil.isEmpty((String)params.getString("tempTable"))) {
            sql.append("\tINNER JOIN ").append(params.getString("tempTable")).append(" tempTable ON ENTRY.FMaterialId = tempTable.FMaterialId").append("\t\n");
            sql.append(this.getCalTypeJoinSql("tempTable", "ENTRY", true));
        }
        sql.append(this.getSQLWhere(period, params, true));
        if (this.getSQLWhereInventoryBalance(period, params) != null) {
            sql.append(this.getSQLWhereInventoryBalance(period, params));
        }
        sql.append(this.getFilterByCalType("0", params, this.INVENTORY_FIELD));
        if (!params.getBoolean("calculteCostPriceMovein") && INVENTORYBILL_TABLENAME[6][0].equals(tabName[0])) {
            sql.append(" AND BILL.FBizTypeID NOT IN (");
            sql.append("'").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
            sql.append(",'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
            sql.append(")").append("\t\n");
        }
        sql.append(" \tAND Entry.FUnitActualCost > 0").append("\t\n");
        sql.append("\tGROUP BY ENTRY.FMaterialId").append("\t\n");
        sql.append(this.getCalTypeGroupSql("ENTRY.", true));
        DBUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getCreateNewPriceMiddleTempTableSQL(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + tempTable + " (");
        sql.append("\n FBizDate DATETIME,");
        sql.append("\n FMaterialID VARCHAR(44),");
        sql.append("\n FSTORAGEORGUNITID VARCHAR(44),");
        sql.append("\n FWAREHOUSEID VARCHAR(44),");
        sql.append("\n FLot NVARCHAR(80),");
        sql.append("\n FAssistPropertyID VARCHAR(44),");
        sql.append("\n FProjectID VARCHAR(44),");
        sql.append("\n FTrackNumberID VARCHAR(44),");
        sql.append("\n FBaseUnitActualCost NUMERIC(21,8) default 0");
        sql.append(")");
        return sql.toString();
    }

    private String getCreateMiddleTempTableSQL(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + tempTable + " (");
        sql.append("\n FBizDate DATETIME,");
        sql.append("\n FMaterialID VARCHAR(44),");
        sql.append("\n FSTORAGEORGUNITID VARCHAR(44),");
        sql.append("\n FWAREHOUSEID VARCHAR(44),");
        sql.append("\n FLot NVARCHAR(80),");
        sql.append("\n FAssistPropertyID VARCHAR(44),");
        sql.append("\n FProjectID VARCHAR(44),");
        sql.append("\n FTrackNumberID VARCHAR(44),");
        sql.append("\n FBaseUnitActualCost NUMERIC(21,8) default 0");
        sql.append(")");
        return sql.toString();
    }

    public void updateNewInpourPrice(Context ctx, PeriodInfo period, String tempTableName, CalculateParams params) throws BOSException {
        this.updateNewPrice(ctx, period, tempTableName, params, CalculateKindEnum.INPUT_WAREHOUSE);
    }

    public void updateNewPayoutPrice(Context ctx, PeriodInfo period, String tempTableName, CalculateParams params) throws BOSException {
        this.updateNewPrice(ctx, period, tempTableName, params, CalculateKindEnum.OUTPUT_WAREHOUSE);
    }

    public String updateThisPeriodAverageInpourPrice(PeriodInfo period, String tempTableName, String sign, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        StringBuffer extField = new StringBuffer();
        extField.append("ENTRY.Flot,ENTRY.FAssistPropertyID,ENTRY.FProjectID,ENTRY.FTrackNumberID");
        sql.append(" UPDATE ").append(tempTableName).append(" AS T");
        sql.append(" SET (FActualBaseUnitCost,FActualCost) = (");
        sql.append(" SELECT ROUND(SumBill.FActualBaseUnitCost,TempT.FPricePrecision)");
        sql.append(" ,ROUND(TempT.FBaseQty*SumBill.FActualBaseUnitCost,TempT.FLocalCurrencyPrecision)");
        sql.append(" FROM ").append(tempTableName).append(" TempT");
        sql.append(" INNER JOIN (");
        sql.append(" SELECT ");
        sql.append(" Entry.Fmaterialid,Entry.FCompanyOrgUnitID");
        sql.append(this.getCalTypeSelectSql("Entry.", true));
        sql.append(" ,case when sum(FBaseQty+FPeriodBeginQty)=0 then 0 else ");
        sql.append("        " + CalculateUtil.TO_DECIMAL_DIVIDE(CalculateUtil.TO_DECIMAL_SUM("sum(FActualCost+FPeriodBeginBalance)") + "/sum(FBaseQty+FPeriodBeginQty)") + " end AS FActualBaseUnitCost");
        sql.append("  from (").append("\r\n");
        sql.append(this.getSQLInpourBill(period, null, extField.toString(), params)).append("\r\n");
        sql.append("\r\n UNION ALL \r\n");
        sql.append(this.getSQLPeriodBeginBalance(null, period, null, extField.toString(), params, null)).append("\t\n");
        sql.append(" ) Entry ");
        sql.append(" inner join T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (MATERIALCOMPANY.FMaterialID = Entry.FMaterialID ");
        sql.append(" AND MATERIALCOMPANY.FCOMPANYID = Entry.FCompanyOrgUnitId ) ");
        if (!StringUtil.isEmpty((String)sign)) {
            sql.append(" Where Entry.FBaseQty ").append(sign);
        }
        sql.append(" GROUP BY ");
        sql.append(" Entry.Fmaterialid,Entry.FCompanyOrgUnitID");
        sql.append(this.getCalTypeGroupSql("Entry.", true));
        sql.append(" ) as SumBill ");
        sql.append(" ON (SumBill.FMaterialID = TempT.FMaterialID ");
        sql.append(" AND SumBill.FCompanyOrgUnitID = TempT.fcompanyorgunitid ");
        sql.append(this.getCalTypeJoinSql("TempT", "SumBill"));
        sql.append(" )");
        sql.append(" WHERE TempT.FID = T.FID AND SumBill.FActualBaseUnitCost > 0");
        sql.append(" )");
        return sql.toString();
    }

    public String updateThisPeriodAveragePayoutPrice(PeriodInfo period, String tempTableName, String sign, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        StringBuffer extField = new StringBuffer();
        extField.append("ENTRY.Flot,ENTRY.FAssistPropertyID,ENTRY.FProjectID,ENTRY.FTrackNumberID");
        sql.append(" UPDATE ").append(tempTableName).append(" AS T");
        sql.append(" SET (FActualBaseUnitCost,FActualCost) = (");
        sql.append(" SELECT ROUND(SumBill.FActualBaseUnitCost,TempT.FPricePrecision)");
        sql.append(" ,ROUND(TempT.FBaseQty*SumBill.FActualBaseUnitCost,TempT.FLocalCurrencyPrecision)");
        sql.append(" FROM ").append(tempTableName).append(" TempT");
        sql.append(" INNER JOIN (");
        sql.append(" SELECT ");
        sql.append(" Entry.Fmaterialid,Entry.FCompanyOrgUnitID");
        sql.append(this.getCalTypeSelectSql("Entry.", true));
        sql.append(" ,case when sum(FBaseQty)=0 then 0 else ").append(CalculateUtil.TO_DECIMAL_SUM("sum(FActualCost)")).append("/sum(FBaseQty) end AS FActualBaseUnitCost");
        sql.append("  from (").append("\r\n");
        sql.append(this.getSQLPayoutBill(period, null, extField.toString(), params)).append("\r\n");
        sql.append(" ) Entry ");
        sql.append(" inner join T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (MATERIALCOMPANY.FMaterialID = Entry.FMaterialID ");
        sql.append(" AND MATERIALCOMPANY.FCOMPANYID = Entry.FCompanyOrgUnitId ) ");
        if (!StringUtil.isEmpty((String)sign)) {
            sql.append(" Where Entry.FBaseQty ").append(sign);
        }
        sql.append(" GROUP BY ");
        sql.append(" Entry.Fmaterialid,Entry.FCompanyOrgUnitID");
        sql.append(this.getCalTypeGroupSql("Entry.", true));
        sql.append(" ) as SumBill ");
        sql.append(" ON (SumBill.FMaterialID = TempT.FMaterialID ");
        sql.append(" AND SumBill.FCompanyOrgUnitID = TempT.fcompanyorgunitid ");
        sql.append(this.getCalTypeJoinSql("TempT", "SumBill"));
        sql.append(" )");
        sql.append(" WHERE TempT.FID = T.FID AND SumBill.FActualBaseUnitCost > 0 ");
        sql.append(" )");
        return sql.toString();
    }

    @Override
    protected StringBuffer getSQLCostAdjExtendWhere() {
        return this.null_string;
    }

    @Override
    protected StringBuffer getSQLJoinExtends(CalculateParams params) {
        return this.null_string;
    }

    @Override
    protected StringBuffer getSQLWhereExtends(PeriodInfo periodInfo, CalculateParams params) {
        return this.null_string;
    }

    protected StringBuffer getSQLCostAdjJoinExtends() {
        return this.null_string;
    }

    private String getCalTypeJoinSql(String subTableName, String nextTableName) {
        return this.getCalTypeJoinSql(subTableName, nextTableName, false);
    }

    private String getCalTypeJoinSql(String subTableName, String nextTableName, Boolean isAddLot) {
        StringBuffer sql = new StringBuffer();
        if (this.calType == 1 || this.calType == 2) {
            sql.append("\n AND ").append(subTableName).append(".FSTORAGEORGUNITID = ").append(nextTableName).append(".FSTORAGEORGUNITID ");
        }
        if (this.calType == 2) {
            sql.append("\n AND ").append(subTableName).append(".FWAREHOUSEID = ").append(nextTableName).append(".FWAREHOUSEID ");
        }
        if (isAddLot.booleanValue()) {
            sql.append("\n AND isnull(").append(subTableName).append(".FLot,N'NULLID') = (case when MATERIALCOMPANY.Fislot  = 1 then isnull(").append(nextTableName).append(".FLot,N'NULLID') else N'NULLID' end)");
            sql.append("\n AND isnull(").append(subTableName).append(".FAssistPropertyID,'NULLID') = (case when MATERIALCOMPANY.FISASSISTPROPERTY = 1 then isnull(").append(nextTableName).append(".FAssistPropertyID,'NULLID') else 'NULLID' end)");
            sql.append("\n AND isnull(").append(subTableName).append(".FProjectID,'NULLID') = (case when MATERIALCOMPANY.FISPROJECT = 1 then isnull(").append(nextTableName).append(".FProjectID,'NULLID') else 'NULLID' end) ");
            sql.append("\n AND isnull(").append(subTableName).append(".FTrackNumberID,'NULLID') = (case when MATERIALCOMPANY.FISTRACKNUMBER = 1 then isnull(").append(nextTableName).append(".FTrackNumberID,'NULLID') else 'NULLID' end) ");
        } else {
            sql.append("\n AND isnull(").append(subTableName).append(".FLot,N'NULLID') = isnull(").append(nextTableName).append(".FLot,N'NULLID') ");
            sql.append("\n AND isnull(").append(subTableName).append(".FAssistPropertyID,'NULLID') = isnull(").append(nextTableName).append(".FAssistPropertyID,'NULLID') ");
            sql.append("\n AND isnull(").append(subTableName).append(".FProjectID,'NULLID') = isnull(").append(nextTableName).append(".FProjectID,'NULLID') ");
            sql.append("\n AND isnull(").append(subTableName).append(".FTrackNumberID,'NULLID') = isnull(").append(nextTableName).append(".FTrackNumberID,'NULLID') ");
        }
        return sql.toString();
    }

    private String getCalTypeGroupSql(String tableNameWithdot, Boolean isAddLot) {
        StringBuffer sql = new StringBuffer();
        if (this.calType == 1 || this.calType == 2) {
            sql.append(",").append(tableNameWithdot).append("FSTORAGEORGUNITID ");
        }
        if (this.calType == 2) {
            sql.append(",").append(tableNameWithdot).append("FWAREHOUSEID ");
        }
        if (isAddLot.booleanValue()) {
            sql.append(", case when MATERIALCOMPANY.FISLOT = 1 then ").append(tableNameWithdot).append("FLot else null end  ");
            sql.append(", case when MATERIALCOMPANY.FISASSISTPROPERTY = 1 then ").append(tableNameWithdot).append("FAssistPropertyID else null end  ");
            sql.append(", case when MATERIALCOMPANY.FISPROJECT = 1 then ").append(tableNameWithdot).append("FProjectID else null end  ");
            sql.append(", case when MATERIALCOMPANY.FISTRACKNUMBER = 1 then ").append(tableNameWithdot).append("FTrackNumberID else null end  ");
        } else {
            sql.append(",").append(tableNameWithdot).append("FLot ");
            sql.append(",").append(tableNameWithdot).append("FAssistPropertyID ");
            sql.append(",").append(tableNameWithdot).append("FProjectID ");
            sql.append(",").append(tableNameWithdot).append("FTrackNumberID ");
        }
        return sql.toString();
    }

    private String getCalTypeSelectSql(String tableNameWithdot, Boolean isAddLot) {
        StringBuffer sql = new StringBuffer();
        if (this.calType == 1 || this.calType == 2) {
            sql.append(",").append(tableNameWithdot).append("FSTORAGEORGUNITID ");
        }
        if (this.calType == 2) {
            sql.append(",").append(tableNameWithdot).append("FWAREHOUSEID ");
        }
        if (isAddLot.booleanValue()) {
            sql.append(", case when MATERIALCOMPANY.FISLOT = 1 then ").append(tableNameWithdot).append("FLot else null end  FLot ");
            sql.append(", case when MATERIALCOMPANY.FISASSISTPROPERTY = 1 then ").append(tableNameWithdot).append("FAssistPropertyID else null end FAssistPropertyID ");
            sql.append(", case when MATERIALCOMPANY.FISPROJECT = 1 then ").append(tableNameWithdot).append("FProjectID else null end FProjectID ");
            sql.append(", case when MATERIALCOMPANY.FISTRACKNUMBER = 1 then ").append(tableNameWithdot).append("FTrackNumberID else null end FTrackNumberID ");
        } else {
            sql.append(",").append(tableNameWithdot).append("FLot ");
            sql.append(",").append(tableNameWithdot).append("FAssistPropertyID ");
            sql.append(",").append(tableNameWithdot).append("FProjectID ");
            sql.append(",").append(tableNameWithdot).append("FTrackNumberID ");
        }
        return sql.toString();
    }

    private String getCalTypeGroupSql(String tableNameWithdot) {
        return this.getCalTypeGroupSql(tableNameWithdot, false);
    }

    public String getNewPriceData(Context ctx, CalculateParams params, PeriodInfo period, CalculateKindEnum kingenum) throws BOSException {
        String middlTempTableName = DBUtil.createTempTable(ctx, this.getCreateNewPriceMiddleTempTableSQL("NewPriceMiddleTable"));
        this.getNewPriceData(ctx, params, middlTempTableName, period, kingenum.getValue());
        return middlTempTableName;
    }
}

