/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.common.perf.IJobInstStatusFacade;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtils;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.PriceSourEnum;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.BalanceCostInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculateCost;
import com.kingdee.eas.scm.cal.app.help.CostComputeHelp;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.app.help.UpdateBillCostHelper;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class MoveAverageReCalculateNew
extends AbstractCalculateCost {
    private Logger logger = Logger.getLogger(MoveAverageReCalculateNew.class);
    private CountDownLatch countDown;

    @Override
    protected AccountType[] takeMaterialAccountType() {
        return new AccountType[]{AccountType.MOVE_ADD_AVERAGE};
    }

    @Override
    protected boolean calculateStrategy(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        Connection conn = sysTempTableHelper.getConn();
        LowTimer calcuateTimer = new LowTimer();
        params.setBoolean("includeAfterPeriod", true);
        params.setBoolean("isCalReversed", true);
        params.setBoolean("IsNeedReWork", true);
        PeriodInfo perPeriod = null;
        try {
            perPeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
            params.setObject("perPeriod", (Object)perPeriod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean isNotSrcBill = CalculateUtil.getCostCalculateParam(ctx, params.getString("COMPANY_ID"), "SCM_CAL_014");
        boolean srcBillisPreperiod = CalculateUtil.getCostCalculateParam(ctx, params.getString("COMPANY_ID"), "SCM_CAL_015");
        params.setBoolean("isNotSrcOutBillCalType", isNotSrcBill);
        params.setBoolean("isSrcPerBillOutBillCalType", srcBillisPreperiod);
        params.setBoolean("calculteCostPriceMovein", true);
        params.setString("ERROR_MSG", SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COST_NOT_PRICE", (Context)ctx));
        params.setString("DETAILADJUST", SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"DETAILADJUST", (Context)ctx));
        String tempTableFIFOBills = params.getString("T_Temp_FIFOBills");
        String tempMaterialTable = params.getString("T_Temp_FIFOMaterialListNew");
        String jobId = (String)ctx.get((Object)"SCM_JOB_INST_ID");
        IJobInstStatusFacade iJobInstStatusFacade = JobInstStatusFacadeFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 15, "", ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"247_PutDataToTempTable", (Locale)this.l2), ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"247_PutDataToTempTable", (Locale)this.l3));
        }
        this.beforeCalculate(ctx, params, strCalType, periodInfo, sysTempTableHelper, conn, tempTableFIFOBills, tempMaterialTable);
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 60, "", ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"255_CostCalculating", (Locale)this.l2), ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"255_CostCalculating", (Locale)this.l3));
        }
        String materialSql = this.getMaterialSqlNew(ctx, tempMaterialTable, params);
        int materialPage = this.getMaterialPageCount(sysTempTableHelper, tempMaterialTable);
        this.countDown = new CountDownLatch(materialPage);
        int threadNum = this.getThreadPoolNum(ctx);
        ExecutorService executor = Executors.newFixedThreadPool(threadNum);
        for (int i = 0; i < materialPage; ++i) {
            CalculateThreadForMoveAvg calThread = new CalculateThreadForMoveAvg(ctx, conn, params, i * 1000, periodInfo, sysTempTableHelper, materialSql);
            executor.execute(calThread);
        }
        try {
            this.countDown.await();
            this.handleOtherData(ctx, sysTempTableHelper, params, periodInfo, tempTableFIFOBills, strCalType);
        }
        catch (InterruptedException e) {
            this.logger.info((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            this.logger.info((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        executor.shutdown();
        if (this.ExceptionList.size() > 0) {
            this.logger.info(this.ExceptionList.get(0));
            throw new BOSException((Throwable)this.ExceptionList.get(0));
        }
        this.logger.info((Object)("\u8ba1\u7b97\u6210\u672c\u603b\u65f6\u95f4\uff1a" + calcuateTimer.msValue()));
        return false;
    }

    private void beforeCalculate(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper, Connection conn, String tempTableFIFOBills, String tempMaterialTable) throws BOSException {
        LowTimer timer = new LowTimer();
        try {
            timer.reset();
            this.buildInOutBillsData(ctx, sysTempTableHelper, periodInfo, strCalType, params, tempTableFIFOBills);
            this.logger.info((Object)("\u5165\u5e93\u548c\u51fa\u5e93\u5355\u636e\u53d6\u6570\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            this.adjustPrePeriodData(conn, params, periodInfo, tempTableFIFOBills);
            this.logger.info((Object)("\u8fdb\u884c\u6570\u636e\u8c03\u6574\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            sysTempTableHelper.analyzeTable(tempTableFIFOBills);
            this.logger.info((Object)("\u7edf\u8ba1\u5206\u6790\u4e34\u65f6\u8868\u65f6\u95f4\uff1a\uff1a" + timer.msValue()));
            timer.reset();
            StringBuffer sqlmaterial = this.takeMatrialListNew(ctx, strCalType, tempTableFIFOBills);
            this.insertFIFOMaterialTMPTableNew(sysTempTableHelper, sqlmaterial, tempMaterialTable);
            this.logger.info((Object)("\u6784\u9020\u7269\u6599\u904d\u5386\u96c6\u5408\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            ArrayList sqlParams = new ArrayList();
            sysTempTableHelper.execute(this.cleaRecentCostData(params, strCalType, sqlParams), sqlParams);
            this.logger.info((Object)("\u6e05\u9664\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u7684\u5373\u65f6\u6838\u7b97\u8868\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            sqlParams.clear();
            sysTempTableHelper.execute(this.clearOldPeriodData(params, strCalType, sqlParams), sqlParams);
            this.logger.info((Object)("\u6e05\u9664\u6210\u672c\u8ba1\u7b97\u62a5\u544a\u65f6\u95f4\uff1a" + timer.msValue()));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public String[][] getTempTableFields() {
        return null;
    }

    @Override
    public String getTempTableSerialVersionUID() {
        return null;
    }

    protected StringBuffer getSQLWherePeriod(PeriodInfo periodInfo) {
        StringBuffer sql = new StringBuffer();
        if (periodInfo != null) {
            sql.append(" ((and BILL.FYear = ").append(periodInfo.getPeriodYear()).append("\t\n");
            sql.append(" and BILL.FPeriod >= ").append(periodInfo.getPeriodNumber()).append(")");
            sql.append(" OR BILL.FYear > ").append(periodInfo.getPeriodYear()).append("\t\n").append(")");
        }
        return sql;
    }

    @Override
    protected StringBuffer getSQLOrderBy(String stCalType) {
        StringBuffer sql = new StringBuffer();
        sql.append(" Order by ");
        if ("1".equals(stCalType)) {
            sql.append("Bill.FStorageOrgUnitId,");
        } else if ("2".equals(stCalType)) {
            sql.append("Bill.FStorageOrgUnitId,Bill.FWarehouseId,");
        }
        sql.append("Bill.FBizdate,BILL.FAUDITTIME,Bill.FNumber desc ,Bill.FSeqNum,bill.fcalculatekind ");
        return sql;
    }

    private HashMap moveAvgCalculate(Context ctx, Connection conn, CalculateParams params, RptRowSet rsMaterial, String strCalType, PeriodInfo periodInfo) throws EASBizException, BOSException {
        HashMap hashMap;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            String materialId = rsMaterial.getString("FMaterialID");
            params.setString("CurrMaterialId", materialId);
            String tempTableFIFOBills = params.getString("T_Temp_FIFOBills");
            StringBuffer sql = new StringBuffer();
            sql.append("select * from ").append(tempTableFIFOBills).append(" Bill ");
            sql.append(" where fmaterialid = '").append(materialId).append("'");
            sql.append("   and fcompanyorgunitid = '").append(rsMaterial.getString("fcompanyorgunitid")).append("'");
            sql.append(this.getSQLOrderBy(strCalType));
            ArrayList<RecentCostInfo> listAllBill = new ArrayList<RecentCostInfo>();
            HashMap<String, RecentCostInfo> costBillMap = new HashMap<String, RecentCostInfo>();
            LinkedHashMap costMoveMap = new LinkedHashMap();
            HashMap<String, RecentCostInfo> periodBillMap = new HashMap<String, RecentCostInfo>();
            HashMap matAttrChgMap = new HashMap();
            ArrayList calOrder = new ArrayList();
            RecentCostInfo periodBeginBill = null;
            RecentCostInfo bill = null;
            HashMap<String, RecentCostInfo> combitionMap = new HashMap<String, RecentCostInfo>();
            RecentCostInfo costBill = null;
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            long timeSerialNumber = new Date().getTime();
            Map<String, String> redAndBlueIdMap = this.getRedAndBlueBillEntryIdMap(ctx, params, tempTableFIFOBills, rsMaterial);
            while (rs.next()) {
                bill = this.convertRecentCostInfo(rs, strCalType, timeSerialNumber += 10L, false, redAndBlueIdMap);
                if (!calOrder.contains(bill.getString("FkeyID"))) {
                    calOrder.add(bill.getString("FkeyID"));
                }
                if (bill.getInt("FFiVouchered") == 1) {
                    bill.setPriceSource(PriceSourEnum.fiVouchered);
                    bill.setDealComplete(true);
                }
                Boolean isInBill4SaleReturn = this.isInBillForSaleReturn(bill, params);
                if (bill.isOutBill()) {
                    if (bill.getString("FSourceBillEntryID") != null) {
                        if (bill.isSrcOutBillInPrePeriod()) {
                            if (params.getBoolean("isSrcPerBillOutBillCalType")) {
                                bill.setBoolean("isOutRetBillisIn", true);
                            }
                            bill.setPriceSource(PriceSourEnum.sourBillPrice);
                            bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                        } else if (bill.isSrcOutBillInCurrentPd() || bill.getFBlueBillEntryID() != null && !isInBill4SaleReturn.booleanValue()) {
                            bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                            bill.setNeedUpdate(true);
                            if (bill.getFBlueBillEntryID() != null && !isInBill4SaleReturn.booleanValue()) {
                                bill.setPriceSource(PriceSourEnum.sourBillPrice);
                            }
                        } else {
                            if (bill.isRedBill() && params.getBoolean("isNotSrcOutBillCalType") && bill.getFBlueBillEntryID() == null || isInBill4SaleReturn.booleanValue()) {
                                bill.setBoolean("isOutRetBillisIn", true);
                                bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                            }
                            if (isInBill4SaleReturn.booleanValue()) {
                                bill.setPriceSource(PriceSourEnum.sourBillPrice);
                            }
                        }
                    } else {
                        if (bill.isNotSrcOutRetBill() && params.getBoolean("isNotSrcOutBillCalType")) {
                            bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                            bill.setBoolean("isOutRetBillisIn", true);
                        }
                        if (bill.isSrcOutBillInPrePeriod() && params.getBoolean("isSrcPerBillOutBillCalType")) {
                            bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                            bill.setBoolean("isOutRetBillisIn", true);
                        }
                    }
                }
                bill.setBigDecimal("MoveAvgQty", CalculateUtil.ZERO);
                bill.setBigDecimal("MoveAvgPrice", CalculateUtil.ZERO);
                bill.setBigDecimal("MoveAvgCost", CalculateUtil.ZERO);
                if (bill.isCostPriceMove()) {
                    this.buildCostPriceMove(bill, costMoveMap, strCalType);
                }
                if (bill.isMatAttrChange()) {
                    this.buildMatAttrChange(bill, matAttrChgMap);
                }
                if (2 == bill.getInt("FCalculateKind")) {
                    periodBeginBill = (RecentCostInfo)periodBillMap.get(bill.getString("FkeyID"));
                    if (periodBeginBill == null) {
                        periodBeginBill = bill;
                        periodBillMap.put(bill.getString("FkeyID"), periodBeginBill);
                        listAllBill.add(periodBeginBill);
                    } else {
                        periodBeginBill.setRecentCost(periodBeginBill.getRecentCost().add(bill.getRecentCost()));
                        periodBeginBill.setRecentQty(periodBeginBill.getRecentQty().add(bill.getRecentQty()));
                    }
                    RecentCostHelp.calculateAvgPrice(periodBeginBill);
                    continue;
                }
                combitionMap.put(bill.getString("FBillEntryId"), bill);
                if (bill.getInt("FisSrcBilInCurrPid") == -1) {
                    if (!combitionMap.containsKey(bill.getString("fsourcebillentryid"))) continue;
                    RecentCostInfo combinBill = (RecentCostInfo)combitionMap.get(bill.getString("fsourcebillentryid"));
                    bill.setLong("timeSerialNumber", combinBill.getLong("timeSerialNumber") + 1L);
                    combinBill.addCombition(bill);
                    int index = listAllBill.indexOf(combinBill);
                    listAllBill.add(index + 1, bill);
                    continue;
                }
                if ("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(bill.getString("FBillTypeID"))) {
                    String costBillKeyId = "2".equals(strCalType) ? bill.getString("fbillid") + bill.getString("fwarehouseid") : bill.getString("fbillid");
                    costBill = (RecentCostInfo)costBillMap.get(costBillKeyId);
                    if (costBill == null) {
                        costBill = bill;
                        costBillMap.put(costBillKeyId, bill);
                        listAllBill.add(costBill);
                        continue;
                    }
                    costBill.setRecentCost(costBill.getRecentCost().add(bill.getRecentCost()));
                    costBill.setRecentQty(costBill.getRecentQty().add(bill.getRecentQty()));
                    continue;
                }
                listAllBill.add(bill);
            }
            calOrder = this.setCalOrder(listAllBill, costMoveMap, calOrder, strCalType);
            HashMap balanceMap = this.calculateOutBillCost(ctx, params, conn, periodInfo, listAllBill, strCalType, costMoveMap, calOrder);
            this.calMatAttrChangeCost(matAttrChgMap);
            hashMap = balanceMap;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return hashMap;
    }

    private ArrayList setCalOrder(ArrayList inBillList, LinkedHashMap costMoveMap, ArrayList calOrder, String strCalType) {
        if (calOrder.size() <= 1 || "0".equals(strCalType)) {
            return calOrder;
        }
        LinkedList<String> outList = new LinkedList<String>();
        LinkedList<String> inList = new LinkedList<String>();
        RecentCostInfo costMoveBill = null;
        ArrayList costMoveInBillList = null;
        ArrayList costMoveoutBillList = null;
        RecentCostInfo inRecentCostInfo = null;
        RecentCostInfo outRecentCostInfo = null;
        String outID = null;
        String inID = null;
        for (Map.Entry entry : costMoveMap.entrySet()) {
            costMoveBill = (RecentCostInfo)entry.getValue();
            costMoveInBillList = costMoveBill.getMoveInbillList();
            costMoveoutBillList = costMoveBill.getMoveOutbillList();
            if (costMoveInBillList == null || costMoveoutBillList == null) continue;
            inRecentCostInfo = (RecentCostInfo)costMoveInBillList.get(0);
            outRecentCostInfo = (RecentCostInfo)costMoveoutBillList.get(0);
            if ("1".equals(strCalType)) {
                outID = outRecentCostInfo.getString("FStorageOrgUnitId");
                if (outID.equals(inID = inRecentCostInfo.getString("FStorageOrgUnitId"))) {
                    continue;
                }
            } else if ("2".equals(strCalType)) {
                outID = outRecentCostInfo.getString("FWarehouseId");
                inID = inRecentCostInfo.getString("FWarehouseId");
            }
            if (inList.contains(outID) && outList.contains(inID)) {
                this.setBillIsCal(inBillList, costMoveInBillList);
                continue;
            }
            if (!outList.contains(inID) && !inList.contains(inID)) {
                inList.add(inID);
            }
            if (inList.contains(outID)) {
                inList.remove(outID);
            }
            if (!outList.contains(outID)) {
                outList.add(outID);
                continue;
            }
            if (!outList.contains(inID)) continue;
            outList.add(outList.indexOf(inID), outID);
        }
        return this.getCalOrder(strCalType, outList, inList, calOrder);
    }

    private ArrayList getCalOrder(String strCalType, LinkedList outList, LinkedList inList, ArrayList calOrder) {
        int i;
        int n = inList.size();
        for (int i2 = 0; i2 < n; ++i2) {
            outList.add(inList.get(i2));
        }
        String key = null;
        String calKeyID = null;
        ArrayList<String> newCalOrder = new ArrayList<String>();
        int n2 = calOrder.size();
        for (i = 0; i < n2; ++i) {
            key = calOrder.get(i).toString();
            if (key.length() <= 0 || key.split("\\_\\$\\$\\$\\$\\_").length < 2) continue;
            String[] temp = key.split("\\_\\$\\$\\$\\$\\_");
            if ("1".equals(strCalType)) {
                calKeyID = temp[1];
            } else if ("2".equals(strCalType)) {
                calKeyID = temp[2];
            }
            if (!outList.contains(calKeyID)) {
                outList.addLast(key);
                continue;
            }
            int index = outList.indexOf(calKeyID);
            outList.set(index, key);
        }
        n2 = outList.size();
        for (i = 0; i < n2; ++i) {
            if (outList.get(i).toString().indexOf("$$$$") <= 0) continue;
            newCalOrder.add(outList.get(i).toString());
        }
        return newCalOrder;
    }

    private void setBillIsCal(ArrayList inBillList, ArrayList costMoveInBillList) {
        RecentCostInfo costMoveInInfo = null;
        RecentCostInfo inBillInfo = null;
        String moveInKey = null;
        String inBillKey = null;
        int n = inBillList.size();
        for (int i = 0; i < n; ++i) {
            inBillInfo = (RecentCostInfo)inBillList.get(i);
            inBillKey = inBillInfo.getString("FBillId");
            int k = costMoveInBillList.size();
            for (int j = 0; j < k; ++j) {
                costMoveInInfo = (RecentCostInfo)costMoveInBillList.get(j);
                moveInKey = costMoveInInfo.getString("FBillId");
                if (!moveInKey.equals(inBillKey)) continue;
                inBillInfo.setInListCal(false);
            }
        }
    }

    private HashMap calculateOutBillCost(Context ctx, CalculateParams params, Connection conn, PeriodInfo period, List listAllBill, String strCalType, HashMap costMoveMap, ArrayList orderList) throws BOSException, CalculateException {
        BalanceCostInfo balanceCostInfo = null;
        HashMap<String, Object> balanceMap = new HashMap<String, Object>();
        boolean isCalculate_NotSrcBill = params.getBoolean("isNotSrcOutBillCalType");
        boolean isCalculate_isSrcPrePerod = params.getBoolean("isSrcPerBillOutBillCalType");
        RecentCostInfo bill = null;
        String fKey = null;
        for (int k = 0; k < orderList.size(); ++k) {
            fKey = (String)orderList.get(k);
            params.setString("CAL_TYPE_KEY", fKey);
            for (int i = 0; listAllBill != null && i < listAllBill.size(); ++i) {
                bill = (RecentCostInfo)listAllBill.get(i);
                String key = bill.getString("FkeyID");
                if (!fKey.equals(key)) continue;
                if (balanceMap.get(key) == null) {
                    balanceCostInfo = new BalanceCostInfo();
                    balanceCostInfo.setStrCalType(strCalType);
                    balanceCostInfo.setBigDecimal("RecentPurInPrice", CalculateUtil.ZERO);
                    balanceCostInfo.setBigDecimal("RecentOutPrice", CalculateUtil.ZERO);
                    RecentCostInfo tmpInfo = (RecentCostInfo)bill.clone();
                    tmpInfo.setRecentCost(CalculateUtil.ZERO);
                    tmpInfo.setRecentQty(CalculateUtil.ZERO);
                    RecentCostHelp.calculateAvgPrice(tmpInfo);
                    balanceCostInfo.setReusltBillInfo(tmpInfo);
                } else {
                    balanceCostInfo = (BalanceCostInfo)((Object)balanceMap.get(key));
                }
                if (balanceCostInfo.getBoolean("isExceptionState")) continue;
                if (1 != bill.getInt("FCalculateKind")) {
                    this.calcualteBlueInOrOutBillCost(ctx, params, conn, period, balanceCostInfo, bill, strCalType, true);
                } else if (1 == bill.getInt("FCalculateKind")) {
                    if (bill.isRedBill() && !bill.isCostAdjustBill()) {
                        if (bill.getString("FSourceBillEntryID") != null) {
                            if (!bill.getBoolean("IS_NOT_AGAIN_UPDATE_COST")) {
                                bill.setNeedUpdate(true);
                                if (bill.isSrcOutBillInPrePeriod()) {
                                    bill.setBoolean("isOutRetBillisIn", isCalculate_isSrcPrePerod);
                                    bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                                    this.calcualteBlueInOrOutBillCost(ctx, params, conn, period, balanceCostInfo, bill, strCalType, isCalculate_isSrcPrePerod);
                                } else {
                                    bill.setNeedUpdate(true);
                                    this.calcualteBlueInOrOutBillCost(ctx, params, conn, period, balanceCostInfo, bill, strCalType, false);
                                    bill.setBoolean("ISADJUSTDIFFER", true);
                                }
                            } else {
                                this.calcualteBlueInOrOutBillCost(ctx, params, conn, period, balanceCostInfo, bill, strCalType, false);
                            }
                        } else {
                            this.calcualteBlueInOrOutBillCost(ctx, params, conn, period, balanceCostInfo, bill, strCalType, isCalculate_NotSrcBill);
                            bill.setBoolean("isOutRetBillisIn", isCalculate_NotSrcBill);
                            this.handleBlueBillAndRedBillRel(listAllBill, bill);
                            if (!isCalculate_NotSrcBill) {
                                bill.setBoolean("ISADJUSTDIFFER", true);
                            }
                        }
                    } else if (CalculateUtil.ZERO.compareTo(bill.getRecentQty()) <= 0 && !bill.isCostAdjustBill()) {
                        boolean isIn = false;
                        if (bill.isReversed() && isCalculate_NotSrcBill) {
                            isIn = true;
                            bill.setBoolean("isOutRetBillisIn", isIn);
                        }
                        this.calcualteBlueInOrOutBillCost(ctx, params, conn, period, balanceCostInfo, bill, strCalType, isIn);
                        this.synCostMovePriceBill(costMoveMap, bill);
                        this.handleBlueBillAndRedBillRel(listAllBill, bill);
                        bill.setBoolean("ISADJUSTDIFFER", true);
                    } else {
                        this.calcualteBlueInOrOutBillCost(ctx, params, conn, period, balanceCostInfo, bill, strCalType, false);
                    }
                }
                balanceMap.put(key, (Object)balanceCostInfo);
            }
        }
        this.handleDetailDiff(listAllBill, balanceMap);
        balanceMap.put("ALLINOUTLIST", listAllBill);
        return balanceMap;
    }

    private boolean calcualteBlueInOrOutBillCost(Context ctx, CalculateParams params, Connection conn, PeriodInfo period, BalanceCostInfo balanceBill, RecentCostInfo billInfo, String strCalType, boolean isIn) throws BOSException {
        PriceSourEnum priceSource = PriceSourEnum.realtimePrice;
        BigDecimal avgPrice = balanceBill.getPrice();
        BigDecimal recntOutPrice = balanceBill.getBigDecimal("RecentOutPrice");
        BigDecimal recntInPrice = balanceBill.getBigDecimal("RecentPurInPrice");
        BigDecimal recentQty = balanceBill.getRecentQty();
        if (!isIn && CalculateUtil.isZero(avgPrice)) {
            if (this.priceType == 0) {
                avgPrice = recntOutPrice;
                if (CalculateUtil.isZero(avgPrice)) {
                    avgPrice = this.getPrice(ctx, params);
                }
                priceSource = PriceSourEnum.newOut;
            } else if (this.priceType == 1) {
                avgPrice = recntInPrice;
                if (CalculateUtil.isZero(avgPrice)) {
                    avgPrice = this.getPrice(ctx, params);
                }
                priceSource = PriceSourEnum.newIn;
            } else if (this.priceType == 2) {
                String companyId = billInfo.getCompanyOrgUnit().getId().toString();
                String materialId = billInfo.getMaterial().getId().toString();
                avgPrice = this.getMaterialStandardCost(ctx, companyId, materialId);
                priceSource = PriceSourEnum.standUnitPrice;
            } else {
                avgPrice = billInfo.getPrice();
                priceSource = PriceSourEnum.userDefine;
            }
        }
        if (avgPrice == null) {
            avgPrice = CalculateUtil.ZERO;
        }
        if (!(isIn || billInfo.isDealComplete() || billInfo.isCostAdjustBill())) {
            if (CalculateUtil.ZERO.compareTo(avgPrice) >= 0 && 2 != billInfo.getInt("FCalculateKind")) {
                if (CalculateUtil.ZERO.compareTo(avgPrice) > 0) {
                    priceSource = PriceSourEnum.negativePrice;
                }
                if (CalculateUtil.ZERO.compareTo(avgPrice) == 0) {
                    priceSource = PriceSourEnum.zeroPrice;
                }
                if (this.priceType == 3 && billInfo.getPrice().compareTo(CalculateUtil.ZERO) > 0) {
                    priceSource = PriceSourEnum.userDefine;
                }
                billInfo.setPriceSource(priceSource);
                billInfo.setBoolean("isExceptionState", true);
                billInfo.setString("ERROR_MSG", params.getString("ERROR_MSG"));
                balanceBill.setBoolean("isExceptionState", true);
                return false;
            }
            if (!billInfo.getBoolean("IS_NOT_AGAIN_UPDATE_COST")) {
                if (billInfo.getRecentQty().compareTo(recentQty) == 0) {
                    billInfo.setRecentCost(balanceBill.getRecentCost());
                } else {
                    BigDecimal cost = billInfo.getRecentQty().multiply(avgPrice).setScale(billInfo.getInt("FLocalCurrencyPrecision"), 4);
                    if (cost.compareTo(BigDecimal.ZERO) == 0 && billInfo.getRecentQty().compareTo(BigDecimal.ZERO) != 0 && avgPrice.compareTo(BigDecimal.ZERO) != 0) {
                        cost = RecentCostHelp.getMinValueByScale(billInfo.getInt("FLocalCurrencyPrecision"), billInfo.getRecentQty().signum());
                    }
                    billInfo.setRecentCost(cost);
                }
                billInfo.setPrice(avgPrice);
                if (!billInfo.isDealComplete()) {
                    billInfo.setPriceSource(priceSource);
                }
                billInfo.setNeedUpdate(true);
            }
            if (CalculateUtil.ZERO.compareTo(billInfo.getPrice()) != 0) {
                balanceBill.setBigDecimal("RecentOutPrice", avgPrice);
            }
        } else if (CalculateUtil.ZERO.compareTo(billInfo.getPrice()) != 0) {
            balanceBill.setBigDecimal("RecentPurInPrice", billInfo.getPrice());
        }
        balanceBill.calculateBalance(billInfo, isIn);
        return true;
    }

    @Override
    protected void handleCostPriceMove(RecentCostInfo bill, HashMap costMoveMap) {
        if (bill.isCostPriceMove()) {
            ArrayList costMoveOutList = null;
            if (bill.isMoveOutBill()) {
                if (costMoveMap.get(bill.getString("FStockTransBillEntryID")) == null) {
                    costMoveOutList = new ArrayList();
                    costMoveOutList.add(bill);
                    costMoveMap.put(bill.getString("FStockTransBillEntryID"), costMoveOutList);
                } else {
                    costMoveOutList = (ArrayList)costMoveMap.get(bill.getString("FStockTransBillEntryID"));
                    costMoveOutList.add(bill);
                    costMoveMap.put(bill.getString("FStockTransBillEntryID"), costMoveOutList);
                }
            }
            if (bill.isMoveInBill()) {
                RecentCostInfo moveIssueBill = null;
                costMoveOutList = (ArrayList)costMoveMap.get(bill.getString("FStockTransBillEntryID"));
                if (costMoveOutList != null && costMoveOutList.size() > 0) {
                    for (int i = 0; i < costMoveOutList.size(); ++i) {
                        moveIssueBill = (RecentCostInfo)costMoveOutList.get(i);
                        if (bill.getString("FSourceBillEntryID") == null || !bill.getString("FSourceBillEntryID").equals(moveIssueBill.getString("FBillEntryId"))) continue;
                        moveIssueBill.addMoveInbillList(bill);
                        return;
                    }
                    moveIssueBill = (RecentCostInfo)costMoveOutList.get(costMoveOutList.size() - 1);
                    moveIssueBill.addMoveInbillList(bill);
                }
            }
        }
    }

    protected void holdCostPriceMove(RecentCostInfo bill, Map costMoveMap, List moveInList) {
        if (bill.isCostPriceMove()) {
            if (bill.isMoveOutBill()) {
                ArrayList moveIssueList = null;
                if (costMoveMap.get(bill.getString("FStockTransBillEntryID")) == null) {
                    moveIssueList = new ArrayList();
                    moveIssueList.add(bill);
                    costMoveMap.put(bill.getString("FStockTransBillEntryID"), moveIssueList);
                } else {
                    moveIssueList = (ArrayList)costMoveMap.get(bill.getString("FStockTransBillEntryID"));
                    moveIssueList.add(bill);
                    costMoveMap.put(bill.getString("FStockTransBillEntryID"), moveIssueList);
                }
            } else if (bill.isMoveInBill()) {
                moveInList.add(bill);
            }
        }
    }

    protected void buildCostMoveInOutRelation(Map costMoveMap, List moveInList) {
        RecentCostInfo bill = null;
        ArrayList costMoveOutList = null;
        RecentCostInfo moveIssueBill = null;
        for (int i = 0; i < moveInList.size(); ++i) {
            bill = (RecentCostInfo)moveInList.get(i);
            if (!bill.isCostPriceMove() || !bill.isMoveInBill() || (costMoveOutList = (ArrayList)costMoveMap.get(bill.getString("FStockTransBillEntryID"))) == null || costMoveOutList.size() <= 0) continue;
            for (int j = 0; j < costMoveOutList.size(); ++j) {
                moveIssueBill = (RecentCostInfo)costMoveOutList.get(j);
                if (bill.getString("FSourceBillEntryID") == null || !bill.getString("FSourceBillEntryID").equals(moveIssueBill.getString("FBillEntryId"))) continue;
                moveIssueBill.addMoveInbillList(bill);
                return;
            }
            moveIssueBill = (RecentCostInfo)costMoveOutList.get(costMoveOutList.size() - 1);
            moveIssueBill.addMoveInbillList(bill);
        }
    }

    protected void reWriteCostPriceMoveInPrice(RecentCostInfo info, HashMap costMoveMap) {
        if (info.isMoveOutBill()) {
            List costMoveOutList = (List)costMoveMap.get(info.getString("FStockTransBillEntryID"));
            for (int i = 0; costMoveOutList != null && i < costMoveOutList.size(); ++i) {
                ArrayList moveinList = ((RecentCostInfo)costMoveOutList.get(i)).getMoveInbillList();
                this.handleSrcBill(moveinList, info);
            }
        }
    }

    private void addRecentCostBacth(HashMap balanceMap, PreparedStatement ps) throws SQLException {
        Iterator iter = balanceMap.entrySet().iterator();
        BalanceCostInfo balanceInfo = null;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (((String)entry.getKey()).equals("ALLINOUTLIST")) continue;
            balanceInfo = (BalanceCostInfo)((Object)entry.getValue());
            RecentCostInfo recentCostInfo = balanceInfo.getReusltBillInfo();
            ps.setString(1, BOSUuid.create((BOSObjectType)recentCostInfo.getBOSType()).toString());
            ps.setBigDecimal(2, recentCostInfo.getPrice());
            ps.setBigDecimal(3, recentCostInfo.getRecentQty());
            ps.setBigDecimal(4, recentCostInfo.getRecentCost());
            ps.setString(5, recentCostInfo.getString("FMaterialID"));
            ps.setString(6, recentCostInfo.getString("FCompanyOrgUnitID"));
            ps.setString(7, recentCostInfo.getString("FStorageOrgUnitId"));
            ps.setString(8, recentCostInfo.getString("FWarehouseId"));
            ps.addBatch();
        }
    }

    private void handleDetailDiff(List allList, HashMap costMoveMap) {
        RecentCostInfo tmpBillInfo = null;
        BalanceCostInfo balanceInfo = null;
        if (costMoveMap == null || costMoveMap.size() == 0 || allList == null || allList.size() == 0) {
            return;
        }
        Iterator iter = costMoveMap.entrySet().iterator();
        String mapKey = null;
        block0: while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            mapKey = (String)entry.getKey();
            balanceInfo = (BalanceCostInfo)((Object)entry.getValue());
            if (balanceInfo == null) {
                return;
            }
            if (!balanceInfo.isNeedAdjustDetail()) continue;
            for (int i = allList.size() - 1; i >= 0; --i) {
                tmpBillInfo = (RecentCostInfo)allList.get(i);
                if (mapKey == null || !mapKey.equals(tmpBillInfo.getString("FkeyID")) || !this.isHandleDetailDiffer(balanceInfo, tmpBillInfo)) continue;
                tmpBillInfo.setRecentCost(tmpBillInfo.getRecentCost().add(balanceInfo.getRecentCost()));
                RecentCostHelp.calculateAvgPrice(tmpBillInfo);
                tmpBillInfo.setBigDecimal("MoveAvgQty", CalculateUtil.ZERO);
                tmpBillInfo.setBigDecimal("MoveAvgPrice", CalculateUtil.ZERO);
                tmpBillInfo.setBigDecimal("MoveAvgCost", CalculateUtil.ZERO);
                tmpBillInfo.setBoolean("ADJUSTDIFFERED", true);
                balanceInfo.handleDetailDifer(tmpBillInfo);
                continue block0;
            }
        }
    }

    private boolean isHandleDetailDiffer(BalanceCostInfo balanceInfo, RecentCostInfo infoBill) {
        return !infoBill.isDealComplete() && infoBill.getBoolean("ISADJUSTDIFFER") && CalculateUtil.ZERO.compareTo(balanceInfo.getRecentCost().add(infoBill.getRecentCost())) != 0 && CalculateUtil.ZERO.compareTo(infoBill.getBigDecimal("FReverseQty")) == 0 && !infoBill.isCostPriceMove() && !infoBill.isMatAttrChange();
    }

    class CalculateThreadForMoveAvg
    implements Runnable {
        Context ctx;
        CalculateParams params;
        SysTempTableHelper sysTempTableHelper;
        Connection conn;
        String materialSql;
        PeriodInfo periodInfo;
        int startIndex = 0;

        public CalculateThreadForMoveAvg(Context ctx, Connection conn, CalculateParams params, int startIndex, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper, String materialSql) {
            this.ctx = ctx;
            try {
                this.params = (CalculateParams)params.clone();
            }
            catch (CloneNotSupportedException e) {
                MoveAverageReCalculateNew.this.ExceptionList.add(e);
            }
            this.sysTempTableHelper = sysTempTableHelper;
            this.conn = conn;
            this.materialSql = materialSql;
            this.periodInfo = periodInfo;
            this.startIndex = startIndex;
        }

        @Override
        public void run() {
            try {
                this.asynCalculate();
            }
            catch (Exception e) {
                MoveAverageReCalculateNew.this.ExceptionList.add(e);
                MoveAverageReCalculateNew.this.logger.info((Object)e);
            }
            finally {
                MoveAverageReCalculateNew.this.countDown.countDown();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void asynCalculate() throws SQLException, BOSException {
            StringBuffer querySql = new StringBuffer();
            querySql.append(this.materialSql).append(" where ksql_seq > ").append(this.startIndex).append(" and ksql_seq <= ").append(1000 + this.startIndex);
            RptRowSet rsMaterial = DBUtils.executeQuery((String)querySql.toString(), (Connection)this.conn);
            UpdateBillCostHelper updateBillCostHelper = new UpdateBillCostHelper(this.conn);
            PreparedStatement reptPs = this.conn.prepareStatement(CostComputeHelp.getCreateCostComputeReportSQL());
            PreparedStatement recentCostPs = this.conn.prepareStatement(RecentCostHelp.getInsertPrepareRecentCostSQL());
            int materialCount = 0;
            HashMap balanceMap = null;
            try {
                while (rsMaterial.next()) {
                    ++materialCount;
                    try {
                        balanceMap = MoveAverageReCalculateNew.this.moveAvgCalculate(this.ctx, this.conn, this.params, rsMaterial, this.params.getString("CALTYPE"), this.periodInfo);
                        updateBillCostHelper.updateBills((ArrayList)balanceMap.get("ALLINOUTLIST"), new HashMap());
                        MoveAverageReCalculateNew.this.addRecentCostBacth(balanceMap, recentCostPs);
                        if (materialCount % 500 == 0) {
                            MoveAverageReCalculateNew.this.executePsBatch(recentCostPs);
                        }
                        if (this.params.getBoolean("ISWRITECOSTCOMPUTEREPORT")) {
                            if (this.params.getBoolean("ISWRITEDEXPCOSTRPT")) {
                                Map keyExceptionState = MoveAverageReCalculateNew.this.getKeyExceptionState(balanceMap);
                                this.params.setObject("keyExceptionState", (Object)keyExceptionState);
                            }
                            MoveAverageReCalculateNew.this.handleCostRept(this.ctx, reptPs, balanceMap, this.periodInfo, this.params);
                        }
                        if (materialCount % 500 == 0) {
                            MoveAverageReCalculateNew.this.executePsBatch(reptPs);
                        }
                        if (balanceMap == null) continue;
                        balanceMap.clear();
                    }
                    catch (Exception e) {
                        MoveAverageReCalculateNew.this.logger.debug((Object)("deal material:" + rsMaterial.getString("FmaterialNumber") + " \u5931\u8d25."));
                        MoveAverageReCalculateNew.this.logger.error((Object)e);
                        MoveAverageReCalculateNew.this.ExceptionList.add(e);
                        throw new BOSException((Throwable)e);
                    }
                }
                updateBillCostHelper.executeBatch(true);
                MoveAverageReCalculateNew.this.executePsBatch(recentCostPs);
                MoveAverageReCalculateNew.this.executePsBatch(reptPs);
                return;
            }
            catch (Exception e) {
                MoveAverageReCalculateNew.this.ExceptionList.add(e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Statement)reptPs);
                SQLUtils.cleanup((Statement)recentCostPs);
            }
        }
    }
}

