/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.common.perf.IJobInstStatusFacade;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostComputeReportInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculateCost;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;

public class MoveWeightedAverageReCalculate
extends AbstractCalculateCost {
    private BigDecimal ZERO = new BigDecimal(String.valueOf("0.00"));
    private static final int MAX_STATEMENT = 200;

    @Override
    protected AccountType[] takeMaterialAccountType() {
        return new AccountType[]{AccountType.MOVE_ADD_AVERAGE};
    }

    @Override
    protected boolean calculateStrategy(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        String tempTableName = params.getString("T_Temp_MoveWeightedAverageMaterialList");
        String jobId = (String)ctx.get((Object)"SCM_JOB_INST_ID");
        IJobInstStatusFacade iJobInstStatusFacade = JobInstStatusFacadeFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 15, "", ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"247_PutDataToTempTable", (Locale)this.l2), ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"247_PutDataToTempTable", (Locale)this.l3));
        }
        params.setBoolean("calculteCostPriceMovein", true);
        sysTempTableHelper.execute(this.insertTempTableSQL(tempTableName, this.getPeroidBeginBalanceSQL(ctx, Local_Currency_Presision, params, strCalType, periodInfo)));
        params.setBoolean("includeAfterPeriod", true);
        sysTempTableHelper.execute(this.insertTempTableSQL(tempTableName, this.getIncomeCostSQL(ctx, Local_Currency_Presision, params, strCalType, periodInfo)));
        sysTempTableHelper.execute(this.insertTempTableSQL(tempTableName, this.getPayoutCostSQL(ctx, Local_Currency_Presision, params, strCalType, periodInfo)));
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 50, "", ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"255_CostCalculating", (Locale)this.l2), ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"255_CostCalculating", (Locale)this.l3));
        }
        this.handleCostPriceTransBill(ctx, tempTableName, strCalType, sysTempTableHelper);
        sysTempTableHelper.execute(this.updateRecentCostSQL(tempTableName, strCalType));
        if (params.getBoolean("ISWRITECOSTCOMPUTEREPORT")) {
            if (!StringUtils.isEmpty((String)jobId)) {
                iJobInstStatusFacade.updateProgress(jobId, 80, "", ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"258_DealComputeReport", (Locale)this.l2), ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"258_DealComputeReport", (Locale)this.l3));
            }
            sysTempTableHelper.execute(this.clearOldPeriodData(periodInfo, strCalType, params).toString());
            this.processComputeReport(ctx, tempTableName, strCalType, sysTempTableHelper);
            sysTempTableHelper.execute(this.insertCostComputerReportSQL(ctx, tempTableName));
        }
        return true;
    }

    protected StringBuffer getSQLCostAdjJoinExtends() {
        StringBuffer bf = new StringBuffer();
        bf.append("INNER JOIN T_SCM_BillType BillType ON BillType.FID = '").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        return bf;
    }

    @Override
    public String[][] getTempTableFields() {
        return null;
    }

    @Override
    public String getTempTableSerialVersionUID() {
        return null;
    }

    protected StringBuffer getSQLWherePeriod(PeriodInfo periodInfo) {
        StringBuffer sql = new StringBuffer();
        if (periodInfo != null) {
            sql.append(" and BILL.FYear >= ").append(periodInfo.getPeriodYear()).append("\t\n");
            sql.append(" and BILL.FPeriod  >= ").append(periodInfo.getPeriodNumber());
        }
        return sql;
    }

    private String getIncomeCostSQL(Context ctx, int local_Currency_Presision, CalculateParams params, String strCalType, PeriodInfo periodInfo) {
        Locale loc = ctx.getLocale();
        StringBuffer bf = new StringBuffer();
        bf.append("select ");
        bf.append(" Entry.FID");
        bf.append(" ,Entry.FMaterialId");
        bf.append(" ,Entry.FCompanyOrgUnitID");
        bf.append(" ,Entry.FStorageOrgUnitID");
        bf.append(" ,Entry.FWarehouseID");
        bf.append("\n ,Entry.FActualCost");
        bf.append(" ,Entry.FBaseQty");
        bf.append(" ,ISNULL(FPricePrecision,2) AS FPricePrecision");
        bf.append(" ,ISNULL(MeasureUnitBase.FQtyPrecision,4) AS FQtyPrecision");
        bf.append(" ,").append(local_Currency_Presision).append(" AS FLocalCurrencyPrecision");
        bf.append(" ,Entry.FYear");
        bf.append(" ,Entry.FPeriod");
        bf.append(" ,0");
        bf.append(" ,Entry.FName_").append(loc);
        bf.append(" ,Entry.FNumber");
        bf.append(" ,''");
        bf.append(" ,''");
        bf.append(" ,''");
        bf.append(" ,Entry.FAuditTime");
        bf.append(",ENTRY.FBizTypeID");
        bf.append(" ,ENTRY.FSourceBillID");
        bf.append(",1");
        bf.append("\n from (").append("\r\n");
        bf.append(this.getSQLInpourBill(periodInfo, strCalType, "Entry.FID,MATERIAL.FPricePrecision,MATERIAL.FBASEUNIT,Bill.FYear,Bill.FPeriod,Bill.FAuditTime,SCMTRANSACTIONTYPE.FName_" + loc + ",BILL.FBizTypeID", params)).append("\t\n");
        bf.append("\r\n UNION ALL \r\n");
        bf.append(this.getSQLInpourCostAdjBill(periodInfo, strCalType, "Entry.FID,MATERIAL.FPricePrecision,MATERIAL.FBASEUNIT,Bill.FYear,Bill.FPeriod,Bill.FAuditTime,BillType.FName_" + loc + ",BILL.FBizTypeID", params)).append("\t\n");
        bf.append(" ) ENTRY ");
        bf.append("\n INNER JOIN T_BD_MultiMeasureUnit MeasureUnitBase");
        bf.append(" ON (Entry.FMaterialID = MeasureUnitBase.FMaterialid");
        bf.append(" AND Entry.FBaseUnit = MeasureUnitBase.FMeasureUnitID )");
        return bf.toString();
    }

    private String getPayoutCostSQL(Context ctx, int local_Currency_Presision, CalculateParams params, String strCalType, PeriodInfo periodInfo) {
        Locale loc = ctx.getLocale();
        StringBuffer bf = new StringBuffer();
        bf.append("select ");
        bf.append(" Entry.FID");
        bf.append(" ,Entry.FMaterialId");
        bf.append(" ,Entry.FCompanyOrgUnitID");
        bf.append(" ,Entry.FStorageOrgUnitID");
        bf.append(" ,Entry.FWarehouseID");
        bf.append(" ,Entry.FActualCost*(-1)");
        bf.append(" ,Entry.FBaseQty*(-1)");
        bf.append(" ,ISNULL(FPricePrecision,2) AS FPricePrecision");
        bf.append(" ,ISNULL(MeasureUnitBase.FQtyPrecision,4) AS FQtyPrecision");
        bf.append(" ,").append(local_Currency_Presision).append(" AS FLocalCurrencyPrecision");
        bf.append(" ,Entry.FYear");
        bf.append(" ,Entry.FPeriod");
        bf.append(" ,1");
        bf.append(" ,Entry.FName_").append(loc);
        bf.append(" ,Entry.FNumber");
        bf.append(" ,''");
        bf.append(" ,''");
        bf.append(" ,''");
        bf.append(" ,Entry.FAuditTime");
        bf.append(",ENTRY.FBizTypeID");
        bf.append(",ENTRY.FSourceBillID");
        bf.append(",1");
        bf.append(" from (").append("\r\n");
        bf.append(this.getSQLPayoutBill(periodInfo, strCalType, "Entry.FID,MATERIAL.FPricePrecision,MATERIAL.FBASEUNIT,Bill.FYear,Bill.FPeriod,Bill.FAuditTime,SCMTRANSACTIONTYPE.FName_" + loc + ",BILL.FBizTypeID", params)).append("\r\n");
        bf.append("\r\n UNION ALL \r\n");
        bf.append(this.getSQLPayoutCostAdjBill(periodInfo, strCalType, "Entry.FID,MATERIAL.FPricePrecision,MATERIAL.FBASEUNIT,Bill.FYear,Bill.FPeriod,Bill.FAuditTime,BillType.FName_" + loc + ",BILL.FBizTypeID", params));
        bf.append("\r\n");
        bf.append(" ) ENTRY ");
        bf.append(" INNER JOIN T_BD_MultiMeasureUnit MeasureUnitBase");
        bf.append(" ON (Entry.FMaterialID = MeasureUnitBase.FMaterialid");
        bf.append(" AND Entry.FBaseUnit = MeasureUnitBase.FMeasureUnitID )");
        return bf.toString();
    }

    private String getPeroidBeginBalanceSQL(Context ctx, int local_Currency_Presision, CalculateParams params, String strCalType, PeriodInfo periodInfo) {
        StringBuffer bf = new StringBuffer();
        bf.append("select ");
        bf.append(" NEWBOSID('88888888')");
        bf.append(" ,Entry.FMaterialId");
        bf.append(" ,Entry.FCompanyOrgUnitID");
        if ("2".equals(strCalType)) {
            bf.append(" ,Entry.FStorageOrgUnitID");
            bf.append(" ,Entry.FWarehouseID");
        } else if ("1".equals(strCalType)) {
            bf.append(" ,Entry.FStorageOrgUnitID");
            bf.append(" ,''");
        } else {
            bf.append(" ,''");
            bf.append(" ,''");
        }
        bf.append(" ,sum(Entry.FPeriodBeginBalance) as FActualCost");
        bf.append(" ,sum(Entry.FPeriodBeginQty) as FBaseQty");
        bf.append(" ,ISNULL(FPricePrecision,2) AS FPricePrecision");
        bf.append(" ,ISNULL(MeasureUnitBase.FQtyPrecision,4) AS FQtyPrecision");
        bf.append(" ,").append(local_Currency_Presision).append(" AS FLocalCurrencyPrecision");
        bf.append(" ,").append(periodInfo.getPeriodYear());
        bf.append(" ,").append(periodInfo.getPeriodNumber());
        bf.append(" ,2");
        bf.append(" ,'").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_BEGIN_CLOSE_ACCOUNT", (Context)ctx)).append("'");
        bf.append(" ,''");
        bf.append(" ,''");
        bf.append(" ,''");
        bf.append(" ,''");
        bf.append(" ,TO_DATE('1900-01-01 00:00:00.000')");
        bf.append(" ,null");
        bf.append(" ,ENTRY.FSourceBillID");
        bf.append(" ,1");
        bf.append("\n from (").append("\r\n");
        bf.append(this.getSQLPeriodBeginBalance(ctx, periodInfo, strCalType, "MATERIAL.FPricePrecision,MATERIAL.FBASEUNIT", params, "2"));
        bf.append("\r\n");
        bf.append(" ) ENTRY ");
        bf.append(" INNER JOIN T_BD_MultiMeasureUnit MeasureUnitBase");
        bf.append(" ON (Entry.FMaterialID = MeasureUnitBase.FMaterialid");
        bf.append(" AND Entry.FBaseUnit = MeasureUnitBase.FMeasureUnitID )");
        bf.append(" GROUP BY ");
        bf.append(" Entry.FMaterialId,Entry.FCompanyOrgUnitID");
        if ("2".equals(strCalType)) {
            bf.append(" ,Entry.FStorageOrgUnitID,Entry.FWarehouseID");
        } else if ("1".equals(strCalType)) {
            bf.append(" ,Entry.FStorageOrgUnitID");
        }
        bf.append(" ,FPricePrecision ");
        bf.append(" ,FQtyPrecision,ENTRY.FSourceBillID").append("\t\n");
        return bf.toString();
    }

    private String insertTempTableSQL(String tempTableName, String sql) {
        StringBuffer bf = new StringBuffer();
        bf.append("insert into ");
        bf.append(tempTableName);
        bf.append(" ").append(sql);
        return bf.toString();
    }

    private String insertCostComputerReportSQL(Context ctx, String tempTableName) {
        CostComputeReportInfo info = new CostComputeReportInfo();
        StringBuffer bf = new StringBuffer();
        bf.append("Insert Into T_CL_CostcomputeReport");
        bf.append("(FID,FBillName,FBillNumber,FCreateTime,FCreatorID,FCalculateKind");
        bf.append(",FIncome,FPayout,FSettleAccounts,FMaterialID,FCompanyOrgUnitID");
        bf.append(",FStorageOrgUnitID,FWarehouseID,FYear,FPeriod,FControlUnitID,FAccountType,FTimeSerialNumber)");
        bf.append(" select");
        bf.append(" newbosid('").append(info.getBOSType()).append("')");
        bf.append(" ,FBillName");
        bf.append(" ,FBillNumber");
        bf.append(" ,FCreateTime");
        bf.append(" ,'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        bf.append(" ,FCalculateKind");
        bf.append(" ,FIncome");
        bf.append(" ,FPayout");
        bf.append(" ,FSettleAccounts");
        bf.append(" ,FMaterialID");
        bf.append(" ,FCompanyOrgUnitID");
        bf.append(" ,FStorageOrgUnitID");
        bf.append(" ,FWarehouseID");
        bf.append(" ,FYear");
        bf.append(" ,FPeriod");
        bf.append(" ,'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()).append("'");
        bf.append(" ,1");
        bf.append(" ,'0'");
        bf.append(" from ").append(tempTableName);
        bf.append("\n WHERE FISCALCULATE = 1");
        return bf.toString();
    }

    private String updateRecentCostSQL(String tempTableName, String strCalType) {
        StringBuffer bf = new StringBuffer();
        bf.append("update T_CL_RecentCost as T set(FRecentCost,FRecentQty,FPrice)=(");
        bf.append("\n select FActualCost,FBaseQty,FBaseUnitActualCost from (");
        bf.append("\n select sum(TempT.FActualCost) AS FActualCost");
        bf.append(",sum(TempT.FBaseQty) AS FBaseQty");
        bf.append(",case when sum(TempT.FBaseQty) = 0 then");
        bf.append(" 0");
        bf.append(" else");
        bf.append(" ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("sum(TempT.FActualCost)")).append("/");
        bf.append(CalculateUtil.TO_DECIMAL_QTY("sum(TempT.FBaseQty)")).append(",FPricePrecision)");
        bf.append(" end");
        bf.append(" AS FBaseUnitActualCost");
        bf.append(",TempT.FMaterialID AS FMaterialID");
        bf.append(",TempT.FCompanyOrgUnitID AS FCompanyOrgUnitID");
        if ("1".equals(strCalType)) {
            bf.append(",TempT.FStorageOrgUnitID AS FStorageOrgUnitID");
        } else if ("2".equals(strCalType)) {
            bf.append(",TempT.FStorageOrgUnitID AS FStorageOrgUnitID,TempT.FWarehouseID AS FWarehouseID");
        }
        bf.append(" from ").append(tempTableName).append(" TempT");
        bf.append("\n WHERE FISCALCULATE = 1");
        bf.append(" group by FMaterialID,FCompanyOrgUnitID");
        if ("1".equals(strCalType)) {
            bf.append(",FStorageOrgUnitID");
        } else if ("2".equals(strCalType)) {
            bf.append(",FStorageOrgUnitID,FWarehouseID");
        }
        bf.append(",FPricePrecision");
        bf.append(") TT");
        bf.append(" where T.FMaterialID = TT.FMaterialID");
        bf.append(" and T.FCompanyOrgUnitID = TT.FCompanyOrgUnitID");
        if ("1".equals(strCalType)) {
            bf.append(" and T.FStorageOrgUnitID = TT.FStorageOrgUnitID");
        } else if ("2".equals(strCalType)) {
            bf.append(" AND T.FStorageOrgUnitID =TT.FStorageOrgUnitID and T.FWarehouseID = TT.FWarehouseID");
        }
        bf.append(")");
        return bf.toString();
    }

    private void processComputeReport(Context ctx, String tempTableName, String strCalType, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append("select * from ").append(tempTableName);
        bf.append("\n WHERE FISCALCULATE = 1 ");
        bf.append(" order by FMaterialID,FCompanyOrgUnitID");
        if ("2".equals(strCalType)) {
            bf.append(" ,FStorageOrgUnitID,FWarehouseID");
        } else if ("1".equals(strCalType)) {
            bf.append(" ,FStorageOrgUnitID");
        }
        bf.append(",FCreateTime");
        String querySql = bf.toString();
        bf.setLength(0);
        bf.append("update ").append(tempTableName);
        bf.append(" set FIncome = ?,FPayout = ?,FSettleAccounts = ?");
        bf.append(" where FID = ?");
        String updateSql = bf.toString();
        bf.setLength(0);
        Connection conn = null;
        PreparedStatement pm = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = sysTempTableHelper.getConn();
            pm = conn.prepareStatement(updateSql);
            ps = conn.prepareStatement(querySql);
            rs = ps.executeQuery();
            BigDecimal recentQty = this.ZERO;
            BigDecimal recentCost = this.ZERO;
            BigDecimal recentPrice = this.ZERO;
            String firstKey = null;
            int count = 0;
            while (rs.next()) {
                BigDecimal price;
                String id = rs.getString("FID");
                bf.append(rs.getString("FMaterialID")).append(rs.getString("FCompanyOrgUnitID"));
                if ("2".equals(strCalType)) {
                    bf.append(rs.getString("FStorageOrgUnitID")).append(rs.getString("FWarehouseID"));
                } else if ("1".equals(strCalType)) {
                    bf.append(rs.getString("FStorageOrgUnitID"));
                }
                String key = bf.toString();
                bf.setLength(0);
                if (!key.equals(firstKey)) {
                    recentQty = this.ZERO;
                    recentCost = this.ZERO;
                    recentPrice = this.ZERO;
                }
                int calculateKind = rs.getInt("FCalculateKind");
                int pricePrecision = rs.getInt("FPricePrecision");
                int qtyPrecision = rs.getInt("FQtyPrecision");
                int localCurrencyPrecision = rs.getInt("FLocalCurrencyPrecision");
                BigDecimal actualCost = rs.getBigDecimal("FActualCost").setScale(localCurrencyPrecision, 4);
                BigDecimal baseQty = rs.getBigDecimal("FBaseQty").setScale(qtyPrecision, 4);
                BigDecimal bigDecimal = price = this.ZERO.compareTo(baseQty) != 0 ? actualCost.divide(baseQty, pricePrecision, 4) : this.ZERO;
                if (1 == calculateKind) {
                    baseQty = baseQty.negate();
                    actualCost = actualCost.negate();
                }
                if (this.ZERO.compareTo(baseQty) == 0) {
                    bf.append(actualCost);
                } else {
                    String companyOrgUnitID = rs.getString("FCompanyOrgUnitID");
                    boolean isNotSrcBill = CalculateUtil.getCostCalculateParam(ctx, companyOrgUnitID.toString().trim(), "SCM_CAL_014");
                    if (isNotSrcBill && this.ZERO.compareTo(baseQty) > 0 && rs.getString("FSourceBillID") == null) {
                        baseQty = baseQty.negate();
                        actualCost = actualCost.negate();
                        calculateKind = 0;
                    }
                    bf.append(baseQty).append(" * ").append(price).append(" = ").append(actualCost);
                }
                String incomeOrPayoutDesc = bf.toString();
                bf.setLength(0);
                String settleAccountsDesc = null;
                switch (calculateKind) {
                    case 0: {
                        bf.append(recentQty).append(" * ").append(recentPrice).append(" = ").append(recentCost).append("\n");
                        recentQty = recentQty.add(baseQty).setScale(qtyPrecision, 4);
                        recentCost = recentCost.add(actualCost).setScale(localCurrencyPrecision, 4);
                        recentPrice = this.ZERO.compareTo(recentQty) != 0 ? recentCost.divide(recentQty, pricePrecision, 4) : this.ZERO;
                        bf.append(recentQty).append(" * ").append(recentPrice).append(" = ").append(recentCost);
                        settleAccountsDesc = bf.toString();
                        bf.setLength(0);
                        pm.setString(1, incomeOrPayoutDesc);
                        pm.setString(2, null);
                        pm.setString(3, settleAccountsDesc);
                        pm.setString(4, id);
                        pm.addBatch();
                        ++count;
                        break;
                    }
                    case 1: {
                        bf.append(recentQty).append(" * ").append(recentPrice).append(" = ").append(recentCost).append("\n");
                        recentQty = recentQty.subtract(baseQty).setScale(qtyPrecision, 4);
                        recentCost = recentCost.subtract(actualCost).setScale(localCurrencyPrecision, 4);
                        recentPrice = this.ZERO.compareTo(recentQty) != 0 ? recentCost.divide(recentQty, pricePrecision, 4) : this.ZERO;
                        bf.append(recentQty).append(" * ").append(recentPrice).append(" = ").append(recentCost);
                        settleAccountsDesc = bf.toString();
                        bf.setLength(0);
                        pm.setString(1, null);
                        pm.setString(2, incomeOrPayoutDesc);
                        pm.setString(3, settleAccountsDesc);
                        pm.setString(4, id);
                        pm.addBatch();
                        ++count;
                        break;
                    }
                    case 2: {
                        bf.append(this.ZERO).append(" * ").append(this.ZERO).append(" = ").append(this.ZERO).append("\n");
                        recentQty = recentQty.add(baseQty).setScale(qtyPrecision, 4);
                        recentCost = recentCost.add(actualCost).setScale(localCurrencyPrecision, 4);
                        recentPrice = this.ZERO.compareTo(recentQty) != 0 ? recentCost.divide(recentQty, pricePrecision, 4) : this.ZERO;
                        bf.append(recentQty).append(" * ").append(recentPrice).append(" = ").append(recentCost);
                        settleAccountsDesc = bf.toString();
                        bf.setLength(0);
                        pm.setString(1, incomeOrPayoutDesc);
                        pm.setString(2, null);
                        pm.setString(3, settleAccountsDesc);
                        pm.setString(4, id);
                        pm.addBatch();
                        ++count;
                    }
                }
                bf.append(rs.getString("FMaterialID")).append(rs.getString("FCompanyOrgUnitID"));
                if ("2".equals(strCalType)) {
                    bf.append(rs.getString("FStorageOrgUnitID")).append(rs.getString("FWarehouseID"));
                } else if ("1".equals(strCalType)) {
                    bf.append(rs.getString("FStorageOrgUnitID"));
                }
                firstKey = bf.toString();
                bf.setLength(0);
                if (count < 200) continue;
                pm.executeBatch();
                pm.clearBatch();
                count = 0;
            }
            if (count < 200) {
                pm.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pm);
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pm);
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
    }

    public StringBuffer clearOldPeriodData(PeriodInfo periodInfo, String strCalType, CalculateParams params) throws CalculateException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from T_CL_CostComputeReport ");
        sql.append(" where FAccountType = ").append(this.takeMaterialAccountType()[0].getValue());
        sql.append(" and ");
        sql.append(" ((FYear = ").append(periodInfo.getPeriodYear());
        sql.append(" and FPeriod >=").append(periodInfo.getPeriodNumber()).append(")");
        sql.append(" or (FYear > ").append(periodInfo.getPeriodYear()).append("))");
        sql.append(this.getFilterIDByCalType(strCalType, params, this.INVENTORY_FIELD_ID));
        if (!(params == null || StringUtil.isEmpty((String)params.getString("MATERIAL_FROM")) && StringUtil.isEmpty((String)params.getString("MATERIAL_TO")))) {
            sql.append(" and fmaterialid in (");
            sql.append(" select fid from T_BD_Material MATERIAL ");
            boolean hasStart = false;
            if (params != null && !StringUtil.isEmpty((String)params.getString("MATERIAL_FROM"))) {
                sql.append(" where MATERIAL.FNumber >= N'").append(params.getString("MATERIAL_FROM")).append("'").append("\t\n");
                hasStart = true;
            }
            if (params != null && !StringUtil.isEmpty((String)params.getString("MATERIAL_TO"))) {
                if (hasStart) {
                    sql.append(" and ");
                } else {
                    sql.append(" where ");
                }
                sql.append("  MATERIAL.FNumber <= N'").append(params.getString("MATERIAL_TO")).append("'").append("\t\n");
            }
            sql.append(" )").append("\t\n");
        }
        return sql;
    }

    private void handleCostPriceTransBill(Context ctx, String tmpTableName, String calType, SysTempTableHelper sysTempTableHelper) throws BOSException {
        if (!"2".equals(calType)) {
            sysTempTableHelper.execute(this.updateCostMoveIsCalcalate(tmpTableName, calType));
        }
    }

    private String updateCostMoveIsCalcalate(String tempReceiveSendTable, String calType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(tempReceiveSendTable);
        buffer.append(" SET FISCALCULATE = 0 ");
        buffer.append("\n WHERE FISCALCULATE =1");
        if ("0".equals(calType)) {
            buffer.append("\n AND FBIZTYPEID IN ('").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
            buffer.append(" ,'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("')");
        } else if ("1".equals(calType)) {
            buffer.append("\n AND FBIZTYPEID IN ('").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("')");
        }
        return buffer.toString();
    }
}

