/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.IssueTypeEnum;
import com.kingdee.eas.scm.cal.WriteOffCreateTypeEnum;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractArApCalculate;
import com.kingdee.eas.scm.cal.app.calculate.model.BillWrittenOffData;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateDiffAmt;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffGroup;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffHashMap;
import com.kingdee.eas.scm.cal.app.newutil.CostAdjustHelper;
import com.kingdee.eas.scm.cal.app.newutil.WriteOffHelper;
import com.kingdee.eas.scm.cal.newutil.CalConstant;
import com.kingdee.eas.scm.cal.newutil.CalculateUtil;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.framework.writeoff.IWriteOffCommonFacade;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryCollection;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryFactory;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonFacadeFactory;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class PurAccountPayableCalculate
extends AbstractArApCalculate {
    private static final String BEFOREPERIOD = "Before_Period_PurInWarehsBill";
    private static final String CURRANDAFTERPERIOD = "Current_Period_PurInwarehsBill";
    private Map costadjusthashmap = new HashMap();

    @Override
    public void calculateStrategy(Context ctx, CoreBillBaseInfo scminfo) throws BOSException, EASBizException {
        BizTypeInfo bizType;
        MappingConditionEntryCollection mappingEntryColl = MappingConditionEntryFactory.getLocalInstance((Context)ctx).getMappingConditionEntryCollection("SELECT id, isSameSideFirst, isMappingQtyAmt, mappingField.*, mainBillFilter, secBillFilter  WHERE mappingCondition.number = '001' AND isFlowWriteOff = 1 order by flowWriteOffSeq, mappingField.seq");
        FilterInfo mainFilter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(scminfo.getId().toString());
        mainFilter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        mainFilter.getFilterItems().add(new FilterItemInfo("entry.unWriteOffBaseQty", (Object)SysConstant.BIGZERO, CompareType.NOTEQUALS));
        mainFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        mainFilter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)3, CompareType.EQUALS));
        mainFilter.getFilterItems().add(new FilterItemInfo("billType", (Object)202, CompareType.EQUALS));
        mainFilter.getFilterItems().add(new FilterItemInfo("isBizBill", (Object)0, CompareType.EQUALS));
        FilterInfo secFilter = new FilterInfo();
        secFilter.setMaskString("1 = 1");
        secFilter.getFilterItems().add(new FilterItemInfo("entry.unwriteOffBaseQty", (Object)SysConstant.BIGZERO, CompareType.NOTEQUALS));
        secFilter.setMaskString(secFilter.getMaskString() + " AND #" + (secFilter.getFilterItems().size() - 1));
        secFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.companyOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        secFilter.setMaskString(secFilter.getMaskString() + " AND #" + (secFilter.getFilterItems().size() - 1));
        secFilter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        secFilter.setMaskString(secFilter.getMaskString() + " AND #" + (secFilter.getFilterItems().size() - 1));
        secFilter.setMaskString(secFilter.getMaskString() + " AND #" + (secFilter.getFilterItems().size() - 1));
        secFilter.getFilterItems().add(new FilterItemInfo("transactionType.isWriteOff", (Object)Boolean.TRUE, CompareType.EQUALS));
        secFilter.setMaskString(secFilter.getMaskString() + " AND #" + (secFilter.getFilterItems().size() - 1));
        this.dischargeType = CalculateUtil.getDischargeType(ctx, this.companyOrgUnitInfo.getId().toString());
        if (this.dischargeType != 0 && (this.periodInfo.getPeriodYear() != scminfo.getInt("year") || this.periodInfo.getPeriodNumber() != scminfo.getInt("period"))) {
            secFilter.getFilterItems().add(new FilterItemInfo("fiVouchered", (Object)Boolean.TRUE, CompareType.EQUALS));
            secFilter.setMaskString(secFilter.getMaskString() + " AND (#" + (secFilter.getFilterItems().size() - 1));
            secFilter.getFilterItems().add(new FilterItemInfo("isInitBill", (Object)Boolean.TRUE, CompareType.EQUALS));
            secFilter.setMaskString(secFilter.getMaskString() + " OR #" + (secFilter.getFilterItems().size() - 1));
            secFilter.getFilterItems().add(new FilterItemInfo("year * 100 + period >= " + (scminfo.getInt("year") * 100 + scminfo.getInt("period"))));
            secFilter.setMaskString(secFilter.getMaskString() + " OR #" + (secFilter.getFilterItems().size() - 1) + ")");
        }
        if ((bizType = (BizTypeInfo)scminfo.get("bizType")) != null) {
            this.isDevolve = BizTypeFactory.getLocalInstance((Context)ctx).exists("WHERE BIZCATEGORY in ('+f4mYqj4xUGaNf69/HWRdqk4kCA=', '6LFeB81CJ0mD3wyAekUV7Kk4kCA=') and id = '" + bizType.getId().toString() + "'");
        }
        WriteOffCommonParams params = new WriteOffCommonParams();
        params.put((Object)"isDevolve", (Object)this.isDevolve);
        params.setFlowWriteOff(true);
        params.setFlowWfBillId(scminfo.getId().toString());
        params.setFromMain(true);
        params.setStrategy("purWriteOff");
        params.setCompanyId(this.companyOrgUnitInfo.getId().toString());
        params.setMainEntityId("48DA3A71");
        params.setSecEntityId("783061E3");
        params.setMainQueryName("com.kingdee.eas.fi.ap.app.OtherBillQuery");
        params.setSecQueryName("com.kingdee.eas.scm.im.inv.PurInWarehsQuery");
        params.setMainEntryIdField("entry.id");
        params.setSecEntryIdField("entry.id");
        params.put((Object)"mainFilter", (Object)mainFilter);
        params.put((Object)"secFilter", (Object)secFilter);
        SorterItemCollection mainSorter = new SorterItemCollection();
        mainSorter.add(new SorterItemInfo("billDate"));
        params.put((Object)"mainSorter", (Object)mainSorter);
        SorterItemCollection secSorter = new SorterItemCollection();
        secSorter.add(new SorterItemInfo("bizDate"));
        secSorter.add(new SorterItemInfo("auditTime"));
        params.put((Object)"secSorter", (Object)secSorter);
        IWriteOffCommonFacade iWriteOffCommonFacade = WriteOffCommonFacadeFactory.getLocalInstance((Context)ctx);
        HashMap cacheMap = new HashMap();
        int size = mappingEntryColl.size();
        for (int i = 0; i < size; ++i) {
            params.put((Object)"mappingEntryInfo", (Object)mappingEntryColl.get(i));
            iWriteOffCommonFacade.flowWriteOff(params, mappingEntryColl, cacheMap);
        }
    }

    private void initParam(Context ctx, String bizTypeNumber) throws BOSException, EASBizException {
        String companyId = this.companyOrgUnitInfo.getId().toString();
        this.isMerageCostAdjust = CostAdjustHelper.isMergeCostAdjustBill(ctx, companyId);
        this.isDevolve = CalculateUtil.isDevolve(bizTypeNumber);
        String paramValue = CalculateUtil.getCalParamValue(ctx, companyId, "SCM_CAL_012");
        this.isAdjust = paramValue.equalsIgnoreCase("true");
        this.dischargeType = CalculateUtil.getDischargeType(ctx, companyId);
    }

    private boolean isCanWriteOff(Context ctx, CalculateWrittenOffBill writtenOffBill, CalculateWrittenOffHashMap hashmap) throws BOSException {
        boolean flag = false;
        if (writtenOffBill.isReversed() || this.dischargeType == 0) {
            return true;
        }
        int year = writtenOffBill.getPeriodYear();
        int period = writtenOffBill.getPeriod();
        if (this.periodInfo.getPeriodYear() == year && this.periodInfo.getPeriodNumber() == period) {
            return true;
        }
        flag = this.isHasVoucher(ctx, hashmap, writtenOffBill);
        return flag;
    }

    private boolean isHasVoucher(Context ctx, CalculateWrittenOffHashMap hashmap, CalculateWrittenOffBill writtenOffBill) throws BOSException {
        String purBillID = "111111111111111111111111111=";
        Iterator iter = hashmap.entrySet().iterator();
        int year = writtenOffBill.getPeriodYear();
        int period = writtenOffBill.getPeriod();
        HashSet<String> ids = new HashSet<String>();
        while (iter.hasNext()) {
            Map.Entry mapentry = iter.next();
            for (Map.Entry mapentrybill : ((CalculateWrittenOffGroup)mapentry.getValue()).entrySet()) {
                CalculateWrittenOffBill bill = (CalculateWrittenOffBill)mapentrybill.getValue();
                purBillID = bill.getId();
                ids.add(purBillID);
            }
        }
        StringBuffer sb = new StringBuffer();
        String sqlids = CalculateUtil.getSqlInString(ids);
        int invoicePeriod = year * 100 + period;
        sb.append(" select fid from T_IM_PurInWarehsbill where fid in( " + sqlids + ") and (ffiVouchered = 1 or fisinitbill = 1 or ( (fyear * 100 + fperiod ) >= " + invoicePeriod + ")) ");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString());
        return rs.size() > 0;
    }

    private WriteOffGroupInfo getWriteOffGroupInfo(Context ctx, Map writeoffGroupMap, CalculateWrittenOffBill writtenOffBill, CalculateWrittenOffEntry calculateWrittenOffEntry, CalculateWrittenOffHashMap hashmap) throws EASBizException, BOSException {
        WriteOffGroupInfo result = null;
        CalculateWrittenOffBill purBill = this.getWriteoffBillByEntry(calculateWrittenOffEntry, hashmap);
        if (purBill == null) {
            return result;
        }
        if (this.dischargeType == 0) {
            result = (WriteOffGroupInfo)writeoffGroupMap.get(CURRANDAFTERPERIOD);
            if (result == null) {
                result = this.createNewWriteOffGroupInfo(ctx, writtenOffBill);
                writeoffGroupMap.put(CURRANDAFTERPERIOD, result);
            }
            return result;
        }
        int billPeriod = purBill.getPeriodYear() * 100 + purBill.getPeriod();
        if (this.dischargeType == 2) {
            if (purBill.getIsInitBill() || billPeriod < this.periodInfo.getNumber()) {
                result = (WriteOffGroupInfo)writeoffGroupMap.get(BEFOREPERIOD);
                if (result == null) {
                    result = this.createNewWriteOffGroupInfo(ctx, writtenOffBill);
                    writeoffGroupMap.put(BEFOREPERIOD, result);
                }
            } else {
                result = (WriteOffGroupInfo)writeoffGroupMap.get(CURRANDAFTERPERIOD);
                if (result == null) {
                    result = this.createNewWriteOffGroupInfo(ctx, writtenOffBill);
                    writeoffGroupMap.put(CURRANDAFTERPERIOD, result);
                }
            }
        } else if (this.dischargeType == 1) {
            if (purBill.getIsInitBill()) {
                writtenOffBill.setIsInitBill(true);
                result = (WriteOffGroupInfo)writeoffGroupMap.get(BEFOREPERIOD);
                if (result == null) {
                    result = this.createNewWriteOffGroupInfo(ctx, writtenOffBill);
                    writeoffGroupMap.put(BEFOREPERIOD, result);
                }
            } else {
                writtenOffBill.setIsInitBill(false);
                result = (WriteOffGroupInfo)writeoffGroupMap.get(CURRANDAFTERPERIOD);
                if (result == null) {
                    writtenOffBill.setIsInitBill(false);
                    result = this.createNewWriteOffGroupInfo(ctx, writtenOffBill);
                    writeoffGroupMap.put(CURRANDAFTERPERIOD, result);
                }
            }
        }
        return result;
    }

    private CalculateWrittenOffBill getWriteoffBillByEntry(CalculateWrittenOffEntry entry, CalculateWrittenOffHashMap writeOffBillMap) {
        Iterator itbill;
        if (entry == null || writeOffBillMap == null) {
            return null;
        }
        CalculateWrittenOffBill result = null;
        CalculateWrittenOffGroup billMap = (CalculateWrittenOffGroup)writeOffBillMap.get(entry.getSourceIDKey());
        if (billMap != null && !billMap.isEmpty() && (result = (CalculateWrittenOffBill)billMap.get(entry.getSourceBillid())) != null) {
            return (CalculateWrittenOffBill)billMap.get(entry.getSourceBillid());
        }
        billMap = (CalculateWrittenOffGroup)writeOffBillMap.get(entry.getCoreIDKey());
        if (billMap != null && !billMap.isEmpty() && (itbill = billMap.entrySet().iterator()).hasNext()) {
            Map.Entry mapentry = itbill.next();
            result = (CalculateWrittenOffBill)mapentry.getValue();
        }
        return result;
    }

    private WriteOffGroupInfo createNewWriteOffGroupInfo(Context ctx, CalculateWrittenOffBill writtenOffBill) throws EASBizException, BOSException {
        WriteOffGroupInfo writeoffgroupinfo = new WriteOffGroupInfo();
        WriteOffCreateTypeEnum createType = this.isDevolve ? WriteOffCreateTypeEnum.DEV_AUTO_WRITEOFF : WriteOffCreateTypeEnum.AUTO_WRITEOFF;
        WriteOffHelper.createWrittenOffGroup(ctx, this.companyOrgUnitInfo, this.takeOutOrInWarehouseKind(), null, writtenOffBill, writeoffgroupinfo, createType, this.dischargeType);
        return writeoffgroupinfo;
    }

    @Override
    protected String getInventoryBillWhereSQL(Context ctx, String billID) throws BOSException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(" Where Entry.FCompanyOrgUnitId = '").append(this.companyOrgUnitInfo.getId().toString()).append("'");
        sSQL.append(" and Bill.FBaseStatus = ").append(4);
        sSQL.append(" and TransType.FIsWriteOff = 1 ");
        sSQL.append(" and Entry.FUnWriteOffQty <> 0 ");
        String orderEntryId = this.takeBillEntryCoreBillEntryId(ctx, billID, this.srcEntryTableName, "FCoreBillEntryId");
        if (!StringUtil.isEmpty((String)orderEntryId)) {
            sSQL.append(" and Entry.FPurOrderEntryID in (").append(orderEntryId).append(")");
        } else {
            String srcEntryId = this.takeBillEntryCoreBillEntryId(ctx, billID, this.srcEntryTableName, "FSourceBillEntryId");
            if (!StringUtil.isEmpty((String)srcEntryId)) {
                sSQL.append(" and Entry.FID in (").append(srcEntryId).append(")");
            } else {
                sSQL.append(" and 1 = 2");
            }
        }
        return sSQL.toString();
    }

    @Override
    protected String getExtendInvBillSelector() {
        return this.getExtendPurInBillSelector();
    }

    @Override
    protected CalculateKindEnum takeOutOrInWarehouseKind() throws EASBizException, BOSException {
        return CalculateKindEnum.INPUT_WAREHOUSE;
    }

    @Override
    protected boolean writeOffEntry(Context ctx, CalculateWrittenOffEntry apEntry, CalculateWrittenOffEntry invEntry, CalculateWrittenOffBill invBill, WriteOffGroupInfo writeoffgroupinfo, CalculateWrittenOffBill apBill, BigDecimal[] writeOffQtyAndAmount) throws EASBizException, BOSException {
        boolean isFullWriteOff = false;
        if (apEntry.getUnWriteOffQty().compareTo(CalConstant.ZERO) == 0 && !invEntry.isFullWriteOff() && !apEntry.isFullWriteOff()) {
            return isFullWriteOff;
        }
        BigDecimal diffSum = CalConstant.ZERO.setScale(apEntry.getAmount().scale());
        if (!this.billwriteoff.isCanWriteOff(apEntry, invEntry)) {
            return isFullWriteOff;
        }
        invEntry.setNeedRetWriteUnitCost(this.isNeedReWriteCost(invBill, invEntry));
        BillWrittenOffData bwod = this.billwriteoff.calculateWriteOffDiffAmt(invEntry, apEntry);
        BigDecimal writeOffQty = bwod.getWriteOffQty();
        BigDecimal writeOffAmtInvo = bwod.getWriteOffAmtInvo();
        BigDecimal writeOffAmtBill = bwod.getWriteOffAmtBill();
        isFullWriteOff = bwod.isFullWriteOff();
        diffSum = writeOffAmtInvo.subtract(writeOffAmtBill);
        writeOffQtyAndAmount[0] = writeOffQtyAndAmount[0].add(writeOffQty);
        writeOffQtyAndAmount[1] = writeOffQtyAndAmount[1].add(writeOffAmtInvo);
        BigDecimal qty = bwod.isFullWriteOff() ? bwod.getWriteOffQtyBill() : writeOffQty;
        WriteOffHelper.createWrittenOffRecord(ctx, writeoffgroupinfo, qty, writeOffAmtBill, invEntry.getBaseUnitPrice(), invBill, invEntry, null);
        apEntry.setCurrWriteOffAmt(writeOffAmtInvo);
        apEntry.setCurrWriteOffQty(writeOffQty);
        invEntry.setCurrWriteOffAmt(writeOffAmtBill);
        invEntry.setCurrWriteOffQty(writeOffQty);
        this.turnOverNoteWriteOffInfo(ctx, invEntry);
        if (invEntry.isNeedRetWriteUnitCost() && bwod.isNeedReCalculte()) {
            boolean isCanRewriteExchangeRate;
            boolean isEqualExchangeRate = this.isEqualExchangeRate(invBill, apBill);
            boolean bl = isCanRewriteExchangeRate = !isEqualExchangeRate && this.isBillUnWriteOff(ctx, invBill) && !this.hasMoveMateiral(ctx, invBill);
            if (this.isFullWriteOff(invEntry, apEntry)) {
                if (isEqualExchangeRate || isCanRewriteExchangeRate) {
                    boolean isLocalCurrency = invEntry.getCurrencyID().equals(this.companyOrgUnitInfo.getBaseCurrency().getId().toString());
                    this.purInwareBillUpdate4FullWriteOff(this.getUpdatePurSQL(invEntry.getId(), apEntry.getId(), isLocalCurrency));
                    this.purInwareBillUpdate4FullWriteOff(this.getUpdatePurCostSQL(invEntry.getId(), apEntry.getId()));
                }
                if (isCanRewriteExchangeRate) {
                    this.purInwareBillUpdate4FullWriteOff(this.getUpdateExchangerRateSQL(invBill.getId(), apBill.getExchangeRate()));
                }
            } else {
                this.needReCalcPurInEntryIdList.add(invEntry.getId());
            }
        }
        Vector vDiffSum = new Vector();
        if (!invEntry.isNeedRetWriteUnitCost() && this.isNeedCreateCostAdjBill(diffSum, invBill, apBill)) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("writeOffNoteSeq", new Integer(invEntry.getSeq()));
            infoMap.put("diffSum", diffSum);
            infoMap.put("OtherbillPrice", apEntry.getBaseUnitPrice());
            infoMap.put("writetenOff_Entry", apEntry);
            vDiffSum.add(infoMap);
        }
        CalculateDiffAmt cDiffSum = new CalculateDiffAmt();
        cDiffSum.setDiffAmtTotale(diffSum);
        cDiffSum.setVDiffAmt(vDiffSum);
        this.createCostAdjustBill(ctx, cDiffSum, invEntry, invBill, writeoffgroupinfo, apBill);
        if (invEntry.isNeedRetWriteUnitCost() && CalConstant.ZERO.compareTo(invEntry.getReverseQty()) < 0) {
            this.handleFullReverseBill(ctx, invEntry, this.isDevolve);
        }
        return isFullWriteOff;
    }

    protected void createCostAdjustBill(Context ctx, CalculateDiffAmt cDiffSum, CalculateWrittenOffEntry invEntry, CalculateWrittenOffBill invBill, WriteOffGroupInfo writeoffgroupinfo, CalculateWrittenOffBill apBill) throws EASBizException, BOSException {
        CostAdjustBillInfo costadjustbillinfo = null;
        String costadjustbillKey = invEntry.getStorageOrg().getId().toString();
        if (this.costadjusthashmap.get(costadjustbillKey) == null) {
            costadjustbillinfo = CostAdjustHelper.createCostAdjustBill(ctx, this.companyOrgUnitInfo, invEntry.getStorageOrg(), this.takeCalculatePeriod(apBill, invBill, this.periodInfo), apBill.getSupplier(), this.takeOutOrInWarehouseKind(), invBill, this.isDevolve);
            this.costadjusthashmap.put(costadjustbillKey, costadjustbillinfo);
        } else {
            costadjustbillinfo = (CostAdjustBillInfo)this.costadjusthashmap.get(costadjustbillKey);
        }
        this.dealCostAdjust(ctx, cDiffSum, invBill, invEntry, writeoffgroupinfo, costadjustbillinfo);
    }

    private void autoCreateCostAdjBill(Context ctx, CalculateWrittenOffBill writtenOffBill) throws BOSException, EASBizException {
        String selStorageOrgSql = "select distinct a.FId, c.FStorageOrgUnitid, c.FWarehouseId, c.FLot, c.FLocationID as FLocationID from t_ap_otherbillentry a inner join t_ap_otherbillentry b on b.fid=a.fsourcebillentryid inner join t_im_purinwarehsentry c on c.fid=b.fsourcebillentryid where a.fparentid = ''{0}''";
        String updateApportionAmount = "update t_ap_otherbillentry set FUnApportionAmount = 0, FApportionAmount = FAmountLocal where FId = ''{0}''";
        String sSQL = MessageFormat.format("select distinct a.FId, c.FStorageOrgUnitid, c.FWarehouseId, c.FLot, c.FLocationID as FLocationID from t_ap_otherbillentry a inner join t_ap_otherbillentry b on b.fid=a.fsourcebillentryid inner join t_im_purinwarehsentry c on c.fid=b.fsourcebillentryid where a.fparentid = ''{0}''", writtenOffBill.getId());
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        HashMap costAdjBillMap = new HashMap();
        ArrayList<String> sqlList = new ArrayList<String>();
        try {
            while (rs.next()) {
                CostAdjustBillInfo costBillInfo = this.getCostAdjustBillInfo(ctx, rs, writtenOffBill, costAdjBillMap);
                this.createCostAdjEntry(costBillInfo, rs, writtenOffBill);
                sSQL = MessageFormat.format("update t_ap_otherbillentry set FUnApportionAmount = 0, FApportionAmount = FAmountLocal where FId = ''{0}''", rs.getString("FId"));
                sqlList.add(sSQL);
            }
            if (sqlList.size() > 0) {
                DBUtil.execBatchSql(ctx, sqlList, true);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ICostAdjustBill costadjust = CostAdjustBillFactory.getLocalInstance(ctx);
        for (Map.Entry entry : costAdjBillMap.entrySet()) {
            CostAdjustBillInfo costInfo = (CostAdjustBillInfo)entry.getValue();
            if (costInfo.getEntry().size() <= 0) continue;
            IObjectPK id = costadjust.addnew((CoreBaseInfo)costInfo);
            costadjust.audit(id);
        }
    }

    private CostAdjustBillInfo getCostAdjustBillInfo(Context ctx, IRowSet rs, CalculateWrittenOffBill writtenOffBill, HashMap costAdjBillMap) throws SQLException {
        String storageId = rs.getString("FStorageOrgUnitid");
        CostAdjustBillInfo costBill = (CostAdjustBillInfo)costAdjBillMap.get(storageId);
        if (costBill == null) {
            costBill = new CostAdjustBillInfo();
            costBill.setId(BOSUuid.create((String)"8FA62986"));
            costBill.setNumber("JDTZ-" + writtenOffBill.getNumber());
            costBill.setIssueType(IssueTypeEnum.NULL);
            costBill.setCreateType(CostAdjuestCreateTypeEnum.APPORTION_EXPENSE);
            costBill.setCalculateKind(CalculateKindEnum.INPUT_WAREHOUSE);
            SupplierInfo supplier = null;
            String supplierId = writtenOffBill.getSupplier();
            if (supplierId != null && supplierId.length() > 0) {
                supplier = new SupplierInfo();
                supplier.setId(BOSUuid.read((String)supplierId));
            }
            costBill.setSupplier(supplier);
            StorageOrgUnitInfo storage = new StorageOrgUnitInfo();
            storage.setId(BOSUuid.read((String)storageId));
            costBill.setStorageOrgUnit(storage);
            AdminOrgUnitInfo adminOrg = null;
            String adminOrgId = writtenOffBill.getAdminOrgUnit();
            if (adminOrgId != null && adminOrgId.length() > 0) {
                adminOrg = new AdminOrgUnitInfo();
                adminOrg.setId(BOSUuid.read((String)adminOrgId));
            }
            costBill.setAdminOrgUnit(adminOrg);
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552"));
            costBill.setBillType(billType);
            BillTypeInfo sourceBillType = new BillTypeInfo();
            sourceBillType.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-010fc0a812fd463ED552"));
            costBill.setSourceBillType(sourceBillType);
            costBill.setSourceBillId(writtenOffBill.getId());
            costBill.setYear(writtenOffBill.getPeriodYear());
            costBill.setPeriod(writtenOffBill.getPeriod());
            costBill.setBizDate(writtenOffBill.getBizDate());
            costBill.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            costBill.setCreateTime(new Timestamp(System.currentTimeMillis()));
            costBill.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            costBill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            costBill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            costAdjBillMap.put(storageId, costBill);
        }
        return costBill;
    }

    private void createCostAdjEntry(CostAdjustBillInfo costBill, IRowSet rs, CalculateWrittenOffBill writtenOffBill) throws SQLException {
        ArrayList entryList = writtenOffBill.getEntry();
        CalculateWrittenOffEntry entry = null;
        String entryId = rs.getString("FId");
        for (int i = 0; i < entryList.size() && !(entry = (CalculateWrittenOffEntry)entryList.get(i)).getId().equals(entryId); ++i) {
        }
        CostAdjustBillEntryInfo costBillEntryInfo = new CostAdjustBillEntryInfo();
        costBillEntryInfo.setId(BOSUuid.create((String)"2774F28C"));
        costBillEntryInfo.setParent(costBill);
        costBillEntryInfo.setSeq(costBill.getEntry().size() + 1);
        costBillEntryInfo.setStorageOrgUnit(costBill.getStorageOrgUnit());
        WarehouseInfo warehouse = null;
        String warehouseId = rs.getString("FWarehouseId");
        if (warehouseId != null && warehouseId.length() > 0) {
            warehouse = new WarehouseInfo();
            warehouse.setId(BOSUuid.read((String)warehouseId));
        }
        costBillEntryInfo.setWarehouse(warehouse);
        costBillEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        costBillEntryInfo.setBaseQty(new BigDecimal("0.0"));
        if (entry != null) {
            costBillEntryInfo.setCompanyOrgUnit(entry.getFinanceOrg());
            costBillEntryInfo.setMaterial(entry.getMaterial());
            costBillEntryInfo.setBaseUnit(entry.getMaterialBaseUnit());
            costBillEntryInfo.setUnit(entry.getMaterialBaseUnit());
            costBillEntryInfo.setSourceBillId(entry.getParentid());
            costBillEntryInfo.setSourceBillEntryId(entry.getId());
            costBillEntryInfo.setSourceBillNumber(entry.getNumber());
            costBillEntryInfo.setSourceBillEntrySeq(entry.getSeq());
            costBillEntryInfo.setAmount(entry.getActualCost());
            costBillEntryInfo.setStandardCost(entry.getActualCost());
            costBillEntryInfo.setActualCost(entry.getActualCost());
            if (entry.getProjectID() != null) {
                ProjectInfo project = new ProjectInfo();
                project.setId(BOSUuid.read((String)entry.getProjectID()));
                costBillEntryInfo.setProject(project);
            }
            if (entry.getTrackNumberID() != null) {
                TrackNumberInfo trackNumber = new TrackNumberInfo();
                trackNumber.setId(BOSUuid.read((String)entry.getTrackNumberID()));
                costBillEntryInfo.setTrackNumber(trackNumber);
            }
        }
        if (this.isAdjust) {
            costBillEntryInfo.setLot(rs.getString("FLot"));
            if (entry != null) {
                costBillEntryInfo.setAssistProperty(entry.getAssistProperty());
            }
        }
        StoreTypeInfo storeType = new StoreTypeInfo();
        storeType.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-0111c0a812fd97D461A6"));
        StoreStateInfo storeState = new StoreStateInfo();
        storeState.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
        LocationInfo locationInfo = new LocationInfo();
        locationInfo.setId(BOSUuid.read((String)rs.getString("FLocationID")));
        costBillEntryInfo.setStoreType(storeType);
        costBillEntryInfo.setStoreStatus(storeState);
        costBillEntryInfo.setLocation(locationInfo);
        costBill.getEntry().add(costBillEntryInfo);
    }

    private String getUpdatePurSQL(String purEntryID, String otherEntryID, boolean isLocalCurrency) {
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_IM_PurInWarehsEntry as t set ( ");
        sb.append(" FPrice,");
        sb.append(" FTaxPrice,");
        sb.append(" FActualPrice,");
        sb.append(" FActualTaxPrice,");
        sb.append(" FPurchaseCost,");
        sb.append(" FUnitPurchaseCost,");
        sb.append(" FAmount,");
        sb.append(" FTax,");
        sb.append(" FLocalTax,");
        sb.append(" FTaxAmount,");
        sb.append(" FLocalTaxAmount )  ");
        sb.append(" = (select entry.FPrice,");
        sb.append("  entry.FTaxPrice,");
        sb.append("  entry.FRealPrice,");
        sb.append("  entry.FactualPrice,");
        sb.append("  entry.FAmountLocal,");
        if (isLocalCurrency) {
            sb.append("  entry.FRealPrice,");
        } else {
            sb.append("  ROUND(TO_DECIMAL(entry.FAmountLocal/entry.Fquantity,21,8),mt.FPriceprecision ),");
        }
        sb.append("  entry.FAmount,");
        sb.append("  entry.FTaxAmount,");
        sb.append("  entry.FTaxAmountLocal,");
        sb.append("  entry.FRecievePayAmount,");
        sb.append("  entry.FRecievePayAmountLocal ");
        sb.append("  from T_AP_Otherbillentry as entry inner join T_BD_Material mt on entry.fmaterialid = mt.fid ");
        sb.append(" where entry.fid = '").append(otherEntryID).append("' ) ");
        sb.append(" where t.fid = '").append(purEntryID).append("'");
        return sb.toString();
    }

    private String getUpdatePurCostSQL(String purEntryID, String otherEntryID) {
        StringBuffer sb = new StringBuffer();
        sb.append("  update T_IM_PurInWarehsEntry as t set (FActualCost,FUnitActualCost) =  ");
        sb.append("  ( select isnull(t1.FPurchaseCost,0) + isnull(t1.FPurchaseFee,0) + isnull(t1.FMaterialCost,0), ");
        sb.append("    case isnull(t1.FPurchaseFee,0) + isnull(t1.FMaterialCost,0) when  0 then  t1.FUnitPurchaseCost else ");
        sb.append("  ROUND(TO_DECIMAL(t1.FActualCost/t1.Fqty,21,8),t2.FPriceprecision ) end ");
        sb.append("  from T_IM_PurInWarehsEntry t1 inner join T_BD_Material t2 on t1.fmaterialid=t2.fid ");
        sb.append(" where t1.fid =  '").append(purEntryID).append("' )");
        sb.append(" where t.fid = '").append(purEntryID).append("' ");
        return sb.toString();
    }

    private String getUpdateExchangerRateSQL(String purID, BigDecimal exchangeRate) {
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_IM_PurInWarehsBill set FExchangeRate = ").append(exchangeRate.toString());
        sb.append(" where fid = '").append(purID).append("'");
        return sb.toString();
    }

    protected boolean isFullWriteOff(CalculateWrittenOffEntry invEntry, CalculateWrittenOffEntry apEntry) {
        return invEntry.getBaseUnitQty() != null && invEntry.getBaseUnitQty().compareTo(apEntry.getBaseUnitQty()) == 0 && invEntry.getBaseUnitQty().compareTo(apEntry.getWrittenOffQty()) == 0 && invEntry.getTaxRate() != null && invEntry.getTaxRate().compareTo(apEntry.getTaxRate()) == 0 && invEntry.getDiscountAmount() != null && invEntry.getDiscountAmount().compareTo(apEntry.getDiscountAmount()) == 0 && invEntry.getDiscountRate() != null && invEntry.getDiscountRate().compareTo(apEntry.getDiscountRate()) == 0 && invEntry.getCurrencyID() != null && invEntry.getCurrencyID().equals(apEntry.getCurrencyID()) && invEntry.getMaterialUnit() != null && invEntry.getMaterialUnit().equals((Object)apEntry.getMaterialUnit());
    }

    private boolean isEqualExchangeRate(CalculateWrittenOffBill invBill, CalculateWrittenOffBill apBill) {
        return invBill.getExchangeRate().compareTo(apBill.getExchangeRate()) == 0;
    }
}

