/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.common.perf.IJobInstStatusFacade;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.ICostAdjustBillEntry;
import com.kingdee.eas.scm.cal.IssueTypeEnum;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculateCost;
import com.kingdee.eas.scm.cal.app.calculate.interfaces.IDBExtends;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculatePrecision;
import com.kingdee.eas.scm.cal.app.help.CostAdjustHelp;
import com.kingdee.eas.scm.cal.app.help.CostComputeHelp;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class StandardCostDiffCalculate
extends AbstractCalculateCost
implements IDBExtends {
    private static Logger logger = Logger.getLogger(StandardCostDiffCalculate.class);
    private final int MAX_ENTRY_SIZE = 1000;
    private final BigDecimal ZERO = new BigDecimal("0.00");
    private CountDownLatch countDown;
    private final String keyMarkStr = "_$$$_";
    private final String keyNullStr = "NULL";

    @Override
    protected boolean calculateStrategy(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        logger.debug((Object)"============\u6807\u51c6\u8ba1\u4ef7\u6cd5\u6838\u7b97\u5f00\u59cb==============");
        LowTimer timer = new LowTimer();
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        timer.reset();
        HashMap<String, String> costadjustNumber = new HashMap<String, String>();
        costadjustNumber.put("costadjustNumber", "");
        if (this.isExistVouchered(ctx, sysTempTableHelper, periodInfo, strCalType, params, costadjustNumber)) {
            throw new CalculateException(CalculateException.COST_ADJUST_VOUCHERED_IS_EXIST, new String[]{CalculateUtil.takeFormateDesc(periodInfo.getPeriodYear() + "." + periodInfo.getPeriodNumber()), CalculateUtil.takeFormateDesc(costadjustNumber.get("costadjustNumber").toString())});
        }
        logger.info((Object)("\u5224\u65ad\u5f53\u671f\u662f\u5426\u5b58\u5728\u5206\u644a\u751f\u6210\u7684\u6210\u672c\u8c03\u6574\u5355\u5df2\u751f\u6210\u51ed\u8bc1\u65f6\u95f4\uff1a" + timer.msValue()));
        timer.reset();
        this.calcDiffZero(ctx, params, strCalType, periodInfo);
        logger.info((Object)("\u6807\u51c6\u6210\u672c\u5c3e\u5dee\u8c03\u6574\u65f6\u95f4\uff1a" + timer.msValue()));
        Connection conn = null;
        String tempTableName = null;
        String diffRateTempTable = null;
        String issueTempTable = null;
        String incomeStandCostTempTab = null;
        conn = sysTempTableHelper.getConn();
        tempTableName = sysTempTableHelper.createTempTable(ctx, this.getTempTableFields());
        sysTempTableHelper.createTempTableIndex(tempTableName, "FID", true, false);
        diffRateTempTable = sysTempTableHelper.createTempTable(ctx, this.getDiffRateTempTableFields());
        sysTempTableHelper.createTempTableIndex(diffRateTempTable, "FID", true, false);
        issueTempTable = sysTempTableHelper.createTempTable(ctx, this.getIssueTempTableFields());
        sysTempTableHelper.createTempTableIndex(issueTempTable, "FID", true, false);
        String jobId = (String)ctx.get((Object)"SCM_JOB_INST_ID");
        IJobInstStatusFacade iJobInstStatusFacade = JobInstStatusFacadeFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 5, "", ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"247_PutDataToTempTable", (Locale)this.l2), ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"247_PutDataToTempTable", (Locale)this.l3));
        }
        incomeStandCostTempTab = sysTempTableHelper.createTempTable(ctx, this.getIncomeStandCostTempTableFields());
        params.setString("diffRateTempTable", diffRateTempTable);
        params.setString("issueTempTable", issueTempTable);
        params.setString("incomeStandCostTempTab", incomeStandCostTempTab);
        params.setBoolean("isFromStandrad", true);
        StringBuffer sqlsum = this.takeMaterialDiffRateList(ctx, periodInfo, strCalType, Local_Currency_Presision, params, sysTempTableHelper);
        timer.reset();
        StringBuffer columns = new StringBuffer("FMaterialID,FCompanyOrgUnitID");
        if (!"0".equals(strCalType)) {
            columns.append(",FStorageOrgUnitID");
        }
        if ("2".equals(strCalType)) {
            columns.append(",FWarehouseID");
        }
        sysTempTableHelper.createTempTableIndex(tempTableName, columns.toString(), false, false);
        sysTempTableHelper.execute("insert into " + tempTableName + " " + sqlsum.toString());
        sysTempTableHelper.analyzeTable(tempTableName);
        logger.info((Object)("\u8ba1\u7b97\u5404\u51fa\u5e93\u5355\u5206\u644a\u6210\u672c\u65f6\u95f4\uff1a" + timer.msValue()));
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 15, "", ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"255_CostCalculating", (Locale)this.l2), ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"255_CostCalculating", (Locale)this.l3));
        }
        timer.reset();
        sysTempTableHelper.execute(this.updatePayOutSumQtyAndAmount_OP(strCalType, tempTableName));
        logger.info((Object)("\u66f4\u65b0\u7269\u6599\u7684\u603b\u53d1\u51fa\u6570\u91cf\u548c\u603b\u53d1\u51fa\u6210\u672c\u65f6\u95f4\uff1a" + timer.msValue()));
        timer.reset();
        this.clearOldPeriodData(sysTempTableHelper, params, strCalType);
        logger.info((Object)("\u6e05\u9664\u5386\u53f2\u5206\u644a\u751f\u6210\u7684\u6210\u672c\u8c03\u6574\u5355\u65f6\u95f4\uff1a" + timer.msValue()));
        this.processTotalIssueCost(sysTempTableHelper, params, strCalType, tempTableName);
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 70, "", ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"258_DealComputeReport", (Locale)this.l2), ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"258_DealComputeReport", (Locale)this.l3));
        }
        LowTimer calcuateTimer = new LowTimer();
        int materialPage = this.getMaterialPageCount(sysTempTableHelper, tempTableName);
        this.countDown = new CountDownLatch(materialPage);
        int threadNum = this.getThreadPoolNum(ctx);
        ExecutorService executor = Executors.newFixedThreadPool(threadNum);
        for (int i = 0; i < materialPage; ++i) {
            CalculateThreadForWeightedStandardCost calThread = new CalculateThreadForWeightedStandardCost(ctx, params, sysTempTableHelper, conn, periodInfo, i * 1000, tempTableName, strCalType);
            executor.execute(calThread);
        }
        try {
            this.countDown.await();
        }
        catch (InterruptedException e) {
            logger.info((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        executor.shutdown();
        if (this.ExceptionList.size() > 0) {
            logger.info(this.ExceptionList.get(0));
            throw new BOSException((Throwable)this.ExceptionList.get(0));
        }
        logger.info((Object)("\u8ba1\u7b97\u6210\u672c\u603b\u65f6\u95f4\uff1a" + calcuateTimer.msValue()));
        sysTempTableHelper.releaseTempTable(diffRateTempTable);
        sysTempTableHelper.releaseTempTable(issueTempTable);
        sysTempTableHelper.releaseTempTable(incomeStandCostTempTab);
        return false;
    }

    private void processTotalIssueCost(SysTempTableHelper sysTempTableHelper, CalculateParams params, String strCalType, String tempTableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempTableName);
        sql.append(" TA set FTotalIssueCost = (select TB.FTotalIssCost from ");
        sql.append("(select sum(FIssueCostDiffAmt)+ sum(FISSUECOSTAMT) as FTotalIssCost, FCompanyOrgUnitID");
        if (!"0".equals(strCalType)) {
            sql.append(", FStorageOrgUnitID");
        }
        if ("2".equals(strCalType)) {
            sql.append(", FWarehouseID ");
        }
        sql.append(",FMaterialId from ").append(tempTableName);
        sql.append(" group by FCompanyOrgUnitID");
        if (!"0".equals(strCalType)) {
            sql.append(", FStorageOrgUnitID");
        }
        if ("2".equals(strCalType)) {
            sql.append(", FWarehouseID");
        }
        sql.append(", FMaterialId)TB where TA.FCompanyOrgUnitID = TB.FCompanyOrgUnitID ");
        if (!"0".equals(strCalType)) {
            sql.append(" and TA.FStorageOrgUnitID = TB.FStorageOrgUnitID");
        }
        if ("2".equals(strCalType)) {
            sql.append(" and  TA.FWarehouseID = TB.FWarehouseID");
        }
        sql.append(" and TA.FMaterialId = TB.FMaterialId)");
        sysTempTableHelper.execute(sql.toString());
    }

    private String updatePayOutSumQtyAndAmount_OP(String strCalType, String tempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(tempTableName).append(" AS T");
        sql.append(" SET (FPayoutSumQty,FIssueCostSumAmt) = (");
        sql.append(" SELECT temp.FQty,temp.FAmount from (");
        sql.append(" SELECT ");
        sql.append(this.getGroupSegmentByCalType(strCalType, true, this.INVENTORY_FIELD_NEW));
        sql.append(" sum(FPayoutQty) as FQty,sum(FIssueCostAmt) as FAmount");
        sql.append(" FROM ").append(tempTableName).append(" as Entry GROUP BY ");
        sql.append(this.getGroupSegmentByCalType(strCalType, false, this.INVENTORY_FIELD_NEW));
        sql.append(" ) as temp where Temp.FMaterialID = T.FMaterialID");
        sql.append(" and Temp.FCompanyOrgUnitID = T.FCompanyOrgUnitID");
        if (!"0".equals(strCalType)) {
            sql.append(" and Temp.FStorageOrgUnitID = T.FStorageOrgUnitID");
        }
        if ("2".equals(strCalType)) {
            sql.append(" and Temp.FWarehouseID = T.FWarehouseID");
        }
        sql.append(" )");
        return sql.toString();
    }

    private void calcDiffZero(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("COMPANY_OBJ");
        if (companyOrgUnitInfo == null) {
            return;
        }
        StringBuffer where = new StringBuffer(" WHERE ENTRY.FCompanyOrgUnitID = '" + companyOrgUnitInfo.getId().toString() + "' ");
        Set storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
        Set wareHouseIds = (Set)params.getObject("WAREHOUSEID");
        if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
            String orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
            where.append(" AND ENTRY.FStorageOrgUnitID").append(" in ").append(orgIds);
        }
        if (wareHouseIds != null && wareHouseIds.size() > 0) {
            String warehouseIds = CalculateUtil.getSqlIn(wareHouseIds);
            where.append(" AND ENTRY.FWarehouseID").append(" in ").append(warehouseIds);
        }
        where.append(" AND MACO.FACCOUNTTYPE = 2 AND TR.FIsCalculate = 1 " + this.takeMaterialNumberWhereSQL(params).toString());
        where.append(" AND BILL.FYEAR = " + periodInfo.getPeriodYear() + " AND BILL.FPERIOD = " + periodInfo.getPeriodNumber());
        where.append(" AND BILL.FBaseStatus = 4 ");
        where.append(" AND sType.FIsForwardAmt = 1 ");
        String groupby = "";
        String select = "";
        String insertFiled = "";
        if ("0".equals(strCalType)) {
            select = "SELECT ENTRY.FCompanyOrgUnitID AS FCompanyOrgUnitID,ENTRY.FMaterialID AS FMaterialID ";
            groupby = " GROUP BY ENTRY.FCompanyOrgUnitID,ENTRY.FMaterialID";
            insertFiled = " (FCompanyOrgUnitID,FMaterialID,FQTY,FStandardCost) ";
        } else if ("1".equals(strCalType)) {
            select = "SELECT ENTRY.FCompanyOrgUnitID AS FCompanyOrgUnitID,ENTRY.FStorageOrgUnitID AS FStorageOrgUnitID,ENTRY.FMaterialID AS FMaterialID";
            groupby = " GROUP BY ENTRY.FCompanyOrgUnitID,ENTRY.FStorageOrgUnitID,ENTRY.FMaterialID";
            insertFiled = " (FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID,FQTY,FStandardCost) ";
        } else {
            select = "SELECT ENTRY.FCompanyOrgUnitID AS FCompanyOrgUnitID,ENTRY.FStorageOrgUnitID AS FStorageOrgUnitID,ENTRY.FWarehouseID AS FWarehouseID,ENTRY.FMaterialID AS FMaterialID";
            groupby = " GROUP BY ENTRY.FCompanyOrgUnitID,ENTRY.FStorageOrgUnitID,ENTRY.FWarehouseID,ENTRY.FMaterialID";
            insertFiled = " (FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FMaterialID,FQTY,FStandardCost) ";
        }
        String selectIn = select + ",SUM(ENTRY.FBaseQty) AS FBaseQty,SUM(ENTRY.FStandardCost) AS FStandardCost";
        String selectOut = select + ",SUM(ENTRY.FBaseQty)*(-1) AS FBaseQty,SUM(ENTRY.FStandardCost)*(-1) AS FStandardCost";
        String having = " HAVING SUM(ENTRY.FStandardCost) <> 0 ";
        sql.append(selectIn + this.getInvTableSql("T_IM_PurInWarehsEntry", "T_IM_PurInWarehsBill", true) + where + groupby + having);
        sql.append("\r\n UNION ALL \r\n");
        sql.append(selectIn + this.getInvTableSql("T_IM_ManufactureRecBillEntry", "T_IM_ManufactureRecBill", true) + where + groupby + having);
        sql.append("\r\n UNION ALL \r\n");
        sql.append(selectIn + this.getInvTableSql("T_IM_MoveInWarehsBillEntry", "T_IM_MoveInWarehsBill", true) + where + groupby + having);
        sql.append("\r\n UNION ALL \r\n");
        sql.append(selectIn + this.getInvTableSql("T_IM_OtherInWarehsBillEntry", "T_IM_OtherInWarehsBill", true) + where + groupby + having);
        sql.append("\r\n UNION ALL \r\n");
        sql.append(selectOut + this.getInvTableSql("T_IM_SaleIssueEntry", "T_IM_SaleIssueBill", false) + where + groupby + having);
        sql.append("\r\n UNION ALL \r\n");
        sql.append(selectOut + this.getInvTableSql("T_IM_MaterialReqBillEntry", "T_IM_MaterialReqBill", false) + where + groupby + having);
        sql.append("\r\n UNION ALL \r\n");
        sql.append(selectOut + this.getInvTableSql("T_IM_MoveIssueBillEntry", "T_IM_MoveIssueBill", false) + where + groupby + having);
        sql.append("\r\n UNION ALL \r\n");
        sql.append(selectOut + this.getInvTableSql("T_IM_OtherIssueBillEntry", "T_IM_OtherIssueBill", false) + where + groupby + having);
        sql.append("\r\n UNION ALL \r\n");
        sql.append(this.getStockSql(params, strCalType, periodInfo));
        String sumSelect = selectIn.replaceAll("ENTRY", "TEMP");
        String sumGroupby = groupby.replaceAll("ENTRY", "TEMP");
        long time1 = System.currentTimeMillis();
        String sumSQL = sumSelect + " FROM (" + sql.toString() + ") AS TEMP " + sumGroupby + " HAVING SUM(TEMP.FStandardCost) <> 0 AND SUM(TEMP.FBaseQty) = 0";
        String tmpTable = DBUtil.createTempTable(ctx, "calcDiffZero", this.getCal2ZeroFields());
        DbUtil.execute((Context)ctx, (String)("insert into " + tmpTable + insertFiled + sumSQL));
        long time2 = System.currentTimeMillis();
        logger.info((Object)("calcDiffZero-insert1 time spent:" + (time2 - time1) + "ms; "));
        logger.info((Object)("SQL1:insert into " + tmpTable + insertFiled + sumSQL));
        String tmpTable2 = DBUtil.createTempTable(ctx, "calcDiffZero2", this.getCal2ZeroFields2());
        DbUtil.execute((Context)ctx, (String)("insert into " + tmpTable2 + this.getTmp2Entry(strCalType, tmpTable, where.toString())));
        long time3 = System.currentTimeMillis();
        logger.info((Object)("calcDiffZero-insert2 time spent:" + (time3 - time2) + "ms; "));
        logger.info((Object)("insert into " + tmpTable2 + this.getTmp2Entry(strCalType, tmpTable, where.toString())));
        this.deleteNotInMaxTemp(ctx, tmpTable2, strCalType);
        String updateTemp1 = "";
        updateTemp1 = "0".equals(strCalType) ? "UPDATE " + tmpTable + " AS TEMP1 SET (FID,FTABLENAME,FSRCSTANDARDCOST) = (SELECT TEMP2.FID,TEMP2.FTABLENAME,TEMP2.FSTANDARDCOST FROM " + tmpTable2 + " AS TEMP2 WHERE TEMP1.FCOMPANYORGUNITID=TEMP2.FCOMPANYORGUNITID AND TEMP1.FMATERIALID = TEMP2.FMATERIALID)" : ("1".equals(strCalType) ? "UPDATE " + tmpTable + " AS TEMP1 SET (FID,FTABLENAME,FSRCSTANDARDCOST) = (SELECT TEMP2.FID,TEMP2.FTABLENAME,TEMP2.FSTANDARDCOST FROM " + tmpTable2 + " AS TEMP2 WHERE TEMP1.FCOMPANYORGUNITID=TEMP2.FCOMPANYORGUNITID AND TEMP1.FSTORAGEORGUNITID = TEMP2.FSTORAGEORGUNITID AND TEMP1.FMATERIALID = TEMP2.FMATERIALID)" : "UPDATE " + tmpTable + " AS TEMP1 SET (FID,FTABLENAME,FSRCSTANDARDCOST) = (SELECT TEMP2.FID,TEMP2.FTABLENAME,TEMP2.FSTANDARDCOST FROM " + tmpTable2 + " AS TEMP2 WHERE TEMP1.FCOMPANYORGUNITID=TEMP2.FCOMPANYORGUNITID AND TEMP1.FSTORAGEORGUNITID = TEMP2.FSTORAGEORGUNITID AND TEMP1.FWAREHOUSEID = TEMP2.FWAREHOUSEID AND TEMP1.FMATERIALID = TEMP2.FMATERIALID)");
        DbUtil.execute((Context)ctx, (String)updateTemp1);
        DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tmpTable + " WHERE FID IS NULL"));
        DbUtil.execute((Context)ctx, (String)this.getUpdateStandardCostSql(tmpTable, "T_IM_SaleIssueEntry", "SaleIssueEntry"));
        DbUtil.execute((Context)ctx, (String)this.getUpdateStandardCostSql(tmpTable, "T_IM_MaterialReqBillEntry", "MaterialReqBillEntry"));
        DbUtil.execute((Context)ctx, (String)this.getUpdateStandardCostSql(tmpTable, "T_IM_MoveIssueBillEntry", "MoveIssueBillEntry"));
        DbUtil.execute((Context)ctx, (String)this.getUpdateStandardCostSql(tmpTable, "T_IM_OtherIssueBillEntry", "OtherIssueBillEntry"));
    }

    private String getUpdateStandardCostSql(String tempTable, String entryTable, String entityName) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("UPDATE ").append(entryTable).append(" as ENTRY SET (FSTANDARDCOST,FActualCost,FUnitStandardCost,FUnitActualCost) = ");
        sSQL.append("(SELECT TEMP.FSRCSTANDARDCOST+TEMP.FSTANDARDCOST,TEMP.FSRCSTANDARDCOST+TEMP.FSTANDARDCOST,");
        sSQL.append("ROUND((TEMP.FSRCSTANDARDCOST+TEMP.FSTANDARDCOST)/ENTRY1.FQTY,FPricePrecision),");
        sSQL.append("ROUND((TEMP.FSRCSTANDARDCOST+TEMP.FSTANDARDCOST)/ENTRY1.FQTY,FPricePrecision) FROM ");
        sSQL.append(tempTable).append(" AS TEMP INNER JOIN T_BD_MATERIAL AS MAT ON TEMP.FMATERIALID = MAT.FID ");
        sSQL.append("INNER JOIN ").append(entryTable).append(" AS ENTRY1 ON ENTRY1.FID= TEMP.FID ");
        sSQL.append("WHERE ENTRY1.FID= ENTRY.FID AND TEMP.FTABLENAME = '").append(entityName).append("')");
        return sSQL.toString();
    }

    private void deleteNotInMaxTemp(Context ctx, String tmpTable2, String strCalType) throws BOSException {
        String select1 = "";
        String groupBy = "";
        String sql1 = "";
        String sqlJoinCondition = "";
        if ("0".equals(strCalType)) {
            groupBy = "FCompanyOrgUnitID,FMaterialID ";
            sqlJoinCondition = " t1.FCompanyOrgUnitID=t2.FCompanyOrgUnitID AND t1.FMaterialID=t2.FMaterialID ";
        } else if ("1".equals(strCalType)) {
            groupBy = "FCompanyOrgUnitID,FStorageOrgUnitID,FMaterialID ";
            sqlJoinCondition = " t1.FCompanyOrgUnitID=t2.FCompanyOrgUnitID AND t1.FStorageOrgUnitID=t2.FStorageOrgUnitID ";
            sqlJoinCondition = sqlJoinCondition + " AND t1.FMaterialID = t2.FMaterialID ";
        } else {
            groupBy = "FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FMaterialID ";
            sqlJoinCondition = " t1.FCompanyOrgUnitID=t2.FCompanyOrgUnitID AND t1.FStorageOrgUnitID=t2.FStorageOrgUnitID AND";
            sqlJoinCondition = sqlJoinCondition + " t1.FWarehouseID=t2.FWarehouseID AND t1.FMaterialID = t2.FMaterialID ";
        }
        select1 = "SELECT max(FBIZDATE) as FBIZDATE," + groupBy;
        sql1 = select1 + " from " + tmpTable2 + " group by " + groupBy;
        String sql2 = "select t1.FID AS FID FROM " + tmpTable2 + " t1 JOIN  (" + sql1 + ") t2 ON " + sqlJoinCondition + " AND t1.FBIZDATE = t2.FBIZDATE ";
        String deleteSql1 = "DELETE FROM " + tmpTable2 + " WHERE FID NOT IN (" + sql2 + ")";
        long timePoint1 = System.currentTimeMillis();
        DbUtil.execute((Context)ctx, (String)deleteSql1);
        long timePoint2 = System.currentTimeMillis();
        logger.info((Object)("delete1 spent:" + (timePoint2 - timePoint1) + "ms"));
        logger.info((Object)deleteSql1);
        select1 = "SELECT max(FAuditTime) as FAuditTime," + groupBy;
        sql1 = select1 + " from " + tmpTable2 + " group by " + groupBy;
        sql2 = "select t1.FID AS FID FROM " + tmpTable2 + " t1 JOIN  (" + sql1 + ") t2 ON " + sqlJoinCondition + " AND t1.FAuditTime = t2.FAuditTime ";
        deleteSql1 = "DELETE FROM " + tmpTable2 + " WHERE FID NOT IN (" + sql2 + ")";
        long timePoint3 = System.currentTimeMillis();
        DbUtil.execute((Context)ctx, (String)deleteSql1);
        logger.info((Object)("delete2 spent:" + (timePoint3 - timePoint2) + "ms"));
        logger.info((Object)deleteSql1);
        select1 = "SELECT max(FSEQ) as FSEQ," + groupBy;
        sql1 = select1 + " from " + tmpTable2 + " group by " + groupBy;
        sql2 = "select t1.FID AS FID FROM " + tmpTable2 + " t1 JOIN  (" + sql1 + ") t2 ON " + sqlJoinCondition + " AND t1.FSEQ = t2.FSEQ ";
        deleteSql1 = "DELETE FROM " + tmpTable2 + " WHERE FID NOT IN (" + sql2 + ")";
        DbUtil.execute((Context)ctx, (String)deleteSql1);
        select1 = "SELECT max(FID) as FID," + groupBy;
        sql1 = select1 + " from " + tmpTable2 + " group by " + groupBy;
        sql2 = "select t1.FID AS FID FROM " + tmpTable2 + " t1 JOIN  (" + sql1 + ") t2 ON " + sqlJoinCondition + " AND t1.FID = t2.FID ";
        deleteSql1 = "DELETE FROM " + tmpTable2 + " WHERE FID NOT IN (" + sql2 + ")";
        DbUtil.execute((Context)ctx, (String)deleteSql1);
    }

    private String getTmp2Entry(String strCalType, String tmpTable, String where) {
        StringBuffer sql = new StringBuffer();
        String exWhere = where + " AND BILL.FFiVouchered = 0 AND ENTRY.FBASEQTY<>0 AND TO_DECIMAL((ENTRY.FStandardCost+TEMP.FStandardCost)/ENTRY.FBASEQTY,21,8)>0 ";
        String saleIssueEntrySelect = " SELECT ENTRY.FID AS FID,ENTRY.FSEQ,'SaleIssueEntry' AS FTABLENAME,ENTRY.FStandardCost AS FStandardCost,BILL.FBIZDATE AS FBIZDATE,BILL.FAuditTime AS FAuditTime ";
        String matReqEntrySelect = " SELECT ENTRY.FID AS FID,ENTRY.FSEQ,'MaterialReqBillEntry' AS FTABLENAME,ENTRY.FStandardCost AS FStandardCost,BILL.FBIZDATE AS FBIZDATE,BILL.FAuditTime AS FAuditTime ";
        String moveIssueEntrySelect = " SELECT ENTRY.FID AS FID,ENTRY.FSEQ,'MoveIssueBillEntry' AS FTABLENAME,ENTRY.FStandardCost AS FStandardCost,BILL.FBIZDATE AS FBIZDATE,BILL.FAuditTime AS FAuditTime ";
        String otherIssueEntrySelect = " SELECT ENTRY.FID AS FID,ENTRY.FSEQ,'OtherIssueBillEntry' AS FTABLENAME,ENTRY.FStandardCost AS FStandardCost,BILL.FBIZDATE AS FBIZDATE,BILL.FAuditTime AS FAuditTime ";
        String commonSelect = ",ENTRY.FCompanyOrgUnitID,ENTRY.FStorageOrgUnitID,ENTRY.FWarehouseID,ENTRY.FMaterialID ";
        sql.append(saleIssueEntrySelect + commonSelect + this.getExInvTableSql("T_IM_SaleIssueEntry", "T_IM_SaleIssueBill", tmpTable, strCalType) + exWhere);
        sql.append("\r\n UNION ALL \r\n");
        sql.append(matReqEntrySelect + commonSelect + this.getExInvTableSql("T_IM_MaterialReqBillEntry", "T_IM_MaterialReqBill", tmpTable, strCalType) + exWhere);
        sql.append("\r\n UNION ALL \r\n");
        sql.append(moveIssueEntrySelect + commonSelect + this.getExInvTableSql("T_IM_MoveIssueBillEntry", "T_IM_MoveIssueBill", tmpTable, strCalType) + exWhere);
        sql.append("\r\n UNION ALL \r\n");
        sql.append(otherIssueEntrySelect + commonSelect + this.getExInvTableSql("T_IM_OtherIssueBillEntry", "T_IM_OtherIssueBill", tmpTable, strCalType) + exWhere);
        return sql.toString();
    }

    private String getExInvTableSql(String entry, String table, String tmpTable, String strCalType) {
        String tableSql = this.getInvTableSql(entry, table, false) + "INNER JOIN " + tmpTable + " TEMP ON TEMP.FMaterialID=ENTRY.FMaterialID ";
        tableSql = "0".equals(strCalType) ? tableSql + "AND TEMP.FCompanyOrgUnitID=ENTRY.FCompanyOrgUnitID " : ("1".equals(strCalType) ? tableSql + "AND TEMP.FCompanyOrgUnitID=ENTRY.FCompanyOrgUnitID AND TEMP.FStorageOrgUnitID=ENTRY.FStorageOrgUnitID " : tableSql + "AND TEMP.FCompanyOrgUnitID=ENTRY.FCompanyOrgUnitID AND TEMP.FStorageOrgUnitID=ENTRY.FStorageOrgUnitID AND TEMP.FWarehouseID=ENTRY.FWarehouseID");
        return tableSql + "\t\n";
    }

    private String getInvTableSql(String entry, String table, boolean isInBill) {
        StringBuffer from = new StringBuffer();
        from.append(" FROM " + entry + " ENTRY ");
        from.append("INNER JOIN " + table + " BILL ON ENTRY.FPARENTID = BILL.FID ").append("\t\n");
        from.append("INNER JOIN T_BD_Material MATERIAL ON ENTRY.FMATERIALID = MATERIAL.FID ").append("\t\n");
        from.append("LEFT JOIN T_SCM_TransactionType TR ON BILL.FTransactionTypeID = TR.FID ").append("\t\n");
        from.append("INNER JOIN T_BD_MATERIALCOMPANYINFO MACO ON MACO.FCOMPANYID = ENTRY.FCompanyOrgUnitID AND MACO.FMATERIALID = ENTRY.FMaterialID ").append("\t\n");
        from.append("Inner Join T_IM_InvUpdateType invupdate on ENTRY.FInvUpdateTypeID = invupdate.FID \r\n");
        if (isInBill) {
            from.append("Inner Join T_IM_STORETYPE stype on invupdate.FSTORETYPEID = stype.FID \r\n");
        } else {
            from.append("Inner Join T_IM_STORETYPE stype on invupdate.FSTORETYPEPREID = stype.FID \r\n");
        }
        return from.toString();
    }

    private String getStockSql(CalculateParams params, String strCalType, PeriodInfo periodInfo) {
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("COMPANY_OBJ");
        String groupby = "";
        StringBuffer stockSql = new StringBuffer();
        if ("0".equals(strCalType)) {
            stockSql.append("SELECT d.FCompanyOrgUnitID AS FCompanyOrgUnitID,d.FMaterialID AS FMaterialID,");
            stockSql.append("SUM(d.FPERIODBEGINQTY) AS FBaseQty,SUM(d.FPeriodBeginBalance + d.FPeriodAdjustDiff) AS FStandardCost");
            groupby = " GROUP BY d.FCompanyOrgUnitID,d.FMaterialID HAVING SUM(d.FPeriodBeginBalance + d.FPeriodAdjustDiff) <> 0 ";
        } else if ("1".equals(strCalType)) {
            stockSql.append("SELECT d.FCompanyOrgUnitID AS FCompanyOrgUnitID,d.FStorageOrgUnitID AS FStorageOrgUnitID,d.FMaterialID AS FMaterialID,");
            stockSql.append("SUM(d.FPERIODBEGINQTY) AS FBaseQty,SUM(d.FPeriodBeginBalance + d.FPeriodAdjustDiff) AS FStandardCost");
            groupby = " GROUP BY d.FCompanyOrgUnitID,d.FStorageOrgUnitID,d.FMaterialID HAVING SUM(d.FPeriodBeginBalance + d.FPeriodAdjustDiff) <> 0 ";
        } else {
            stockSql.append("SELECT d.FCompanyOrgUnitID AS FCompanyOrgUnitID,d.FStorageOrgUnitID AS FStorageOrgUnitID,d.FWarehouseID AS FWarehouseID,d.FMaterialID AS FMaterialID,");
            stockSql.append("SUM(d.FPERIODBEGINQTY) AS FBaseQty,SUM(d.FPeriodBeginBalance + d.FPeriodAdjustDiff) AS FStandardCost");
            groupby = " GROUP BY d.FCompanyOrgUnitID,d.FStorageOrgUnitID,d.FWarehouseID,d.FMaterialID HAVING SUM(d.FPeriodBeginBalance + d.FPeriodAdjustDiff) <> 0 ";
        }
        stockSql.append(" FROM T_IM_InventoryBalance d ").append("\t\n");
        stockSql.append("Inner Join T_BD_Material MATERIAL On d.FMaterialID=MATERIAL.FID ").append("\t\n");
        stockSql.append("JOIN T_BD_MATERIALCOMPANYINFO MACO ON MACO.FCOMPANYID = d.FCompanyOrgUnitID AND MACO.FMATERIALID = d.FMaterialID ").append("\t\n");
        stockSql.append("WHERE d.FCompanyOrgUnitID = '" + companyOrgUnitInfo.getId().toString() + "' ");
        Set storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
        Set wareHouseIds = (Set)params.getObject("WAREHOUSEID");
        if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
            String orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
            stockSql.append(" AND d.FStorageOrgUnitID").append(" in ").append(orgIds);
        }
        if (wareHouseIds != null && wareHouseIds.size() > 0) {
            String warehouseIds = CalculateUtil.getSqlIn(wareHouseIds);
            stockSql.append(" AND d.FWarehouseID").append(" in ").append(warehouseIds);
        }
        stockSql.append(" AND MACO.FACCOUNTTYPE = 2 AND d.FIsCalculate = 1 " + this.takeMaterialNumberWhereSQL(params).toString());
        stockSql.append(" AND d.FYEAR = " + periodInfo.getPeriodYear() + " AND d.FPERIOD = " + periodInfo.getPeriodNumber());
        stockSql.append(groupby);
        return stockSql.toString();
    }

    private StringBuffer takeMaterialDiffRateList(Context ctx, PeriodInfo periodInfo, String strCalType, int local_Currency_Presision, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws BOSException {
        LowTimer timer = new LowTimer();
        String diffRateTempTableName = params.getString("diffRateTempTable");
        String sqlDiffRate = this.getSQLStandcostDiffRate(ctx, periodInfo, strCalType, params);
        sqlDiffRate = this.getInsertSQLForDiffRate(diffRateTempTableName, sqlDiffRate, strCalType, this.INVENTORY_FIELD_NEW);
        sysTempTableHelper.execute(sqlDiffRate);
        logger.debug((Object)("\u83b7\u53d6\u7269\u6599\u6210\u672c\u5dee\u5f02\u7387\u65f6\u95f4\uff1a" + timer.msValue()));
        timer.reset();
        String issueTempTableName = params.getString("issueTempTable");
        params.setBoolean("IsNeedCostCenter", true);
        params.setBoolean("IsFilterCommisionBill", true);
        String sqlIssueWarehs = this.getSQLIssueStandardCostSum(periodInfo, strCalType, params);
        sqlIssueWarehs = "Insert into " + issueTempTableName + " " + sqlIssueWarehs;
        sysTempTableHelper.execute(sqlIssueWarehs);
        params.remove("IsNeedCostCenter");
        params.remove("IsFilterCommisionBill");
        logger.debug((Object)("\u63d0\u53d6\u5dee\u5f02\u5206\u644a\u51fa\u5e93\u5355\u65f6\u95f4\uff1a" + timer.msValue()));
        StringBuffer sql = new StringBuffer();
        sql.append(" Select ");
        sql.append(" newbosid('StdCsDif')");
        sql.append(" ,rate.FCompanyOrgUnitID");
        sql.append(" ,rate.FMaterialID");
        sql.append(" ,case ");
        sql.append("  when sqlIssueWarehs.fstorageorg is not null then sqlIssueWarehs.fstorageorg ");
        if (!"0".equals(strCalType)) {
            sql.append("  when rate.fstorageorg is not null then rate.fstorageorg ");
        }
        sql.append("  else N''");
        sql.append("  end as fstorageorg");
        sql.append(" ,case ");
        sql.append("  when sqlIssueWarehs.fstorageorgunitid is not null then sqlIssueWarehs.fstorageorgunitid ");
        if (!"0".equals(strCalType)) {
            sql.append("  when rate.fstorageorgunitid is not null then rate.fstorageorgunitid ");
        }
        sql.append("  else ''");
        sql.append("  end as fstorageorgunitid");
        sql.append(" ,case ");
        sql.append("  when sqlIssueWarehs.fwarehouse is not null then sqlIssueWarehs.fwarehouse ");
        if ("2".equals(strCalType)) {
            sql.append("  when rate.fwarehouse is not null then rate.fwarehouse ");
        }
        sql.append("  else N''");
        sql.append("  end as fwarehouse");
        sql.append(" ,case ");
        sql.append("  when sqlIssueWarehs.fwarehouseid is not null then sqlIssueWarehs.fwarehouseid ");
        if ("2".equals(strCalType)) {
            sql.append("  when rate.fwarehouseid is not null then rate.fwarehouseid ");
        }
        sql.append("  else ''");
        sql.append("  end as fwarehouseid");
        sql.append(" ,case when sqlIssueWarehs.fOutwarehouseType is null then ").append(-1).append(" else sqlIssueWarehs.fOutwarehouseType end  as fOutwarehouseType").append("\t\n");
        sql.append(" ,sqlIssueWarehs.FCostCenter, sqlIssueWarehs.FCostObject");
        sql.append(" ,sqlIssueWarehs.FCostObjectSuiteID, sqlIssueWarehs.FCostItemID,sqlIssueWarehs.FIsReWork");
        sql.append(" ,rate.FUnitStandardCost");
        sql.append(" ,rate.FPeriodBeginQty");
        sql.append(" ,rate.FdiffRate");
        sql.append(" ,rate.fIncomeDiffAmt").append("\t\n");
        sql.append(" ,rate.FPeriodBeginCostDiff");
        sql.append(" ,rate.FActualcost");
        sql.append(" ,rate.fIncomeCostAdjustAmt").append("\t\n");
        sql.append(" ,rate.FPeriodBeginBalance");
        sql.append(" ,rate.FStandardCost");
        sql.append(" ,rate.FIncomeSumQty");
        sql.append(" ,0 AS FPayoutSumQty").append("\r\n");
        sql.append(" ,0 AS FIssueCostSumAmt").append("\r\n");
        sql.append(" ,ISNULL(sqlIssueWarehs.FBaseQty,0) AS FPayoutQty").append("\r\n");
        sql.append(" ,ISNULL(sqlIssueWarehs.FIssueCostAmt,0) AS FIssueCostAmt").append("\r\n");
        sql.append(" ,case when sqlIssueWarehs.FIssueCostAmt is null then 0 else ");
        sql.append(" Round(Round(rate.FdiffRate,4)*sqlIssueWarehs.FIssueCostAmt, ").append(local_Currency_Presision).append(") end as FIssueCostDiffAmt").append("\r\n");
        sql.append(" ,ISNULL(MATERIAL.FPricePrecision,2) AS FPricePrecision");
        sql.append(" ,ISNULL(MeasureUnitBase.FQtyPrecision,4) AS FQtyPrecision");
        sql.append(" ,").append(local_Currency_Presision).append(" AS FLocalCurrencyPrecision");
        sql.append(",rate.FstandCostRefactorDdiffer ");
        sql.append(" ,0 AS FTotalIssueCost").append("\r\n");
        sql.append("\n from ").append(issueTempTableName).append(" sqlIssueWarehs");
        sql.append(" LEFT OUTER JOIN ").append(diffRateTempTableName).append(" rate");
        sql.append(" ON rate.FMaterialID = sqlIssueWarehs.FMaterialID").append("\r\n");
        sql.append(" and rate.FCompanyOrgUnitID = sqlIssueWarehs.FCompanyOrgUnitID").append("\r\n");
        if (!"0".equals(strCalType)) {
            sql.append(" and rate.FStorageOrgUnitID = sqlIssueWarehs.FStorageOrgUnitID").append("\r\n");
        }
        if ("2".equals(strCalType)) {
            sql.append(" and rate.FWarehouseID = sqlIssueWarehs.FWarehouseID").append("\r\n");
        }
        sql.append(" INNER JOIN T_BD_Material MATERIAL ");
        sql.append(" ON rate.FMaterialID = MATERIAL.FId");
        sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sql.append(" ON (rate.FMaterialID = MeasureUnitBase.FMaterialid");
        sql.append(" AND MATERIAL.FBaseUnit = MeasureUnitBase.FMeasureUnitID )");
        sql.append(" order by rate.FMaterialID");
        return sql;
    }

    private String getInsertSQLForDiffRate(String diffRateTempTableName, String sqlDiffRate, String strCalType, String[] strings) {
        StringBuffer insertBuffer = new StringBuffer();
        insertBuffer.append("Insert into ").append(diffRateTempTableName);
        insertBuffer.append("(FID,FMaterialId");
        if (this.takeMaterialAccountType() != null && AccountType.STANDARDCOST.equals((Object)this.takeMaterialAccountType()[0])) {
            insertBuffer.append(",").append(strings[5]);
        }
        insertBuffer.append(",").append(strings[0]);
        if ("2".equals(strCalType)) {
            insertBuffer.append(",").append(strings[1]);
            insertBuffer.append(",").append(strings[2]);
            insertBuffer.append(",").append(strings[3]);
            insertBuffer.append(",").append(strings[4]);
        } else if ("1".equals(strCalType)) {
            insertBuffer.append(",").append(strings[1]);
            insertBuffer.append(",").append(strings[3]);
        }
        insertBuffer.append(",FdiffRate");
        insertBuffer.append(",FPeriodBeginCostDiff");
        insertBuffer.append(",fIncomeDiffAmt");
        insertBuffer.append(",fIncomeCostAdjustAmt");
        insertBuffer.append(",FPeriodBeginBalance");
        insertBuffer.append(",FStandardCost");
        insertBuffer.append(",FActualcost");
        insertBuffer.append(",FIncomeSumQty");
        insertBuffer.append(",FPeriodBeginQty");
        insertBuffer.append(",FstandCostRefactorDdiffer");
        insertBuffer.append(") ").append("\t\n").append(sqlDiffRate);
        return insertBuffer.toString();
    }

    private void computeReportOutAndInWarehouseInfo(Context ctx, Statement ps, ResultSet rs, HashMap mhm, String strCalType, PeriodInfo periodInfo, int outwarehouseType, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws SQLException, EASBizException, BOSException {
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        String StorageOrgUnitId = rs.getString("FStorageOrgUnitId");
        String WarehouseId = rs.getString("FWarehouseId");
        CalculatePrecision calculatePrecision = new CalculatePrecision();
        calculatePrecision.setBaseQtyPrecision(rs.getInt("FQtyPrecision"));
        calculatePrecision.setLocalCurrencyPrecision(rs.getInt("FLocalCurrencyPrecision"));
        calculatePrecision.setPricePrecision(rs.getInt("FPricePrecision"));
        if ("0".equals(strCalType) && mhm.get(rs.getString("FMaterialID")) == null || "1".equals(strCalType) && mhm.get(rs.getString("FMaterialID") + rs.getString("FStorageOrgUnitId")) == null || "2".equals(strCalType) && mhm.get(rs.getString("FMaterialID") + rs.getString("FWarehouseId") + rs.getString("FStorageOrgUnitId")) == null) {
            if ("0".equals(strCalType)) {
                mhm.put(rs.getString("FMaterialID"), rs.getString("FMaterialID"));
            }
            if ("1".equals(strCalType)) {
                mhm.put(rs.getString("FMaterialID") + rs.getString("FStorageOrgUnitId"), rs.getString("FMaterialID"));
            }
            if ("2".equals(strCalType)) {
                mhm.put(rs.getString("FMaterialID") + rs.getString("FWarehouseId") + rs.getString("FStorageOrgUnitId"), rs.getString("FMaterialID"));
            }
            for (int ii = 0; ii < 4; ++ii) {
                StringBuffer income = new StringBuffer();
                StringBuffer payout = new StringBuffer();
                StringBuffer SettleAccounts = new StringBuffer();
                String billName = IssueTypeEnum.getEnum(outwarehouseType).toString();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
                String createTime = sdf.format(new Date());
                String timeSerialNumber = "0";
                if (ii == 0) {
                    createTime = "1900-01-01 00:00:00.000";
                    billName = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_BEGIN_CLOSE_ACCOUNT", (Context)ctx);
                    SettleAccounts.append(rs.getBigDecimal("FPeriodBeginQty").setScale(calculatePrecision.getBaseQtyPrecision(), 4));
                    SettleAccounts.append(" * ");
                    if (CalculateUtil.ZERO.compareTo(rs.getBigDecimal("FPeriodBeginQty").setScale(calculatePrecision.getBaseQtyPrecision(), 4)) == 0) {
                        SettleAccounts.append("0.00");
                    } else {
                        SettleAccounts.append(rs.getBigDecimal("FPeriodBeginBalance").setScale(Local_Currency_Presision, 4).divide(rs.getBigDecimal("FPeriodBeginQty").setScale(calculatePrecision.getBaseQtyPrecision(), 4), calculatePrecision.getPricePrecision(), 4));
                    }
                    SettleAccounts.append(" = ");
                    SettleAccounts.append(rs.getBigDecimal("FPeriodBeginBalance").setScale(Local_Currency_Presision, 4));
                } else if (ii == 2) {
                    createTime = "2900-01-01 00:00:00.001";
                    billName = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_COST_DIFF_RATE", (Context)ctx);
                    payout.append(" ( ");
                    payout.append(rs.getBigDecimal("FPeriodBeginCostDiff").setScale(Local_Currency_Presision, 4));
                    payout.append(" + ");
                    payout.append(" ( ");
                    payout.append(rs.getBigDecimal("FActualcost").setScale(Local_Currency_Presision, 4).subtract(rs.getBigDecimal("FStandardCost").setScale(Local_Currency_Presision, 4)).add(rs.getBigDecimal("fIncomeCostAdjustAmt").setScale(Local_Currency_Presision, 4)));
                    payout.append(" ) ");
                    payout.append(" + (");
                    payout.append(rs.getBigDecimal("FStandardCostdiff").setScale(Local_Currency_Presision, 4));
                    payout.append(") )/( ");
                    payout.append(rs.getBigDecimal("FPeriodBeginBalance").setScale(Local_Currency_Presision, 4));
                    payout.append(" + ");
                    payout.append(rs.getBigDecimal("FStandardCost").setScale(Local_Currency_Presision, 4));
                    payout.append(" + (");
                    payout.append(rs.getBigDecimal("FStandardCostdiff").multiply(new BigDecimal("-1")).setScale(Local_Currency_Presision, 4));
                    payout.append(") ) ");
                    payout.append(" = ");
                    payout.append(rs.getBigDecimal("FdiffRate").multiply(CalculateUtil.HUNDRED).setScale(2, 4)).append("%");
                } else if (ii == 3) {
                    createTime = "2900-01-03 00:00:00.000";
                    billName = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_SALE_COST", (Context)ctx);
                    BigDecimal qty = rs.getBigDecimal("FPayoutSumQty").setScale(calculatePrecision.getBaseQtyPrecision(), 4);
                    BigDecimal price = this.ZERO;
                    if (qty.compareTo(this.ZERO) != 0) {
                        price = rs.getBigDecimal("FTotalIssueCost").divide(qty, calculatePrecision.getPricePrecision(), 4);
                    }
                    BigDecimal totalIssueCost = rs.getBigDecimal("FTotalIssueCost");
                    payout.append(qty);
                    payout.append(" * ");
                    payout.append(price);
                    payout.append(" = ");
                    payout.append(rs.getBigDecimal("FTotalIssueCost").setScale(Local_Currency_Presision, 4));
                    qty = rs.getBigDecimal("FIncomeSumQty").subtract(rs.getBigDecimal("FPayoutSumQty")).setScale(calculatePrecision.getBaseQtyPrecision(), 4);
                    BigDecimal totalinCost = rs.getBigDecimal("factualcost");
                    if (qty.compareTo(this.ZERO) != 0) {
                        price = totalinCost.subtract(totalIssueCost).divide(qty, calculatePrecision.getPricePrecision(), 4);
                    }
                    SettleAccounts.append(qty);
                    SettleAccounts.append(" * ");
                    SettleAccounts.append(price);
                    SettleAccounts.append(" = ");
                    SettleAccounts.append(totalinCost.subtract(totalIssueCost).setScale(Local_Currency_Presision, 4));
                }
                if (ii == 1) continue;
                ps.addBatch(CostComputeHelp.createCostComputeReport(ctx, periodInfo, rs.getString("FMaterialID"), rs.getString("FCompanyOrgUnitID"), StorageOrgUnitId, WarehouseId, billName, "", income.toString(), payout.toString(), SettleAccounts.toString(), createTime, timeSerialNumber, this.takeMaterialAccountType()[0], 1, params.getString("headerid")).toString());
            }
        }
    }

    private void computeReportOutWarehouseCostAdjustBill(Context ctx, Statement ps, ResultSet rs, String strCalType, PeriodInfo periodInfo, String costAdjustNumber, int outwarehouseType, CalculateParams params) throws SQLException {
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        String StorageOrgUnitId = rs.getString("FStorageOrgUnitId");
        String WarehouseId = rs.getString("FWarehouseId");
        StringBuffer income = new StringBuffer();
        StringBuffer payout = new StringBuffer();
        StringBuffer SettleAccounts = new StringBuffer();
        String billName = new StringBuffer(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"OUT_WAREHOUSE_COST_ADJUST", (Context)ctx)).append("(").append(IssueTypeEnum.getEnum(outwarehouseType).toString()).append(")").toString();
        String createTime = "2900-01-02 00:00:00.000";
        String timeSerialNumber = "0";
        payout.append(rs.getBigDecimal("FdiffRate").multiply(CalculateUtil.HUNDRED).setScale(2, 4)).append("%");
        payout.append(" * ");
        payout.append(rs.getBigDecimal("FIssueCostAmt").setScale(Local_Currency_Presision, 4));
        payout.append(" = ");
        payout.append(rs.getBigDecimal("FIssueCostDiffAmt").setScale(Local_Currency_Presision, 4));
        ps.addBatch(CostComputeHelp.createCostComputeReport(ctx, periodInfo, rs.getString("FMaterialID"), rs.getString("FCompanyOrgUnitID"), StorageOrgUnitId, WarehouseId, billName, costAdjustNumber, income.toString(), payout.toString(), SettleAccounts.toString(), createTime, timeSerialNumber, this.takeMaterialAccountType()[0], 1, params.getString("headerid")).toString());
    }

    private boolean isExistVouchered(Context ctx, SysTempTableHelper sysTempTableHelper, PeriodInfo periodInfo, String strCalType, CalculateParams params, HashMap costadjustNumber) throws CalculateException, BOSException {
        String tempTableName = sysTempTableHelper.createTempTable(ctx, this.getCostAdjBillTempTableFields());
        params.setString("CostAdjBillTempTable", tempTableName);
        String companyOrgID = params.getString("COMPANY_ID");
        String costMaterialRange = params.getString("CALCULATEMATERIALRANGE");
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(tempTableName).append("(FID,FEntryID,FNumber,FFiVouchered) ");
        sql.append(" SELECT Bill.FID, ENTRY.FID, Bill.FNumber, Bill.FFiVouchered FROM T_CL_CostAdjustBill AS BILL");
        sql.append(" INNER JOIN T_CL_CostAdjustBillEntry AS ENTRY ON BILL.FID = ENTRY.FParentID ");
        sql.append(" INNER JOIN T_BD_MATERIAL AS MATERIAL ON ENTRY.FMATERIALID = MATERIAL.FID ");
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo AS MATCMP ON MATCMP.FMaterialId = MATERIAL.FID ");
        sql.append(" WHERE BILL.FCalculateKind = ").append(1);
        sql.append(" AND BILL.FYear = ").append(periodInfo.getPeriodYear());
        sql.append(" AND BILL.FPeriod =").append(periodInfo.getPeriodNumber());
        sql.append(" AND BILL.FCreateType = ").append(3);
        sql.append(" AND MATCMP.FCompanyID = '").append(companyOrgID).append("'");
        if ("rawMaterailCostCal".equalsIgnoreCase(costMaterialRange)) {
            sql.append(" AND MATCMP.FCalculateType = ").append(0).append("\t\n");
        } else if ("fishedGoodsCostCal".equalsIgnoreCase(costMaterialRange)) {
            sql.append(" AND MATCMP.FCalculateType <> ").append(0).append("\t\n");
        }
        sql.append(this.takeMaterialNumberWhereSQL(params));
        sql.append(this.getFilterIDByCalType(strCalType, params, this.INVENTORY_FIELD_ENTRY_ID));
        sysTempTableHelper.execute(sql.toString());
        sql.setLength(0);
        sql.append("Select FNumber From ").append(tempTableName).append(" Where FFiVouchered = 1");
        IRowSet rs = sysTempTableHelper.executeQuery(sql.toString());
        try {
            sql.setLength(0);
            while (rs.next()) {
                sql.append(rs.getString("FNumber")).append("\t\n");
            }
            if (sql.length() > 0) {
                costadjustNumber.put("costadjustNumber", sql.toString());
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return false;
    }

    private void clearOldPeriodData(SysTempTableHelper sysTempTableHelper, CalculateParams params, String strCalType) throws BOSException {
        String tempTableName = params.getString("CostAdjBillTempTable");
        StringBuffer sqlDelete = new StringBuffer();
        sqlDelete.append("DELETE FROM T_CL_CostAdjustBillEntry");
        sqlDelete.append(" WHERE FID IN (");
        sqlDelete.append(" SELECT FEntryID FROM ").append(tempTableName);
        sqlDelete.append(")");
        sysTempTableHelper.execute(sqlDelete.toString());
        sqlDelete.setLength(0);
        sqlDelete.append("DELETE FROM T_CL_CostAdjustBill");
        sqlDelete.append(" WHERE FID IN (");
        sqlDelete.append(" SELECT FID FROM ").append(tempTableName);
        sqlDelete.append(")");
        sysTempTableHelper.execute(sqlDelete.toString());
        ArrayList sqlParams = new ArrayList();
        sysTempTableHelper.execute(super.clearOldPeriodData(params, strCalType, sqlParams), sqlParams);
    }

    private String getSQLIssueStandardCostSum(PeriodInfo periodInfo, String strCalType, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newbosid('IssueTab'),");
        sql.append(this.getGroupSegmentByCalType("2", true, this.INVENTORY_FIELD_NEW));
        sql.append(" FOutwarehouseType,FCostCenter,FCostObject");
        sql.append(" ,FCostObjectSuiteID,FCostItemID,FIsReWork");
        sql.append(" ,sum(ENTRY.FStandardCost) AS FIssueCostAmt");
        sql.append(" ,sum(FBaseQty) AS FBaseQty");
        sql.append("  from (").append("\r\n");
        sql.append(this.getSQLPayoutBill(periodInfo, strCalType, null, params)).append("\r\n");
        sql.append(" ) ENTRY ");
        sql.append(" GROUP BY ");
        sql.append(this.getGroupSegmentByCalType("2", false, this.INVENTORY_FIELD_NEW));
        sql.append(",FOutwarehouseType,FCostCenter,FCostObject");
        sql.append(",FCostObjectSuiteID,FCostItemID,FIsReWork");
        return sql.toString();
    }

    private String getSQLStandcostDiffRate(Context ctx, PeriodInfo periodInfo, String strCalType, CalculateParams params) {
        int local_currency_presion = params.getInt("Local_Currency_Presision");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newbosid('DiffRate'),");
        sql.append(this.getGroupSegmentByCalType(strCalType, true, this.INVENTORY_FIELD_NEW));
        sql.append(" case (sum(FPeriodBeginBalance+FStandardCost+FPeriodBeginQty*ISNULL(FDIFFPRICE,0))) when 0 then 0");
        sql.append("  else ROUND(").append(CalculateUtil.TO_DECIMAL_DIVIDE(CalculateUtil.TO_DECIMAL_SUM("(sum(FPeriodBeginCostDiff+FActualcost-FStandardCost+fIncomeCostAdjustAmt+((-1)*FPeriodBeginQty*ISNULL(FDIFFPRICE,0))))") + "/" + CalculateUtil.TO_DECIMAL_SUM("(sum(FPeriodBeginBalance+FStandardCost+FPeriodBeginQty*ISNULL(FDIFFPRICE,0)))"))).append(",").append(8).append(")");
        sql.append("  end AS FdiffRate");
        sql.append(" ,sum(FPeriodBeginCostDiff) AS FPeriodBeginCostDiff").append("\t\n");
        sql.append(" ,case (sum(FActualcost-FStandardCost)) when 0 then 0 else sum(FActualcost-FStandardCost) end AS fIncomeDiffAmt").append("\t\n");
        sql.append(" ,sum(fIncomeCostAdjustAmt) AS fIncomeCostAdjustAmt").append("\t\n");
        sql.append(" ,sum(FPeriodBeginBalance) AS FPeriodBeginBalance").append("\t\n");
        sql.append(" ,sum(FStandardCost) AS FStandardCost").append("\t\n");
        sql.append(" ,sum(FActualcost) AS FActualcost").append("\t\n");
        StringBuffer stringBuffer = sql.append(" ,sum(FBaseQty+FPeriodBeginQty) AS FIncomeSumQty");
        this.getClass();
        stringBuffer.append("\t\n");
        sql.append(" ,sum(FPeriodBeginQty) AS FPeriodBeginQty").append("\t\n");
        sql.append(" ," + CalculateUtil.TO_DECIMAL_SUM("round((sum((-1)*FPeriodBeginQty*ISNULL(FDIFFPRICE,0)))," + local_currency_presion + ")") + " AS FstandCostRefactorDdiffer ").append("\t\n");
        sql.append("  from (").append("\r\n");
        sql.append(this.getSQLIncomeStandCost(periodInfo, strCalType, null, params));
        sql.append("\r\n UNION ALL \r\n").append("\t\n");
        sql.append(this.getSQLPeriodBeginBalance(ctx, periodInfo, strCalType, null, params, strCalType));
        sql.append(" ) ENTRY LEFT JOIN (");
        sql.append(this.getSQLStandCostAdjBillDiff(periodInfo, params));
        sql.append("\n )AS TT");
        sql.append("\n ON (ENTRY.FCOMPANYORGUNITID = TT.FCOMPANYID AND ENTRY.FMATERIALID = TT.FMATERIALID");
        sql.append(")");
        sql.append(" GROUP BY ");
        sql.append(this.getGroupSegmentByCalType(strCalType, false, this.INVENTORY_FIELD_NEW));
        sql.append(" having " + CalculateUtil.TO_DECIMAL_SUM("(sum(FPeriodBeginBalance+FStandardCost+FPeriodBeginQty*ISNULL(FDIFFPRICE,0)))") + "<>0 ");
        return sql.toString();
    }

    @Override
    public AccountType[] takeMaterialAccountType() {
        return new AccountType[]{AccountType.STANDARDCOST};
    }

    private String[][] getCal2ZeroFields() {
        String[][] fields = new String[][]{{"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"FQty", "NUMERIC(21,8) DEFAULT 0"}, {"FStandardCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FID", "VARCHAR(44)"}, {"FTABLENAME", "VARCHAR(80)"}, {"FSrcStandardCost", "NUMERIC(17,4)"}};
        return fields;
    }

    private String[][] getCal2ZeroFields2() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44)"}, {"FSEQ", "INT"}, {"FTABLENAME", "VARCHAR(80)"}, {"FStandardCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FBIZDATE", "DateTime"}, {"FAuditTime", "DateTime"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}};
        return fields;
    }

    @Override
    public String[][] getTempTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"Fstorageorg", "NVARCHAR(80)"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouse", "NVARCHAR(80)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FOutwarehouseType", "INT DEFAULT -1 NOT NULL"}, {"FCostCenter", "VARCHAR(44)"}, {"FCostObject", "VARCHAR(44)"}, {"FCostObjectSuiteID", "VARCHAR(44)"}, {"FCostItemID", "VARCHAR(44)"}, {"FIsReWork", "INT DEFAULT 0"}, {"FUnitStandardCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPeriodBeginQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FdiffRate", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"fIncomeDiffAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPeriodBeginCostDiff", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FActualcost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"fIncomeCostAdjustAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPeriodBeginBalance", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FStandardCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FIncomeSumQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPayoutSumQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FIssueCostSumAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPayoutQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FIssueCostAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FIssueCostDiffAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPricePrecision", "INT DEFAULT 2"}, {"FQtyPrecision", "INT DEFAULT 4"}, {"FLocalCurrencyPrecision", "INT DEFAULT 2"}, {"FStandardCostdiff", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FTotalissueCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    public String[][] getDiffRateTempTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"FUnitStandardCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"Fstorageorg", "NVARCHAR(80)"}, {"Fwarehouse", "NVARCHAR(80)"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FdiffRate", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPeriodBeginCostDiff", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"fIncomeDiffAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"fIncomeCostAdjustAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPeriodBeginBalance", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FStandardCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FActualcost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FIncomeSumQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPeriodBeginQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FstandCostRefactorDdiffer", "NUMERIC(17, 4) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    public String[][] getIncomeStandCostTempTableFields() {
        String[][] fields = new String[][]{{"FMaterialId", "VARCHAR(44) NOT NULL"}, {"FUnitStandardCost", "NUMERIC(19,4) DEFAULT 0 NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FStorageOrg", "NVARCHAR(80)"}, {"FWarehouse", "NVARCHAR(80)"}, {"FStorageOrgUnitID", "VARCHAR(44)"}, {"FWarehouseID", "VARCHAR(44)"}, {"FPeriodBeginCostDiff", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPeriodBeginBalance", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FIncomeCostAdjustAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FStandardCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseUnitActualCost", "NUMERIC(19,4) DEFAULT 0 NOT NULL"}, {"FPeriodBeginQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBillTypeID", "VARCHAR(44)"}, {"FNumber", "VARCHAR(80)"}, {"FBizDate", "DATETIME"}, {"FUNITACTUALCOST", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FBASEUNITID", "VARCHAR(44)"}, {"FUNITID", "VARCHAR(44)"}, {"FSourceBillID", "VARCHAR(44)"}, {"FSourceBillEntryID", "VARCHAR(44)"}, {"FSourceBillEntrySeq", "INT"}, {"FOutwarehouseType", "INT"}, {"FEntryTableMame", "NVARCHAR(80)"}};
        return fields;
    }

    public String[][] getIssueTempTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"FUnitStandardCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"Fstorageorg", "NVARCHAR(80)"}, {"Fwarehouse", "NVARCHAR(80)"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FOutwarehouseType", "INT DEFAULT -1 NOT NULL"}, {"FCostCenter", "VARCHAR(44)"}, {"FCostObject", "VARCHAR(44)"}, {"FCostObjectSuiteID", "VARCHAR(44)"}, {"FCostItemID", "VARCHAR(44)"}, {"FIsReWork", "INT DEFAULT 0"}, {"FIssueCostAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    public String[][] getCostAdjBillTempTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FEntryID", "VARCHAR(44) NOT NULL"}, {"FNumber", "VARCHAR(80) NOT NULL"}, {"FFiVouchered", "INT DEFAULT 0 NOT NULL"}};
        return fields;
    }

    @Override
    public String getTempTableSerialVersionUID() {
        return "StandardCostDiffCalculate";
    }

    @Override
    protected StringBuffer getSQLCostAdjExtendWhere() {
        StringBuffer sql = new StringBuffer();
        sql.append(" AND BILL.FCreateType != ").append(3);
        return sql;
    }

    @Override
    protected StringBuffer getSQLWhereExtends(PeriodInfo periodInfo, CalculateParams params) {
        StringBuffer sql = super.getSQLWhereExtends(periodInfo, params);
        boolean IsFilterCommisionBill = params.getBoolean("IsFilterCommisionBill");
        if (IsFilterCommisionBill) {
            sql.append(" AND SCMTRANSACTIONTYPE.FRITypeID <> '" + RecIssueTypeConstant.CONSIGNOUT_RITYPEID + "' ");
            sql.append(" AND SCMTRANSACTIONTYPE.FRITypeID <> '" + RecIssueTypeConstant.CONSIGNRT_RITYPEID + "' ").append("\t\n");
        }
        String materialId = null;
        boolean isNeedExtendWhere = params.getBoolean("IsNeedExtendWhere");
        String filterCalType = params.getString("CALTYPE");
        if (isNeedExtendWhere) {
            String orgIds;
            materialId = params.getString("MATERIAL_ID_FROM");
            Set storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
            Set wareHouseIds = (Set)params.getObject("WAREHOUSEID");
            if (!StringUtil.isEmpty((String)materialId)) {
                sql.append(" AND MATERIAL.FID = '").append(materialId).append("'").append("\t\n");
            }
            if ("2".equals(filterCalType)) {
                if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                    orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                    sql.append(" AND STORAGEORGUNIT.FID in ").append(orgIds).append("\t\n");
                }
                if (wareHouseIds != null && wareHouseIds.size() > 0) {
                    String warehouseIds = CalculateUtil.getSqlIn(wareHouseIds);
                    sql.append(" AND WAREHOUSE.FID in ").append(warehouseIds).append("\t\n");
                }
            }
            if ("1".equals(filterCalType) && storageOrgBegs != null && storageOrgBegs.size() > 0) {
                orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                sql.append(" AND STORAGEORGUNIT.FID in ").append(orgIds).append("\t\n");
            }
        }
        return sql;
    }

    private String getSQLStandCostAdjBillDiff(PeriodInfo periodInfo, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT BILL.FCompanyOrgUnitID AS FCOMPANYID,ENTRY.FMATERIALID");
        sql.append(" ,SUM(ISNULL(FNewStandardPrice,0)-ISNULL(FOldStandardPrice,0)) AS FDIFFPRICE").append("\t\n");
        sql.append(" FROM T_CL_StandardCostAdjBill AS BILL").append("\t\n");
        sql.append(" INNER JOIN T_CL_StandardCostAdjEntry AS ENTRY ON BILL.FID = ENTRY.FParentID").append("\t\n");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ");
        sql.append(" ON ENTRY.FMaterialID = MATERIAL.FId").append("\t\n");
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (ENTRY.FMaterialID = MATERIALCOMPANY.FMaterialID").append("\t\n");
        sql.append(" AND bill.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )").append("\t\n");
        sql.append(" WHERE BILL.FBaseStatus = ").append(4).append("\t\n");
        sql.append(this.takeMaterialNumberWhereSQL(params));
        sql.append(this.takeMaterialAccountTypeWhereSQL());
        sql.append(this.getSQLWherePeriod(params, periodInfo, false, false));
        sql.append("\n GROUP BY BILL.FCOMPANYORGUNITID,ENTRY.FMATERIALID");
        return sql.toString();
    }

    class CalculateThreadForWeightedStandardCost
    implements Runnable {
        Context ctx;
        CalculateParams params;
        SysTempTableHelper sysTempTableHelper;
        Connection conn;
        PeriodInfo periodInfo;
        int startIndex = 0;
        String tempTableName;
        String strCalType;

        public CalculateThreadForWeightedStandardCost(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper, Connection conn, PeriodInfo periodInfo, int startIndex, String tempTableName, String strCalType) {
            this.ctx = ctx;
            try {
                this.params = (CalculateParams)params.clone();
            }
            catch (CloneNotSupportedException e) {
                StandardCostDiffCalculate.this.ExceptionList.add(e);
            }
            this.sysTempTableHelper = sysTempTableHelper;
            this.conn = conn;
            this.periodInfo = periodInfo;
            this.startIndex = startIndex;
            this.tempTableName = tempTableName;
            this.strCalType = strCalType;
        }

        @Override
        public void run() {
            try {
                this.asynCalculate();
            }
            catch (Exception e) {
                StandardCostDiffCalculate.this.ExceptionList.add(e);
                logger.info((Object)e);
            }
            finally {
                StandardCostDiffCalculate.this.countDown.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void asynCalculate() throws SQLException, BOSException, EASBizException {
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.params.getObject("COMPANY_OBJ");
            int Local_Currency_Presision = this.params.getInt("Local_Currency_Presision");
            ICostAdjustBill ic = CostAdjustBillFactory.getLocalInstance(this.ctx);
            ICostAdjustBillEntry ice = CostAdjustBillEntryFactory.getLocalInstance(this.ctx);
            Statement reptPS = null;
            Statement costBillPS = null;
            IRowSet rs = this.sysTempTableHelper.batchExecuteQuery("select * from " + this.tempTableName, this.startIndex, 1000);
            String storageorgid = "";
            String warehourseId = "";
            int iOutwarehouseType = -1;
            HashMap mhm = new HashMap();
            ObjectUuidPK billid = null;
            boolean i = false;
            StringBuffer sql = new StringBuffer();
            String costAdjustNumber = "";
            String costCenter = "";
            String billKey = "";
            Integer entryCount = new Integer(0);
            BigDecimal issueCostDiff = null;
            CostBillInfo billInfo = null;
            HashMap keyMap = new HashMap();
            HashMap<ObjectUuidPK, Integer> entrySizeMap = new HashMap<ObjectUuidPK, Integer>();
            ArrayList<CostBillInfo> billList = null;
            costBillPS = this.conn.createStatement();
            reptPS = this.conn.createStatement();
            int recordCount = 0;
            int billCount = 0;
            String costObjectSuite = "";
            String costItem = "";
            boolean isReWork = false;
            try {
                while (rs.next()) {
                    try {
                        ++recordCount;
                        storageorgid = rs.getString("fstorageorgunitid");
                        iOutwarehouseType = rs.getInt("fOutwarehouseType");
                        costCenter = rs.getString("FCostCenter");
                        warehourseId = rs.getString("FWarehouseID");
                        issueCostDiff = rs.getBigDecimal("FIssueCostDiffAmt");
                        costObjectSuite = rs.getString("FCostObjectSuiteID");
                        costItem = rs.getString("FCostItemID");
                        isReWork = rs.getBoolean("FIsReWork");
                        if (issueCostDiff.compareTo(StandardCostDiffCalculate.this.ZERO) != 0) {
                            ++billCount;
                            StringBuffer sb = new StringBuffer();
                            sb.append(storageorgid);
                            sb.append("_$$$_" + iOutwarehouseType);
                            if ("2".equals(this.strCalType)) {
                                sb.append("_$$$_" + warehourseId);
                            } else {
                                sb.append("_$$$_NULL");
                            }
                            if (costCenter == null) {
                                sb.append("_$$$_NULL");
                            } else {
                                sb.append("_$$$_" + costCenter);
                            }
                            if (costObjectSuite == null) {
                                sb.append("_$$$_NULL");
                            } else {
                                sb.append("_$$$_" + costObjectSuite);
                            }
                            if (costItem == null) {
                                sb.append("_$$$_NULL");
                            } else {
                                sb.append("_$$$_" + costItem);
                            }
                            if (!isReWork) {
                                sb.append("_$$$_false");
                            } else {
                                sb.append("_$$$_true");
                            }
                            billKey = sb.toString();
                            billList = (ArrayList<CostBillInfo>)keyMap.get(billKey);
                            if (billList == null || billList.size() == 0) {
                                billid = new ObjectUuidPK(ic.getType());
                                costAdjustNumber = CostAdjustHelp.creatCostAdjustBillNumber(this.ctx, companyOrgUnitInfo, "");
                                sql = CostAdjustHelp.createCostAdjustBillSQL(this.ctx, companyOrgUnitInfo, this.periodInfo, (ResultSet)rs, billid, storageorgid, iOutwarehouseType, costAdjustNumber, costCenter);
                                costBillPS.addBatch(sql.toString());
                                billList = new ArrayList<CostBillInfo>();
                                billInfo = new CostBillInfo(billid, costAdjustNumber);
                                billList.add(billInfo);
                                keyMap.put(billKey, billList);
                                entryCount = new Integer(0);
                            } else {
                                billInfo = (CostBillInfo)billList.get(billList.size() - 1);
                                billid = billInfo.getId();
                                costAdjustNumber = billInfo.getNumber();
                                entryCount = (Integer)entrySizeMap.get(billid);
                                if (entryCount != null && entryCount >= 1000) {
                                    billid = new ObjectUuidPK(ic.getType());
                                    costAdjustNumber = CostAdjustHelp.creatCostAdjustBillNumber(this.ctx, companyOrgUnitInfo, "");
                                    sql = CostAdjustHelp.createCostAdjustBillSQL(this.ctx, companyOrgUnitInfo, this.periodInfo, (ResultSet)rs, billid, storageorgid, iOutwarehouseType, costAdjustNumber, costCenter);
                                    costBillPS.addBatch(sql.toString());
                                    billInfo = new CostBillInfo(billid, costAdjustNumber);
                                    billList.add(billInfo);
                                    entryCount = new Integer(0);
                                }
                            }
                            int count = entryCount + 1;
                            entryCount = new Integer(count);
                            entrySizeMap.put(billid, entryCount);
                            ObjectUuidPK entryid = new ObjectUuidPK(ice.getType());
                            StringBuffer sqlentry = CostAdjustHelp.createCostAdjustEntrySQL(billid, entryid, this.periodInfo, (ResultSet)rs, count, Local_Currency_Presision);
                            costBillPS.addBatch(sqlentry.toString());
                            if (this.params.getBoolean("ISWRITECOSTCOMPUTEREPORT")) {
                                StandardCostDiffCalculate.this.computeReportOutWarehouseCostAdjustBill(this.ctx, reptPS, (ResultSet)rs, this.strCalType, this.periodInfo, costAdjustNumber, iOutwarehouseType, this.params);
                            }
                            if (recordCount % 500 == 0) {
                                StandardCostDiffCalculate.this.executePsBatch(costBillPS);
                            }
                        }
                        if (this.params.getBoolean("ISWRITECOSTCOMPUTEREPORT")) {
                            StandardCostDiffCalculate.this.computeReportOutAndInWarehouseInfo(this.ctx, reptPS, (ResultSet)rs, mhm, this.strCalType, this.periodInfo, iOutwarehouseType, this.params, this.sysTempTableHelper);
                        }
                        if (recordCount % 500 != 0) continue;
                        StandardCostDiffCalculate.this.executePsBatch(reptPS);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                        StandardCostDiffCalculate.this.ExceptionList.add(e);
                    }
                }
                StandardCostDiffCalculate.this.executePsBatch(costBillPS);
                StandardCostDiffCalculate.this.executePsBatch(reptPS);
                return;
            }
            finally {
                SQLUtils.cleanup((Statement)costBillPS);
                SQLUtils.cleanup((Statement)reptPS);
            }
        }
    }

    private class CostBillInfo {
        ObjectUuidPK id;
        String number;

        public CostBillInfo(ObjectUuidPK id, String number) {
            this.id = id;
            this.number = number;
        }

        public ObjectUuidPK getId() {
            return this.id;
        }

        public String getNumber() {
            return this.number;
        }
    }
}

