/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.app.calculate.AbstractInventoryCalculate;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.app.newutil.InventoryBillHelper;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryCollection;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillEntryInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StockTranInpWarehsCalculate
extends AbstractInventoryCalculate {
    Map<String, Integer> moveInStatusMap = new HashMap<String, Integer>();
    Map<String, List<MoveIn>> dealMoveInMap = new HashMap<String, List<MoveIn>>();
    Map<String, Integer> materialPricePrecisionMap = new HashMap<String, Integer>();

    @Override
    public void calculateStrategy(Context ctx, CoreBillBaseInfo scminfo) throws BOSException, EASBizException {
        StringBuffer selectSQL;
        CalculateWrittenOffBill calculateWrittenOffBill;
        MoveInWarehsBillInfo bill = (MoveInWarehsBillInfo)scminfo;
        this.srcEntryTableName = InvCommonUtils.getBillEntryTableName((String)SCMUtil.getBillTypeNOFormBillTypeID((BillTypeInfo)bill.getBillType()));
        if (InventoryBillHelper.isCostStockTran(bill.getBizType().getId().toString()) && !bill.isIsReversed()) {
            this.handleMoveInCost(ctx, bill);
        }
        if ((calculateWrittenOffBill = this.takeWrittenOffBill(ctx, (CoreBillBaseInfo)bill, this.srcEntryTableName, selectSQL = this.takeSQLBill(ctx, this.srcEntryTableName))) == null) {
            return;
        }
        if (InventoryBillHelper.isEfficeBalance(calculateWrittenOffBill.getBizType(), this.materialCalType)) {
            ArrayList entrys = calculateWrittenOffBill.getEntry();
            for (int i = 0; i < entrys.size(); ++i) {
                CalculateWrittenOffEntry entry = (CalculateWrittenOffEntry)entrys.get(i);
                this.calculator.calculateCost(ctx, this.companyOrgUnitInfo, this.periodInfo, this.materialCalType, entry.getAmount(), entry.getBaseUnitQty(), calculateWrittenOffBill, entry, true);
            }
        }
    }

    @Override
    protected CalculateKindEnum takeOutOrInWarehouseKind() throws EASBizException, BOSException {
        return CalculateKindEnum.INPUT_WAREHOUSE;
    }

    private Map<String, MoveOut> getMoveOutMap(Context ctx, String billID) throws BOSException {
        HashMap<String, MoveOut> moveOutMap = new HashMap<String, MoveOut>();
        IRowSet rs = null;
        try {
            StringBuffer sb = new StringBuffer(1024);
            sb.append("select b.fstocktransbillentryid as stocktransbillentryid, sum(b.fbaseqty) as totalBaseQty, sum(b.factualcost) as totalActualcost");
            sb.append(" from t_im_moveissuebillentry b, ");
            sb.append(" (select distinct a.fstocktransbillentryid ");
            sb.append(" from t_im_moveinwarehsbillentry a ");
            sb.append(" where a.fparentid = '" + billID + "'");
            sb.append(" ) as c, ");
            sb.append(" t_im_moveissuebill d ");
            sb.append(" where b.fstocktransbillentryid = c.fstocktransbillentryid ");
            sb.append("   and b.fparentid = d.fid ");
            sb.append("   and d.fbasestatus=4 ");
            sb.append(" group by b.fstocktransbillentryid");
            rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString());
            MoveOut moveOut = null;
            while (rs.next()) {
                moveOut = new MoveOut();
                String stocktransbillentryid = rs.getString("stocktransbillentryid");
                moveOut.setStocktransbillentryid(stocktransbillentryid);
                moveOut.setTotalBaseQty(rs.getBigDecimal("totalBaseQty"));
                moveOut.setTotalActualcost(rs.getBigDecimal("totalActualcost"));
                moveOutMap.put(stocktransbillentryid, moveOut);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return moveOutMap;
    }

    private Map<String, MoveIn> getMoveInMap(Context ctx, String billID) throws BOSException {
        HashMap<String, MoveIn> moveInMap = new HashMap<String, MoveIn>();
        IRowSet rs = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select a.fid as entryID, ");
        sb.append("a.fparentid as parentID, ");
        sb.append("a.fseq as seq, ");
        sb.append("a.fbasestatus as basestatus, ");
        sb.append("a.fstocktransbillentryid as stocktransbillentryid, ");
        sb.append("a.factualcost as actualcost, ");
        sb.append("a.fqty as qty, ");
        sb.append("a.fbaseqty as baseqty, ");
        sb.append("a.funitactualcost as unitactualcost ");
        sb.append("from t_im_moveinwarehsbillentry as a ");
        sb.append("inner join t_im_moveinwarehsbill b on a.FPARENTID  = b.FID  ");
        StringBuffer sql = new StringBuffer();
        sql.append(sb);
        sql.append("where b.fid = '").append(billID).append("' ");
        sql.append("union all ");
        sql.append(sb);
        sql.append("where fstocktransbillentryid in (select fstocktransbillentryid  from t_im_moveinwarehsbillentry ");
        sql.append("where fparentid = '" + billID + "') and  b.FBASESTATUS = 4");
        try {
            rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            MoveIn moveIn = null;
            while (rs.next()) {
                moveIn = new MoveIn();
                String stocktransbillentryid = "";
                stocktransbillentryid = rs.getString("stocktransbillentryid");
                String entryID = rs.getString("entryID");
                moveIn.setEntryID(entryID);
                moveIn.setParentID(rs.getString("parentID"));
                moveIn.setSeq(rs.getInt("seq"));
                moveIn.setBasestatus(rs.getInt("basestatus"));
                moveIn.setStocktransbillentryid(stocktransbillentryid);
                moveIn.setActualcost(rs.getBigDecimal("actualcost"));
                moveIn.setBaseqty(rs.getBigDecimal("baseqty"));
                moveIn.setQty(rs.getBigDecimal("qty"));
                moveIn.setUnitactualcost(rs.getBigDecimal("unitactualcost"));
                moveInMap.put(entryID, moveIn);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return moveInMap;
    }

    private Map<String, Integer> getMoveInMaterialPricePrecisionMap(Context ctx, String billID) throws BOSException {
        HashMap<String, Integer> materialPricePrecisionMap = new HashMap<String, Integer>();
        IRowSet rs = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select b.fid as fid,b.fpriceprecision as fpriceprecision from t_bd_material b , ");
        sb.append(" ( ");
        sb.append(" select distinct fmaterialid from t_im_moveinwarehsbillentry a where a.fparentid = '" + billID + "' ");
        sb.append(" ) a ");
        sb.append(" where b.fid=a.fmaterialid ");
        try {
            rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                materialPricePrecisionMap.put(rs.getString("fid"), rs.getInt("fpriceprecision"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return materialPricePrecisionMap;
    }

    private Map<String, Integer> getMoveInSatatusMap(Context ctx, String billID) throws BOSException {
        HashMap<String, Integer> moveInStatusMap = new HashMap<String, Integer>();
        IRowSet rs = null;
        StringBuffer sb = new StringBuffer();
        sb.append("select t.fid fid,t.fbasestatus fbasestatus from t_im_moveinwarehsbill t, ");
        sb.append(" ( ");
        sb.append(" select distinct a.fparentid from t_im_moveinwarehsbillentry a ");
        sb.append(" where fstocktransbillentryid in ");
        sb.append(" (select a.fstocktransbillentryid from t_im_moveinwarehsbillentry a ");
        sb.append(" where a.fparentid = '" + billID + "') ");
        sb.append(" ) b ");
        sb.append(" where t.fid=b.fparentid ");
        try {
            rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                moveInStatusMap.put(rs.getString("fid"), rs.getInt("fbasestatus"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return moveInStatusMap;
    }

    private void getMoveInAuditQty(Map<String, MoveIn> moveInMap, String billID, MoveInWarehsBillEntryInfo entry) {
        String stocktransbillentryid = entry.getStockTransBillEntry().getId().toString();
        List<Object> list = null;
        list = this.dealMoveInMap.containsKey(stocktransbillentryid) ? this.dealMoveInMap.get(stocktransbillentryid) : new ArrayList();
        int status = 0;
        if (this.moveInStatusMap.containsKey(billID)) {
            status = this.moveInStatusMap.get(billID);
        }
        Map.Entry<String, MoveIn> mapentry2 = null;
        Boolean isRepeat = false;
        for (Map.Entry<String, MoveIn> mapentry2 : moveInMap.entrySet()) {
            MoveIn moveIn = mapentry2.getValue();
            if (!stocktransbillentryid.equals(moveIn.getStocktransbillentryid()) || status != 4 || moveIn.getParentID().equals(billID)) continue;
            for (int i = 0; i < list.size(); ++i) {
                if (!((MoveIn)list.get(i)).getEntryID().equals(moveIn.getEntryID())) continue;
                isRepeat = true;
                break;
            }
            if (isRepeat.booleanValue()) continue;
            list.add(moveIn);
        }
        this.dealMoveInMap.put(stocktransbillentryid, list);
    }

    private void handleMoveIn(Map<String, MoveOut> moveOutMap, Map<String, MoveIn> moveInMap, MoveInWarehsBillEntryInfo entry, Map transferEntryStatusMap) throws EASBizException, BOSException {
        String stocktransbillentryid = entry.getStockTransBillEntry().getId().toString();
        String entryID = entry.getId().toString();
        MoveOut moveOut = moveOutMap.get(stocktransbillentryid);
        if (moveOut == null) {
            return;
        }
        MoveIn moveIn = moveInMap.get(entryID);
        if (moveIn == null) {
            return;
        }
        BigDecimal dealQty = SCMServerUtils.ZERO;
        BigDecimal dealActualCost = SCMServerUtils.ZERO;
        List<MoveIn> list = this.dealMoveInMap.get(stocktransbillentryid);
        int pricePrecision = 0;
        if (this.materialPricePrecisionMap.containsKey(entry.getMaterial().getId().toString())) {
            pricePrecision = this.materialPricePrecisionMap.get(entry.getMaterial().getId().toString());
        }
        BigDecimal avgBaseUnitactualcost = moveOut.getTotalActualcost().divide(moveOut.getTotalBaseQty(), pricePrecision, 4);
        MoveIn temp = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            temp = list.get(i);
            dealQty = dealQty.add(temp.getBaseqty());
            dealActualCost = dealActualCost.add(temp.getActualcost());
        }
        Boolean isLast = dealQty.add(entry.getBaseQty()).compareTo(moveOut.getTotalBaseQty()) == 0;
        if (transferEntryStatusMap.get(stocktransbillentryid) != null && ((Boolean)transferEntryStatusMap.get(stocktransbillentryid)).booleanValue() && isLast.booleanValue()) {
            BigDecimal actualCost = SCMServerUtils.ZERO;
            BigDecimal unitActualCost = SCMServerUtils.ZERO;
            actualCost = moveIn.getBaseqty().compareTo(moveOut.getTotalBaseQty()) == 0 ? moveOut.getTotalActualcost() : moveOut.getTotalActualcost().subtract(dealActualCost);
            unitActualCost = actualCost.divide(moveIn.getQty(), pricePrecision, 4);
            entry.setActualCost(actualCost);
            entry.setUnitActualCost(unitActualCost);
            moveIn.setActualcost(actualCost);
            moveIn.setUnitactualcost(unitActualCost);
        } else {
            BigDecimal actualCost = avgBaseUnitactualcost.multiply(entry.getBaseQty()).setScale(this.Local_Currency_Presision, 4);
            if (actualCost.compareTo(BigDecimal.ZERO) == 0 && avgBaseUnitactualcost.compareTo(BigDecimal.ZERO) != 0 && entry.getBaseQty().compareTo(BigDecimal.ZERO) != 0) {
                actualCost = RecentCostHelp.getMinValueByScale(this.Local_Currency_Presision, entry.getBaseQty().signum());
            }
            BigDecimal unitActualCost = actualCost.divide(entry.getQty(), pricePrecision, 4);
            entry.setUnitActualCost(unitActualCost);
            entry.setActualCost(actualCost);
            moveIn.setUnitactualcost(unitActualCost);
            moveIn.setActualcost(actualCost);
        }
        list.add(moveIn);
        this.dealMoveInMap.put(stocktransbillentryid, list);
    }

    public void handleMoveInCost(Context ctx, MoveInWarehsBillInfo bill) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean flag = false;
        IRowSet rs = null;
        try {
            String billID = bill.getId().toString();
            Map<String, MoveOut> moveOutMap = this.getMoveOutMap(ctx, billID);
            Map<String, MoveIn> moveInMap = this.getMoveInMap(ctx, billID);
            this.materialPricePrecisionMap.clear();
            this.materialPricePrecisionMap = this.getMoveInMaterialPricePrecisionMap(ctx, billID);
            this.moveInStatusMap.clear();
            this.moveInStatusMap = this.getMoveInSatatusMap(ctx, billID);
            MoveInWarehsBillEntryCollection col = bill.getEntry();
            MoveInWarehsBillEntryInfo entry = null;
            this.dealMoveInMap.clear();
            conn = EJBFactory.getConnection((Context)ctx);
            String sql = "update t_im_moveinwarehsbillentry set factualcost=?,funitactualcost=? where fid=?";
            ps = conn.prepareStatement(sql);
            Set mats = this.getMoveWeigAverMats(ctx, bill);
            HashMap<String, Boolean> transferEntryStatusMap = new HashMap<String, Boolean>();
            StringBuffer ksql = new StringBuffer();
            ksql.append(" SELECT fid,fbaseStatus FROM T_IM_STOCKTRANSFERBILLENTRY where fid in (");
            ksql.append(" SELECT FSTOCKTRANSBILLENTRYID  FROM T_IM_MOVEINWAREHSBILLENTRY ");
            ksql.append(" WHERE fparentid  = '").append(billID).append("')");
            rs = DBUtil.executeQuery((Context)ctx, (String)ksql.toString());
            while (rs.next()) {
                transferEntryStatusMap.put(rs.getString("fid"), 7 == rs.getInt("fbaseStatus"));
            }
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                entry = col.get(i);
                if (!mats.contains(entry.getMaterial().getId().toString())) continue;
                flag = true;
                this.getMoveInAuditQty(moveInMap, billID, entry);
                this.handleMoveIn(moveOutMap, moveInMap, entry, transferEntryStatusMap);
                ps.setBigDecimal(1, entry.getActualCost());
                ps.setBigDecimal(2, entry.getUnitActualCost());
                ps.setString(3, entry.getId().toString());
                ps.addBatch();
            }
            if (flag) {
                ps.executeBatch();
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, ps);
                throw throwable;
            }
        }
        DBUtil.close(conn, ps);
    }

    private Set getMoveWeigAverMats(Context ctx, MoveInWarehsBillInfo bill) throws BOSException {
        HashSet<String> retMats = new HashSet<String>();
        MoveInWarehsBillEntryCollection col = bill.getEntry();
        if (col == null || col.size() < 1) {
            return retMats;
        }
        HashSet<String> mats = new HashSet<String>();
        MoveInWarehsBillEntryInfo entry = null;
        String companyID = null;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            if (entry != null && entry.getMaterial() != null && entry.getMaterial().getId() != null) {
                mats.add(entry.getMaterial().getId().toString());
            }
            if (entry == null || entry.getCompanyOrgUnit() == null || entry.getCompanyOrgUnit().getId() == null) continue;
            companyID = entry.getCompanyOrgUnit().getId().toString();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", companyID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", mats, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("accountType", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("accountType", (Object)2, CompareType.EQUALS));
        filter.setMaskString(" #0 AND #1 AND (#2 OR #3)");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("mateial.id"));
        EntityViewInfo ev = new EntityViewInfo();
        ev.setSelector(sic);
        ev.setFilter(filter);
        MaterialCompanyInfoCollection coll = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(ev);
        for (int index = 0; index < coll.size(); ++index) {
            MaterialCompanyInfoInfo matInfo = coll.get(index);
            if (matInfo == null || matInfo.getId() == null) continue;
            retMats.add(matInfo.getMateial().getId().toString());
        }
        return retMats;
    }

    class MoveIn {
        String entryID;
        String parentID;
        int seq;
        int basestatus;
        String stocktransbillentryid;
        BigDecimal actualcost;
        BigDecimal qty;
        BigDecimal baseqty;
        BigDecimal unitactualcost;

        MoveIn() {
        }

        public String getEntryID() {
            return this.entryID;
        }

        public void setEntryID(String entryID) {
            this.entryID = entryID;
        }

        public String getParentID() {
            return this.parentID;
        }

        public void setParentID(String parentID) {
            this.parentID = parentID;
        }

        public int getSeq() {
            return this.seq;
        }

        public void setSeq(int seq) {
            this.seq = seq;
        }

        public int getBasestatus() {
            return this.basestatus;
        }

        public void setBasestatus(int basestatus) {
            this.basestatus = basestatus;
        }

        public String getStocktransbillentryid() {
            return this.stocktransbillentryid;
        }

        public void setStocktransbillentryid(String stocktransbillentryid) {
            this.stocktransbillentryid = stocktransbillentryid;
        }

        public BigDecimal getActualcost() {
            return this.actualcost;
        }

        public void setActualcost(BigDecimal actualcost) {
            this.actualcost = actualcost;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public BigDecimal getBaseqty() {
            return this.baseqty;
        }

        public void setBaseqty(BigDecimal baseqty) {
            this.baseqty = baseqty;
        }

        public BigDecimal getUnitactualcost() {
            return this.unitactualcost;
        }

        public void setUnitactualcost(BigDecimal unitactualcost) {
            this.unitactualcost = unitactualcost;
        }
    }

    class MoveOut {
        String stocktransbillentryid;
        BigDecimal totalBaseQty;
        BigDecimal avgUnitactualcost;
        BigDecimal totalActualcost;
        BigDecimal totalDealBaseQty;

        MoveOut() {
        }

        public String getStocktransbillentryid() {
            return this.stocktransbillentryid;
        }

        public void setStocktransbillentryid(String stocktransbillentryid) {
            this.stocktransbillentryid = stocktransbillentryid;
        }

        public BigDecimal getTotalBaseQty() {
            return this.totalBaseQty;
        }

        public void setTotalBaseQty(BigDecimal totalBaseQty) {
            this.totalBaseQty = totalBaseQty;
        }

        public BigDecimal getAvgUnitactualcost() {
            return this.avgUnitactualcost;
        }

        public void setAvgUnitactualcost(BigDecimal avgUnitactualcost) {
            this.avgUnitactualcost = avgUnitactualcost;
        }

        public BigDecimal getTotalActualcost() {
            return this.totalActualcost;
        }

        public void setTotalActualcost(BigDecimal totalActualcost) {
            this.totalActualcost = totalActualcost;
        }

        public BigDecimal getTotalDealBaseQty() {
            return this.totalDealBaseQty;
        }

        public void setTotalDealBaseQty(BigDecimal totalDealBaseQty) {
            this.totalDealBaseQty = totalDealBaseQty;
        }
    }
}

