/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.common.perf.IJobInstStatusFacade;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtils;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.AbstractRecentCostInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostComputeReportInfo;
import com.kingdee.eas.scm.cal.PriceSourEnum;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.BalanceCostInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculateCost;
import com.kingdee.eas.scm.cal.app.calculate.interfaces.IDBExtends;
import com.kingdee.eas.scm.cal.app.help.CostComputeHelp;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.app.help.UpdateBillCostHelper;
import com.kingdee.eas.scm.cal.help.CalcCycleTrans;
import com.kingdee.eas.scm.cal.help.Topology;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class WeightedAverageCalculateNew
extends AbstractCalculateCost
implements IDBExtends {
    private Logger logger = Logger.getLogger(WeightedAverageCalculateNew.class);
    private static final String res = "com.kingdee.eas.scm.cal.CALAutoGenerateResource";
    private AccountType accountType = AccountType.ADD_AVERAGE;
    private int dfPricePresion = 8;
    boolean isAddLot = false;
    private CountDownLatch countDown;
    private String salesDeliveryRes = null;
    private String endBalanceRes = null;
    private String notCalBalanceRes = null;
    private String costnegativeRxceptionRes = null;
    private String costzeroExceptionRes = null;
    private String settleAccountsExceptionRes = null;
    private String costMoveCycleRes = null;

    @Override
    protected boolean calculateStrategy(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        Connection conn = null;
        PeriodInfo perPeriod = null;
        LowTimer timer = new LowTimer();
        LowTimer calcuateTimer = new LowTimer();
        conn = sysTempTableHelper.getConn();
        if (5 == params.getInt("ACCOUNT_TYPE")) {
            this.accountType = AccountType.SPECIAL_ACCT;
            this.isAddLot = true;
        }
        try {
            perPeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
            params.setObject("perPeriod", (Object)perPeriod);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        params.setBoolean("isCalReversed", true);
        params.setBoolean("IsNeedReWork", true);
        String jobId = (String)ctx.get((Object)"SCM_JOB_INST_ID");
        IJobInstStatusFacade iJobInstStatusFacade = JobInstStatusFacadeFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 5, "", ResourceBase.getString((String)res, (String)"247_PutDataToTempTable", (Locale)this.l2), ResourceBase.getString((String)res, (String)"247_PutDataToTempTable", (Locale)this.l3));
        }
        params.setBoolean("calculteCostPriceMovein", true);
        this.logger.info((Object)("\u6e05\u9664\u5f53\u524d\u8d22\u52a1\u7ec4\u7ec7\u7684\u5220\u9664\u6210\u672c\u8ba1\u7b97\u62a5\u544a\u65f6\u95f4\uff1a" + timer.msValue()));
        String tempTableFIFOBills = params.getString("T_Temp_FIFOBills");
        String tempMaterialTable = params.getString("T_Temp_FIFOMaterialListNew");
        this.initResourc(ctx);
        this.beforeCalculate(ctx, params, strCalType, periodInfo, sysTempTableHelper, conn, timer, tempTableFIFOBills, tempMaterialTable);
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 65, "", ResourceBase.getString((String)res, (String)"255_CostCalculating", (Locale)this.l2), ResourceBase.getString((String)res, (String)"255_CostCalculating", (Locale)this.l3));
        }
        String materialSql = this.getMaterialSqlNew(ctx, tempMaterialTable, params);
        int materialPage = this.getMaterialPageCount(sysTempTableHelper, tempMaterialTable);
        this.countDown = new CountDownLatch(materialPage);
        int threadNum = this.getThreadPoolNum(ctx);
        ExecutorService executor = Executors.newFixedThreadPool(threadNum);
        for (int i = 0; i < materialPage; ++i) {
            CalculateThreadForWeightedAvg calThread = new CalculateThreadForWeightedAvg(ctx, params, sysTempTableHelper, conn, materialSql, periodInfo, i * 1000, tempTableFIFOBills, strCalType);
            executor.execute(calThread);
        }
        try {
            this.countDown.await();
            this.handleOtherData(ctx, sysTempTableHelper, params, periodInfo, tempTableFIFOBills, strCalType);
        }
        catch (InterruptedException e) {
            this.logger.info((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            this.logger.info((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        executor.shutdown();
        if (this.ExceptionList.size() > 0) {
            this.logger.info(this.ExceptionList.get(0));
            throw new BOSException((Throwable)this.ExceptionList.get(0));
        }
        this.logger.info((Object)("\u8ba1\u7b97\u6210\u672c\u603b\u65f6\u95f4\uff1a" + calcuateTimer.msValue()));
        return false;
    }

    private void beforeCalculate(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper, Connection conn, LowTimer timer, String tempTableFIFOBills, String tempMaterialTable) throws BOSException {
        try {
            this.checkInterrupted();
            timer.reset();
            this.buildInOutBillsData(ctx, sysTempTableHelper, periodInfo, strCalType, params, tempTableFIFOBills);
            this.logger.info((Object)("\u5165\u5e93\u548c\u51fa\u5e93\u5355\u636e\u53d6\u6570\u65f6\u95f4\uff1a" + timer.msValue()));
            this.checkInterrupted();
            timer.reset();
            this.buildPrePeriodCostMoveBill(ctx, sysTempTableHelper, params, strCalType, periodInfo, tempTableFIFOBills);
            this.logger.info((Object)("\u4ee5\u524d\u671f\u95f4\u7684\u6210\u672c\u4ef7\u8c03\u62e8\u53d6\u6570\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            this.adjustPrePeriodData(sysTempTableHelper, params, periodInfo, tempTableFIFOBills);
            this.logger.info((Object)("\u8fdb\u884c\u6570\u636e\u8c03\u6574\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            sysTempTableHelper.analyzeTable(tempTableFIFOBills);
            this.logger.info((Object)("\u7edf\u8ba1\u5206\u6790\u4e34\u65f6\u8868\u65f6\u95f4\uff1a\uff1a" + timer.msValue()));
            StringBuffer sqlmaterial = this.takeMatrialListNew(ctx, strCalType, tempTableFIFOBills);
            timer.reset();
            this.insertFIFOMaterialTMPTableNew(sysTempTableHelper, sqlmaterial, tempMaterialTable);
            this.logger.info((Object)("\u6784\u9020\u7269\u6599\u904d\u5386\u96c6\u5408\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            this.getEntrustMaterial(sysTempTableHelper, tempMaterialTable, params, strCalType);
            this.logger.info((Object)("\u83b7\u53d6\u6709\u59d4\u6258\u4ee3\u9500\u4e1a\u52a1\u7684\u7269\u6599\uff1a" + timer.msValue()));
            timer.reset();
            this.getNeedUpdateMoveLocBillMaterial(sysTempTableHelper, tempMaterialTable, params, periodInfo);
            this.logger.info((Object)("\u9700\u8981\u66f4\u65b0\u5e93\u4f4d\u79fb\u52a8\u5355\u6210\u672c\u7684\u7269\u6599\uff1a" + timer.msValue()));
            timer.reset();
            ArrayList sqlParams = new ArrayList();
            sysTempTableHelper.execute(this.clearOldPeriodData(params, strCalType, sqlParams), sqlParams);
            params.setString("ERROR_MSG", SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COST_NOT_PRICE", (Context)ctx));
            params.setString("DETAILADJUST", SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"DETAILADJUST", (Context)ctx));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new BOSException("\u5176\u4ed6\u4efb\u52a1\u5df2\u4e2d\u65ad job was interrupted by other thread \n" + e);
        }
    }

    private void getEntrustMaterial(SysTempTableHelper sysTempTableHelper, String tempTableFIFOBills, CalculateParams params, String strCalType) throws BOSException, SQLException {
        if (!params.getBoolean("isChkEntrust")) {
            return;
        }
        PeriodInfo periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        Set<String> entrustMaterialIdSet = new HashSet();
        HashMap entrustMaterialIdMap = new HashMap();
        StringBuffer sql = new StringBuffer();
        sql.append("select DISTINCT ENTRY.FMATERIALID as FMATERIALID, ENTRY.FCOMPANYORGUNITID as FCOMPANYORGUNITID,");
        sql.append(" ENTRY.FSTORAGEORGUNITID as FSTORAGEORGUNITID,ENTRY.FWAREHOUSEID as FWAREHOUSEID, MATERIALCOMPANY.FACCOUNTTYPE as FACCOUNTTYPE,");
        sql.append(" (case when MATERIALCOMPANY.FIsLot = 1 then isnull(ENTRY.FLot,'X') else null end) AS FLOT,");
        sql.append(" (case when MATERIALCOMPANY.FIsAssistProperty = 1 then isnull(ENTRY.FAssistPropertyID,'X') else null end) AS FAssistPropertyID, ");
        sql.append("(case when MATERIALCOMPANY.FIsProject = 1  then isnull(ENTRY.FProjectID,'X') else null end) AS FProjectID, ");
        sql.append("(case when MATERIALCOMPANY.FIsTrackNumber = 1  then isnull(ENTRY.FTrackNumberID,'X') else null end) AS FTrackNumberID");
        sql.append(" from T_IM_SALEISSUEENTRY ENTRY").append("\t\n");
        sql.append(" INNER JOIN T_IM_SALEISSUEBILL BILL on BILL.fid = ENTRY.fparentid").append("\t\n");
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY  ON (ENTRY.FMaterialId = MATERIALCOMPANY.FMaterialID ");
        sql.append("\t AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )");
        sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID ").append("\t\n");
        sql.append(" INNER JOIN T_IM_StoreType StoreTypePre ON InvUpdateType.FStoreTypePreID = StoreTypePre.FID ").append("\t\n");
        sql.append(" LEFT JOIN T_IM_StoreType StoreType ON InvUpdateType.FStoreTypeID = StoreType.FID ").append("\t\n");
        sql.append(" WHERE BILL.FYEAR = ").append(periodInfo.getPeriodYear()).append("\t\n");
        sql.append(" AND BILL.FPERIOD = ").append(periodInfo.getPeriodNumber()).append("\t\n");
        sql.append(" AND ENTRY.FBIZDATE >= to_date('").append(periodInfo.getBeginDate()).append("')").append("\t\n");
        sql.append(" AND ENTRY.FBIZDATE <= to_date('").append(periodInfo.getEndDate()).append("')").append("\t\n");
        sql.append(" AND ENTRY.FMATERIALID in ( select DISTINCT FMATERIALID from ").append(tempTableFIFOBills).append(" ) ").append("\t\n");
        sql.append(" AND ENTRY.FCompanyOrgUnitID = '").append(params.getString("COMPANY_ID")).append("'");
        sql.append(" AND case when ENTRY.FQTY < 0 THEN StoreType.FID ELSE StoreTypePre.FID END ='").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("'").append("\t\n");
        sql.append(" AND BILL.FBaseStatus = ").append(4);
        IRowSet rs = sysTempTableHelper.executeQuery(sql.toString());
        StringBuffer key = new StringBuffer();
        String separator = "_$$$$_";
        String defultValue = "X";
        while (rs.next()) {
            key.setLength(0);
            key.append(rs.getString("FCOMPANYORGUNITID"));
            if ("1".equals(strCalType)) {
                key.append(separator).append(rs.getString("FSTORAGEORGUNITID"));
            } else if ("2".equals(strCalType)) {
                key.append(separator).append(rs.getString("FSTORAGEORGUNITID"));
                key.append(separator).append(rs.getString("FWAREHOUSEID"));
            }
            if (5 == rs.getInt("FACCOUNTTYPE")) {
                key.append(separator).append(rs.getString("FLOT") == null ? defultValue : rs.getString("FLOT"));
                key.append(separator).append(rs.getString("FAssistPropertyID") == null ? defultValue : rs.getString("FAssistPropertyID"));
                key.append(separator).append(rs.getString("FProjectID") == null ? defultValue : rs.getString("FProjectID"));
                key.append(separator).append(rs.getString("FTrackNumberID") == null ? defultValue : rs.getString("FTrackNumberID"));
            }
            if ((entrustMaterialIdSet = (Set)entrustMaterialIdMap.get(rs.getString("FMATERIALID"))) == null) {
                entrustMaterialIdSet = new HashSet();
                entrustMaterialIdMap.put(rs.getString("FMATERIALID"), entrustMaterialIdSet);
            }
            entrustMaterialIdSet.add(key.toString());
        }
        params.setObject("entrustMaterialIdMap", entrustMaterialIdMap);
    }

    private HashMap handleAvgCalculate(Context ctx, Connection conn, CalculateParams params, RptRowSet rsMaterial, String strCalType, PeriodInfo periodInfo) throws EASBizException, BOSException {
        HashMap hashMap;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.checkInterrupted();
            String materialId = rsMaterial.getString("FMaterialID");
            params.setString("CurrMaterialId", materialId);
            String tempTableFIFOBills = params.getString("T_Temp_FIFOBills");
            StringBuffer sql = this.getOrderBillSql(tempTableFIFOBills, materialId, rsMaterial);
            HashMap matAttrChgMap = new HashMap();
            ArrayList<RecentCostInfo> inBillList = new ArrayList<RecentCostInfo>();
            ArrayList<RecentCostInfo> outBillList = new ArrayList<RecentCostInfo>();
            LinkedHashMap costMoveMap = new LinkedHashMap();
            ArrayList calOrder = new ArrayList();
            ArrayList<RecentCostInfo> redBillList = new ArrayList<RecentCostInfo>();
            ArrayList<RecentCostInfo> revereList = new ArrayList<RecentCostInfo>();
            ArrayList<RecentCostInfo> outRetInList = new ArrayList<RecentCostInfo>();
            ArrayList<RecentCostInfo> inBillNeddUpdated = new ArrayList<RecentCostInfo>();
            HashMap<String, RecentCostInfo> prePeriodCostMoveMap = new HashMap<String, RecentCostInfo>();
            ArrayList reWorkMatReqBillList = new ArrayList();
            RecentCostInfo periodBegin = null;
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            long timeSerialNumber = new Date().getTime();
            HashMap<String, RecentCostInfo> periodBeginBillMap = new HashMap<String, RecentCostInfo>();
            Map<String, String> redAndBlueIdMap = this.getRedAndBlueBillEntryIdMap(ctx, params, tempTableFIFOBills, rsMaterial);
            while (rs.next()) {
                RecentCostInfo bill;
                if (!calOrder.contains((bill = this.convertRecentCostInfo(rs, strCalType, ++timeSerialNumber, this.isAddLot, redAndBlueIdMap)).getFkeyID())) {
                    calOrder.add(bill.getFkeyID());
                }
                if (2 == bill.getInt("FCalculateKind")) {
                    if (periodBeginBillMap.get(bill.getFkeyID()) == null) {
                        periodBeginBillMap.put(bill.getFkeyID(), bill);
                        RecentCostHelp.calculateAvgPrice(bill);
                    } else {
                        periodBegin = (RecentCostInfo)periodBeginBillMap.get(bill.getFkeyID());
                        periodBegin.setRecentCost(periodBegin.getRecentCost().add(bill.getRecentCost()));
                        periodBegin.setRecentQty(periodBegin.getRecentQty().add(bill.getRecentQty()));
                        RecentCostHelp.calculateAvgPrice(periodBegin);
                        continue;
                    }
                }
                if (bill.getInt("FFiVouchered") == 1) {
                    bill.setPriceSource(PriceSourEnum.fiVouchered);
                    bill.setDealComplete(true);
                }
                Boolean isInBill4SaleReturn = this.isInBillForSaleReturn(bill, params);
                if (params.getBoolean("isNotSrcOutBillCalType") || params.getBoolean("isSrcPerBillOutBillCalType")) {
                    if (bill.isNotSrcOutRetBill() && params.getBoolean("isNotSrcOutBillCalType") && bill.getFBlueBillEntryID() == null) {
                        if (!bill.isDealComplete()) {
                            bill.setPriceSource(PriceSourEnum.userDefine);
                        }
                        bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                    }
                    if (bill.isSrcOutBillInPrePeriod() && params.getBoolean("isSrcPerBillOutBillCalType") || isInBill4SaleReturn.booleanValue()) {
                        bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                        bill.setPriceSource(PriceSourEnum.sourBillPrice);
                    }
                }
                if (bill.isCostPriceMove()) {
                    this.setCostMoveIsCalculate(bill, strCalType, periodInfo);
                    this.buildCostPriceMove(bill, costMoveMap, strCalType);
                    if (bill.isMoveOutBill() && RecentCostHelp.isPrePeriodBill(bill, periodInfo)) {
                        prePeriodCostMoveMap.put(bill.getStockTransBillEntryID(), bill);
                    }
                    if (bill.isSrcOutBillInPrePeriod()) {
                        bill.setNeedUpdate(true);
                    }
                }
                if (bill.isMatAttrChange()) {
                    bill.setBoolean("IsCalculate", false);
                    this.buildMatAttrChange(bill, matAttrChgMap);
                    if (!bill.isOutBill() && !bill.isDealComplete()) {
                        inBillNeddUpdated.add(bill);
                    }
                }
                if (bill.isReWorkBill()) {
                    this.setReWorkBillCost(reWorkMatReqBillList, periodBeginBillMap, inBillNeddUpdated, bill);
                }
                if (1 != bill.getInt("FCalculateKind")) {
                    if (!bill.isCalculate()) continue;
                    if (bill.isCostPriceMove() && bill.isMoveOutBill()) {
                        outBillList.add(bill);
                        continue;
                    }
                    inBillList.add(bill);
                    continue;
                }
                if (1 != bill.getInt("FCalculateKind")) continue;
                if (bill.isRedBill()) {
                    if (bill.isNotSrcOutRetBill() && params.getBoolean("isNotSrcOutBillCalType") && bill.getFBlueBillEntryID() == null || bill.isSrcOutBillInPrePeriod() && params.getBoolean("isSrcPerBillOutBillCalType") || isInBill4SaleReturn.booleanValue()) {
                        inBillList.add(bill);
                        outRetInList.add(bill);
                        bill.setBoolean("isOutRetBillisIn", true);
                    } else {
                        if (bill.isReversed()) {
                            revereList.add(bill);
                        } else {
                            bill.setBoolean("ISADJUSTDIFFER", true);
                            if (bill.getString("fbilltypeid") != null && bill.getString("fbilltypeid").equals(bill.getString("fsourcebilltypeid"))) {
                                bill.setBoolean("ISADJUSTDIFFER", false);
                            }
                            outBillList.add(bill);
                        }
                        redBillList.add(bill);
                    }
                    if (bill.isSrcOutBillInPrePeriod() && !bill.isDealComplete()) {
                        inBillNeddUpdated.add(bill);
                        bill.setPriceSource(PriceSourEnum.sourBillPrice);
                        bill.setNeedUpdate(true);
                    }
                    if (bill.getFBlueBillEntryID() == null || isInBill4SaleReturn.booleanValue()) continue;
                    bill.setPriceSource(PriceSourEnum.sourBillPrice);
                    bill.setNeedUpdate(true);
                    continue;
                }
                if (bill.isReversed()) {
                    revereList.add(bill);
                    continue;
                }
                bill.setBoolean("ISADJUSTDIFFER", true);
                outBillList.add(bill);
            }
            HashMap costMoveCycleMap = new HashMap();
            if (!"0".equals(strCalType)) {
                calOrder = this.setCalOrder(ctx, inBillList, costMoveMap, calOrder, strCalType, costMoveCycleMap);
            }
            this.updateToPrePeriodCostMovePrice(prePeriodCostMoveMap, costMoveMap, inBillNeddUpdated);
            this.handleReversedInList(inBillList, outBillList, revereList, outRetInList, params);
            HashMap balanceMap = this.calculateOutBillCost(ctx, params, inBillList, outBillList, redBillList, reWorkMatReqBillList, strCalType, costMoveMap, null, calOrder);
            this.updateMoveLocationBill(ctx, params, balanceMap, calOrder, strCalType);
            balanceMap.put("INBILLNEEDUPDATED", inBillNeddUpdated);
            balanceMap.putAll(costMoveCycleMap);
            this.calMatAttrChangeCost(matAttrChgMap);
            hashMap = balanceMap;
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return hashMap;
    }

    private void setExceptionState(HashMap balanceMap, String fKey) {
        if (balanceMap == null) {
            return;
        }
        RecentCostInfo resultInfo = null;
        BalanceCostInfo balanceInfo = null;
        balanceInfo = (BalanceCostInfo)((Object)balanceMap.get(fKey));
        if (balanceInfo == null) {
            return;
        }
        resultInfo = balanceInfo.getReusltBillInfo();
        if (resultInfo.isBalanceExcep()) {
            resultInfo.setBoolean("isExceptionState", true);
        }
    }

    private void setReWorkBillCost(ArrayList reWorkMatReqBillList, HashMap periodBeginBillMap, List inBillNeddUpdated, RecentCostInfo bill) {
        RecentCostInfo periodBegin = null;
        if ("1".equals(this.writeCostType)) {
            bill.setBoolean("IsCalculate", false);
            if (bill.getInt("FFiVouchered") != 1 && !bill.isExistSrcBill()) {
                periodBegin = (RecentCostInfo)periodBeginBillMap.get(bill.getFkeyID());
                if (periodBegin != null) {
                    bill.setPrice(periodBegin.getPrice());
                    bill.setPriceSource(PriceSourEnum.periodBeginPriceReWork);
                }
                bill.setRecentCost(bill.getRecentQty().multiply(bill.getPrice()).setScale(bill.getInt("FLocalCurrencyPrecision"), 4));
                inBillNeddUpdated.add(bill);
                bill.setNeedUpdate(true);
            }
            reWorkMatReqBillList.add(bill);
        } else if ("0".equals(this.writeCostType)) {
            bill.setBoolean("IsCalculate", false);
            if (bill.getInt("FFiVouchered") != 1 && !bill.isExistSrcBill()) {
                bill.setPriceSource(PriceSourEnum.userDefine);
                bill.setDealComplete(true);
            }
            reWorkMatReqBillList.add(bill);
        }
    }

    private HashMap handleLotCalculate(Context ctx, Connection conn, CalculateParams params, RptRowSet rsMaterial, String strCalType, PeriodInfo periodInfo) throws EASBizException, BOSException {
        HashMap<String, ArrayList<RecentCostInfo>> hashMap;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.checkInterrupted();
            String materialId = rsMaterial.getString("FMaterialID");
            params.setString("CurrMaterialId", materialId);
            String tempTableFIFOBills = params.getString("T_Temp_FIFOBills");
            StringBuffer sql = this.getOrderBillSql(tempTableFIFOBills, materialId, rsMaterial);
            LinkedHashMap costMoveMap = new LinkedHashMap();
            HashMap<String, AbstractCalculateCost.MatAttrChangeVO> matAttrChgMap = new HashMap<String, AbstractCalculateCost.MatAttrChangeVO>();
            HashMap matLotChgMap = new HashMap();
            ArrayList<RecentCostInfo> inBillList = new ArrayList<RecentCostInfo>();
            ArrayList<RecentCostInfo> outBillList = new ArrayList<RecentCostInfo>();
            HashSet<String> lotOutOrderSet = new HashSet<String>();
            HashSet<String> lotInOrderSet = new HashSet<String>();
            HashSet<String> otherOrderSet = new HashSet<String>();
            ArrayList otherOrder = new ArrayList();
            ArrayList lotOutOrder = new ArrayList();
            ArrayList lotInOrder = new ArrayList();
            HashMap<String, RecentCostInfo> prePeriodCostMoveMap = new HashMap<String, RecentCostInfo>();
            ArrayList<RecentCostInfo> redBillList = new ArrayList<RecentCostInfo>();
            ArrayList<RecentCostInfo> revereList = new ArrayList<RecentCostInfo>();
            ArrayList<RecentCostInfo> outRetInList = new ArrayList<RecentCostInfo>();
            ArrayList<RecentCostInfo> inBillNeddUpdated = new ArrayList<RecentCostInfo>();
            ArrayList reWorkMatReqBillList = new ArrayList();
            RecentCostInfo periodBegin = null;
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            long timeSerialNumber = new Date().getTime();
            HashMap<String, RecentCostInfo> periodBeginBillMap = new HashMap<String, RecentCostInfo>();
            Map<String, String> redAndBlueIdMap = this.getRedAndBlueBillEntryIdMap(ctx, params, tempTableFIFOBills, rsMaterial);
            while (rs.next()) {
                RecentCostInfo bill;
                if (2 == (bill = this.convertRecentCostInfo(rs, strCalType, ++timeSerialNumber, this.isAddLot, redAndBlueIdMap)).getInt("FCalculateKind")) {
                    if (periodBeginBillMap.get(bill.getFkeyID()) == null) {
                        periodBeginBillMap.put(bill.getFkeyID(), bill);
                        RecentCostHelp.calculateAvgPrice(bill);
                    } else {
                        periodBegin = (RecentCostInfo)periodBeginBillMap.get(bill.getFkeyID());
                        periodBegin.setRecentCost(periodBegin.getRecentCost().add(bill.getRecentCost()));
                        periodBegin.setRecentQty(periodBegin.getRecentQty().add(bill.getRecentQty()));
                        RecentCostHelp.calculateAvgPrice(periodBegin);
                        continue;
                    }
                }
                if (bill.getInt("FFiVouchered") == 1) {
                    bill.setPriceSource(PriceSourEnum.fiVouchered);
                    bill.setDealComplete(true);
                }
                Boolean isInBill4SaleReturn = this.isInBillForSaleReturn(bill, params);
                if (params.getBoolean("isNotSrcOutBillCalType") || params.getBoolean("isSrcPerBillOutBillCalType")) {
                    if (bill.isNotSrcOutRetBill() && params.getBoolean("isNotSrcOutBillCalType") && bill.getFBlueBillEntryID() == null) {
                        bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                        if (!bill.isDealComplete()) {
                            bill.setPriceSource(PriceSourEnum.userDefine);
                        }
                    }
                    if (bill.isSrcOutBillInPrePeriod() && params.getBoolean("isSrcPerBillOutBillCalType") || isInBill4SaleReturn.booleanValue()) {
                        bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                        bill.setPriceSource(PriceSourEnum.sourBillPrice);
                    }
                }
                if (bill.isCostPriceMove()) {
                    this.setCostMoveIsCalculate(bill, strCalType, periodInfo);
                    this.buildCostPriceMove(bill, costMoveMap, strCalType);
                    if (bill.isMoveOutBill() && RecentCostHelp.isPrePeriodBill(bill, periodInfo)) {
                        prePeriodCostMoveMap.put(bill.getStockTransBillEntryID(), bill);
                    }
                    if (bill.isSrcOutBillInPrePeriod()) {
                        if (!bill.isDealComplete()) {
                            bill.setPriceSource(PriceSourEnum.sourBillPrice);
                        }
                        bill.setNeedUpdate(true);
                    }
                }
                if (bill.isMatAttrChange()) {
                    if (bill.isMatAttrChange()) {
                        this.buildMatAttrChange(bill, matLotChgMap);
                        if (!bill.isOutBill() && !bill.getBoolean("IS_DEAL_COMPLETE")) {
                            inBillNeddUpdated.add(bill);
                        }
                    }
                } else {
                    otherOrderSet.add(bill.getFkeyID());
                }
                if (bill.isReWorkBill()) {
                    this.setReWorkBillCost(reWorkMatReqBillList, periodBeginBillMap, inBillNeddUpdated, bill);
                }
                if (!bill.isOutBill()) {
                    if (!bill.isCalculate()) continue;
                    if (bill.isCostPriceMove() && bill.isMoveOutBill()) {
                        outBillList.add(bill);
                        continue;
                    }
                    inBillList.add(bill);
                    continue;
                }
                if (bill.isRedBill()) {
                    if (bill.isNotSrcOutRetBill() && params.getBoolean("isNotSrcOutBillCalType") && bill.getFBlueBillEntryID() == null || bill.isSrcOutBillInPrePeriod() && params.getBoolean("isSrcPerBillOutBillCalType") || isInBill4SaleReturn.booleanValue()) {
                        inBillList.add(bill);
                        outRetInList.add(bill);
                        bill.setBoolean("isOutRetBillisIn", true);
                    } else {
                        if (bill.isReversed()) {
                            revereList.add(bill);
                        } else {
                            bill.setBoolean("ISADJUSTDIFFER", true);
                            if (bill.getString("fbilltypeid") != null && bill.getString("fbilltypeid").equals(bill.getString("fsourcebilltypeid"))) {
                                bill.setBoolean("ISADJUSTDIFFER", false);
                            }
                            outBillList.add(bill);
                        }
                        redBillList.add(bill);
                    }
                    if (bill.isSrcOutBillInPrePeriod()) {
                        inBillNeddUpdated.add(bill);
                        bill.setNeedUpdate(true);
                        bill.setPriceSource(PriceSourEnum.sourBillPrice);
                    }
                    if (bill.getFBlueBillEntryID() == null || isInBill4SaleReturn.booleanValue()) continue;
                    bill.setNeedUpdate(true);
                    bill.setPriceSource(PriceSourEnum.sourBillPrice);
                    continue;
                }
                if (bill.isReversed()) {
                    revereList.add(bill);
                    continue;
                }
                bill.setBoolean("ISADJUSTDIFFER", true);
                outBillList.add(bill);
            }
            ArrayList<String> removeKeys = new ArrayList<String>();
            for (String key : matLotChgMap.keySet()) {
                AbstractCalculateCost.MatAttrChangeVO matVo = (AbstractCalculateCost.MatAttrChangeVO)matLotChgMap.get(key);
                if (matVo.getInBillList() == null || matVo.getInBillCount() <= 0 || matVo.getOutBillList() == null || matVo.getOutBillCount() <= 0) continue;
                if (matVo.getInBill(0).getFkeyID().equals(matVo.getOutBill(0).getFkeyID())) {
                    matAttrChgMap.put(key, matVo);
                    removeKeys.add(key);
                    otherOrderSet.add(matVo.getInBill(0).getFkeyID());
                    otherOrderSet.add(matVo.getOutBill(0).getFkeyID());
                    continue;
                }
                lotOutOrderSet.add(matVo.getOutBill(0).getFkeyID());
                lotInOrderSet.add(matVo.getInBill(0).getFkeyID());
            }
            for (String s : removeKeys) {
                matLotChgMap.remove(s);
            }
            otherOrder.addAll(otherOrderSet);
            lotOutOrder.addAll(lotOutOrderSet);
            lotInOrder.addAll(lotInOrderSet);
            this.updateToPrePeriodCostMovePrice(prePeriodCostMoveMap, costMoveMap, inBillNeddUpdated);
            this.handleReversedInList(inBillList, outBillList, revereList, outRetInList, params);
            lotOutOrder = this.setCalOrder(ctx, inBillList, costMoveMap, lotOutOrder, strCalType, null);
            HashMap outLotMap = this.calculateOutBillCost(ctx, params, inBillList, outBillList, redBillList, reWorkMatReqBillList, strCalType, costMoveMap, matAttrChgMap, lotOutOrder);
            this.calMatAttrChangeCost(matLotChgMap);
            lotInOrder = this.setCalOrder(ctx, inBillList, costMoveMap, lotInOrder, strCalType, null);
            HashMap inLotMap = this.calculateOutBillCost(ctx, params, inBillList, outBillList, redBillList, reWorkMatReqBillList, strCalType, costMoveMap, matAttrChgMap, lotInOrder);
            otherOrder = this.setCalOrder(ctx, inBillList, costMoveMap, otherOrder, strCalType, null);
            HashMap otherMap = this.calculateOutBillCost(ctx, params, inBillList, outBillList, redBillList, reWorkMatReqBillList, strCalType, costMoveMap, matAttrChgMap, otherOrder);
            this.updateMoveLocationBill(ctx, params, otherMap, otherOrder, strCalType);
            this.calMatAttrChangeCost(matAttrChgMap);
            this.calBalanceAddMatChange(otherMap);
            HashMap<String, ArrayList<RecentCostInfo>> balanceMap = new HashMap<String, ArrayList<RecentCostInfo>>();
            balanceMap.putAll(outLotMap);
            balanceMap.putAll(inLotMap);
            balanceMap.putAll(otherMap);
            balanceMap.put("INBILLNEEDUPDATED", inBillNeddUpdated);
            hashMap = balanceMap;
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return hashMap;
    }

    private void calBalanceAddMatChange(HashMap otherMap) {
        HashMap noCalInListBillMap = (HashMap)otherMap.get("noCalMatChageInBill");
        if (noCalInListBillMap == null || noCalInListBillMap.isEmpty()) {
            return;
        }
        Iterator iterator = noCalInListBillMap.keySet().iterator();
        BalanceCostInfo balanceCostInfo = null;
        RecentCostInfo resultInfo = null;
        List billList = null;
        RecentCostInfo bill = null;
        while (iterator.hasNext()) {
            String fKeyid = (String)iterator.next();
            balanceCostInfo = (BalanceCostInfo)((Object)otherMap.get(fKeyid));
            resultInfo = balanceCostInfo.getReusltBillInfo();
            if (noCalInListBillMap == null || noCalInListBillMap.get(fKeyid) == null) continue;
            billList = (List)noCalInListBillMap.get(fKeyid);
            int size = billList.size();
            for (int i = 0; i < size; ++i) {
                bill = (RecentCostInfo)billList.get(i);
                resultInfo.setRecentQty(resultInfo.getRecentQty().add(bill.getRecentQty()));
                resultInfo.setRecentCost(resultInfo.getRecentCost().add(bill.getRecentCost()));
            }
        }
        RecentCostHelp.calculateAvgPrice(resultInfo);
    }

    private void handleReversedInList(List inBillList, List outBillList, List reversedList, List outRetInList, CalculateParams params) {
        int size = outRetInList.size();
        RecentCostInfo reversedInfo = null;
        RecentCostInfo outRetInfo = null;
        for (int i = 0; i < size; ++i) {
            outRetInfo = (RecentCostInfo)outRetInList.get(i);
            for (int j = reversedList.size() - 1; j >= 0; --j) {
                reversedInfo = (RecentCostInfo)reversedList.get(j);
                if (!outRetInfo.getString("FBillEntryId").equals(reversedInfo.getString("FSourceBillEntryID"))) continue;
                inBillList.add(reversedInfo);
                reversedInfo.setBoolean("isOutRetBillisIn", true);
                reversedList.remove(j);
            }
        }
        int listSize = reversedList.size();
        for (int k = 0; k < listSize; ++k) {
            reversedInfo = (RecentCostInfo)reversedList.get(k);
            if (!reversedInfo.isSrcBillInPrePeriod()) continue;
            reversedInfo.setNeedUpdate(true);
        }
        if (reversedList.size() > 0) {
            outBillList.addAll(reversedList);
        }
    }

    protected void adjustPrePeriodData(SysTempTableHelper sysTempTableHelper, CalculateParams params, PeriodInfo periodInfo, String tempTableFIFOBills) throws BOSException, SQLException {
        LowTimer tt = new LowTimer();
        sysTempTableHelper.execute(this.getUpateMaterialReqPriceFromPrePeriod(tempTableFIFOBills, periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u9886\u6599\u51fa\u5e93\u9000\u8d27\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        sysTempTableHelper.execute(this.getUpateSaleIssuePriceFromPrePeriod(tempTableFIFOBills, periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u9500\u552e\u51fa\u5e93\u9000\u8d27\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        sysTempTableHelper.execute(this.getUpateOtherIssuePriceFromPrePeriod(tempTableFIFOBills, periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u5176\u4ed6\u51fa\u5e93\u9000\u8d27\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        sysTempTableHelper.execute(this.getUpateCostMoveIssueFromPrePeriod(tempTableFIFOBills, periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u6210\u672c\u4ef7\u8c03\u62d4\u51fa\u9000\u8d27\u5355\u6216\u8005\u51b2\u9500\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        sysTempTableHelper.execute(this.getUpateCostMoveInFromPrePeriod(tempTableFIFOBills, periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u6210\u672c\u4ef7\u8c03\u62d4\u5165\u9000\u8d27\u5355\u6216\u8005\u51b2\u9500\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
    }

    private HashMap calculateOutBillCost(Context ctx, CalculateParams params, List inBillList, List outBillList, List redBillList, List reWorkMatReqBillList, String strCalType, HashMap costMoveMap, HashMap matChangeMap, ArrayList orderList) throws BOSException, CalculateException {
        HashMap<String, HashMap> balanceMap = new HashMap<String, HashMap>();
        String fKey = null;
        HashMap noCalInList = new HashMap();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Object[] param = null;
        BalanceCostInfo bCostInfo = null;
        int listSize = orderList.size();
        for (int k = 0; k < listSize; ++k) {
            fKey = (String)orderList.get(k);
            this.calInBillAvgPrice(ctx, inBillList, balanceMap, costMoveMap, fKey, strCalType, noCalInList, matChangeMap);
            bCostInfo = (BalanceCostInfo)((Object)balanceMap.get(fKey));
            param = this.buildMaterialAveragePrice(bCostInfo, params, strCalType);
            if (param != null) {
                paramsList.add(param);
            }
            this.handleReWorkUnitCost(balanceMap, reWorkMatReqBillList, fKey);
            this.calOutBillCost(ctx, params, outBillList, redBillList, balanceMap, costMoveMap, fKey, strCalType);
            this.handleDetailDiff(outBillList, balanceMap, fKey);
            this.calCostMoveBill(costMoveMap, fKey);
        }
        this.insertAveragePrice(ctx, params, paramsList);
        balanceMap.put("CostPriceMove__", costMoveMap);
        this.setBalanceResultInfo(costMoveMap, noCalInList, balanceMap);
        return balanceMap;
    }

    private Object[] buildMaterialAveragePrice(BalanceCostInfo bCostInfo, CalculateParams params, String strCalType) {
        if (bCostInfo == null) {
            return null;
        }
        RecentCostInfo rCostInfo = bCostInfo.getReusltBillInfo();
        if (rCostInfo == null || rCostInfo.getPriceSource() != PriceSourEnum.averagePrice) {
            return null;
        }
        Object[] param = new Object[12];
        String companyId = params.getString("COMPANY_ID");
        PeriodInfo curPeriod = (PeriodInfo)params.getObject("PERIOD_OBJ");
        param[0] = companyId;
        param[1] = !"0".equals(strCalType) ? rCostInfo.getString("fstorageorgunitid") : "93uhNTdxcafgUztAqMC5Zusff9I=";
        param[2] = "2".equals(strCalType) ? rCostInfo.getString("fwarehouseid") : "93uhNTdycafgUztAqMC5Zrvp+K4=";
        param[3] = rCostInfo.getString("fmaterialid");
        param[4] = rCostInfo.getString("flot");
        param[5] = rCostInfo.getString("fassistpropertyid");
        param[6] = rCostInfo.getString("fprojectid");
        param[7] = rCostInfo.getString("ftracknumberid");
        param[8] = curPeriod.getPeriodYear();
        param[9] = curPeriod.getPeriodNumber();
        param[10] = rCostInfo.getPrice().setScale(rCostInfo.getInt("fpriceprecision"), 6);
        param[11] = 2;
        return param;
    }

    private void insertAveragePrice(Context ctx, CalculateParams params, List<Object[]> paramsList) throws BOSException {
        Set storageOrgSet = (Set)params.getObject("STORAGEORGUNITID");
        Set warehouseSet = (Set)params.getObject("WAREHOUSEID");
        String materialId = params.getString("CurrMaterialId");
        String companyId = params.getString("COMPANY_ID");
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_CL_StockPrice where FCompanyOrgUnitID = '").append(companyId).append("'");
        if (storageOrgSet != null && storageOrgSet.size() > 0) {
            sql.append(" and FStorageOrgUnitId in ").append(CalculateUtil.getSqlIn(storageOrgSet));
        }
        if (warehouseSet != null && warehouseSet.size() > 0) {
            sql.append(" and FWarehouseID in ").append(CalculateUtil.getSqlIn(warehouseSet));
        }
        sql.append(" and FMaterialId = '").append(materialId).append("' and FPriceType = ").append(2);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("insert into T_CL_StockPrice(FID,FAvageDate,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FMaterialID");
        sql.append(",FLot,FAssistPropertyID,FProjectID,FTrackNumberID,FYear,FPeriod,FPrice,FPriceType)");
        sql.append("values(newbosid('E4BFDAF6'),getdate(),?,?,?,?,?,?,?,?,?,?,?,?)");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
    }

    private void calCostMoveBill(HashMap costMoveMap, String fKey) throws CalculateException {
        RecentCostInfo costMoveObj = null;
        RecentCostInfo moveIssueInfo = null;
        for (Map.Entry entry : costMoveMap.entrySet()) {
            costMoveObj = (RecentCostInfo)entry.getValue();
            if (costMoveObj == null || costMoveObj.getMoveOutbillList() == null || costMoveObj.getMoveOutbillList().size() <= 0 || !(moveIssueInfo = (RecentCostInfo)costMoveObj.getMoveOutbillList().get(0)).getFkeyID().equals(fKey)) continue;
            this.calCostMoveBill(costMoveObj, moveIssueInfo, false);
        }
    }

    private void setBalanceResultInfo(HashMap costMoveMap, HashMap noCalInList, HashMap balanceMap) {
        if (noCalInList.size() == 0) {
            return;
        }
        HashMap<String, BigDecimal> costTotalMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> costMoveInBill = new HashMap<String, BigDecimal>();
        Iterator costMoveMapIter = costMoveMap.keySet().iterator();
        String FStockTransBill = null;
        RecentCostInfo moveCostBill = null;
        ArrayList moveInBill = null;
        RecentCostInfo moveInCostBill = null;
        while (costMoveMapIter.hasNext()) {
            FStockTransBill = costMoveMapIter.next().toString();
            moveCostBill = (RecentCostInfo)costMoveMap.get(FStockTransBill);
            moveInBill = moveCostBill.getMoveInbillList();
            if (moveInBill == null) continue;
            int listSize = moveInBill.size();
            for (int i = 0; i < listSize; ++i) {
                moveInCostBill = (RecentCostInfo)moveInBill.get(i);
                String id = moveInCostBill.getString("fbillentryid");
                costMoveInBill.put(id, moveInCostBill.getRecentCost());
            }
        }
        Iterator iter = noCalInList.keySet().iterator();
        String billID = null;
        BigDecimal tempCost = null;
        BigDecimal oldCost = null;
        String fKey = null;
        while (iter.hasNext()) {
            billID = iter.next().toString();
            fKey = noCalInList.get(billID).toString();
            tempCost = (BigDecimal)costMoveInBill.get(billID);
            if (costTotalMap.get(fKey) != null) {
                oldCost = (BigDecimal)costTotalMap.get(fKey);
                costTotalMap.put(fKey, oldCost.add(tempCost));
                continue;
            }
            costTotalMap.put(fKey, tempCost);
        }
        Iterator totalIter = costTotalMap.keySet().iterator();
        String fKeyid = null;
        BalanceCostInfo balanceCostInfo = null;
        RecentCostInfo resultInfo = null;
        BigDecimal totalCost = null;
        BigDecimal tempQty = null;
        HashMap noCalInListBillQty = (HashMap)balanceMap.get("noCalInListBillQty");
        while (totalIter.hasNext()) {
            fKeyid = totalIter.next().toString();
            totalCost = (BigDecimal)costTotalMap.get(fKeyid);
            balanceCostInfo = (BalanceCostInfo)((Object)balanceMap.get(fKeyid));
            resultInfo = balanceCostInfo.getReusltBillInfo();
            if (noCalInListBillQty != null && noCalInListBillQty.get(fKeyid) != null) {
                tempQty = (BigDecimal)noCalInListBillQty.get(fKeyid);
                resultInfo.setRecentQty(resultInfo.getRecentQty().add(tempQty));
            }
            resultInfo.setRecentCost(resultInfo.getRecentCost().add(totalCost));
            RecentCostHelp.calculateAvgPrice(resultInfo);
        }
    }

    private void calInBillAvgPrice(Context ctx, List inBillList, HashMap balanceMap, HashMap costMoveMap, String fKey, String strCalType, HashMap noCalInListBillCost, HashMap matChangeMap) {
        RecentCostInfo bill = null;
        BalanceCostInfo balanceCostInfo = null;
        RecentCostInfo tmpInfo = null;
        HashMap noCalInListBillQty = null;
        HashMap noCalMatChageInBill = null;
        List<RecentCostInfo> matChangeInList = null;
        Set keySet = null;
        if (matChangeMap != null) {
            keySet = matChangeMap.keySet();
        }
        noCalMatChageInBill = balanceMap.get("noCalMatChageInBill") == null ? new HashMap() : (HashMap)balanceMap.get("noCalMatChageInBill");
        noCalInListBillQty = balanceMap.get("noCalInListBillQty") == null ? new HashMap() : (HashMap)balanceMap.get("noCalInListBillQty");
        BigDecimal tempRecentQty = null;
        int listSize = inBillList.size();
        for (int i = 0; i < listSize; ++i) {
            bill = (RecentCostInfo)inBillList.get(i);
            tempRecentQty = BigDecimal.ZERO;
            if (!fKey.equals(bill.getFkeyID())) continue;
            if (keySet != null && bill.getString("FSourceBillEntryID") != null && keySet.contains(bill.getString("FSourceBillEntryID"))) {
                if (noCalMatChageInBill.get(fKey) == null) {
                    matChangeInList = new ArrayList();
                    noCalMatChageInBill.put(fKey, matChangeInList);
                } else {
                    matChangeInList = (List)noCalMatChageInBill.get(fKey);
                }
                matChangeInList.add(bill);
                continue;
            }
            balanceCostInfo = (BalanceCostInfo)((Object)balanceMap.get(fKey));
            if (balanceCostInfo == null) {
                balanceCostInfo = this.createNewBalanceCostInfo(ctx, strCalType, bill);
                balanceMap.put(fKey, balanceCostInfo);
            }
            if ((tmpInfo = balanceCostInfo.getReusltBillInfo()).getTimestamp("FBizDate") == null) {
                tmpInfo.setTimestamp("FBizDate", bill.getTimestamp("FBizDate"));
            }
            if (bill.getTimestamp("FBizDate").compareTo(tmpInfo.getTimestamp("FBizDate")) > 0) {
                tmpInfo.setTimestamp("FBizDate", bill.getTimestamp("FBizDate"));
            }
            if (bill.isCalculate()) {
                if (!bill.isCostAdjustBill()) {
                    if (bill.isOutBill()) {
                        if (!bill.isCommissionSaleOut()) {
                            tmpInfo.setRecentQty(tmpInfo.getRecentQty().subtract(bill.getRecentQty()));
                        }
                    } else if (bill.isInListCal()) {
                        tmpInfo.setRecentQty(tmpInfo.getRecentQty().add(bill.getRecentQty()));
                    } else {
                        tempRecentQty = tempRecentQty.add(bill.getRecentQty());
                    }
                }
                if (bill.isOutBill()) {
                    if (!bill.isCommissionSaleOut()) {
                        tmpInfo.setRecentCost(tmpInfo.getRecentCost().subtract(bill.getRecentCost()));
                    }
                } else if (bill.isInListCal()) {
                    tmpInfo.setRecentCost(tmpInfo.getRecentCost().add(bill.getRecentCost()));
                } else {
                    noCalInListBillCost.put(bill.getString("fbillentryid"), fKey);
                }
                RecentCostHelp.calculateAvgPrice(tmpInfo, this.dfPricePresion);
                tmpInfo.setPriceSource(PriceSourEnum.averagePrice);
            }
            if (CalculateUtil.ZERO.compareTo(tempRecentQty) == 0) continue;
            if (noCalInListBillQty.get(fKey) != null) {
                BigDecimal tempQty = (BigDecimal)noCalInListBillQty.get(fKey);
                noCalInListBillQty.put(fKey, tempRecentQty.add(tempQty));
                continue;
            }
            noCalInListBillQty.put(fKey, tempRecentQty);
        }
        balanceMap.put("INBILLLIST", inBillList);
        balanceMap.put("noCalInListBillQty", noCalInListBillQty);
        balanceMap.put("noCalMatChageInBill", noCalMatChageInBill);
    }

    private BalanceCostInfo createNewBalanceCostInfo(Context ctx, String strCalType, RecentCostInfo bill) {
        BalanceCostInfo balanceCostInfo = new BalanceCostInfo();
        balanceCostInfo.setStrCalType(strCalType);
        balanceCostInfo.setBigDecimal("balance_Qty", CalculateUtil.ZERO);
        balanceCostInfo.setBigDecimal("balance_ActualCost", CalculateUtil.ZERO);
        balanceCostInfo.setBigDecimal("balance_Price", CalculateUtil.ZERO);
        RecentCostInfo tmpInfo = (RecentCostInfo)bill.clone();
        tmpInfo.setRecentCost(CalculateUtil.ZERO);
        tmpInfo.setRecentQty(CalculateUtil.ZERO);
        tmpInfo.setString("fNumber", this.endBalanceRes);
        tmpInfo.setString("fbilltypename", "");
        RecentCostHelp.calculateAvgPrice(tmpInfo);
        balanceCostInfo.setReusltBillInfo(tmpInfo);
        return balanceCostInfo;
    }

    private void handleReWorkUnitCost(HashMap balanceMap, List reWorkMatReqBillList, String fKey) {
        RecentCostInfo costInfo = null;
        BalanceCostInfo balanceCostInfo = (BalanceCostInfo)((Object)balanceMap.get(fKey));
        if (balanceCostInfo != null) {
            RecentCostInfo tmpInfo = balanceCostInfo.getReusltBillInfo();
            int listSize = reWorkMatReqBillList.size();
            for (int i = 0; i < listSize; ++i) {
                costInfo = (RecentCostInfo)reWorkMatReqBillList.get(i);
                if (!fKey.equals(costInfo.getFkeyID())) continue;
                tmpInfo.setRecentQty(tmpInfo.getRecentQty().subtract(costInfo.getRecentQty()));
                tmpInfo.setRecentCost(tmpInfo.getRecentCost().subtract(costInfo.getRecentCost()));
            }
            RecentCostHelp.calculateAvgPrice(tmpInfo, this.dfPricePresion);
        }
    }

    private void calOutBillCost(Context ctx, CalculateParams params, List outBillList, List redBillList, HashMap balanceMap, HashMap costMoveMap, String fKey, String strCalType) throws BOSException, CalculateException {
        HashMap entrustMaterialIdMap;
        HashSet entrustMaterialIdSet;
        RecentCostInfo resultInfo;
        RecentCostInfo bill = null;
        for (int i = outBillList.size() - 1; i >= 0 && !fKey.equals((bill = (RecentCostInfo)outBillList.get(i)).getFkeyID()); --i) {
        }
        BalanceCostInfo balanceCostInfo = (BalanceCostInfo)((Object)balanceMap.get(fKey));
        if (bill == null && balanceCostInfo == null) {
            return;
        }
        if (bill != null && !fKey.equals(bill.getFkeyID())) {
            return;
        }
        if (balanceCostInfo == null) {
            balanceCostInfo = this.createNewBalanceCostInfo(ctx, strCalType, bill);
            balanceMap.put(fKey, balanceCostInfo);
        }
        if ((resultInfo = balanceCostInfo.getReusltBillInfo()) == null) {
            return;
        }
        if (outBillList.size() > 0) {
            resultInfo.setPriceSource(PriceSourEnum.averagePrice);
            if (CalculateUtil.ZERO.compareTo(resultInfo.getPrice()) == 0) {
                BigDecimal price = null;
                if (this.priceType == 0 || this.priceType == 1) {
                    price = this.getNewPrice(ctx, params, resultInfo);
                    resultInfo.setPrice(price);
                }
                if (price == null) {
                    resultInfo.setPrice(this.getPriceByParamter(ctx, params, fKey));
                }
                if (this.priceType == 0) {
                    resultInfo.setPriceSource(PriceSourEnum.newOut);
                } else if (this.priceType == 1) {
                    resultInfo.setPriceSource(PriceSourEnum.newIn);
                } else if (this.priceType == 2) {
                    resultInfo.setPriceSource(PriceSourEnum.standUnitPrice);
                } else if (this.priceType == 4) {
                    resultInfo.setPriceSource(PriceSourEnum.newReturnPrice);
                }
                params.setBoolean("IsNevPrice", false);
            }
            if (resultInfo.isPriceExcep()) {
                resultInfo.setBoolean("isNegativePriceState", true);
                int listSize = outBillList.size();
                for (int i = 0; i < listSize; ++i) {
                    RecentCostInfo outBillInfo = (RecentCostInfo)outBillList.get(i);
                    if (!fKey.equals(outBillInfo.getFkeyID()) || outBillInfo.getInt("isrework") == 1 || outBillInfo.getPriceSource() == PriceSourEnum.sourBillPrice) continue;
                    if (!outBillInfo.isDealComplete()) {
                        outBillInfo.setPriceSource(PriceSourEnum.negativePrice);
                        if (this.priceType == 3 && outBillInfo.getPrice().compareTo(BigDecimal.ZERO) > 0) {
                            outBillInfo.setPriceSource(PriceSourEnum.userDefine);
                        }
                    }
                    outBillInfo.setDealComplete(true);
                }
            }
            if (resultInfo.getPrice().compareTo(BigDecimal.ZERO) == 0) {
                boolean isZeroPriceState = false;
                int listSize = outBillList.size();
                for (int i = 0; i < listSize; ++i) {
                    RecentCostInfo outBillInfo = (RecentCostInfo)outBillList.get(i);
                    if (!fKey.equals(outBillInfo.getFkeyID()) || outBillInfo.isReWorkBill()) continue;
                    if (!(outBillInfo.isDealComplete() || outBillInfo.getPriceSource() != null && PriceSourEnum.averagePrice != outBillInfo.getPriceSource() || outBillInfo.getString("fbilltypeid") == null || outBillInfo.getString("fbilltypeid").equals(outBillInfo.getString("fsourcebilltypeid")))) {
                        outBillInfo.setPriceSource(PriceSourEnum.zeroPrice);
                        if (this.priceType == 3 && outBillInfo.getPrice().compareTo(BigDecimal.ZERO) > 0) {
                            outBillInfo.setPriceSource(PriceSourEnum.userDefine);
                        }
                    }
                    if (PriceSourEnum.sourBillPrice != outBillInfo.getPriceSource() && outBillInfo.getString("fbilltypeid") != null && !outBillInfo.getString("fbilltypeid").equals(outBillInfo.getString("fsourcebilltypeid"))) {
                        outBillInfo.setDealComplete(true);
                    }
                    if (outBillInfo.getPriceSource() != PriceSourEnum.averagePrice) continue;
                    isZeroPriceState = true;
                }
                if (isZeroPriceState) {
                    resultInfo.setBoolean("isZeroPriceState", true);
                }
            }
            this.calculateOutBillCost(outBillList, redBillList, costMoveMap, fKey, resultInfo, params);
        }
        if (params.getBoolean("isChkEntrust") && (entrustMaterialIdSet = (HashSet)(entrustMaterialIdMap = (HashMap)params.getObject("entrustMaterialIdMap")).get(params.getString("CurrMaterialId"))) != null && entrustMaterialIdSet.contains(fKey)) {
            this.calBillForEntrust(ctx, params, outBillList, strCalType, fKey);
        }
        balanceMap.put("OUTBILLLIST", outBillList);
        this.calculateBalance(outBillList, fKey, strCalType, resultInfo, balanceMap, params);
    }

    private void calBillForEntrust(Context ctx, CalculateParams params, List outBillList, String strCalType, String fkey) throws BOSException {
        try {
            SysTempTableHelper sysTempTableHelper = (SysTempTableHelper)params.getObject("sysTempTableHelper");
            HashMap keyParam = this.getParamFromKey(fkey, strCalType, params);
            params.setObject("OUTBILLLIST", (Object)outBillList);
            params.setString("curFKeyID", fkey);
            this.costBillForEntrust(ctx, params, strCalType, sysTempTableHelper, keyParam);
            params.setObject("OUTBILLLIST", null);
            String entrustEntryId = params.getString("EntrustEntryId");
            if (entrustEntryId != null && entrustEntryId.length() > 0) {
                ArrayList entrustBillList;
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT Bill.FBillEntryId FID, Bill.FBillId, Bill.FBillEntryId, FEntryTableMame, Bill.FNumber, Bill.FBizDate,");
                sql.append(" Bill.FCompanyOrgUnitID, Bill.FMaterialId, Bill.FStorageorg, Bill.Fstorageorgunitid, Bill.Fwarehouse, Bill.Fwarehouseid,");
                sql.append(" case when FCalculateKind = 2 then FPeriodBeginQty else Bill.FBaseQty end FBaseQty,");
                sql.append(" case when FCalculateKind = 2 then FPeriodBeginQty else Bill.FBaseQty end FBaseQtyBak,");
                sql.append(" case when FCalculateKind = 2 then FPeriodBeginBalance else Bill.FActualCost end FActualCost,");
                sql.append(" Bill.FBaseUnitActualCost as FPrice, Bill.FReverseQty, Bill.FPricePrecision, Bill.FQtyPrecision, Bill.FLocalCurrencyPrecision,");
                sql.append(" Bill.FCalculateKind, Bill.FbillTypeID, Bill.FTransactionTypeName, Bill.FSeqNum, ISNULL(Bill.FFiVouchered, 0) AS FFiVouchered,");
                sql.append(" Bill.FBizTypeID, Bill.FSourceBillID, Bill.FSourceBillEntryID, Bill.FSourceBillEntrySeq, 0 AS FSourceUnitActualCost,");
                sql.append(" case when FCalculateKind = 2 then FPeriodBeginBalance else Bill.FActualCost end FActualCostBak,");
                sql.append(" Bill.FmaterialNumber, 0 AS FisCombition, 0 AS FisSrcBilInCurrPid, Bill.FIsPresent, BILL.FStockTransBillEntryID,");
                sql.append(" BILL.FAUDITTIME, Bill.FSourceBillTypeID, Bill.FIsReversed, Bill.FIsReWork, Bill.FOutwarehouseType, Bill.FStoreTypeID,");
                sql.append(" Bill.FStoreTypePreID, Bill.FBillTypeName, Bill.FBaseUnit, Bill.FLot, Bill.FAssistPropertyID, Bill.FProjectID, Bill.FTrackNumberID,");
                sql.append(" Bill.FUnitID, Bill.FQty, Bill.FWrittenOffBaseQty, Bill.FUnWriteOffBaseQty, Bill.FisWriteOffVouched, Bill.FBASECONVSRATE,");
                sql.append(" Bill.FbaseStatus FStockStatus, Bill.FClosePeriod FStockClosePeriod From ( ");
                sql.append(" SELECT  Entry.FMaterialID, ENTRY.FCompanyOrgUnitId AS FCompanyOrgUnitID, ENTRY.FStorageOrgUnitID AS FStorageOrgUnitID,");
                sql.append(" ENTRY.FWarehouseID AS FWarehouseID, 0 AS FPeriodBeginCostDiff, 0 AS FPeriodBeginBalance, 0 AS FIncomeCostAdjustAmt,");
                sql.append(" ENTRY.FStandardCost AS FStandardCost, ENTRY.FActualCost AS FActualCost, ENTRY.FBaseQty AS FBaseQty, MATERIAL.Fnumber as FmaterialNumber,");
                sql.append(" SCMTRANSACTIONTYPE.FName_l2 AS FTransactionTypeName, WAREHOUSE.FNumber AS FWarehouse, STORAGEORGUNIT.FNumber AS FStorageOrg,");
                sql.append(" CASE WHEN ENTRY.FUNITID=ENTRY.FBASEUNITID OR ENTRY.FBaseQty=0 THEN ISNULL(ENTRY.FUNITACTUALCOST,0) ");
                sql.append("    ELSE TO_DECIMAL(TO_DECIMAL(ENTRY.FActualCost, 17, 4)/ENTRY.FBaseQty, 21, 8) END AS FBASEUNITACTUALCOST,");
                sql.append(" 0 AS FPeriodBeginQty, Bill.FBillTypeID, BILL.FNumber, Bill.FBizDate, ENTRY.FUnitID, ENTRY.FQty, ENTRY.FWrittenOffBaseQty,");
                sql.append(" ENTRY.FUnWriteOffBaseQty, BILL.FBIZTYPEID, BILL.FTRANSACTIONTYPEID, BILL.FFIVOUCHERED, ENTRY.FSEQ AS FSEQNUM,");
                sql.append(" BILL.FID AS FBILLID,ENTRY.FID AS FBILLENTRYID, 1 AS FCALCULATEKIND, BILL.FISREVERSED, ENTRY.FREVERSEQTY,");
                sql.append(" ISNULL(MATERIAL.FPRICEPRECISION,2) AS FPRICEPRECISION, ISNULL(MEASUREUNITBASE.FQTYPRECISION,4) AS FQTYPRECISION, 2 AS FLOCALCURRENCYPRECISION,");
                sql.append(" NULL AS FSTOCKTRANSBILLENTRYID,BILL.FAUDITTIME, 0 AS FOutwarehouseType, 'T_IM_SaleIssueEntry' AS FEntryTableMame, 0 as FIsReWork,");
                sql.append(" BILL.FSOURCEBILLTYPEID, 0 AS FISPRESENT, INVUPDATETYPE.FSTORETYPEID AS FSTORETYPEID, INVUPDATETYPE.FSTORETYPEPREID AS FSTORETYPEPREID,");
                sql.append(" to_char(ENTRY.FSourceBillID) AS FSourceBillID, to_char(ENTRY.FSourceBillEntryID) AS FSourceBillEntryID, ENTRY.FSourceBillEntrySeq,");
                sql.append(" '").append(this.salesDeliveryRes).append("' as FBillTypeName,");
                sql.append(" ENTRY.FBaseUnitID as FBASEUNIT, (case when MATERIALCOMPANY.FIsLot = 1 then isnull(ENTRY.FLot,'X') else null end) AS FLOT, ");
                sql.append("(case when MATERIALCOMPANY.FIsAssistProperty = 1 then isnull(ENTRY.FAssistPropertyID,'X') else null end) AS FAssistPropertyID, ");
                sql.append("(case when MATERIALCOMPANY.FIsProject = 1  then isnull(ENTRY.FProjectID,'X') else null end) AS FProjectID, ");
                sql.append("(case when MATERIALCOMPANY.FIsTrackNumber = 1  then isnull(ENTRY.FTrackNumberID,'X') else null end) AS FTrackNumberID, ");
                sql.append(" BILL.FisWriteOffVouched as FisWriteOffVouched, MeasureUnit.FBASECONVSRATE, 0 as FbaseStatus, 0 as FClosePeriod");
                sql.append(" FROM T_IM_SaleIssueEntry ENTRY ");
                sql.append(" INNER JOIN T_IM_SaleIssueBill BILL ON BILL.FID = ENTRY.FParentID ");
                sql.append(" INNER JOIN T_BD_MATERIAL MATERIAL on MATERIAL.FID = ENTRY.FMATERIALID ");
                sql.append(" INNER JOIN T_BD_MATERIALCOMPANYINFO MATERIALCOMPANY ");
                sql.append(" \tON (ENTRY.FMaterialId = MATERIALCOMPANY.FMaterialID AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )");
                sql.append(" INNER JOIN T_ORG_Storage STORAGEORGUNIT ON entry.FStorageOrgUnitID = STORAGEORGUNIT.FID");
                sql.append(" INNER JOIN T_DB_WAREHOUSE WAREHOUSE ON entry.FWareHouseID = WAREHOUSE.FID");
                sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID");
                sql.append(" INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID");
                sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase ON (ENTRY.FMaterialID = MeasureUnitBase.FMaterialid AND ENTRY.FBaseUnitID = MeasureUnitBase.FMeasureUnitID)");
                sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnit ON (ENTRY.FMaterialID = MeasureUnit.FMaterialid AND ENTRY.FUnitID = MeasureUnit.FMeasureUnitID)");
                sql.append(" WHERE ENTRY.FID in (").append(entrustEntryId).append(") ) Bill ");
                IRowSet rs = sysTempTableHelper.executeQuery(sql.toString());
                long timeSerialNumber = new Date().getTime();
                if (params.getObject("entrustBillList") == null) {
                    entrustBillList = new ArrayList();
                    params.setObject("entrustBillList", (Object)entrustBillList);
                } else {
                    entrustBillList = (ArrayList)params.getObject("entrustBillList");
                }
                HashSet returnEntrySet = (HashSet)params.getObject("returnEntrySet");
                HashSet updateEntrySet = (HashSet)params.getObject("updateEntrySet");
                while (rs.next()) {
                    RecentCostInfo billInfo;
                    if (updateEntrySet.contains((billInfo = this.convertRecentCostInfo((ResultSet)rs, strCalType, ++timeSerialNumber, this.isAddLot)).getString("FBillEntryId"))) {
                        billInfo.setPriceSource(PriceSourEnum.entrust);
                    } else {
                        billInfo.setPriceSource(PriceSourEnum.fiVouchered);
                    }
                    if (returnEntrySet.contains(billInfo.getString("FBillEntryId"))) {
                        outBillList.add(billInfo);
                        continue;
                    }
                    billInfo.setLong("timeSerialNumber", 99999999999999L);
                    billInfo.setString("FBillTypeName", billInfo.getString("FBillTypeName") + this.notCalBalanceRes);
                    entrustBillList.add(billInfo);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private BigDecimal getPriceByParamter(Context ctx, CalculateParams params, String fKey) throws BOSException {
        if (5 == this.accountType.getValue()) {
            String[] keys = fKey.split("_[$]{4}_");
            params.setString("FLOT", keys[keys.length - 4]);
            params.setString("FAssistPropertyID", keys[keys.length - 3]);
            params.setString("FProjectID", keys[keys.length - 2]);
            params.setString("FTrackNumberID", keys[keys.length - 1]);
        }
        params.setObject("CAL_TYPE_KEY", (Object)fKey);
        return this.getPrice(ctx, params);
    }

    private void calculateBalance(List outBillList, String fKey, String strCalType, RecentCostInfo resultInfo, HashMap balanceMap, CalculateParams params) {
        RecentCostInfo bill = null;
        int listSize = outBillList.size();
        for (int i = 0; i < listSize; ++i) {
            bill = (RecentCostInfo)outBillList.get(i);
            if (!fKey.equals(bill.getFkeyID()) || !RecentCostHelp.isEffectBalance(bill, strCalType, params) || bill.isReWorkBill()) continue;
            if (bill.isMoveInBill()) {
                resultInfo.setRecentQty(resultInfo.getRecentQty().add(bill.getRecentQty()));
                resultInfo.setRecentCost(resultInfo.getRecentCost().add(bill.getRecentCost()));
            } else {
                resultInfo.setRecentQty(resultInfo.getRecentQty().subtract(bill.getRecentQty()));
                resultInfo.setRecentCost(resultInfo.getRecentCost().subtract(bill.getRecentCost()));
            }
            RecentCostHelp.calculateAvgPrice(resultInfo);
            if (resultInfo.getTimestamp("FBizDate") == null) {
                resultInfo.setTimestamp("FBizDate", bill.getTimestamp("FBizDate"));
            }
            if (bill.getTimestamp("FBizDate").compareTo(resultInfo.getTimestamp("FBizDate")) <= 0) continue;
            resultInfo.setTimestamp("FBizDate", bill.getTimestamp("FBizDate"));
        }
        RecentCostHelp.calculateAvgPrice(resultInfo);
        if (resultInfo.isPriceExcep()) {
            resultInfo.setBoolean("isExceptionState", true);
        }
    }

    private void calculateOutBillCost(List outBillList, List redBillList, HashMap costMoveMap, String fKey, RecentCostInfo resultInfo, CalculateParams params) throws CalculateException {
        RecentCostInfo bill = null;
        int listSize = outBillList.size();
        for (int i = 0; i < listSize; ++i) {
            bill = (RecentCostInfo)outBillList.get(i);
            if (!fKey.equals(bill.getFkeyID())) continue;
            boolean IsNevPrice = params.getBoolean("IsNevPrice");
            if (!bill.isNeedUpdate()) {
                if (!(bill.getBoolean("hasdealed") || bill.isCostAdjustBill() || bill.isDealComplete() || IsNevPrice && this.priceType == 3)) {
                    bill.setPrice(resultInfo.getPrice().setScale(bill.getInt("FPricePrecision"), 4));
                    BigDecimal cost = bill.getRecentQty().multiply(resultInfo.getPrice()).setScale(bill.getInt("FLocalCurrencyPrecision"), 4);
                    if (cost.compareTo(BigDecimal.ZERO) == 0 && bill.getRecentQty().compareTo(BigDecimal.ZERO) != 0 && resultInfo.getPrice().compareTo(BigDecimal.ZERO) != 0) {
                        cost = RecentCostHelp.getMinValueByScale(bill.getInt("FLocalCurrencyPrecision"), bill.getRecentQty().signum());
                    }
                    bill.setRecentCost(cost);
                }
                if (bill.isCostAdjustBill()) {
                    bill.setNeedUpdate(false);
                } else {
                    if (!bill.isDealComplete()) {
                        bill.setPriceSource(resultInfo.getPriceSource());
                    }
                    bill.setNeedUpdate(true);
                }
            }
            if (!bill.isRedBill()) {
                this.handleBlueBillAndRedBillRel(redBillList, bill);
            }
            if (resultInfo.getTimestamp("FBizDate") == null) {
                resultInfo.setTimestamp("FBizDate", bill.getTimestamp("FBizDate"));
            }
            if (bill.getTimestamp("FBizDate").compareTo(resultInfo.getTimestamp("FBizDate")) <= 0) continue;
            resultInfo.setTimestamp("FBizDate", bill.getTimestamp("FBizDate"));
        }
    }

    private StringBuffer getOrderBillSql(String tempTableFIFOBills, String materialId, RptRowSet rsMaterial) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select Bill.* from ").append(tempTableFIFOBills).append(" Bill ");
        sql.append(" where Bill.fmaterialid = '").append(materialId).append("'");
        sql.append(" and Bill.fcompanyorgunitid = '").append(rsMaterial.getString("fcompanyorgunitid")).append("'");
        sql.append(" order by Bill.FBizdate,Bill.FAuditTime,Bill.FNumber,Bill.FSeqNum ");
        return sql;
    }

    @Override
    protected void setCostMoveIsCalculate(RecentCostInfo bill, String calType, PeriodInfo periodInfo) {
        if (bill.isCostPriceMove()) {
            if (RecentCostHelp.isPrePeriodBill(bill, periodInfo)) {
                bill.setBoolean("IsCalculate", false);
                bill.setDealComplete(true);
            } else if ("2".equals(calType)) {
                bill.setBoolean("IsCalculate", true);
            } else if ("1".equals(calType)) {
                if (bill.isMoveInCostPriceStorage()) {
                    bill.setBoolean("IsCalculate", true);
                } else {
                    bill.setBoolean("IsCalculate", false);
                }
            } else {
                bill.setBoolean("IsCalculate", false);
            }
        }
    }

    protected void updateBills(Connection conn, ArrayList updateBillSql, List billList, HashMap balanceMap, boolean isupdate, int test) throws SQLException, BOSException {
        if (balanceMap == null || billList == null) {
            return;
        }
        HashMap costMovemap = (HashMap)balanceMap.get("CostPriceMove__");
        RecentCostInfo billInfo = null;
        RecentCostInfo costMoveInfo = null;
        RecentCostInfo costMoveInbillInfo = null;
        int listSize = billList.size();
        for (int i = 0; i < listSize; ++i) {
            billInfo = (RecentCostInfo)billList.get(i);
            if (billInfo.getString("FEntryTableMame") != null && billInfo.isNeedUpdate() && !billInfo.isDealComplete()) {
                updateBillSql.add(this.updateBillCostSQL(billInfo.getString("FEntryTableMame"), billInfo));
            }
            if (!billInfo.isMoveOutBill() || costMovemap == null || (costMoveInfo = (RecentCostInfo)costMovemap.get(billInfo.getStockTransBillEntryID())) == null) continue;
            ArrayList costMoveList = costMoveInfo.getMoveInbillList();
            int movelistSize = costMoveList.size();
            for (int j = 0; costMoveList != null && j < movelistSize; ++j) {
                costMoveInbillInfo = (RecentCostInfo)costMoveList.get(j);
                if (costMoveInbillInfo == null || !costMoveInbillInfo.isNeedUpdate()) continue;
                updateBillSql.add(this.updateBillCostSQL(costMoveInbillInfo.getString("FEntryTableMame"), costMoveInbillInfo));
            }
        }
        this.execBatchSql(conn, updateBillSql, isupdate);
    }

    private void handlePeriodEndCostRept(Context ctx, PreparedStatement rptPs, PeriodInfo period, CalculateParams params, HashMap balanceMap) throws SQLException {
        BOSObjectType bosType = new CostComputeReportInfo().getBOSType();
        Date now = new Date();
        boolean isOnlyWriteExpRpt = params.getBoolean("ISWRITEDEXPCOSTRPT");
        int accountType = params.getInt("ACCOUNT_TYPE");
        Iterator iter = balanceMap.entrySet().iterator();
        BalanceCostInfo balInfo = null;
        RecentCostInfo billInfo = null;
        Timestamp createTime = null;
        String fparentID = params.getString("headerid");
        String costMoveCycle = (String)balanceMap.get("costMoveCycle");
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getKey().equals("CostPriceMove__") || entry.getKey().equals("INBILLLIST") || entry.getKey().equals("OUTBILLLIST") || entry.getKey().equals("INBILLNEEDUPDATED") || entry.getKey().equals("costMoveCycle") || entry.getValue() instanceof HashMap) continue;
            balInfo = (BalanceCostInfo)((Object)entry.getValue());
            billInfo = balInfo.getReusltBillInfo();
            RecentCostHelp.calculateAvgPrice(billInfo);
            if (!RecentCostHelp.isEffectBalance(billInfo, billInfo.getString("strCalType")) || isOnlyWriteExpRpt && !billInfo.getBoolean("isExceptionState")) continue;
            String intComment = "";
            String outComment = "";
            String balanceCommnet = "";
            rptPs.setString(1, BOSUuid.create((BOSObjectType)bosType).toString());
            rptPs.setString(2, billInfo.getString("FBillTypeName"));
            rptPs.setString(3, billInfo.getString("FNumber"));
            rptPs.setString(4, "9999999999999");
            if (accountType == 3 || accountType == 5) {
                createTime = new Timestamp(billInfo.getTimestamp("FBizDate").getTime() + 1000L);
                rptPs.setTimestamp(5, createTime);
            } else {
                rptPs.setTimestamp(5, new Timestamp(now.getTime()));
            }
            rptPs.setString(6, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            rptPs.setInt(7, billInfo.getInt("FCalculateKind"));
            rptPs.setString(8, intComment);
            rptPs.setString(9, outComment);
            StringBuffer buffer = RecentCostHelp.takeAmountQytPriceDesc(billInfo.getRecentCost(), billInfo.getRecentQty(), billInfo.getPrice());
            balanceCommnet = buffer.toString();
            int i = 1;
            if (billInfo.getBoolean("isNegativePriceState")) {
                balanceCommnet = balanceCommnet + "\n" + i + ". " + this.costnegativeRxceptionRes;
                ++i;
            }
            if (billInfo.getBoolean("isZeroPriceState")) {
                balanceCommnet = balanceCommnet + "\n" + i + ". " + this.costzeroExceptionRes;
                ++i;
            }
            if (billInfo.getBoolean("isExceptionState")) {
                balanceCommnet = balanceCommnet + "\n" + i + ". " + this.settleAccountsExceptionRes;
                ++i;
            }
            rptPs.setString(10, balanceCommnet);
            rptPs.setString(11, billInfo.getString("FMaterialID"));
            rptPs.setString(12, billInfo.getString("FCompanyOrgUnitID"));
            rptPs.setString(13, billInfo.getString("FStorageOrgUnitID"));
            rptPs.setString(14, billInfo.getString("FWarehouseID"));
            rptPs.setInt(15, period.getPeriodYear());
            rptPs.setInt(16, period.getPeriodNumber());
            rptPs.setString(17, ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            rptPs.setInt(18, accountType);
            int successFlag = billInfo.getBoolean("isExceptionState") ? 2 : 1;
            rptPs.setInt(19, successFlag);
            if (accountType == 5) {
                rptPs.setString(20, billInfo.getString("FLot"));
                rptPs.setString(21, billInfo.getString("FAssistPropertyID"));
                rptPs.setString(22, billInfo.getString("FProjectID"));
                rptPs.setString(23, billInfo.getString("FTrackNumberID"));
            } else {
                rptPs.setString(20, "");
                rptPs.setString(21, "");
                rptPs.setString(22, "");
                rptPs.setString(23, "");
            }
            rptPs.setString(24, fparentID);
            rptPs.setString(25, "");
            rptPs.addBatch();
            if (StringUtil.isEmpty((String)costMoveCycle)) continue;
            rptPs.setString(1, BOSUuid.create((BOSObjectType)bosType).toString());
            rptPs.setString(3, this.costMoveCycleRes);
            rptPs.setString(8, "");
            rptPs.setString(9, "");
            rptPs.setString(10, costMoveCycle);
            createTime = new Timestamp(billInfo.getTimestamp("FBizDate").getTime() + 1010L);
            rptPs.setTimestamp(5, createTime);
            rptPs.addBatch();
        }
    }

    @Override
    protected AccountType[] takeMaterialAccountType() {
        return new AccountType[]{this.accountType};
    }

    @Override
    public String[][] getTempTableFields() {
        return null;
    }

    @Override
    public String getTempTableSerialVersionUID() {
        return null;
    }

    private void handleDetailDiff(List billList, HashMap balanceMap, String fKey) {
        RecentCostInfo tmpBillInfo = null;
        BalanceCostInfo balanceInfo = null;
        if (balanceMap == null || balanceMap.size() == 0 || billList == null || billList.size() == 0) {
            return;
        }
        balanceInfo = (BalanceCostInfo)((Object)balanceMap.get(fKey));
        if (balanceInfo == null) {
            return;
        }
        if (balanceInfo.isNeedAdjustDetail()) {
            boolean adjustDetail = false;
            AbstractRecentCostInfo lastCostMove = null;
            for (int j = billList.size() - 1; j >= 0; --j) {
                tmpBillInfo = (RecentCostInfo)billList.get(j);
                if (fKey.equals(tmpBillInfo.getFkeyID()) && this.isHandleDetailDiffer(balanceInfo, tmpBillInfo)) {
                    tmpBillInfo.setRecentCost(tmpBillInfo.getRecentCost().add(balanceInfo.getRecentCost()));
                    RecentCostHelp.calculateAvgPrice(tmpBillInfo);
                    tmpBillInfo.setBigDecimal("MoveAvgQty", CalculateUtil.ZERO);
                    tmpBillInfo.setBigDecimal("MoveAvgPrice", CalculateUtil.ZERO);
                    tmpBillInfo.setBigDecimal("MoveAvgCost", CalculateUtil.ZERO);
                    tmpBillInfo.setBoolean("ADJUSTDIFFERED", true);
                    balanceInfo.handleDetailDifer(tmpBillInfo);
                    adjustDetail = true;
                    break;
                }
                if (lastCostMove != null || !tmpBillInfo.isCostPriceMove() || !tmpBillInfo.isCalculate() || !fKey.equals(tmpBillInfo.getFkeyID())) continue;
                lastCostMove = tmpBillInfo;
            }
            if (!adjustDetail && lastCostMove != null && balanceInfo.getRecentCost().add(lastCostMove.getRecentCost()).signum() == lastCostMove.getRecentQty().signum()) {
                RecentCostHelp.calculateAvgPrice((RecentCostInfo)lastCostMove);
                lastCostMove.setBigDecimal("MoveAvgQty", CalculateUtil.ZERO);
                lastCostMove.setBigDecimal("MoveAvgPrice", CalculateUtil.ZERO);
                lastCostMove.setBigDecimal("MoveAvgCost", CalculateUtil.ZERO);
                lastCostMove.setBoolean("ADJUSTDIFFERED", true);
                balanceInfo.handleDetailDifer((RecentCostInfo)lastCostMove);
            }
        }
    }

    private boolean isHandleDetailDiffer(BalanceCostInfo balanceInfo, RecentCostInfo infoBill) {
        return !infoBill.isDealComplete() && infoBill.getBoolean("ISADJUSTDIFFER") && balanceInfo.getRecentCost().add(infoBill.getRecentCost()).signum() == infoBill.getRecentQty().signum() && CalculateUtil.ZERO.compareTo(infoBill.getBigDecimal("FReverseQty")) == 0 && !infoBill.isCostPriceMove() && !infoBill.isCommissionSaleOut() && !infoBill.isMatAttrChange() && infoBill.getQty().compareTo(BigDecimal.ZERO) != 0;
    }

    private ArrayList setCalOrder(Context ctx, ArrayList inBillList, LinkedHashMap costMoveMap, ArrayList calOrder, String strCalType, Map costMoveCycleMap) throws BOSException {
        if (calOrder.size() <= 1 || "0".equals(strCalType)) {
            return calOrder;
        }
        LinkedList<Object> outList = new LinkedList<Object>();
        LinkedList inList = new LinkedList();
        RecentCostInfo costMoveBill = null;
        ArrayList costMoveInBillList = null;
        ArrayList outBillList = null;
        RecentCostInfo inRecentCostInfo = null;
        RecentCostInfo outRecentCostInfo = null;
        String outID = null;
        String inID = null;
        HashMap<String, Integer> vertexValueMap = new HashMap<String, Integer>();
        HashMap<String, Long> outAndInMap = new HashMap<String, Long>();
        HashMap<String, String> value2IDMap = new HashMap<String, String>();
        int vertexValue = 0;
        long timeSerialNumber = 0L;
        String outInkey2 = null;
        for (Map.Entry entry : costMoveMap.entrySet()) {
            costMoveBill = (RecentCostInfo)entry.getValue();
            costMoveInBillList = costMoveBill.getMoveInbillList();
            outBillList = costMoveBill.getMoveOutbillList();
            if (costMoveInBillList == null || outBillList == null) continue;
            inRecentCostInfo = (RecentCostInfo)costMoveInBillList.get(0);
            outRecentCostInfo = (RecentCostInfo)outBillList.get(0);
            if ("1".equals(strCalType)) {
                outID = outRecentCostInfo.getString("FStorageOrgUnitId");
                if (outID.equals(inID = inRecentCostInfo.getString("FStorageOrgUnitId"))) {
                    continue;
                }
            } else if ("2".equals(strCalType)) {
                outID = outRecentCostInfo.getString("FStorageOrgUnitId") + "_$$$_" + outRecentCostInfo.getString("FWarehouseId");
                inID = inRecentCostInfo.getString("FStorageOrgUnitId") + "_$$$_" + inRecentCostInfo.getString("FWarehouseId");
            }
            if (this.isAddLot) {
                outID = this.addLot4WarehsID(outRecentCostInfo, outID);
                inID = this.addLot4WarehsID(inRecentCostInfo, inID);
            }
            if (vertexValueMap.get(outID) == null) {
                vertexValueMap.put(outID, vertexValue);
                ++vertexValue;
            }
            if (vertexValueMap.get(inID) == null) {
                vertexValueMap.put(inID, vertexValue);
                ++vertexValue;
            }
            if ((timeSerialNumber = outAndInMap.get(outInkey2 = outID + "_$$$$$$_" + inID) == null ? outRecentCostInfo.getLong("timeSerialNumber") : ((Long)outAndInMap.get(outInkey2)).longValue()) > outRecentCostInfo.getLong("timeSerialNumber")) {
                timeSerialNumber = outRecentCostInfo.getLong("timeSerialNumber");
            }
            outAndInMap.put(outInkey2, timeSerialNumber);
        }
        if (outAndInMap.size() > 0) {
            Set cycle;
            int[][] outInArray = new int[vertexValueMap.size()][vertexValueMap.size()];
            long[][] outInOrderArray = new long[vertexValueMap.size()][vertexValueMap.size()];
            int rowindex = 0;
            int colindex = 0;
            String[] temp = null;
            Set keySet = outAndInMap.keySet();
            for (String outInkey2 : keySet) {
                temp = outInkey2.split("\\_\\$\\$\\$\\$\\$\\$\\_");
                outID = temp[0];
                inID = temp[1];
                rowindex = (Integer)vertexValueMap.get(outID);
                colindex = (Integer)vertexValueMap.get(inID);
                outInArray[rowindex][colindex] = 1;
                outInOrderArray[rowindex][colindex] = (Long)outAndInMap.get(outInkey2);
            }
            String idKey2 = "";
            Set<Object> idKeySet = new HashSet();
            for (String idKey2 : vertexValueMap.keySet()) {
                if ("2".equals(strCalType)) {
                    String[] split = idKey2.split("_\\$\\$\\$_");
                    value2IDMap.put(vertexValueMap.get(idKey2).toString(), split[1]);
                    idKeySet.add(split[1]);
                    continue;
                }
                value2IDMap.put(vertexValueMap.get(idKey2).toString(), idKey2);
            }
            if (idKeySet.size() == 0) {
                idKeySet = vertexValueMap.keySet();
            }
            if (!this.isAddLot && (cycle = CalcCycleTrans.getCycle(outInArray)) != null && cycle.size() > 0) {
                costMoveCycleMap.put("costMoveCycle", this.getCycleString(ctx, cycle, strCalType, this.isAddLot, idKeySet, value2IDMap));
            }
            outInArray = CalcCycleTrans.breakCycle(outInArray, outInOrderArray);
            Topology topology = new Topology(vertexValueMap.size(), outInArray);
            String outOrInID2 = null;
            keySet = vertexValueMap.keySet();
            for (String outOrInID2 : keySet) {
                rowindex = (Integer)vertexValueMap.get(outOrInID2);
                topology.setVertexs(rowindex, outOrInID2);
            }
            Object[] result = topology.topo();
            int n = result.length;
            for (int j = 0; j < n; ++j) {
                outList.add(result[j]);
            }
            this.logger.info((Object)("\u8ba1\u7b97\u987a\u5e8foutList :" + outList));
        }
        for (Map.Entry entry : costMoveMap.entrySet()) {
            costMoveBill = (RecentCostInfo)entry.getValue();
            costMoveInBillList = costMoveBill.getMoveInbillList();
            outBillList = costMoveBill.getMoveOutbillList();
            if (costMoveInBillList == null || outBillList == null) continue;
            inRecentCostInfo = (RecentCostInfo)costMoveInBillList.get(0);
            outRecentCostInfo = (RecentCostInfo)outBillList.get(0);
            if ("1".equals(strCalType)) {
                outID = outRecentCostInfo.getString("FStorageOrgUnitId");
                if (outID.equals(inID = inRecentCostInfo.getString("FStorageOrgUnitId"))) {
                    continue;
                }
            } else if ("2".equals(strCalType)) {
                outID = outRecentCostInfo.getString("FStorageOrgUnitId") + "_$$$_" + outRecentCostInfo.getString("FWarehouseId");
                inID = inRecentCostInfo.getString("FStorageOrgUnitId") + "_$$$_" + inRecentCostInfo.getString("FWarehouseId");
            }
            if (this.isAddLot) {
                outID = this.addLot4WarehsID(outRecentCostInfo, outID);
                inID = this.addLot4WarehsID(inRecentCostInfo, inID);
            }
            if (outList.indexOf(outID) <= outList.indexOf(inID)) continue;
            this.setBillIsCal(inBillList, costMoveInBillList);
        }
        return this.getCalOrder(strCalType, outList, inList, calOrder);
    }

    private String getCycleString(Context ctx, Set cycle, String strCalType, boolean isAddLot, Set idset, HashMap value2idMap) throws BOSException {
        List cycleList2 = new ArrayList();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idset, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("name"));
        sics.add(new SelectorItemInfo("number"));
        view.setSelector(sics);
        HashMap<String, DataBaseInfo> id2ObjMap = new HashMap<String, DataBaseInfo>();
        StorageOrgUnitCollection collection = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view);
        if ("2".equals(strCalType)) {
            collection = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(view);
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            id2ObjMap.put(collection.getObject(i).getString("id"), (DataBaseInfo)collection.getObject(i));
        }
        String id = "";
        StringBuffer cycleSb = new StringBuffer();
        StringBuffer cycleSbNumber = new StringBuffer();
        for (List cycleList2 : cycle) {
            int size2 = cycleList2.size();
            for (int i = 0; i < size2; ++i) {
                id = (String)value2idMap.get(cycleList2.get(i));
                cycleSb.append("[ ").append(((DataBaseInfo)id2ObjMap.get(id)).getNumber()).append(" , ");
                cycleSb.append(((DataBaseInfo)id2ObjMap.get(id)).getName()).append(" ]");
                cycleSbNumber.append("[ ").append(((DataBaseInfo)id2ObjMap.get(id)).getNumber()).append(" ]");
                if (i == size2 - 1) {
                    cycleSb.append("\n");
                    cycleSbNumber.append("\n");
                    continue;
                }
                cycleSb.append("->");
                cycleSbNumber.append("->");
            }
        }
        if (cycleSb.length() > 1500) {
            if (cycleSbNumber.length() > 1500) {
                return cycleSbNumber.substring(0, 1499);
            }
            return cycleSbNumber.toString();
        }
        return cycleSb.toString();
    }

    private String addLot4WarehsID(RecentCostInfo bill, String warehsID) {
        StringBuffer buffer = new StringBuffer(warehsID);
        buffer.append(this.getCalModelKey(bill, "FLot"));
        buffer.append(this.getCalModelKey(bill, "FAssistPropertyID"));
        buffer.append(this.getCalModelKey(bill, "FProjectID"));
        buffer.append(this.getCalModelKey(bill, "FTrackNumberID"));
        return buffer.toString();
    }

    private String addLot4WarehsID(String[] temp, String warehsID, int beginIndex) {
        StringBuffer buffer = new StringBuffer(warehsID);
        buffer.append("_$$$$_").append(temp[beginIndex]);
        buffer.append("_$$$$_").append(temp[beginIndex + 1]);
        buffer.append("_$$$$_").append(temp[beginIndex + 2]);
        buffer.append("_$$$$_").append(temp[beginIndex + 3]);
        return buffer.toString();
    }

    private ArrayList getCalOrder(String strCalType, LinkedList outList, LinkedList inList, ArrayList calOrder) {
        int i;
        int n = inList.size();
        for (int i2 = 0; i2 < n; ++i2) {
            outList.add(inList.get(i2));
        }
        int beginIndex = 0;
        String key = null;
        String calKeyID = null;
        ArrayList<String> newCalOrder = new ArrayList<String>();
        int n2 = calOrder.size();
        for (i = 0; i < n2; ++i) {
            key = calOrder.get(i).toString();
            if (key.length() <= 0 || key.split("\\_\\$\\$\\$\\$\\_").length < 2) continue;
            String[] temp = key.split("\\_\\$\\$\\$\\$\\_");
            if ("1".equals(strCalType)) {
                calKeyID = temp[1];
                beginIndex = 2;
            } else if ("2".equals(strCalType)) {
                calKeyID = temp[1] + "_$$$_" + temp[2];
                beginIndex = 3;
            }
            if (this.isAddLot) {
                calKeyID = this.addLot4WarehsID(temp, calKeyID, beginIndex);
            }
            if (!outList.contains(calKeyID)) {
                outList.addLast(key);
                continue;
            }
            int index = outList.indexOf(calKeyID);
            outList.set(index, key);
        }
        n2 = outList.size();
        for (i = 0; i < n2; ++i) {
            if (outList.get(i).toString().indexOf("$$$$") <= 0) continue;
            newCalOrder.add(outList.get(i).toString());
        }
        return newCalOrder;
    }

    private void setBillIsCal(ArrayList inBillList, ArrayList costMoveInBillList) {
        RecentCostInfo costMoveInInfo = null;
        RecentCostInfo inBillInfo = null;
        String moveInKey = null;
        String inBillKey = null;
        int n = inBillList.size();
        for (int i = 0; i < n; ++i) {
            inBillInfo = (RecentCostInfo)inBillList.get(i);
            inBillKey = inBillInfo.getString("FBillId");
            int k = costMoveInBillList.size();
            for (int j = 0; j < k; ++j) {
                costMoveInInfo = (RecentCostInfo)costMoveInBillList.get(j);
                moveInKey = costMoveInInfo.getString("FBillId");
                if (!moveInKey.equals(inBillKey)) continue;
                inBillInfo.setInListCal(false);
            }
        }
    }

    protected void costBillForEntrust(Context ctx, CalculateParams params, String strCalType, SysTempTableHelper sysTempTableHelper, HashMap keyParam) throws BOSException, SQLException {
        List innerList;
        RecentCostInfo currInfo;
        int local_Currency_Presision = params.getInt("Local_Currency_Presision");
        Map ret = this.entrustSettlement(ctx, params, strCalType, sysTempTableHelper, keyParam);
        Map<String, List<RecentCostInfo>> settlementReturnGroupMap = this.entrustSettlementReturn(ctx, params, sysTempTableHelper, keyParam);
        Map outMap = (Map)ret.get("outMap");
        Map otherMap = (Map)ret.get("otherMap");
        ArrayList<RecentCostInfo> needUpdate = new ArrayList<RecentCostInfo>();
        StringBuffer entryId = new StringBuffer();
        HashSet<String> entryIdSet = new HashSet<String>();
        HashSet<String> updateEntrySet = new HashSet<String>();
        HashSet<String> returnEntrySet = new HashSet<String>();
        for (List<RecentCostInfo> returnList : settlementReturnGroupMap.values()) {
            for (int i = 1; i < returnList.size(); ++i) {
                currInfo = returnList.get(i);
                innerList = (List)otherMap.get(currInfo.getFBillEntryId());
                if (innerList == null) {
                    if (returnList.get(0).getInt("FISBeforePeroid") == 0 && returnList.get(0).getInt("FFiVouchered") == 0) {
                        needUpdate.add(returnList.get(0));
                    }
                    if (returnList.get(0).getInt("FISBeforePeroid") != 0 || !entryIdSet.add(returnList.get(0).getFBillEntryId())) continue;
                    entryId.append("'").append(returnList.get(0).getFBillEntryId()).append("',");
                    returnEntrySet.add(returnList.get(0).getFBillEntryId());
                    continue;
                }
                innerList.add(currInfo);
                innerList.add(returnList.get(0));
            }
        }
        BigDecimal unitActuralCost = CalculateUtil.ZERO;
        BigDecimal allQty = CalculateUtil.ZERO;
        BigDecimal allCost = CalculateUtil.ZERO;
        BigDecimal sumQty = CalculateUtil.ZERO;
        BigDecimal sumCost = CalculateUtil.ZERO;
        int dealTailIndex = -1;
        BigDecimal dealTailQty = CalculateUtil.ZERO;
        BigDecimal diffAmount = CalculateUtil.ZERO;
        BigDecimal writeBaseQty = CalculateUtil.ZERO;
        BigDecimal baseconvsrate = BigDecimal.ONE;
        for (Map.Entry entry : otherMap.entrySet()) {
            RecentCostInfo outInfo = (RecentCostInfo)outMap.get(entry.getKey());
            allQty = outInfo.getRecentQty();
            allCost = outInfo.getRecentCost();
            innerList = (List)entry.getValue();
            for (int i = 0; i < innerList.size(); ++i) {
                currInfo = (RecentCostInfo)innerList.get(i);
                if (currInfo.getInt("FISBeforePeroid") == 0 && entryIdSet.add(currInfo.getFBillEntryId())) {
                    entryId.append("'").append(currInfo.getFBillEntryId()).append("',");
                    if (currInfo.getRecentCost().compareTo(BigDecimal.ZERO) < 0) {
                        returnEntrySet.add(currInfo.getFBillEntryId());
                    }
                }
                if (currInfo.getInt("FFiVouchered") == 0 && currInfo.getInt("FISBeforePeroid") == 0) {
                    if (currInfo.getInt("isSettlementReturnBill") == 0) {
                        needUpdate.add(currInfo);
                        if (dealTailQty.compareTo(CalculateUtil.ZERO) <= 0) {
                            dealTailIndex = i;
                            dealTailQty = currInfo.getRecentQty();
                        }
                    } else if (currInfo.getRecentQty().compareTo(CalculateUtil.ZERO) < 0) {
                        needUpdate.add(currInfo);
                        if (dealTailIndex == -1) {
                            dealTailIndex = i;
                        }
                    }
                }
                if (currInfo.getInt("isSettlementReturnBill") == 0) {
                    sumQty = sumQty.add(currInfo.getRecentQty().abs());
                    sumCost = sumCost.add(currInfo.getRecentCost().abs());
                    continue;
                }
                if (currInfo.getRecentQty().compareTo(CalculateUtil.ZERO) <= 0) continue;
                writeBaseQty = currInfo.getBigDecimal("FWriteOffBaseQty");
                if (writeBaseQty == null) {
                    if (!currInfo.getString("FBaseUnit").equals(currInfo.getString("FUnitID"))) {
                        baseconvsrate = currInfo.getBigDecimal("FBaseConvsRate");
                        writeBaseQty = currInfo.getBigDecimal("FWRITEOFFQTY").multiply(baseconvsrate);
                    } else {
                        writeBaseQty = currInfo.getBigDecimal("FWRITEOFFQTY");
                    }
                }
                sumQty = sumQty.add(writeBaseQty);
                sumCost = sumCost.add(writeBaseQty.multiply(((RecentCostInfo)innerList.get(i + 1)).getPrice()).setScale(local_Currency_Presision, 4).abs());
            }
            if (sumQty.compareTo(allQty) == 0 && dealTailIndex > -1) {
                diffAmount = allCost.subtract(sumCost);
                if (diffAmount.compareTo(CalculateUtil.ZERO) == 0) {
                    sumQty = CalculateUtil.ZERO;
                    sumCost = CalculateUtil.ZERO;
                    dealTailIndex = -1;
                    dealTailQty = CalculateUtil.ZERO;
                    diffAmount = CalculateUtil.ZERO;
                    continue;
                }
                currInfo = (RecentCostInfo)innerList.get(dealTailIndex);
                if (currInfo.getRecentQty().compareTo(CalculateUtil.ZERO) < 0) {
                    if (currInfo.getRecentCost().subtract(diffAmount).compareTo(CalculateUtil.ZERO) > 0) continue;
                    currInfo.setRecentCost(currInfo.getRecentCost().subtract(diffAmount));
                } else {
                    if (currInfo.getRecentCost().add(diffAmount).compareTo(CalculateUtil.ZERO) < 0) continue;
                    currInfo.setRecentCost(currInfo.getRecentCost().add(diffAmount));
                }
                RecentCostHelp.calculateAvgPrice(currInfo);
                unitActuralCost = currInfo.getPrice();
                if (!currInfo.getString("FBaseUnit").equals(currInfo.getString("FUnitID"))) {
                    baseconvsrate = currInfo.getBigDecimal("FBaseConvsRate");
                    unitActuralCost = currInfo.getPrice().multiply(baseconvsrate).setScale(currInfo.getInt("FPricePrecision"), 4);
                }
                if (currInfo.getRecentQty().compareTo(BigDecimal.ZERO) == 0) {
                    unitActuralCost = BigDecimal.ZERO;
                }
                currInfo.setBigDecimal("unitActuralCost", unitActuralCost);
            }
            sumQty = CalculateUtil.ZERO;
            sumCost = CalculateUtil.ZERO;
            dealTailIndex = -1;
            dealTailQty = CalculateUtil.ZERO;
            diffAmount = CalculateUtil.ZERO;
        }
        if (needUpdate.size() > 0) {
            Object[][] paramlist = new String[needUpdate.size()][6];
            for (int i = 0; i < needUpdate.size(); ++i) {
                currInfo = (RecentCostInfo)needUpdate.get(i);
                paramlist[i][0] = currInfo.getPrice().toPlainString();
                paramlist[i][1] = currInfo.getBigDecimal("unitActuralCost").toPlainString();
                paramlist[i][2] = currInfo.getRecentCost().toPlainString();
                paramlist[i][3] = currInfo.getWrittenOffAmount().toPlainString();
                paramlist[i][4] = currInfo.getUnWriteOffAmount().toPlainString();
                paramlist[i][5] = currInfo.getFBillEntryId();
                updateEntrySet.add(currInfo.getFBillEntryId());
            }
            String updateSql = "update T_IM_SaleIssueEntry set FBASEUNITACTUALCOST = ?, FUNITACTUALCOST = ?, FACTUALCOST=?, FWRITTENOFFAMOUNT = ?, FUNWRITEOFFAMOUNT = ? where FId = ?";
            sysTempTableHelper.executeBatch(ctx, updateSql, paramlist);
        }
        if (entryId.length() > 0) {
            params.setString("EntrustEntryId", entryId.substring(0, entryId.length() - 1));
        } else {
            params.setString("EntrustEntryId", null);
        }
        params.setObject("returnEntrySet", returnEntrySet);
        params.setObject("updateEntrySet", updateEntrySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map entrustSettlement(Context ctx, CalculateParams params, String strCalType, SysTempTableHelper sysTempTableHelper, HashMap keyParam) throws BOSException, SQLException {
        HashMap<String, HashMap<String, Object>> hashMap;
        StringBuffer sql = new StringBuffer();
        PeriodInfo periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            List<RecentCostInfo> innerList;
            sql.append("select DISTINCT ALLENTRY.FID, ALLENTRY.FUNITACTUALCOST, ALLENTRY.FSOURCEBILLENTRYID, ALLENTRY.FBASEQTY, ALLENTRY.FQTY,ALLENTRY.FACTUALCOST, ALLENTRYBILL.FFIVOUCHERED,");
            sql.append(" ALLMATERIAL.FPRICEPRECISION, allEntryUpdateType.FSTORETYPEID, allEntryUpdateType.FSTORETYPEPREID,");
            sql.append(" Round(ALLENTRY.FUNITACTUALCOST*MULT.FBASECONVSRATE,MATERIAL.FPRICEPRECISION) as FBASEUNITACTUALCOST, ALLENTRY.FBASEUNITID, ALLENTRY.FUNITID, ALLENTRY.FWRITTENOFFBASEQTY, ALLENTRY.FUNWRITEOFFBASEQTY, MULT.FBASECONVSRATE,");
            sql.append(" (case when ALLENTRYBILL.FYEAR*100+ALLENTRYBILL.FPERIOD < ").append(periodInfo.getNumber()).append(" THEN 1 ELSE 0 END) AS FISBEFOREPEROID");
            sql.append(" from T_IM_SALEISSUEENTRY ENTRY").append("\t\n");
            sql.append(" INNER JOIN T_IM_SALEISSUEBILL BILL ON BILL.FID = ENTRY.FParentID ").append("\t\n");
            sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID ").append("\t\n");
            sql.append(" INNER JOIN T_IM_StoreType StoreType ON InvUpdateType.FStoreTypePreID = StoreType.FID ").append("\t\n");
            sql.append(" AND StoreType.FID ='").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("'").append("\t\n");
            sql.append(" INNER JOIN T_BD_Material MATERIAL ON MATERIAL.FID = ENTRY.FMATERIALID");
            sql.append(" INNER JOIN T_IM_SALEISSUEENTRY ALLENTRY ON (ENTRY.FSOURCEBILLENTRYID = ALLENTRY.FID OR ENTRY.FSOURCEBILLENTRYID = ALLENTRY.FSOURCEBILLENTRYID) ");
            sql.append(" INNER JOIN T_IM_SALEISSUEBILL ALLENTRYBILL ON ALLENTRYBILL.FID = ALLENTRY.FParentID ").append("\t\n");
            sql.append(" INNER JOIN T_BD_Material ALLMATERIAL ON ALLMATERIAL.FID = ALLENTRY.FMATERIALID ").append("\t\n");
            sql.append(" INNER JOIN T_BD_MULTIMEASUREUNIT MULT ON MULT.FMATERIALID = ALLENTRY.FMATERIALID AND MULT.FMEASUREUNITID = ALLENTRY.FUNITID").append("\t\n");
            sql.append(" INNER JOIN T_IM_InvUpdateType allEntryUpdateType ON ALLENTRY.FInvUpdateTypeID = allEntryUpdateType.FID ").append("\t\n");
            params.setBoolean("isGetPrePeriod", false);
            params.setBoolean("includePreAndcurPeriod", false);
            params.setBoolean("includeAfterPeriod", false);
            sql.append(this.getSQLWhereCalcuate(periodInfo, params));
            sql.append(this.getSQLWhereFromKeyParam(keyParam, "ENTRY"));
            sql.append(" AND ENTRY.fmaterialid = '").append(params.getString("CurrMaterialId")).append("'").append("\t\n");
            sql.append(" AND ALLENTRY.FCOMPANYORGUNITID = '").append(params.getString("COMPANY_ID")).append("'");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sql.append(" AND ALLENTRY.FBIZDATE <= TO_DATE('").append(format.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" order by ALLENTRY.FBASEQTY desc");
            this.logger.error((Object)("\u67e5\u8be2\u59d4\u6258\u552e\u51fa\u5355\u8bed\u53e5\u4e3a :" + sql));
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            HashMap<String, RecentCostInfo> outMap = new HashMap<String, RecentCostInfo>();
            HashMap otherMap = new HashMap();
            int local_Currency_Presision = params.getInt("Local_Currency_Presision");
            ArrayList outBillList = (ArrayList)params.getObject("OUTBILLLIST");
            RecentCostInfo outListInfo = null;
            while (rs.next()) {
                RecentCostInfo billInfo = new RecentCostInfo();
                billInfo.setFBillEntryId(rs.getString("FID"));
                billInfo.setFSourceBillEntryID(rs.getString("FSOURCEBILLENTRYID"));
                billInfo.setPrice(rs.getBigDecimal("FBASEUNITACTUALCOST"));
                billInfo.setRecentQty(rs.getBigDecimal("FBASEQTY"));
                billInfo.setRecentCost(rs.getBigDecimal("FACTUALCOST"));
                billInfo.setInt("FPricePrecision", rs.getInt("FPRICEPRECISION"));
                billInfo.setInt("FFiVouchered", rs.getInt("FFIVOUCHERED"));
                billInfo.setInt("FISBeforePeroid", rs.getInt("FISBEFOREPEROID"));
                billInfo.setBigDecimal("FBaseConvsRate", rs.getBigDecimal("FBASECONVSRATE"));
                billInfo.setInt("FLocalCurrencyPrecision", local_Currency_Presision);
                billInfo.setBigDecimal("FWrittenOffBaseQty", rs.getBigDecimal("FWRITTENOFFBASEQTY"));
                billInfo.setBigDecimal("FUnWriteOffBaseQty", rs.getBigDecimal("FUNWRITEOFFBASEQTY"));
                billInfo.setString("FBaseUnit", rs.getString("FBASEUNITID"));
                billInfo.setString("FUnitID", rs.getString("FUNITID"));
                billInfo.setInt("isSettlementReturnBill", 0);
                if (billInfo.getRecentQty().compareTo(CalculateUtil.ZERO) > 0 && "181875d5-0105-1000-e000-011ac0a812fd97D461A6".equals(rs.getString("FSTORETYPEID")) && "181875d5-0105-1000-e000-0111c0a812fd97D461A6".equals(rs.getString("FSTORETYPEPREID"))) {
                    if (billInfo.getInt("FISBeforePeroid") == 0) {
                        for (int i = 0; i < outBillList.size(); ++i) {
                            outListInfo = (RecentCostInfo)outBillList.get(i);
                            if (!outListInfo.getFBillEntryId().equals(billInfo.getFBillEntryId())) continue;
                            billInfo.setPrice(outListInfo.getPrice());
                            billInfo.setRecentCost(outListInfo.getRecentCost());
                            break;
                        }
                    }
                    outMap.put(billInfo.getFBillEntryId(), billInfo);
                    continue;
                }
                if (otherMap.containsKey(billInfo.getFSourceBillEntryID())) {
                    innerList = (List)otherMap.get(billInfo.getFSourceBillEntryID());
                    innerList.add(billInfo);
                } else {
                    innerList = new ArrayList<RecentCostInfo>();
                    innerList.add(billInfo);
                }
                otherMap.put(billInfo.getFSourceBillEntryID(), innerList);
            }
            for (Map.Entry entry : otherMap.entrySet()) {
                RecentCostInfo outInfo = (RecentCostInfo)outMap.get(entry.getKey());
                BigDecimal unitActuralCost = outInfo.getPrice();
                innerList = (ArrayList<RecentCostInfo>)entry.getValue();
                for (int i = 0; i < innerList.size(); ++i) {
                    RecentCostInfo currInfo = (RecentCostInfo)innerList.get(i);
                    if (currInfo.getInt("FFiVouchered") != 0 || currInfo.getInt("FISBeforePeroid") != 0) continue;
                    currInfo.setPrice(outInfo.getPrice());
                    currInfo.setRecentCost(currInfo.getPrice().multiply(currInfo.getRecentQty()).setScale(local_Currency_Presision, RoundingMode.HALF_UP));
                    if (!currInfo.getString("FBaseUnit").equals(currInfo.getString("FUnitID"))) {
                        BigDecimal baseconvsrate = outInfo.getBigDecimal("FBaseConvsRate");
                        unitActuralCost = currInfo.getPrice().multiply(baseconvsrate).setScale(currInfo.getInt("FPricePrecision"), 4);
                    }
                    if (currInfo.getRecentQty().compareTo(BigDecimal.ZERO) == 0) {
                        unitActuralCost = BigDecimal.ZERO;
                    }
                    currInfo.setBigDecimal("unitActuralCost", unitActuralCost);
                }
            }
            HashMap<String, HashMap<String, Object>> ret = new HashMap<String, HashMap<String, Object>>();
            ret.put("outMap", outMap);
            ret.put("otherMap", otherMap);
            hashMap = ret;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<RecentCostInfo>> entrustSettlementReturn(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper, HashMap keyParam) throws BOSException, SQLException {
        HashMap hashMap;
        int local_Currency_Presision = params.getInt("Local_Currency_Presision");
        StringBuffer sqlForReturn = new StringBuffer();
        PeriodInfo periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        String materialId = params.getString("CurrMaterialId");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            List<RecentCostInfo> innerList;
            sqlForReturn.append(" SELECT ALLENTRY.FID,TO_DECIMAL(TO_DECIMAL(ALLENTRY.FActualCost, 17, 4)/ALLENTRY.FBaseQty, 21, 8) AS FBASEUNITACTUALCOST,").append("\t\n");
            sqlForReturn.append(" RETURNENTRYGROUP.FWRITEOFFBASEQTY,RETURNENTRYGROUP.FWRITEOFFQTY,ALLENTRY.FACTUALCOST,ALLENTRY.FBASEQTY ,ALLENTRYBILL.FFIVOUCHERED,").append("\t\n");
            sqlForReturn.append(" ALLMATERIAL.FPRICEPRECISION,ALLENTRY.FBASEUNITID,ALLENTRY.FUNITID,ALLENTRY.FWRITTENOFFBASEQTY,ALLENTRY.FUNWRITEOFFBASEQTY,MULT.FBASECONVSRATE,").append("\t\n");
            sqlForReturn.append(" (CASE WHEN (BILL.FYEAR*100 + BILL.FPERIOD) < ").append(periodInfo.getNumber()).append(" THEN 1 ELSE 0 END) AS FISBEFOREPEROID,RETURNENTRYGROUP.FPARENTID").append("\t\n");
            sqlForReturn.append(" FROM T_SD_ConsignSaleBill BILL ").append("\t\n");
            sqlForReturn.append(" INNER JOIN T_SD_ConsignSaleBillentry ENTRY ON BILL.FID = ENTRY.FPARENTID").append("\t\n");
            sqlForReturn.append(" INNER JOIN T_SD_ConsignSaleBillentry RETURNENTRYGROUP ON ENTRY.FPARENTID = RETURNENTRYGROUP.FPARENTID ").append("\t\n");
            sqlForReturn.append(" INNER JOIN T_IM_SALEISSUEENTRY ALLENTRY ON ALLENTRY.FID = RETURNENTRYGROUP.FSOURCEBILLEMID ").append("\t\n");
            sqlForReturn.append(" INNER JOIN T_IM_SALEISSUEBILL ALLENTRYBILL ON ALLENTRYBILL.FID = ALLENTRY.FPARENTID ").append("\t\n");
            sqlForReturn.append(" INNER JOIN T_BD_Material ALLMATERIAL ON ALLMATERIAL.FID = ALLENTRY.FMATERIALID").append("\t\n");
            sqlForReturn.append(" INNER JOIN T_BD_MULTIMEASUREUNIT MULT ON MULT.FMATERIALID = ALLENTRY.FMATERIALID AND MULT.FMEASUREUNITID = ALLENTRY.FUNITID").append("\t\n");
            sqlForReturn.append(" WHERE (BILL.FYEAR*100 + BILL.FPERIOD) <= ").append(periodInfo.getNumber()).append(" AND ENTRY.FWRITEOFFQTY < 0").append("\t\n");
            sqlForReturn.append(" AND ENTRY.fmaterialid = '").append(materialId).append("'").append("\t\n");
            sqlForReturn.append(this.getSQLWhereFromKeyParam(keyParam, "ALLENTRY"));
            sqlForReturn.append(" AND ALLENTRY.FCOMPANYORGUNITID ='").append(params.getString("COMPANY_ID")).append("'").append("\t\n");
            sqlForReturn.append(" ORDER BY RETURNENTRYGROUP.FWRITEOFFQTY ");
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sqlForReturn.toString());
            HashMap groupMap = new HashMap();
            ArrayList outBillList = (ArrayList)params.getObject("OUTBILLLIST");
            String fKeyId = params.getString("curFKeyID");
            RecentCostInfo outListInfo = null;
            while (rs.next()) {
                RecentCostInfo billInfo = new RecentCostInfo();
                billInfo.setFBillEntryId(rs.getString("FID"));
                billInfo.setPrice(rs.getBigDecimal("FBASEUNITACTUALCOST"));
                billInfo.setRecentQty(rs.getBigDecimal("FBASEQTY"));
                billInfo.setRecentCost(rs.getBigDecimal("FACTUALCOST"));
                billInfo.setInt("FPricePrecision", rs.getInt("FPRICEPRECISION"));
                billInfo.setInt("FFivouchered", rs.getInt("FFIVOUCHERED"));
                billInfo.setInt("FIsBeforePeroid", rs.getInt("FISBEFOREPEROID"));
                billInfo.setBigDecimal("FBaseConvsRate", rs.getBigDecimal("FBASECONVSRATE"));
                billInfo.setInt("FLocalCurrencyPrecision", local_Currency_Presision);
                billInfo.setBigDecimal("FWRITEOFFQTY", rs.getBigDecimal("FWRITEOFFQTY"));
                billInfo.setBigDecimal("FWriteOffBaseQty", rs.getBigDecimal("FWRITEOFFBASEQTY"));
                billInfo.setBigDecimal("FWrittenOffBaseQty", rs.getBigDecimal("FWRITTENOFFBASEQTY"));
                billInfo.setString("FBaseUnit", rs.getString("FBASEUNITID"));
                billInfo.setString("FUnitID", rs.getString("FUNITID"));
                billInfo.setInt("isSettlementReturnBill", 1);
                if (billInfo.getRecentQty().compareTo(BigDecimal.ZERO) < 0) {
                    innerList = new ArrayList<RecentCostInfo>();
                    innerList.add(billInfo);
                    groupMap.put(rs.getString("FParentId"), innerList);
                    continue;
                }
                innerList = (List)groupMap.get(rs.getString("FParentId"));
                if (billInfo.getInt("FIsBeforePeroid") == 0) {
                    for (int i = 0; i < outBillList.size(); ++i) {
                        outListInfo = (RecentCostInfo)outBillList.get(i);
                        if (!outListInfo.getFkeyID().equals(fKeyId) || !outListInfo.getFBillEntryId().equals(billInfo.getFBillEntryId())) continue;
                        billInfo.setPrice(outListInfo.getPrice());
                        billInfo.setRecentCost(outListInfo.getRecentCost());
                        break;
                    }
                }
                innerList.add(billInfo);
            }
            BigDecimal sumCost = BigDecimal.ZERO;
            BigDecimal baseWriteQty = BigDecimal.ZERO;
            BigDecimal unitActuralCost = BigDecimal.ZERO;
            BigDecimal baseconvsrate = BigDecimal.ONE;
            for (Map.Entry entry : groupMap.entrySet()) {
                innerList = (ArrayList<RecentCostInfo>)entry.getValue();
                if (innerList.size() <= 1) continue;
                RecentCostInfo returnInfo = (RecentCostInfo)innerList.get(0);
                if (returnInfo.getInt("FFivouchered") == 0 && returnInfo.getInt("FIsBeforePeroid") == 0) {
                    for (int i = 1; i < innerList.size(); ++i) {
                        baseWriteQty = ((RecentCostInfo)innerList.get(i)).getBigDecimal("FWriteOffBaseQty");
                        if (baseWriteQty == null) {
                            if (!returnInfo.getString("FBaseUnit").equals(returnInfo.getString("FUnitID"))) {
                                baseconvsrate = rs.getBigDecimal("FBaseConvsRate");
                                baseWriteQty = ((RecentCostInfo)innerList.get(i)).getBigDecimal("FWRITEOFFQTY").multiply(baseconvsrate);
                            } else {
                                baseWriteQty = ((RecentCostInfo)innerList.get(i)).getBigDecimal("FWRITEOFFQTY");
                            }
                        }
                        sumCost = sumCost.add(((RecentCostInfo)innerList.get(i)).getPrice().multiply(baseWriteQty).setScale(local_Currency_Presision, 4));
                    }
                    returnInfo.setRecentCost(sumCost.negate());
                    returnInfo.setPrice(returnInfo.getRecentCost().divide(returnInfo.getRecentQty(), returnInfo.getInt("FPricePrecision"), 4));
                    if (!returnInfo.getString("FBaseUnit").equals(returnInfo.getString("FUnitID"))) {
                        baseconvsrate = rs.getBigDecimal("FBaseConvsRate");
                        unitActuralCost = returnInfo.getPrice().multiply(baseconvsrate).setScale(returnInfo.getInt("FPricePrecision"), 4);
                    } else {
                        unitActuralCost = returnInfo.getPrice();
                    }
                    returnInfo.setBigDecimal("unitActuralCost", unitActuralCost);
                }
                sumCost = BigDecimal.ZERO;
            }
            hashMap = groupMap;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return hashMap;
    }

    private void initResourc(Context ctx) {
        this.endBalanceRes = SCMUtils.getResource((String)res, (String)"235_EndBalance", (Context)ctx);
        this.salesDeliveryRes = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SalesDelivery", (Context)ctx);
        this.notCalBalanceRes = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"notCalBalance", (Context)ctx);
        this.costnegativeRxceptionRes = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COSTNEGATIVE_RXCEPTION", (Context)ctx);
        this.costzeroExceptionRes = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COSTZERO_EXCEPTION", (Context)ctx);
        this.settleAccountsExceptionRes = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SettleAccounts_Exception", (Context)ctx);
        this.costMoveCycleRes = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"costMoveCycle", (Context)ctx);
    }

    class CalculateThreadForWeightedAvg
    implements Runnable {
        Context ctx;
        CalculateParams params;
        SysTempTableHelper sysTempTableHelper;
        Connection conn;
        String materialSql;
        PeriodInfo periodInfo;
        int startIndex = 0;
        String tempTableFIFOBills;
        String strCalType;

        public CalculateThreadForWeightedAvg(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper, Connection conn, String materialSql, PeriodInfo periodInfo, int startIndex, String tempTableFIFOBills, String strCalType) {
            this.ctx = ctx;
            try {
                this.params = (CalculateParams)params.clone();
            }
            catch (CloneNotSupportedException e) {
                WeightedAverageCalculateNew.this.ExceptionList.add(e);
            }
            this.sysTempTableHelper = sysTempTableHelper;
            this.params.setObject("sysTempTableHelper", (Object)sysTempTableHelper);
            this.conn = conn;
            this.materialSql = materialSql;
            this.periodInfo = periodInfo;
            this.startIndex = startIndex;
            this.tempTableFIFOBills = tempTableFIFOBills;
            this.strCalType = strCalType;
        }

        @Override
        public void run() {
            try {
                this.asynCalculate();
            }
            catch (Exception e) {
                WeightedAverageCalculateNew.this.ExceptionList.add(e);
                WeightedAverageCalculateNew.this.logger.info((Object)e);
            }
            finally {
                WeightedAverageCalculateNew.this.countDown.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void asynCalculate() throws BOSException, SQLException {
            HashMap balanceMap = null;
            StringBuffer querySql = new StringBuffer();
            querySql.append(this.materialSql).append(" where ksql_seq > ").append(this.startIndex).append(" and ksql_seq <= ").append(1000 + this.startIndex);
            RptRowSet rsMaterial = DBUtils.executeQuery((String)querySql.toString(), (Connection)this.conn);
            PreparedStatement reptPs = this.conn.prepareStatement(CostComputeHelp.getCreateCostComputeReportSQL());
            UpdateBillCostHelper updateBillCostHelper = new UpdateBillCostHelper(this.conn);
            int materialCount = 0;
            try {
                while (rsMaterial.next()) {
                    this.params.setObject("MATERIAL_LIST", (Object)rsMaterial);
                    ++materialCount;
                    try {
                        balanceMap = WeightedAverageCalculateNew.this.isAddLot ? WeightedAverageCalculateNew.this.handleLotCalculate(this.ctx, this.conn, this.params, rsMaterial, this.params.getString("CALTYPE"), this.periodInfo) : WeightedAverageCalculateNew.this.handleAvgCalculate(this.ctx, this.conn, this.params, rsMaterial, this.params.getString("CALTYPE"), this.periodInfo);
                        updateBillCostHelper.updateBills((List)balanceMap.get("INBILLNEEDUPDATED"), balanceMap);
                        updateBillCostHelper.updateBills((List)balanceMap.get("OUTBILLLIST"), balanceMap);
                        if (this.params.getBoolean("ISWRITECOSTCOMPUTEREPORT")) {
                            if (this.params.getBoolean("ISWRITEDEXPCOSTRPT")) {
                                Map keyExceptionState = WeightedAverageCalculateNew.this.getKeyExceptionState(balanceMap);
                                this.params.setObject("keyExceptionState", (Object)keyExceptionState);
                            }
                            WeightedAverageCalculateNew.this.handleCostRept(this.ctx, reptPs, this.periodInfo, this.params, (List)balanceMap.get("INBILLLIST"));
                            WeightedAverageCalculateNew.this.handleCostRept(this.ctx, reptPs, this.periodInfo, this.params, (List)balanceMap.get("OUTBILLLIST"));
                            WeightedAverageCalculateNew.this.handlePeriodEndCostRept(this.ctx, reptPs, this.periodInfo, this.params, balanceMap);
                        }
                        if (materialCount % 500 == 0) {
                            WeightedAverageCalculateNew.this.executePsBatch(reptPs);
                        }
                        if (balanceMap == null) continue;
                        balanceMap.clear();
                    }
                    catch (Exception e) {
                        WeightedAverageCalculateNew.this.logger.error((Object)("deal material:" + rsMaterial.getString("FmaterialNumber") + " \u5931\u8d25."));
                        WeightedAverageCalculateNew.this.logger.error((Object)e);
                        WeightedAverageCalculateNew.this.ExceptionList.add(e);
                    }
                }
                WeightedAverageCalculateNew.this.handleCostRept(this.ctx, reptPs, this.periodInfo, this.params, (List)this.params.getObject("entrustBillList"));
                updateBillCostHelper.executeBatch(true);
                WeightedAverageCalculateNew.this.executePsBatch(reptPs);
                return;
            }
            finally {
                SQLUtils.cleanup((Statement)reptPs);
            }
        }
    }
}

