/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.help;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.CostComputeReportInfo;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculatePrecision;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CostComputeHelp {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.help.CostComputeHelp");

    public static StringBuffer createCostComputeReport(Context ctx, CostComputeReportInfo cinfo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        PeriodInfo periodInfo = new PeriodInfo();
        periodInfo.setPeriodNumber(cinfo.getPeriod());
        periodInfo.setPeriodYear(cinfo.getYear());
        return CostComputeHelp.createCostComputeReport(ctx, periodInfo, cinfo.getMaterial() != null && cinfo.getMaterial().getId() != null ? cinfo.getMaterial().getId().toString() : "", cinfo.getCompanyOrgUnit() != null && cinfo.getCompanyOrgUnit().getId() != null ? cinfo.getCompanyOrgUnit().getId().toString() : "", cinfo.getStorageOrgUnit() != null && cinfo.getStorageOrgUnit().getId() != null ? cinfo.getStorageOrgUnit().getId().toString() : "", cinfo.getWarehouse() != null && cinfo.getWarehouse().getId() != null ? cinfo.getWarehouse().getId().toString() : "", cinfo.getBillName(), cinfo.getBillNumber(), cinfo.getIncome(), cinfo.getPayout(), cinfo.getSettleAccounts(), sdf.format(cinfo.getCreateTime()), cinfo.getTimeSerialNumber(), cinfo.getAccountType());
    }

    public static StringBuffer createCostComputeReport(Context ctx, PeriodInfo periodInfo, String MaterialID, String CompanyOrg, String StorageOrgUnitId, String WarehouseId, String billName, String billNumber, String income, String payout, String settleAccounts, String createTime, String timeSerialNumber, AccountType accountType) {
        StringBuffer sb = new StringBuffer();
        CostComputeReportInfo info = new CostComputeReportInfo();
        sb.append("Insert Into T_CL_CostcomputeReport(");
        sb.append("FID,FBillName,FBillNumber,FTimeSerialNumber,FCreateTime,FCreatorID");
        sb.append(",FCalculateKind,FIncome,FPayout,FSettleAccounts,FMaterialID");
        sb.append(",FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FYear,FPeriod");
        sb.append(",FControlUnitID,FAccountType");
        sb.append(")");
        sb.append("Values(");
        sb.append("newbosid('").append(info.getBOSType()).append("')");
        sb.append(",'").append(billName).append("'");
        sb.append(",'").append(billNumber).append("'");
        sb.append(",'").append(timeSerialNumber).append("'");
        sb.append(",TO_DATE('").append(createTime).append("')");
        sb.append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sb.append(",").append(1).append("");
        sb.append(",'").append(income).append("'");
        sb.append(",'").append(payout).append("'");
        sb.append(",'").append(settleAccounts).append("'");
        sb.append(",'").append(MaterialID).append("'");
        sb.append(",'").append(CompanyOrg).append("'");
        sb.append(",'").append(StorageOrgUnitId).append("'");
        sb.append(",'").append(WarehouseId).append("'");
        sb.append(",").append(periodInfo.getPeriodYear()).append("");
        sb.append(",").append(periodInfo.getPeriodNumber()).append("");
        sb.append(",'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        sb.append(",").append(accountType.getValue());
        sb.append(")");
        return sb;
    }

    public static StringBuffer createCostComputeReport(Context ctx, PeriodInfo periodInfo, String MaterialID, String CompanyOrg, String StorageOrgUnitId, String WarehouseId, String billName, String billNumber, String income, String payout, String settleAccounts, String createTime, String timeSerialNumber, AccountType accountType, int isSuccessed, String parent) {
        StringBuffer sb = new StringBuffer();
        CostComputeReportInfo info = new CostComputeReportInfo();
        sb.append("Insert Into T_CL_CostcomputeReport(");
        sb.append("FID,FBillName,FBillNumber,FTimeSerialNumber,FCreateTime,FCreatorID");
        sb.append(",FCalculateKind,FIncome,FPayout,FSettleAccounts,FMaterialID");
        sb.append(",FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FYear,FPeriod");
        sb.append(",FControlUnitID,FAccountType,FIsSusccessed,fparentid");
        sb.append(")");
        sb.append("Values(");
        sb.append("newbosid('").append(info.getBOSType()).append("')");
        sb.append(",'").append(billName).append("'");
        sb.append(",'").append(billNumber).append("'");
        sb.append(",'").append(timeSerialNumber).append("'");
        sb.append(",TO_DATE('").append(createTime).append("')");
        sb.append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sb.append(",").append(1).append("");
        sb.append(",'").append(income).append("'");
        sb.append(",'").append(payout).append("'");
        sb.append(",'").append(settleAccounts).append("'");
        sb.append(",'").append(MaterialID).append("'");
        sb.append(",'").append(CompanyOrg).append("'");
        sb.append(",'").append(StorageOrgUnitId).append("'");
        sb.append(",'").append(WarehouseId).append("'");
        sb.append(",").append(periodInfo.getPeriodYear()).append("");
        sb.append(",").append(periodInfo.getPeriodNumber()).append("");
        sb.append(",'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        sb.append(",").append(accountType.getValue());
        sb.append(",").append(isSuccessed);
        sb.append(",'").append(parent).append("'");
        sb.append(")");
        return sb;
    }

    public static StringBuffer createCostComputeReport(Context ctx, PeriodInfo periodInfo, String MaterialID, String CompanyOrg, String StorageOrgUnitId, String WarehouseId, String billName, String billNumber, String income, String payout, String settleAccounts, String createTime, long timeSerialNumber, AccountType accountType, StringBuffer sqlfrom, String lot, int isSuccessed) {
        StringBuffer sb = new StringBuffer();
        CostComputeReportInfo info = new CostComputeReportInfo();
        sb.append("Insert Into T_CL_CostcomputeReport(");
        sb.append("FID,FBillName,FBillNumber,FTimeSerialNumber,FCreateTime,FCreatorID");
        sb.append(",FCalculateKind,FIncome,FPayout,FSettleAccounts,FMaterialID");
        sb.append(",FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FYear,FPeriod");
        sb.append(",FControlUnitID,FAccountType,FIsSusccessed");
        if (AccountType.SPECIAL_ACCT.equals((Object)accountType)) {
            sb.append(",FLot");
        }
        sb.append(")");
        sb.append(" select ");
        sb.append("newbosid('").append(info.getBOSType()).append("')");
        sb.append(",'").append(billName).append("'");
        sb.append(",'").append(billNumber).append("'");
        sb.append(",'").append(timeSerialNumber).append("'");
        sb.append(",TO_DATE('").append(createTime).append("')");
        sb.append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sb.append(",").append(1).append("");
        sb.append(",'").append(income).append("'");
        sb.append(",'").append(payout).append("'");
        sb.append(",'").append(settleAccounts).append("'");
        sb.append(",'").append(MaterialID).append("'");
        sb.append(",'").append(CompanyOrg).append("'");
        sb.append(",'").append(StorageOrgUnitId).append("'");
        sb.append(",'").append(WarehouseId).append("'");
        sb.append(",").append(periodInfo.getPeriodYear()).append("");
        sb.append(",").append(periodInfo.getPeriodNumber()).append("");
        sb.append(",'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        sb.append(",").append(accountType.getValue());
        sb.append(",").append(isSuccessed);
        if (AccountType.SPECIAL_ACCT.equals((Object)accountType)) {
            sb.append(",'").append(null != lot ? lot : "").append("'");
        }
        if (sqlfrom != null) {
            sb.append(sqlfrom);
        }
        return sb;
    }

    public static StringBuffer createCostComputeReport(Context ctx, PeriodInfo periodInfo, String MaterialID, String CompanyOrg, String StorageOrgUnitId, String WarehouseId, String billName, String billNumber, String income, String payout, String settleAccounts, String createTime, long timeSerialNumber, AccountType accountType, StringBuffer sqlfrom) {
        StringBuffer sb = new StringBuffer();
        CostComputeReportInfo info = new CostComputeReportInfo();
        sb.append("Insert Into T_CL_CostcomputeReport(");
        sb.append("FID,FBillName,FBillNumber,FTimeSerialNumber,FCreateTime,FCreatorID");
        sb.append(",FCalculateKind,FIncome,FPayout,FSettleAccounts,FMaterialID");
        sb.append(",FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FYear,FPeriod");
        sb.append(",FControlUnitID,FAccountType");
        sb.append(")");
        sb.append(" select ");
        sb.append("newbosid('").append(info.getBOSType()).append("')");
        sb.append(",'").append(billName).append("'");
        sb.append(",'").append(billNumber).append("'");
        sb.append(",'").append(timeSerialNumber).append("'");
        sb.append(",TO_DATE('").append(createTime).append("')");
        sb.append(",'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sb.append(",").append(1).append("");
        sb.append(",'").append(income).append("'");
        sb.append(",'").append(payout).append("'");
        sb.append(",'").append(settleAccounts).append("'");
        sb.append(",'").append(MaterialID).append("'");
        sb.append(",'").append(CompanyOrg).append("'");
        sb.append(",'").append(StorageOrgUnitId).append("'");
        sb.append(",'").append(WarehouseId).append("'");
        sb.append(",").append(periodInfo.getPeriodYear()).append("");
        sb.append(",").append(periodInfo.getPeriodNumber()).append("");
        sb.append(",'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        sb.append(",").append(accountType.getValue());
        if (sqlfrom != null) {
            sb.append(sqlfrom);
        }
        return sb;
    }

    public static CostComputeReportInfo createCostComputeReport(Context ctx, String materialCalType, PeriodInfo aPeriodInfo, BigDecimal sum, BigDecimal qty, CalculatePrecision cprecision, String settleAccountsDesc, CalculateWrittenOffBill bill, CalculateWrittenOffEntry entry) throws EASBizException, BOSException {
        CostComputeReportInfo cinfo = new CostComputeReportInfo();
        String billTypeName = CostComputeHelp.getBillTypeName(ctx, bill.getBillType());
        if ("410".equals(bill.getBillType())) {
            cinfo.setBillName(billTypeName);
        } else {
            StringBuffer billName = new StringBuffer();
            billName.append(billTypeName.trim()).append(" - ").append(bill.getTransactionTypeName().trim());
            cinfo.setBillName(billName.toString());
        }
        cinfo.setBillNumber(bill.getNumber());
        cinfo.setCreateTime(new Timestamp(new Date().getTime()));
        cinfo.setTimeSerialNumber(new Long(new Date().getTime()).toString() + String.valueOf(entry.getSeq()));
        cinfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        cinfo.setCalculateKind(bill.getCalculateKindEnum());
        cinfo.setAccountType(entry.getMaterialAccountType());
        cinfo.setIncome("");
        cinfo.setPayout("");
        StringBuffer stemp = new StringBuffer();
        if (CalculateUtil.ZERO.compareTo(qty) != 0) {
            stemp.append(qty.setScale(cprecision.getBaseQtyPrecision(), 4).toString());
            stemp.append(" * ");
            BigDecimal price = sum.divide(qty, cprecision.getPricePrecision(), 4);
            stemp.append(price);
            stemp.append(" = ");
        }
        stemp.append(sum.setScale(cprecision.getLocalCurrencyPrecision(), 4));
        if (CalculateKindEnum.OUTPUT_WAREHOUSE != bill.getCalculateKindEnum()) {
            cinfo.setIncome(stemp.toString());
        } else if (stemp.toString().indexOf(45) < 0) {
            cinfo.setPayout(stemp.insert(0, '-').toString().replaceAll("= ", "= -"));
        } else {
            cinfo.setPayout(stemp.toString().replaceAll("-", ""));
        }
        cinfo.setSettleAccounts(settleAccountsDesc);
        cinfo.setMaterial(entry.getMaterial());
        cinfo.setCompanyOrgUnit(entry.getFinanceOrg());
        if (entry.getStorageOrg() != null) {
            cinfo.setStorageOrgUnit(entry.getStorageOrg());
        }
        if (entry.getWarehouse() != null) {
            cinfo.setWarehouse(entry.getWarehouse());
        }
        cinfo.setYear(aPeriodInfo.getPeriodYear());
        cinfo.setPeriod(aPeriodInfo.getPeriodNumber());
        return cinfo;
    }

    public static String getBillTypeName(Context ctx, String billTypeNumber) throws EASBizException, BOSException {
        String billTypeName = "";
        StringBuffer sql = new StringBuffer();
        sql.append("select FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" AS FBillTypeName from T_SCM_BillType ").append(" where FNumber ='").append(billTypeNumber).append("'");
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                billTypeName = rs.getString("FBillTypeName");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return billTypeName;
    }

    public static boolean isSrcBilInCurrPid(Context ctx, CalculateWrittenOffBill bill, CalculateWrittenOffEntry entry, PeriodInfo aPeriodInfo) {
        if (bill.getSourceBillId() == null) {
            return false;
        }
        String sourceBillId = bill.getSourceBillId().toString();
        String tableName = "";
        StringBuffer sql = new StringBuffer();
        if ("T_IM_SaleIssueBill".equals(bill.getTableName())) {
            tableName = "t_im_saleissuebill";
        }
        if ("T_IM_MaterialReqBill".equalsIgnoreCase(bill.getTableName())) {
            tableName = "t_im_materialreqbill";
        }
        sql.append("select FBizDate from ").append(tableName).append(" where FID = '").append(sourceBillId).append("' ");
        IRowSet rs = null;
        Date SourceBillBizDate = new Date();
        try {
            rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                SourceBillBizDate = rs.getDate("FBizDate");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Calendar c = Calendar.getInstance();
        c.setTime(SourceBillBizDate);
        int sourceBillYear = c.get(1);
        int sourceBillMonth = c.get(2) + 1;
        return sourceBillYear < aPeriodInfo.getPeriodYear() || sourceBillYear == aPeriodInfo.getPeriodYear() && sourceBillMonth < aPeriodInfo.getPeriodNumber();
    }

    public static boolean isSrcOutBillInPrePeriod(Context ctx, CalculateWrittenOffBill bill, CalculateWrittenOffEntry entry, PeriodInfo aPeriodInfo) {
        return CostComputeHelp.isRedBill(bill, entry) && !"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(bill.getBillType()) && CostComputeHelp.isSrcBilInCurrPid(ctx, bill, entry, aPeriodInfo) && entry.getSourceBillTypeID() != null && (entry.getSourceBillTypeID().equals("50957179-0105-1000-e000-015bc0a812fd463ED552") || entry.getSourceBillTypeID().equals("50957179-0105-1000-e000-0163c0a812fd463ED552"));
    }

    public static boolean isSrcOutBillInCurrentPd(Context ctx, CalculateWrittenOffBill bill, CalculateWrittenOffEntry entry, PeriodInfo aPeriodInfo) {
        return CostComputeHelp.isRedBill(bill, entry) && !"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(bill.getBillType()) && CostComputeHelp.isSrcBilInCurrPid(ctx, bill, entry, aPeriodInfo) && entry.getSourceBillTypeID() != null && (entry.getSourceBillTypeID().equals("50957179-0105-1000-e000-015bc0a812fd463ED552") || entry.getSourceBillTypeID().equals("50957179-0105-1000-e000-0163c0a812fd463ED552"));
    }

    public static boolean isNotSrcOutRetBill(CalculateWrittenOffBill bill, CalculateWrittenOffEntry entry) {
        return CostComputeHelp.isRedBill(bill, entry) && !"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(bill.getBillType()) && !bill.isReversed() && (entry.getSourceBillTypeID() == null || !entry.getSourceBillTypeID().equals("50957179-0105-1000-e000-015bc0a812fd463ED552") && !entry.getSourceBillTypeID().equals("50957179-0105-1000-e000-0163c0a812fd463ED552"));
    }

    public static boolean isRedBill(CalculateWrittenOffBill bill, CalculateWrittenOffEntry entry) {
        return entry.getQty() != null && CalculateUtil.ZERO.compareTo(entry.getQty()) > 0;
    }

    public static void addCostComputerReportBatch(Context ctx, PreparedStatement ps, PeriodInfo periodInfo, String MaterialID, String CompanyOrg, String StorageOrgUnitId, String WarehouseId, String billName, String billNumber, String income, String payout, String settleAccounts, String createTime, long timeSerialNumber, AccountType accountType, int isSuccessed, String parent, String priceSource, boolean isCostMove) throws UuidException, SQLException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        ps.setString(1, BOSUuid.create((String)"2F1F9D8E").toString());
        ps.setString(2, billName);
        ps.setString(3, billNumber);
        ps.setString(4, String.valueOf(timeSerialNumber));
        try {
            ps.setTimestamp(5, new Timestamp(sdf.parse(createTime).getTime()));
        }
        catch (ParseException e1) {
            logger.error((Object)e1);
        }
        ps.setString(6, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        ps.setInt(7, 1);
        ps.setString(8, income);
        ps.setString(9, payout);
        ps.setString(10, settleAccounts);
        ps.setString(11, MaterialID);
        ps.setString(12, CompanyOrg);
        ps.setString(13, StorageOrgUnitId);
        ps.setString(14, WarehouseId);
        ps.setInt(15, periodInfo.getPeriodYear());
        ps.setInt(16, periodInfo.getPeriodNumber());
        ps.setString(17, ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        ps.setInt(18, accountType.getValue());
        ps.setInt(19, isSuccessed);
        ps.setString(20, "");
        ps.setString(21, "");
        ps.setString(22, "");
        ps.setString(23, "");
        ps.setString(24, parent);
        if (StringUtils.isEmpty((String)income) || isCostMove) {
            ps.setString(25, priceSource);
        } else {
            ps.setString(25, "");
        }
        ps.addBatch();
    }

    public static String getCreateCostComputeReportSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert Into T_CL_CostcomputeReport(");
        sb.append("FID,FBillName,FBillNumber,FTimeSerialNumber,FCreateTime");
        sb.append(",FCreatorID,FCalculateKind,FIncome,FPayout,FSettleAccounts");
        sb.append(",FMaterialID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FYear");
        sb.append(",FPeriod,FControlUnitID,FAccountType,FIsSusccessed");
        sb.append(",FLOT,FAssistPropertyID,FProjectID,FTrackNumberID,FParentid,FpriceSource");
        sb.append(")");
        sb.append("\n VALUES(?,?,?,?,?");
        sb.append("\n ,?,?,?,?,?");
        sb.append("\n ,?,?,?,?,?");
        sb.append("\n ,?,?,?,?");
        sb.append("\n ,?,?,?,?,?,?)");
        return sb.toString();
    }

    public static boolean isCostPriceMoveCalculate(Context ctx, String companyOrgUnitID) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        IParamControl ipc = null != ctx ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        String calType = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(companyOrgUnitID)), "SCM_CAL_010");
        return calType == null || !calType.equalsIgnoreCase("false");
    }

    public static StringBuffer createCostComputeRpt(Context ctx, PeriodInfo period, String companyorgUnitid, CostAdjustBillInfo bill, CostAdjustBillEntryInfo entry, AccountType accmountType) {
        String inComeDesc = "";
        String payOutDesc = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        if (bill.getCalculateKind().getValue() == 1) {
            payOutDesc = entry.getActualCost().toString();
        } else {
            inComeDesc = entry.getActualCost().toString();
        }
        String longtime = new Long(new Date().getTime()).toString() + String.valueOf(entry.getSeq());
        String balanceDesc = RecentCostHelp.takeAmountQytPriceDesc(entry.getBigDecimal("FRecentCost_tmp"), entry.getBigDecimal("FRecentQty_tmp"), entry.getBigDecimal("FPrice_tmp")).toString();
        String createTime = sdf.format(new Timestamp(new Date().getTime()));
        return CostComputeHelp.createCostComputeReport(ctx, period, entry.getMaterial().getId().toString(), companyorgUnitid, bill.getStorageOrgUnit().getId().toString(), entry.getWarehouse().getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"172_CostComputeHelp", (Locale)ctx.getLocale()), bill.getNumber(), inComeDesc, payOutDesc, balanceDesc, createTime, longtime, accmountType);
    }

    public static boolean isRedBill(CalculateWrittenOffEntry entry) {
        return entry.getQty() != null && CalculateUtil.ZERO.compareTo(entry.getQty()) > 0;
    }
}

