/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.help;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Locale;

public class CostUpdateMutextHelper {
    public static final String MATOUTCAL = "matOutCal";
    public static final String PRDOUTCAL = "prdOutCal";
    public static final String MATASSEMBLE = "matAssembleCal";
    public static final String MATCHANGE = "matChangeCal";
    public static final String DEVOLVECAL = "devolveCal";
    public static final String ONEKEYCAL = "oneKeyCal";
    public static final String CALBILL = "calBill";
    public static final String EXCEPTIONBILL = "exceptionBill";
    public static final String INWAREHSSUMCAL = "inwarehsSumCal";
    public static final String UNSHUTACCOUNT = "unShutAccount";
    public static final String CLOSEACCOUNT = "close_account";
    private static final String CALRESOURCE = "com.kingdee.eas.scm.cal.CalCommonResource";

    public static void checkPerfSepTask(Context ctx, String taskType, String message) throws EASBizException, BOSException {
        String sql = "SELECT FJOBID FROM T_BD_PERFSEPTASK WHERE FTASKTYPE LIKE ? AND FSTATE = 0";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{taskType + "%"});
        try {
            if (rs.next()) {
                throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{message});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void checkUpdateCostOperation(Context ctx, String companyId, String operateType) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT 1 FROM T_CL_UPDATECOSTMUTEX WHERE FCOMPANYID = ?  AND FOPERATETYPE = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, operateType});
        try {
            if (rs.next()) {
                throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{CostUpdateMutextHelper.getMessage(ctx, operateType)});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void addCostOperationMutex(Context ctx, String companyId, String operateType) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" INSERT INTO T_CL_UPDATECOSTMUTEX(FCOMPANYID,FOPERATETYPE) VALUES(?,?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, operateType});
    }

    public static void clearCostOperationMutex(Context ctx, String companyId, String operateType) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" DELETE FROM T_CL_UPDATECOSTMUTEX WHERE FCOMPANYID = ?  AND FOPERATETYPE = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, operateType});
    }

    public static void checkOneKeyCalRunning(Context ctx, String companyNumber) throws EASBizException, BOSException {
        String calType = companyNumber + "SCM_CAL_0005";
        CostUpdateMutextHelper.checkPerfSepTask(ctx, calType, EASResource.getString((String)"com.kingdee.eas.scm.cal.onekey.OneKeyCalculateResource", (String)"oneKeyCalIsRunning"));
    }

    private static String getMessage(Context ctx, String operateType) {
        String message = "";
        if (MATASSEMBLE.equals(operateType)) {
            message = ResourceBase.getString((String)CALRESOURCE, (String)"matAssembleRunning", (Locale)ctx.getLocale());
        }
        if (MATCHANGE.equals(operateType)) {
            message = ResourceBase.getString((String)CALRESOURCE, (String)"matChangeRunning", (Locale)ctx.getLocale());
        }
        if (CALBILL.equals(operateType)) {
            message = ResourceBase.getString((String)CALRESOURCE, (String)"calBillRunning", (Locale)ctx.getLocale());
        }
        if (EXCEPTIONBILL.equals(operateType)) {
            message = ResourceBase.getString((String)CALRESOURCE, (String)"exceptionBillRunning", (Locale)ctx.getLocale());
        }
        return message;
    }
}

