/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.help;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import java.util.ArrayList;

public class InventoryBillHelp {
    public static final String t_sm_purinvoicebill = "t_sm_purinvoicebill";
    public static final String t_sm_purinvoiceentry = "t_sm_purinvoiceentry";
    public static final String t_sd_saleinvoicebill = "t_sd_saleinvoicebill";
    public static final String t_sd_saleinvoiceentry = "t_sd_saleinvoiceentry";
    public static final String t_im_purinwarehsbill = "t_im_purinwarehsbill";
    public static final String t_im_purinwarehsentry = "t_im_purinwarehsentry";
    public static final String t_im_saleissuebill = "t_im_saleissuebill";
    public static final String t_im_saleissueentry = "t_im_saleissueentry";
    public static final String t_im_moveissuebill = "t_im_moveissuebill";
    public static final String t_im_moveissuebillentry = "t_im_moveissuebillentry";
    public static final String t_im_moveinwarehsbill = "t_im_moveinwarehsbill";
    public static final String t_im_moveinwarehsbillentry = "t_im_moveinwarehsbillentry";
    public static final String t_im_materialreqbill = "t_im_materialreqbill";
    public static final String t_im_materialreqbillentry = "t_im_materialreqbillentry";
    public static final String t_im_manufacturerecbill = "t_im_manufacturerecbill";
    public static final String t_im_manufacturerecbillentry = "t_im_manufacturerecbillentry";
    public static final String t_im_otherissuebill = "t_im_otherissuebill";
    public static final String t_im_otherissuebillentry = "t_im_otherissuebillentry";
    public static final String t_im_otherinwarehsbill = "t_im_otherinwarehsbill";
    public static final String t_im_otherinwarehsbillentry = "t_im_otherinwarehsbillentry";
    public static final String t_cl_costadjustbill = "t_cl_costadjustbill";
    public static final String t_cl_costadjustbillentry = "t_cl_costadjustbillentry";
    public static final String t_ap_otherbill = "t_ap_otherbill";
    public static final String t_ap_otherbillentry = "t_ap_otherbillentry";
    public static final String t_ar_otherbill = "t_ar_otherbill";
    public static final String t_ar_otherbillentry = "t_ar_otherbillentry";
    public static final String t_cl_inventorybalance = "T_CL_InventoryBalance";
    public static final String t_im_inventorybalance = "T_IM_InventoryBalance";
    private static final String[][] inpourTableArray = new String[][]{{"T_IM_PurInWarehsEntry", "T_IM_PurInWarehsBill", "50957179-0105-1000-e000-015fc0a812fd463ED552"}, {"T_IM_ManufactureRecBillEntry", "T_IM_ManufactureRecBill", "50957179-0105-1000-e000-0167c0a812fd463ED552"}, {"T_IM_MoveInWarehsBillEntry", "T_IM_MoveInWarehsBill", "50957179-0105-1000-e000-0172c0a812fd463ED552"}, {"T_IM_OtherInWarehsBillEntry", "T_IM_OtherInWarehsBill", "50957179-0105-1000-e000-017bc0a812fd463ED552"}, {"T_IM_SaleIssueEntry", "T_IM_SaleIssueBill", "50957179-0105-1000-e000-015bc0a812fd463ED552"}, {"T_IM_MaterialReqBillEntry", "T_IM_MaterialReqBill", "50957179-0105-1000-e000-0163c0a812fd463ED552"}, {"T_IM_OtherIssueBillEntry", "T_IM_OtherIssueBill", "50957179-0105-1000-e000-0177c0a812fd463ED552"}};
    private static final String[][] issueTableArray = new String[][]{{"T_IM_SaleIssueEntry", "T_IM_SaleIssueBill", "50957179-0105-1000-e000-015bc0a812fd463ED552"}, {"T_IM_MoveIssueBillEntry", "T_IM_MoveIssueBill", "50957179-0105-1000-e000-016ec0a812fd463ED552"}, {"T_IM_MaterialReqBillEntry", "T_IM_MaterialReqBill", "50957179-0105-1000-e000-0163c0a812fd463ED552"}, {"T_IM_OtherIssueBillEntry", "T_IM_OtherIssueBill", "50957179-0105-1000-e000-0177c0a812fd463ED552"}};
    public static final String T_Temp_ReverseBills = "T_Temp_ReverseBills";
    public static final String T_Temp_FullReverseBills = "T_Temp_FullReverseBills";
    public static final String T_Temp_FullReverseMaxTimeBills = "T_Temp_FullReverseMaxTimeBills";
    public static final String T_Temp_FullReverseMaxIdBills = "T_Temp_FullReverseMaxIdBills";
    public static final String T_Temp_WeightedAverageMaterialList = "T_Temp_WeightedAverageMaterialList";
    public static final String T_Temp_WeightedAverageGroupbyList = "T_Temp_WeightedAverageGroupbyList";
    public static final String T_TEMP_MOVEWEIGHTEDAVERAGEMATERIALLIST = "T_Temp_MoveWeightedAverageMaterialList";
    public static final String T_Temp_FIFOBills = "T_Temp_FIFOBills";
    public static final String T_Temp_MiddleFIFOBills = "T_Temp_MiddleFIFOBills";
    public static final String T_Temp_FIFOMaterialList = "T_Temp_FIFOMaterialList";
    public static final String T_TEMP_FIFOMATERIALLISTNEW = "T_Temp_FIFOMaterialListNew";
    public static final String T_Temp_CostStockTranMaxTimeBills = "T_Temp_CostStockTranMaxTimeBills";
    public static final String T_Temp_CostStockTranMaxIdBills = "T_Temp_CostStockTranMaxIdBills";
    public static final String T_Temp_TotalCostStockTranOutBills = "T_Temp_TotalCostStockTranOutBills";
    public static final String T_Temp_TotalCostStockTranInpBills = "T_Temp_TotalCostStockTranInpBills";
    public static final String T_Temp_CostAdjusTable = "T_Temp_CostAdjusTable";
    public static final String T_Temp_PeriodCostAdjustAssistTable = "T_Temp_PeriodCostAdjustAssistTable";
    public static final String T_Temp_PeriodEndCostAdjustAssistTable = "T_Temp_PeriodEndCostAdjustAssistTable";
    public static final String T_Temp_MiddleInOutBillsTempTable = "T_Temp_MiddleInOutBillsTempTable";
    public static final String T_Temp_FIFOBillsTempTable = "T_Temp_FIFOBillsTempTable";
    public static final String T_Temp_MultiMeasureUnitTempTable = "T_Temp_MultiMeasureUnitTempTable";
    public static final String T_Temp_MaterialTempTable = "T_Temp_MaterialTempTable";
    public static final String T_Temp_MaterialAssistTable = "T_Temp_MaterialAssistTable";
    public static final String T_Temp_MaterialAssistTable2 = "T_Temp_MaterialAssistTable2";
    public static final String T_Temp_ASSISTTABLE = "T_Temp_ASSISTTABLE";
    public static final String T_CL_PROGRESSTABLE = "t_cl_progress";
    public static final String T_CL_PROGRESSTABLENAME = "t_cl_progressTableName";
    public static final String TASKID = "taskID";
    public static final String T_Temp_WRITEOFFTABLE = "T_Temp_WriteOffTable";
    public static final String T_Temp_ENTRYINFO = "T_Temp_ENTRYINFO";
    public static final String T_Temp_StockTransBillEntryID = "T_Temp_StockTransBillEntryID";
    public static final String T_Temp_ReturnBillAssistTableField = "T_Temp_ReturnBillAssistTableField";
    public static final String T_Temp_LastEntryTable = "T_Temp_LastEntryTable";
    public static final String T_Temp_SpecialCalTypeTempResault = "T_Temp_SpecialCalTypeTempResault";
    public static final String T_Temp_SaleIssueWriteoffRecord = "T_Temp_SaleIssueWriteoffRecord";
    private static final String[] calculateTables = new String[]{"T_Temp_ReverseBills", "T_Temp_FullReverseBills", "T_Temp_FullReverseMaxTimeBills", "T_Temp_FullReverseMaxIdBills", "T_Temp_WeightedAverageMaterialList", "T_Temp_MoveWeightedAverageMaterialList", "T_Temp_FIFOBills", "T_Temp_MiddleFIFOBills", "T_Temp_FIFOMaterialList", "T_Temp_FIFOMaterialListNew", "T_Temp_CostStockTranMaxIdBills", "T_Temp_CostStockTranMaxTimeBills", "T_Temp_TotalCostStockTranOutBills", "T_Temp_TotalCostStockTranInpBills", "T_Temp_WeightedAverageGroupbyList", "T_Temp_MaterialAssistTable", "T_Temp_MaterialAssistTable2", "T_Temp_ASSISTTABLE", "T_Temp_WriteOffTable", "T_Temp_ENTRYINFO", "T_Temp_ReturnBillAssistTableField", "T_Temp_LastEntryTable", "T_Temp_StockTransBillEntryID", "T_Temp_SpecialCalTypeTempResault", "T_Temp_SaleIssueWriteoffRecord"};

    public static String[][] getInpourTableArray() {
        return inpourTableArray;
    }

    public static String[][] getIssueTableArray() {
        return issueTableArray;
    }

    public static String[] getCalculateTables() {
        return calculateTables;
    }

    public static boolean isCostStockTran(String billtype) {
        return "d8e80652-011b-1000-e000-04c5c0a812202407435C".equals(billtype) || "d8e80652-011a-1000-e000-04c5c0a812202407435C".equals(billtype);
    }

    public static String updateReverceBillsPriceSQL(Context ctx, InvBillBaseInfo info, BOSUuid uuid) {
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(info.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        String bill = entityObjectInfo.getTable().getName();
        String billEntry = CalculateUtil.getEntryTableNameFormBillTableName(bill);
        int Local_Currency_Presision = info.getTotalAmount().scale();
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(billEntry).append(" AS T ");
        sql.append(" SET (FActualCost,FUnitActualCost");
        if (issueTableArray[0][0].equalsIgnoreCase(billEntry) || issueTableArray[1][0].equalsIgnoreCase(billEntry) || issueTableArray[2][0].equalsIgnoreCase(billEntry) || issueTableArray[3][0].equalsIgnoreCase(billEntry)) {
            sql.append(",FBaseUnitActualCost");
        }
        if (issueTableArray[0][0].equalsIgnoreCase(billEntry) || inpourTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(",FWrittenOffAmount,FUnWriteOffAmount");
        }
        sql.append(" ) = ( ");
        sql.append(" SELECT ");
        sql.append("  Case ");
        sql.append("  when (ABS(sourceT.FQty) = ABS(EntryIsReversed.FQty)) then ");
        sql.append("  ABS(sourceT.FActualCost)*(EntryIsReversed.FQty/abs(EntryIsReversed.FQty))");
        sql.append("  else ");
        sql.append("  ABS(ROUND(sourceT.FUnitActualCost*EntryIsReversed.FQty,sourceT.FLocalCurrencyPrecision))*(EntryIsReversed.FQty/abs(EntryIsReversed.FQty))");
        sql.append("  end");
        sql.append(" ,(sourceT.FUnitActualCost)");
        if (issueTableArray[0][0].equalsIgnoreCase(billEntry) || issueTableArray[1][0].equalsIgnoreCase(billEntry) || issueTableArray[2][0].equalsIgnoreCase(billEntry) || issueTableArray[3][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,(sourceT.FBaseUnitActualCost)");
        }
        if (issueTableArray[0][0].equalsIgnoreCase(billEntry) || inpourTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,ABS(ROUND(sourceT.FUnitActualCost*EntryIsReversed.FWrittenOffQty,sourceT.FLocalCurrencyPrecision))*(EntryIsReversed.FQty/abs(EntryIsReversed.FQty))");
            sql.append(" ,Case ");
            sql.append("  when ( ABS(sourceT.FQty) = ABS(EntryIsReversed.FQty)) then ");
            sql.append("  ABS(sourceT.FActualCost)*(EntryIsReversed.FQty/abs(EntryIsReversed.FQty))");
            sql.append("  - ABS(ROUND(sourceT.FUnitActualCost*EntryIsReversed.FWrittenOffQty,sourceT.FLocalCurrencyPrecision))*(EntryIsReversed.FQty/abs(EntryIsReversed.FQty))");
            sql.append("  else ");
            sql.append("  ABS(ROUND(sourceT.FUnitActualCost*EntryIsReversed.FQty,sourceT.FLocalCurrencyPrecision))*(EntryIsReversed.FQty/abs(EntryIsReversed.FQty))");
            sql.append("  - ABS(ROUND(sourceT.FUnitActualCost*EntryIsReversed.FWrittenOffQty,sourceT.FLocalCurrencyPrecision))*(EntryIsReversed.FQty/abs(EntryIsReversed.FQty))");
            sql.append("  end");
        }
        sql.append(" FROM ").append(billEntry).append(" as EntryIsReversed  ");
        sql.append(" INNER JOIN ").append(bill).append(" as BillIsReversed ON BillIsReversed.FID = EntryIsReversed.FParentID  ");
        sql.append(" INNER JOIN ");
        sql.append("(");
        sql.append(" SELECT EntrySource.FParentid,EntrySource.FId");
        sql.append(" ,EntrySource.FActualCost,EntrySource.FUnitActualCost");
        if (issueTableArray[0][0].equalsIgnoreCase(billEntry) || issueTableArray[1][0].equalsIgnoreCase(billEntry) || issueTableArray[2][0].equalsIgnoreCase(billEntry) || issueTableArray[3][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,EntrySource.FBaseUnitActualCost");
        }
        sql.append(" ,EntrySource.FQty");
        sql.append(" ,MATERIAL.FPricePrecision,MeasureUnitBase.FQtyPrecision,").append(Local_Currency_Presision).append(" as FLocalCurrencyPrecision");
        if (issueTableArray[0][0].equalsIgnoreCase(billEntry) || inpourTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,EntrySource.FUnWriteOffAmount,EntrySource.FWrittenOffAmount");
        }
        sql.append(" FROM ").append(billEntry).append(" as EntrySource  ");
        sql.append(" INNER JOIN ").append(bill).append(" as BillSource ON BillSource.FID = EntrySource.FParentID  ");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ");
        sql.append(" ON EntrySource.FMaterialID = MATERIAL.FId");
        sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sql.append(" ON (EntrySource.FMaterialID = MeasureUnitBase.FMaterialid");
        sql.append(" AND MATERIAL.FBaseUnit = MeasureUnitBase.FMeasureUnitID )");
        sql.append(" WHERE BillSource.FID = '").append(uuid.toString()).append("'");
        sql.append(") sourceT");
        sql.append(" ON (EntryIsReversed.FSourceBillId = sourceT.FParentid ");
        sql.append(" AND EntryIsReversed.FSourceBillEntryId = sourceT.FId )");
        sql.append(" WHERE (BillIsReversed.FFiVouchered = 0 OR BillIsReversed.FFiVouchered is NULL)");
        sql.append(" AND BillIsReversed.FIsReversed  = 1 ");
        sql.append(" AND T.Fid = EntryIsReversed.Fid");
        sql.append(") ");
        return sql.toString();
    }

    public static String updateFullReverseBillSQL(Context ctx, InvBillBaseInfo info, BOSUuid uuid) {
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(info.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        String bill = entityObjectInfo.getTable().getName();
        String billEntry = CalculateUtil.getEntryTableNameFormBillTableName(bill);
        int Local_Currency_Presision = info.getTotalAmount().scale();
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(billEntry).append(" AS T ");
        sql.append(" SET (FActualCost,FUnitActualCost");
        if (inpourTableArray[0][0].equalsIgnoreCase(billEntry) || issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(",FWrittenOffAmount,FUnWriteOffAmount");
        }
        sql.append(")=(");
        sql.append(" SELECT ((abs(TempEntry.factualcost)+MaxTimeOffSet.factualcost)*(TempEntry.FQty/abs(TempEntry.FQty))) as factualcost");
        sql.append(" ,ABS(ROUND(").append(CalculateUtil.TO_DECIMAL_DIVIDE(CalculateUtil.TO_DECIMAL_SUM("(abs(TempEntry.factualcost)+MaxTimeOffSet.factualcost)") + "/TempEntry.FQty")).append(",MATERIAL.FPricePrecision)) as factualunitcost");
        if (inpourTableArray[0][0].equalsIgnoreCase(billEntry) || issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("ABS(ROUND(" + CalculateUtil.TO_DECIMAL_DIVIDE(CalculateUtil.TO_DECIMAL_SUM("(abs(TempEntry.factualcost)+MaxTimeOffSet.factualcost)") + "/TempEntry.FQty") + ",MATERIAL.FPricePrecision)) * FWrittenOffQty")).append(",").append(Local_Currency_Presision).append(")");
            sql.append(" as FUnWriteOffAmount");
            sql.append(" ,((ABS(TempEntry.factualcost)+MaxTimeOffSet.factualcost)*(TempEntry.FQty/abs(TempEntry.FQty)))");
            sql.append(" - ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("ABS(ROUND(" + CalculateUtil.TO_DECIMAL_DIVIDE(CalculateUtil.TO_DECIMAL_SUM("(abs(TempEntry.factualcost)+MaxTimeOffSet.factualcost)") + "/TempEntry.FQty") + ",MATERIAL.FPricePrecision)) * FWrittenOffQty")).append(",").append(Local_Currency_Presision).append(")");
            sql.append(" as FWrittenOffAmount");
        }
        sql.append(" FROM ").append(bill).append(" TempBill INNER JOIN ").append(billEntry).append(" TempEntry ");
        sql.append(" ON TempBill.fid=TempEntry.fparentid ");
        sql.append(" INNER JOIN (");
        sql.append(" SELECT ENTRY.fsourcebillid,ENTRY.fsourcebillentryid,max(ENTRY.FID) AS FEntrtID");
        sql.append(" ,AVG(MaxTimeOffBill.factualcost) as factualcost");
        sql.append(" FROM ").append(bill).append(" BILL INNER JOIN ").append(billEntry).append(" ENTRY ");
        sql.append(" ON BILL.fid=ENTRY.fparentid ");
        sql.append(" INNER JOIN (");
        sql.append(" SELECT ENTRY.fsourcebillid,ENTRY.fsourcebillentryid,max(BILL.FBizDate) AS FBizDate");
        sql.append(" ,AVG((abs(sourcebill.factualcost)-abs(otherOffSetbill.factualcost))) as factualcost");
        sql.append(" FROM ").append(bill).append(" BILL INNER JOIN ").append(billEntry).append(" ENTRY ");
        sql.append(" ON BILL.fid=ENTRY.fparentid ");
        sql.append(" INNER JOIN (");
        sql.append(" SELECT ENTRY.fparentid,ENTRY.fid,ENTRY.factualcost from ").append(bill).append(" BILL");
        sql.append(" inner join ").append(billEntry).append(" ENTRY on BILL.fid=ENTRY.fparentid ");
        sql.append("  WHERE BILL.FID = '").append(uuid).append("'");
        sql.append("  AND abs(ENTRY.fqty)=abs(ENTRY.freverseqty)");
        sql.append("  AND (BILL.FIsReversed  = 0 or BILL.FIsReversed is Null)");
        sql.append(" ) sourcebill");
        sql.append(" ON (ENTRY.fsourcebillid = sourcebill.fparentid ");
        sql.append(" AND ENTRY.fsourcebillentryid=sourcebill.fid)");
        sql.append(" INNER JOIN (");
        sql.append(" SELECT ENTRY.fsourcebillid,ENTRY.fsourcebillentryid,sum(ENTRY.fqty) as fqty ,sum(ENTRY.factualcost) as factualcost");
        sql.append(" FROM ").append(bill).append(" BILL INNER JOIN ").append(billEntry).append(" ENTRY ");
        sql.append(" ON BILL.fid=ENTRY.fparentid ");
        sql.append(" WHERE ENTRY.fsourcebillid = '").append(uuid).append("'");
        sql.append(" AND BILL.FIsReversed  = 1 ");
        sql.append(" GROUP BY ENTRY.fsourcebillid,ENTRY.fsourcebillentryid");
        sql.append(" ) otherOffSetbill");
        sql.append(" ON (");
        sql.append("     ENTRY.fsourcebillid = otherOffSetbill.fsourcebillid");
        sql.append(" AND ENTRY.fsourcebillentryid=otherOffSetbill.fsourcebillentryid");
        sql.append(" AND abs(sourcebill.factualcost) != abs(otherOffSetbill.factualcost)");
        sql.append(" )");
        sql.append(" WHERE BILL.FIsReversed = 1");
        sql.append(" AND (BILL.FFiVouchered = 0 OR Bill.FFiVouchered is NULL)");
        sql.append(" GROUP BY ENTRY.fsourcebillid,ENTRY.fsourcebillentryid");
        sql.append(" ) MaxTimeOffBill");
        sql.append(" ON (");
        sql.append("     Entry.fsourcebillid = MaxTimeOffBill.fsourcebillid");
        sql.append(" AND Entry.fsourcebillentryid=MaxTimeOffBill.fsourcebillentryid");
        sql.append(" AND BILL.FBizDate = MaxTimeOffBill.FBizDate");
        sql.append(" )");
        sql.append(" WHERE BILL.FIsReversed = 1");
        sql.append(" AND (BILL.FFiVouchered = 0 OR Bill.FFiVouchered is NULL)");
        sql.append(" GROUP BY ENTRY.fsourcebillid ,ENTRY.fsourcebillentryid");
        sql.append(" ) MaxTimeOffSet");
        sql.append(" ON (");
        sql.append("     MaxTimeOffSet.fsourcebillid = TempEntry.fsourcebillid");
        sql.append(" AND MaxTimeOffSet.fsourcebillentryid = TempEntry.fsourcebillentryid");
        sql.append(" AND MaxTimeOffSet.FEntrtID = TempEntry.fid");
        sql.append(" )");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ");
        sql.append(" ON TempEntry.FMaterialID = MATERIAL.FId");
        sql.append(" WHERE TempBill.FIsReversed  = 1");
        sql.append(" AND TempEntry.fid =T.fid");
        sql.append(" )");
        return sql.toString();
    }

    public static String updateFullReverseBill(Context ctx, InvBillBaseInfo info, BOSUuid uuid, String sourceBillId) {
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(info.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        String tableName = entityObjectInfo.getTable().getName();
        String entryTalbeName = CalculateUtil.getEntryTableNameFormBillTableName(tableName);
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ").append(entryTalbeName).append(" AS T");
        sql.append(" SET (FActualCost,FUnitActualCost");
        if (t_im_purinwarehsentry.equalsIgnoreCase(entryTalbeName) || t_im_saleissueentry.equalsIgnoreCase(entryTalbeName)) {
            sql.append(" ,FUnWriteOffAmount,FWrittenOffAmount");
        }
        sql.append(") = (");
        sql.append(" SELECT abs(").append(CalculateUtil.TO_DECIMAL_SUM("abs(sourcebill.factualcost)-abs(otherOffSetbill.factualcost)")).append(")*(").append(CalculateUtil.TO_DECIMAL_DIVIDE("ENTRY.FQty/abs(ENTRY.FQty)")).append(") as factualcost");
        sql.append(" ,ABS(ROUND(").append(CalculateUtil.TO_DECIMAL_DIVIDE(CalculateUtil.TO_DECIMAL_SUM("(abs(sourcebill.factualcost)-abs(otherOffSetbill.factualcost))") + "/ENTRY.FQty")).append(",MATERIAL.FPricePrecision)) as price");
        if (t_im_purinwarehsentry.equalsIgnoreCase(entryTalbeName) || t_im_saleissueentry.equalsIgnoreCase(entryTalbeName)) {
            sql.append(" ,abs(abs(sourcebill.factualcost)-abs(otherOffSetbill.factualcost))*(").append(CalculateUtil.TO_DECIMAL_DIVIDE("ENTRY.FQty/abs(ENTRY.FQty)")).append(") as FUnWriteOffAmount");
            sql.append(" ,0 as FWrittenOffAmount");
        }
        sql.append(" FROM ").append(tableName).append(" BILL ");
        sql.append(" INNER JOIN ").append(entryTalbeName).append(" ENTRY ON BILL.fid=ENTRY.fparentid ");
        sql.append(" INNER JOIN (");
        sql.append(" SELECT b.fparentid,b.fid,b.factualcost ");
        sql.append(" from ").append(tableName).append(" a inner join ").append(entryTalbeName);
        sql.append(" b on a.fid=b.fparentid ");
        sql.append(" WHERE abs(b.fqty)=abs(b.freverseqty)");
        sql.append("   AND (a.FIsReversed  = 0 or a.FIsReversed is Null)");
        sql.append("   AND a.fid='").append(sourceBillId).append("' ");
        sql.append(" ) sourcebill");
        sql.append(" ON (ENTRY.fsourcebillid = sourcebill.fparentid ");
        sql.append(" AND ENTRY.fsourcebillentryid=sourcebill.fid)");
        sql.append(" INNER JOIN (");
        sql.append(" SELECT b.fsourcebillid,b.fsourcebillentryid,sum(b.fqty) as fqty ,sum(b.factualcost) as factualcost");
        sql.append(" FROM ").append(tableName).append(" a INNER JOIN ").append(entryTalbeName).append(" b ");
        sql.append(" ON a.fid=b.fparentid ");
        sql.append(" WHERE a.FIsReversed  = 1 ");
        sql.append("   AND a.fid !='").append(uuid).append("'");
        sql.append("   AND b.fsourcebillid='").append(sourceBillId).append("' ");
        sql.append(" GROUP BY b.fsourcebillid,b.fsourcebillentryid");
        sql.append(" ) otherOffSetbill");
        sql.append(" ON (ENTRY.fsourcebillid = otherOffSetbill.fsourcebillid ");
        sql.append(" and ENTRY.fsourcebillentryid=otherOffSetbill.fsourcebillentryid)");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ");
        sql.append(" ON Entry.FMaterialID = MATERIAL.FId");
        sql.append(" WHERE BILL.fid ='").append(uuid).append("'");
        sql.append("   AND BILL.FIsReversed  = 1 ");
        sql.append(" AND ENTRY.fid =T.fid");
        sql.append(" )");
        return sql.toString();
    }

    public static StringBuffer updateCostStockTranbill(String id, String date) {
        StringBuffer bf = new StringBuffer();
        String actualCost = bf.append("ROUND(").append(CalculateUtil.TO_DECIMAL_AMT("ROUND(" + CalculateUtil.TO_DECIMAL_DIVIDE(CalculateUtil.TO_DECIMAL_SUM("entry.factualcost") + "/entry.fbaseqty") + ",MATERIAL.FPricePrecision)*entrymovein.fbaseqty")).append(",currency.fPrecision)").toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(t_im_moveinwarehsbillentry).append(" as T");
        sql.append(" set (factualcost,funitactualcost)=");
        sql.append(" (");
        sql.append(" select /*+ORDERED*/ ");
        sql.append(actualCost);
        sql.append(",ROUND(").append(CalculateUtil.TO_DECIMAL_DIVIDE(CalculateUtil.TO_DECIMAL_SUM(actualCost) + "/entrymovein.fqty")).append(",MATERIAL.FPricePrecision)");
        sql.append(" from ").append(t_im_moveinwarehsbillentry).append(" as entrymovein");
        sql.append(" inner join ").append(t_im_moveissuebillentry).append(" entry ");
        sql.append(" on (entrymovein.FStockTransferBillID = entry.FStockTransferBillID");
        sql.append(" and entrymovein.FStockTransBillEntryID = entry.FStockTransBillEntryID)");
        sql.append(" inner join (");
        sql.append(" select max(entry.fid) as fid");
        sql.append(" from ").append(t_im_moveissuebill).append(" bill");
        sql.append(" inner join ").append(t_im_moveissuebillentry).append(" entry  ");
        sql.append(" on bill.FIsReversed = 0 and bill.fid=entry.fparentid");
        sql.append(" INNER JOIN T_SCM_TransactionType T1 ");
        sql.append(" ON (bill.FTRANSACTIONTYPEID = T1.FID and T1.FIsCalculate = 1 )").append("\n");
        sql.append(" inner join (");
        sql.append(" select ");
        sql.append(" entry.FStockTransferBillID,entry.FStockTransBillEntryID,max(bill.fbizdate) as fbizdate");
        sql.append(" from ").append(t_im_moveissuebill).append(" bill");
        sql.append(" inner join ").append(t_im_moveissuebillentry).append(" entry  ");
        sql.append(" on bill.fid=entry.fparentid");
        sql.append(" inner join (");
        sql.append(" select FStockTransferBillID,FStockTransBillEntryID ");
        sql.append(" from ").append(t_im_moveinwarehsbill).append(" bill");
        sql.append(" inner join ").append(t_im_moveinwarehsbillentry).append(" entry  ");
        sql.append(" on bill.fid=entry.fparentid");
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (entry.FMaterialID = MATERIALCOMPANY.FMaterialID");
        sql.append(" and entry.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )");
        sql.append(" \n INNER JOIN T_SCM_TransactionType T1 ");
        sql.append(" \n ON bill.FTRANSACTIONTYPEID = T1.FID");
        sql.append(" where Bill.FID='").append(id).append("'");
        sql.append(" and (MATERIALCOMPANY.FAccountType = ").append(1);
        sql.append(" or MATERIALCOMPANY.FAccountType = ").append(2);
        sql.append(") ");
        sql.append(" \n AND T1.FIsCalculate = 1 ");
        sql.append(" group by entry.FStockTransferBillID,entry.FStockTransBillEntryID");
        sql.append(" ) movein ");
        sql.append(" on (movein.FStockTransferBillID = entry.FStockTransferBillID");
        sql.append(" and movein.FStockTransBillEntryID = entry.FStockTransBillEntryID)");
        sql.append(" INNER JOIN T_SCM_TransactionType T1 ");
        sql.append(" ON (bill.FTRANSACTIONTYPEID = T1.FID and T1.FIsCalculate = 1 )").append("\n");
        sql.append(" group by entry.FStockTransferBillID,entry.FStockTransBillEntryID");
        sql.append(" ) maxtime ");
        sql.append(" on (maxtime.FStockTransferBillID = entry.FStockTransferBillID");
        sql.append(" and maxtime.FStockTransBillEntryID = entry.FStockTransBillEntryID");
        sql.append(" and maxtime.fbizdate = bill.fbizdate)");
        sql.append(" group by entry.FStockTransferBillID,entry.FStockTransBillEntryID");
        sql.append(" ) maxentry ");
        sql.append(" on maxentry.FID = entry.FID");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ");
        sql.append(" ON Entry.FMaterialID = MATERIAL.FId");
        sql.append(" INNER JOIN t_org_company company ");
        sql.append(" on company.fid=entry.fcompanyorgunitid");
        sql.append(" inner join t_bd_currency currency");
        sql.append(" on company.fbaseCurrencyid=currency.fid");
        sql.append(" where T.FID = entrymovein.FID");
        sql.append(" )");
        return sql;
    }

    public static String[][] getWeightedTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"Fstorageorg", "NVARCHAR(80)"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouse", "NVARCHAR(80)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FActualUnitCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPeriodBeginQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPeriodBeginBalanceAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FIncomeSumQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FIncomeSumAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPlayOutSumQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPeriodEndBalanceQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FLastBillEntryID", "VARCHAR(44) DEFAULT '' "}, {"FOutwarehouseType", "INT DEFAULT 0 NOT NULL"}, {"FPricePrecision", "INT DEFAULT 2"}, {"FQtyPrecision", "INT DEFAULT 4"}, {"FLocalCurrencyPrecision", "INT DEFAULT 2"}, {"FLastMaxInWarehousePrice", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FIsHasPayoutBill", "INT DEFAULT 0"}, {"FMaxBizDate", "DateTime DEFAULT getDate()"}, {"FLot", "NVARCHAR(255)"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}};
        return fields;
    }

    public static String[][] getFIFOTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44)"}, {"FBillId", "VARCHAR(44) NOT NULL"}, {"FBillEntryId", "VARCHAR(44) NOT NULL"}, {"FEntryTableMame", "VARCHAR(44) NOT NULL"}, {"FNumber", "NVARCHAR(80)"}, {"FBizDate", "DateTime"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"Fstorageorg", "NVARCHAR(80)"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouse", "NVARCHAR(80)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseQtyBak", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPrice", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FReverseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPricePrecision", "INT DEFAULT 2"}, {"FQtyPrecision", "INT DEFAULT 4"}, {"FLocalCurrencyPrecision", "INT DEFAULT 2"}, {"FCalculateKind", "INT DEFAULT 0"}, {"FTransactionTypeName", "NVARCHAR(255)"}, {"FSeqNum", "INT DEFAULT 0"}, {"FFiVouchered", "INT DEFAULT 0"}, {"FBizTypeID", "VARCHAR(44)"}, {"FSourceBillID", "VARCHAR(44)"}, {"FSourceBillEntryID", "VARCHAR(44)"}, {"FSourceBillEntrySeq", "INT "}, {"FSourceUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FActualCostBak", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FbillTypeID", "VARCHAR(44)"}, {"FmaterialNumber", "NVARCHAR(255)"}, {"FisCombition", "INT DEFAULT 0"}, {"FisSrcBilInCurrPid", "INT DEFAULT 0"}, {"FISPRESENT", "INT DEFAULT 0"}, {"FStockTransBillEntryID", "VARCHAR(44)"}, {"FAUDITTIME", "DateTime"}, {"FSourceBillTypeID", "VARCHAR(44)"}, {"FIsReversed", "INT DEFAULT 0"}, {"FLot", "NVARCHAR(255)"}, {"FIsReWork", "INT DEFAULT 0"}, {"FOutwarehouseType", "INT DEFAULT -1"}, {"FStoreTypeID", "VARCHAR(44)"}, {"FStoreTypePreID", "VARCHAR(44)"}, {"FBillTypeName", "NVARCHAR(80)"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}, {"FBaseUnit", "VARCHAR(44)"}, {"FUnitID", "VARCHAR(44)"}, {"FQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FWrittenOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FUnWriteOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FisWriteOffVouched", "INT DEFAULT 0"}, {"FBASECONVSRATE", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FStockStatus", "INT DEFAULT 0"}, {"FStockClosePeriod", "INT DEFAULT 0"}};
        return fields;
    }

    public static String[][] getFIFOTempTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44)"}, {"FBillId", "VARCHAR(44) NOT NULL"}, {"FBillEntryId", "VARCHAR(44) NOT NULL"}, {"FEntryTableMame", "VARCHAR(44) NOT NULL"}, {"FNumber", "NVARCHAR(80)"}, {"FBizDate", "DateTime"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"Fstorageorg", "NVARCHAR(80)"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouse", "NVARCHAR(80)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseQtyBak", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPrice", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FReverseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPricePrecision", "INT DEFAULT 2"}, {"FLocalCurrencyPrecision", "INT DEFAULT 2"}, {"FCalculateKind", "INT DEFAULT 0"}, {"FTransactionTypeName", "NVARCHAR(255)"}, {"FSeqNum", "INT DEFAULT 0"}, {"FFiVouchered", "INT DEFAULT 0"}, {"FBizTypeID", "VARCHAR(44)"}, {"FSourceBillID", "VARCHAR(44)"}, {"FSourceBillEntryID", "VARCHAR(44)"}, {"FSourceBillEntrySeq", "INT "}, {"FSourceUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FActualCostBak", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FbillTypeID", "VARCHAR(44)"}, {"FmaterialNumber", "NVARCHAR(255)"}, {"FisCombition", "INT DEFAULT 0"}, {"FisSrcBilInCurrPid", "INT DEFAULT 0"}, {"FISPRESENT", "INT DEFAULT 0"}, {"FStockTransBillEntryID", "VARCHAR(44)"}, {"FAUDITTIME", "DateTime"}, {"FSourceBillTypeID", "VARCHAR(44)"}, {"FIsReversed", "INT DEFAULT 0"}, {"FLot", "NVARCHAR(255)"}, {"FIsReWork", "INT DEFAULT 0"}, {"FOutwarehouseType", "INT DEFAULT -1"}, {"FStoreTypeID", "VARCHAR(44)"}, {"FStoreTypePreID", "VARCHAR(44)"}, {"FBillTypeName", "NVARCHAR(80)"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}, {"FBaseUnit", "VARCHAR(44)"}, {"FUnitID", "VARCHAR(44)"}, {"FQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FWrittenOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FUnWriteOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FisWriteOffVouched", "INT DEFAULT 0"}};
        return fields;
    }

    public static String[][] getMultiMeasureUnitTempTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44)"}, {"FBillId", "VARCHAR(44) NOT NULL"}, {"FBillEntryId", "VARCHAR(44) NOT NULL"}, {"FEntryTableMame", "VARCHAR(44) NOT NULL"}, {"FNumber", "NVARCHAR(80)"}, {"FBizDate", "DateTime"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"Fstorageorg", "NVARCHAR(80)"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouse", "NVARCHAR(80)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseQtyBak", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPrice", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FReverseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPricePrecision", "INT DEFAULT 2"}, {"FLocalCurrencyPrecision", "INT DEFAULT 2"}, {"FCalculateKind", "INT DEFAULT 0"}, {"FTransactionTypeName", "NVARCHAR(255)"}, {"FSeqNum", "INT DEFAULT 0"}, {"FFiVouchered", "INT DEFAULT 0"}, {"FBizTypeID", "VARCHAR(44)"}, {"FSourceBillID", "VARCHAR(44)"}, {"FSourceBillEntryID", "VARCHAR(44)"}, {"FSourceBillEntrySeq", "INT "}, {"FSourceUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FActualCostBak", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FbillTypeID", "VARCHAR(44)"}, {"FmaterialNumber", "NVARCHAR(255)"}, {"FisCombition", "INT DEFAULT 0"}, {"FisSrcBilInCurrPid", "INT DEFAULT 0"}, {"FISPRESENT", "INT DEFAULT 0"}, {"FStockTransBillEntryID", "VARCHAR(44)"}, {"FAUDITTIME", "DateTime"}, {"FSourceBillTypeID", "VARCHAR(44)"}, {"FIsReversed", "INT DEFAULT 0"}, {"FLot", "NVARCHAR(255)"}, {"FIsReWork", "INT DEFAULT 0"}, {"FOutwarehouseType", "INT DEFAULT -1"}, {"FStoreTypeID", "VARCHAR(44)"}, {"FStoreTypePreID", "VARCHAR(44)"}, {"FBillTypeName", "NVARCHAR(80)"}, {"FBaseUnit", "VARCHAR(44)"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}, {"FUnitID", "VARCHAR(44)"}, {"FQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FWrittenOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FUnWriteOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FisWriteOffVouched", "INT DEFAULT 0"}};
        return fields;
    }

    public static String[][] getMaterialTempTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44)"}, {"FNumber", "NVARCHAR(80)"}, {"FPricePrecision", "INT DEFAULT 2"}, {"FBaseUnit", "VARCHAR(44)"}};
        return fields;
    }

    public static String[][] getMiddleFIFOTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FBillId", "VARCHAR(44) NOT NULL"}, {"FBillEntryId", "VARCHAR(44) NOT NULL"}, {"FEntryTableMame", "VARCHAR(44) NOT NULL"}, {"FNumber", "NVARCHAR(80)"}, {"FBizDate", "DateTime"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"Fstorageorg", "NVARCHAR(80)"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouse", "NVARCHAR(80)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseQtyBak", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPrice", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FReverseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPricePrecision", "INT DEFAULT 2"}, {"FCalculateKind", "INT DEFAULT 0"}, {"FSeqNum", "INT DEFAULT 0"}, {"FFiVouchered", "INT DEFAULT 0"}, {"FBizTypeID", "VARCHAR(44)"}, {"FSourceBillID", "VARCHAR(44)"}, {"FSourceBillEntryID", "VARCHAR(44)"}, {"FSourceBillEntrySeq", "INT "}, {"FSourceUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FActualCostBak", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FbillTypeID", "VARCHAR(44)"}, {"FTransactionTypeName", "NVARCHAR(255)"}, {"FmaterialNumber", "NVARCHAR(255)"}, {"FisCombition", "INT DEFAULT 0"}, {"FisSrcBilInCurrPid", "INT DEFAULT 0"}, {"FISPRESENT", "INT DEFAULT 0"}, {"FStockTransBillEntryID", "VARCHAR(44)"}, {"FAUDITTIME", "DateTime"}, {"FSourceBillTypeID", "VARCHAR(44)"}, {"FIsReversed", "INT DEFAULT 0"}, {"FLot", "NVARCHAR(255)"}, {"FBaseUnit", "VARCHAR(44)"}, {"FIsReWork", "INT DEFAULT 0"}, {"FOutwarehouseType", "INT DEFAULT -1"}, {"FStoreTypeID", "VARCHAR(44)"}, {"FStoreTypePreID", "VARCHAR(44)"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}};
        return fields;
    }

    public static String[][] getMiddleInOutTempTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FBillId", "VARCHAR(44) NOT NULL"}, {"FBillEntryId", "VARCHAR(44) NOT NULL"}, {"FEntryTableMame", "VARCHAR(44) NOT NULL"}, {"FNumber", "NVARCHAR(80)"}, {"FBizDate", "DateTime"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseQtyBak", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPrice", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FReverseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FCalculateKind", "INT DEFAULT 0"}, {"FSeqNum", "INT DEFAULT 0"}, {"FFiVouchered", "INT DEFAULT 0"}, {"FBizTypeID", "VARCHAR(44)"}, {"FSourceBillID", "VARCHAR(44)"}, {"FSourceBillEntryID", "VARCHAR(44)"}, {"FSourceBillEntrySeq", "INT "}, {"FSourceUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FActualCostBak", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FBillTypeID", "VARCHAR(44)"}, {"FBillTypeName", "NVARCHAR(80)"}, {"FTransactionTypeID", "VARCHAR(44)"}, {"FisCombition", "INT DEFAULT 0"}, {"FisSrcBilInCurrPid", "INT DEFAULT 0"}, {"FISPRESENT", "INT DEFAULT 0"}, {"FStockTransBillEntryID", "VARCHAR(44)"}, {"FAUDITTIME", "DateTime"}, {"FSourceBillTypeID", "VARCHAR(44)"}, {"FIsReversed", "INT DEFAULT 0"}, {"FLot", "NVARCHAR(255)"}, {"FIsReWork", "INT DEFAULT 0"}, {"FOutwarehouseType", "INT DEFAULT -1"}, {"FStoreTypeID", "VARCHAR(44)"}, {"FStoreTypePreID", "VARCHAR(44)"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}, {"FUnitID", "VARCHAR(44)"}, {"FQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FWrittenOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FUnWriteOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FisWriteOffVouched", "INT DEFAULT 0"}};
        return fields;
    }

    public static String[][] getFIFOMaterialTableFields() {
        String[][] fields = new String[][]{{"FMaterialId", "VARCHAR(44) NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FIsHasPayoutBill", "INT DEFAULT 0"}, {"FPricePrecision", "INT DEFAULT 2"}, {"FLocalCurrencyPrecision", "INT DEFAULT 2"}, {"FQtyPrecision", "INT DEFAULT 2"}, {"FmaterialNumber", "NVARCHAR(255)"}};
        return fields;
    }

    public static String[][] getFIFOMaterialTableFieldsNew() {
        String[][] fields = new String[][]{{"ksql_seq", "INT IDENTITY(1,1)"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"Fstorageorgunitid", "VARCHAR(44)"}, {"Fwarehouseid", "VARCHAR(44)"}, {"FIsHasPayoutBill", "INT DEFAULT 0"}, {"FPricePrecision", "INT DEFAULT 2"}, {"FLocalCurrencyPrecision", "INT DEFAULT 2"}, {"FQtyPrecision", "INT DEFAULT 2"}, {"FmaterialNumber", "NVARCHAR(255)"}};
        return fields;
    }

    public static String[][] getMoveWeightedTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FMaterialId", "VARCHAR(44) NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"FStorageOrgUnitID", "VARCHAR(44)"}, {"FWarehouseID", "VARCHAR(44)"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0"}, {"FPricePrecision", "INT DEFAULT 2"}, {"FQtyPrecision", "INT DEFAULT 4"}, {"FLocalCurrencyPrecision", "INT DEFAULT 2"}, {"FYear", "INT DEFAULT 1999"}, {"FPeriod", "INT DEFAULT 1"}, {"FCalculateKind", "INT DEFAULT 1"}, {"FBillName", "VARCHAR(80)"}, {"FBillNumber", "VARCHAR(80)"}, {"FIncome", "VARCHAR(200)"}, {"FPayout", "VARCHAR(200)"}, {"FSettleAccounts", "VARCHAR(500)"}, {"FCreateTime", "DateTime"}, {"FBizTypeID", "VARCHAR(44)"}, {"FSourceBillID", "VARCHAR(44)"}, {"FISCALCULATE", "INT DEFAULT 1"}};
        return fields;
    }

    public static String[][] getReverseBillsTableFields() {
        String[][] fields = new String[][]{{"FSourceBillId", "VARCHAR(44) NOT NULL "}, {"FSourceBillEntryId", "VARCHAR(44) NOT NULL "}, {"FPricePrecision", "INT DEFAULT 0"}, {"FQtyPrecision", "INT DEFAULT 0"}, {"FLocalCurrencyPrecision", "INT DEFAULT 0"}, {"FQty", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"Factualcost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    public static String[][] getFullReverseBillsTableFields() {
        String[][] fields = new String[][]{{"fbillid", "VARCHAR(44) NOT NULL "}, {"fbillentryid", "VARCHAR(44) NOT NULL "}, {"factualcost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    public static String[][] getFullReverseMaxTimeBillsTableFields() {
        String[][] fields = new String[][]{{"fsourcebillid", "VARCHAR(44) NOT NULL "}, {"fsourcebillentryid", "VARCHAR(44) NOT NULL "}, {"FBizDate", "DateTime"}, {"factualcost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    public static String[][] getFullReverseMaxIdBillsTableFields() {
        String[][] fields = new String[][]{{"fsourcebillid", "VARCHAR(44) NOT NULL "}, {"fsourcebillentryid", "VARCHAR(44) NOT NULL "}, {"fentryid", "VARCHAR(44) NOT NULL "}, {"factualcost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    public static String[][] getLastEntryTempTableFields() {
        String[][] fields = new String[][]{{"FID", "Varchar(44)"}, {"FMaterialID", "Varchar(44)"}, {"FCompanyOrgUnitID", "Varchar(44)"}, {"FStorageOrgUnitID", "Varchar(44)"}, {"FWarehouseID", "Varchar(44)"}, {"FAdminOrgUnitID", "Varchar(44)"}, {"FCostCenterOrgUnitID", "Varchar(44)"}, {"FLot", "NVARCHAR(255)"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}};
        return fields;
    }

    public static void updateListObjValue(ArrayList list, RecentCostInfo info) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(info)) continue;
            if (CalculateUtil.ZERO.compareTo(info.getRecentQty()) > 0) {
                ((RecentCostInfo)list.get(i)).setRecentCost(info.getRecentCost().negate());
                break;
            }
            if (CalculateUtil.ZERO.compareTo(info.getRecentCost()) < 0) break;
            ((RecentCostInfo)list.get(i)).setRecentCost(info.getRecentCost().abs());
            break;
        }
    }

    public static String[][] getCostStockTranMaxTimeBillsTableFields() {
        String[][] fields = new String[][]{{"FStockTransferBillID", "VARCHAR(44) NOT NULL "}, {"FStockTransBillEntryID", "VARCHAR(44) NOT NULL "}, {"FBizDate", "DateTime"}};
        return fields;
    }

    public static String[][] getCostStockTranMaxIDBillsTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL "}};
        return fields;
    }

    public static String[][] getTotalCostStockTranOutWarehsTableFields() {
        String[][] fields = new String[][]{{"FStockTransferBillID", "VARCHAR(44) NOT NULL"}, {"FStockTransBillEntryID", "VARCHAR(44) NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    public static String[][] getTotalCostStockTranInpWarehsTableFields() {
        String[][] fields = new String[][]{{"FStockTransferBillID", "VARCHAR(44) NOT NULL"}, {"FStockTransBillEntryID", "VARCHAR(44) NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FMantissaAmt", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FMantissaQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FEntryID", "VARCHAR(44)"}};
        return fields;
    }

    public static String[][] getWeightedAssistTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FPlayOutSumQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPeriodEndBalanceQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    public static String[][] getMaterialAssistTableFields() {
        String[][] fields = new String[][]{{"FMaterialid", "VARCHAR(44) NOT NULL"}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"fstorageorgunitid", "VARCHAR(44)"}, {"fwarehouseid", "VARCHAR(44)"}, {"FLot", "NVARCHAR(255)"}, {"FIssueActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"Fstorageorg", "VARCHAR(80)"}, {"FWarehouse", "NVARCHAR(80)"}, {"FperiodBeginCostDiff", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FperiodBeginBalance", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FincomeCostAdjAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FStandardCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FbaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FperiodBeginQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBillTypeID", "VARCHAR(44)"}, {"FNumber", "VARCHAR(80)"}, {"FBizDate", "DateTime"}, {"fOutwarehouseType", "INT DEFAULT 0 NOT NULL"}, {"FTABLEName", "VARCHAR(80)"}, {"FBillTypeName", "VARCHAR(80)"}, {"FUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBASEUNITID", "VARCHAR(44)"}, {"FUnitID", "VARCHAR(44)"}, {"FEntryID", "VARCHAR(44)"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}};
        return fields;
    }

    public static String[][] getMaterialAssistTableFields2() {
        String[][] fields = new String[][]{{"FMaterialid", "VARCHAR(44) NOT NULL "}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"fstorageorgunitid", "VARCHAR(44)"}, {"fwarehouseid", "VARCHAR(44)"}, {"FLot", "NVARCHAR(255)"}, {"FIssueActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"Fstorageorg", "NVARCHAR(80)"}, {"FWarehouse", "NVARCHAR(80)"}, {"FperiodBeginCostDiff", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FperiodBeginBalance", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FincomeCostAdjAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FStandardCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FbaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FperiodBeginQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBillTypeID", "VARCHAR(44)"}, {"FNumber", "VARCHAR(80)"}, {"FBizDate", "DateTime"}, {"fOutwarehouseType", "INT DEFAULT 0 NOT NULL"}, {"FTABLEName", "VARCHAR(80)"}, {"FBillTypeName", "VARCHAR(80)"}, {"FentryId", "VARCHAR(44)"}, {"FReverseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FIsReversed", "INT DEFAULT 0 "}, {"FFiVouchered", "INT DEFAULT 0 "}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}};
        return fields;
    }

    public static String[][] getAssistTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FUnitActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FBaseUnitActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FWrittenOffAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FUnWriteOffAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FOutwarehouseType", "INT DEFAULT 0 NOT NULL"}, {"FMaxBizDate", "DateTime DEFAULT getDate()"}, {"FLastBillEntryID", "VARCHAR(44) DEFAULT '' "}, {"FEntryTableMame", "VARCHAR(80) DEFAULT ''"}};
        return fields;
    }

    public static String[][] getCostAdjustAssistTableFields() {
        String[][] fields = new String[][]{{"FPurInWarehsBillID", "VARCHAR(44)"}, {"FPurInWarehsEntryID", "VARCHAR(44)"}, {"FCostAdjustBillID", "VARCHAR(44)"}, {"FCostAdjustEntryID", "VARCHAR(44)"}, {"FMaterialID", "VARCHAR(44)"}, {"FStorageOrgUnitID", "VARCHAR(44)"}, {"FWarehouseID", "VARCHAR(44)"}};
        return fields;
    }

    public static String[][] getCostAdjustTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FMaterialID", "VARCHAR(44)"}, {"FStorageOrgUnitID", "VARCHAR(44)"}, {"FWarehouseID", "VARCHAR(44)"}, {"FLocalCurrencyPrecision", "INT DEFAULT 2"}, {"FDiffAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FIssueDiffAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FPeriodBeginQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPeriodBeginUnWriteOffQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPeriodWrittenOffQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FPeriodEndWrittenOffQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FLocationID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}, {"FAdminOrgUnitId", "VARCHAR(44)"}, {"FLOT", "NVARCHAR(80)"}, {"FCostCenterOrgUnitId", "VARCHAR(44)"}};
        return fields;
    }

    public static boolean isEfficeBalance(String billtype, String CalType) {
        if (InventoryBillHelp.isCostStockTran(billtype)) {
            if ("0".equals(CalType)) {
                return false;
            }
            if ("1".equals(CalType)) {
                return "d8e80652-011a-1000-e000-04c5c0a812202407435C".equals(billtype);
            }
            return true;
        }
        return true;
    }

    public static String[][] getWriteOffTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FBillID", "VARCHAR(44)"}, {"FBillEntryID", "VARCHAR(44)"}, {"FCurrWrittenOffQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FCurrWrittenOffAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FWrittenOffAmount", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FUnWirteOffQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    public static String[][] getSaleIssueWriteOffTableFields() {
        String[][] fields = new String[][]{{"FBillEntryID", "VARCHAR(44) NOT NULL"}, {"FBillID", "VARCHAR(44)"}};
        return fields;
    }

    public static String[][] getEntryInfoTableFields() {
        String[][] fields = new String[][]{{"FParentID", "VARCHAR(44)"}, {"FStockTransferBillID", "VARCHAR(44)"}, {"FStockTransBillEntryID", "VARCHAR(44)"}};
        return fields;
    }

    public static String[][] getReturnBillAssistTableFields() {
        String[][] fields = new String[][]{{"FMaterialid", "VARCHAR(44) NOT NULL "}, {"FCompanyOrgUnitID", "VARCHAR(44) NOT NULL"}, {"fstorageorgunitid", "VARCHAR(44)"}, {"fwarehouseid", "VARCHAR(44)"}, {"FLot", "NVARCHAR(255)"}, {"FIssueActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"Fstorageorg", "NVARCHAR(80)"}, {"FWarehouse", "NVARCHAR(80)"}, {"FperiodBeginCostDiff", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FperiodBeginBalance", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FincomeCostAdjAmt", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FStandardCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FbaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBaseUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FperiodBeginQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FBillTypeID", "VARCHAR(44)"}, {"FNumber", "NVARCHAR(80)"}, {"FBizDate", "DateTime"}, {"FentryId", "VARCHAR(44)"}, {"FBASEUNITID", "VARCHAR(44)"}, {"FSourceBillTypeID", "VARCHAR(44)"}, {"FSourceBillEntryID", "VARCHAR(44)"}, {"fOutwarehouseType", "INT DEFAULT 0 NOT NULL"}, {"FTABLEName", "VARCHAR(80)"}, {"FBillTypeName", "NVARCHAR(80)"}, {"FReverseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FIsReversed", "INT DEFAULT 0 "}, {"FFiVouchered", "INT DEFAULT 0 "}, {"FisSrcBillInPre", "INT DEFAULT 0 "}, {"FAssistPropertyID", "VARCHAR(44)"}, {"FProjectID", "VARCHAR(44)"}, {"FTrackNumberID", "VARCHAR(44)"}};
        return fields;
    }

    public static String[][] getStockTransEntryID() {
        String[][] fields = new String[][]{{"FStockTransBillEntryID", "VARCHAR(44)"}};
        return fields;
    }

    public static String[][] getStockTransEntryAndClosePeriod() {
        String[][] fields = new String[][]{{"FStockTransBillEntryID", "VARCHAR(44)"}, {"FClosePeriod", "int"}, {"FBASESTATUS", "int"}};
        return fields;
    }

    public static String[][] getMatReqTempTableFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    public static String[][] getSpecialCalTypeTempFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FActualLot", "NVARCHAR(255)"}, {"FActualAssistPropertyID", "VARCHAR(44)"}, {"FActualProjectID", "VARCHAR(44)"}, {"FActualTrackNumberID", "VARCHAR(44)"}};
        return fields;
    }

    public static String[][] getPurInwarehsTempFields() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FActualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FUnitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"FWrittenOffAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"FUnWriteOffAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}};
        return fields;
    }
}

