/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.help;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.help.InventoryBillHelp;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpdateBillCostHelper {
    protected static final int PAGE_COUNT = 200;
    private Logger logger = Logger.getLogger(UpdateBillCostHelper.class);
    protected String[][] issueTableArray = InventoryBillHelp.getIssueTableArray();
    private Connection conn = null;
    private Map updateTabPSMap = new HashMap();

    public UpdateBillCostHelper(Connection conn) {
        this.conn = conn;
    }

    private CountPreparedStatement getPreParedStatement(String tableName) throws BOSException {
        CountPreparedStatement result = (CountPreparedStatement)this.updateTabPSMap.get(tableName);
        try {
            if (result == null) {
                PreparedStatement pstm = this.conn.prepareStatement(this.getUpdateBillCostSQL(tableName));
                result = new CountPreparedStatement(pstm);
                this.updateTabPSMap.put(tableName, result);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private String getUpdateBillCostSQL(String tableName) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("update ").append(tableName);
        sSQL.append(" set FActualCost = ?,FUnitActualCost = ?");
        if (!"T_CL_CostAdjustBillEntry".equals(tableName)) {
            sSQL.append(",FBaseUnitActualCost = ?");
        }
        if (this.issueTableArray[0][0].equalsIgnoreCase(tableName)) {
            sSQL.append(",FWrittenOffAmount = ?,FUnWriteOffAmount = ?");
        } else if (this.issueTableArray[2][0].equalsIgnoreCase(tableName)) {
            sSQL.append(",FSCWrittenOffAmount = ?,FSCUnWrittenOffAmount = ?");
        }
        sSQL.append(" where FID = ?");
        return sSQL.toString();
    }

    private void addUpdateBill(RecentCostInfo billInfo) throws BOSException {
        String tableName = billInfo.getString("FEntryTableMame");
        CountPreparedStatement pstmt = this.getPreParedStatement(tableName);
        StringBuffer sql = new StringBuffer();
        Statement statement = null;
        ResultSet rs = null;
        try {
            sql.append("select FBASECONVSRATE from T_BD_MULTIMEASUREUNIT where fmaterialid = '");
            sql.append(billInfo.getString("fmaterialid")).append("' and FMEASUREUNITID = '");
            sql.append(billInfo.getString("FUnitID")).append("'");
            BigDecimal unitActuralCost = billInfo.getPrice();
            if (!billInfo.getString("FBaseUnit").equals(billInfo.getString("FUnitID"))) {
                BigDecimal baseconvsrate = billInfo.getBigDecimal("FBASECONVSRATE");
                unitActuralCost = billInfo.getPrice().multiply(baseconvsrate).setScale(billInfo.getInt("FPricePrecision"), 4);
                if (baseconvsrate.equals(BigDecimal.ZERO)) {
                    statement = this.conn.createStatement();
                    rs = statement.executeQuery(sql.toString());
                    if (rs.next()) {
                        baseconvsrate = rs.getBigDecimal("FBASECONVSRATE");
                        unitActuralCost = billInfo.getPrice().multiply(baseconvsrate).setScale(billInfo.getInt("FPricePrecision"), 4);
                    } else {
                        unitActuralCost = billInfo.getUnitActualCost();
                    }
                }
            }
            if (billInfo.getQty().compareTo(BigDecimal.ZERO) == 0) {
                unitActuralCost = BigDecimal.ZERO;
            }
            billInfo.setPrice(billInfo.getPrice().setScale(billInfo.getInt("FPricePrecision"), 4));
            pstmt.setBigDecimal(1, billInfo.getRecentCost());
            pstmt.setBigDecimal(2, unitActuralCost);
            if (!"T_CL_CostAdjustBillEntry".equals(tableName)) {
                pstmt.setBigDecimal(3, billInfo.getPrice());
            }
            if (this.issueTableArray[0][0].equalsIgnoreCase(tableName) || this.issueTableArray[2][0].equalsIgnoreCase(tableName)) {
                pstmt.setBigDecimal(4, billInfo.getWrittenOffAmount());
                pstmt.setBigDecimal(5, billInfo.getUnWriteOffAmount());
                pstmt.setString(6, billInfo.getString("FBillEntryId"));
            } else if (!"T_CL_CostAdjustBillEntry".equals(tableName)) {
                pstmt.setString(4, billInfo.getString("FBillEntryId"));
            } else {
                pstmt.setString(3, billInfo.getString("FBillEntryId"));
            }
            pstmt.addBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((ResultSet)rs);
    }

    public void updateBills(List billList, Map balanceMap) throws BOSException {
        RecentCostInfo billInfo = null;
        RecentCostInfo costMoveInfo = null;
        RecentCostInfo costMoveInbillInfo = null;
        HashMap costMovemap = (HashMap)balanceMap.get("CostPriceMove__");
        if (billList == null) {
            return;
        }
        for (int i = 0; i < billList.size(); ++i) {
            billInfo = (RecentCostInfo)billList.get(i);
            if (billInfo.getString("FEntryTableMame") != null && billInfo.isNeedUpdate() && !billInfo.isDealComplete()) {
                this.addUpdateBill(billInfo);
            }
            if (!billInfo.isMoveOutBill() || costMovemap == null || (costMoveInfo = (RecentCostInfo)costMovemap.get(billInfo.getStockTransBillEntryID())) == null) continue;
            ArrayList costMoveList = costMoveInfo.getMoveInbillList();
            if (costMoveInfo.getStockTransBillEntryID() == null) continue;
            for (int j = 0; costMoveList != null && j < costMoveList.size(); ++j) {
                costMoveInbillInfo = (RecentCostInfo)costMoveList.get(j);
                if (!costMoveInbillInfo.isNeedUpdate()) continue;
                this.addUpdateBill(costMoveInbillInfo);
            }
        }
    }

    public void executeBatch(boolean isExecImmediate) throws BOSException {
        Iterator it = this.updateTabPSMap.entrySet().iterator();
        Map.Entry entry = null;
        try {
            while (it.hasNext()) {
                entry = it.next();
                ((CountPreparedStatement)entry.getValue()).executeBatch(isExecImmediate);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void close() {
        Iterator it = this.updateTabPSMap.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            ((CountPreparedStatement)entry.getValue()).close();
        }
    }

    class CountPreparedStatement {
        private int count = 0;
        private PreparedStatement pstmt = null;

        public CountPreparedStatement(PreparedStatement pstmt) {
            this.pstmt = pstmt;
        }

        public void addBatch() throws SQLException {
            ++this.count;
            this.pstmt.addBatch();
            this.executeBatch(false);
        }

        public void setString(int parameterIndex, String x) throws SQLException {
            this.pstmt.setString(parameterIndex, x);
        }

        public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
            this.pstmt.setBigDecimal(parameterIndex, x);
        }

        public void setInt(int parameterIndex, int x) throws SQLException {
            this.pstmt.setInt(parameterIndex, x);
        }

        public void executeBatch(boolean isExecImmediate) throws SQLException {
            if (isExecImmediate) {
                this.pstmt.executeBatch();
                this.pstmt.clearBatch();
                this.count = 0;
                return;
            }
            if (this.count >= 200) {
                this.pstmt.executeBatch();
                this.pstmt.clearBatch();
                this.count = 0;
            }
        }

        public void close() {
            try {
                this.pstmt.close();
            }
            catch (SQLException e) {
                UpdateBillCostHelper.this.logger.error((Object)e);
            }
            this.pstmt = null;
        }
    }
}

