/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.config;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.fi.ap.BillStatusEnum;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.arap.config.OtherBillCommonHandler;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.scm.cal.client.ManualWriteOffQueryUIFactory;
import com.kingdee.eas.scm.framework.writeoff.IApportionCommonHandler;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JTextField;

public class ApOtherBillApportionHandler
extends OtherBillCommonHandler
implements IApportionCommonHandler {
    private String apportionType = null;

    public ApOtherBillApportionHandler() {
    }

    public ApOtherBillApportionHandler(String apportionType) {
        this.apportionType = apportionType;
    }

    public String getBOSType() {
        return "48DA3A71";
    }

    public String[][] getDisplayFields() {
        return new String[][]{{"false", "selected", EASResource.getString((String)"com.kingdee.eas.scm.cal.ExpenseApportionResource", (String)"selected")}, {"false", "number", null}, {"false", "billDate", EASResource.getString((String)"com.kingdee.eas.scm.cal.ExpenseApportionResource", (String)"bizDate")}, {"false", "asstActName", null}, {"false", "company.name", EASResource.getString((String)"com.kingdee.eas.scm.cal.ExpenseApportionResource", (String)"companyOrgUnit_name")}, {"false", "expenseItem.number", null}, {"false", "expenseItem.name", null}, {"false", "abstractName", null}, {"false", "entry.remark", null}, {"false", "material.number", null}, {"false", "material.name", null}, {"true", "entry.recievePayAmountLocal", EASResource.getString((String)"com.kingdee.eas.scm.cal.ExpenseApportionResource", (String)"entries_amount")}, {"true", "entry.amountLocal", EASResource.getString((String)"com.kingdee.eas.scm.cal.ExpenseApportionResource", (String)"entries_localNonTaxAmount")}, {"true", "entry.unApportionAmount", EASResource.getString((String)"com.kingdee.eas.scm.cal.ExpenseApportionResource", (String)"nonApportionAmount")}, {"true", "thisApportionAmountLocal", EASResource.getString((String)"com.kingdee.eas.scm.cal.ExpenseApportionResource", (String)"apportionAmount")}};
    }

    public String getContainerName() {
        if ("pur".equals(this.apportionType)) {
            return EASResource.getString((String)"com.kingdee.eas.scm.framework.writeoff.client.ApportionCommon", (String)"AP2PIPURTOP");
        }
        if ("dev".equals(this.apportionType)) {
            return EASResource.getString((String)"com.kingdee.eas.scm.framework.writeoff.client.ApportionCommon", (String)"AP2PIDEVTOP");
        }
        if ("incomeConfirm".equals(this.apportionType)) {
            return EASResource.getString((String)"com.kingdee.eas.scm.framework.writeoff.client.ApportionCommon", (String)"AP2PIINCOMETOP");
        }
        return "";
    }

    public String getEditUIClassName() {
        return "com.kingdee.eas.fi.ap.client.OtherBillEditUI";
    }

    public String[] getHiddenFields() {
        return new String[]{"currency.precision", "baseCurrency.precision", "id", "entry.id", "lastUpdateTime"};
    }

    public String[] getLocalAmountFields() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(super.getLocalAmountFields()));
        list.add("entry.unApportionAmount");
        list.add("entry.apportionAmount");
        list.add("thisApportionAmountLocal");
        return list.toArray(new String[list.size()]);
    }

    public String[] getModifyFields() {
        return new String[]{"selected", "thisApportionAmountLocal"};
    }

    public CustomerQueryPanel getQueryUI(String companyId, Map uiContext) throws Exception {
        String premissonItem = null;
        if ("pur".equals(this.apportionType)) {
            premissonItem = "expenseApportionUI";
        } else if ("dev".equals(this.apportionType)) {
            premissonItem = "DevExpenseApportion";
        } else if ("incomeConfirm".equals(this.apportionType)) {
            premissonItem = "SaleExpenseApportionUI";
        }
        CustomerQueryPanel queryUI = ManualWriteOffQueryUIFactory.createQueryUI((int)2, (String)premissonItem, (String)companyId, (boolean)false, (boolean)false);
        queryUI.setSize(508, 435);
        return queryUI;
    }

    public String[] getSumFields() {
        return new String[]{"entry.recievePayAmountLocal", "entry.amountLocal", "entry.unApportionAmount", "thisApportionAmountLocal"};
    }

    public String[] getUserDefineFields() {
        return new String[]{"selected", "thisApportionAmountLocal"};
    }

    public void handleTableEditStopped(KDTEditEvent e) throws Exception {
        KDTable table = (KDTable)e.getSource();
        if ("thisApportionAmountLocal".equalsIgnoreCase(table.getColumnKey(e.getColIndex()))) {
            IRow curRow = table.getRow(e.getRowIndex());
            BigDecimal thisApportionAmountLocal = (BigDecimal)curRow.getCell("thisApportionAmountLocal").getValue();
            BigDecimal unApportionAmount = (BigDecimal)curRow.getCell("entry.unApportionAmount").getValue();
            if (thisApportionAmountLocal == null) {
                return;
            }
            if (thisApportionAmountLocal.signum() != unApportionAmount.signum()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ExpenseApportionResource", (String)"orientationAlert"));
                curRow.getCell("thisApportionAmountLocal").setValue((Object)unApportionAmount);
            } else if (thisApportionAmountLocal.abs().compareTo(unApportionAmount.abs()) > 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.cal.ExpenseApportionResource", (String)"apportionAmountAlert"));
                curRow.getCell("thisApportionAmountLocal").setValue((Object)unApportionAmount);
            }
        }
    }

    public void handleTableRowData(IRow row, Object[] rowData, boolean isHeadView) {
        int i;
        row.getCell("selected").setValue((Object)Boolean.FALSE);
        if (row.getCell("billType").getValue() != null) {
            row.getCell("billType").setValue((Object)OtherBillType.getEnum((int)Integer.valueOf(row.getCell("billType").getValue().toString())));
        }
        if (row.getCell("billStatus").getValue() != null) {
            row.getCell("billStatus").setValue((Object)BillStatusEnum.getEnum((int)Integer.valueOf(row.getCell("billStatus").getValue().toString())));
        }
        if (row.getCell("sourceBillType").getValue() != null) {
            row.getCell("sourceBillType").setValue((Object)VerificateBillTypeEnum.getEnum((int)Integer.valueOf(row.getCell("sourceBillType").getValue().toString())));
        }
        if (row.getCell("entry.discountType").getValue() != null) {
            row.getCell("entry.discountType").setValue((Object)DiscountModeEnum.getEnum((int)Integer.valueOf(row.getCell("entry.discountType").getValue().toString())));
        }
        int basePrecision = Integer.valueOf(row.getCell("baseCurrency.precision").getValue().toString());
        KDFormattedTextField text = new KDFormattedTextField();
        text.setDataType(1);
        text.setPrecision(basePrecision);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)text);
        row.getCell("thisApportionAmountLocal").setEditor((ICellEditor)editor);
        row.getCell("thisApportionAmountLocal").setValue(row.getCell("entry.unApportionAmount").getValue());
        String[] fields = this.getAmountFields();
        String formatString = PrecisionFormatUtils.getFormatString((int)Integer.valueOf(row.getCell("currency.precision").getValue().toString()));
        int len = fields.length;
        for (i = 0; i < len; ++i) {
            if (row.getCell(fields[i]) == null) continue;
            row.getCell(fields[i]).getStyleAttributes().setNumberFormat(formatString);
        }
        fields = this.getLocalAmountFields();
        formatString = PrecisionFormatUtils.getFormatString((int)Integer.valueOf(row.getCell("baseCurrency.precision").getValue().toString()));
        len = fields.length;
        for (i = 0; i < len; ++i) {
            if (row.getCell(fields[i]) == null) continue;
            row.getCell(fields[i]).getStyleAttributes().setNumberFormat(formatString);
        }
    }

    public List getWriteOffList(KDTable table) {
        ArrayList<WriteOffCommonInfo> list = new ArrayList<WriteOffCommonInfo>();
        WriteOffCommonInfo info = null;
        int rowCount = table.getRowCount3();
        for (int i = 0; i < rowCount; ++i) {
            if (!Boolean.TRUE.equals(table.getCell(i, "selected").getValue())) continue;
            info = new WriteOffCommonInfo();
            info.setLocalAmount((BigDecimal)table.getCell(i, "thisApportionAmountLocal").getValue());
            info.setBillId((String)table.getCell(i, "id").getValue());
            info.setEntryId((String)table.getCell(i, "entry.id").getValue());
            info.setLastUpdateTime((Date)table.getCell(i, "lastUpdateTime").getValue());
            info.setBillNumber((String)table.getCell(i, "number").getValue());
            list.add(info);
        }
        return list;
    }
}

