/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.help;

public class Topology {
    private String[] vertexs;
    private int[][] adjMat;
    private byte[][] byteAdjMat;
    private int length = 0;

    public Topology(int size, int[][] adjMat) {
        this.length = size;
        this.vertexs = new String[size];
        this.adjMat = adjMat;
    }

    public Topology(int size, byte[][] adjMat) {
        this.length = size;
        this.vertexs = new String[size];
        this.byteAdjMat = adjMat;
    }

    public void setVertexs(int index, String vertex) {
        this.vertexs[index] = vertex;
    }

    void remove(int index) {
        this.removeObject(this.vertexs, index);
        for (int[] bs : this.adjMat) {
            this.remove(bs, index);
        }
        this.removeObjectSp(this.adjMat, index);
        --this.length;
    }

    void removeByte(int index) {
        this.removeObject(this.vertexs, index);
        for (byte[] bs : this.byteAdjMat) {
            this.removeByte(bs, index);
        }
        this.removeObjectSpByte(this.byteAdjMat, index);
        --this.length;
    }

    private void removeObject(Object[] a, int index) {
        for (int i = index; i < this.length - 1; ++i) {
            a[i] = a[i + 1];
        }
    }

    private void removeObjectSp(int[][] adjMat2, int index) {
        for (int i = index; i < this.length - 1; ++i) {
            for (int j = 0; j < adjMat2[i].length; ++j) {
                adjMat2[i][j] = adjMat2[i + 1][j];
            }
        }
    }

    private void removeObjectSpByte(byte[][] adjMat2, int index) {
        for (int i = index; i < this.length - 1; ++i) {
            for (int j = 0; j < adjMat2[i].length; ++j) {
                adjMat2[i][j] = adjMat2[i + 1][j];
            }
        }
    }

    private void remove(int[] a, int index) {
        for (int i = index; i < this.length - 1; ++i) {
            a[i] = a[i + 1];
        }
    }

    private void removeByte(byte[] a, int index) {
        for (int i = index; i < this.length - 1; ++i) {
            a[i] = a[i + 1];
        }
    }

    int noNext() {
        int result = -1;
        block0: for (int i = 0; i < this.length; ++i) {
            for (int j = 0; j < this.length; ++j) {
                if (this.adjMat[i][j] == 1) continue block0;
            }
            return i;
        }
        return -1;
    }

    int noNextByte() {
        int result = -1;
        block0: for (int i = 0; i < this.length; ++i) {
            for (int j = 0; j < this.length; ++j) {
                if (this.byteAdjMat[i][j] == 1) continue block0;
            }
            return i;
        }
        return -1;
    }

    public Object[] topo() {
        Object[] result = new Object[this.length];
        int pos = this.length;
        while (this.length > 0) {
            int index = this.noNext();
            assert (index != -1) : "\u56fe\u4e2d\u5b58\u5728\u73af";
            result[--pos] = this.vertexs[index];
            this.remove(index);
        }
        return result;
    }

    public Object[] topoByte() {
        Object[] result = new Object[this.length];
        int pos = this.length;
        while (this.length > 0) {
            int index = this.noNextByte();
            assert (index != -1) : "\u56fe\u4e2d\u5b58\u5728\u73af";
            result[--pos] = this.vertexs[index];
            this.removeByte(index);
        }
        return result;
    }
}

