/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.invdep.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.util.UuidException;
import java.sql.Connection;
import java.util.Collection;
import org.apache.log4j.Logger;

public class DepChargeServerHelper {
    private static final Logger logger = Logger.getLogger((String)"");

    public static final String createTempTable(Context ctx, Connection con, String nameKey, String fieldsDefine) throws BOSException, EASBizException {
        return DepChargeServerHelper.createTempTable(ctx, fieldsDefine);
    }

    public static String toSqlString(Collection idList) {
        int size = DepChargeServerHelper.getValidSize(idList);
        StringBuffer ids = new StringBuffer(size * 48);
        int i = 0;
        for (Object id : idList) {
            ids.append("'").append(id.toString());
            ids.append(i + 1 < size ? "', " : "' ");
            ++i;
        }
        return ids.toString();
    }

    private static int getValidSize(Collection idList) {
        int limit = 1024;
        int n = idList.size();
        if (n > limit) {
            logger.warn((Object)("the idListSize " + n + " greater than limit: " + limit));
            n = limit;
        }
        return n;
    }

    public static String ids2SqlString(Collection idList) throws CalculateException {
        StringBuffer ids = new StringBuffer();
        int size = DepChargeServerHelper.getValidSize(idList);
        int i = 0;
        for (Object id : idList) {
            try {
                ids.append("'").append(BOSUuid.read((String)id.toString()));
                ids.append(i + 1 < size ? "', " : "' ");
            }
            catch (UuidException e) {
                logger.error((Object)("invalid id: " + id), (Throwable)e);
                throw new CalculateException(CalculateException.INVALIDID);
            }
            ++i;
        }
        return ids.toString();
    }

    public static String createTempTable(Context ctx, String tblDefine) throws BOSException {
        String tblName = null;
        TempTablePool tmpTblPool = TempTablePool.getInstance((Context)ctx);
        try {
            tblName = tmpTblPool.createTempTable("CREATE TABLE TEML_KSQL_0 " + tblDefine);
        }
        catch (Exception e) {
            throw new BOSException("cannot create tempTable", (Throwable)e);
        }
        return tblName;
    }
}

