/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.newutil;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.scm.cal.newutil.CalculateUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DBUtil
extends DbUtil {
    private static final int MAX_STATMENT = 200;

    public static Object takeValue(Context ctx, String sql) throws BOSException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            Object object = DBUtil.takeValue(conn, sql);
            return object;
        }
        catch (SQLException ex) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean takeValue(Context ctx, String[] sql) throws BOSException {
        block8: {
            block7: {
                conn = null;
                stmt = null;
                rs = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    stmt = conn.createStatement();
                    i = 0;
                    len = sql.length;
lbl9:
                    // 2 sources

                    while (i < len) {
                        rs = stmt.executeQuery(sql[i]);
                        if (rs != null && rs.next()) {
                            var7_8 = rs.getObject(1) != null;
                            break block7;
                        }
                        ** GOTO lbl-1000
                    }
                    break block8;
                }
                catch (SQLException ex) {
                    try {
                        throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
                    }
                    catch (Throwable var8_9) {
                        SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
                        throw var8_9;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return var7_8;
lbl-1000:
            // 1 sources

            {
                ++i;
                ** GOTO lbl9
            }
        }
        SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
        return false;
    }

    public static Object takeValue(Connection conn, String sql) throws BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        block4: {
            Object object;
            stmt = null;
            rs = null;
            try {
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs == null || !rs.next()) break block4;
                object = rs.getObject(1);
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return object;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return null;
    }

    public static void dropTempTable(Context ctx, String tempTableName) throws BOSException, EASBizException {
        if (!StringUtil.isEmpty((String)tempTableName)) {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTemporaryTableName(tempTableName);
        }
    }

    public static void releaseTempTable(Context ctx, String ... tempTableNames) throws BOSException, EASBizException {
        TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
        for (String tempTableName : tempTableNames) {
            if (StringUtil.isEmpty((String)tempTableName)) continue;
            tmpPool.releaseTable(tempTableName);
        }
    }

    public static String createTempTable(Context ctx, String sql) throws BOSException {
        TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
        try {
            return tmpPool.createTempTable(sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String createTempTable(Context ctx, String[][] tableFields) throws BOSException {
        String tempTableName = "tempTableName";
        String sqlcreatetable = CalculateUtil.transCreateTable(ctx, CalculateUtil.getCreateTableSQl(tempTableName, tableFields).toString());
        try {
            TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
            tempTableName = tmpPool.createTempTable(sqlcreatetable);
            return tempTableName;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void close(Connection conn, PreparedStatement[] pm, ResultSet[] rs) throws BOSException {
        try {
            int i;
            int n;
            if (rs != null) {
                n = rs.length;
                for (i = 0; i < n; ++i) {
                    if (null == rs[i]) continue;
                    rs[i].close();
                }
            }
            if (pm != null) {
                n = pm.length;
                for (i = 0; i < n; ++i) {
                    if (null == pm[i]) continue;
                    pm[i].close();
                }
            }
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void close(Connection conn, Statement stm) throws BOSException {
        try {
            if (null != stm) {
                stm.close();
            }
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void execBatchSql(Context ctx, ArrayList sqlList, boolean isUpdateBill) throws BOSException {
        if (isUpdateBill || sqlList.size() >= 200) {
            DBUtil.execute(ctx, sqlList.toArray(new String[sqlList.size()]));
            sqlList.clear();
        }
    }

    public static void execBatchSql(Connection conn, ArrayList sqlList, boolean isUpdateBill) throws BOSException, SQLException {
        if (isUpdateBill || sqlList.size() >= 200) {
            DBUtil.execute(conn, sqlList.toArray(new String[sqlList.size()]));
            sqlList.clear();
        }
    }

    public static void execute(Context ctx, String[] sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            DBUtil.execute(statement, sql);
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqlstr, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    public static void execute(Connection conn, String[] sql) throws BOSException, SQLException {
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer(64);
        try {
            statement = conn.createStatement();
            DBUtil.execute(statement, sql);
        }
        catch (SQLException e) {
            throw new SQLException(ResourceUtil.getMessage((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"279_SQLEr", (String[])new String[]{e.toString(), sqlstr.toString()}));
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
        }
    }

    private static void execute(Statement statement, String[] sql) throws SQLException {
        StringBuffer sqlstr = new StringBuffer(64);
        if (!ArrayUtil.isEmpty((Object[])sql)) {
            int n = sql.length;
            for (int i = 0; i < n; ++i) {
                statement.addBatch(sql[i]);
                sqlstr.append(sql[i]).append("\t\n");
            }
            statement.executeBatch();
        }
    }

    public static void execute(Connection conn, String sql) throws BOSException, SQLException {
        try (Statement statement = null;){
            statement = conn.createStatement();
            statement.execute(sql);
        }
    }

    public static void createTempTableIndex(Context ctx, String tableName, String columns, boolean isUnique) throws BOSException {
        DBUtil.createTempTableIndex(ctx, tableName, columns, isUnique, false);
    }

    public static void createTempTableIndex(Context ctx, String tableName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        try {
            TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
            tmpPool.createIndex(tableName, columns, isUnique, isClustered);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void analyseTable(Context ctx, Connection con, String table) throws SQLException {
        TempTablePool.getInstance((Context)ctx).analyzeTable(con, table);
    }
}

