/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app;

import com.kingdee.eas.scm.cal.PriceSourEnum;
import com.kingdee.eas.scm.cal.onekey.OneKeyBillCostInfo;
import com.kingdee.eas.scm.cal.onekey.app.help.OneKeyCalculateHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class MatAttrChangeVO {
    private String sourceEntryID = null;
    private List inBillList = null;
    private List outBillList = null;

    public MatAttrChangeVO(String sourceEntryID) {
        this.sourceEntryID = sourceEntryID;
        this.inBillList = new ArrayList();
        this.outBillList = new ArrayList();
    }

    public void addInBill(OneKeyBillCostInfo inBill) {
        if (this.inBillList.indexOf(inBill) < 0) {
            this.inBillList.add(inBill);
        }
    }

    public void removeInBill(OneKeyBillCostInfo inBill) {
        this.inBillList.remove(inBill);
    }

    public void addOutBill(OneKeyBillCostInfo outBill) {
        if (this.outBillList.indexOf(outBill) < 0) {
            this.outBillList.add(outBill);
        }
    }

    public void removeOutBill(OneKeyBillCostInfo outBill) {
        this.outBillList.remove(outBill);
    }

    public void clearInBillList() {
        this.inBillList.clear();
    }

    public void clearOutBillList() {
        this.outBillList.clear();
    }

    public String getSourceEntryID() {
        return this.sourceEntryID;
    }

    public List getInBillList() {
        return this.inBillList;
    }

    public List getOutBillList() {
        return this.outBillList;
    }

    public int getOutBillCount() {
        return this.outBillList.size();
    }

    public int getInBillCount() {
        return this.inBillList.size();
    }

    public OneKeyBillCostInfo getOutBill(int i) {
        return (OneKeyBillCostInfo)this.outBillList.get(i);
    }

    public OneKeyBillCostInfo getInBill(int i) {
        return (OneKeyBillCostInfo)this.inBillList.get(i);
    }

    public void calculateCost() {
        BigDecimal totalCost = this.getTotalOutCost();
        BigDecimal totalQty = this.getTotalInQty();
        BigDecimal dealCost = new BigDecimal("0");
        BigDecimal recentCost = new BigDecimal("0");
        for (int i = 0; i < this.inBillList.size(); ++i) {
            OneKeyBillCostInfo bill = (OneKeyBillCostInfo)this.inBillList.get(i);
            recentCost = totalCost.multiply(bill.getRecentQty().divide(totalQty, 8, 4)).setScale(bill.getBaseCurrencyPrecision(), 4);
            if (i == this.inBillList.size() - 1) {
                recentCost = totalCost.subtract(dealCost);
            }
            if (!bill.isDealComplete()) {
                bill.setRecentCost(recentCost);
                OneKeyCalculateHelper.calculateAvgPrice(bill);
                bill.setPriceSource(PriceSourEnum.matChangeOut);
                bill.setNeedUpdate(true);
            }
            dealCost = dealCost.add(bill.getRecentCost());
        }
    }

    private BigDecimal getTotalOutCost() {
        BigDecimal result = new BigDecimal("0.00");
        for (int i = 0; i < this.outBillList.size(); ++i) {
            OneKeyBillCostInfo bill = (OneKeyBillCostInfo)this.outBillList.get(i);
            result = result.add(bill.getRecentCost());
        }
        return result;
    }

    private BigDecimal getTotalInQty() {
        BigDecimal result = new BigDecimal("0.00");
        for (int i = 0; i < this.inBillList.size(); ++i) {
            OneKeyBillCostInfo bill = (OneKeyBillCostInfo)this.inBillList.get(i);
            result = result.add(bill.getRecentQty());
        }
        return result;
    }
}

