/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.CostCalculateFacadeFactory;
import com.kingdee.eas.scm.cal.CostComputeRportHeaderFactory;
import com.kingdee.eas.scm.cal.CostComputeRportHeaderInfo;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.cal.ICostCalculateFacade;
import com.kingdee.eas.scm.cal.IDevolveCostCalculateFacade;
import com.kingdee.eas.scm.cal.IMatAssembleCalculateFacade;
import com.kingdee.eas.scm.cal.IMatChangeCalculateFacade;
import com.kingdee.eas.scm.cal.MaterialCalTypeEnum;
import com.kingdee.eas.scm.cal.help.CalcCycleTransNormal;
import com.kingdee.eas.scm.cal.help.Topology;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.cal.onekey.CalculateUnitInfo;
import com.kingdee.eas.scm.cal.onekey.IOneKeyCalculateProcess;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessEntryCollection;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessFactory;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessInfo;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateReportFactory;
import com.kingdee.eas.scm.cal.onekey.app.AbstractOneKeyCalculateFacadeControllerBean;
import com.kingdee.eas.scm.cal.onekey.app.OneKeyCalculateParams;
import com.kingdee.eas.scm.cal.onekey.app.calculateimp.OneKeyAvgAndSpecialCalculate;
import com.kingdee.eas.scm.cal.onekey.app.calculateimp.OneKeyCalcInCalculate;
import com.kingdee.eas.scm.cal.onekey.app.calculateimp.OneKeyFIFOCalculate;
import com.kingdee.eas.scm.cal.onekey.app.calculateimp.OneKeyMovingAverageCalaulte;
import com.kingdee.eas.scm.cal.onekey.app.help.OneKeyCalculateProcessHelper;
import com.kingdee.eas.scm.cal.onekey.multipleJob.ThreadLocalHelper;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.framework.balance.util.BalanceUtil;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class OneKeyCalculateFacadeControllerBean
extends AbstractOneKeyCalculateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.onekey.app.OneKeyCalculateFacadeControllerBean");
    private Map md5KeyMap = new HashMap();
    IMatAssembleCalculateFacade iMatAssembleCalculateFacade;
    IMatChangeCalculateFacade iMatChangeCalculateFacade;
    IDevolveCostCalculateFacade iDevolveCostCalculateFacade;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void reCalcMaterialRelationStructure(Context ctx, HashMap param) throws BOSException, EASBizException {
        HashSet<String> matIdSet;
        StringBuffer sql;
        String calType;
        PeriodInfo currentPeriodInfo;
        CompanyOrgUnitInfo cou;
        String companyId;
        Connection conn;
        PreparedStatement costMoveStmt;
        ResultSet costMoveRs;
        PreparedStatement devStmt;
        ResultSet devRs;
        PreparedStatement inOutStmt;
        ResultSet inOutRs;
        block14: {
            inOutRs = null;
            inOutStmt = null;
            devRs = null;
            devStmt = null;
            costMoveRs = null;
            costMoveStmt = null;
            conn = null;
            conn = EJBFactory.getConnection((Context)ctx);
            companyId = (String)param.get("companyId");
            cou = new CompanyOrgUnitInfo();
            cou.setId(BOSUuid.read((String)companyId));
            currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            int year = currentPeriodInfo.getPeriodYear();
            int period = currentPeriodInfo.getPeriodNumber();
            Date beginDate = currentPeriodInfo.getBeginDate();
            Timestamp endDate = currentPeriodInfo.getEndDate();
            IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
            calType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_002");
            sql = new StringBuffer();
            String getBillSql = this.getInOutData();
            inOutStmt = conn.prepareStatement(getBillSql, 1004, 1007);
            inOutStmt.setFetchSize(1000);
            inOutStmt.setObject(1, beginDate);
            inOutStmt.setObject(2, companyId);
            inOutStmt.setObject(3, endDate);
            inOutStmt.setObject(4, beginDate);
            inOutStmt.setObject(5, endDate);
            inOutRs = inOutStmt.executeQuery();
            getBillSql = this.getDevData(ctx, companyId, year, period, beginDate, endDate);
            devStmt = conn.prepareStatement(getBillSql, 1004, 1007);
            devStmt.setFetchSize(1000);
            devRs = devStmt.executeQuery();
            String billTypeId = null;
            if ("1".equals(calType)) {
                billTypeId = "d8e80652-011a-1000-e000-04c5c0a812202407435C";
            } else if ("2".equals(calType)) {
                billTypeId = "d8e80652-011b-1000-e000-04c5c0a812202407435C";
            }
            if (billTypeId != null) {
                getBillSql = this.getCostMoveData();
                costMoveStmt = conn.prepareStatement(getBillSql, 1004, 1007);
                costMoveStmt.setFetchSize(1000);
                costMoveStmt.setObject(1, beginDate);
                costMoveStmt.setObject(2, endDate);
                costMoveStmt.setObject(3, companyId);
                costMoveStmt.setObject(4, billTypeId);
                costMoveRs = costMoveStmt.executeQuery();
            }
            matIdSet = new HashSet<String>();
            this.buildInOutIdSet(inOutRs, matIdSet);
            this.buildInOutIdSet(devRs, matIdSet);
            this.buildInOutIdSet(costMoveRs, matIdSet);
            if (matIdSet.size() != 0) break block14;
            SQLUtils.cleanup((ResultSet)inOutRs, (Statement)inOutStmt);
            SQLUtils.cleanup((ResultSet)devRs, (Statement)devStmt);
            SQLUtils.cleanup(costMoveRs, (Statement)costMoveStmt, (Connection)conn);
            return;
        }
        try {
            Map matComMap = this.getMaterialCompanyCalcInfo(ctx, cou.getId().toString(), matIdSet);
            sql.setLength(0);
            String insertSql = "insert into t_cl_materialRelationStructure(fid,FCompanyOrgUnitId,FPeriodId,FMaterialFrom,FMaterialTo,FKeyFrom,FKeyTo) values(newbosid('D1F79EED'),?,?,?,?,?,?)";
            String deleteSql = "delete t_cl_materialRelationStructure where FPeriodId = '" + currentPeriodInfo.getId().toString() + "' and FCompanyOrgUnitId = '" + cou.getId().toString() + "'";
            HashSet<String> keySet = new HashSet<String>();
            StringBuffer unionKey = new StringBuffer();
            if (inOutRs != null) {
                inOutRs.beforeFirst();
                this.buildKeyCount(ctx, companyId, calType, inOutRs, matComMap, keySet, unionKey);
            }
            if (costMoveRs != null) {
                costMoveRs.beforeFirst();
                this.buildKeyCount(ctx, companyId, calType, costMoveRs, matComMap, keySet, unionKey);
            }
            if (devRs != null) {
                devRs.beforeFirst();
                this.buildKeyCount(ctx, companyId, calType, devRs, matComMap, keySet, unionKey);
            }
            ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                Object[] insertParam = new Object[6];
                String entry = (String)iterator.next();
                String[] unionKeys = entry.split(";");
                insertParam[0] = companyId;
                insertParam[1] = currentPeriodInfo.getId().toString();
                insertParam[2] = unionKeys[0];
                insertParam[3] = unionKeys[1];
                insertParam[4] = unionKeys[2];
                insertParam[5] = unionKeys[3];
                insertParams.add(insertParam);
            }
            DbUtil.execute((Context)ctx, (String)deleteSql);
            DbUtil.executeBatch((Context)ctx, (String)insertSql, insertParams);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (NoSuchAlgorithmException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(inOutRs, inOutStmt);
                SQLUtils.cleanup(devRs, devStmt);
                SQLUtils.cleanup(costMoveRs, costMoveStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)inOutRs, (Statement)inOutStmt);
        SQLUtils.cleanup((ResultSet)devRs, (Statement)devStmt);
        SQLUtils.cleanup((ResultSet)costMoveRs, (Statement)costMoveStmt, (Connection)conn);
        return;
    }

    private void buildKeyCount(Context ctx, String companyId, String calType, ResultSet rowSet, Map matComMap, Set<String> keySet, StringBuffer unionKey) throws SQLException, NoSuchAlgorithmException, BOSException {
        while (rowSet.next()) {
            unionKey.setLength(0);
            String inMd5Key = this.getMd5CalKey(ctx, calType, rowSet.getString("inFMATERIALID"), companyId, rowSet.getString("inFSTORAGEORGUNITID"), rowSet.getString("inFWAREHOUSEID"), rowSet.getString("inFLOT"), rowSet.getString("inFASSISTPROPERTYID"), rowSet.getString("inFPROJECTID"), rowSet.getString("inFTRACKNUMBERID"), matComMap);
            String outMd5Key = this.getMd5CalKey(ctx, calType, rowSet.getString("outFMATERIALID"), companyId, rowSet.getString("outFSTORAGEORGUNITID"), rowSet.getString("outFWAREHOUSEID"), rowSet.getString("outFLOT"), rowSet.getString("outFASSISTPROPERTYID"), rowSet.getString("outFPROJECTID"), rowSet.getString("outFTRACKNUMBERID"), matComMap);
            unionKey.append(rowSet.getString("outFMATERIALID")).append(";").append(rowSet.getString("inFMATERIALID")).append(";");
            unionKey.append(outMd5Key).append(";").append(inMd5Key);
            keySet.add(unionKey.toString());
        }
    }

    public String convertIdSet2String(Set<String> idSet) {
        StringBuffer ids = new StringBuffer();
        ids.append("(");
        for (String s : idSet) {
            ids.append("'").append(s).append("',");
        }
        ids.setLength(ids.length() - 1);
        ids.append(")");
        return ids.toString();
    }

    private String getMd5CalKey(Context ctx, String calType, String materialId, String couId, String souId, String warehouseId, String lot, String assistPropertyId, String projectId, String trackNumberId, Map matComMap) throws NoSuchAlgorithmException {
        String md5Key;
        String[] param = new String[8];
        StringBuffer calKey = new StringBuffer();
        if ("0".equals(calType)) {
            calKey.append(couId);
            param[1] = couId;
        } else if ("1".equals(calType)) {
            calKey.append(couId).append(souId);
            param[1] = couId;
            param[2] = souId;
        } else if ("2".equals(calType)) {
            calKey.append(couId).append(souId).append(warehouseId);
            param[1] = couId;
            param[2] = souId;
            param[3] = warehouseId;
        }
        if (matComMap.get(materialId) != null) {
            HashMap specialCalKeyMap = (HashMap)matComMap.get(materialId);
            if (Integer.parseInt(specialCalKeyMap.get("FISLOT").toString()) == 1) {
                calKey.append(lot);
                param[4] = lot;
            }
            if (Integer.parseInt(specialCalKeyMap.get("FISASSISTPROPERTY").toString()) == 1) {
                calKey.append(assistPropertyId);
                param[5] = assistPropertyId;
            }
            if (Integer.parseInt(specialCalKeyMap.get("FISPROJECT").toString()) == 1) {
                calKey.append(projectId);
                param[6] = projectId;
            }
            if (Integer.parseInt(specialCalKeyMap.get("FISTRACKNUMBER").toString()) == 1) {
                calKey.append(trackNumberId);
                param[7] = trackNumberId;
            }
        }
        param[0] = md5Key = BalanceUtil.getMd5((String)calKey.toString());
        this.md5KeyMap.put(md5Key, param);
        return md5Key;
    }

    protected void calcRank(Context ctx, HashMap param) throws BOSException, EASBizException {
        String companyId = (String)param.get("companyId");
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyId));
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        String periodId = currentPeriodInfo.getId().toString();
        DBUtil.execute((Context)ctx, (String)("delete T_CL_MATERIALCALCRANK where FCompanyOrgUnitId = '" + companyId + "' and FPeriodId = '" + periodId + "'"));
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FMATERIALFROM,FKEYFROM,FMATERIALTO,FKEYTO,FGROUPKEY FROM t_cl_materialRelationStructure ");
        sql.append("WHERE FCOMPANYORGUNITID = '").append(companyId).append("' ");
        sql.append("AND FPERIODID = '").append(periodId).append("' ");
        sql.append("ORDER BY FGROUPKEY,FBIZDATE,FAUDITTIME");
        HashMap<String, Integer> fromToMap = new HashMap<String, Integer>();
        HashMap<Integer, String> fromToMapOpposite = new HashMap<Integer, String>();
        HashMap<String, Integer> fromToSerialMap = new HashMap<String, Integer>();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        int keyCount = 1;
        int serial = 1;
        String fromDot = null;
        String toDot = null;
        String fromToDot = null;
        String groupKey = null;
        try {
            while (rs.next()) {
                if (groupKey != null && !groupKey.equals(rs.getString("FGROUPKEY"))) {
                    this.calcCurrGroupRank(ctx, keyCount, fromToSerialMap, fromToMap, fromToMapOpposite, companyId, periodId, groupKey);
                    keyCount = 1;
                    serial = 1;
                    fromToSerialMap = new HashMap();
                    fromToMap = new HashMap();
                    fromToMapOpposite = new HashMap();
                }
                groupKey = rs.getString("FGROUPKEY");
                fromDot = rs.getString("FMATERIALFROM") + ";" + rs.getString("FKEYFROM");
                toDot = rs.getString("FMATERIALTO") + ";" + rs.getString("FKEYTO");
                if (!fromToMap.containsKey(fromDot)) {
                    fromToMap.put(fromDot, keyCount);
                    fromToMapOpposite.put(keyCount, fromDot);
                    ++keyCount;
                }
                if (!fromToMap.containsKey(toDot)) {
                    fromToMap.put(toDot, keyCount);
                    fromToMapOpposite.put(keyCount, toDot);
                    ++keyCount;
                }
                fromToDot = fromDot + "_" + toDot;
                fromToSerialMap.put(fromToDot, serial);
                ++serial;
            }
            this.calcCurrGroupRank(ctx, keyCount, fromToSerialMap, fromToMap, fromToMapOpposite, companyId, periodId, groupKey);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void calcCurrGroupRank(Context ctx, int keyCount, Map fromToSerialMap, Map fromToMap, Map fromToMapOpposite, String couId, String periodId, String groupKey) throws BOSException {
        byte[][] fromToArray = new byte[keyCount][keyCount];
        int[][] fromToSerialArray = new int[keyCount][keyCount];
        int rowindex = 0;
        int colindex = 0;
        String[] temp = null;
        Set keySet = fromToSerialMap.keySet();
        String fromDot = null;
        String toDot = null;
        String fromToDot2 = null;
        for (String fromToDot2 : keySet) {
            temp = fromToDot2.split("_");
            fromDot = temp[0];
            toDot = temp[1];
            rowindex = (Integer)fromToMap.get(fromDot);
            colindex = (Integer)fromToMap.get(toDot);
            fromToArray[rowindex][colindex] = 1;
            fromToSerialArray[rowindex][colindex] = (Integer)fromToSerialMap.get(fromToDot2);
        }
        CalcCycleTransNormal calcCycleTrans = new CalcCycleTransNormal();
        fromToArray = calcCycleTrans.breakCycle(fromToArray, fromToSerialArray);
        boolean hasCycle = calcCycleTrans.isHasCycle();
        int fHasCycle = hasCycle ? 1 : 0;
        Topology topology = new Topology(keyCount, fromToArray);
        String outOrInID2 = null;
        keySet = fromToMap.keySet();
        for (String outOrInID2 : keySet) {
            rowindex = (Integer)fromToMap.get(outOrInID2);
            topology.setVertexs(rowindex, outOrInID2);
        }
        Object[] result = topology.topoByte();
        String insertSql = "insert into T_CL_MATERIALCALCRANK(fid,FCompanyOrgUnitId,FPeriodId,FGroupKey,FMaterialId,FCalculateKey,FRank,fHasCycle) values(newbosid('F99C1DF4'),?,?,?,?,?,?,?)";
        ArrayList<Object[]> insertParamList = new ArrayList<Object[]>();
        int n = result.length;
        for (int j = 0; j < n; ++j) {
            if (result[j] == null) continue;
            String[] matKey = result[j].toString().split(";");
            Object[] param = new Object[]{couId, periodId, groupKey, matKey[0], matKey[1], j + 1, fHasCycle};
            insertParamList.add(param);
        }
        DBUtil.executeBatch((Context)ctx, (String)insertSql, insertParamList);
    }

    protected void calcGroupKey(Context ctx, HashMap param) throws BOSException, EASBizException {
        String companyId = (String)param.get("companyId");
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyId));
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        try {
            HashSet currIdSet;
            StringBuffer sql = new StringBuffer();
            sql.append("select fid,FMaterialFrom,FKeyFrom,FMaterialTo,FKeyTo from t_cl_materialRelationStructure ");
            sql.append("where FCompanyOrgUnitId = ? ");
            sql.append("and FPeriodId = ?");
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, currentPeriodInfo.getId().toString()});
            LinkedHashMap groupKey2KeySet = new LinkedHashMap();
            LinkedHashMap groupKey2IdSet = new LinkedHashMap();
            String groupKey = null;
            String findGroupKey = null;
            while (rs.next()) {
                String fromKey = rs.getString("FMaterialFrom") + ";" + rs.getString("FKeyFrom");
                String toKey = rs.getString("FMaterialTo") + ";" + rs.getString("FKeyTo");
                Iterator iterator = groupKey2KeySet.keySet().iterator();
                HashSet<String> removeKey = new HashSet<String>();
                while (iterator.hasNext()) {
                    String currGroupKey = (String)iterator.next();
                    HashSet currKeySet = (HashSet)groupKey2KeySet.get(currGroupKey);
                    currIdSet = (HashSet)groupKey2IdSet.get(currGroupKey);
                    if (!currKeySet.contains(fromKey) && !currKeySet.contains(toKey)) continue;
                    currKeySet.add(fromKey);
                    currKeySet.add(toKey);
                    currIdSet.add(rs.getString("fid"));
                    if (findGroupKey == null) {
                        findGroupKey = currGroupKey;
                        continue;
                    }
                    HashSet preKeySet = (HashSet)groupKey2KeySet.get(findGroupKey);
                    HashSet preIdSet = (HashSet)groupKey2IdSet.get(findGroupKey);
                    currKeySet.addAll(preKeySet);
                    currIdSet.addAll(preIdSet);
                    removeKey.add(findGroupKey);
                    break;
                }
                for (String s : removeKey) {
                    groupKey2KeySet.remove(s);
                    groupKey2IdSet.remove(s);
                }
                if (findGroupKey == null) {
                    HashSet<String> keySet = new HashSet<String>();
                    keySet.add(fromKey);
                    keySet.add(toKey);
                    HashSet<String> idSet = new HashSet<String>();
                    idSet.add(rs.getString("fid"));
                    groupKey = UUID.randomUUID().toString();
                    groupKey2KeySet.put(groupKey, keySet);
                    groupKey2IdSet.put(groupKey, idSet);
                }
                findGroupKey = null;
            }
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
            Iterator iterator = groupKey2IdSet.entrySet().iterator();
            int group = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                currIdSet = (HashSet)entry.getValue();
                ++group;
                for (String s : currIdSet) {
                    Object[] updateParam = new Object[]{group, s};
                    updateParamList.add(updateParam);
                }
            }
            if (updateParamList.size() > 0) {
                DBUtil.executeBatch((Context)ctx, (String)"update t_cl_materialRelationStructure set FGroupKey = ? where fid = ?", updateParamList);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void calcFirstBizTime(Context ctx, HashMap param) throws BOSException, EASBizException {
        HashSet<String> matIdSet;
        ResultSet costMoveRs;
        PreparedStatement costMoveStmt;
        ResultSet devRs;
        PreparedStatement devStmt;
        ResultSet inOutRs;
        PreparedStatement inOutStmt;
        Connection conn;
        String calType;
        PeriodInfo currentPeriodInfo;
        CompanyOrgUnitInfo cou;
        String companyId;
        block13: {
            companyId = (String)param.get("companyId");
            cou = new CompanyOrgUnitInfo();
            cou.setId(BOSUuid.read((String)companyId));
            currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
            Date beginDate = currentPeriodInfo.getBeginDate();
            Timestamp endDate = currentPeriodInfo.getEndDate();
            IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
            calType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_002");
            conn = null;
            inOutStmt = null;
            inOutRs = null;
            devStmt = null;
            devRs = null;
            costMoveStmt = null;
            costMoveRs = null;
            conn = EJBFactory.getConnection((Context)ctx);
            String getBillSql = this.getInOutData();
            inOutStmt = conn.prepareStatement(getBillSql, 1004, 1007);
            inOutStmt.setFetchSize(1000);
            inOutStmt.setObject(1, beginDate);
            inOutStmt.setObject(2, companyId);
            inOutStmt.setObject(3, endDate);
            inOutStmt.setObject(4, beginDate);
            inOutStmt.setObject(5, endDate);
            inOutRs = inOutStmt.executeQuery();
            getBillSql = this.getDevData(ctx, companyId, currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber(), beginDate, endDate);
            devStmt = conn.prepareStatement(getBillSql, 1004, 1007);
            devStmt.setFetchSize(1000);
            devRs = devStmt.executeQuery();
            String billTypeId = null;
            if ("1".equals(calType)) {
                billTypeId = "d8e80652-011a-1000-e000-04c5c0a812202407435C";
            } else if ("2".equals(calType)) {
                billTypeId = "d8e80652-011b-1000-e000-04c5c0a812202407435C";
            }
            if (billTypeId != null) {
                getBillSql = this.getCostMoveData();
                costMoveStmt = conn.prepareStatement(getBillSql, 1004, 1007);
                costMoveStmt.setFetchSize(1000);
                costMoveStmt.setObject(1, beginDate);
                costMoveStmt.setObject(2, endDate);
                costMoveStmt.setObject(3, companyId);
                costMoveStmt.setObject(4, billTypeId);
                costMoveRs = costMoveStmt.executeQuery();
            }
            matIdSet = new HashSet<String>();
            this.buildInOutIdSet(inOutRs, matIdSet);
            this.buildInOutIdSet(devRs, matIdSet);
            this.buildInOutIdSet(costMoveRs, matIdSet);
            if (matIdSet.size() != 0) break block13;
            SQLUtils.cleanup((ResultSet)inOutRs, (Statement)inOutStmt);
            SQLUtils.cleanup((ResultSet)devRs, (Statement)devStmt);
            SQLUtils.cleanup(costMoveRs, (Statement)costMoveStmt, (Connection)conn);
            return;
        }
        try {
            Map matComMap = this.getMaterialCompanyCalcInfo(ctx, cou.getId().toString(), matIdSet);
            HashMap firstBizMap = new HashMap();
            if (inOutRs != null) {
                inOutRs.beforeFirst();
                this.buildFirstBizTime(ctx, companyId, calType, inOutRs, matComMap, firstBizMap);
            }
            if (costMoveRs != null) {
                costMoveRs.beforeFirst();
                this.buildFirstBizTime(ctx, companyId, calType, costMoveRs, matComMap, firstBizMap);
            }
            if (devRs != null) {
                devRs.beforeFirst();
                this.buildFirstBizTime(ctx, companyId, calType, devRs, matComMap, firstBizMap);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT FID,FMATERIALFROM,FKEYFROM,FMATERIALTO,FKEYTO FROM t_cl_materialRelationStructure");
            sql.append(" where FCOMPANYORGUNITID = ? and FPERIODID = ?");
            IRowSet matRelationRs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, currentPeriodInfo.getId().toString()});
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
            while (matRelationRs.next()) {
                String fromToKey = matRelationRs.getString("FMATERIALFROM") + matRelationRs.getString("FKEYFROM") + matRelationRs.getString("FMATERIALTO") + matRelationRs.getString("FKEYTO");
                if (!firstBizMap.containsKey(fromToKey)) continue;
                Object[] firstBizDate = (Object[])firstBizMap.get(fromToKey);
                Object[] updateParam = new Object[]{firstBizDate[0], firstBizDate[1], firstBizDate[2], matRelationRs.getString("fid")};
                updateParamList.add(updateParam);
            }
            String updateSql = "update t_cl_materialRelationStructure set FBIZDATE = ?, FAUDITTIME = ?, FBILLID = ? where fid = ?";
            DBUtil.executeBatch((Context)ctx, (String)updateSql, updateParamList);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(inOutRs, inOutStmt);
                SQLUtils.cleanup(devRs, devStmt);
                SQLUtils.cleanup(costMoveRs, costMoveStmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)inOutRs, (Statement)inOutStmt);
        SQLUtils.cleanup((ResultSet)devRs, (Statement)devStmt);
        SQLUtils.cleanup((ResultSet)costMoveRs, (Statement)costMoveStmt, (Connection)conn);
    }

    private void buildInOutIdSet(ResultSet inOutRs, Set<String> matIdSet) throws SQLException {
        if (inOutRs == null) {
            return;
        }
        while (inOutRs.next()) {
            matIdSet.add(inOutRs.getString("inFMATERIALID"));
            matIdSet.add(inOutRs.getString("outFMATERIALID"));
        }
    }

    private void buildFirstBizTime(Context ctx, String companyId, String calType, ResultSet rowSet, Map matComMap, Map firstBizMap) throws SQLException, NoSuchAlgorithmException, BOSException {
        while (rowSet.next()) {
            Object[] firstBizDate;
            String fromKey = this.getMd5CalKey(ctx, calType, rowSet.getString("outFMATERIALID"), companyId, rowSet.getString("outFSTORAGEORGUNITID"), rowSet.getString("outFWAREHOUSEID"), rowSet.getString("outFLOT"), rowSet.getString("outFASSISTPROPERTYID"), rowSet.getString("outFPROJECTID"), rowSet.getString("outFTRACKNUMBERID"), matComMap);
            String toKey = this.getMd5CalKey(ctx, calType, rowSet.getString("inFMATERIALID"), companyId, rowSet.getString("inFSTORAGEORGUNITID"), rowSet.getString("inFWAREHOUSEID"), rowSet.getString("inFLOT"), rowSet.getString("inFASSISTPROPERTYID"), rowSet.getString("inFPROJECTID"), rowSet.getString("inFTRACKNUMBERID"), matComMap);
            String fromToKey = rowSet.getString("outFMATERIALID") + fromKey + rowSet.getString("inFMATERIALID") + toKey;
            if (firstBizMap.containsKey(fromToKey)) {
                firstBizDate = (Object[])firstBizMap.get(fromToKey);
                if (((Date)firstBizDate[0]).compareTo(rowSet.getDate("FBIZDATE")) > 0) {
                    firstBizDate[0] = rowSet.getDate("FBIZDATE");
                    firstBizDate[1] = rowSet.getDate("FAUDITTIME");
                    firstBizDate[2] = rowSet.getString("inBillId");
                    continue;
                }
                if (((Date)firstBizDate[0]).compareTo(rowSet.getDate("FBIZDATE")) != 0 || ((Date)firstBizDate[1]).compareTo(rowSet.getDate("FAUDITTIME")) <= 0) continue;
                firstBizDate[1] = rowSet.getDate("FAUDITTIME");
                firstBizDate[2] = rowSet.getString("inBillId");
                continue;
            }
            firstBizDate = new Object[]{rowSet.getDate("FBIZDATE"), rowSet.getDate("FAUDITTIME"), rowSet.getString("inBillId")};
            firstBizMap.put(fromToKey, firstBizDate);
        }
    }

    protected void checkInCalc(Context ctx, HashMap param) throws BOSException, EASBizException {
        String companyId = (String)param.get("companyId");
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyId));
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        Date beginDate = currentPeriodInfo.getBeginDate();
        Timestamp endDate = currentPeriodInfo.getEndDate();
        String periodId = currentPeriodInfo.getId().toString();
        int year = currentPeriodInfo.getPeriodYear();
        int period = currentPeriodInfo.getPeriodNumber();
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String calType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_002");
        try {
            StringBuffer sql = new StringBuffer();
            IRowSet inRs = this.getNeedCalcOtherInwareBill(ctx, companyId, beginDate, endDate, sql);
            IRowSet devRs = this.getNeedCalcDevInBill(ctx, companyId, beginDate, endDate, year, period, sql);
            IRowSet costMoveInRs = null;
            if (!"0".equals(calType)) {
                costMoveInRs = this.getNeedCalcCostMoveInBill(ctx, companyId, beginDate, endDate, calType, sql);
            }
            HashSet<String> matIdSet = new HashSet<String>();
            while (inRs.next()) {
                matIdSet.add(inRs.getString("FMATERIALID"));
            }
            while (devRs.next()) {
                matIdSet.add(devRs.getString("FMATERIALID"));
            }
            if (costMoveInRs != null) {
                while (costMoveInRs.next()) {
                    matIdSet.add(costMoveInRs.getString("FMATERIALID"));
                }
            }
            if (matIdSet.size() == 0) {
                return;
            }
            Map materialCompanyCalcMap = this.getMaterialCompanyCalcInfo(ctx, companyId, matIdSet);
            HashMap needCalcMap = new HashMap();
            if (inRs != null) {
                inRs.beforeFirst();
            }
            this.buildNeedInCalcMap(ctx, companyId, calType, inRs, materialCompanyCalcMap, needCalcMap, 1);
            if (devRs != null) {
                devRs.beforeFirst();
            }
            this.buildNeedInCalcMap(ctx, companyId, calType, devRs, materialCompanyCalcMap, needCalcMap, 2);
            if (costMoveInRs != null) {
                costMoveInRs.beforeFirst();
                this.buildNeedInCalcMap(ctx, companyId, calType, costMoveInRs, materialCompanyCalcMap, needCalcMap, 3);
            }
            ArrayList<Object[]> updateParamList = new ArrayList<Object[]>();
            Iterator iterator = needCalcMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Object[] updateParam = new Object[9];
                Map.Entry entry = iterator.next();
                String[] matAndCalcKey = ((String)entry.getKey()).split(";");
                int[] needCal = (int[])entry.getValue();
                updateParam[0] = needCal[0];
                updateParam[1] = needCal[1];
                updateParam[2] = needCal[2];
                updateParam[3] = needCal[3];
                updateParam[4] = needCal[4];
                updateParam[5] = companyId;
                updateParam[6] = periodId;
                updateParam[7] = matAndCalcKey[0];
                updateParam[8] = matAndCalcKey[1];
                updateParamList.add(updateParam);
            }
            String updateSql = "update T_CL_MATERIALCALCRANK set FISASSEMBLECALC = ?, FISDISASSEMBLECALC = ?, FISMATCHANGECALC = ?, FISDEVOLVECALC = ?, FIsCostMove = ? where FCOMPANYORGUNITID = ? and FPERIODID = ? and FMATERIALID =? and FCALCULATEKEY = ?";
            DBUtil.executeBatch((Context)ctx, (String)updateSql, updateParamList);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void buildNeedInCalcMap(Context ctx, String companyId, String calType, IRowSet rowSet, Map materialCompanyCalcMap, Map needCalcMap, int type) throws NoSuchAlgorithmException, BOSException, SQLException {
        while (rowSet.next()) {
            int[] needCal;
            String calcKey = this.getMd5CalKey(ctx, calType, rowSet.getString("FMATERIALID"), companyId, rowSet.getString("FSTORAGEORGUNITID"), rowSet.getString("FWAREHOUSEID"), rowSet.getString("FLOT"), rowSet.getString("FASSISTPROPERTYID"), rowSet.getString("FPROJECTID"), rowSet.getString("FTRACKNUMBERID"), materialCompanyCalcMap);
            String calcRankKey = rowSet.getString("FMATERIALID") + ";" + calcKey;
            if (needCalcMap.containsKey(calcRankKey)) {
                needCal = (int[])needCalcMap.get(calcRankKey);
            } else {
                needCal = new int[5];
                needCalcMap.put(calcRankKey, needCal);
            }
            if (type == 1) {
                if ("CJeXjSzrKhfgU0ETqMA1nkY+1VI=".equals(rowSet.getString("FSOURCEBILLTYPEID"))) {
                    needCal[0] = 1;
                    continue;
                }
                if ("CJewLHpKKe/gU0ETqMDAp0Y+1VI=".equals(rowSet.getString("FSOURCEBILLTYPEID"))) {
                    needCal[1] = 1;
                    continue;
                }
                if (!"50957179-0105-1000-e000-888880a812fd463ED552".equals(rowSet.getString("FSOURCEBILLTYPEID"))) continue;
                needCal[2] = 1;
                continue;
            }
            if (type == 2) {
                needCal[3] = 1;
                continue;
            }
            if (type != 3) continue;
            needCal[4] = 1;
        }
    }

    private IRowSet getNeedCalcCostMoveInBill(Context ctx, String companyId, Date beginDate, Timestamp endDate, String calType, StringBuffer sql) throws BOSException {
        sql.setLength(0);
        Object[] params = new Object[]{companyId, beginDate, endDate, null};
        sql.append("SELECT entry.FMATERIALID ,entry.FCOMPANYORGUNITID ,entry.FSTORAGEORGUNITID ,entry.FWAREHOUSEID,entry.FLOT ,entry.FASSISTPROPERTYID, ");
        sql.append(" entry.FPROJECTID ,entry.FTRACKNUMBERID, bill.FSOURCEBILLTYPEID FROM T_IM_MoveInWarehsBill bill ");
        sql.append(" INNER JOIN T_IM_MoveInWarehsBillEntry entry ON BILL.FID = ENTRY.FPARENTID");
        sql.append(" where entry.FCOMPANYORGUNITID = ?");
        sql.append(" and entry.FBIZDATE >= ?");
        sql.append(" and entry.FBIZDATE <= ?");
        sql.append(" and bill.FBIZTYPEID = ?");
        params[3] = "1".equals(calType) ? "d8e80652-011a-1000-e000-04c5c0a812202407435C" : "d8e80652-011b-1000-e000-04c5c0a812202407435C";
        sql.append(" and bill.FBASESTATUS = 4 ");
        IRowSet costMoveInRs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        return costMoveInRs;
    }

    private IRowSet getNeedCalcDevInBill(Context ctx, String companyId, Date beginDate, Timestamp endDate, int year, int period, StringBuffer sql) throws BOSException {
        sql.setLength(0);
        sql.append("SELECT inEntry.FMATERIALID ,inEntry.FSTORAGEORGUNITID,inEntry.FWAREHOUSEID ,inEntry.FLOT ,inEntry.FASSISTPROPERTYID ,");
        sql.append(" inEntry.FPROJECTID ,inEntry.FTRACKNUMBERID FROM T_CL_DEVOLVEWRITEOFFGROUP g ");
        sql.append(" INNER JOIN T_CL_DEVOLVEWRITEOFFRECORD r on r.FPARENTID = g.fid");
        sql.append(" INNER JOIN T_IM_PURINWAREHSENTRY inEntry on inEntry.FID = r.FBILLENTRYID ");
        sql.append(" where g.FWRITEOFFYEAR = ?");
        sql.append(" and g.FWRITEOFFPERIOD = ?");
        sql.append(" and g.FCOMPANYORGUNITID = ?");
        sql.append(" and inEntry.FBIZDATE >= ?");
        sql.append(" and inEntry.FBIZDATE <= ?");
        IRowSet devRs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{year, period, companyId, beginDate, endDate});
        return devRs;
    }

    private IRowSet getNeedCalcOtherInwareBill(Context ctx, String companyId, Date beginDate, Timestamp endDate, StringBuffer sql) throws BOSException {
        sql.append("SELECT entry.FMATERIALID ,entry.FCOMPANYORGUNITID ,entry.FSTORAGEORGUNITID ,entry.FWAREHOUSEID,entry.FLOT ,entry.FASSISTPROPERTYID, ");
        sql.append(" entry.FPROJECTID ,entry.FTRACKNUMBERID, bill.FSOURCEBILLTYPEID FROM t_im_otherInwarehsBill bill ");
        sql.append(" INNER JOIN t_im_otherInwarehsBillEntry entry ON BILL.FID = ENTRY.FPARENTID");
        sql.append(" where entry.FCOMPANYORGUNITID = ?");
        sql.append(" and entry.FBIZDATE >= ?");
        sql.append(" and entry.FBIZDATE <= ?");
        sql.append(" and bill.FBIZTYPEID in ").append(this.specialBillTypeId());
        sql.append(" and bill.FBASESTATUS = 4 ");
        IRowSet inRs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, beginDate, endDate});
        return inRs;
    }

    @Override
    protected CalculateParams _costCalcNormalMaterial(Context ctx, CalculateParams param) throws BOSException, EASBizException {
        CalculateParams calculateParams;
        String materialIdTempTableName = null;
        String calcUnitTempTbl = null;
        String companyId = param.getString("companyId");
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyId));
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        try {
            CalculateParams cps;
            this.getFilterParam(ctx, companyId, param, companyId);
            if (!param.getBoolean("normalMatOnly")) {
                calcUnitTempTbl = this.buildRankDimensionTbl(ctx, companyId, currentPeriodInfo);
                param.setString("calcUnitTempTbl", calcUnitTempTbl);
                materialIdTempTableName = this.buildMaterialIdTempTable(ctx, companyId, currentPeriodInfo);
                param.setString("ThirdPartyMaterialTableName", materialIdTempTableName);
            }
            ICalculateFacade ida = CalculateFacadeFactory.getLocalInstance(ctx);
            calculateParams = cps = ida.costCalculate(param);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                KsqlUtil.releaseTempTable((Context)ctx, materialIdTempTableName);
                KsqlUtil.releaseTempTable((Context)ctx, calcUnitTempTbl);
                throw throwable;
            }
        }
        KsqlUtil.releaseTempTable((Context)ctx, materialIdTempTableName);
        KsqlUtil.releaseTempTable((Context)ctx, (String)calcUnitTempTbl);
        return calculateParams;
    }

    private String buildMaterialIdTempTable(Context ctx, String companyId, PeriodInfo currentPeriodInfo) throws BOSException {
        String materialIdTempTableName = KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)"create table materialIdTempTableName (fmaterialid varchar(44))");
        DBUtil.createTempTableIndex(ctx, materialIdTempTableName, "fid", true);
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(materialIdTempTableName);
        sql.append(" select distinct FMATERIALID FROM T_CL_MATERIALCALCRANK R ");
        sql.append("WHERE R.FCOMPANYORGUNITID = '").append(companyId).append("' ");
        sql.append("AND R.FPERIODID = '").append(currentPeriodInfo.getId().toString()).append("'");
        DBUtil.execute((Context)ctx, (String)sql.toString());
        return materialIdTempTableName;
    }

    protected void getFilterParam(Context ctx, String companyOrgInfoID, CalculateParams params, String companyId) throws EASBizException, BOSException, SQLException {
        params.setBoolean("ISWRITECOSTCOMPUTEREPORT", true);
        params.setBoolean("ISWRITEDEXPCOSTRPT", false);
        params.setBoolean("isWriteCostComputePriceSource", true);
        params.setString("COMPANY_ID", companyOrgInfoID);
        params.setBoolean("IsOtherInvkCostCalculate", true);
        params.setBoolean("IsCreateTmpTable", true);
        params.setBoolean("IsCostAllAccountType", true);
        ICostCalculateFacade iCalc = CostCalculateFacadeFactory.getLocalInstance(ctx);
        IRowSet accountTypeRs = iCalc.getMaterialAccountType(null, null, null, companyId);
        ArrayList<Integer> accountTypeList = new ArrayList<Integer>();
        while (accountTypeRs.next()) {
            if (1 == accountTypeRs.getInt("FACCOUNTTYPE")) continue;
            accountTypeList.add(accountTypeRs.getInt("FACCOUNTTYPE"));
        }
        params.setObject("accountTypeList", accountTypeList);
    }

    private String buildRankDimensionTbl(Context ctx, String companyId, PeriodInfo periodInfo) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" CREATE TABLE TEMP (");
        sql.append(" FMATERIALID VARCHAR(44),");
        sql.append(" FCOMPANYORGUNITID VARCHAR(44),");
        sql.append(" FSTORAGEORGUNITID VARCHAR(44) default '',");
        sql.append(" FWAREHOUSEID VARCHAR(44) default '',");
        sql.append(" FLOT NVARCHAR(255) default '',");
        sql.append(" FASSISTPROPERTYID VARCHAR(255) default '',");
        sql.append(" FPROJECTID VARCHAR(255) default '',");
        sql.append(" FTRACKNUMBERID VARCHAR(255) default '')");
        String calUnitTemp = KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)sql.toString());
        KsqlUtil.createTempTableIndex((Context)ctx, (String)calUnitTemp, (String)"FMATERIALID,FCOMPANYORGUNITID,FSTORAGEORGUNITID,FWAREHOUSEID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID", (boolean)true);
        sql.setLength(0);
        sql.append("insert into ").append(calUnitTemp).append("(FMATERIALID,FCOMPANYORGUNITID,FSTORAGEORGUNITID,FWAREHOUSEID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID) ");
        sql.append("SELECT r.FMATERIALID,m.FCOMPANYORGUNITID ,m.FSTORAGEORGUNITID,m.FWAREHOUSEID,m.FLOT,m.FASSISTPROPERTYID,m.FPROJECTID,m.FTRACKNUMBERID ");
        sql.append("FROM T_CL_MATERIALCALCRANK R INNER JOIN T_CL_CALCULATEKEYMAPPING M ON R.FCALCULATEKEY = M.FMD5KEY ");
        sql.append("WHERE R.FCOMPANYORGUNITID = ? ");
        sql.append("AND R.FPERIODID = ?");
        DBUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodInfo.getId().toString()});
        return calUnitTemp;
    }

    private String specialBillTypeId() {
        StringBuffer s = new StringBuffer();
        s.append("('").append("kXeVPjE9chDgQKjAYj1RYCQHQ1w=").append("','").append("CJeXjSzsKhfgU0ETqMA1niQHQ1w=").append("','").append("CJewLHpMKe/gU0ETqMDApyQHQ1w=").append("')");
        return s.toString();
    }

    public Map getMaterialCompanyCalcInfo(Context ctx, String couId, Set matIdSet) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FMATERIALID, FISLOT, FISASSISTPROPERTY, FISPROJECT, FISTRACKNUMBER FROM t_bd_materialCompanyinfo ");
        sql.append("WHERE FCOMPANYID = '").append(couId).append("' and FACCOUNTTYPE = 5 ");
        sql.append("AND FMATERIALID IN ").append(this.convertIdSet2String(matIdSet));
        IRowSet matComRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap matComMap = new HashMap();
        while (matComRs.next()) {
            HashMap<String, Integer> specialCalKeyMap = new HashMap<String, Integer>();
            specialCalKeyMap.put("FISLOT", matComRs.getInt("FISLOT"));
            specialCalKeyMap.put("FISASSISTPROPERTY", matComRs.getInt("FISASSISTPROPERTY"));
            specialCalKeyMap.put("FISPROJECT", matComRs.getInt("FISPROJECT"));
            specialCalKeyMap.put("FISTRACKNUMBER", matComRs.getInt("FISTRACKNUMBER"));
            matComMap.put(matComRs.getString("FMATERIALID"), specialCalKeyMap);
        }
        return matComMap;
    }

    private String getInOutData() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT outEntry.FMATERIALID outFMATERIALID,outEntry.FCOMPANYORGUNITID ,outEntry.FSTORAGEORGUNITID outFSTORAGEORGUNITID,");
        sql.append(" outEntry.FWAREHOUSEID outFWAREHOUSEID,outEntry.FLOT outFLOT,outEntry.FASSISTPROPERTYID  outFASSISTPROPERTYID,");
        sql.append(" outEntry.FPROJECTID outFPROJECTID,outEntry.FTRACKNUMBERID outFTRACKNUMBERID,outBill.FYEAR outFYEAR,outBill.FPERIOD outFPERIOD, ");
        sql.append(" outEntry.FSOURCEBILLENTRYID,inEntry.FMATERIALID inFMATERIALID,inEntry.FSTORAGEORGUNITID inFSTORAGEORGUNITID,");
        sql.append(" inEntry.FWAREHOUSEID inFWAREHOUSEID,inEntry.FLOT inFLOT,inEntry.FASSISTPROPERTYID inFASSISTPROPERTYID,");
        sql.append(" inEntry.FPROJECTID inFPROJECTID,inEntry.FTRACKNUMBERID inFTRACKNUMBERID,inBill.FYEAR inFYEAR,outBill.FPERIOD inFPERIOD, ");
        sql.append(" inBill.FSOURCEBILLTYPEID, inBill.FBIZDATE, inbill.FAUDITTIME,inBill.fid inBillId ");
        sql.append(" FROM T_IM_OTHERINWAREHSBILL inBill");
        sql.append(" INNER JOIN T_IM_OTHERINWAREHSBILLENTRY inEntry ON INBILL.FID = INENTRY.FPARENTID");
        sql.append(" INNER JOIN T_IM_OTHERISSUEBILLENTRY outEntry on outEntry.FSOURCEBILLENTRYID = inEntry.FSOURCEBILLENTRYID  ");
        sql.append(" INNER JOIN T_IM_OTHERISSUEBILL outBill on outEntry.FPARENTID = outBill.FID ");
        sql.append(" WHERE inEntry.FBIZDATE >= ?");
        sql.append(" AND inEntry.FCOMPANYORGUNITID = ?");
        sql.append(" and inEntry.FBIZDATE <= ?");
        sql.append(" AND inBill.FBIZTYPEID in").append(this.specialBillTypeId());
        sql.append(" and outEntry.FBIZDATE >= ?");
        sql.append(" and outEntry.FBIZDATE <= ?");
        sql.append(" and inBill.FBASESTATUS = 4 and outBill.FBASESTATUS = 4");
        return sql.toString();
    }

    private String getCostMoveData() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT outEntry.FMATERIALID outFMATERIALID,outEntry.FCOMPANYORGUNITID ,outEntry.FSTORAGEORGUNITID outFSTORAGEORGUNITID,");
        sql.append(" outEntry.FWAREHOUSEID outFWAREHOUSEID,outEntry.FLOT outFLOT,outEntry.FASSISTPROPERTYID  outFASSISTPROPERTYID,");
        sql.append(" outEntry.FPROJECTID outFPROJECTID,outEntry.FTRACKNUMBERID outFTRACKNUMBERID,outBill.FYEAR outFYEAR,outBill.FPERIOD outFPERIOD, ");
        sql.append(" outEntry.FSOURCEBILLENTRYID,inEntry.FMATERIALID inFMATERIALID,inEntry.FSTORAGEORGUNITID inFSTORAGEORGUNITID,");
        sql.append(" inEntry.FWAREHOUSEID inFWAREHOUSEID,inEntry.FLOT inFLOT,inEntry.FASSISTPROPERTYID inFASSISTPROPERTYID,");
        sql.append(" inEntry.FPROJECTID inFPROJECTID,inEntry.FTRACKNUMBERID inFTRACKNUMBERID,inBill.FYEAR inFYEAR,outBill.FPERIOD inFPERIOD, ");
        sql.append(" inBill.FSOURCEBILLTYPEID, inBill.FBIZDATE, inbill.FAUDITTIME,inBill.fid inBillId ");
        sql.append(" FROM T_IM_MOVEINWAREHSBILL inBill");
        sql.append(" INNER JOIN T_IM_MoveInWarehsBillEntry inEntry ON INBILL.FID = INENTRY.FPARENTID");
        sql.append(" INNER JOIN T_IM_MoveIssueBillEntry outEntry on inEntry.FSTOCKTRANSBILLENTRYID = outEntry.FSTOCKTRANSBILLENTRYID ");
        sql.append(" INNER JOIN T_IM_MOVEISSUEBILL outBill on outEntry.FPARENTID = outBill.FID ");
        sql.append(" WHERE inEntry.FBIZDATE >= ?");
        sql.append(" and inEntry.FBIZDATE <= ?");
        sql.append(" AND inEntry.FCOMPANYORGUNITID = ?");
        sql.append(" and inBill.FBIZTYPEID = ?");
        sql.append(" and inBill.FBASESTATUS = 4 and outBill.FBASESTATUS = 4");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDevData(Context ctx, String companyId, int year, int period, Date beginDate, Date endDate) throws BOSException, EASBizException {
        String string;
        String tempTable = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append("CREATE TABLE TBL (FID VARCHAR(44), FBIZDATE DateTime,FCREATETIME DateTime,FNUMBER NVARCHAR(80),FGROUPNO INT,FBILLTYPENUMBER NVARCHAR(44),FOUTMAT VARCHAR(44), FOUTSOU VARCHAR(44), FOUTWAREHOUSE VARCHAR(44), FOUTLOT NVARCHAR(80), FOUTASST VARCHAR(44), FOUTPROJECT VARCHAR(44), FOUTTRACKNUM VARCHAR(44), FINMAT VARCHAR(44), FINSOU VARCHAR(44), FINWAREHOUSE VARCHAR(44), FINLOT NVARCHAR(80), FINASST VARCHAR(44),FINPROJECT VARCHAR(44), FINTRACKNUM VARCHAR(44),FINBILLBIZDATE DateTime) ");
            tempTable = KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)sql.toString());
            DBUtil.createTempTableIndex(ctx, tempTable, "FNUMBER,FGROUPNO", false, false);
            sql.setLength(0);
            sql.append("INSERT INTO ").append(tempTable).append(" (FID,FBIZDATE,FCREATETIME,FNUMBER,FGROUPNO,FBILLTYPENUMBER,FOUTMAT,FOUTSOU,FOUTWAREHOUSE,FOUTLOT,FOUTASST,");
            sql.append("FOUTPROJECT,FOUTTRACKNUM,FINMAT,FINSOU,FINWAREHOUSE,FINLOT,FINASST,FINPROJECT,FINTRACKNUM,FINBILLBIZDATE) ");
            sql.append("SELECT devGroup.FID,devGroup.FBIZDATE, devGroup.FCREATETIME,devGroup.FNUMBER,devRecord.FGROUPNO ,devRecord.FBILLTYPENUMBER ,outEntry.FMATERIALID,");
            sql.append("outEntry.FSTORAGEORGUNITID,outEntry.FWAREHOUSEID,outEntry.FLOT,");
            sql.append("outEntry.FASSISTPROPERTYID ,outEntry.FPROJECTID,outEntry.FTRACKNUMBERID,");
            sql.append("inEntry.FMATERIALID,inEntry.FSTORAGEORGUNITID,inEntry.FWAREHOUSEID,");
            sql.append("inEntry.FLOT,inEntry.FASSISTPROPERTYID,inEntry.FPROJECTID,inEntry.FTRACKNUMBERID,inEntry.FBIZDATE ");
            sql.append("FROM T_CL_DEVOLVEWRITEOFFRECORD devRecord ");
            sql.append("INNER JOIN T_CL_DEVOLVEWRITEOFFGROUP devGroup on devRecord.FPARENTID = devGroup.FID ");
            sql.append("LEFT JOIN T_IM_PURINWAREHSENTRY inEntry on inEntry.fid = devRecord.FBILLENTRYID ");
            sql.append(" and inEntry.FBIZDATE >= ?");
            sql.append(" and inEntry.FBIZDATE <= ?");
            sql.append(" LEFT OUTER JOIN T_IM_MATERIALREQBILLENTRY outEntry on outEntry.FID = devRecord.FBILLENTRYID ");
            sql.append(" WHERE devGrouP.FCOMPANYORGUNITID = ? ");
            sql.append(" and devGrouP.FWRITEOFFPERIOD = ? and devGrouP.FWRITEOFFYEAR = ?");
            sql.append(" and devGrouP.FCREATETYPE <> 3");
            DBUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{beginDate, endDate, companyId, period, year});
            sql.setLength(0);
            sql.append("update ").append(tempTable).append(" outTbl set (FINMAT,FINSOU,FINWAREHOUSE,FINLOT,FINASST,FINPROJECT,FINTRACKNUM) = ");
            sql.append("(select FINMAT,FINSOU,FINWAREHOUSE,FINLOT,FINASST,FINPROJECT,FINTRACKNUM from ").append(tempTable).append(" inTbl ");
            sql.append("where outTbl.FNUMBER = inTbl.FNUMBER and outTbl.FGROUPNO = inTbl.FGROUPNO and inTbl.FBILLTYPENUMBER = 103)");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("delete ").append(tempTable).append(" where FBILLTYPENUMBER = 103");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("delete ").append(tempTable).append(" where FINBILLBIZDATE > to_date('").append(endDate).append("')");
            DBUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("select FOUTMAT outFMATERIALID,FOUTSOU outFSTORAGEORGUNITID,FOUTWAREHOUSE outFWAREHOUSEID,FOUTLOT outFLOT,FOUTASST outFASSISTPROPERTYID,");
            sql.append("FOUTPROJECT outFPROJECTID,FOUTTRACKNUM outFTRACKNUMBERID,FINMAT inFMATERIALID,FINSOU inFSTORAGEORGUNITID,FINWAREHOUSE inFWAREHOUSEID,");
            sql.append("FINLOT inFLOT,FINASST inFASSISTPROPERTYID,FINPROJECT inFPROJECTID,FINTRACKNUM inFTRACKNUMBERID,");
            sql.append("FBIZDATE,FCREATETIME FAUDITTIME,FID inBillId from ").append(tempTable);
            string = sql.toString();
        }
        catch (Throwable throwable) {
            DBUtil.releaseTempTable(ctx, tempTable);
            throw throwable;
        }
        DBUtil.releaseTempTable(ctx, tempTable);
        return string;
    }

    @Override
    protected void _costCalcByRank(Context ctx, HashMap params) throws BOSException, EASBizException {
        String companyId = (String)params.get("companyId");
        if (companyId == null) {
            return;
        }
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyId));
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        String periodId = currentPeriodInfo.getId().toString();
        this.checkCalType(ctx, periodId, companyId, params.get("isReCalRank"));
        CostComputeRportHeaderInfo reportHeaderInfo = this.writeCostComputePriceSourceRptHeader(ctx, cou, currentPeriodInfo);
        String processId = (String)params.get("processId");
        Map entryMap = (Map)params.get("entryMap");
        OneKeyCalculateProcessHelper.updateProcessReportHeaderId(ctx, processId, reportHeaderInfo.getId().toString());
        if (params.get("isReCalRank") != null && ((Boolean)params.get("isReCalRank")).booleanValue()) {
            this.doReCalcRank(ctx, params, companyId, currentPeriodInfo, processId, entryMap);
        }
        this.clearOldReport(ctx, companyId, currentPeriodInfo);
        try {
            ThreadLocalHelper.mainExcutor.set(Executors.newFixedThreadPool(2));
            ExecutorCompletionService service = new ExecutorCompletionService((Executor)ThreadLocalHelper.mainExcutor.get());
            ThreadLocalHelper.isOneKeyCalc.set(true);
            if (((Boolean)params.get("isCalUsualMat")).booleanValue()) {
                CalcUsualMatThread usualMatCalcThread = new CalcUsualMatThread(ctx, companyId, reportHeaderInfo.getId().toString(), (String)entryMap.get("calUsualMatNode"));
                service.submit(usualMatCalcThread);
            }
            CalcRankMatThread rankMatThread = new CalcRankMatThread(ctx, cou, currentPeriodInfo, reportHeaderInfo, processId, entryMap);
            service.submit(rankMatThread);
            if (((Boolean)params.get("isCalUsualMat")).booleanValue()) {
                service.take().get();
            }
            service.take().get();
        }
        catch (Exception e) {
            ((ExecutorService)ThreadLocalHelper.mainExcutor.get()).shutdownNow();
            throw new BOSException((Throwable)e);
        }
        finally {
            ThreadLocalHelper.isOneKeyCalc.remove();
            ((ExecutorService)ThreadLocalHelper.mainExcutor.get()).shutdown();
            ThreadLocalHelper.mainExcutor.remove();
        }
    }

    private void calcRankMat(Context ctx, CompanyOrgUnitInfo cou, PeriodInfo currentPeriodInfo, CostComputeRportHeaderInfo reportHeaderInfo, String processId, Map<String, String> entryMap) throws BOSException, EASBizException {
        String calcResultTbl = null;
        String rankTempTbl = null;
        Connection conn = null;
        PreparedStatement calcRankStatement = null;
        ResultSet calcRankResultSet = null;
        String companyId = cou.getId().toString();
        String periodId = currentPeriodInfo.getId().toString();
        OneKeyCalculateParams calcParams = new OneKeyCalculateParams();
        try {
            rankTempTbl = this.getRankInfo(ctx, companyId, periodId);
            conn = EJBFactory.getConnection((Context)ctx);
            calcRankStatement = conn.prepareStatement("select * from " + rankTempTbl + " ORDER BY FRANK,FMATERIALID", 1004, 1007);
            calcRankStatement.setFetchSize(1000);
            calcRankResultSet = calcRankStatement.executeQuery();
            calcParams.setCompanyInfo(cou);
            calcParams.setPeriodInfo(currentPeriodInfo);
            calcParams.setProcessId(processId);
            calcParams.setProcessEntryMap(entryMap);
            calcParams.setReportHeaderInfo(reportHeaderInfo);
            this.initParams(ctx, calcParams);
            boolean calcCycle = calcParams.isCalcCycle();
            int calcTimes = 1;
            if (calcCycle) {
                calcResultTbl = this.createCalcResultTempTable(ctx);
                calcParams.setCalcResulteTbl(calcResultTbl);
                IRowSet timesRs = DBUtil.executeQuery((Context)ctx, (String)"SELECT FVALUE FROM t_dt_dttempparam WHERE FKEY = 'ONE_KEY_CALC_TIMES'");
                while (timesRs.next()) {
                    calcTimes = timesRs.getInt(1);
                }
            }
            boolean firstCalc = true;
            HashMap lastResulte = new HashMap();
            int currRank = -1;
            CalcRankCollection calcColl = new CalcRankCollection();
            while (calcTimes > 0) {
                if (calcRankResultSet != null) {
                    calcRankResultSet.beforeFirst();
                }
                while (calcRankResultSet.next()) {
                    if (!firstCalc && !lastResulte.containsKey(calcRankResultSet.getString("FGROUPKEY"))) continue;
                    if (currRank != -1 && currRank != calcRankResultSet.getInt("FRANK")) {
                        calcColl.setCurrentRank(currRank);
                        this.doCurrRankCalculate(ctx, companyId, calcColl, calcParams, rankTempTbl, currentPeriodInfo);
                    }
                    this.buildCalculateUnitInfo(calcColl, calcRankResultSet, lastResulte, firstCalc, calcCycle);
                    currRank = calcRankResultSet.getInt("FRANK");
                }
                calcColl.setCurrentRank(currRank);
                this.doCurrRankCalculate(ctx, companyId, calcColl, calcParams, rankTempTbl, currentPeriodInfo);
                currRank = -1;
                if (calcCycle) {
                    this.checkNeedCycle(ctx, calcResultTbl, lastResulte);
                }
                if (lastResulte.isEmpty()) {
                    calcTimes = 1;
                }
                firstCalc = false;
                --calcTimes;
            }
        }
        catch (Exception e) {
            try {
                if (ThreadLocalHelper.calcOutExcutor.get() != null) {
                    ((ExecutorService)ThreadLocalHelper.calcOutExcutor.get()).shutdownNow();
                }
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                ThreadLocalHelper.calcOutExcutor.remove();
                DBUtil.releaseTempTable(ctx, calcResultTbl, rankTempTbl);
                DBUtil.close(conn, new PreparedStatement[]{calcRankStatement}, new ResultSet[]{calcRankResultSet});
                DBUtil.releaseTempTable(ctx, calcParams.getClBalanceTempTbl(), calcParams.getInvBalanceTempTbl(), calcParams.getSaleIssueEntryTempTbl(), calcParams.getOtherIssueTempTbl(), calcParams.getMatReqEntryTempTbl(), calcParams.getMoveIssueTempTbl(), calcParams.getOtherInTempTbl(), calcParams.getPurInTempTbl(), calcParams.getMoveInTempTbl(), calcParams.getManuRecEntryTempTbl(), calcParams.getCostAdjEntryTempTbl());
                throw throwable;
            }
        }
        ThreadLocalHelper.calcOutExcutor.remove();
        DBUtil.releaseTempTable(ctx, calcResultTbl, rankTempTbl);
        DBUtil.close(conn, new PreparedStatement[]{calcRankStatement}, new ResultSet[]{calcRankResultSet});
        DBUtil.releaseTempTable(ctx, calcParams.getClBalanceTempTbl(), calcParams.getInvBalanceTempTbl(), calcParams.getSaleIssueEntryTempTbl(), calcParams.getOtherIssueTempTbl(), calcParams.getMatReqEntryTempTbl(), calcParams.getMoveIssueTempTbl(), calcParams.getOtherInTempTbl(), calcParams.getPurInTempTbl(), calcParams.getMoveInTempTbl(), calcParams.getManuRecEntryTempTbl(), calcParams.getCostAdjEntryTempTbl());
    }

    private void doReCalcRank(Context ctx, HashMap params, String companyId, PeriodInfo currentPeriodInfo, String processId, Map<String, String> entryMap) throws BOSException, EASBizException {
        String reCalRankNode = entryMap.get("reCalRankNode");
        OneKeyCalculateProcessHelper.setPocessEntryStart(ctx, reCalRankNode);
        this.reCalcRank(ctx, params);
        OneKeyCalculateProcessHelper.setProcessEntrySucess(ctx, reCalRankNode);
        IOneKeyCalculateProcess iProcess = OneKeyCalculateProcessFactory.getLocalInstance(ctx);
        OneKeyCalculateProcessInfo processInfo = iProcess.getOneKeyCalculateProcessInfo((IObjectPK)new ObjectUuidPK(processId));
        int seq = processInfo.getEntry().size();
        OneKeyCalculateProcessEntryCollection entryCol = OneKeyCalculateProcessHelper.buildEntryCollByRankTable(ctx, companyId, currentPeriodInfo, seq, entryMap);
        processInfo.getEntry().addCollection(entryCol);
        iProcess.update((IObjectPK)new ObjectUuidPK(processId), processInfo);
    }

    private void doNormalMaterial(Context ctx, String companyId, String reportHeaderId, String calcUsualMatNode) throws BOSException, EASBizException {
        try {
            OneKeyCalculateProcessHelper.setPocessEntryStart(ctx, calcUsualMatNode);
            CalculateParams param = new CalculateParams();
            param.setString("companyId", companyId);
            param.setString("headerid", reportHeaderId);
            param.setBoolean("normalMatOnly", true);
            this._costCalcNormalMaterial(ctx, param);
            param.setBoolean("normalMatOnly", false);
            this._costCalcNormalMaterial(ctx, param);
            OneKeyCalculateProcessHelper.setProcessEntrySucess(ctx, calcUsualMatNode);
        }
        catch (Exception e) {
            OneKeyCalculateProcessHelper.setProcessExceptionState(ctx, calcUsualMatNode);
            throw new BOSException((Throwable)e);
        }
    }

    private CostComputeRportHeaderInfo writeCostComputePriceSourceRptHeader(Context ctx, CompanyOrgUnitInfo cou, PeriodInfo periodInfo) throws BOSException, EASBizException {
        CostComputeRportHeaderInfo info = new CostComputeRportHeaderInfo();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String strCalType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(cou.getId().toString()), "SCM_CAL_002");
        info.setCompany(cou);
        info.setPeriod(periodInfo);
        info.setMatCalType(MaterialCalTypeEnum.getEnum(strCalType));
        Timestamp time = new Timestamp(new Date().getTime());
        info.setStartTime(time);
        StringBuffer sql = new StringBuffer();
        sql.append(" select max(fcount)  maxCount from T_CL_CostComputeRportHeader ");
        sql.append(" where FCompanyID = '");
        sql.append(cou.getId().toString()).append("'");
        sql.append(" and FPeriodID = '");
        sql.append(periodInfo.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int count = 1;
        try {
            if (rs.next()) {
                count = rs.getInt("maxCount") + 1;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        info.setCount(count);
        IObjectPK pk = CostComputeRportHeaderFactory.getLocalInstance(ctx).addnew(info);
        info.setId(BOSUuid.read((String)pk.toString()));
        return info;
    }

    private void clearOldReport(Context ctx, String companyId, PeriodInfo periodInfo) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)periodInfo.getPeriodYear()));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)periodInfo.getPeriodNumber()));
        OneKeyCalculateReportFactory.getLocalInstance(ctx).delete(filter);
    }

    private String getRankInfo(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" CREATE TABLE TEMP (");
        sql.append(" FRANK INT,");
        sql.append(" FMATERIALID VARCHAR(44),");
        sql.append(" FCOMPANYORGUNITID VARCHAR(44),");
        sql.append(" FSTORAGEORGUNITID VARCHAR(44),");
        sql.append(" FWAREHOUSEID VARCHAR(44),");
        sql.append(" FLOT NVARCHAR(255),");
        sql.append(" FASSISTPROPERTYID VARCHAR(255),");
        sql.append(" FPROJECTID VARCHAR(255),");
        sql.append(" FTRACKNUMBERID VARCHAR(255),");
        sql.append(" FGROUPKEY VARCHAR(36),");
        sql.append(" FACCOUNTTYPE INT,");
        sql.append(" FISASSEMBLECALC INT,");
        sql.append(" FISDISASSEMBLECALC INT,");
        sql.append(" FISMATCHANGECALC INT,");
        sql.append(" FISDEVOLVECALC INT,");
        sql.append(" FHASCYCLE INT)");
        String rankTempTbl = KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)sql.toString());
        KsqlUtil.createTempTableIndex((Context)ctx, (String)rankTempTbl, (String)"FMATERIALID,FSTORAGEORGUNITID,FWAREHOUSEID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID", (boolean)true);
        sql.setLength(0);
        sql.append("insert into ").append(rankTempTbl);
        sql.append("(FRANK,FCOMPANYORGUNITID,FMATERIALID,FSTORAGEORGUNITID,FWAREHOUSEID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID,");
        sql.append("FGROUPKEY,FACCOUNTTYPE,FISASSEMBLECALC,FISDISASSEMBLECALC,FISMATCHANGECALC,FISDEVOLVECALC,FHASCYCLE) ");
        sql.append("SELECT R.FRANK, R.FCOMPANYORGUNITID, R.FMATERIALID, M.FSTORAGEORGUNITID, M.FWAREHOUSEID, ");
        sql.append("M.FLOT, M.FASSISTPROPERTYID, M.FPROJECTID, M.FTRACKNUMBERID, R.FGROUPKEY, MC.FACCOUNTTYPE, ");
        sql.append("R.FISASSEMBLECALC, R.FISDISASSEMBLECALC, R.FISMATCHANGECALC, R.FISDEVOLVECALC, R.FHASCYCLE ");
        sql.append("FROM T_CL_materialCalcRank R INNER JOIN T_CL_CalculateKeyMapping M ON R.FCALCULATEKEY = M.FMD5KEY ");
        sql.append("INNER JOIN T_BD_MATERIALCOMPANYINFO MC ON MC.FMATERIALID = R.FMATERIALID AND MC.FCOMPANYID = R.FCOMPANYORGUNITID ");
        sql.append("WHERE R.FCOMPANYORGUNITID = ? AND R.FPERIODID = ?");
        DBUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodId});
        return rankTempTbl;
    }

    private void checkNeedCycle(Context ctx, String calcResultTbl, Map lastResulte) throws BOSException, SQLException {
        Iterator iterator = lastResulte.entrySet().iterator();
        HashSet<String> removeSet = new HashSet<String>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String groupKey = entry.getKey().toString();
            Object[] value = (Object[])entry.getValue();
            CalculateUnitInfo calcInfo = (CalculateUnitInfo)value[0];
            BigDecimal lastPrice = (BigDecimal)value[1];
            BigDecimal currPrice = BigDecimal.ZERO;
            IRowSet rs = this.getNewPriceByCalcUnit(ctx, calcInfo, calcResultTbl);
            while (rs.next()) {
                currPrice = rs.getBigDecimal("FPRICE");
            }
            if (lastPrice.compareTo(currPrice) == 0) {
                removeSet.add(groupKey);
                continue;
            }
            value[1] = currPrice;
        }
        for (String s : removeSet) {
            lastResulte.remove(s);
        }
        DBUtil.execute((Context)ctx, (String)("delete " + calcResultTbl));
    }

    private IRowSet getNewPriceByCalcUnit(Context ctx, CalculateUnitInfo calcInfo, String calcResultTbl) throws BOSException {
        StringBuilder sql = new StringBuilder();
        ArrayList<String> param = new ArrayList<String>();
        sql.append("SELECT FPRICE FROM ").append(calcResultTbl);
        sql.append(" WHERE FMATERIALID = ? ");
        param.add(calcInfo.getMaterialId());
        if (calcInfo.getStorageOrgUnitId() != null) {
            sql.append(" and FSTORAGEORGUNITID = ? ");
            param.add(calcInfo.getStorageOrgUnitId());
        }
        if (calcInfo.getWarehouseId() != null) {
            sql.append(" and FWAREHOUSEID = ? ");
            param.add(calcInfo.getWarehouseId());
        }
        if (calcInfo.getLot() != null) {
            sql.append(" and FLOT = ? ");
            param.add(calcInfo.getLot());
        }
        if (calcInfo.getAssistPropertyId() != null) {
            sql.append(" and FASSISTPROPERTYID = ? ");
            param.add(calcInfo.getAssistPropertyId());
        }
        if (calcInfo.getProjectId() != null) {
            sql.append(" and FPROJECTID = ? ");
            param.add(calcInfo.getProjectId());
        }
        if (calcInfo.getTrackNumberId() != null) {
            sql.append(" and FTRACKNUMBERID = ? ");
            param.add(calcInfo.getTrackNumberId());
        }
        return DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
    }

    private void doCurrRankCalculate(Context ctx, String companyId, CalcRankCollection calcColl, OneKeyCalculateParams params, String rankTempTbl, PeriodInfo currentPeriodInfo) throws EASBizException, BOSException {
        Map<String, String> processEntryMap = params.getProcessEntryMap();
        try {
            ThreadLocalHelper.calcOutExcutor.set(Executors.newFixedThreadPool(4));
            this.multiThreadInCalc(ctx, companyId, calcColl, processEntryMap, rankTempTbl, currentPeriodInfo);
            this.multiThreadOutCalc(ctx, calcColl, params, processEntryMap);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (ThreadLocalHelper.calcOutExcutor.get() != null) {
                ((ExecutorService)ThreadLocalHelper.calcOutExcutor.get()).shutdownNow();
            }
        }
    }

    private void multiThreadOutCalc(Context ctx, CalcRankCollection calcColl, OneKeyCalculateParams params, Map<String, String> processEntryMap) throws BOSException {
        int currentRank = calcColl.getCurrentRank();
        int calcCount = 0;
        if (calcColl.getAvgList().size() > 0) {
            ++calcCount;
        }
        if (calcColl.getSpecialList().size() > 0) {
            ++calcCount;
        }
        if (calcColl.getFifoList().size() > 0) {
            ++calcCount;
        }
        if (calcColl.getMovingAvgList().size() > 0) {
            ++calcCount;
        }
        ExecutorCompletionService completionService = new ExecutorCompletionService((Executor)ThreadLocalHelper.calcOutExcutor.get());
        try {
            OutCalcThread outCalcThread;
            String processEntryId;
            if (calcColl.getAvgList().size() > 0) {
                processEntryId = processEntryMap.get(currentRank + "addAvg");
                outCalcThread = new OutCalcThread(ctx, AccountType.ADD_AVERAGE, calcColl, params, processEntryId);
                completionService.submit(outCalcThread);
            }
            if (calcColl.getSpecialList().size() > 0) {
                processEntryId = processEntryMap.get(currentRank + "special");
                outCalcThread = new OutCalcThread(ctx, AccountType.SPECIAL_ACCT, calcColl, params, processEntryId);
                completionService.submit(outCalcThread);
            }
            if (calcColl.getFifoList().size() > 0) {
                processEntryId = processEntryMap.get(currentRank + "fifo");
                outCalcThread = new OutCalcThread(ctx, AccountType.FIN_FOUT, calcColl, params, processEntryId);
                completionService.submit(outCalcThread);
            }
            if (calcColl.getMovingAvgList().size() > 0) {
                processEntryId = processEntryMap.get(currentRank + "moveWeight");
                outCalcThread = new OutCalcThread(ctx, AccountType.MOVE_WEIGHTED_AVERAGE, calcColl, params, processEntryId);
                completionService.submit(outCalcThread);
            }
            for (int i = 0; i < calcCount; ++i) {
                completionService.take().get();
            }
            calcColl.getAvgList().clear();
            calcColl.getSpecialList().clear();
            calcColl.getFifoList().clear();
            calcColl.getMovingAvgList().clear();
        }
        catch (Exception e) {
            ((ExecutorService)ThreadLocalHelper.calcOutExcutor.get()).shutdownNow();
            throw new BOSException((Throwable)e);
        }
    }

    private void multiThreadInCalc(Context ctx, String companyId, CalcRankCollection calcColl, Map<String, String> processEntryMap, String rankTempTbl, PeriodInfo currentPeriodInfo) throws BOSException, InterruptedException {
        int currentRank = calcColl.getCurrentRank();
        int calcCount = 0;
        if (calcColl.getMatAssembleInList().size() > 0) {
            ++calcCount;
        }
        if (calcColl.getMatChangeInList().size() > 0) {
            ++calcCount;
        }
        if (calcColl.getDevInList().size() > 0) {
            ++calcCount;
        }
        ExecutorCompletionService completionService = new ExecutorCompletionService((Executor)ThreadLocalHelper.calcOutExcutor.get());
        try {
            InCalcThread inCalcThread;
            String processEntryId;
            if (calcColl.getMatAssembleInList().size() > 0) {
                processEntryId = processEntryMap.get(currentRank + "assemble");
                inCalcThread = new InCalcThread(ctx, calcColl, companyId, 1, processEntryId, rankTempTbl, currentPeriodInfo);
                completionService.submit(inCalcThread);
            }
            if (calcColl.getMatChangeInList().size() > 0) {
                processEntryId = processEntryMap.get(currentRank + "matChange");
                inCalcThread = new InCalcThread(ctx, calcColl, companyId, 2, processEntryId, rankTempTbl, currentPeriodInfo);
                completionService.submit(inCalcThread);
            }
            if (calcColl.getDevInList().size() > 0) {
                processEntryId = processEntryMap.get(currentRank + "devolve");
                inCalcThread = new InCalcThread(ctx, calcColl, companyId, 3, processEntryId, rankTempTbl, currentPeriodInfo);
                completionService.submit(inCalcThread);
            }
            for (int i = 0; i < calcCount; ++i) {
                completionService.take().get();
            }
            calcColl.getMatAssembleInList().clear();
            calcColl.getMatChangeInList().clear();
            calcColl.getDevInList().clear();
        }
        catch (Exception e) {
            ((ExecutorService)ThreadLocalHelper.calcOutExcutor.get()).shutdownNow();
            throw new BOSException((Throwable)e);
        }
    }

    private void buildCalculateUnitInfo(CalcRankCollection calcColl, ResultSet rs, Map lastResulte, boolean firstCalc, boolean calcCycle) throws SQLException {
        CalculateUnitInfo calcInfo = new CalculateUnitInfo();
        calcInfo.setMaterialId(rs.getString("FMATERIALID"));
        calcInfo.setCompanyOrgUnitId(rs.getString("FCOMPANYORGUNITID"));
        calcInfo.setAccountType(rs.getInt("FACCOUNTTYPE"));
        if (rs.getString("FSTORAGEORGUNITID") != null) {
            calcInfo.setStorageOrgUnitId(rs.getString("FSTORAGEORGUNITID"));
        }
        if (rs.getString("FWAREHOUSEID") != null) {
            calcInfo.setWarehouseId(rs.getString("FWAREHOUSEID"));
        }
        if (rs.getString("FLOT") != null) {
            calcInfo.setLot(rs.getString("FLOT"));
        }
        if (rs.getString("FASSISTPROPERTYID") != null) {
            calcInfo.setAssistPropertyId(rs.getString("FASSISTPROPERTYID"));
        }
        if (rs.getString("FPROJECTID") != null) {
            calcInfo.setProjectId(rs.getString("FPROJECTID"));
        }
        if (rs.getString("FTRACKNUMBERID") != null) {
            calcInfo.setTrackNumberId(rs.getString("FTRACKNUMBERID"));
        }
        if (3 == calcInfo.getAccountType()) {
            calcColl.getAvgList().add(calcInfo);
        } else if (5 == calcInfo.getAccountType()) {
            calcColl.getSpecialList().add(calcInfo);
        } else if (4 == calcInfo.getAccountType()) {
            calcColl.getFifoList().add(calcInfo);
        } else if (6 == calcInfo.getAccountType()) {
            calcColl.getMovingAvgList().add(calcInfo);
        }
        if (rs.getInt("FISASSEMBLECALC") == 1 || rs.getInt("FISDISASSEMBLECALC") == 1) {
            calcColl.getMatAssembleInList().add(calcInfo);
        }
        if (rs.getInt("FISMATCHANGECALC") == 1) {
            calcColl.getMatChangeInList().add(calcInfo);
        }
        if (rs.getInt("FISDEVOLVECALC") == 1) {
            calcColl.getDevInList().add(calcInfo);
        }
        if (calcCycle && firstCalc && rs.getInt("FHASCYCLE") == 1) {
            lastResulte.put(rs.getString("FGROUPKEY"), new Object[]{calcInfo, BigDecimal.ZERO});
        }
    }

    private void initParams(Context ctx, OneKeyCalculateParams params) throws Exception {
        String companyId = params.getCompanyInfo().getId().toString();
        CompanyOrgUnitInfo companyInfo = params.getCompanyInfo();
        if (companyInfo == null) {
            CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
            try {
                cou.setId(BOSUuid.read((String)companyId));
                if (cou == null || cou.getId() == null) {
                    throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
                }
                params.setCompanyInfo(cou);
            }
            catch (Exception e) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
        }
        int presision = 2;
        try {
            presision = params.getBaseCurrencyPrecision();
            if (presision <= 0) {
                presision = CalculateUtil.getLocalCurrencyPrecision2(ctx, companyInfo);
            }
            params.setBaseCurrencyPrecision(presision);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        PeriodInfo periodInfo = params.getPeriodInfo();
        if (periodInfo == null) {
            periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo == null) {
                if (companyInfo.getName() == null || companyInfo.getNumber() == null) {
                    companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                }
                throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{CalculateUtil.takeFormateDesc(companyInfo.getName(), companyInfo.getNumber())});
            }
            params.setPeriodInfo(periodInfo);
        }
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String strCalType = params.getCalType();
        if (strCalType == null) {
            strCalType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_002");
            params.setCalType(strCalType);
        }
        String isNotSrcBill = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_014");
        params.setNoSrcOutBillCalType(isNotSrcBill);
        String srcBillisPreperiod = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_015");
        params.setSrcBillPreperiodCalType(srcBillisPreperiod);
        String writeCostType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_016");
        params.setReworkCostType(writeCostType);
        String zeroPriceType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_017");
        params.setZeroGetCostType(zeroPriceType);
        String isChkEntrust = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_022");
        params.setNotCalConsignSale(isChkEntrust);
        String moveLocBill = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_029");
        params.setCalMoveLocationBill(moveLocBill);
        boolean calcCycle = CalculateUtil.getCostCalculateParam(ctx, companyId, "SCM_CAL_030");
        params.setCalcCycle(calcCycle);
        this.getCurrPeriodBillDataTempTbl(ctx, companyId, periodInfo, params);
    }

    private void getCurrPeriodBillDataTempTbl(Context ctx, String companyId, PeriodInfo periodInfo, OneKeyCalculateParams params) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String saleIssueEntryTempTbl = pool.createTempTableName();
        String matReqEntryTempTbl = pool.createTempTableName();
        String moveIssueTempTbl = pool.createTempTableName();
        String otherIssueTempTbl = pool.createTempTableName();
        String purInTempTbl = pool.createTempTableName();
        String otherInTempTbl = pool.createTempTableName();
        String moveInTempTbl = pool.createTempTableName();
        String manuRecEntryTempTbl = pool.createTempTableName();
        String costAdjEntryTempTbl = pool.createTempTableName();
        String invBalanceTempTbl = pool.createTempTableName();
        String clBalanceTempTbl = pool.createTempTableName();
        params.setSaleIssueEntryTempTbl(saleIssueEntryTempTbl);
        params.setMoveIssueTempTbl(moveIssueTempTbl);
        params.setOtherIssueTempTbl(otherIssueTempTbl);
        params.setMatReqEntryTempTbl(matReqEntryTempTbl);
        params.setPurInTempTbl(purInTempTbl);
        params.setOtherInTempTbl(otherInTempTbl);
        params.setMoveInTempTbl(moveInTempTbl);
        params.setManuRecEntryTempTbl(manuRecEntryTempTbl);
        params.setCostAdjEntryTempTbl(costAdjEntryTempTbl);
        params.setInvBalanceTempTbl(invBalanceTempTbl);
        params.setClBalanceTempTbl(clBalanceTempTbl);
        StringBuilder sql = new StringBuilder();
        String condition = "where FCOMPANYORGUNITID = '" + companyId + "' and FBIZDATE >= to_date('" + periodInfo.getBeginDate() + "') and FBIZDATE <= to_date('" + periodInfo.getEndDate() + "')";
        sql.append("select * into ").append(saleIssueEntryTempTbl).append(" from t_im_saleIssueEntry ").append(condition);
        DBUtil.execute((Context)ctx, (String)sql.toString());
        pool.createIndex(saleIssueEntryTempTbl, "FMATERIALID,FPARENTID", false, false);
        pool.createIndex(saleIssueEntryTempTbl, "FMATERIALID,FStorageOrgUnitID,FWareHouseID,FLOT,FAssistPropertyID,FProjectID,FTrackNumberID", false, false);
        sql.setLength(0);
        sql.append("select * into ").append(matReqEntryTempTbl).append(" from T_IM_MaterialReqBillEntry ").append(condition);
        DBUtil.execute((Context)ctx, (String)sql.toString());
        pool.createIndex(matReqEntryTempTbl, "FMATERIALID,FPARENTID", false, false);
        pool.createIndex(matReqEntryTempTbl, "FMATERIALID,FStorageOrgUnitID,FWareHouseID,FLOT,FAssistPropertyID,FProjectID,FTrackNumberID", false, false);
        sql.setLength(0);
        sql.append("select * into ").append(moveIssueTempTbl).append(" from T_IM_MoveIssueBillEntry ").append(condition);
        DBUtil.execute((Context)ctx, (String)sql.toString());
        pool.createIndex(moveIssueTempTbl, "FMATERIALID,FPARENTID", false, false);
        pool.createIndex(moveIssueTempTbl, "FMATERIALID,FStorageOrgUnitID,FWareHouseID,FLOT,FAssistPropertyID,FProjectID,FTrackNumberID", false, false);
        sql.setLength(0);
        sql.append("select * into ").append(otherIssueTempTbl).append(" from T_IM_OtherIssueBillEntry ").append(condition);
        DBUtil.execute((Context)ctx, (String)sql.toString());
        pool.createIndex(otherIssueTempTbl, "FMATERIALID,FPARENTID", false, false);
        pool.createIndex(otherIssueTempTbl, "FMATERIALID,FStorageOrgUnitID,FWareHouseID,FLOT,FAssistPropertyID,FProjectID,FTrackNumberID", false, false);
        sql.setLength(0);
        sql.append("select * into ").append(otherInTempTbl).append(" from T_IM_OtherInWarehsBillEntry ").append(condition);
        DBUtil.execute((Context)ctx, (String)sql.toString());
        pool.createIndex(otherInTempTbl, "FMATERIALID,FPARENTID", false, false);
        pool.createIndex(otherInTempTbl, "FMATERIALID,FStorageOrgUnitID,FWareHouseID,FLOT,FAssistPropertyID,FProjectID,FTrackNumberID", false, false);
        sql.setLength(0);
        sql.append("select * into ").append(moveInTempTbl).append(" from T_IM_MoveInWarehsBillEntry ").append(condition);
        DBUtil.execute((Context)ctx, (String)sql.toString());
        pool.createIndex(moveInTempTbl, "FMATERIALID,FPARENTID", false, false);
        pool.createIndex(moveInTempTbl, "FMATERIALID,FStorageOrgUnitID,FWareHouseID,FLOT,FAssistPropertyID,FProjectID,FTrackNumberID", false, false);
        sql.setLength(0);
        sql.append("select * into ").append(manuRecEntryTempTbl).append(" from T_IM_ManufactureRecBillEntry ").append(condition);
        DBUtil.execute((Context)ctx, (String)sql.toString());
        pool.createIndex(manuRecEntryTempTbl, "FMATERIALID,FPARENTID", false, false);
        pool.createIndex(manuRecEntryTempTbl, "FMATERIALID,FStorageOrgUnitID,FWareHouseID,FLOT,FAssistPropertyID,FProjectID,FTrackNumberID", false, false);
        sql.setLength(0);
        sql.append("select * into ").append(purInTempTbl).append(" from T_IM_PurInWarehsEntry ").append(condition);
        DBUtil.execute((Context)ctx, (String)sql.toString());
        pool.createIndex(purInTempTbl, "FMATERIALID,FPARENTID", false, false);
        pool.createIndex(purInTempTbl, "FMATERIALID,FStorageOrgUnitID,FWareHouseID,FLOT,FAssistPropertyID,FProjectID,FTrackNumberID", false, false);
        sql.setLength(0);
        sql.append("select * into ").append(costAdjEntryTempTbl).append(" from T_CL_CostAdjustBillEntry ").append(condition);
        DBUtil.execute((Context)ctx, (String)sql.toString());
        pool.createIndex(costAdjEntryTempTbl, "FMATERIALID,FPARENTID", false, false);
        pool.createIndex(costAdjEntryTempTbl, "FMATERIALID,FStorageOrgUnitID,FWareHouseID,FLOT,FAssistPropertyID,FProjectID,FTrackNumberID", false, false);
        sql.setLength(0);
        sql.append("select * into ").append(invBalanceTempTbl).append(" from T_IM_InventoryBalance ");
        sql.append("where FCOMPANYORGUNITID = '").append(companyId).append("' ");
        sql.append("and fyear = ").append(periodInfo.getPeriodYear()).append(" and fperiod = ").append(periodInfo.getPeriodNumber());
        DBUtil.execute((Context)ctx, (String)sql.toString());
        pool.createIndex(invBalanceTempTbl, "FMATERIALID,FStorageOrgUnitID,FWareHouseID,FLOT,FAssistPropertyID,FProjectID,FTrackNumberID", false, false);
        sql.setLength(0);
        sql.append("select * into ").append(clBalanceTempTbl).append(" from T_CL_InventoryBalance ");
        sql.append("where FCOMPANYORGUNITID = '").append(companyId).append("' ");
        sql.append("and fyear = ").append(periodInfo.getPeriodYear()).append(" and fperiod = ").append(periodInfo.getPeriodNumber());
        DBUtil.execute((Context)ctx, (String)sql.toString());
        pool.createIndex(clBalanceTempTbl, "FMATERIALID,FStorageOrgUnitID,FWareHouseID,FLOT,FAssistPropertyID,FProjectID,FTrackNumberID", false, false);
    }

    private String createCalcResultTempTable(Context ctx) throws BOSException {
        StringBuilder createSql = new StringBuilder();
        createSql.append(" CREATE TABLE TEMP (");
        createSql.append(" FMATERIALID VARCHAR(44),");
        createSql.append(" FCOMPANYORGUNITID VARCHAR(44),");
        createSql.append(" FSTORAGEORGUNITID VARCHAR(44),");
        createSql.append(" FWAREHOUSEID VARCHAR(44),");
        createSql.append(" FLOT NVARCHAR(255),");
        createSql.append(" FASSISTPROPERTYID VARCHAR(255),");
        createSql.append(" FPROJECTID VARCHAR(255),");
        createSql.append(" FTRACKNUMBERID VARCHAR(255),");
        createSql.append(" FPRICE NUMERIC(21,8) default 0)");
        String tblName = KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)createSql.toString());
        KsqlUtil.createTempTableIndex((Context)ctx, (String)tblName, (String)"FMATERIALID,FSTORAGEORGUNITID,FWAREHOUSEID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID", (boolean)true);
        return tblName;
    }

    protected List getExceptionMat(Context ctx, List idList, int inCalcType) throws BOSException, SQLException {
        String entryTbl;
        String billTbl;
        ArrayList<String> matList = new ArrayList<String>();
        if (inCalcType == 3) {
            billTbl = "T_IM_PURINWAREHSBILL";
            entryTbl = "T_IM_PURINWAREHSENTRY";
        } else {
            billTbl = "T_IM_OTHERINWAREHSBILL";
            entryTbl = "T_IM_OTHERINWAREHSBILLENTRY";
        }
        StringBuilder ids = new StringBuilder();
        for (Object s : idList) {
            ids.append("'").append(s).append("',");
        }
        ids.setLength(ids.length() - 1);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT distinct M.FNUMBER FROM ").append(billTbl).append(" bill ");
        sql.append("INNER JOIN ").append(entryTbl).append(" entry ON BILL.FID = ENTRY.FPARENTID ");
        sql.append("INNER JOIN T_BD_MATERIAL M ON M.FID = ENTRY.FMATERIALID ");
        sql.append("where bill.fid in (").append((CharSequence)ids).append(")");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            matList.add(rs.getString("FNUMBER"));
        }
        return matList;
    }

    @Override
    protected void _reCalcRank(Context ctx, HashMap param) throws BOSException, EASBizException {
        this.reCalcMaterialRelationStructure(ctx, param);
        this.calcGroupKey(ctx, param);
        this.calcFirstBizTime(ctx, param);
        this.calcRank(ctx, param);
        this.checkInCalc(ctx, param);
        this.addNewMd5Key(ctx);
    }

    private void addNewMd5Key(Context ctx) throws BOSException {
        if (!this.md5KeyMap.isEmpty()) {
            try {
                Set keySet = this.md5KeyMap.keySet();
                StringBuilder ids = new StringBuilder();
                for (String key : keySet) {
                    ids.append("'").append(key).append("',");
                }
                ids.setLength(ids.length() - 1);
                String selectSql = "select FMD5Key from T_CL_CalculateKeyMapping where FMD5Key in (" + ids + ")";
                IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)selectSql);
                HashSet<String> existSet = new HashSet<String>();
                while (rs.next()) {
                    existSet.add(rs.getString("FMD5Key"));
                }
                Iterator iterator = keySet.iterator();
                ArrayList params = new ArrayList();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    if (existSet.contains(key)) continue;
                    params.add(this.md5KeyMap.get(key));
                }
                if (params.size() == 0) {
                    return;
                }
                String insertSql = "insert into T_CL_CalculateKeyMapping(fid,FMD5Key,FCOMPANYORGUNITID,FSTORAGEORGUNITID,FWAREHOUSEID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID) values (newbosid('243A15B2'),?,?,?,?,?,?,?,?)";
                DBUtil.executeBatch((Context)ctx, (String)insertSql, params);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void checkCalType(Context ctx, String periodId, String companyId, Object isReCalRank) throws BOSException, EASBizException {
        if (isReCalRank != null && ((Boolean)isReCalRank).booleanValue()) {
            return;
        }
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String calType = ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "SCM_CAL_002");
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select top 1 map.FCOMPANYORGUNITID, map.FSTORAGEORGUNITID, map.FWAREHOUSEID ");
            sql.append(" from T_CL_materialCalcRank rank ");
            sql.append(" inner join T_CL_CalculateKeyMapping map on map.FMD5KEY = rank.FCALCULATEKEY");
            sql.append(" where rank.FCOMPANYORGUNITID = '").append(companyId).append("' ");
            sql.append(" and rank.FPERIODID = '").append(periodId).append("' ");
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                if ("2".equals(calType) && rs.getString("FCOMPANYORGUNITID") != null && rs.getString("FSTORAGEORGUNITID") != null && rs.getString("FWAREHOUSEID") != null || "1".equals(calType) && rs.getString("FCOMPANYORGUNITID") != null && rs.getString("FSTORAGEORGUNITID") != null && rs.getString("FWAREHOUSEID") == null || "0".equals(calType) && rs.getString("FCOMPANYORGUNITID") != null && rs.getString("FSTORAGEORGUNITID") == null && rs.getString("FWAREHOUSEID") == null) {
                    return;
                }
                throw new CalculateException(CalculateException.CALTYPE_CHANGE);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    class CalcRankMatThread
    extends Thread
    implements Callable {
        Context ctx;
        CompanyOrgUnitInfo cou;
        PeriodInfo currentPeriodInfo;
        CostComputeRportHeaderInfo reportHeaderInfo;
        String processId;
        Map<String, String> entryMap;

        public CalcRankMatThread(Context ctx, CompanyOrgUnitInfo cou, PeriodInfo currentPeriodInfo, CostComputeRportHeaderInfo reportHeaderInfo, String processId, Map<String, String> entryMap) {
            this.ctx = ctx;
            this.cou = cou;
            this.currentPeriodInfo = currentPeriodInfo;
            this.reportHeaderInfo = reportHeaderInfo;
            this.processId = processId;
            this.entryMap = entryMap;
        }

        public Object call() throws Exception {
            OneKeyCalculateFacadeControllerBean.this.calcRankMat(this.ctx, this.cou, this.currentPeriodInfo, this.reportHeaderInfo, this.processId, this.entryMap);
            return null;
        }
    }

    class CalcUsualMatThread
    extends Thread
    implements Callable {
        Context ctx;
        String companyId;
        String calcUsualMatNode;
        String reportHeaderId;

        public CalcUsualMatThread(Context ctx, String companyId, String reportHeaderId, String calcUsualMatNode) {
            this.ctx = ctx;
            this.companyId = companyId;
            this.calcUsualMatNode = calcUsualMatNode;
            this.reportHeaderId = reportHeaderId;
        }

        public Object call() throws Exception {
            OneKeyCalculateFacadeControllerBean.this.doNormalMaterial(this.ctx, this.companyId, this.reportHeaderId, this.calcUsualMatNode);
            return null;
        }
    }

    class OutCalcThread
    implements Callable {
        Context ctx;
        AccountType accountType;
        CalcRankCollection calcColl;
        OneKeyCalculateParams params;
        String processEntryId;

        public OutCalcThread(Context ctx, AccountType accountType, CalcRankCollection calcColl, OneKeyCalculateParams params, String processEntryId) throws CloneNotSupportedException {
            this.ctx = ctx;
            this.accountType = accountType;
            this.calcColl = calcColl;
            this.params = params;
            this.processEntryId = processEntryId;
        }

        public Object call() throws Exception {
            OneKeyCalculateProcessHelper.setPocessEntryStart(this.ctx, this.processEntryId);
            try {
                if (this.accountType == AccountType.ADD_AVERAGE) {
                    OneKeyCalculateParams.accountTypeThreadLocal.set(AccountType.ADD_AVERAGE);
                    OneKeyAvgAndSpecialCalculate avgCalc = new OneKeyAvgAndSpecialCalculate();
                    avgCalc.calculate(this.ctx, this.calcColl.getAvgList(), this.params);
                } else if (this.accountType == AccountType.SPECIAL_ACCT) {
                    OneKeyCalculateParams.accountTypeThreadLocal.set(AccountType.SPECIAL_ACCT);
                    OneKeyAvgAndSpecialCalculate specialCalc = new OneKeyAvgAndSpecialCalculate();
                    specialCalc.calculate(this.ctx, this.calcColl.getSpecialList(), this.params);
                } else if (this.accountType == AccountType.FIN_FOUT) {
                    OneKeyCalculateParams.accountTypeThreadLocal.set(AccountType.FIN_FOUT);
                    OneKeyFIFOCalculate fifoCalc = new OneKeyFIFOCalculate();
                    fifoCalc.calculate(this.ctx, this.calcColl.getFifoList(), this.params);
                } else if (this.accountType == AccountType.MOVE_WEIGHTED_AVERAGE) {
                    OneKeyCalculateParams.accountTypeThreadLocal.set(AccountType.MOVE_WEIGHTED_AVERAGE);
                    OneKeyMovingAverageCalaulte mavgCalc = new OneKeyMovingAverageCalaulte();
                    mavgCalc.calculate(this.ctx, this.calcColl.getMovingAvgList(), this.params);
                }
                OneKeyCalculateProcessHelper.setProcessEntrySucess(this.ctx, this.processEntryId);
            }
            catch (Exception e) {
                OneKeyCalculateProcessHelper.setProcessExceptionState(this.ctx, this.processEntryId);
                throw new BOSException((Throwable)e);
            }
            finally {
                OneKeyCalculateParams.accountTypeThreadLocal.remove();
            }
            return null;
        }
    }

    class InCalcThread
    implements Callable {
        CalcRankCollection calcColl;
        Context ctx;
        String companyId;
        int inCalcType;
        String processEntryId;
        String rankTempTbl;
        PeriodInfo currentPeriodInfo;

        public InCalcThread(Context ctx, CalcRankCollection calcColl, String companyId, int inCalcType, String processEntryId, String rankTempTbl, PeriodInfo currentPeriodInfo) {
            this.ctx = ctx;
            this.calcColl = calcColl;
            this.companyId = companyId;
            this.inCalcType = inCalcType;
            this.processEntryId = processEntryId;
            this.rankTempTbl = rankTempTbl;
            this.currentPeriodInfo = currentPeriodInfo;
        }

        public Object call() throws BOSException {
            try {
                OneKeyCalculateProcessHelper.setPocessEntryStart(this.ctx, this.processEntryId);
                List calcInList = null;
                if (this.inCalcType == 1) {
                    calcInList = this.calcColl.getMatAssembleInList();
                } else if (this.inCalcType == 2) {
                    calcInList = this.calcColl.getMatChangeInList();
                } else if (this.inCalcType == 3) {
                    calcInList = this.calcColl.getDevInList();
                }
                OneKeyCalcInCalculate calcInCalculate = new OneKeyCalcInCalculate(this.ctx, this.companyId, this.processEntryId, calcInList, this.inCalcType, this.rankTempTbl, this.currentPeriodInfo, this.calcColl.getCurrentRank());
                calcInCalculate.calculate();
                OneKeyCalculateProcessHelper.setProcessEntrySucess(this.ctx, this.processEntryId);
                return null;
            }
            catch (Exception e) {
                OneKeyCalculateProcessHelper.setProcessExceptionState(this.ctx, this.processEntryId);
                throw new BOSException((Throwable)e);
            }
        }
    }

    class CalcRankCollection {
        int currentRank = -1;
        List avgList = new ArrayList();
        List specialList = new ArrayList();
        List fifoList = new ArrayList();
        List movingAvgList = new ArrayList();
        List<CalculateUnitInfo> matChangeInList = new ArrayList<CalculateUnitInfo>();
        List<CalculateUnitInfo> matAssembleInList = new ArrayList<CalculateUnitInfo>();
        List<CalculateUnitInfo> devInList = new ArrayList<CalculateUnitInfo>();

        CalcRankCollection() {
        }

        public List getAvgList() {
            return this.avgList;
        }

        public List getSpecialList() {
            return this.specialList;
        }

        public List getFifoList() {
            return this.fifoList;
        }

        public List getMovingAvgList() {
            return this.movingAvgList;
        }

        public List getMatChangeInList() {
            return this.matChangeInList;
        }

        public List getMatAssembleInList() {
            return this.matAssembleInList;
        }

        public void setMatChangeInList(ArrayList matChangeInList) {
            this.matChangeInList = matChangeInList;
        }

        public void setMatAssembleInList(ArrayList matAssembleInList) {
            this.matAssembleInList = matAssembleInList;
        }

        public List getDevInList() {
            return this.devInList;
        }

        public void setDevInList(List devInList) {
            this.devInList = devInList;
        }

        public int getCurrentRank() {
            return this.currentRank;
        }

        public void setCurrentRank(int currentRank) {
            this.currentRank = currentRank;
        }
    }
}

