/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateFacadeFactory;
import com.kingdee.eas.scm.cal.onekey.app.help.OneKeyCalculateProcessHelper;
import com.kingdee.eas.scm.util.app.CheckVoucherUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OneKeyCalculateHandler
implements IJobHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Job job) throws Exception {
        Object var11_11;
        Context ctx = job.getContext();
        JobParam jobParam = (JobParam)job.getParameters();
        Map params = (Map)jobParam.getBizParam();
        String companyId = (String)params.get("companyId");
        CompanyOrgUnitInfo cou = new CompanyOrgUnitInfo();
        cou.setId(BOSUuid.read((String)companyId));
        String operateType = jobParam.getJobNumber() + "OneKeyCal";
        boolean isCloseAccount = false;
        try {
            ctx.put((Object)"UserInfo", params.get("CURRENT_USER"));
            ctx.put((Object)OrgType.Company, params.get("CURRENT_COMPANY"));
            ctx.put((Object)OrgType.ControlUnit, params.get("CURRENT_CU"));
            ctx.setLocale(jobParam.getLocale());
            String processId = (String)params.get("processId");
            Map entryMap = (Map)params.get("entryMap");
            try {
                if (!StringUtils.isEmpty((String)job.getId())) {
                    OneKeyCalculateProcessHelper.updateProcessJobId(ctx, processId, job.getId());
                }
                if (CheckVoucherUtil.isCheckVoucherAndCal((Context)ctx)) {
                    IRowSet row = CheckVoucherUtil.checkGenVoucher((Context)ctx, (String)companyId, (boolean)false);
                    if (row.size() > 0) {
                        StringBuffer msg = new StringBuffer();
                        while (row.next()) {
                            msg.append("\n").append(row.getString("fbilltype")).append(row.getString("fnumber")).append(",").append(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"operatorInfo", (Locale)ctx.getLocale())).append(row.getString("fuser"));
                        }
                        throw new CalculateException(CalculateException.IS_GEN_VOUCHER_EXCEPTION, new Object[]{msg});
                    }
                    EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"insertGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, List.class, String.class, String.class, String.class}, (Object[])new Object[]{ctx, companyId, null, null, null, ctx.getUserName(), operateType}, (int)3);
                }
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)companyId));
                isCloseAccount = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).isClosed(SystemEnum.INVENTORYMANAGEMENT, company);
                if (!isCloseAccount) {
                    this.doneCloseAccount(ctx, company);
                }
                HashMap<String, Object> calParam = new HashMap<String, Object>();
                calParam.put("companyId", companyId);
                calParam.put("processId", processId);
                calParam.put("entryMap", entryMap);
                calParam.put("isReCalRank", params.get("isReCalRank"));
                calParam.put("isCalUsualMat", params.get("isCalUsualMat"));
                OneKeyCalculateFacadeFactory.getLocalInstance(ctx).costCalcByRank(calParam);
                OneKeyCalculateProcessHelper.setProcessSuccessState(ctx, processId);
            }
            catch (Exception e) {
                OneKeyCalculateProcessHelper.setProcessExceptionState(ctx, processId);
                throw e;
            }
            var11_11 = null;
        }
        catch (Throwable throwable) {
            if (!isCloseAccount && cou != null && cou.getId() != null) {
                this.doneReverCloseAccount(ctx, cou);
            }
            PerfSepServerUtils.updateTaskState((Job)job);
            EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, companyId, null, operateType}, (int)3);
            throw throwable;
        }
        if (!isCloseAccount && cou != null && cou.getId() != null) {
            this.doneReverCloseAccount(ctx, cou);
        }
        PerfSepServerUtils.updateTaskState((Job)job);
        EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, companyId, null, operateType}, (int)3);
        return var11_11;
    }

    private void doneCloseAccount(Context ctx, CompanyOrgUnitInfo cou) throws EASBizException, BOSException {
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        iSystemStatusCtrol.close(SystemEnum.INVENTORYMANAGEMENT, cou, true);
    }

    private void doneReverCloseAccount(Context ctx, CompanyOrgUnitInfo cou) throws EASBizException, BOSException {
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        iSystemStatusCtrol.close(SystemEnum.INVENTORYMANAGEMENT, cou, false);
    }
}

