/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalTaskStateEnum;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessEntryCollection;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessEntryInfo;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessFactory;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessInfo;
import com.kingdee.eas.scm.cal.onekey.app.AbstractOneKeyCalculateProcessControllerBean;
import com.kingdee.eas.scm.cal.onekey.app.help.OneKeyCalculateProcessHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OneKeyCalculateProcessControllerBean
extends AbstractOneKeyCalculateProcessControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.onekey.app.OneKeyCalculateProcessControllerBean");
    private static final String ONEKEYRESOURCE = "com.kingdee.eas.scm.cal.onekey.OneKeyCalculateResource";

    @Override
    protected Map _buildProcess(Context ctx, Map params) throws BOSException, EASBizException {
        String companyId = (String)params.get("companyId");
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo periodInfo = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getCacheCurrentPeriod(2, companyId);
        this.removeOldProcess(ctx, companyId, periodInfo.getId().toString());
        OneKeyCalculateProcessInfo processInfo = new OneKeyCalculateProcessInfo();
        processInfo.setCompany(companyInfo);
        processInfo.setPeriod(periodInfo);
        processInfo.setStartTime(new Timestamp(new Date().getTime()));
        processInfo.setState(OneKeyCalTaskStateEnum.runing);
        processInfo.setName(companyInfo.getName() + EASResource.getString((String)ONEKEYRESOURCE, (String)"oneKeyCal"));
        processInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        processInfo.setIsReCalRank(new Boolean(params.get("isReCalRank").toString()));
        processInfo.setIsCalUsualMat(new Boolean(params.get("isCalUsualMat").toString()));
        String entryName = null;
        OneKeyCalculateProcessEntryInfo entryInfo = null;
        int seq = 0;
        HashMap<String, String> processEntryMap = new HashMap<String, String>();
        if (processInfo.isIsCalUsualMat()) {
            entryName = ResourceBase.getString((String)ONEKEYRESOURCE, (String)"calUsualMat", (Locale)ctx.getLocale());
            entryInfo = this.buildSpecialEntryInfo(entryName);
            entryInfo.setSeq(seq);
            processInfo.getEntry().add(entryInfo);
            processEntryMap.put("calUsualMatNode", entryInfo.getId().toString());
            ++seq;
        }
        if (processInfo.isIsReCalRank()) {
            entryName = ResourceBase.getString((String)ONEKEYRESOURCE, (String)"reCalRank", (Locale)ctx.getLocale());
            entryInfo = this.buildSpecialEntryInfo(entryName);
            entryInfo.setSeq(seq);
            processInfo.getEntry().add(entryInfo);
            processEntryMap.put("reCalRankNode", entryInfo.getId().toString());
            ++seq;
        } else {
            OneKeyCalculateProcessEntryCollection entryCol = OneKeyCalculateProcessHelper.buildEntryCollByRankTable(ctx, companyId, periodInfo, seq, processEntryMap);
            processInfo.getEntry().addCollection(entryCol);
        }
        IObjectPK id = OneKeyCalculateProcessFactory.getLocalInstance(ctx).addnew(processInfo);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("processId", id.toString());
        result.put("entryMap", processEntryMap);
        return result;
    }

    private OneKeyCalculateProcessEntryInfo buildSpecialEntryInfo(String entryName) {
        OneKeyCalculateProcessEntryInfo entryInfo = new OneKeyCalculateProcessEntryInfo();
        entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        entryInfo.setName(entryName);
        entryInfo.setState(OneKeyCalTaskStateEnum.notStart);
        entryInfo.setTotalCount(0);
        entryInfo.setProcessRate(0);
        return entryInfo;
    }

    private void removeOldProcess(Context ctx, String companyId, String periodId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)periodId));
        this._delete(ctx, filter);
    }
}

