/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.scm.cal.app.help.InventoryBillHelp;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;

public class OneKeyCalculateTempTableManager {
    private String inOutBillTemp;
    private String costMoveOutTemp;
    private String calUnitTemp;
    private String writeOffTemp;
    private String reqTemp;

    public String getReqTemp() {
        return this.reqTemp;
    }

    public void createReqTempTable(Context ctx) throws BOSException {
        String[][] fields = new String[][]{{"FEntryId", "varchar(44)"}, {"FMaterialId", "varchar(44)"}, {"FQty", "Numeric(21, 8)"}, {"FBaseQty", "Numeric(21, 8)"}, {"FUnitActualCost", "Numeric(28, 16)"}, {"FActualCost", "Numeric(21, 8)"}};
        this.reqTemp = KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateSQl(fields));
    }

    public String getWriteOffTemp() {
        return this.writeOffTemp;
    }

    public String getInOutBillTemp() {
        return this.inOutBillTemp;
    }

    public void initTempTables(Context ctx) throws BOSException {
        this.createInOutBillTempTable(ctx);
        this.createCalUnitTempTable(ctx);
        this.createWriteOffTempTable(ctx);
        this.createCostMoveInTempTable(ctx);
    }

    public void releaseTempTables(Context ctx) throws BOSException {
        KsqlUtil.releaseTempTable((Context)ctx, (String)this.calUnitTemp);
        KsqlUtil.releaseTempTable((Context)ctx, (String)this.writeOffTemp);
        KsqlUtil.releaseTempTable((Context)ctx, (String)this.inOutBillTemp);
        KsqlUtil.releaseTempTable((Context)ctx, (String)this.costMoveOutTemp);
    }

    private void createWriteOffTempTable(Context ctx) throws BOSException {
        this.writeOffTemp = KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateSQl(InventoryBillHelp.getWriteOffTableFields()));
        KsqlUtil.createTempTableIndex((Context)ctx, (String)this.writeOffTemp, (String)"FID", (boolean)true, (boolean)false);
        KsqlUtil.createTempTableIndex((Context)ctx, (String)this.writeOffTemp, (String)"FBillEntryID,FBillID", (boolean)false, (boolean)false);
    }

    private void createCostMoveInTempTable(Context ctx) throws BOSException {
        this.costMoveOutTemp = KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateSQl(InventoryBillHelp.getFIFOTableFields()));
        KsqlUtil.createTempTableIndex((Context)ctx, (String)this.costMoveOutTemp, (String)"FSTOCKTRANSBILLENTRYID", (boolean)false, (boolean)false);
    }

    private void createCalUnitTempTable(Context ctx) throws BOSException {
        StringBuilder createSql = new StringBuilder();
        createSql.append(" CREATE TABLE TEMP (");
        createSql.append(" FMATERIALID VARCHAR(44),");
        createSql.append(" FCOMPANYORGUNITID VARCHAR(44),");
        createSql.append(" FSTORAGEORGUNITID VARCHAR(44),");
        createSql.append(" FWAREHOUSEID VARCHAR(44),");
        createSql.append(" FLOT NVARCHAR(255),");
        createSql.append(" FASSISTPROPERTYID VARCHAR(255),");
        createSql.append(" FPROJECTID VARCHAR(255),");
        createSql.append(" FTRACKNUMBERID VARCHAR(255))");
        this.calUnitTemp = KsqlUtil.createTempTable((Context)ctx, (String)createSql.toString());
        KsqlUtil.createTempTableIndex((Context)ctx, (String)this.calUnitTemp, (String)"FMATERIALID,FSTORAGEORGUNITID,FWAREHOUSEID,FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID", (boolean)true);
    }

    public String getCalUnitTemp() {
        return this.calUnitTemp;
    }

    private void createInOutBillTempTable(Context ctx) throws BOSException {
        this.inOutBillTemp = KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateSQl(InventoryBillHelp.getFIFOTableFields()));
        KsqlUtil.createTempTableIndex((Context)ctx, (String)this.inOutBillTemp, (String)"FID", (boolean)true, (boolean)false);
        KsqlUtil.createTempTableIndex((Context)ctx, (String)this.inOutBillTemp, (String)"FENTRYTABLEMAME,FFIVOUCHERED", (boolean)false, (boolean)false);
        KsqlUtil.createTempTableIndex((Context)ctx, (String)this.inOutBillTemp, (String)"FBillEntryId,FBillId,FSOURCEBILLENTRYID", (boolean)false, (boolean)false);
        KsqlUtil.createTempTableIndex((Context)ctx, (String)this.inOutBillTemp, (String)"FMaterialID,FCompanyOrgUnitID", (boolean)false, (boolean)false);
    }

    public void clearInOutBillTempTable(Context ctx) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" truncate table ").append(this.inOutBillTemp);
        KsqlUtil.execute((Context)ctx, (String)sql.toString());
    }

    public String getCreateSQl(String[][] fields) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append("TempTableName");
        sql.append("(");
        for (int i = 0; i < fields.length; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append(fields[i][0]);
            sql.append(" ");
            sql.append(fields[i][1]);
        }
        sql.append(")");
        return sql.toString();
    }

    public String getCostMoveOutTemp() {
        return this.costMoveOutTemp;
    }
}

