/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app.calculateimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostComputeReportPriceSourceCollection;
import com.kingdee.eas.scm.cal.CostComputeReportPriceSourceInfo;
import com.kingdee.eas.scm.cal.PriceSourEnum;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.onekey.CalculateUnitInfo;
import com.kingdee.eas.scm.cal.onekey.OneKeyBalanceCostInfo;
import com.kingdee.eas.scm.cal.onekey.OneKeyBillCostInfo;
import com.kingdee.eas.scm.cal.onekey.app.OneKeyCalculateParams;
import com.kingdee.eas.scm.cal.onekey.app.calculateimp.AbstractOneKeyCalculate;
import com.kingdee.eas.scm.cal.onekey.app.calculateimp.OneKeyUpdateBillCostHelper;
import com.kingdee.eas.scm.cal.onekey.app.help.OneKeyCalculateHelper;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OneKeyAvgAndSpecialCalculate
extends AbstractOneKeyCalculate {
    private static final String res = "com.kingdee.eas.scm.cal.CALAutoGenerateResource";
    private Logger logger = Logger.getLogger(OneKeyAvgAndSpecialCalculate.class);
    private Map<String, Set> entrustMaterialIdMap = null;
    private List entrustBillList = null;

    @Override
    public void calculateStrategy(Context ctx, CalculateUnitInfo calculateUnitInfo) throws EASBizException, BOSException {
        OneKeyUpdateBillCostHelper updateBillCostHelper = null;
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            updateBillCostHelper = new OneKeyUpdateBillCostHelper(con);
            HashMap balanceMap = null;
            this.checkInterrupted();
            if (5 == ((AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get()).getValue()) {
                balanceMap = this.handleLotCalculate(ctx, calculateUnitInfo, con);
            } else if (3 == ((AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get()).getValue()) {
                balanceMap = this.handleAvgCalculate(ctx, calculateUnitInfo, con);
            }
            if (balanceMap != null) {
                List outBillList = (List)balanceMap.get("OUTBILLLIST");
                updateBillCostHelper.updateBills((List)balanceMap.get("INBILLNEEDUPDATED"), balanceMap);
                updateBillCostHelper.updateBills(outBillList, balanceMap);
                this.checkInterrupted();
                this.handleReport(ctx, balanceMap);
                if (this.calParams.getCalcResulteTbl() != null && outBillList != null && !outBillList.isEmpty()) {
                    for (int i = outBillList.size() - 1; i >= 0; --i) {
                        if (((OneKeyBillCostInfo)outBillList.get(i)).getFiVouchered() != 0) continue;
                        this.insertCalcResultInfo(ctx, (OneKeyBillCostInfo)outBillList.get(i), this.calParams.getCalcResulteTbl());
                        break;
                    }
                }
            }
            updateBillCostHelper.executeBatch(true);
            this.checkInterrupted();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            updateBillCostHelper.close();
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void handleReport(Context ctx, HashMap balanceMap) throws EASBizException, BOSException {
        if (!this.calParams.isWriteReport()) {
            return;
        }
        Map keyExceptionStateMap = null;
        if (this.calParams.isOnlyWriteExpReport()) {
            keyExceptionStateMap = this.getKeyExceptionState(balanceMap);
        }
        this.addOneKeyReportInfo(ctx, (List)balanceMap.get("INBILLLIST"), keyExceptionStateMap);
        this.addOneKeyReportInfo(ctx, (List)balanceMap.get("OUTBILLLIST"), keyExceptionStateMap);
        this.addOneKeyPeriodEndReportInfo(ctx, balanceMap);
        this.addOneKeyReportInfo(ctx, this.entrustBillList, keyExceptionStateMap);
        this.entrustBillList = null;
    }

    private void addOneKeyPeriodEndReportInfo(Context ctx, HashMap balanceMap) {
        Date now = new Date();
        boolean isOnlyWriteExpRpt = this.calParams.isOnlyWriteExpReport();
        AccountType accountType = (AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get();
        String calType = this.calParams.getCalType();
        Iterator iter = balanceMap.entrySet().iterator();
        OneKeyBalanceCostInfo balInfo = null;
        OneKeyBillCostInfo billInfo = null;
        Timestamp createTime = null;
        String costMoveCycle = (String)balanceMap.get("costMoveCycle");
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getKey().equals("CostPriceMove__") || entry.getKey().equals("INBILLLIST") || entry.getKey().equals("OUTBILLLIST") || entry.getKey().equals("INBILLNEEDUPDATED") || entry.getKey().equals("costMoveCycle") || entry.getValue() instanceof HashMap) continue;
            CostComputeReportPriceSourceInfo reportInfo = new CostComputeReportPriceSourceInfo();
            reportInfo.setParent(this.calParams.getReportHeaderInfo());
            balInfo = (OneKeyBalanceCostInfo)entry.getValue();
            billInfo = balInfo.getReusltBillInfo();
            OneKeyCalculateHelper.calculateAvgPrice(billInfo);
            if (!OneKeyCalculateHelper.isEffectBalance(billInfo, calType) || isOnlyWriteExpRpt && !billInfo.isExceptionState()) continue;
            String intComment = "";
            String outComment = "";
            String balanceCommnet = "";
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(BOSUuid.read((String)billInfo.getCompanyOrgUnitId()));
            reportInfo.setCompanyOrgUnit(companyInfo);
            PeriodInfo periodInfo = this.calParams.getPeriodInfo();
            reportInfo.setYear(periodInfo.getPeriodYear());
            reportInfo.setPeriod(periodInfo.getPeriodNumber());
            if (!StringUtil.isEmpty((String)billInfo.getStorageOrgUnitId())) {
                StorageOrgUnitInfo storageInfo = new StorageOrgUnitInfo();
                storageInfo.setId(BOSUuid.read((String)billInfo.getStorageOrgUnitId()));
                reportInfo.setStorageOrgUnit(storageInfo);
            }
            if (!StringUtil.isEmpty((String)billInfo.getWarehouseId())) {
                WarehouseInfo warehouseInfo = new WarehouseInfo();
                warehouseInfo.setId(BOSUuid.read((String)billInfo.getWarehouseId()));
                reportInfo.setWarehouse(warehouseInfo);
            }
            if (!StringUtil.isEmpty((String)billInfo.getMaterialId())) {
                MaterialInfo materialInfo = new MaterialInfo();
                materialInfo.setId(BOSUuid.read((String)billInfo.getMaterialId()));
                reportInfo.setMaterial(materialInfo);
            }
            reportInfo.setAccountType((AccountType)OneKeyCalculateParams.accountTypeThreadLocal.get());
            if (accountType == AccountType.SPECIAL_ACCT) {
                if (!StringUtil.isEmpty((String)billInfo.getLot())) {
                    reportInfo.setLot(billInfo.getLot());
                }
                if (!StringUtil.isEmpty((String)billInfo.getAssistPropertyId())) {
                    AsstAttrValueInfo assPropInfo = new AsstAttrValueInfo();
                    assPropInfo.setId(BOSUuid.read((String)billInfo.getAssistPropertyId()));
                    reportInfo.setAssistProperty(assPropInfo);
                }
                if (!StringUtil.isEmpty((String)billInfo.getProjectId())) {
                    ProjectInfo projectInfo = new ProjectInfo();
                    projectInfo.setId(BOSUuid.read((String)billInfo.getProjectId()));
                    reportInfo.setProject(projectInfo);
                }
                if (!StringUtil.isEmpty((String)billInfo.getTrackNumberId())) {
                    TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
                    trackNumberInfo.setId(BOSUuid.read((String)billInfo.getTrackNumberId()));
                    reportInfo.setTrackNumber(trackNumberInfo);
                }
            }
            int state = billInfo.isExceptionState() || billInfo.isZeroPrice() || billInfo.isNegativePrice() ? 2 : 1;
            reportInfo.setState(state);
            reportInfo.setBillName(billInfo.getBillTypeName());
            reportInfo.setBillNumber(billInfo.getBillNumber());
            StringBuffer buffer = RecentCostHelp.takeAmountQytPriceDesc(billInfo.getRecentCost(), billInfo.getRecentQty(), billInfo.getPrice());
            balanceCommnet = buffer.toString();
            int i = 1;
            if (billInfo.isNegativePrice()) {
                balanceCommnet = balanceCommnet + "\n" + i + ". " + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COSTNEGATIVE_RXCEPTION", (Context)ctx);
                ++i;
            }
            if (billInfo.isZeroPrice()) {
                balanceCommnet = balanceCommnet + "\n" + i + ". " + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COSTZERO_EXCEPTION", (Context)ctx);
                ++i;
            }
            if (billInfo.isExceptionState()) {
                balanceCommnet = balanceCommnet + "\n" + i + ". " + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SettleAccounts_Exception", (Context)ctx);
                ++i;
            }
            reportInfo.setSettleAccounts(balanceCommnet);
            reportInfo.setCalculateKind(billInfo.getCalculateKind());
            reportInfo.setTimeSerialNumber("9999999999999");
            reportInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            createTime = new Timestamp(now.getTime());
            if (accountType == AccountType.ADD_AVERAGE || accountType == AccountType.SPECIAL_ACCT) {
                createTime = new Timestamp(billInfo.getBizDate().getTime() + 1000L);
            }
            reportInfo.setCreateTime(createTime);
            reportInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            ((CostComputeReportPriceSourceCollection)((Object)this.reportColLocal.get())).add(reportInfo);
            if (StringUtil.isEmpty((String)costMoveCycle)) continue;
            reportInfo = new CostComputeReportPriceSourceInfo();
            reportInfo.setParent(this.calParams.getReportHeaderInfo());
            reportInfo.setBillNumber(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"costMoveCycle", (Context)ctx));
            reportInfo.setSettleAccounts(costMoveCycle);
            createTime = new Timestamp(billInfo.getBizDate().getTime() + 1010L);
            reportInfo.setCreateTime(createTime);
            ((CostComputeReportPriceSourceCollection)((Object)this.reportColLocal.get())).add(reportInfo);
        }
    }

    @Override
    protected void beforeCalculate(Context ctx) throws BOSException, EASBizException {
        super.beforeCalculate(ctx);
        this.getEntrustMaterial(ctx);
    }

    @Override
    protected void afterCalculate(Context ctx) throws BOSException, EASBizException {
        super.afterCalculate(ctx);
        if (this.entrustMaterialIdMap != null) {
            this.entrustMaterialIdMap.clear();
        }
    }

    private void getEntrustMaterial(Context ctx) throws BOSException {
        if ("0".equals(this.calParams.getNotCalConsignSale())) {
            return;
        }
        String strCalType = this.calParams.getCalType();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        String companyId = this.calParams.getCompanyInfo().getId().toString();
        String inOutBilltemp = this.tempManager.getInOutBillTemp();
        Set<String> entrustMaterialIdSet = new HashSet();
        this.entrustMaterialIdMap = new HashMap<String, Set>();
        StringBuffer sql = new StringBuffer();
        sql.append("select DISTINCT ENTRY.FMATERIALID as FMATERIALID, ENTRY.FCOMPANYORGUNITID as FCOMPANYORGUNITID,");
        sql.append(" ENTRY.FSTORAGEORGUNITID as FSTORAGEORGUNITID,ENTRY.FWAREHOUSEID as FWAREHOUSEID, MATERIALCOMPANY.FACCOUNTTYPE as FACCOUNTTYPE,");
        sql.append(" (case when MATERIALCOMPANY.FIsLot = 1 then isnull(ENTRY.FLot,'X') else null end) AS FLOT,");
        sql.append(" (case when MATERIALCOMPANY.FIsAssistProperty = 1 then isnull(ENTRY.FAssistPropertyID,'X') else null end) AS FAssistPropertyID, ");
        sql.append("(case when MATERIALCOMPANY.FIsProject = 1  then isnull(ENTRY.FProjectID,'X') else null end) AS FProjectID, ");
        sql.append("(case when MATERIALCOMPANY.FIsTrackNumber = 1  then isnull(ENTRY.FTrackNumberID,'X') else null end) AS FTrackNumberID");
        sql.append(" from T_IM_SALEISSUEENTRY ENTRY").append("\t\n");
        sql.append(" INNER JOIN T_IM_SALEISSUEBILL BILL on BILL.fid = ENTRY.fparentid").append("\t\n");
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY  ON (ENTRY.FMaterialId = MATERIALCOMPANY.FMaterialID ");
        sql.append("\t AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )");
        sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID ").append("\t\n");
        sql.append(" INNER JOIN T_IM_StoreType StoreTypePre ON InvUpdateType.FStoreTypePreID = StoreTypePre.FID ").append("\t\n");
        sql.append(" LEFT JOIN T_IM_StoreType StoreType ON InvUpdateType.FStoreTypeID = StoreType.FID ").append("\t\n");
        sql.append(" WHERE BILL.FYEAR = ").append(periodInfo.getPeriodYear()).append("\t\n");
        sql.append(" AND BILL.FPERIOD = ").append(periodInfo.getPeriodNumber()).append("\t\n");
        sql.append(" AND ENTRY.FBIZDATE >= to_date('").append(periodInfo.getBeginDate()).append("')").append("\t\n");
        sql.append(" AND ENTRY.FBIZDATE <= to_date('").append(periodInfo.getEndDate()).append("')").append("\t\n");
        sql.append(" AND ENTRY.FMATERIALID in ( select DISTINCT FMATERIALID from ").append(inOutBilltemp).append(" ) ").append("\t\n");
        sql.append(" AND ENTRY.FCompanyOrgUnitID = '").append(companyId).append("'");
        sql.append(" AND case when ENTRY.FQTY < 0 THEN StoreType.FID ELSE StoreTypePre.FID END ='").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("'").append("\t\n");
        sql.append(" AND BILL.FBaseStatus = ").append(4);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            StringBuffer key = new StringBuffer();
            String separator = "_$$$$_";
            String defultValue = "X";
            while (rs.next()) {
                key.setLength(0);
                key.append(rs.getString("FCOMPANYORGUNITID"));
                if ("1".equals(strCalType)) {
                    key.append(separator).append(rs.getString("FSTORAGEORGUNITID"));
                } else if ("2".equals(strCalType)) {
                    key.append(separator).append(rs.getString("FSTORAGEORGUNITID"));
                    key.append(separator).append(rs.getString("FWAREHOUSEID"));
                }
                if (5 == rs.getInt("FACCOUNTTYPE")) {
                    key.append(separator).append(rs.getString("FLOT") == null ? defultValue : rs.getString("FLOT"));
                    key.append(separator).append(rs.getString("FAssistPropertyID") == null ? defultValue : rs.getString("FAssistPropertyID"));
                    key.append(separator).append(rs.getString("FProjectID") == null ? defultValue : rs.getString("FProjectID"));
                    key.append(separator).append(rs.getString("FTrackNumberID") == null ? defultValue : rs.getString("FTrackNumberID"));
                }
                if ((entrustMaterialIdSet = this.entrustMaterialIdMap.get(rs.getString("FMATERIALID"))) == null) {
                    entrustMaterialIdSet = new HashSet();
                    this.entrustMaterialIdMap.put(rs.getString("FMATERIALID"), entrustMaterialIdSet);
                }
                entrustMaterialIdSet.add(key.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private HashMap handleAvgCalculate(Context ctx, CalculateUnitInfo calculateUnitInfo, Connection conn) throws EASBizException, BOSException, InterruptedException {
        HashMap hashMap;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String strCalType = this.calParams.getCalType();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        try {
            HashMap matAttrChgMap = new HashMap();
            ArrayList<OneKeyBillCostInfo> inBillList = new ArrayList<OneKeyBillCostInfo>();
            ArrayList<OneKeyBillCostInfo> outBillList = new ArrayList<OneKeyBillCostInfo>();
            LinkedHashMap costMoveMap = new LinkedHashMap();
            ArrayList<String> calOrder = new ArrayList<String>();
            ArrayList<OneKeyBillCostInfo> redBillList = new ArrayList<OneKeyBillCostInfo>();
            ArrayList<OneKeyBillCostInfo> revereList = new ArrayList<OneKeyBillCostInfo>();
            ArrayList<OneKeyBillCostInfo> outRetInList = new ArrayList<OneKeyBillCostInfo>();
            ArrayList<OneKeyBillCostInfo> inBillNeddUpdated = new ArrayList<OneKeyBillCostInfo>();
            HashMap prePeriodCostMoveMap = new HashMap();
            ArrayList reWorkMatReqBillList = new ArrayList();
            OneKeyBillCostInfo periodBegin = null;
            stmt = this.getBillPreparedStatement(conn, calculateUnitInfo);
            rs = this.getBillRowSet(stmt, calculateUnitInfo);
            this.checkInterrupted();
            long timeSerialNumber = new Date().getTime();
            HashMap<String, OneKeyBillCostInfo> periodBeginBillMap = new HashMap<String, OneKeyBillCostInfo>();
            while (rs.next()) {
                OneKeyBillCostInfo bill = this.convertOneKeyBillCostInfo(rs, timeSerialNumber += 10L);
                if (!calOrder.contains(bill.getKeyId())) {
                    calOrder.add(bill.getKeyId());
                }
                if (2 == bill.getCalculateKind()) {
                    if (periodBeginBillMap.get(bill.getKeyId()) == null) {
                        periodBeginBillMap.put(bill.getKeyId(), bill);
                        OneKeyCalculateHelper.calculateAvgPrice(bill);
                    } else {
                        periodBegin = (OneKeyBillCostInfo)periodBeginBillMap.get(bill.getKeyId());
                        periodBegin.setRecentCost(periodBegin.getRecentCost().add(bill.getRecentCost()));
                        periodBegin.setRecentQty(periodBegin.getRecentQty().add(bill.getRecentQty()));
                        OneKeyCalculateHelper.calculateAvgPrice(periodBegin);
                        continue;
                    }
                }
                if (bill.getFiVouchered() == 1) {
                    bill.setPriceSource(PriceSourEnum.fiVouchered);
                    bill.setDealComplete(true);
                }
                if ("1".equals(this.calParams.getNoSrcOutBillCalType()) || "1".equals(this.calParams.getSrcBillPreperiodCalType())) {
                    if (bill.isNotSrcOutRetBill() && "1".equals(this.calParams.getNoSrcOutBillCalType())) {
                        if (!bill.isDealComplete()) {
                            bill.setPriceSource(PriceSourEnum.userDefine);
                        }
                        bill.setNotUpdateCostAgain(true);
                    }
                    if (bill.isSrcOutBillInPrePeriod() && "1".equals(this.calParams.getSrcBillPreperiodCalType())) {
                        bill.setNotUpdateCostAgain(true);
                    }
                }
                if (bill.isCostPriceMove()) {
                    this.setCostMoveIsCalculate(bill);
                    this.buildCostPriceMove(bill, costMoveMap);
                    if (bill.isSrcOutBillInPrePeriod()) {
                        bill.setNeedUpdate(true);
                    }
                }
                if (bill.isMatAttrChange()) {
                    bill.setCalculate(false);
                    this.buildMatAttrChange(bill, matAttrChgMap);
                    if (!bill.isOutBill() && !bill.isDealComplete()) {
                        inBillNeddUpdated.add(bill);
                    }
                }
                if (bill.isReWork()) {
                    this.setReWorkBillCost(reWorkMatReqBillList, periodBeginBillMap, inBillNeddUpdated, bill);
                }
                if (1 != bill.getCalculateKind()) {
                    if (!bill.isCalculate()) continue;
                    if (bill.isCostPriceMove() && bill.isMoveOutBill()) {
                        outBillList.add(bill);
                        continue;
                    }
                    inBillList.add(bill);
                    continue;
                }
                if (1 != bill.getCalculateKind()) continue;
                if (bill.isRedBill()) {
                    if (bill.isNotSrcOutRetBill() && "1".equals(this.calParams.getNoSrcOutBillCalType()) || bill.isSrcOutBillInPrePeriod() && "1".equals(this.calParams.getSrcBillPreperiodCalType())) {
                        inBillList.add(bill);
                        outRetInList.add(bill);
                        bill.setOutRetBillisIn(true);
                    } else {
                        if (bill.isReversed()) {
                            revereList.add(bill);
                        } else {
                            outBillList.add(bill);
                        }
                        redBillList.add(bill);
                    }
                    if (!bill.isSrcOutBillInPrePeriod() || bill.isDealComplete()) continue;
                    inBillNeddUpdated.add(bill);
                    bill.setPriceSource(PriceSourEnum.sourBillPrice);
                    bill.setNeedUpdate(true);
                    continue;
                }
                if (bill.isReversed()) {
                    revereList.add(bill);
                    continue;
                }
                bill.setCanAdjustDiffer(true);
                outBillList.add(bill);
            }
            this.checkInterrupted();
            this.getCostMoveInBillByIssue(conn, prePeriodCostMoveMap, costMoveMap, timeSerialNumber, periodInfo);
            this.checkInterrupted();
            HashMap costMoveCycleMap = new HashMap();
            this.updateToPrePeriodCostMovePrice(prePeriodCostMoveMap, costMoveMap, inBillNeddUpdated);
            this.handleReversedInList(inBillList, outBillList, revereList, outRetInList);
            this.checkInterrupted();
            HashMap balanceMap = this.calculateOutBillCost(ctx, inBillList, outBillList, redBillList, reWorkMatReqBillList, calculateUnitInfo, costMoveMap, null, calOrder, conn);
            this.checkInterrupted();
            this.updateMoveLocationBill(ctx, balanceMap, calOrder, calculateUnitInfo);
            balanceMap.put("INBILLNEEDUPDATED", inBillNeddUpdated);
            balanceMap.putAll(costMoveCycleMap);
            this.calMatAttrChangeCost(matAttrChgMap);
            this.checkInterrupted();
            hashMap = balanceMap;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return hashMap;
    }

    private void setReWorkBillCost(ArrayList reWorkMatReqBillList, HashMap periodBeginBillMap, List inBillNeddUpdated, OneKeyBillCostInfo bill) {
        OneKeyBillCostInfo periodBegin = null;
        if ("1".equals(this.calParams.getReworkCostType())) {
            bill.setCalculate(false);
            if (bill.getFiVouchered() != 1 && !bill.isExistSrcBill()) {
                periodBegin = (OneKeyBillCostInfo)periodBeginBillMap.get(bill.getKeyId());
                if (periodBegin != null) {
                    bill.setPrice(periodBegin.getPrice());
                    bill.setPriceSource(PriceSourEnum.periodBeginPriceReWork);
                }
                bill.setRecentCost(bill.getRecentQty().multiply(bill.getPrice()).setScale(bill.getBaseCurrencyPrecision(), 4));
                inBillNeddUpdated.add(bill);
                bill.setNeedUpdate(true);
            }
            reWorkMatReqBillList.add(bill);
        } else if ("0".equals(this.calParams.getReworkCostType())) {
            bill.setCalculate(false);
            if (bill.getFiVouchered() != 1 && !bill.isExistSrcBill()) {
                bill.setPriceSource(PriceSourEnum.userDefine);
                bill.setDealComplete(true);
            }
            reWorkMatReqBillList.add(bill);
        }
    }

    private void handleReversedInList(List inBillList, List outBillList, List reversedList, List outRetInList) {
        OneKeyBillCostInfo reversedInfo;
        int size = outRetInList.size();
        for (int i = 0; i < size; ++i) {
            OneKeyBillCostInfo outRetInfo = (OneKeyBillCostInfo)outRetInList.get(i);
            for (int j = reversedList.size() - 1; j >= 0; --j) {
                reversedInfo = (OneKeyBillCostInfo)reversedList.get(j);
                if (!outRetInfo.getBillEntryId().equals(reversedInfo.getSourceBillEntryId())) continue;
                inBillList.add(reversedInfo);
                reversedInfo.setOutRetBillisIn(true);
                reversedList.remove(j);
            }
        }
        int listSize = reversedList.size();
        for (int k = 0; k < listSize; ++k) {
            reversedInfo = (OneKeyBillCostInfo)reversedList.get(k);
            if (!reversedInfo.isSrcBillInPrePeriod()) continue;
            reversedInfo.setNeedUpdate(true);
        }
        if (reversedList.size() > 0) {
            outBillList.addAll(reversedList);
        }
    }

    private HashMap calculateOutBillCost(Context ctx, List inBillList, List outBillList, List redBillList, List reWorkMatReqBillList, CalculateUnitInfo calUnitInfo, HashMap costMoveMap, HashMap matChangeMap, ArrayList orderList, Connection conn) throws BOSException, CalculateException {
        HashMap<String, HashMap> balanceMap = new HashMap<String, HashMap>();
        String keyId = null;
        HashMap noCalInList = new HashMap();
        int listSize = orderList.size();
        for (int k = 0; k < listSize; ++k) {
            keyId = (String)orderList.get(k);
            this.calCostMoveBill(costMoveMap, keyId);
            this.calInBillAvgPrice(ctx, inBillList, balanceMap, costMoveMap, keyId, noCalInList, matChangeMap);
            this.handleReWorkUnitCost(balanceMap, reWorkMatReqBillList, keyId);
            this.calOutBillCost(ctx, outBillList, redBillList, balanceMap, costMoveMap, keyId, calUnitInfo, conn);
            this.handleDetailDiff(outBillList, balanceMap, keyId);
            this.setExceptionState(balanceMap, keyId);
        }
        balanceMap.put("CostPriceMove__", costMoveMap);
        this.setBalanceResultInfo(costMoveMap, noCalInList, balanceMap);
        return balanceMap;
    }

    private void calInBillAvgPrice(Context ctx, List inBillList, HashMap balanceMap, HashMap costMoveMap, String keyId, HashMap noCalInListBillCost, HashMap matChangeMap) {
        OneKeyBillCostInfo bill = null;
        OneKeyBalanceCostInfo balanceCostInfo = null;
        OneKeyBillCostInfo tmpInfo = null;
        HashMap noCalInListBillQty = null;
        HashMap noCalMatChageInBill = null;
        List<OneKeyBillCostInfo> matChangeInList = null;
        Set keySet = null;
        String strCalType = this.calParams.getCalType();
        if (matChangeMap != null) {
            keySet = matChangeMap.keySet();
        }
        noCalMatChageInBill = balanceMap.get("noCalMatChageInBill") == null ? new HashMap() : (HashMap)balanceMap.get("noCalMatChageInBill");
        noCalInListBillQty = balanceMap.get("noCalInListBillQty") == null ? new HashMap() : (HashMap)balanceMap.get("noCalInListBillQty");
        BigDecimal tempRecentQty = null;
        int listSize = inBillList.size();
        for (int i = 0; i < listSize; ++i) {
            bill = (OneKeyBillCostInfo)inBillList.get(i);
            tempRecentQty = BigDecimal.ZERO;
            if (!keyId.equals(bill.getKeyId())) continue;
            if (keySet != null && bill.getSourceBillEntryId() != null && keySet.contains(bill.getSourceBillEntryId())) {
                if (noCalMatChageInBill.get(keyId) == null) {
                    matChangeInList = new ArrayList();
                    noCalMatChageInBill.put(keyId, matChangeInList);
                } else {
                    matChangeInList = (List)noCalMatChageInBill.get(keyId);
                }
                matChangeInList.add(bill);
                continue;
            }
            balanceCostInfo = (OneKeyBalanceCostInfo)balanceMap.get(keyId);
            if (balanceCostInfo == null) {
                balanceCostInfo = this.createNewBalanceCostInfo(ctx, strCalType, bill);
                balanceMap.put(keyId, balanceCostInfo);
            }
            if ((tmpInfo = balanceCostInfo.getReusltBillInfo()).getBizDate() == null) {
                tmpInfo.setBizDate(bill.getBizDate());
            }
            if (bill.getBizDate().compareTo(tmpInfo.getBizDate()) > 0) {
                tmpInfo.setBizDate(bill.getBizDate());
            }
            if (bill.isCalculate()) {
                if (!bill.isCostAdjustBill()) {
                    if (bill.isOutBill()) {
                        if (!bill.isCommissionSaleOut()) {
                            tmpInfo.setRecentQty(tmpInfo.getRecentQty().subtract(bill.getRecentQty()));
                        }
                    } else if (bill.isInListCal()) {
                        tmpInfo.setRecentQty(tmpInfo.getRecentQty().add(bill.getRecentQty()));
                    } else {
                        tempRecentQty = tempRecentQty.add(bill.getRecentQty());
                    }
                }
                if (bill.isOutBill()) {
                    if (!bill.isCommissionSaleOut()) {
                        tmpInfo.setRecentCost(tmpInfo.getRecentCost().subtract(bill.getRecentCost()));
                    }
                } else if (bill.isInListCal()) {
                    tmpInfo.setRecentCost(tmpInfo.getRecentCost().add(bill.getRecentCost()));
                } else {
                    noCalInListBillCost.put(bill.getBillEntryId(), keyId);
                }
                OneKeyCalculateHelper.calculateAvgPrice(tmpInfo);
            }
            if (CalculateUtil.ZERO.compareTo(tempRecentQty) == 0) continue;
            if (noCalInListBillQty.get(keyId) != null) {
                BigDecimal tempQty = (BigDecimal)noCalInListBillQty.get(keyId);
                noCalInListBillQty.put(keyId, tempRecentQty.add(tempQty));
                continue;
            }
            noCalInListBillQty.put(keyId, tempRecentQty);
        }
        balanceMap.put("INBILLLIST", inBillList);
        balanceMap.put("noCalInListBillQty", noCalInListBillQty);
        balanceMap.put("noCalMatChageInBill", noCalMatChageInBill);
    }

    private OneKeyBalanceCostInfo createNewBalanceCostInfo(Context ctx, String strCalType, OneKeyBillCostInfo bill) {
        OneKeyBalanceCostInfo balanceCostInfo = new OneKeyBalanceCostInfo();
        balanceCostInfo.setStrCalType(strCalType);
        balanceCostInfo.setBalanceQty(BigDecimal.ZERO);
        balanceCostInfo.setBalanceActualCost(BigDecimal.ZERO);
        balanceCostInfo.setBalancePrice(BigDecimal.ZERO);
        OneKeyBillCostInfo tmpInfo = (OneKeyBillCostInfo)bill.clone();
        tmpInfo.setRecentCost(CalculateUtil.ZERO);
        tmpInfo.setRecentQty(CalculateUtil.ZERO);
        tmpInfo.setBillNumber(SCMUtils.getResource((String)res, (String)"235_EndBalance", (Context)ctx));
        tmpInfo.setBillTypeName("");
        OneKeyCalculateHelper.calculateAvgPrice(tmpInfo);
        balanceCostInfo.setReusltBillInfo(tmpInfo);
        return balanceCostInfo;
    }

    private void handleReWorkUnitCost(HashMap balanceMap, List reWorkMatReqBillList, String fKey) {
        OneKeyBillCostInfo costInfo = null;
        OneKeyBalanceCostInfo balanceCostInfo = (OneKeyBalanceCostInfo)balanceMap.get(fKey);
        if (balanceCostInfo != null) {
            OneKeyBillCostInfo tmpInfo = balanceCostInfo.getReusltBillInfo();
            int listSize = reWorkMatReqBillList.size();
            for (int i = 0; i < listSize; ++i) {
                costInfo = (OneKeyBillCostInfo)reWorkMatReqBillList.get(i);
                if (!fKey.equals(costInfo.getKeyId())) continue;
                tmpInfo.setRecentQty(tmpInfo.getRecentQty().subtract(costInfo.getRecentQty()));
                tmpInfo.setRecentCost(tmpInfo.getRecentCost().subtract(costInfo.getRecentCost()));
            }
            OneKeyCalculateHelper.calculateAvgPrice(tmpInfo);
        }
    }

    private void calOutBillCost(Context ctx, List outBillList, List redBillList, HashMap balanceMap, HashMap costMoveMap, String keyId, CalculateUnitInfo calUnitInfo, Connection conn) throws BOSException, CalculateException {
        HashSet entrustMaterialIdSet;
        OneKeyBillCostInfo outBillInfo;
        int i;
        int listSize;
        OneKeyBillCostInfo resultInfo;
        if (outBillList.size() <= 0) {
            return;
        }
        String strCalType = this.calParams.getCalType();
        OneKeyBillCostInfo bill = null;
        for (int i2 = outBillList.size() - 1; i2 >= 0 && !keyId.equals((bill = (OneKeyBillCostInfo)outBillList.get(i2)).getKeyId()); --i2) {
        }
        if (bill == null || !keyId.equals(bill.getKeyId())) {
            return;
        }
        OneKeyBalanceCostInfo OneKeyBalanceCostInfo2 = (OneKeyBalanceCostInfo)balanceMap.get(keyId);
        if (OneKeyBalanceCostInfo2 == null) {
            OneKeyBalanceCostInfo2 = this.createNewBalanceCostInfo(ctx, strCalType, bill);
            balanceMap.put(keyId, OneKeyBalanceCostInfo2);
        }
        if ((resultInfo = OneKeyBalanceCostInfo2.getReusltBillInfo()) == null) {
            return;
        }
        resultInfo.setPriceSource(PriceSourEnum.averagePrice);
        if (CalculateUtil.ZERO.compareTo(resultInfo.getPrice()) == 0) {
            resultInfo.setPrice(this.getPrice(ctx, resultInfo));
            int priceType = Integer.parseInt(this.calParams.getZeroGetCostType());
            if (priceType == 0) {
                resultInfo.setPriceSource(PriceSourEnum.newOut);
            } else if (priceType == 1) {
                resultInfo.setPriceSource(PriceSourEnum.newIn);
            } else if (priceType == 2) {
                resultInfo.setPriceSource(PriceSourEnum.standUnitPrice);
            } else if (priceType == 4) {
                resultInfo.setPriceSource(PriceSourEnum.newReturnPrice);
            }
        }
        if (resultInfo.isPriceExcep()) {
            resultInfo.setNegativePrice(true);
            listSize = outBillList.size();
            for (i = 0; i < listSize; ++i) {
                outBillInfo = (OneKeyBillCostInfo)outBillList.get(i);
                if (!keyId.equals(outBillInfo.getKeyId()) || outBillInfo.isReWork()) continue;
                if (!outBillInfo.isDealComplete()) {
                    outBillInfo.setPriceSource(PriceSourEnum.negativePrice);
                    if (Integer.parseInt(this.calParams.getZeroGetCostType()) == 3 && outBillInfo.getPrice().compareTo(BigDecimal.ZERO) > 0) {
                        outBillInfo.setPriceSource(PriceSourEnum.userDefine);
                    }
                }
                outBillInfo.setDealComplete(true);
            }
        }
        if (resultInfo.getPrice().compareTo(BigDecimal.ZERO) == 0) {
            listSize = outBillList.size();
            for (i = 0; i < listSize; ++i) {
                outBillInfo = (OneKeyBillCostInfo)outBillList.get(i);
                if (!keyId.equals(outBillInfo.getKeyId()) || outBillInfo.isReWork()) continue;
                resultInfo.setZeroPrice(true);
                if (!(outBillInfo.isDealComplete() || outBillInfo.getPriceSource() != null && PriceSourEnum.averagePrice != outBillInfo.getPriceSource() || outBillInfo.getBillTypeId() == null || outBillInfo.getBillTypeId().equals(outBillInfo.getSourceBillTypeId()))) {
                    outBillInfo.setPriceSource(PriceSourEnum.zeroPrice);
                    if (Integer.parseInt(this.calParams.getZeroGetCostType()) == 3 && outBillInfo.getPrice().compareTo(BigDecimal.ZERO) > 0) {
                        outBillInfo.setPriceSource(PriceSourEnum.userDefine);
                    }
                }
                if (PriceSourEnum.sourBillPrice == outBillInfo.getPriceSource() || outBillInfo.getBillTypeId() == null || outBillInfo.getBillTypeId().equals(outBillInfo.getSourceBillTypeId())) continue;
                outBillInfo.setDealComplete(true);
            }
        }
        this.calculateOutBillCost(outBillList, redBillList, costMoveMap, keyId, resultInfo, conn);
        if ("1".equals(this.calParams.getNotCalConsignSale()) && (entrustMaterialIdSet = (HashSet)this.entrustMaterialIdMap.get(calUnitInfo.getMaterialId())) != null && entrustMaterialIdSet.contains(keyId)) {
            this.calBillForEntrust(ctx, calUnitInfo, outBillList, keyId, conn);
        }
        balanceMap.put("OUTBILLLIST", outBillList);
        this.calculateBalance(outBillList, keyId, strCalType, resultInfo);
    }

    private void calculateOutBillCost(List outBillList, List redBillList, HashMap costMoveMap, String fKey, OneKeyBillCostInfo resultInfo, Connection conn) throws CalculateException {
        OneKeyBillCostInfo bill = null;
        int listSize = outBillList.size();
        for (int i = 0; i < listSize; ++i) {
            bill = (OneKeyBillCostInfo)outBillList.get(i);
            if (!fKey.equals(bill.getKeyId())) continue;
            if (!bill.isNeedUpdate()) {
                if (!bill.isCostAdjustBill() && !bill.isDealComplete()) {
                    bill.setPrice(resultInfo.getPrice().setScale(bill.getPricePrecision(), 4));
                    BigDecimal cost = bill.getRecentQty().multiply(resultInfo.getPrice()).setScale(bill.getBaseCurrencyPrecision(), 4);
                    if (cost.compareTo(BigDecimal.ZERO) == 0 && bill.getRecentQty().compareTo(BigDecimal.ZERO) != 0 && resultInfo.getPrice().compareTo(BigDecimal.ZERO) != 0) {
                        cost = RecentCostHelp.getMinValueByScale(bill.getBaseCurrencyPrecision(), bill.getRecentQty().signum());
                    }
                    bill.setRecentCost(cost);
                }
                if (bill.isCostAdjustBill()) {
                    bill.setNeedUpdate(false);
                } else {
                    if (!bill.isDealComplete()) {
                        bill.setPriceSource(resultInfo.getPriceSource());
                    }
                    bill.setNeedUpdate(true);
                }
            }
            if (!bill.isRedBill()) {
                this.handleBlueBillAndRedBillRel(redBillList, bill);
            }
            if (resultInfo.getBizDate() == null) {
                resultInfo.setBizDate(bill.getBizDate());
            }
            if (bill.getBizDate().compareTo(resultInfo.getBizDate()) <= 0) continue;
            resultInfo.setBizDate(bill.getBizDate());
        }
    }

    @Override
    protected void handleBlueBillAndRedBillRel(List redList, OneKeyBillCostInfo info) {
        OneKeyBillCostInfo billInfo = null;
        ArrayList<OneKeyBillCostInfo> redBillList = new ArrayList<OneKeyBillCostInfo>();
        for (int i = 0; i < redList.size(); ++i) {
            billInfo = (OneKeyBillCostInfo)redList.get(i);
            if (!billInfo.isRedBill() || !info.getBillEntryId().equals(billInfo.getSourceBillEntryId()) || billInfo.getEntryTableMame() == null || !billInfo.getEntryTableMame().equals(info.getEntryTableMame())) continue;
            redBillList.add(billInfo);
        }
        info.setRedBillList(redBillList);
        if (redBillList != null && redBillList.size() > 0) {
            this.handleSrcBill(redBillList, info);
        }
    }

    private void calCostMoveBill(HashMap costMoveMap, String fKey) throws CalculateException {
        OneKeyBillCostInfo costMoveObj = null;
        OneKeyBillCostInfo moveInInfo = null;
        for (Map.Entry entry : costMoveMap.entrySet()) {
            costMoveObj = (OneKeyBillCostInfo)entry.getValue();
            if (costMoveObj == null || costMoveObj.getMoveInbillList() == null || costMoveObj.getMoveInbillList().size() <= 0 || !(moveInInfo = (OneKeyBillCostInfo)costMoveObj.getMoveInbillList().get(0)).getKeyId().equals(fKey)) continue;
            this.calCostMoveBill(costMoveObj, moveInInfo, false);
        }
    }

    private void calBillForEntrust(Context ctx, CalculateUnitInfo calUnitInfo, List outBillList, String keyId, Connection conn) throws BOSException {
        try {
            Map keyParam = this.getParamFromKey(keyId);
            Map result = this.costBillForEntrust(ctx, keyParam, calUnitInfo, outBillList, keyId, conn);
            String entrustEntryId = (String)result.get("entrustEntryId");
            if (entrustEntryId != null && entrustEntryId.length() > 0) {
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT Bill.FBillEntryId FID, Bill.FBillId, Bill.FBillEntryId, FEntryTableMame, Bill.FNumber, Bill.FBizDate,");
                sql.append(" Bill.FCompanyOrgUnitID, Bill.FMaterialId, Bill.FStorageorg, Bill.Fstorageorgunitid, Bill.Fwarehouse, Bill.Fwarehouseid,");
                sql.append(" case when FCalculateKind = 2 then FPeriodBeginQty else Bill.FBaseQty end FBaseQty,");
                sql.append(" case when FCalculateKind = 2 then FPeriodBeginQty else Bill.FBaseQty end FBaseQtyBak,");
                sql.append(" case when FCalculateKind = 2 then FPeriodBeginBalance else Bill.FActualCost end FActualCost,");
                sql.append(" Bill.FBaseUnitActualCost as FPrice, Bill.FReverseQty, Bill.FPricePrecision, Bill.FQtyPrecision, Bill.FLocalCurrencyPrecision,");
                sql.append(" Bill.FCalculateKind, Bill.FbillTypeID, Bill.FTransactionTypeName, Bill.FSeqNum, ISNULL(Bill.FFiVouchered, 0) AS FFiVouchered,");
                sql.append(" Bill.FBizTypeID, Bill.FSourceBillID, Bill.FSourceBillEntryID, Bill.FSourceBillEntrySeq, 0 AS FSourceUnitActualCost,");
                sql.append(" case when FCalculateKind = 2 then FPeriodBeginBalance else Bill.FActualCost end FActualCostBak,");
                sql.append(" Bill.FmaterialNumber, 0 AS FisCombition, 0 AS FisSrcBilInCurrPid, Bill.FIsPresent, BILL.FStockTransBillEntryID,");
                sql.append(" BILL.FAUDITTIME, Bill.FSourceBillTypeID, Bill.FIsReversed, Bill.FIsReWork, Bill.FOutwarehouseType, Bill.FStoreTypeID,");
                sql.append(" Bill.FStoreTypePreID, Bill.FBillTypeName, Bill.FBaseUnit, Bill.FLot, Bill.FAssistPropertyID, Bill.FProjectID, Bill.FTrackNumberID,");
                sql.append(" Bill.FUnitID, Bill.FQty, Bill.FWrittenOffBaseQty, Bill.FUnWriteOffBaseQty, Bill.FisWriteOffVouched, Bill.FBASECONVSRATE,");
                sql.append(" Bill.FbaseStatus FStockStatus, Bill.FClosePeriod FStockClosePeriod From ( ");
                sql.append(" SELECT  Entry.FMaterialID, ENTRY.FCompanyOrgUnitId AS FCompanyOrgUnitID, ENTRY.FStorageOrgUnitID AS FStorageOrgUnitID,");
                sql.append(" ENTRY.FWarehouseID AS FWarehouseID, 0 AS FPeriodBeginCostDiff, 0 AS FPeriodBeginBalance, 0 AS FIncomeCostAdjustAmt,");
                sql.append(" ENTRY.FStandardCost AS FStandardCost, ENTRY.FActualCost AS FActualCost, ENTRY.FBaseQty AS FBaseQty, MATERIAL.Fnumber as FmaterialNumber,");
                sql.append(" SCMTRANSACTIONTYPE.FName_l2 AS FTransactionTypeName, WAREHOUSE.FNumber AS FWarehouse, STORAGEORGUNIT.FNumber AS FStorageOrg,");
                sql.append(" CASE WHEN ENTRY.FUNITID=ENTRY.FBASEUNITID OR ENTRY.FBaseQty=0 THEN ISNULL(ENTRY.FUNITACTUALCOST,0) ");
                sql.append("    ELSE TO_DECIMAL(TO_DECIMAL(ENTRY.FActualCost, 17, 4)/ENTRY.FBaseQty, 21, 8) END AS FBASEUNITACTUALCOST,");
                sql.append(" 0 AS FPeriodBeginQty, Bill.FBillTypeID, BILL.FNumber, Bill.FBizDate, ENTRY.FUnitID, ENTRY.FQty, ENTRY.FWrittenOffBaseQty,");
                sql.append(" ENTRY.FUnWriteOffBaseQty, BILL.FBIZTYPEID, BILL.FTRANSACTIONTYPEID, BILL.FFIVOUCHERED, ENTRY.FSEQ AS FSEQNUM,");
                sql.append(" BILL.FID AS FBILLID,ENTRY.FID AS FBILLENTRYID, 1 AS FCALCULATEKIND, BILL.FISREVERSED, ENTRY.FREVERSEQTY,");
                sql.append(" ISNULL(MATERIAL.FPRICEPRECISION,2) AS FPRICEPRECISION, ISNULL(MEASUREUNITBASE.FQTYPRECISION,4) AS FQTYPRECISION, 2 AS FLOCALCURRENCYPRECISION,");
                sql.append(" NULL AS FSTOCKTRANSBILLENTRYID,BILL.FAUDITTIME, 0 AS FOutwarehouseType, 'T_IM_SaleIssueEntry' AS FEntryTableMame, 0 as FIsReWork,");
                sql.append(" BILL.FSOURCEBILLTYPEID, 0 AS FISPRESENT, INVUPDATETYPE.FSTORETYPEID AS FSTORETYPEID, INVUPDATETYPE.FSTORETYPEPREID AS FSTORETYPEPREID,");
                sql.append(" to_char(ENTRY.FSourceBillID) AS FSourceBillID, to_char(ENTRY.FSourceBillEntryID) AS FSourceBillEntryID, ENTRY.FSourceBillEntrySeq,");
                sql.append(" '").append(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SalesDelivery", (Context)ctx)).append("' as FBillTypeName,");
                sql.append(" ENTRY.FBaseUnitID as FBASEUNIT, (case when MATERIALCOMPANY.FIsLot = 1 then isnull(ENTRY.FLot,'X') else null end) AS FLOT, ");
                sql.append("(case when MATERIALCOMPANY.FIsAssistProperty = 1 then isnull(ENTRY.FAssistPropertyID,'X') else null end) AS FAssistPropertyID, ");
                sql.append("(case when MATERIALCOMPANY.FIsProject = 1  then isnull(ENTRY.FProjectID,'X') else null end) AS FProjectID, ");
                sql.append("(case when MATERIALCOMPANY.FIsTrackNumber = 1  then isnull(ENTRY.FTrackNumberID,'X') else null end) AS FTrackNumberID, ");
                sql.append(" BILL.FisWriteOffVouched as FisWriteOffVouched, MeasureUnit.FBASECONVSRATE, 0 as FbaseStatus, 0 as FClosePeriod");
                sql.append(" FROM T_IM_SaleIssueEntry ENTRY ");
                sql.append(" INNER JOIN T_IM_SaleIssueBill BILL ON BILL.FID = ENTRY.FParentID ");
                sql.append(" INNER JOIN T_BD_MATERIAL MATERIAL on MATERIAL.FID = ENTRY.FMATERIALID ");
                sql.append(" INNER JOIN T_BD_MATERIALCOMPANYINFO MATERIALCOMPANY ");
                sql.append(" \tON (ENTRY.FMaterialId = MATERIALCOMPANY.FMaterialID AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )");
                sql.append(" INNER JOIN T_ORG_Storage STORAGEORGUNIT ON entry.FStorageOrgUnitID = STORAGEORGUNIT.FID");
                sql.append(" INNER JOIN T_DB_WAREHOUSE WAREHOUSE ON entry.FWareHouseID = WAREHOUSE.FID");
                sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID");
                sql.append(" INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID");
                sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase ON (ENTRY.FMaterialID = MeasureUnitBase.FMaterialid AND ENTRY.FBaseUnitID = MeasureUnitBase.FMeasureUnitID)");
                sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnit ON (ENTRY.FMaterialID = MeasureUnit.FMaterialid AND ENTRY.FUnitID = MeasureUnit.FMeasureUnitID)");
                sql.append(" WHERE ENTRY.FID in (").append(entrustEntryId).append(") ) Bill ");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                long timeSerialNumber = new Date().getTime();
                if (this.entrustBillList == null) {
                    this.entrustBillList = new ArrayList();
                }
                HashSet returnEntrySet = (HashSet)result.get("returnEntrySet");
                HashSet updateEntrySet = (HashSet)result.get("updateEntrySet");
                while (rs.next()) {
                    OneKeyBillCostInfo billInfo;
                    if (updateEntrySet.contains((billInfo = this.convertOneKeyBillCostInfo((ResultSet)rs, ++timeSerialNumber)).getBillEntryId())) {
                        billInfo.setPriceSource(PriceSourEnum.entrust);
                    } else {
                        billInfo.setPriceSource(PriceSourEnum.fiVouchered);
                    }
                    if (returnEntrySet.contains(billInfo.getBillEntryId())) {
                        outBillList.add(billInfo);
                        continue;
                    }
                    billInfo.setTimeSerialNumber(99999999999999L);
                    billInfo.setBillTypeName(billInfo.getBillTypeName() + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"notCalBalance", (Context)ctx));
                    this.entrustBillList.add(billInfo);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Map costBillForEntrust(Context ctx, Map keyParam, CalculateUnitInfo calUnitInfo, List outBillList, String keyId, Connection conn) throws BOSException, SQLException {
        List innerList;
        OneKeyBillCostInfo currInfo;
        int local_Currency_Presision = this.calParams.getBaseCurrencyPrecision();
        Map ret = this.entrustSettlement(ctx, keyParam, outBillList, calUnitInfo, conn);
        Map<String, List<OneKeyBillCostInfo>> settlementReturnGroupMap = this.entrustSettlementReturn(ctx, keyParam, calUnitInfo, outBillList, keyId, conn);
        Map outMap = (Map)ret.get("outMap");
        Map otherMap = (Map)ret.get("otherMap");
        ArrayList<OneKeyBillCostInfo> needUpdate = new ArrayList<OneKeyBillCostInfo>();
        StringBuffer entryId = new StringBuffer();
        HashSet<String> entryIdSet = new HashSet<String>();
        HashSet<String> updateEntrySet = new HashSet<String>();
        HashSet<String> returnEntrySet = new HashSet<String>();
        for (List<OneKeyBillCostInfo> returnList : settlementReturnGroupMap.values()) {
            for (int i = 1; i < returnList.size(); ++i) {
                currInfo = returnList.get(i);
                innerList = (List)otherMap.get(currInfo.getBillEntryId());
                if (innerList == null) {
                    if (returnList.get(0).getBeforePeroid() == 0 && returnList.get(0).getFiVouchered() == 0) {
                        needUpdate.add(returnList.get(0));
                    }
                    if (returnList.get(0).getBeforePeroid() != 0 || !entryIdSet.add(returnList.get(0).getBillEntryId())) continue;
                    entryId.append("'").append(returnList.get(0).getBillEntryId()).append("',");
                    returnEntrySet.add(returnList.get(0).getBillEntryId());
                    continue;
                }
                innerList.add(currInfo);
                innerList.add(returnList.get(0));
            }
        }
        BigDecimal unitActuralCost = CalculateUtil.ZERO;
        BigDecimal allQty = CalculateUtil.ZERO;
        BigDecimal allCost = CalculateUtil.ZERO;
        BigDecimal sumQty = CalculateUtil.ZERO;
        BigDecimal sumCost = CalculateUtil.ZERO;
        int dealTailIndex = -1;
        BigDecimal dealTailQty = CalculateUtil.ZERO;
        BigDecimal diffAmount = CalculateUtil.ZERO;
        BigDecimal writeBaseQty = CalculateUtil.ZERO;
        BigDecimal baseconvsrate = BigDecimal.ONE;
        for (Map.Entry entry : otherMap.entrySet()) {
            OneKeyBillCostInfo outInfo = (OneKeyBillCostInfo)outMap.get(entry.getKey());
            allQty = outInfo.getRecentQty();
            allCost = outInfo.getRecentCost();
            innerList = (List)entry.getValue();
            for (int i = 0; i < innerList.size(); ++i) {
                currInfo = (OneKeyBillCostInfo)innerList.get(i);
                if (currInfo.getBeforePeroid() == 0 && entryIdSet.add(currInfo.getBillEntryId())) {
                    entryId.append("'").append(currInfo.getBillEntryId()).append("',");
                    if (currInfo.getRecentCost().compareTo(BigDecimal.ZERO) < 0) {
                        returnEntrySet.add(currInfo.getBillEntryId());
                    }
                }
                if (currInfo.getFiVouchered() == 0 && currInfo.getBeforePeroid() == 0) {
                    if (currInfo.getSettlementReturnBill() == 0) {
                        needUpdate.add(currInfo);
                        if (dealTailQty.compareTo(CalculateUtil.ZERO) <= 0) {
                            dealTailIndex = i;
                            dealTailQty = currInfo.getRecentQty();
                        }
                    } else if (currInfo.getRecentQty().compareTo(CalculateUtil.ZERO) < 0) {
                        needUpdate.add(currInfo);
                        if (dealTailIndex == -1) {
                            dealTailIndex = i;
                        }
                    }
                }
                if (currInfo.getSettlementReturnBill() == 0) {
                    sumQty = sumQty.add(currInfo.getRecentQty().abs());
                    sumCost = sumCost.add(currInfo.getRecentCost().abs());
                    continue;
                }
                if (currInfo.getRecentQty().compareTo(CalculateUtil.ZERO) <= 0) continue;
                writeBaseQty = currInfo.getWrittenOffBaseQty();
                if (writeBaseQty == null) {
                    if (!currInfo.getBaseUnitId().equals(currInfo.getUnitId())) {
                        baseconvsrate = currInfo.getBaseConvsRate();
                        writeBaseQty = currInfo.getWrittenOffBaseQty().multiply(baseconvsrate);
                    } else {
                        writeBaseQty = currInfo.getWrittenOffBaseQty();
                    }
                }
                sumQty = sumQty.add(writeBaseQty);
                sumCost = sumCost.add(writeBaseQty.multiply(((OneKeyBillCostInfo)innerList.get(i + 1)).getPrice()).setScale(local_Currency_Presision, 4).abs());
            }
            if (sumQty.compareTo(allQty) == 0 && dealTailIndex > -1) {
                diffAmount = allCost.subtract(sumCost);
                if (diffAmount.compareTo(CalculateUtil.ZERO) == 0) {
                    sumQty = CalculateUtil.ZERO;
                    sumCost = CalculateUtil.ZERO;
                    dealTailIndex = -1;
                    dealTailQty = CalculateUtil.ZERO;
                    diffAmount = CalculateUtil.ZERO;
                    continue;
                }
                currInfo = (OneKeyBillCostInfo)innerList.get(dealTailIndex);
                if (currInfo.getRecentQty().compareTo(CalculateUtil.ZERO) < 0) {
                    if (currInfo.getRecentCost().subtract(diffAmount).compareTo(CalculateUtil.ZERO) > 0) continue;
                    currInfo.setRecentCost(currInfo.getRecentCost().subtract(diffAmount));
                } else {
                    if (currInfo.getRecentCost().add(diffAmount).compareTo(CalculateUtil.ZERO) < 0) continue;
                    currInfo.setRecentCost(currInfo.getRecentCost().add(diffAmount));
                }
                OneKeyCalculateHelper.calculateAvgPrice(currInfo);
                unitActuralCost = currInfo.getPrice();
                if (!currInfo.getBaseUnitId().equals(currInfo.getUnitId())) {
                    baseconvsrate = currInfo.getBaseConvsRate();
                    unitActuralCost = currInfo.getPrice().multiply(baseconvsrate).setScale(currInfo.getPricePrecision(), 4);
                }
                if (currInfo.getRecentQty().compareTo(BigDecimal.ZERO) == 0) {
                    unitActuralCost = BigDecimal.ZERO;
                }
                currInfo.setUnitActuralCost(unitActuralCost);
            }
            sumQty = CalculateUtil.ZERO;
            sumCost = CalculateUtil.ZERO;
            dealTailIndex = -1;
            dealTailQty = CalculateUtil.ZERO;
            diffAmount = CalculateUtil.ZERO;
        }
        if (needUpdate.size() > 0) {
            ArrayList<String[]> paramlist = new ArrayList<String[]>();
            for (int i = 0; i < needUpdate.size(); ++i) {
                currInfo = (OneKeyBillCostInfo)needUpdate.get(i);
                String[] param = new String[]{currInfo.getPrice().toPlainString(), currInfo.getUnitActuralCost().toPlainString(), currInfo.getRecentCost().toPlainString(), currInfo.getWrittenOffAmount().toPlainString(), currInfo.getUnWriteOffAmount().toPlainString(), currInfo.getBillEntryId()};
                paramlist.add(param);
                updateEntrySet.add(currInfo.getBillEntryId());
            }
            String updateSql = "update T_IM_SaleIssueEntry set FBASEUNITACTUALCOST = ?, FUNITACTUALCOST = ?, FACTUALCOST=?, FWRITTENOFFAMOUNT = ?, FUNWRITEOFFAMOUNT = ? where FId = ?";
            DbUtil.executeBatch((Context)ctx, (String)updateSql, paramlist);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (entryId.length() > 0) {
            result.put("entrustEntryId", entryId.substring(0, entryId.length() - 1));
        }
        result.put("returnEntrySet", returnEntrySet);
        result.put("updateEntrySet", updateEntrySet);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map entrustSettlement(Context ctx, Map keyParam, List outBillList, CalculateUnitInfo calUnitInfo, Connection conn) throws SQLException {
        HashMap<String, HashMap<String, Object>> hashMap;
        StringBuffer sql = new StringBuffer();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            List<OneKeyBillCostInfo> innerList;
            sql.append("select DISTINCT ALLENTRY.FID, ALLENTRY.FUNITACTUALCOST, ALLENTRY.FSOURCEBILLENTRYID, ALLENTRY.FBASEQTY, ALLENTRY.FQTY,ALLENTRY.FACTUALCOST, ALLENTRYBILL.FFIVOUCHERED,");
            sql.append(" ALLMATERIAL.FPRICEPRECISION, allEntryUpdateType.FSTORETYPEID, allEntryUpdateType.FSTORETYPEPREID,");
            sql.append(" Round(ALLENTRY.FUNITACTUALCOST*MULT.FBASECONVSRATE,MATERIAL.FPRICEPRECISION) as FBASEUNITACTUALCOST, ALLENTRY.FBASEUNITID, ALLENTRY.FUNITID, ALLENTRY.FWRITTENOFFBASEQTY, ALLENTRY.FUNWRITEOFFBASEQTY, MULT.FBASECONVSRATE,");
            sql.append(" (case when ALLENTRYBILL.FYEAR*100+ALLENTRYBILL.FPERIOD < ").append(periodInfo.getNumber()).append(" THEN 1 ELSE 0 END) AS FISBEFOREPEROID");
            sql.append(" from T_IM_SALEISSUEENTRY ENTRY").append("\t\n");
            sql.append(" INNER JOIN T_IM_SALEISSUEBILL BILL ON BILL.FID = ENTRY.FParentID ").append("\t\n");
            sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID ").append("\t\n");
            sql.append(" INNER JOIN T_IM_StoreType StoreType ON InvUpdateType.FStoreTypePreID = StoreType.FID ").append("\t\n");
            sql.append(" AND StoreType.FID ='").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("'").append("\t\n");
            sql.append(" INNER JOIN T_BD_Material MATERIAL ON MATERIAL.FID = ENTRY.FMATERIALID");
            sql.append(" INNER JOIN T_IM_SALEISSUEENTRY ALLENTRY ON (ENTRY.FSOURCEBILLENTRYID = ALLENTRY.FID OR ENTRY.FSOURCEBILLENTRYID = ALLENTRY.FSOURCEBILLENTRYID) ");
            sql.append(" INNER JOIN T_IM_SALEISSUEBILL ALLENTRYBILL ON ALLENTRYBILL.FID = ALLENTRY.FParentID ").append("\t\n");
            sql.append(" INNER JOIN T_BD_Material ALLMATERIAL ON ALLMATERIAL.FID = ALLENTRY.FMATERIALID ").append("\t\n");
            sql.append(" INNER JOIN T_BD_MULTIMEASUREUNIT MULT ON MULT.FMATERIALID = ALLENTRY.FMATERIALID AND MULT.FMEASUREUNITID = ALLENTRY.FUNITID").append("\t\n");
            sql.append(" INNER JOIN T_IM_InvUpdateType allEntryUpdateType ON ALLENTRY.FInvUpdateTypeID = allEntryUpdateType.FID ").append("\t\n");
            sql.append(this.getBillBaseWhereSql(false));
            sql.append(this.getPeroidWhereSql(periodInfo, false, true, false));
            sql.append(this.getSQLWhereFromKeyParam(keyParam, "ENTRY"));
            sql.append(" AND ENTRY.fmaterialid = '").append(calUnitInfo.getMaterialId()).append("'").append("\t\n");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sql.append(" AND ALLENTRY.FBIZDATE <= TO_DATE('").append(format.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" order by ALLENTRY.FBASEQTY desc");
            this.logger.error((Object)("\u67e5\u8be2\u59d4\u6258\u552e\u51fa\u5355\u8bed\u53e5\u4e3a :" + sql));
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            HashMap<String, OneKeyBillCostInfo> outMap = new HashMap<String, OneKeyBillCostInfo>();
            HashMap otherMap = new HashMap();
            int local_Currency_Presision = this.calParams.getBaseCurrencyPrecision();
            OneKeyBillCostInfo outListInfo = null;
            while (rs.next()) {
                OneKeyBillCostInfo billInfo = new OneKeyBillCostInfo();
                billInfo.setBillEntryId(rs.getString("FID"));
                billInfo.setSourceBillEntryId(rs.getString("FSOURCEBILLENTRYID"));
                billInfo.setPrice(rs.getBigDecimal("FBASEUNITACTUALCOST"));
                billInfo.setRecentQty(rs.getBigDecimal("FBASEQTY"));
                billInfo.setRecentCost(rs.getBigDecimal("FACTUALCOST"));
                billInfo.setPricePrecision(rs.getInt("FPRICEPRECISION"));
                billInfo.setFiVouchered(rs.getInt("FFIVOUCHERED"));
                billInfo.setBeforePeroid(rs.getInt("FISBEFOREPEROID"));
                billInfo.setBaseConvsRate(rs.getBigDecimal("FBASECONVSRATE"));
                billInfo.setBaseCurrencyPrecision(local_Currency_Presision);
                billInfo.setWrittenOffBaseQty(rs.getBigDecimal("FWRITTENOFFBASEQTY"));
                billInfo.setUnWriteOffBaseQty(rs.getBigDecimal("FUNWRITEOFFBASEQTY"));
                billInfo.setBaseUnitId(rs.getString("FBASEUNITID"));
                billInfo.setUnitId(rs.getString("FUNITID"));
                billInfo.setSettlementReturnBill(0);
                if (billInfo.getRecentQty().compareTo(CalculateUtil.ZERO) > 0 && "181875d5-0105-1000-e000-011ac0a812fd97D461A6".equals(rs.getString("FSTORETYPEID")) && "181875d5-0105-1000-e000-0111c0a812fd97D461A6".equals(rs.getString("FSTORETYPEPREID"))) {
                    for (int i = 0; i < outBillList.size(); ++i) {
                        outListInfo = (OneKeyBillCostInfo)outBillList.get(i);
                        if (!outListInfo.getBillEntryId().equals(billInfo.getBillEntryId())) continue;
                        billInfo.setPrice(outListInfo.getPrice());
                        billInfo.setRecentCost(outListInfo.getRecentCost());
                        break;
                    }
                    outMap.put(billInfo.getBillEntryId(), billInfo);
                    continue;
                }
                if (otherMap.containsKey(billInfo.getSourceBillEntryId())) {
                    innerList = (List)otherMap.get(billInfo.getSourceBillEntryId());
                    innerList.add(billInfo);
                } else {
                    innerList = new ArrayList<OneKeyBillCostInfo>();
                    innerList.add(billInfo);
                }
                otherMap.put(billInfo.getSourceBillEntryId(), innerList);
            }
            for (Map.Entry entry : otherMap.entrySet()) {
                OneKeyBillCostInfo outInfo = (OneKeyBillCostInfo)outMap.get(entry.getKey());
                BigDecimal unitActuralCost = outInfo.getPrice();
                innerList = (ArrayList<OneKeyBillCostInfo>)entry.getValue();
                for (int i = 0; i < innerList.size(); ++i) {
                    OneKeyBillCostInfo currInfo = (OneKeyBillCostInfo)innerList.get(i);
                    if (currInfo.getFiVouchered() != 0 || currInfo.getBeforePeroid() != 0) continue;
                    currInfo.setPrice(outInfo.getPrice());
                    currInfo.setRecentCost(currInfo.getPrice().multiply(currInfo.getRecentQty()).setScale(local_Currency_Presision, RoundingMode.HALF_UP));
                    if (!currInfo.getBaseUnitId().equals(currInfo.getUnitId())) {
                        BigDecimal baseconvsrate = outInfo.getBaseConvsRate();
                        unitActuralCost = currInfo.getPrice().multiply(baseconvsrate).setScale(currInfo.getPricePrecision(), 4);
                    }
                    if (currInfo.getRecentQty().compareTo(BigDecimal.ZERO) == 0) {
                        unitActuralCost = BigDecimal.ZERO;
                    }
                    currInfo.setUnitActuralCost(unitActuralCost);
                }
            }
            HashMap<String, HashMap<String, Object>> ret = new HashMap<String, HashMap<String, Object>>();
            ret.put("outMap", outMap);
            ret.put("otherMap", otherMap);
            hashMap = ret;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<OneKeyBillCostInfo>> entrustSettlementReturn(Context ctx, Map keyParam, CalculateUnitInfo calUnitInfo, List outBillList, String keyId, Connection conn) throws SQLException {
        HashMap hashMap;
        int local_Currency_Presision = this.calParams.getBaseCurrencyPrecision();
        StringBuffer sqlForReturn = new StringBuffer();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        String materialId = calUnitInfo.getMaterialId();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            List<OneKeyBillCostInfo> innerList;
            sqlForReturn.append(" SELECT ALLENTRY.FID,TO_DECIMAL(TO_DECIMAL(ALLENTRY.FActualCost, 17, 4)/ALLENTRY.FBaseQty, 21, 8) AS FBASEUNITACTUALCOST,").append("\t\n");
            sqlForReturn.append(" RETURNENTRYGROUP.FWRITEOFFBASEQTY,RETURNENTRYGROUP.FWRITEOFFQTY,ALLENTRY.FACTUALCOST,ALLENTRY.FBASEQTY ,ALLENTRYBILL.FFIVOUCHERED,").append("\t\n");
            sqlForReturn.append(" ALLMATERIAL.FPRICEPRECISION,ALLENTRY.FBASEUNITID,ALLENTRY.FUNITID,ALLENTRY.FWRITTENOFFBASEQTY,ALLENTRY.FUNWRITEOFFBASEQTY,MULT.FBASECONVSRATE,").append("\t\n");
            sqlForReturn.append(" (CASE WHEN (BILL.FYEAR*100 + BILL.FPERIOD) < ").append(periodInfo.getNumber()).append(" THEN 1 ELSE 0 END) AS FISBEFOREPEROID,RETURNENTRYGROUP.FPARENTID").append("\t\n");
            sqlForReturn.append(" FROM T_SD_ConsignSaleBill BILL ").append("\t\n");
            sqlForReturn.append(" INNER JOIN T_SD_ConsignSaleBillentry ENTRY ON BILL.FID = ENTRY.FPARENTID").append("\t\n");
            sqlForReturn.append(" INNER JOIN T_SD_ConsignSaleBillentry RETURNENTRYGROUP ON ENTRY.FPARENTID = RETURNENTRYGROUP.FPARENTID ").append("\t\n");
            sqlForReturn.append(" INNER JOIN T_IM_SALEISSUEENTRY ALLENTRY ON ALLENTRY.FID = RETURNENTRYGROUP.FSOURCEBILLEMID ").append("\t\n");
            sqlForReturn.append(" INNER JOIN T_IM_SALEISSUEBILL ALLENTRYBILL ON ALLENTRYBILL.FID = ALLENTRY.FPARENTID ").append("\t\n");
            sqlForReturn.append(" INNER JOIN T_BD_Material ALLMATERIAL ON ALLMATERIAL.FID = ALLENTRY.FMATERIALID").append("\t\n");
            sqlForReturn.append(" INNER JOIN T_BD_MULTIMEASUREUNIT MULT ON MULT.FMATERIALID = ALLENTRY.FMATERIALID AND MULT.FMEASUREUNITID = ALLENTRY.FUNITID").append("\t\n");
            sqlForReturn.append(" WHERE (BILL.FYEAR*100 + BILL.FPERIOD) <= ").append(periodInfo.getNumber()).append(" AND ENTRY.FWRITEOFFQTY < 0").append("\t\n");
            sqlForReturn.append(" AND ENTRY.fmaterialid = '").append(materialId).append("'").append("\t\n");
            sqlForReturn.append(this.getSQLWhereFromKeyParam(keyParam, "ALLENTRY"));
            sqlForReturn.append(" AND ALLENTRY.FCOMPANYORGUNITID ='").append(this.calParams.getCompanyInfo().getId().toString()).append("'").append("\t\n");
            sqlForReturn.append(" ORDER BY RETURNENTRYGROUP.FWRITEOFFQTY ");
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sqlForReturn.toString());
            HashMap groupMap = new HashMap();
            OneKeyBillCostInfo outListInfo = null;
            while (rs.next()) {
                OneKeyBillCostInfo billInfo = new OneKeyBillCostInfo();
                billInfo.setBillEntryId(rs.getString("FID"));
                billInfo.setPrice(rs.getBigDecimal("FBASEUNITACTUALCOST"));
                billInfo.setRecentQty(rs.getBigDecimal("FBASEQTY"));
                billInfo.setRecentCost(rs.getBigDecimal("FACTUALCOST"));
                billInfo.setPricePrecision(rs.getInt("FPRICEPRECISION"));
                billInfo.setFiVouchered(rs.getInt("FFIVOUCHERED"));
                billInfo.setBeforePeroid(rs.getInt("FISBEFOREPEROID"));
                billInfo.setBaseConvsRate(rs.getBigDecimal("FBASECONVSRATE"));
                billInfo.setBaseCurrencyPrecision(local_Currency_Presision);
                billInfo.setWrittenOffQty(rs.getBigDecimal("FWRITEOFFQTY"));
                billInfo.setWrittenOffBaseQty(rs.getBigDecimal("FWRITEOFFBASEQTY"));
                billInfo.setUnWriteOffBaseQty(rs.getBigDecimal("FWRITTENOFFBASEQTY"));
                billInfo.setBaseUnitId(rs.getString("FBASEUNITID"));
                billInfo.setUnitId(rs.getString("FUNITID"));
                billInfo.setSettlementReturnBill(1);
                if (billInfo.getRecentQty().compareTo(BigDecimal.ZERO) < 0) {
                    innerList = new ArrayList<OneKeyBillCostInfo>();
                    innerList.add(billInfo);
                    groupMap.put(rs.getString("FParentId"), innerList);
                    continue;
                }
                innerList = (List)groupMap.get(rs.getString("FParentId"));
                for (int i = 0; i < outBillList.size(); ++i) {
                    outListInfo = (OneKeyBillCostInfo)outBillList.get(i);
                    if (!outListInfo.getKeyId().equals(keyId) || !outListInfo.getBillEntryId().equals(billInfo.getBillEntryId())) continue;
                    billInfo.setPrice(outListInfo.getPrice());
                    billInfo.setRecentCost(outListInfo.getRecentCost());
                    break;
                }
                innerList.add(billInfo);
            }
            BigDecimal sumCost = BigDecimal.ZERO;
            BigDecimal baseWriteQty = BigDecimal.ZERO;
            BigDecimal unitActuralCost = BigDecimal.ZERO;
            BigDecimal baseconvsrate = BigDecimal.ONE;
            for (Map.Entry entry : groupMap.entrySet()) {
                innerList = (ArrayList<OneKeyBillCostInfo>)entry.getValue();
                if (innerList.size() <= 1) continue;
                OneKeyBillCostInfo returnInfo = (OneKeyBillCostInfo)innerList.get(0);
                if (returnInfo.getFiVouchered() == 0 && returnInfo.getBeforePeroid() == 0) {
                    for (int i = 1; i < innerList.size(); ++i) {
                        baseWriteQty = ((OneKeyBillCostInfo)innerList.get(i)).getUnWriteOffBaseQty();
                        if (baseWriteQty == null) {
                            if (!returnInfo.getBaseUnitId().equals(returnInfo.getUnitId())) {
                                baseconvsrate = rs.getBigDecimal("FBaseConvsRate");
                                baseWriteQty = ((OneKeyBillCostInfo)innerList.get(i)).getUnWriteOffBaseQty().multiply(baseconvsrate);
                            } else {
                                baseWriteQty = ((OneKeyBillCostInfo)innerList.get(i)).getUnWriteOffBaseQty();
                            }
                        }
                        sumCost = sumCost.add(((OneKeyBillCostInfo)innerList.get(i)).getPrice().multiply(baseWriteQty).setScale(local_Currency_Presision, 4));
                    }
                    returnInfo.setRecentCost(sumCost.negate());
                    returnInfo.setPrice(returnInfo.getRecentCost().divide(returnInfo.getRecentQty(), returnInfo.getPricePrecision(), 4));
                    if (!returnInfo.getBaseUnitId().equals(returnInfo.getUnitId())) {
                        baseconvsrate = rs.getBigDecimal("FBaseConvsRate");
                        unitActuralCost = returnInfo.getPrice().multiply(baseconvsrate).setScale(returnInfo.getPricePrecision(), 4);
                    } else {
                        unitActuralCost = returnInfo.getPrice();
                    }
                    returnInfo.setUnitActuralCost(unitActuralCost);
                }
                sumCost = BigDecimal.ZERO;
            }
            hashMap = groupMap;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, stmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return hashMap;
    }

    public String getSQLWhereFromKeyParam(Map keyParam, String alias) {
        StringBuffer sql = new StringBuffer();
        if (keyParam.get("companyOrgUnitID") != null) {
            sql.append(" AND ").append(alias).append(".FCOMPANYORGUNITID ='").append(keyParam.get("companyOrgUnitID").toString()).append("'");
        }
        if (keyParam.get("storageOrgUnitID") != null) {
            sql.append(" AND  ").append(alias).append(".FSTORAGEORGUNITID ='").append(keyParam.get("storageOrgUnitID").toString()).append("'");
        }
        if (keyParam.get("wareHouseID") != null) {
            sql.append(" AND ").append(alias).append(".FWAREHOUSEID ='").append(keyParam.get("wareHouseID").toString()).append("'");
        }
        if (keyParam.get("Lot") != null) {
            sql.append(" AND ").append(alias).append(".FLOT ='").append(keyParam.get("Lot").toString()).append("'");
        }
        if (keyParam.get("AssistPropertyID") != null) {
            sql.append(" AND ").append(alias).append(".FASSISTPROPERTYID ='").append(keyParam.get("AssistPropertyID").toString()).append("'");
        }
        if (keyParam.get("ProjectID") != null) {
            sql.append(" AND ").append(alias).append(".FPROJECTID ='").append(keyParam.get("ProjectID").toString()).append("'");
        }
        if (keyParam.get("TrackNumberID") != null) {
            sql.append(" AND ").append(alias).append(".FTRACKNUMBERID ='").append(keyParam.get("TrackNumberID").toString()).append("'");
        }
        return sql.toString();
    }

    private void calculateBalance(List outBillList, String fKey, String strCalType, OneKeyBillCostInfo resultInfo) {
        OneKeyBillCostInfo bill = null;
        int listSize = outBillList.size();
        for (int i = 0; i < listSize; ++i) {
            bill = (OneKeyBillCostInfo)outBillList.get(i);
            if (!fKey.equals(bill.getKeyId()) || !OneKeyCalculateHelper.isEffectBalance(bill, strCalType) || bill.isReWork()) continue;
            if (bill.isMoveInBill()) {
                resultInfo.setRecentQty(resultInfo.getRecentQty().add(bill.getRecentQty()));
                resultInfo.setRecentCost(resultInfo.getRecentCost().add(bill.getRecentCost()));
            } else {
                resultInfo.setRecentQty(resultInfo.getRecentQty().subtract(bill.getRecentQty()));
                resultInfo.setRecentCost(resultInfo.getRecentCost().subtract(bill.getRecentCost()));
            }
            OneKeyCalculateHelper.calculateAvgPrice(resultInfo);
            if (resultInfo.getBizDate() == null) {
                resultInfo.setBizDate(bill.getBizDate());
            }
            if (bill.getBizDate().compareTo(resultInfo.getBizDate()) <= 0) continue;
            resultInfo.setBizDate(bill.getBizDate());
        }
        OneKeyCalculateHelper.calculateAvgPrice(resultInfo);
        if (resultInfo.isPriceExcep()) {
            resultInfo.setExceptionState(true);
        }
    }

    private void handleDetailDiff(List billList, HashMap balanceMap, String fKey) {
        OneKeyBillCostInfo tmpBillInfo = null;
        OneKeyBalanceCostInfo balanceInfo = null;
        if (balanceMap == null || balanceMap.size() == 0 || billList == null || billList.size() == 0) {
            return;
        }
        balanceInfo = (OneKeyBalanceCostInfo)balanceMap.get(fKey);
        if (balanceInfo == null) {
            return;
        }
        if (balanceInfo.isNeedAdjustDetail()) {
            boolean adjustDetail = false;
            OneKeyBillCostInfo lastCostMove = null;
            for (int j = billList.size() - 1; j >= 0; --j) {
                tmpBillInfo = (OneKeyBillCostInfo)billList.get(j);
                if (fKey.equals(tmpBillInfo.getKeyId()) && this.isHandleDetailDiffer(balanceInfo, tmpBillInfo)) {
                    tmpBillInfo.setRecentCost(tmpBillInfo.getRecentCost().add(balanceInfo.getRecentCost()));
                    OneKeyCalculateHelper.calculateAvgPrice(tmpBillInfo);
                    tmpBillInfo.setMoveAvgQty(CalculateUtil.ZERO);
                    tmpBillInfo.setMoveAvgPrice(CalculateUtil.ZERO);
                    tmpBillInfo.setMoveAvgCost(CalculateUtil.ZERO);
                    tmpBillInfo.setAdjustDiffered(true);
                    balanceInfo.handleDetailDifer(tmpBillInfo);
                    adjustDetail = true;
                    break;
                }
                if (lastCostMove != null || !tmpBillInfo.isCostPriceMove() || !tmpBillInfo.isCalculate() || !fKey.equals(tmpBillInfo.getKeyId())) continue;
                lastCostMove = tmpBillInfo;
            }
            if (!adjustDetail && lastCostMove != null && balanceInfo.getRecentCost().add(lastCostMove.getRecentCost()).signum() == lastCostMove.getRecentQty().signum()) {
                OneKeyCalculateHelper.calculateAvgPrice(lastCostMove);
                lastCostMove.setMoveAvgCost(CalculateUtil.ZERO);
                lastCostMove.setMoveAvgPrice(CalculateUtil.ZERO);
                lastCostMove.setMoveAvgQty(CalculateUtil.ZERO);
                lastCostMove.setAdjustDiffered(true);
                balanceInfo.handleDetailDifer(lastCostMove);
            }
        }
    }

    private boolean isHandleDetailDiffer(OneKeyBalanceCostInfo balanceInfo, OneKeyBillCostInfo infoBill) {
        return !infoBill.isDealComplete() && infoBill.isCanAdjustDiffer() && balanceInfo.getRecentCost().add(infoBill.getRecentCost()).signum() == infoBill.getRecentQty().signum() && CalculateUtil.ZERO.compareTo(infoBill.getReverseQty()) == 0 && !infoBill.isCostPriceMove() && !infoBill.isCommissionSaleOut() && !infoBill.isMatAttrChange() && infoBill.getQty().compareTo(BigDecimal.ZERO) != 0;
    }

    private void setExceptionState(HashMap balanceMap, String fKey) {
        if (balanceMap == null) {
            return;
        }
        OneKeyBillCostInfo resultInfo = null;
        OneKeyBalanceCostInfo balanceInfo = null;
        balanceInfo = (OneKeyBalanceCostInfo)balanceMap.get(fKey);
        if (balanceInfo == null) {
            return;
        }
        resultInfo = balanceInfo.getReusltBillInfo();
        if (resultInfo.isBalanceExcep()) {
            resultInfo.setExceptionState(true);
        }
    }

    private void setBalanceResultInfo(HashMap costMoveMap, HashMap noCalInList, HashMap balanceMap) {
        if (noCalInList.size() == 0) {
            return;
        }
        HashMap<String, BigDecimal> costTotalMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> costMoveInBill = new HashMap<String, BigDecimal>();
        Iterator costMoveMapIter = costMoveMap.keySet().iterator();
        String FStockTransBill = null;
        OneKeyBillCostInfo moveCostBill = null;
        ArrayList moveInBill = null;
        OneKeyBillCostInfo moveInCostBill = null;
        while (costMoveMapIter.hasNext()) {
            FStockTransBill = costMoveMapIter.next().toString();
            moveCostBill = (OneKeyBillCostInfo)costMoveMap.get(FStockTransBill);
            moveInBill = moveCostBill.getMoveInbillList();
            if (moveInBill == null) continue;
            int listSize = moveInBill.size();
            for (int i = 0; i < listSize; ++i) {
                moveInCostBill = (OneKeyBillCostInfo)moveInBill.get(i);
                String id = moveInCostBill.getBillEntryId();
                costMoveInBill.put(id, moveInCostBill.getRecentCost());
            }
        }
        Iterator iter = noCalInList.keySet().iterator();
        String billID = null;
        BigDecimal tempCost = null;
        BigDecimal oldCost = null;
        String fKey = null;
        while (iter.hasNext()) {
            billID = iter.next().toString();
            fKey = noCalInList.get(billID).toString();
            tempCost = (BigDecimal)costMoveInBill.get(billID);
            if (costTotalMap.get(fKey) != null) {
                oldCost = (BigDecimal)costTotalMap.get(fKey);
                costTotalMap.put(fKey, oldCost.add(tempCost));
                continue;
            }
            costTotalMap.put(fKey, tempCost);
        }
        Iterator totalIter = costTotalMap.keySet().iterator();
        String fKeyid = null;
        OneKeyBalanceCostInfo OneKeyBalanceCostInfo2 = null;
        OneKeyBillCostInfo resultInfo = null;
        BigDecimal totalCost = null;
        BigDecimal tempQty = null;
        HashMap noCalInListBillQty = (HashMap)balanceMap.get("noCalInListBillQty");
        while (totalIter.hasNext()) {
            fKeyid = totalIter.next().toString();
            totalCost = (BigDecimal)costTotalMap.get(fKeyid);
            OneKeyBalanceCostInfo2 = (OneKeyBalanceCostInfo)balanceMap.get(fKeyid);
            resultInfo = OneKeyBalanceCostInfo2.getReusltBillInfo();
            if (noCalInListBillQty != null && noCalInListBillQty.get(fKeyid) != null) {
                tempQty = (BigDecimal)noCalInListBillQty.get(fKeyid);
                resultInfo.setRecentQty(resultInfo.getRecentQty().add(tempQty));
            }
            resultInfo.setRecentCost(resultInfo.getRecentCost().add(totalCost));
            OneKeyCalculateHelper.calculateAvgPrice(resultInfo);
        }
    }

    private HashMap handleLotCalculate(Context ctx, CalculateUnitInfo calculateUnitInfo, Connection conn) throws EASBizException, BOSException, InterruptedException {
        HashMap<String, ArrayList<OneKeyBillCostInfo>> hashMap;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        try {
            LinkedHashMap costMoveMap = new LinkedHashMap();
            HashMap matAttrChgMap = new HashMap();
            ArrayList<OneKeyBillCostInfo> inBillList = new ArrayList<OneKeyBillCostInfo>();
            ArrayList<OneKeyBillCostInfo> outBillList = new ArrayList<OneKeyBillCostInfo>();
            HashSet<String> otherOrderSet = new HashSet<String>();
            ArrayList<String> otherOrder = new ArrayList<String>();
            HashMap prePeriodCostMoveMap = new HashMap();
            ArrayList<OneKeyBillCostInfo> redBillList = new ArrayList<OneKeyBillCostInfo>();
            ArrayList<OneKeyBillCostInfo> revereList = new ArrayList<OneKeyBillCostInfo>();
            ArrayList<OneKeyBillCostInfo> outRetInList = new ArrayList<OneKeyBillCostInfo>();
            ArrayList<OneKeyBillCostInfo> inBillNeddUpdated = new ArrayList<OneKeyBillCostInfo>();
            ArrayList reWorkMatReqBillList = new ArrayList();
            OneKeyBillCostInfo periodBegin = null;
            stmt = this.getBillPreparedStatement(conn, calculateUnitInfo);
            rs = this.getBillRowSet(stmt, calculateUnitInfo);
            this.checkInterrupted();
            long timeSerialNumber = new Date().getTime();
            HashMap<String, OneKeyBillCostInfo> periodBeginBillMap = new HashMap<String, OneKeyBillCostInfo>();
            while (rs.next()) {
                OneKeyBillCostInfo bill;
                if (2 == (bill = this.convertOneKeyBillCostInfo(rs, ++timeSerialNumber)).getCalculateKind()) {
                    if (periodBeginBillMap.get(bill.getKeyId()) == null) {
                        periodBeginBillMap.put(bill.getKeyId(), bill);
                        OneKeyCalculateHelper.calculateAvgPrice(bill);
                    } else {
                        periodBegin = (OneKeyBillCostInfo)periodBeginBillMap.get(bill.getKeyId());
                        periodBegin.setRecentCost(periodBegin.getRecentCost().add(bill.getRecentCost()));
                        periodBegin.setRecentQty(periodBegin.getRecentQty().add(bill.getRecentQty()));
                        OneKeyCalculateHelper.calculateAvgPrice(periodBegin);
                        continue;
                    }
                }
                if (bill.getFiVouchered() == 1) {
                    bill.setPriceSource(PriceSourEnum.fiVouchered);
                    bill.setDealComplete(true);
                }
                if ("1".equals(this.calParams.getNoSrcOutBillCalType()) || "1".equals(this.calParams.getSrcBillPreperiodCalType())) {
                    if (bill.isNotSrcOutRetBill() && "1".equals(this.calParams.getNoSrcOutBillCalType())) {
                        if (!bill.isDealComplete()) {
                            bill.setPriceSource(PriceSourEnum.userDefine);
                        }
                        bill.setNotUpdateCostAgain(true);
                    }
                    if (bill.isSrcOutBillInPrePeriod() && "1".equals(this.calParams.getSrcBillPreperiodCalType())) {
                        bill.setNotUpdateCostAgain(true);
                    }
                }
                if (bill.isCostPriceMove()) {
                    this.setCostMoveIsCalculate(bill);
                    this.buildCostPriceMove(bill, costMoveMap);
                    if (bill.isSrcOutBillInPrePeriod()) {
                        if (!bill.isDealComplete()) {
                            bill.setPriceSource(PriceSourEnum.sourBillPrice);
                        }
                        bill.setNeedUpdate(true);
                    }
                }
                otherOrderSet.add(bill.getKeyId());
                if (bill.isReWork()) {
                    this.setReWorkBillCost(reWorkMatReqBillList, periodBeginBillMap, inBillNeddUpdated, bill);
                }
                if (!bill.isOutBill()) {
                    if (!bill.isCalculate()) continue;
                    if (bill.isCostPriceMove() && bill.isMoveOutBill()) {
                        outBillList.add(bill);
                        continue;
                    }
                    inBillList.add(bill);
                    continue;
                }
                if (bill.isRedBill()) {
                    if (bill.isNotSrcOutRetBill() && "1".equals(this.calParams.getNoSrcOutBillCalType()) || bill.isSrcOutBillInPrePeriod() && "1".equals(this.calParams.getSrcBillPreperiodCalType())) {
                        inBillList.add(bill);
                        outRetInList.add(bill);
                        bill.setOutRetBillisIn(true);
                    } else {
                        if (bill.isReversed()) {
                            revereList.add(bill);
                        } else {
                            outBillList.add(bill);
                        }
                        redBillList.add(bill);
                    }
                    if (!bill.isSrcOutBillInPrePeriod() || bill.isDealComplete()) continue;
                    inBillNeddUpdated.add(bill);
                    bill.setPriceSource(PriceSourEnum.sourBillPrice);
                    bill.setNeedUpdate(true);
                    continue;
                }
                if (bill.isReversed()) {
                    revereList.add(bill);
                    continue;
                }
                bill.setCanAdjustDiffer(true);
                outBillList.add(bill);
            }
            this.checkInterrupted();
            this.getCostMoveInBillByIssue(conn, prePeriodCostMoveMap, costMoveMap, timeSerialNumber, periodInfo);
            otherOrder.addAll(otherOrderSet);
            this.updateToPrePeriodCostMovePrice(prePeriodCostMoveMap, costMoveMap, inBillNeddUpdated);
            this.handleReversedInList(inBillList, outBillList, revereList, outRetInList);
            this.checkInterrupted();
            HashMap otherMap = this.calculateOutBillCost(ctx, inBillList, outBillList, redBillList, reWorkMatReqBillList, calculateUnitInfo, costMoveMap, matAttrChgMap, otherOrder, conn);
            this.checkInterrupted();
            this.updateMoveLocationBill(ctx, otherMap, otherOrder, calculateUnitInfo);
            this.calMatAttrChangeCost(matAttrChgMap);
            this.calBalanceAddMatChange(otherMap);
            HashMap<String, ArrayList<OneKeyBillCostInfo>> balanceMap = new HashMap<String, ArrayList<OneKeyBillCostInfo>>();
            balanceMap.putAll(otherMap);
            balanceMap.put("INBILLNEEDUPDATED", inBillNeddUpdated);
            this.checkInterrupted();
            hashMap = balanceMap;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return hashMap;
    }

    @Override
    protected String getBillSqlOrder() {
        return " Order by Bill.FBizdate,Bill.FAuditTime,Bill.FNumber,Bill.FSeqNum";
    }

    private void calBalanceAddMatChange(HashMap otherMap) {
        HashMap noCalInListBillMap = (HashMap)otherMap.get("noCalMatChageInBill");
        if (noCalInListBillMap == null || noCalInListBillMap.isEmpty()) {
            return;
        }
        Iterator iterator = noCalInListBillMap.keySet().iterator();
        OneKeyBalanceCostInfo balanceCostInfo = null;
        OneKeyBillCostInfo resultInfo = null;
        List billList = null;
        OneKeyBillCostInfo bill = null;
        while (iterator.hasNext()) {
            String fKeyid = (String)iterator.next();
            balanceCostInfo = (OneKeyBalanceCostInfo)otherMap.get(fKeyid);
            resultInfo = balanceCostInfo.getReusltBillInfo();
            if (noCalInListBillMap == null || noCalInListBillMap.get(fKeyid) == null) continue;
            billList = (List)noCalInListBillMap.get(fKeyid);
            int size = billList.size();
            for (int i = 0; i < size; ++i) {
                bill = (OneKeyBillCostInfo)billList.get(i);
                resultInfo.setRecentQty(resultInfo.getRecentQty().add(bill.getRecentQty()));
                resultInfo.setRecentCost(resultInfo.getRecentCost().add(bill.getRecentCost()));
            }
        }
        OneKeyCalculateHelper.calculateAvgPrice(resultInfo);
    }

    @Override
    protected void adjustPrePeriodData(Context ctx) throws BOSException {
        LowTimer tt = new LowTimer();
        PeriodInfo periodInfo = this.calParams.getPeriodInfo();
        DBUtil.execute(ctx, this.getUpateMaterialReqPriceFromPrePeriod(periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u9886\u6599\u51fa\u5e93\u9000\u8d27\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        DBUtil.execute(ctx, this.getUpateSaleIssuePriceFromPrePeriod(periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u9500\u552e\u51fa\u5e93\u9000\u8d27\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        DbUtil.execute((Context)ctx, (String)this.getUpateCostMoveIssueFromPrePeriod(periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u6210\u672c\u4ef7\u8c03\u62d4\u51fa\u9000\u8d27\u5355\u6216\u8005\u51b2\u9500\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        DBUtil.execute(ctx, this.getUpateCostMoveInFromPrePeriod(periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u6210\u672c\u4ef7\u8c03\u62d4\u5165\u9000\u8d27\u5355\u6216\u8005\u51b2\u9500\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
    }
}

