/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app.calculateimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.DevolveCostCalculateFacadeFactory;
import com.kingdee.eas.scm.cal.IDevolveCostCalculateFacade;
import com.kingdee.eas.scm.cal.IMatAssembleCalculateFacade;
import com.kingdee.eas.scm.cal.IMatChangeCalculateFacade;
import com.kingdee.eas.scm.cal.MatAssembleCalculateFacadeFactory;
import com.kingdee.eas.scm.cal.MatChangeCalculateFacadeFactory;
import com.kingdee.eas.scm.cal.onekey.CalculateUnitInfo;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateReportFactory;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateReportInfo;
import com.kingdee.eas.scm.cal.onekey.app.help.OneKeyCalculateProcessHelper;
import com.kingdee.eas.scm.cal.onekey.multipleJob.ThreadLocalHelper;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class OneKeyCalcInCalculate {
    IMatAssembleCalculateFacade iMatAssembleCalculateFacade;
    IMatChangeCalculateFacade iMatChangeCalculateFacade;
    IDevolveCostCalculateFacade iDevolveCostCalculateFacade;
    Context ctx;
    String companyId;
    String processEntryId;
    List<CalculateUnitInfo> calcInList;
    int inCalcType;
    String rankTempTbl;
    PeriodInfo currentPeriodInfo;
    int currentRank;

    public OneKeyCalcInCalculate(Context ctx, String companyId, String processEntryId, List<CalculateUnitInfo> calcInList, int inCalcType, String rankTempTbl, PeriodInfo currentPeriodInfo, int currentRank) {
        this.ctx = ctx;
        this.companyId = companyId;
        this.processEntryId = processEntryId;
        this.calcInList = calcInList;
        this.inCalcType = inCalcType;
        this.rankTempTbl = rankTempTbl;
        this.currentPeriodInfo = currentPeriodInfo;
        this.currentRank = currentRank;
    }

    public void calculate() throws BOSException {
        try {
            int maxExecuteNum = 10;
            IRowSet rowSet = DBUtil.executeQuery((Context)this.ctx, (String)"SELECT fvalue FROM t_dt_dttempparam where fkey = 'oneKeyCalcMultiThread'");
            while (rowSet.next()) {
                maxExecuteNum = rowSet.getInt("fvalue");
            }
            ThreadLocalHelper.childInExecutor.set(Executors.newFixedThreadPool(maxExecuteNum));
            ExecutorCompletionService completionService = new ExecutorCompletionService((Executor)ThreadLocalHelper.childInExecutor.get());
            for (int i = 0; i < this.calcInList.size(); ++i) {
                CalculateUnitInfo calcInfo = this.calcInList.get(i);
                List currBillList = this.inCalcType == 1 || this.inCalcType == 2 ? this.getSpecialBizBillByCalcUnit(this.ctx, this.currentPeriodInfo, this.rankTempTbl, this.currentRank, calcInfo, this.inCalcType) : this.getDevInBillByCalcUnit(this.ctx, this.currentPeriodInfo, this.rankTempTbl, this.currentRank, calcInfo);
                if (currBillList.size() == 0) continue;
                if (i > maxExecuteNum - 1) {
                    completionService.take().get();
                }
                InCalcThread inCalcThread = new InCalcThread(currBillList, calcInfo);
                completionService.submit(inCalcThread);
            }
            int unCatchJob = Math.min(maxExecuteNum, this.calcInList.size());
            for (int i = 0; i < unCatchJob; ++i) {
                completionService.take().get();
            }
        }
        catch (Exception e) {
            if (ThreadLocalHelper.childInExecutor.get() != null) {
                ((ExecutorService)ThreadLocalHelper.childInExecutor.get()).shutdownNow();
            }
            throw new BOSException((Throwable)e);
        }
        finally {
            if (ThreadLocalHelper.childInExecutor.get() != null) {
                ((ExecutorService)ThreadLocalHelper.childInExecutor.get()).shutdown();
            }
            ThreadLocalHelper.childInExecutor.remove();
        }
    }

    private CalculateParams doMatAssembleCalculate(Context ctx, List idList, String companyId) throws BOSException, EASBizException {
        if (this.iMatAssembleCalculateFacade == null) {
            this.iMatAssembleCalculateFacade = MatAssembleCalculateFacadeFactory.getLocalInstance(ctx);
        }
        CalculateParams params = new CalculateParams();
        params.setBoolean("ONE_KEY_CALC", true);
        params.setString("COMPANY_ID", companyId);
        params.setObject("ENTRY_ID", (Object)idList);
        CalculateParams result = this.iMatAssembleCalculateFacade.costCalculate(params);
        result.setObject("currBill", (Object)idList);
        return result;
    }

    private CalculateParams doMatChangeCalculate(Context ctx, List idList, String companyId) throws BOSException, EASBizException {
        if (this.iMatChangeCalculateFacade == null) {
            this.iMatChangeCalculateFacade = MatChangeCalculateFacadeFactory.getLocalInstance(ctx);
        }
        CalculateParams params = new CalculateParams();
        params.setBoolean("ONE_KEY_CALC", true);
        params.setString("COMPANY_ID", companyId);
        params.setObject("ENTRY_ID", (Object)idList);
        CalculateParams result = this.iMatChangeCalculateFacade.costCalculate(params);
        result.setObject("currBill", (Object)idList);
        return result;
    }

    private CalculateParams doDevolveCostCalculate(Context ctx, List idList, String companyId) throws BOSException, EASBizException {
        if (this.iDevolveCostCalculateFacade == null) {
            this.iDevolveCostCalculateFacade = DevolveCostCalculateFacadeFactory.getLocalInstance(ctx);
        }
        if (idList.size() == 0) {
            return null;
        }
        StringBuilder ids = new StringBuilder();
        for (Object s : idList) {
            ids.append("'").append(s).append("',");
        }
        ids.setLength(ids.length() - 1);
        StringBuilder sql = new StringBuilder();
        sql.append(" entry.fid in (").append((CharSequence)ids).append(")");
        CalculateParams params = new CalculateParams();
        params.setString("COMPANY_ID", companyId);
        params.setString("EXT_SQL", sql.toString());
        params.setBoolean("ONE_KEY_CALC", true);
        CalculateParams result = this.iDevolveCostCalculateFacade.costCalculate(params);
        result.setObject("currBill", (Object)idList);
        return result;
    }

    private List getSpecialBizBillByCalcUnit(Context ctx, PeriodInfo period, String rankTempTbl, int currRank, CalculateUnitInfo calcInfo, int inCalcType) throws BOSException, SQLException {
        List param = this.getCurrRankParam(currRank, calcInfo, period.getBeginDate(), period.getEndDate());
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT entry.FID FROM T_IM_OtherInWarehsBill bill inner join T_IM_OtherInWarehsBillEntry entry on entry.FParentId = bill.FID ");
        sql.append("INNER JOIN ").append(rankTempTbl).append(" TEMP on TEMP.FMATERIALID = ENTRY.FMATERIALID ");
        sql.append("AND TEMP.FCOMPANYORGUNITID = ENTRY.FCOMPANYORGUNITID ");
        sql.append("AND (CASE WHEN TEMP.FSTORAGEORGUNITID IS NULL THEN 1 WHEN TEMP.FSTORAGEORGUNITID = ENTRY.FSTORAGEORGUNITID THEN 1 ELSE 0 END) = 1 ");
        sql.append("AND (CASE WHEN TEMP.FWAREHOUSEID IS NULL THEN 1 WHEN TEMP.FWAREHOUSEID = ENTRY.FWAREHOUSEID THEN 1 ELSE 0 END) = 1 ");
        sql.append("AND (CASE WHEN TEMP.FLOT IS NULL THEN 1 WHEN TEMP.FLOT = ENTRY.FLOT THEN 1 ELSE 0 END) = 1 ");
        sql.append("AND (CASE WHEN TEMP.FASSISTPROPERTYID IS NULL THEN 1 WHEN TEMP.FASSISTPROPERTYID = ENTRY.FASSISTPROPERTYID THEN 1 ELSE 0 END) = 1 ");
        sql.append("AND (CASE WHEN TEMP.FPROJECTID IS NULL THEN 1 WHEN TEMP.FPROJECTID = ENTRY.FPROJECTID THEN 1 ELSE 0 END) = 1 ");
        sql.append("AND (CASE WHEN TEMP.FTRACKNUMBERID IS NULL THEN 1 WHEN TEMP.FTRACKNUMBERID = ENTRY.FTRACKNUMBERID THEN 1 ELSE 0 END) = 1 ");
        sql.append("AND TEMP.FRANK = ? ");
        this.getCurrRankCondition(calcInfo, sql);
        sql.append("and entry.FSOURCEBILLTYPEID ");
        if (inCalcType == 1) {
            sql.append(" IN ('").append("CJeXjSzrKhfgU0ETqMA1nkY+1VI=").append("','").append("CJewLHpKKe/gU0ETqMDAp0Y+1VI=").append("')");
        } else {
            sql.append(" = '").append("50957179-0105-1000-e000-888880a812fd463ED552").append("'");
        }
        IRowSet rs = com.kingdee.eas.scm.cal.newutil.DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        ArrayList<String> idList = new ArrayList<String>();
        while (rs.next()) {
            idList.add(rs.getString("fid"));
        }
        return idList;
    }

    private List getCurrRankParam(int currRank, CalculateUnitInfo calcInfo, Date beginDate, Timestamp endDate) {
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(currRank);
        param.add(calcInfo.getMaterialId());
        if (calcInfo.getStorageOrgUnitId() != null) {
            param.add(calcInfo.getStorageOrgUnitId());
        }
        if (calcInfo.getWarehouseId() != null) {
            param.add(calcInfo.getWarehouseId());
        }
        if (calcInfo.getLot() != null) {
            param.add(calcInfo.getLot());
        }
        if (calcInfo.getAssistPropertyId() != null) {
            param.add(calcInfo.getAssistPropertyId());
        }
        if (calcInfo.getProjectId() != null) {
            param.add(calcInfo.getProjectId());
        }
        if (calcInfo.getTrackNumberId() != null) {
            param.add(calcInfo.getTrackNumberId());
        }
        param.add(beginDate);
        param.add(endDate);
        return param;
    }

    private void getCurrRankCondition(CalculateUnitInfo calcInfo, StringBuilder sql) {
        sql.append("WHERE TEMP.FMATERIALID = ? ");
        if (calcInfo.getStorageOrgUnitId() != null) {
            sql.append(" AND TEMP.FSTORAGEORGUNITID = ? ");
        }
        if (calcInfo.getWarehouseId() != null) {
            sql.append(" AND TEMP.FWAREHOUSEID = ? ");
        }
        if (calcInfo.getLot() != null) {
            sql.append(" AND TEMP.FLOT = ? ");
        }
        if (calcInfo.getAssistPropertyId() != null) {
            sql.append(" AND TEMP.FASSISTPROPERTYID = ? ");
        }
        if (calcInfo.getProjectId() != null) {
            sql.append(" AND TEMP.FPROJECTID = ? ");
        }
        if (calcInfo.getTrackNumberId() != null) {
            sql.append(" AND TEMP.FTRACKNUMBERID = ? ");
        }
        sql.append("and bill.FBaseStatus = 4 and entry.FBIZDATE >= ? and entry.FBIZDATE <= ? ");
    }

    private List getDevInBillByCalcUnit(Context ctx, PeriodInfo period, String rankTempTbl, int currRank, CalculateUnitInfo calcInfo) throws BOSException, SQLException {
        List param = this.getCurrRankParam(currRank, calcInfo, period.getBeginDate(), period.getEndDate());
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT entry.FID FROM T_IM_PURINWAREHSBILL bill INNER JOIN T_IM_PURINWAREHSENTRY entry ON BILL.FID = ENTRY.FPARENTID ");
        sql.append("INNER JOIN ").append(rankTempTbl).append(" TEMP on TEMP.FMATERIALID = ENTRY.FMATERIALID ");
        sql.append("AND TEMP.FCOMPANYORGUNITID = ENTRY.FCOMPANYORGUNITID ");
        sql.append("AND (CASE WHEN TEMP.FSTORAGEORGUNITID IS NULL THEN 1 WHEN TEMP.FSTORAGEORGUNITID = ENTRY.FSTORAGEORGUNITID THEN 1 ELSE 0 END) = 1 ");
        sql.append("AND (CASE WHEN TEMP.FWAREHOUSEID IS NULL THEN 1 WHEN TEMP.FWAREHOUSEID = ENTRY.FWAREHOUSEID THEN 1 ELSE 0 END) = 1 ");
        sql.append("AND (CASE WHEN TEMP.FLOT IS NULL THEN 1 WHEN TEMP.FLOT = ENTRY.FLOT THEN 1 ELSE 0 END) = 1 ");
        sql.append("AND (CASE WHEN TEMP.FASSISTPROPERTYID IS NULL THEN 1 WHEN TEMP.FASSISTPROPERTYID = ENTRY.FASSISTPROPERTYID THEN 1 ELSE 0 END) = 1 ");
        sql.append("AND (CASE WHEN TEMP.FPROJECTID IS NULL THEN 1 WHEN TEMP.FPROJECTID = ENTRY.FPROJECTID THEN 1 ELSE 0 END) = 1 ");
        sql.append("AND (CASE WHEN TEMP.FTRACKNUMBERID IS NULL THEN 1 WHEN TEMP.FTRACKNUMBERID = ENTRY.FTRACKNUMBERID THEN 1 ELSE 0 END) = 1 ");
        sql.append("AND TEMP.FRANK = ? ");
        this.getCurrRankCondition(calcInfo, sql);
        sql.append("and bill.FPurchaseType = 1 and entry.FSCUnWrittenOffBaseQty = 0 ");
        IRowSet rs = com.kingdee.eas.scm.cal.newutil.DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param.toArray());
        ArrayList<String> idList = new ArrayList<String>();
        while (rs.next()) {
            idList.add(rs.getString("FID"));
        }
        return idList;
    }

    private void addInCalErrorReport(Context ctx, CalculateUnitInfo calUnitInfo, PeriodInfo periodInfo, String errMsg) throws BOSException, EASBizException {
        OneKeyCalculateReportInfo reportInfo = new OneKeyCalculateReportInfo();
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)calUnitInfo.getCompanyOrgUnitId()));
        reportInfo.setCompany(companyInfo);
        reportInfo.setYear(periodInfo.getPeriodYear());
        reportInfo.setPeriod(periodInfo.getPeriodNumber());
        if (!StringUtils.isEmpty((String)calUnitInfo.getStorageOrgUnitId())) {
            StorageOrgUnitInfo storageInfo = new StorageOrgUnitInfo();
            storageInfo.setId(BOSUuid.read((String)calUnitInfo.getStorageOrgUnitId()));
            reportInfo.setStorage(storageInfo);
        }
        if (!StringUtils.isEmpty((String)calUnitInfo.getWarehouseId())) {
            WarehouseInfo warehouseInfo = new WarehouseInfo();
            warehouseInfo.setId(BOSUuid.read((String)calUnitInfo.getWarehouseId()));
            reportInfo.setWarehouse(null);
        }
        MaterialInfo materialInfo = new MaterialInfo();
        materialInfo.setId(BOSUuid.read((String)calUnitInfo.getMaterialId()));
        reportInfo.setMaterial(materialInfo);
        reportInfo.setLot(calUnitInfo.getLot());
        if (!StringUtil.isEmpty((String)calUnitInfo.getAssistPropertyId())) {
            AsstAttrValueInfo assPropInfo = new AsstAttrValueInfo();
            assPropInfo.setId(BOSUuid.read((String)calUnitInfo.getAssistPropertyId()));
            reportInfo.setAssistProperty(assPropInfo);
        }
        if (!StringUtil.isEmpty((String)calUnitInfo.getProjectId())) {
            ProjectInfo projectInfo = new ProjectInfo();
            projectInfo.setId(BOSUuid.read((String)calUnitInfo.getProjectId()));
            reportInfo.setProject(projectInfo);
        }
        if (!StringUtil.isEmpty((String)calUnitInfo.getTrackNumberId())) {
            TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
            trackNumberInfo.setId(BOSUuid.read((String)calUnitInfo.getTrackNumberId()));
            reportInfo.setTrackNumber(trackNumberInfo);
        }
        reportInfo.setState(2);
        reportInfo.setSettleAccounts(errMsg);
        OneKeyCalculateReportFactory.getLocalInstance(ctx).addnew(reportInfo);
    }

    class InCalcThread
    implements Callable {
        List currBillList;
        CalculateUnitInfo calcInfo;

        public InCalcThread(List currBillList, CalculateUnitInfo calcInfo) {
            this.currBillList = currBillList;
            this.calcInfo = calcInfo;
        }

        public Object call() throws Exception {
            CalculateParams calculateParams = OneKeyCalcInCalculate.this.inCalcType == 1 ? OneKeyCalcInCalculate.this.doMatAssembleCalculate(OneKeyCalcInCalculate.this.ctx, this.currBillList, OneKeyCalcInCalculate.this.companyId) : (OneKeyCalcInCalculate.this.inCalcType == 2 ? OneKeyCalcInCalculate.this.doMatChangeCalculate(OneKeyCalcInCalculate.this.ctx, this.currBillList, OneKeyCalcInCalculate.this.companyId) : OneKeyCalcInCalculate.this.doDevolveCostCalculate(OneKeyCalcInCalculate.this.ctx, this.currBillList, OneKeyCalcInCalculate.this.companyId));
            if (calculateParams.getObject("calcException") != null) {
                OneKeyCalculateProcessHelper.setProcessExceptionState(OneKeyCalcInCalculate.this.ctx, OneKeyCalcInCalculate.this.processEntryId);
                Exception inException = (Exception)calculateParams.getObject("calcException");
                if (inException != null && inException instanceof EASBizException) {
                    OneKeyCalcInCalculate.this.addInCalErrorReport(OneKeyCalcInCalculate.this.ctx, this.calcInfo, OneKeyCalcInCalculate.this.currentPeriodInfo, inException.getMessage());
                } else {
                    throw new BOSException((Throwable)inException);
                }
            }
            return null;
        }
    }
}

