/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app.help;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.onekey.CalculateUnitInfo;
import com.kingdee.eas.scm.cal.onekey.OneKeyBillCostInfo;
import com.kingdee.eas.scm.cal.onekey.app.OneKeyCalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class OneKeyCalculateHelper {
    public static void calculate(Context ctx, List<CalculateUnitInfo> calculateUnitList, String companyOrgUnitId) throws BOSException, EASBizException {
        CalculateParams params = new CalculateParams();
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitId));
        params.setBoolean("isPerf", false);
        params.setBoolean("ISWRITECOSTCOMPUTEREPORT", true);
        params.setBoolean("ISWRITEDEXPCOSTRPT", false);
        params.setInt("COST_ADJUST_ISSUE_TYPE", 0);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String calType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyOrgUnitId), "SCM_CAL_002");
        params.setString("CALTYPE", calType);
        params.setString("COMPANY_ID", companyOrgUnitId);
        params.setInt("ACCOUNT_TYPE", 4);
        params.setString("COMPANY_NAME", companyOrgUnitInfo.getName());
        params.setString("COMPANY_NUMBER", companyOrgUnitInfo.getNumber());
        params.setObject("STORAGEORGUNIT_NUMBER", null);
        params.setObject("WAREHOUSE_NUMBER", null);
        params.setObject("STORAGEORGUNITID", null);
        params.setObject("WAREHOUSEID", null);
        params.setString("MATERIAL_FROM", null);
        params.setString("MATERIAL_TO", null);
        params.setInt("CALCULATE_CREATE_ITEM", 0);
        PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyOrgUnitId));
        params.setObject("PERIOD_OBJ", (Object)curPeriodInfo);
        params.setString("taskID", String.valueOf(System.currentTimeMillis()));
        params.setString("t_cl_progressTableName", "t_cl_progress");
        params.setString("title", "(" + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"materialCal", (Context)ctx) + ")");
        params.setString("OprtState", "rawMaterailCostCal");
        params.setString("CALCULATEMATERIALRANGE", "rawMaterailCostCal");
        params.setObject("CURRENT_USER", (Object)ctx.getCaller());
        params.setObject("CURRENT_COMPANY", (Object)companyOrgUnitInfo);
        params.setObject("CURRENT_CU", (Object)companyOrgUnitInfo.getCU());
        params.setObject("languageLocale", (Object)ctx.getLocale());
        params.setBoolean("isCheckBillIsAudited", false);
        params.setBoolean("isCheckPriceIsZero", false);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startTime = df.format(new Date());
        params.setString("startTime", startTime);
        int presision = CalculateUtil.getLocalCurrencyPrecision2(ctx, companyOrgUnitInfo);
        params.setInt("Local_Currency_Presision", presision);
        params.setObject("calUnitList", calculateUnitList);
        OneKeyCalculateHelper.initCostUnitTempTable(ctx, params, calculateUnitList);
        String calUnitTemp = params.getString("calUnitTemp");
        KsqlUtil.releaseTempTable((Context)ctx, (String)calUnitTemp);
    }

    public static void testOneKeyCal(Context ctx) throws EASBizException, BOSException {
        ArrayList<CalculateUnitInfo> calculateUnitList = new ArrayList<CalculateUnitInfo>();
        CalculateUnitInfo info = new CalculateUnitInfo("c6oAAA9Hg6hECefw", "c6oAAAAAZGjM567U", "c6oAAAAAZGjM567U", null, null, null, null, null, 4);
        calculateUnitList.add(info);
        info = new CalculateUnitInfo("c6oAAAAAaT5ECefw", "c6oAAAAAZGjM567U", "c6oAAAAAZGjM567U", null, null, null, null, null, 4);
        calculateUnitList.add(info);
        OneKeyCalculateHelper.calculate(ctx, calculateUnitList, "c6oAAAAAZGjM567U");
    }

    private static void initCostUnitTempTable(Context ctx, CalculateParams params, List<CalculateUnitInfo> calculateUnitList) throws BOSException {
        if (calculateUnitList != null && calculateUnitList.size() > 1) {
            StringBuilder createSql = new StringBuilder();
            createSql.append(" CREATE TABLE TEMP (");
            createSql.append(" FMATERIALID VARCHAR(44),");
            createSql.append(" FCOMPANYORGUNITID VARCHAR(44),");
            createSql.append(" FSTORAGEORGUNITID VARCHAR(44),");
            createSql.append(" FWAREHOUSEID VARCHAR(44),");
            createSql.append(" FLOT NVARCHAR(255),");
            createSql.append(" FASSISTPROPERTYID VARCHAR(255),");
            createSql.append(" FPROJECTID VARCHAR(255),");
            createSql.append(" FTRACKNUMBERID VARCHAR(255))");
            String calUnitTemp = KsqlUtil.createTempTable((Context)ctx, (String)createSql.toString());
            createSql.setLength(0);
            Object[][] sqlParams = new Object[calculateUnitList.size()][8];
            int size = calculateUnitList.size();
            for (int i = 0; i < size; ++i) {
                CalculateUnitInfo calUnitInfo = calculateUnitList.get(i);
                sqlParams[i][0] = calUnitInfo.getMaterialId();
                sqlParams[i][1] = calUnitInfo.getCompanyOrgUnitId();
                sqlParams[i][2] = calUnitInfo.getStorageOrgUnitId();
                sqlParams[i][3] = calUnitInfo.getWarehouseId();
                sqlParams[i][4] = calUnitInfo.getLot();
                sqlParams[i][5] = calUnitInfo.getAssistPropertyId();
                sqlParams[i][6] = calUnitInfo.getProjectId();
                sqlParams[i][7] = calUnitInfo.getTrackNumberId();
            }
            createSql.append(" insert into ").append(calUnitTemp).append("(");
            createSql.append(" FMATERIALID,FCOMPANYORGUNITID,FSTORAGEORGUNITID,FWAREHOUSEID, ");
            createSql.append(" FLOT,FASSISTPROPERTYID,FPROJECTID,FTRACKNUMBERID)");
            createSql.append(" values (?,?,?,?,?,?,?,?)");
            KsqlUtil.executeBatch((Context)ctx, (String)createSql.toString(), (Object[][])sqlParams);
            params.setString("calUnitTemp", calUnitTemp);
        }
    }

    public static boolean isPrePeriodBill(OneKeyBillCostInfo billInfo, PeriodInfo periodInfo) {
        if (billInfo != null && periodInfo != null && billInfo.getEntryTableMame() != null && !billInfo.getEntryTableMame().equalsIgnoreCase("T_IM_InventoryBalance") && !billInfo.getEntryTableMame().equalsIgnoreCase("T_CL_InventoryBalance")) {
            return periodInfo.getBeginDate().compareTo(billInfo.getBizDate()) > 0;
        }
        return false;
    }

    public static boolean isEffectBalance(OneKeyBillCostInfo billInfo, String strCalType) {
        return OneKeyCalculateHelper.isEffectBalance(billInfo, strCalType, null);
    }

    public static boolean isEffectBalance(OneKeyBillCostInfo billInfo, OneKeyCalculateParams params) {
        String strCalType = params.getCalType();
        return OneKeyCalculateHelper.isEffectBalance(billInfo, strCalType, params);
    }

    public static boolean isEffectBalance(OneKeyBillCostInfo billInfo, String strCalType, OneKeyCalculateParams params) {
        if (billInfo.isCostPriceMove()) {
            if ("0".equals(strCalType)) {
                return false;
            }
            if ("1".equals(strCalType)) {
                return billInfo.isMoveInCostPriceStorage();
            }
            return true;
        }
        if (billInfo.isCommissionSaleOut()) {
            if (params == null) {
                return false;
            }
            return "1".equals(params.getNotCalConsignSale());
        }
        return !billInfo.isMatAttrChange() || billInfo.isCalculate();
    }

    public static void calculateAvgPrice(OneKeyBillCostInfo billInfo) {
        int presion = billInfo.getPricePrecision();
        if (CalculateUtil.ZERO.compareTo(billInfo.getRecentQty()) == 0) {
            billInfo.setPrice(CalculateUtil.ZERO);
        } else {
            billInfo.setPrice(billInfo.getRecentCost().divide(billInfo.getRecentQty(), presion, 4));
        }
    }

    public static void calculateBalance(OneKeyBillCostInfo balanceBill, OneKeyBillCostInfo billInfo, String calType, boolean isIn) {
        if (OneKeyCalculateHelper.isEffectBalance(billInfo, calType)) {
            if (isIn) {
                if (1 == billInfo.getCalculateKind()) {
                    if (!billInfo.isCostAdjustBill()) {
                        balanceBill.setRecentQty(balanceBill.getRecentQty().add(billInfo.getRecentQty().negate()));
                    }
                    balanceBill.setRecentCost(balanceBill.getRecentCost().add(billInfo.getRecentCost().negate()));
                } else {
                    if (!billInfo.isCostAdjustBill()) {
                        balanceBill.setRecentQty(balanceBill.getRecentQty().add(billInfo.getRecentQty()));
                    }
                    balanceBill.setRecentCost(balanceBill.getRecentCost().add(billInfo.getRecentCost()));
                }
            } else {
                if (!billInfo.isCostAdjustBill()) {
                    balanceBill.setRecentQty(balanceBill.getRecentQty().subtract(billInfo.getRecentQty()));
                }
                balanceBill.setRecentCost(balanceBill.getRecentCost().subtract(billInfo.getRecentCost()));
            }
            OneKeyCalculateHelper.calculateAvgPrice(balanceBill);
        }
    }
}

