/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.onekey.app.help;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalTaskStateEnum;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessEntryCollection;
import com.kingdee.eas.scm.cal.onekey.OneKeyCalculateProcessEntryInfo;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class OneKeyCalculateProcessHelper {
    private static final String ONEKEYRESOURCE = "com.kingdee.eas.scm.cal.onekey.OneKeyCalculateResource";

    public static void setProcessExceptionState(Context ctx, String processId) throws BOSException {
        if (StringUtils.isEmpty((String)processId)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        Timestamp endtime = new Timestamp(new Date().getTime());
        sql.append(" UPDATE T_CL_ONEKEYCALCULATEPROCESS SET FSTATE = 3,FRESULT = 3 ,FENDTIME = ? WHERE FID = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{endtime, processId});
        sql.setLength(0);
        sql.append(" UPDATE T_CL_ONEKEYCALPROCESSENTRY SET FSTATE = 3 WHERE FSTATE = 1 AND FPARENTID = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{processId});
    }

    public static void updateProcessJobId(Context ctx, String processId, String jobId) throws BOSException {
        if (StringUtils.isEmpty((String)processId) || StringUtils.isEmpty((String)jobId)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" UPDATE T_CL_ONEKEYCALCULATEPROCESS SET FJOBID = ? WHERE FID = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{jobId, processId});
    }

    public static void updateProcessReportHeaderId(Context ctx, String processId, String reportHeaderId) throws BOSException {
        if (StringUtils.isEmpty((String)processId) || StringUtils.isEmpty((String)reportHeaderId)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" UPDATE T_CL_ONEKEYCALCULATEPROCESS SET FREPORTHEADERID = ? WHERE FID = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{reportHeaderId, processId});
    }

    public static void setProcessSuccessState(Context ctx, String processId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)processId)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        Timestamp endtime = new Timestamp(new Date().getTime());
        sql.append(" SELECT A.FCOMPANYID FCOMPANYID,B.FPERIODYEAR FYEAR,B.FPERIODNUMBER FPERIOD,A.FREPORTHEADERID FREPORTHEADERID");
        sql.append(" FROM T_CL_ONEKEYCALCULATEPROCESS A ");
        sql.append(" INNER JOIN T_BD_PERIOD B ON A.FPERIODID = B.FID ");
        sql.append(" WHERE A.FID = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{processId});
        int totalMatCount = 0;
        int failMatCount = 0;
        int successMatCount = 0;
        int ncmCalMatCount = 0;
        try {
            if (rs.next()) {
                String companyId = rs.getString("FCOMPANYID");
                int year = rs.getInt("FYEAR");
                int period = rs.getInt("FPERIOD");
                String reportHeaderId = rs.getString("FREPORTHEADERID");
                totalMatCount = OneKeyCalculateProcessHelper.getTotalMatCount(ctx, companyId, year, period, reportHeaderId);
                failMatCount = OneKeyCalculateProcessHelper.getFailMatCount(ctx, companyId, year, period, reportHeaderId);
                ncmCalMatCount = OneKeyCalculateProcessHelper.getNCMCalMatCount(ctx, companyId, year, period, reportHeaderId);
                successMatCount = totalMatCount - failMatCount;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" UPDATE T_CL_ONEKEYCALCULATEPROCESS SET FSTATE = 2,FRESULT = 1 ,FENDTIME = ? ,FTOTALCOUNT = ? ,");
        sql.append(" FSUCCESSCOUNT=?, FAILCOUNT=?,FProductCount=?, FCurProcess = null ");
        sql.append(" WHERE FID = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{endtime, totalMatCount, successMatCount, failMatCount, ncmCalMatCount, processId});
    }

    public static void setProcessEntrySucess(Context ctx, String processEntryId) throws BOSException {
        if (StringUtils.isEmpty((String)processEntryId)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        Timestamp endtime = new Timestamp(new Date().getTime());
        sql.append(" UPDATE T_CL_ONEKEYCALPROCESSENTRY SET FSTATE = 2,FENDTIME = ?,FCOMPLETECOUNT = FTOTALCOUNT,FPROCESSRATE = 100 ");
        sql.append(" WHERE FID = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{endtime, processEntryId});
    }

    public static void setProcessRate(Context ctx, String processEntryId, int rate) throws BOSException {
        if (StringUtils.isEmpty((String)processEntryId)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" UPDATE T_CL_ONEKEYCALPROCESSENTRY FPROCESSRATE = " + rate);
        sql.append(" WHERE FID = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{processEntryId});
    }

    public static void setPocessEntryStart(Context ctx, String processEntryId) throws BOSException {
        if (StringUtils.isEmpty((String)processEntryId)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        Timestamp endtime = new Timestamp(new Date().getTime());
        sql.append(" UPDATE T_CL_ONEKEYCALPROCESSENTRY SET FSTATE = 1,FSTARTTIME = ?,FCOMPLETECOUNT = 0, FPROCESSRATE = 0, ");
        sql.append(" FENDTIME = null WHERE FID = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{endtime, processEntryId});
        sql.setLength(0);
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        sql.append(" UPDATE T_CL_ONEKEYCALCULATEPROCESS T0 SET (FCURPROCESS) = (");
        sql.append(" SELECT FNAME_").append(loc).append(" FROM T_CL_ONEKEYCALPROCESSENTRY T1");
        sql.append(" WHERE T1.FID = ? AND T0.FID = T1.FPARENTID ) WHERE T0.FID IN (");
        sql.append(" SELECT FPARENTID  FROM T_CL_ONEKEYCALPROCESSENTRY WHERE FID = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{processEntryId, processEntryId});
    }

    private static int getFailMatCount(Context ctx, String companyId, int year, int period, String reportHeaderId) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT COUNT(1) FCOUNT FROM( ");
        sql.append(" SELECT DISTINCT FMATERIALID FROM T_CL_CostComputePriceReport ");
        sql.append(" WHERE FSTATE <> 1 AND FCOMPANYORGUNITID = ? AND FYEAR = ? AND FPERIOD = ? AND FPARENTID = ?) T");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, year, period, reportHeaderId});
        int totalCount = 0;
        try {
            if (rs.next()) {
                totalCount = rs.getInt("FCOUNT");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return totalCount;
    }

    private static int getNCMCalMatCount(Context ctx, String companyId, int year, int period, String reportHeaderId) throws BOSException, EASBizException {
        if (!SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.COSTMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyId))) {
            return 0;
        }
        StringBuilder sql = new StringBuilder();
        String inputTemp = OneKeyCalculateProcessHelper.getInputTemp(ctx, companyId, year, period);
        sql.append(" SELECT COUNT(1) FCOUNT FROM( ");
        sql.append(" SELECT DISTINCT FMATERIALID FROM T_CL_CostComputePriceReport ");
        sql.append(" WHERE FMATERIALID IN (SELECT FMATERIALID FROM ").append(inputTemp).append(") ");
        sql.append(" AND FCOMPANYORGUNITID = ? AND FYEAR = ? AND FPERIOD = ? AND FPARENTID = ?) T");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, year, period, reportHeaderId});
        int totalCount = 0;
        try {
            if (rs.next()) {
                totalCount = rs.getInt("FCOUNT");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return totalCount;
    }

    private static String getInputTemp(Context ctx, String companyId, int year, int period) throws EASBizException, BOSException {
        String inputMatTemp = null;
        StringBuilder sql = new StringBuilder();
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)year, (int)period, (IObjectPK)new ObjectUuidPK(companyId));
        String ncmBalanceTbl = OneKeyCalculateProcessHelper.getNCMBalanceTabl(ctx, companyId);
        sql.append("CREATE TABLE TEMP ( FMATERIALID VARCHAR(44)) ");
        inputMatTemp = KsqlUtil.createTempTable((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        if (!StringUtils.isEmpty((String)ncmBalanceTbl)) {
            sql.append(" INSERT INTO ").append(inputMatTemp).append(" (FMATERIALID) \n");
            sql.append(" SELECT DISTINCT MAT.FID FROM ").append(ncmBalanceTbl).append(" bala \n");
            sql.append(" INNER JOIN T_BD_COSTOBJECT COBJ ON BALA.FCOSTOBJECTID = COBJ.FID \n");
            sql.append(" INNER JOIN T_BD_MATERIAL MAT ON COBJ.FRELATEDID = MAT.FID \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
        }
        sql.append(" INSERT INTO ").append(inputMatTemp).append(" (FMATERIALID) \n");
        sql.append(" SELECT DISTINCT MAT.FID FROM T_NCM_INPUTQTYBILL BILL ");
        sql.append(" INNER JOIN T_NCM_INPUTQTYBILLENTRY ENTRY ON BILL.FID = ENTRY.FPARENTID ");
        sql.append(" INNER JOIN T_BD_COSTOBJECT COBJ ON ENTRY.FCOSTOBJECTID = COBJ.FID ");
        sql.append(" INNER JOIN T_BD_MATERIAL MAT ON COBJ.FRELATEDID = MAT.FID ");
        sql.append(" WHERE BILL.FCOMPANYORG = ? AND BILL.FCALCULATEPERIOD = ? ");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{companyId, periodInfo.getId().toString()});
        sql.setLength(0);
        return inputMatTemp;
    }

    private static String getNCMBalanceTabl(Context ctx, String companyId) throws EASBizException, BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT FPHYSICALTBLNAME FROM T_NCM_DYNAMICTABLEMAP WHERE FCOMPANYID = ? AND FBUSINESSTBLNAME = 'T_NCM_BALANCE'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{companyId});
        sql.setLength(0);
        String ncmBalanceTbl = null;
        try {
            if (rs.next()) {
                ncmBalanceTbl = rs.getString("FPHYSICALTBLNAME");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ncmBalanceTbl;
    }

    private static int getTotalMatCount(Context ctx, String companyId, int year, int period, String reportHeaderId) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT COUNT(1) FCOUNT FROM( ");
        sql.append(" SELECT DISTINCT FMATERIALID FROM T_CL_CostComputePriceReport ");
        sql.append(" WHERE FCOMPANYORGUNITID = ? AND FYEAR = ? AND FPERIOD = ? AND FPARENTID = ?) T");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, year, period, reportHeaderId});
        int totalCount = 0;
        try {
            if (rs.next()) {
                totalCount = rs.getInt("FCOUNT");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return totalCount;
    }

    public static OneKeyCalculateProcessEntryCollection buildEntryCollByRankTable(Context ctx, String companyId, PeriodInfo periodInfo, int seq, Map<String, String> processEntryMap) throws BOSException {
        String entryName = null;
        OneKeyCalculateProcessEntryCollection entrys = new OneKeyCalculateProcessEntryCollection();
        OneKeyCalculateProcessEntryInfo entryInfo = null;
        String periodId = periodInfo.getId().toString();
        Map<Integer, Integer> assembleMap = OneKeyCalculateProcessHelper.getAssembleAndDisAssembleMap(ctx, companyId, periodId);
        Map<Integer, Integer> matChangeMap = OneKeyCalculateProcessHelper.getInCalMap(ctx, companyId, periodId, "FISMATCHANGECALC");
        Map<Integer, Integer> devolveMap = OneKeyCalculateProcessHelper.getInCalMap(ctx, companyId, periodId, "FISDEVOLVECALC");
        Map<Integer, Integer> addAvgMap = OneKeyCalculateProcessHelper.getOutCalMap(ctx, companyId, periodId, AccountType.ADD_AVERAGE);
        Map<Integer, Integer> specialMap = OneKeyCalculateProcessHelper.getOutCalMap(ctx, companyId, periodId, AccountType.SPECIAL_ACCT);
        Map<Integer, Integer> fifoMap = OneKeyCalculateProcessHelper.getOutCalMap(ctx, companyId, periodId, AccountType.FIN_FOUT);
        Map<Integer, Integer> moveWeightMap = OneKeyCalculateProcessHelper.getOutCalMap(ctx, companyId, periodId, AccountType.MOVE_WEIGHTED_AVERAGE);
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT DISTINCT FRANK FROM T_CL_MATERIALCALCRANK WHERE FCOMPANYORGUNITID = ? AND FPERIODID = ? ORDER BY FRANK ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodId});
        try {
            while (rs.next()) {
                int rank = rs.getInt("FRANK");
                entryName = ResourceBase.getString((String)ONEKEYRESOURCE, (String)"assmebleCal", (Locale)ctx.getLocale(), (Object[])new Object[]{rank});
                entryInfo = OneKeyCalculateProcessHelper.buildNewEntryInfo(assembleMap, rank, entryName);
                if (entryInfo != null) {
                    entryInfo.setSeq(seq);
                    entrys.add(entryInfo);
                    processEntryMap.put(rank + "assemble", entryInfo.getId().toString());
                    ++seq;
                }
                if ((entryInfo = OneKeyCalculateProcessHelper.buildNewEntryInfo(matChangeMap, rank, entryName = ResourceBase.getString((String)ONEKEYRESOURCE, (String)"matChangeCal", (Locale)ctx.getLocale(), (Object[])new Object[]{rank}))) != null) {
                    entryInfo.setSeq(seq);
                    entrys.add(entryInfo);
                    processEntryMap.put(rank + "matChange", entryInfo.getId().toString());
                    ++seq;
                }
                if ((entryInfo = OneKeyCalculateProcessHelper.buildNewEntryInfo(devolveMap, rank, entryName = ResourceBase.getString((String)ONEKEYRESOURCE, (String)"devolveCal", (Locale)ctx.getLocale(), (Object[])new Object[]{rank}))) != null) {
                    entryInfo.setSeq(seq);
                    entrys.add(entryInfo);
                    processEntryMap.put(rank + "devolve", entryInfo.getId().toString());
                    ++seq;
                }
                if ((entryInfo = OneKeyCalculateProcessHelper.buildNewEntryInfo(addAvgMap, rank, entryName = ResourceBase.getString((String)ONEKEYRESOURCE, (String)"addAvgCal", (Locale)ctx.getLocale(), (Object[])new Object[]{rank}))) != null) {
                    entryInfo.setSeq(seq);
                    entrys.add(entryInfo);
                    processEntryMap.put(rank + "addAvg", entryInfo.getId().toString());
                    ++seq;
                }
                if ((entryInfo = OneKeyCalculateProcessHelper.buildNewEntryInfo(specialMap, rank, entryName = ResourceBase.getString((String)ONEKEYRESOURCE, (String)"specialCal", (Locale)ctx.getLocale(), (Object[])new Object[]{rank}))) != null) {
                    entryInfo.setSeq(seq);
                    entrys.add(entryInfo);
                    processEntryMap.put(rank + "special", entryInfo.getId().toString());
                    ++seq;
                }
                if ((entryInfo = OneKeyCalculateProcessHelper.buildNewEntryInfo(fifoMap, rank, entryName = ResourceBase.getString((String)ONEKEYRESOURCE, (String)"fifoCal", (Locale)ctx.getLocale(), (Object[])new Object[]{rank}))) != null) {
                    entryInfo.setSeq(seq);
                    entrys.add(entryInfo);
                    processEntryMap.put(rank + "fifo", entryInfo.getId().toString());
                    ++seq;
                }
                if ((entryInfo = OneKeyCalculateProcessHelper.buildNewEntryInfo(moveWeightMap, rank, entryName = ResourceBase.getString((String)ONEKEYRESOURCE, (String)"moveWeight", (Locale)ctx.getLocale(), (Object[])new Object[]{rank}))) == null) continue;
                entryInfo.setSeq(seq);
                entrys.add(entryInfo);
                processEntryMap.put(rank + "moveWeight", entryInfo.getId().toString());
                ++seq;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return entrys;
    }

    private static Map<Integer, Integer> getInCalMap(Context ctx, String companyId, String periodId, String field) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT FRANK,COUNT(1) FCOUNT FROM T_CL_MATERIALCALCRANK WHERE FCOMPANYORGUNITID = ? AND FPERIODID = ? ");
        sql.append(" AND ").append(field).append(" = 1");
        sql.append(" GROUP BY FRANK ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodId});
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        try {
            while (rs.next()) {
                result.put(rs.getInt("FRANK"), rs.getInt("FCOUNT"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static Map<Integer, Integer> getAssembleAndDisAssembleMap(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT FRANK,COUNT(1) FCOUNT FROM T_CL_MATERIALCALCRANK WHERE FCOMPANYORGUNITID = ? AND FPERIODID = ? ");
        sql.append(" AND (FISASSEMBLECALC = 1 OR FISDISASSEMBLECALC = 1) ");
        sql.append(" GROUP BY FRANK ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodId});
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        try {
            while (rs.next()) {
                result.put(rs.getInt("FRANK"), rs.getInt("FCOUNT"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static Map<Integer, Integer> getOutCalMap(Context ctx, String companyId, String periodId, AccountType accountType) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT FRANK,COUNT(1) FCOUNT FROM T_CL_MATERIALCALCRANK A  ");
        sql.append(" INNER JOIN T_BD_MATERIALCOMPANYINFO  B ON A.FCOMPANYORGUNITID = B.FCOMPANYID AND A.FMATERIALID = B.FMATERIALID ");
        sql.append(" WHERE FCOMPANYORGUNITID = ? AND FPERIODID = ? AND B.FACCOUNTTYPE = ?");
        sql.append(" GROUP BY FRANK");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, periodId, accountType.getValue()});
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        try {
            while (rs.next()) {
                result.put(rs.getInt("FRANK"), rs.getInt("FCOUNT"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private static OneKeyCalculateProcessEntryInfo buildNewEntryInfo(Map<Integer, Integer> calMap, int rank, String entryName) {
        OneKeyCalculateProcessEntryInfo entryInfo = null;
        if (calMap.containsKey(rank)) {
            entryInfo = new OneKeyCalculateProcessEntryInfo();
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
            entryInfo.setName(entryName);
            entryInfo.setState(OneKeyCalTaskStateEnum.notStart);
            entryInfo.setTotalCount(calMap.get(rank));
            entryInfo.setProcessRate(0);
        }
        return entryInfo;
    }
}

