/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DBUtil
extends DbUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.util.DBUtil");
    private static final int MAX_STATMENT = 200;

    public static void execute(Context ctx, String[] sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            if (sql != null && sql.length > 0) {
                for (int i = 0; i < sql.length; ++i) {
                    statement.addBatch(sql[i]);
                    sqlstr.append(sql[i]).append("\t\n");
                }
                statement.executeBatch();
                statement.clearBatch();
            }
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqlstr, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    public static Object takeValue(Context ctx, String sql) throws BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block6: {
            Object object;
            block5: {
                conn = null;
                stmt = null;
                rs = null;
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs != null) break block5;
                Object var5_5 = null;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
                return var5_5;
            }
            try {
                if (!rs.next()) break block6;
                object = rs.getObject(1);
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return object;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return null;
    }

    public static void dropTempTable(Context ctx, String tempTableName) throws BOSException, EASBizException {
        if (tempTableName != null) {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTemporaryTableName(tempTableName);
        }
    }

    public static void releaseTempTable(Context ctx, String tempTableName) throws BOSException {
        if (tempTableName != null) {
            Connection con = null;
            try {
                con = EJBFactory.getConnection((Context)ctx);
                TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
                tmpPool.releaseTable(tempTableName);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                    }
                }
            }
        }
    }

    public static String createTempTable(Context ctx, String serial, String[][] tableFields) throws BOSException {
        String tempTableName = "tempTableName";
        String sqlcreatetable = CalculateUtil.transCreateTable(ctx, CalculateUtil.getCreateTableSQl(tempTableName, tableFields).toString());
        try {
            TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
            tempTableName = tmpPool.createTempTable(sqlcreatetable);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    public static void close(Connection conn, PreparedStatement[] pm, ResultSet[] rs) throws BOSException {
        int i;
        for (i = 0; null != rs && i < rs.length; ++i) {
            if (null == rs[i]) continue;
            try {
                rs[i].close();
                continue;
            }
            catch (SQLException throwables) {
                logger.error((Object)throwables);
            }
        }
        for (i = 0; null != pm && i < pm.length; ++i) {
            if (null == pm[i]) continue;
            try {
                pm[i].close();
                continue;
            }
            catch (SQLException throwables) {
                logger.error((Object)throwables);
            }
        }
        if (null != conn) {
            try {
                conn.close();
            }
            catch (SQLException throwables) {
                logger.error((Object)throwables);
            }
        }
    }

    public static void close(Connection conn, Statement stm) throws BOSException {
        try {
            if (null != conn) {
                conn.close();
            }
            if (null != stm) {
                stm.close();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void execBatchSql(Context ctx, ArrayList sqlList, boolean isUpdateBill) throws BOSException {
        if (isUpdateBill || sqlList.size() >= 200) {
            DBUtil.execute(ctx, sqlList.toArray(new String[sqlList.size()]));
            sqlList.clear();
        }
    }

    public static void execBatchSql(Connection conn, ArrayList sqlList, boolean isUpdateBill) throws BOSException, SQLException {
        if (isUpdateBill || sqlList.size() >= 200) {
            DBUtil.execute(conn, sqlList.toArray(new String[sqlList.size()]));
            sqlList.clear();
        }
    }

    public static void execute(Connection conn, String[] sql) throws BOSException, SQLException {
        StringBuffer sqlstr = new StringBuffer();
        try (Statement statement = null;){
            statement = conn.createStatement();
            if (sql != null && sql.length > 0) {
                for (int i = 0; i < sql.length; ++i) {
                    statement.addBatch(sql[i]);
                    sqlstr.append(sql[i]).append("\t\n");
                }
                statement.executeBatch();
            }
        }
    }

    public static void createTempTableIndex(Context ctx, String tableName, String columns, boolean isUnique) throws BOSException {
        DBUtil.createTempTableIndex(ctx, tableName, columns, isUnique, false);
    }

    public static void createTempTableIndex(Context ctx, String tableName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        try {
            TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
            tmpPool.createIndex(tableName, columns, isUnique, isClustered);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void execute(Connection conn, String sql) throws BOSException, SQLException {
        StringBuffer sqlstr = new StringBuffer();
        try (Statement statement = null;){
            statement = conn.createStatement();
            statement.execute(sql);
        }
    }

    public static Object takeValue(Connection conn, String sql) throws BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            Object object;
            block5: {
                stmt = null;
                rs = null;
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs != null) break block5;
                Object var4_4 = null;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                return var4_4;
            }
            try {
                if (!rs.next()) break block6;
                object = rs.getObject(1);
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return object;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return null;
    }

    public static String createTempTable(Context ctx, String sql) throws BOSException {
        TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
        try {
            return tmpPool.createTempTable(sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void AnalyseTable(Context ctx, Connection con, String table) throws SQLException {
        TempTablePool.getInstance((Context)ctx).analyzeTable(con, table);
    }
}

