/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.cal.BizCLOSEACCOUNTException;
import com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount.AbstractCloseAccountProcessor;
import com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount.CloseAccountExecuteContext;
import com.kingdee.eas.scm.im.inv.CalulateBalanceInfo;
import com.kingdee.eas.scm.im.inv.InventoryBalanceInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CloseAccountDataLoaderProcessor
extends AbstractCloseAccountProcessor {
    private static final long serialVersionUID = 1L;
    private Map params;

    public CloseAccountDataLoaderProcessor(ProcessorConstructParam param) {
        super(param);
        CloseAccountExecuteContext caExeContext = (CloseAccountExecuteContext)super.getExecuteContext();
        this.ctx = caExeContext.getContext();
        this.params = caExeContext.getParams();
        this.companyInfo = caExeContext.getCompanyInfo();
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ApplicationContext appContext = super.getExecuteContext().getApplicationContext();
        Map paramMap = CloseAccountDataLoaderProcessor.getSystemParams(this.ctx, this.companyInfo, this.params);
        appContext.putData("CLOSE_ACCOUNT_PARAM", (Object)paramMap);
    }

    public static Map getSystemParams(Context ctx, CompanyOrgUnitInfo companyInfo, Map param) throws EASBizException, BOSException {
        int precision;
        PeriodInfo curPeriodInfo = null;
        PeriodInfo nextPeriodInfo = null;
        curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (curPeriodInfo == null) {
            throw new BizCLOSEACCOUNTException(BizCLOSEACCOUNTException.NOTSTARTPERIOD);
        }
        nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)curPeriodInfo);
        if (nextPeriodInfo.getId() == null) {
            throw new BizCLOSEACCOUNTException(BizCLOSEACCOUNTException.NEXTPERIODISNULL);
        }
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(companyInfo.getBOSUuid("id"));
        String dischargeType = ipc.getParamValue((IObjectPK)pk, "SCM_CAL_001");
        String calType = ipc.getParamValue((IObjectPK)pk, "SCM_CAL_002");
        String isCheckVoucher = ipc.getParamValue((IObjectPK)pk, "SCM_CAL_003");
        String isDelCostAdjBill = ipc.getParamValue((IObjectPK)pk, "SCM_CAL_019");
        String isCheckCostMoveBalance = ipc.getParamValue((IObjectPK)pk, "SCM_CAL_023");
        String isExceBalPermitCloseAccount = ipc.getParamValue((IObjectPK)pk, "SCM_CAL_025");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.putAll(param);
        paramMap.put("period", curPeriodInfo);
        paramMap.put("nextPeriod", nextPeriodInfo);
        paramMap.put("calType", calType);
        paramMap.put("isCheckVoucher", isCheckVoucher);
        paramMap.put("dischargeType", Integer.valueOf(dischargeType));
        paramMap.put("isDelCostAdjBill", isDelCostAdjBill);
        paramMap.put("isCheckCostMoveBalance", isCheckCostMoveBalance);
        paramMap.put("isExceBalPermitCloseAccount", isExceBalPermitCloseAccount);
        paramMap.put("InvBalBosType", CloseAccountDataLoaderProcessor.getInvBalBOSType(ctx));
        paramMap.put("CalBalBosType", CloseAccountDataLoaderProcessor.getCalBalBOSType(ctx));
        ArrayList<String> listTableNames = new ArrayList<String>();
        listTableNames.add(0, "T_IM_SaleIssueBill");
        listTableNames.add(1, "T_IM_MaterialReqBill");
        listTableNames.add(2, "T_IM_OtherIssueBill");
        listTableNames.add(3, "T_IM_MoveIssueBill");
        listTableNames.add(4, "T_IM_PurInWarehsBill");
        listTableNames.add(5, "T_IM_ManufactureRecBill");
        listTableNames.add(6, "T_IM_OtherInWarehsBill");
        listTableNames.add(7, "T_IM_MoveInWarehsBill");
        listTableNames.add(8, "T_IM_InventoryInitBill");
        listTableNames.add(9, "T_IM_MoveLocationBill");
        listTableNames.add(10, "T_CL_CostAdjustBill");
        listTableNames.add(11, "T_Cl_StandardCostAdjBill");
        listTableNames.add(12, "T_CL_CalculateKindRefactorBill");
        listTableNames.add(13, "T_IM_DecomposeBill");
        listTableNames.add(14, "T_IM_INVSTATEADJUSTBILL");
        paramMap.put("listTableNames", listTableNames);
        ArrayList<String> listEntryTableNames = new ArrayList<String>();
        listEntryTableNames.add(0, "T_IM_SaleIssueEntry");
        listEntryTableNames.add(1, "T_IM_MaterialReqBillEntry");
        listEntryTableNames.add(2, "T_IM_OtherIssueBillEntry");
        listEntryTableNames.add(3, "T_IM_MoveIssueBillEntry");
        listEntryTableNames.add(4, "T_IM_PurInWarehsEntry");
        listEntryTableNames.add(5, "T_IM_ManufactureRecBillEntry");
        listEntryTableNames.add(6, "T_IM_OtherInWarehsBillEntry");
        listEntryTableNames.add(7, "T_IM_MoveInWarehsBillEntry");
        listEntryTableNames.add(8, "T_IM_InventoryInitEntry");
        listEntryTableNames.add(9, "T_IM_MoveLocationBillEntry");
        listEntryTableNames.add(10, "T_CL_CostAdjustBillEntry");
        listEntryTableNames.add(11, "T_CL_StandardCostAdjEntry");
        listEntryTableNames.add(12, "T_CL_CalculateKindRefactEntry");
        listEntryTableNames.add(13, "T_IM_DECOMPOSEENTRY");
        listEntryTableNames.add(14, "T_IM_INVSTATEADJUSTBILLENTRY");
        paramMap.put("listEntryTableNames", listEntryTableNames);
        if (companyInfo.getBaseCurrency().getId() == null) {
            precision = 2;
        } else {
            ICurrency ic = CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyInfo ci = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId()), SCMSelectorFactory.getCurrencySelector());
            precision = ci.getPrecision();
        }
        paramMap.put("precision", new Integer(precision));
        paramMap.put("companyOrgUnitID", companyInfo.getId().toString());
        return paramMap;
    }

    public static String getInvBalBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new InventoryBalanceInfo().getBOSType().toString();
    }

    public static String getCalBalBOSType(Context ctx) throws InvalidDAOMetaDataException {
        return new CalulateBalanceInfo().getBOSType().toString();
    }
}

