/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount.AbstractCloseAccountProcessor;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.im.inv.PurInWarehsVoucherInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class CloseAccountDischargeVoucherProcessor
extends AbstractCloseAccountProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(CloseAccountDischargeVoucherProcessor.class);

    public CloseAccountDischargeVoucherProcessor(ProcessorConstructParam param) {
        super(param);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        if (this.isPreCloseAccount) {
            return;
        }
        super.doProcessing(batchResults);
        Integer dischargeType = (Integer)this.paramMap.get("dischargeType");
        if (dischargeType == 1) {
            if (OperationTypeEnum.Positive.equals((Object)this.OPType)) {
                this.dischargeVoucher(this.ctx, this.companyInfo.getId().toString(), this.paramMap);
            } else {
                this.deleteDischargeVoucher(this.ctx, this.companyInfo.getId().toString(), this.paramMap);
            }
        }
    }

    private void dischargeVoucher(Context ctx, String companyId, Map paramMap) throws BOSException, EASBizException {
        PeriodInfo prePeriod = (PeriodInfo)paramMap.get("period");
        PeriodInfo curPeriod = (PeriodInfo)paramMap.get("nextPeriod");
        if (curPeriod.isIsAdjustPeriod()) {
            return;
        }
        if (prePeriod.isIsAdjustPeriod()) {
            prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)prePeriod);
        }
        StringBuffer sql = new StringBuffer();
        String tmpTable = this.getInitSameWriteOff(ctx, prePeriod, companyId);
        sql.append("select distinct pinv.FBillId,pinv.FVoucherId from T_IM_PurInWarehsVoucher as pinv ");
        sql.append(" inner join t_gl_voucher as voucher on voucher.fid = pinv.FVoucherId ");
        sql.append(" inner join t_im_purinwarehsbill bill on bill.fid = FBillId ");
        sql.append(" inner join t_gl_voucher billVoucher on bill.FVOUCHERID = billVoucher.fid and billVoucher.FPeriodID = ''{2}''");
        sql.append(" where pinv.FCompanyOrgUnitId=''{0}'' and pinv.FVoucherType={1} ");
        sql.append("   and voucher.FPeriodID = ''{2}'' and bill.FFIVOUCHERED = 1");
        sql.append(" and not exists(select 1 from T_IM_PurInWarehsVoucher a where a.FVOUCHERTYPE = {3} and a.FVOUCHERID  = bill.FVOUCHERID and bill.FFIVOUCHERED = 1)");
        sql.append(" and bill.fid not in (");
        sql.append(" select FBillId from " + tmpTable + ")");
        sql.append(" order by pinv.FVoucherId, pinv.FBillId");
        String getDischargeVoucherId = sql.toString();
        String insertPurVoucherInfo = "insert into T_IM_PurInWarehsVoucher(FID,FYear,FPeriod,FCompanyOrgUnitId,FBillId,FVoucherId,FVoucherType,FCreateTime,FCreateMode) values(?,?,?,?,?,?,?,?,?)";
        String updatePurBill = "update T_IM_PurInWarehsBill BILL set FFiVouchered = 0,FVoucherId = null where BILL.FID = ? ";
        StringBuffer reBindVoucher = new StringBuffer(150);
        reBindVoucher.append("update T_IM_PurInWarehsBill UPDATEBILL set (FFiVouchered,FVoucherId) = (select 1,voucher.fid from T_IM_PurInWarehsBill bill").append("\n");
        reBindVoucher.append("inner JOIN T_IM_PurInWarehsVoucher pinv on bill.fid = pinv.FBILLID").append("\n");
        reBindVoucher.append("inner JOIN T_gl_voucher voucher on voucher.fid = pinv.FVOUCHERID ").append("\n");
        reBindVoucher.append("inner join T_BD_Period period on period.fid = voucher.fperiodid").append("\n");
        reBindVoucher.append("where bill.fid = ?").append("\n");
        reBindVoucher.append("and period.FNUMBER = ? and pinv.FVOUCHERTYPE = ? and UPDATEBILL.fid = BILL.FID)");
        String deletePurVoucher = "delete from T_IM_PurInWarehsVoucher where FVoucherId=?";
        IRowSet rs = KsqlUtil.executeQuery((Context)ctx, (String)MessageFormat.format(getDischargeVoucherId, companyId, String.valueOf(1), String.valueOf(prePeriod.getId().toString()), String.valueOf(0)));
        ArrayList<String> idList = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement purstmt = null;
        PreparedStatement reBindVoucherstmt = null;
        PreparedStatement delstmt = null;
        VoucherInfo dischargeVcher = null;
        PurInWarehsVoucherInfo purVoucher = new PurInWarehsVoucherInfo();
        IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(insertPurVoucherInfo);
            purstmt = conn.prepareStatement(updatePurBill);
            reBindVoucherstmt = conn.prepareStatement(reBindVoucher.toString());
            delstmt = conn.prepareStatement(deletePurVoucher);
            IObjectPK pk = null;
            while (rs.next()) {
                String voucherId = rs.getString("FVoucherID");
                if (idList.indexOf(voucherId) == -1) {
                    try {
                        dischargeVcher = (VoucherInfo)voucher.getValue((IObjectPK)new ObjectUuidPK(voucherId), VoucherInfo.getDefaultSelector());
                    }
                    catch (EASBizException e) {
                        delstmt.setString(1, voucherId);
                        delstmt.addBatch();
                        continue;
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                    idList.add(voucherId);
                    dischargeVcher.setId(null);
                    dischargeVcher.setBizDate(curPeriod.getBeginDate());
                    dischargeVcher.setPeriod(curPeriod);
                    dischargeVcher.setBookedDate(curPeriod.getBeginDate());
                    dischargeVcher.setPoster(null);
                    dischargeVcher.setBizStatus(VoucherStatusEnum.TEMP);
                    dischargeVcher.setCanModifyEdited(false);
                    dischargeVcher.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    dischargeVcher.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                    dischargeVcher.setAuditor(null);
                    dischargeVcher.setLocalCreditAmount(dischargeVcher.getLocalCreditAmount().negate());
                    dischargeVcher.setLocalDebitAmount(dischargeVcher.getLocalDebitAmount().negate());
                    dischargeVcher.setReportingCreditAmount(dischargeVcher.getReportingCreditAmount().negate());
                    dischargeVcher.setReportingDebitAmount(dischargeVcher.getReportingDebitAmount().negate());
                    dischargeVcher.setNumber(null);
                    for (int i = 0; i < dischargeVcher.getEntries().size(); ++i) {
                        VoucherEntryInfo entry = dischargeVcher.getEntries().get(i);
                        entry.setId(null);
                        entry.setLocalAmount(entry.getLocalAmount().negate());
                        if (entry.getQuantity() != null) {
                            entry.setQuantity(entry.getQuantity().negate());
                        }
                        entry.setOriginalAmount(entry.getOriginalAmount().negate());
                        entry.setReportingAmount(entry.getReportingAmount().negate());
                        entry.setDescription(entry.getDescription() + "---" + EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"DischargeVoucher"));
                        if (entry.getAssistRecords() == null) continue;
                        for (VoucherAssistRecordInfo rec : entry.getAssistRecords()) {
                            rec.setId(null);
                            rec.setOprStatus(1);
                            rec.setDescription(rec.getDescription() + "---" + EASResource.getString((String)"com.kingdee.eas.scm.cal.ManualWriteOffResource", (String)"DischargeVoucher"));
                            if (rec.getQuantity() != null) {
                                rec.setQuantity(rec.getQuantity().negate());
                            }
                            rec.setOriginalAmount(rec.getOriginalAmount().negate());
                            rec.setLocalAmount(rec.getLocalAmount().negate());
                            rec.setReportingAmount(rec.getReportingAmount().negate());
                        }
                    }
                    pk = this.saveVoucherInNexTx(dischargeVcher, voucher);
                    if (pk == null) {
                        logger.error((Object)("\u51ed\u8bc1\u4fdd\u5b58\u65f6\u53d1\u751f\u9519\u8bef" + dischargeVcher.getNumber()));
                        continue;
                    }
                    boolean result = this.auditVoucherInNexTx(dischargeVcher, voucher, pk);
                    if (!result) {
                        logger.error((Object)("\u51ed\u8bc1\u5ba1\u6838\u65f6\u53d1\u751f\u9519\u8bef" + dischargeVcher.getNumber()));
                    }
                }
                if (pk == null) continue;
                pstmt.setString(1, BOSUuid.create((BOSObjectType)purVoucher.getBOSType()).toString());
                pstmt.setInt(2, curPeriod.getPeriodYear());
                pstmt.setInt(3, curPeriod.getPeriodNumber());
                pstmt.setString(4, companyId);
                pstmt.setString(5, rs.getString("FBillId"));
                pstmt.setString(6, pk.toString());
                pstmt.setInt(7, 2);
                pstmt.setDate(8, new Date(System.currentTimeMillis()));
                pstmt.setInt(9, 1);
                pstmt.addBatch();
                purstmt.setString(1, rs.getString("FBillId"));
                purstmt.addBatch();
                reBindVoucherstmt.setString(1, rs.getString("FBillId"));
                reBindVoucherstmt.setInt(2, curPeriod.getNumber());
                reBindVoucherstmt.setInt(3, 1);
                reBindVoucherstmt.addBatch();
            }
            pstmt.executeBatch();
            purstmt.executeBatch();
            delstmt.executeBatch();
            reBindVoucherstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs, pstmt);
                SQLUtils.cleanup(purstmt);
                SQLUtils.cleanup(delstmt);
                SQLUtils.cleanup(reBindVoucherstmt);
                SQLUtils.cleanup((Connection)conn);
                DBUtil.releaseTempTable((Context)ctx, (String)tmpTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        SQLUtils.cleanup((Statement)purstmt);
        SQLUtils.cleanup((Statement)delstmt);
        SQLUtils.cleanup((Statement)reBindVoucherstmt);
        SQLUtils.cleanup((Connection)conn);
        DBUtil.releaseTempTable((Context)ctx, (String)tmpTable);
    }

    private void deleteDischargeVoucher(Context ctx, String companyId, Map paramMap) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct pinv.FVoucherId from T_IM_PurInWarehsVoucher as pinv ");
        sql.append(" left join t_gl_voucher as voucher on voucher.fid = pinv.FVoucherId ");
        sql.append(" inner join t_im_purinwarehsbill bill on bill.fid = pinv.FBILLID ");
        sql.append(" where pinv.FCompanyOrgUnitId=''{0}'' and pinv.FVoucherType={1} ");
        sql.append("   and (voucher.FPeriodID = ''{2}'' or  pinv.FYEAR = ''{3}'' and pinv.FPERIOD =''{4}'' ) and FCreateMode = 1 ");
        sql.append(" and not exists(select 1 from T_IM_PurInWarehsVoucher a where a.FVOUCHERTYPE = {5} and a.FVOUCHERID = bill.FVOUCHERID and bill.FFIVOUCHERED =1 )");
        String selectVoucherId = sql.toString();
        String deletePurVoucherInfo = "delete from T_IM_PurInWarehsVoucher where FYear={0} and FPeriod={1} and FCompanyOrgUnitId=''{2}'' and FVoucherType={3} and FCreateMode = 1 ";
        sql = new StringBuffer();
        sql.append("update T_IM_PurInWarehsBill as bill set (FFiVouchered,FVoucherId) = ");
        sql.append(" (select 1 as FFiVouchered, pinvoucher.FVoucherId from T_IM_PurInWarehsVoucher as pinvoucher ");
        sql.append("   inner join t_gl_voucher as voucher on voucher.fid = pinvoucher.FVoucherId ");
        sql.append(" where bill.FID = pinvoucher.FBillID and voucher.FPeriodID = ''{0}'' ");
        sql.append("   and pinvoucher.FCompanyOrgUnitId=''{1}'' and pinvoucher.FVoucherType={2}) ");
        String updatePurBill = sql.toString();
        PeriodInfo curPeriod = (PeriodInfo)paramMap.get("period");
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)curPeriod);
        String sSQL = MessageFormat.format(selectVoucherId, companyId, String.valueOf(2), String.valueOf(curPeriod.getId().toString()), String.valueOf(curPeriod.getPeriodYear()), String.valueOf(curPeriod.getPeriodNumber()), String.valueOf(0));
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        HashSet<String> voucherIdSet = new HashSet<String>();
        ArrayList<String> voucherIdList = new ArrayList<String>();
        String voucherId = null;
        VoucherInfo voucher = null;
        try {
            while (rs.next()) {
                voucherId = rs.getString("FVoucherId");
                try {
                    voucher = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherId), SCMSelectorFactory.getVoucherInfoSelector4Cal());
                }
                catch (EASBizException e) {
                    voucherIdSet.add(voucherId);
                    continue;
                }
                Exception result = this.antiVoucherInNexTx(iVoucher, voucher);
                if (result != null) {
                    throw new BOSException((Throwable)result);
                }
                voucherIdSet.add(voucherId);
            }
            voucherIdList.addAll(voucherIdSet);
            iVoucher.deleteVoucherCollection(voucherIdList, SystemEnum.INVENTORYMANAGEMENT);
        }
        catch (EASBizException bize) {
            logger.error((Object)bize);
            throw bize;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        voucherIdList.clear();
        StringBuffer delIds = new StringBuffer();
        for (String s : voucherIdSet) {
            delIds.append("'").append(s).append("',");
        }
        if (delIds.length() > 0) {
            delIds.setLength(delIds.length() - 1);
            String unDelIds = "select fid from t_gl_voucher where fid in(" + delIds + ")";
            IRowSet unDelRs = DBUtil.executeQuery((Context)ctx, (String)unDelIds);
            String id = null;
            try {
                delIds.setLength(0);
                while (unDelRs.next()) {
                    id = unDelRs.getString("fid");
                    voucherIdSet.remove(id);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            for (String idStr : voucherIdSet) {
                delIds.append("'").append(idStr).append("',");
            }
        }
        if (delIds.length() > 0) {
            delIds.setLength(delIds.length() - 1);
        }
        if (delIds.length() > 0) {
            if (prePeriod.isIsAdjustPeriod()) {
                prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)prePeriod);
            }
            if (prePeriod != null && prePeriod.getId() != null) {
                sSQL = MessageFormat.format(updatePurBill, String.valueOf(prePeriod.getId().toString()), companyId, String.valueOf(1), delIds.toString());
                sSQL = sSQL + " where bill.fid in (select fbillid from T_IM_PurInWarehsVoucher where FVoucherId in(" + delIds + "))";
                DBUtil.execute((Context)ctx, (String)sSQL);
            }
            sSQL = MessageFormat.format(deletePurVoucherInfo, String.valueOf(curPeriod.getPeriodYear()), String.valueOf(curPeriod.getPeriodNumber()), companyId, String.valueOf(2), delIds.toString());
            sSQL = sSQL + "and Fvoucherid  in (" + delIds + ")";
            DBUtil.execute((Context)ctx, (String)sSQL);
        }
    }

    public Exception antiVoucherInNexTx(IVoucher iVoucher, VoucherInfo voucher) throws BOSException {
        Exception result = null;
        try {
            result = (Exception)EJBTransactionProxy.invokeByManual((Object)((Object)this), (String)"antiVoucher", (Class[])new Class[]{IVoucher.class, VoucherInfo.class}, (Object[])new Object[]{iVoucher, voucher}, (int)3);
        }
        catch (Exception e) {
            result = e;
        }
        return result;
    }

    protected Exception antiVoucher(IVoucher iVoucher, VoucherInfo voucher) {
        Exception result = null;
        String voucherId = voucher.getId().toString();
        try {
            if (VoucherStatusEnum.POSTED.equals((Object)voucher.getBizStatus())) {
                iVoucher.antiPostVoucher((IObjectPK)new ObjectUuidPK(voucherId), voucher.getBizStatus());
                iVoucher.antiAuditVoucher((IObjectPK)new ObjectUuidPK(voucherId), voucher.getBizStatus());
            } else if (VoucherStatusEnum.AUDITTED.equals((Object)voucher.getBizStatus())) {
                iVoucher.antiAuditVoucher((IObjectPK)new ObjectUuidPK(voucherId), voucher.getBizStatus());
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u53cd\u8fc7\u8d26\u53cd\u5ba1\u6838\u51ed\u8bc1\u51fa\u73b0\u5f02\u5e38\uff1a" + e));
            result = e;
        }
        return result;
    }

    public IObjectPK saveVoucherInNexTx(VoucherInfo dischargeVcher, IVoucher voucher) {
        try {
            Object value = EJBTransactionProxy.invokeByManual((Object)((Object)this), (String)"saveVoucher", (Class[])new Class[]{VoucherInfo.class, IVoucher.class}, (Object[])new Object[]{dischargeVcher, voucher}, (int)3);
            IObjectPK pk = (IObjectPK)value;
            return pk;
        }
        catch (Throwable e) {
            logger.error((Object)("\u7ed3\u8d26\u63d0\u4ea4\u3001\u5ba1\u6838\u51ed\u8bc1\u51fa\u73b0\u5f02\u5e38\uff1a" + e));
            return null;
        }
    }

    public boolean auditVoucherInNexTx(VoucherInfo dischargeVcher, IVoucher voucher, IObjectPK pk) {
        try {
            Object auditvalue = EJBTransactionProxy.invokeByManual((Object)((Object)this), (String)"auditVoucher", (Class[])new Class[]{VoucherInfo.class, IVoucher.class, IObjectPK.class}, (Object[])new Object[]{dischargeVcher, voucher, pk}, (int)3);
            return (Boolean)auditvalue;
        }
        catch (Throwable e) {
            logger.error((Object)("\u7ed3\u8d26\u63d0\u4ea4\u3001\u5ba1\u6838\u51ed\u8bc1\u51fa\u73b0\u5f02\u5e38\uff1a" + e));
            return false;
        }
    }

    IObjectPK saveVoucher(VoucherInfo dischargeVcher, IVoucher voucher) {
        IObjectPK pk = null;
        try {
            pk = voucher.save((CoreBaseInfo)dischargeVcher);
        }
        catch (Exception e) {
            logger.error((Object)("\u7ed3\u8d26\u4fdd\u5b58\u51ed\u8bc1\u51fa\u73b0\u5f02\u5e38\uff1a" + e));
        }
        return pk;
    }

    boolean auditVoucher(VoucherInfo dischargeVcher, IVoucher voucher, IObjectPK pk) {
        try {
            voucher.submitVoucher(pk);
            voucher.auditVoucher(pk, ContextUtil.getCurrentUserInfo((Context)this.ctx).getId());
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("\u7ed3\u8d26\u51ed\u8bc1\u63d0\u4ea4\u3001\u5ba1\u6838\u51fa\u73b0\u5f02\u5e38\uff1a" + e));
            return false;
        }
    }

    private String getInitSameWriteOff(Context ctx, PeriodInfo period, String companyId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String createTempTable = "create table tmp(FBillID varchar(44))";
        String tempTable = DBUtil.createTempTable((Context)ctx, (String)createTempTable);
        sql.append("insert into " + tempTable + " (FBillID) ");
        sql.append("SELECT bill.FID FROM T_IM_PURINWAREHSBILL bill ");
        sql.append("INNER JOIN T_IM_PURINWAREHSENTRY entry ON BILL.FID = ENTRY.FPARENTID ");
        sql.append("INNER JOIN T_CL_WRITEOFFRECORD wo on wo.FBILLENTRYID = entry.FID ");
        sql.append("INNER JOIN T_CL_WRITEOFFRECORD wor on wo.FPARENTID  = wor.FPARENTID ");
        sql.append("INNER JOIN T_IM_PURINWAREHSENTRY allEntry on wor.FBILLENTRYID  = allentry.fid ");
        sql.append("INNER JOIN T_IM_PURINWAREHSBILL allBill on allentry.FPARENTID = allbill.fid ");
        sql.append("INNER JOIN t_im_purinwarehsVoucher pv on bill.FVOUCHERID  = pv.FVOUCHERID ");
        sql.append("WHERE allbill.FISINITBILL = 1 and bill.FYEAR  = " + period.getPeriodYear() + " and bill.FPERIOD = " + period.getPeriodNumber() + " ");
        sql.append("and entry.FCOMPANYORGUNITID ='" + companyId + "' ");
        sql.append("and entry.FUNWRITEOFFQTY = 0 ");
        sql.append("and bill.FISINITBILL = 0 ");
        sql.append("and pv.FVOUCHERTYPE = 1 ");
        DBUtil.execute((Context)ctx, (String)sql.toString());
        return tempTable;
    }
}

