/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.sd.channel.app.IAutoBillProcessor;
import java.util.HashMap;

public abstract class AbstractAutoBillProcessor
implements IAutoBillProcessor {
    @Override
    public void autoDelete(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        this._autoDelete(ctx, billInfo);
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.FALSE);
    }

    public abstract void _autoDelete(Context var1, SCMBillBaseInfo var2) throws EASBizException, BOSException;

    @Override
    public final void autoCreate(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        if (this.shouldAutoCreate(ctx, billInfo)) {
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            this._autoCreate(ctx, billInfo);
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.FALSE);
        }
    }

    protected abstract void _autoCreate(Context var1, SCMBillBaseInfo var2) throws EASBizException, BOSException;

    protected abstract boolean shouldAutoCreate(Context var1, SCMBillBaseInfo var2) throws BOSException;

    protected IObjectPK[] saveBotpBill(BTPTransformResult result, Context ctx) throws BOSException, EASBizException {
        if (result == null) {
            return null;
        }
        IBTPManager iBtpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IObjectCollection destBillCols = result.getBills();
        BOTRelationCollection botRelationCols = result.getBOTRelationCollection();
        IObjectPK[] pks = new IObjectPK[destBillCols.size()];
        int count = destBillCols.size();
        for (int i = 0; i < count; ++i) {
            CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
            pks[i] = iBtpManager.submitRelations(destBillInfo, botRelationCols);
        }
        return pks;
    }

    protected String getBotpId(String number, BOTMappingCollection mappingCol) {
        if (mappingCol == null) {
            return null;
        }
        BOTMappingInfo mappingInfo = null;
        int size = mappingCol.size();
        for (int i = 0; i < size; ++i) {
            mappingInfo = mappingCol.get(i);
            if (!mappingInfo.getName().startsWith(number)) continue;
            return mappingInfo.getId().toString();
        }
        return null;
    }

    protected BOTMappingCollection getBotMappingCollection(Context ctx, String srcBosType, String destBosType, CtrlUnitInfo cuInfo) throws BOTPException, BOSException {
        HashMap<String, CtrlUnitInfo> transmitCtx = new HashMap<String, CtrlUnitInfo>();
        transmitCtx.put("TRANSMITCU", cuInfo);
        return BOTMappingHelper.getMappingForSelect((Context)ctx, (String)srcBosType, (String)destBosType, null, transmitCtx);
    }

    protected String getBotpId(Context ctx, String srcBosType, String destBosType, CtrlUnitInfo cuInfo, String number) throws BOTPException, BOSException {
        BOTMappingCollection mappingCol = null;
        try {
            mappingCol = this.getBotMappingCollection(ctx, srcBosType, destBosType, cuInfo);
        }
        catch (BOTPException bOTPException) {
            // empty catch block
        }
        if (mappingCol == null) {
            return null;
        }
        BOTMappingInfo mappingInfo = null;
        int size = mappingCol.size();
        for (int i = 0; i < size; ++i) {
            mappingInfo = mappingCol.get(i);
            if (!mappingInfo.getName().startsWith(number)) continue;
            return mappingInfo.getId().toString();
        }
        return null;
    }
}

