/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillFactory;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillInfo;
import com.kingdee.eas.scm.sd.channel.ChannelSaleIssueBillInfo;
import com.kingdee.eas.scm.sd.channel.app.AbstractAutoBillProcessor;
import com.kingdee.eas.scm.sd.channel.app.IAutoBillProcessor;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoSaleIssueProcessor
extends AbstractAutoBillProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.AutoSaleIssueProcessor");

    private AutoSaleIssueProcessor() {
    }

    public static IAutoBillProcessor getInstance() {
        return new AutoSaleIssueProcessor();
    }

    @Override
    public void _autoCreate(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        this.createChannelInWarehsBill(ctx, (ChannelSaleIssueBillInfo)billInfo);
    }

    private void createChannelInWarehsBill(Context ctx, ChannelSaleIssueBillInfo siInfo) throws BOSException, EASBizException {
        if (siInfo.getSaleIssueType().getValue() == 3) {
            return;
        }
        try {
            BTPTransformResult result = this.createBillByBotp(ctx, siInfo);
            this.updateBillInfo(ctx, siInfo, result);
            this.saveBotpBill(result, ctx);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateBillInfo(Context ctx, ChannelSaleIssueBillInfo siInfo, BTPTransformResult result) throws EASBizException, BOSException {
        if (result == null) {
            return;
        }
        this.setHeadInfo(ctx, siInfo, result);
        this.setEntryPrecision(ctx, result);
    }

    private void setHeadInfo(Context ctx, ChannelSaleIssueBillInfo siInfo, BTPTransformResult result) throws EASBizException, BOSException {
        ICodingRuleManager manager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        Map currencyMap = this.getCurrencyMap(ctx, result);
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            ChannelInWarehsBillInfo ciwBillInfo = (ChannelInWarehsBillInfo)result.getBills().getObject(i);
            if (manager.getCodingRule((IObjectValue)ciwBillInfo, ciwBillInfo.getSaleOrgUnit().getId().toString()) == null) {
                ciwBillInfo.setNumber("*" + siInfo.getNumber());
            }
            ciwBillInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            ciwBillInfo.setLastUpdateTime(null);
            ciwBillInfo.setAuditTime(null);
            ciwBillInfo.setModificationTime(null);
            CurrencyInfo curInfo = (CurrencyInfo)currencyMap.get(ciwBillInfo.getCurrency().getId().toString());
            ciwBillInfo.setCurrencyPrecision(curInfo.getPrecision());
            curInfo = (CurrencyInfo)currencyMap.get(ciwBillInfo.get("baseCurId"));
            if (curInfo == null) continue;
            ciwBillInfo.setLocalCurPrecision(curInfo.getPrecision());
            ExchangeRateInfo rateInfo = SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)ciwBillInfo.get("couInfo")), (IObjectPK)new ObjectUuidPK(ciwBillInfo.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(curInfo.getId().toString()));
            ciwBillInfo.setExchangeRate(rateInfo == null ? new BigDecimal("1.00") : rateInfo.getConvertRate());
            ciwBillInfo.setExRatePrecision(rateInfo == null ? 2 : rateInfo.getPrecision());
        }
    }

    public void setEntryPrecision(Context ctx, BTPTransformResult result) throws EASBizException, BOSException {
        Map mmuMap = this.getMultiMeasureUnitMap(ctx, result);
        Map matMap = this.getMateiralMap(ctx, result);
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            ChannelInWarehsBillInfo ciwBillInfo = (ChannelInWarehsBillInfo)result.getBills().getObject(i);
            int entrySize = ciwBillInfo.getEntries().size();
            for (int k = 0; k < entrySize; ++k) {
                MultiMeasureUnitInfo mmuInfo;
                ChannelInWarehsBillEntryInfo entryInfo = ciwBillInfo.getEntries().get(k);
                if (entryInfo.getUnit() != null) {
                    mmuInfo = (MultiMeasureUnitInfo)mmuMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getUnit().getId().toString());
                    entryInfo.setUnitPrecision(mmuInfo == null ? 0 : mmuInfo.getQtyPrecision());
                }
                if (entryInfo.getBaseUnit() != null) {
                    mmuInfo = (MultiMeasureUnitInfo)mmuMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getBaseUnit().getId().toString());
                    entryInfo.setBaseUnitPrecision(mmuInfo == null ? 0 : mmuInfo.getQtyPrecision());
                }
                if (entryInfo.getAssistUnit() != null) {
                    mmuInfo = (MultiMeasureUnitInfo)mmuMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getAssistUnit().getId().toString());
                    entryInfo.setAssistUnitPrecision(mmuInfo == null ? 0 : mmuInfo.getQtyPrecision());
                }
                entryInfo.setPricePrecision(((MaterialInfo)matMap.get(entryInfo.getMaterial().getId().toString())).getPricePrecision());
                if (entryInfo.getAmount() == null || ciwBillInfo.getExchangeRate() == null) continue;
                entryInfo.setLocalAmount(entryInfo.getAmount().multiply(ciwBillInfo.getExchangeRate()));
                entryInfo.setLocalAmount(entryInfo.getLocalAmount().setScale(ciwBillInfo.getLocalCurPrecision(), 4));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BTPTransformResult createBillByBotp(Context ctx, ChannelSaleIssueBillInfo siInfo) throws BOSException, BTPException, SQLException, BOTPException {
        String botpId;
        if (siInfo.getCU() == null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FControlUnitID from T_CHA_CHANNELSALEISSUEBILL where FID = ?", (Object[])new Object[]{siInfo.getId().toString()});
            try {
                if (rs.next()) {
                    CtrlUnitInfo cuInfo = new CtrlUnitInfo();
                    cuInfo.setId(BOSUuid.read((String)rs.getString("FControlUnitID")));
                    siInfo.setCU(cuInfo);
                }
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        if ((botpId = this.getBotpId(ctx, SCMConstant.BOSTYPE_CHANNELSALEISSUE, SCMConstant.BOSTYPE_CHANNELINWAREHS, siInfo.getCU(), "SaleIssue_InWarehs")) == null) {
            return null;
        }
        ArrayList<String> entriesKeys = new ArrayList<String>(siInfo.getEntries().size());
        int size = siInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            if (siInfo.getEntries().get(i).getRequireChannel() == null) continue;
            entriesKeys.add(siInfo.getEntries().get(i).getId().toString());
        }
        return entriesKeys.size() == 0 ? null : BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(new String[]{siInfo.getId().toString()}, new String[]{"entries"}, entriesKeys, null, SCMConstant.BOSTYPE_CHANNELINWAREHS, (IObjectPK)new ObjectUuidPK(botpId), SCMConstant.BOSTYPE_CHANNELSALEISSUE);
    }

    @Override
    public void _autoDelete(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        ChannelSaleIssueBillInfo siInfo = (ChannelSaleIssueBillInfo)billInfo;
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct ciw.FId as fid from T_CHA_ChannelInWarehsBillEntry ciwe ");
        sql.append("left join T_CHA_ChannelInWarehsBill ciw on ciw.FId = ciwe.FParentId ");
        sql.append("left join T_BOT_RELATIONENTRY re on ciwe.FId = re.FDestEntryId ");
        sql.append("where ciw.FBaseStatus not in(?,?) and re.FSrcEntryId in (");
        Object[] params = new Object[3 + siInfo.getEntries().size()];
        int size = siInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            sql.append("?,");
            params[i + 2] = siInfo.getEntries().get(i).getId().toString();
        }
        sql.append("?)");
        params[params.length - 1] = "  ";
        params[0] = new Integer(4);
        params[1] = new Integer(7);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            while (rs.next()) {
                ChannelInWarehsBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(rs.getString("fid")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    @Override
    public boolean isAutoDelete(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        boolean flag;
        block7: {
            flag = true;
            ChannelSaleIssueBillInfo siInfo = (ChannelSaleIssueBillInfo)billInfo;
            StringBuffer sql = new StringBuffer();
            sql.append("select distinct ciw.FId as fid, ciw.FBaseStatus as fbasestatus from T_CHA_ChannelInWarehsBillEntry ciwe ");
            sql.append("left join T_CHA_ChannelInWarehsBill ciw on ciw.FId = ciwe.FParentId ");
            sql.append("left join T_BOT_RELATIONENTRY re on ciwe.FId = re.FDestEntryId ");
            sql.append("where re.FSrcEntryId in (");
            Object[] params = new Object[1 + siInfo.getEntries().size()];
            int size = siInfo.getEntries().size();
            for (int i = 0; i < size; ++i) {
                sql.append("?,");
                params[i] = siInfo.getEntries().get(i).getId().toString();
            }
            sql.append("?)");
            params[params.length - 1] = "  ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            try {
                if (rs == null) break block7;
                while (rs.next()) {
                    if (rs.getInt("fbasestatus") != 4 && rs.getInt("fbasestatus") != 7) continue;
                    flag = false;
                    break;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        return flag;
    }

    private Map getMateiralMap(Context ctx, BTPTransformResult result) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet<BOSUuid> ids = new HashSet<BOSUuid>();
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            ChannelInWarehsBillInfo ciwBillInfo = (ChannelInWarehsBillInfo)result.getBills().getObject(i);
            int entrySize = ciwBillInfo.getEntries().size();
            for (int j = 0; j < entrySize; ++j) {
                ChannelInWarehsBillEntryInfo entryInfo = ciwBillInfo.getEntries().get(j);
                ids.add(entryInfo.getMaterial().getId());
            }
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("pricePrecision");
        MaterialCollection col = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(viewInfo);
        HashMap<String, MaterialInfo> map = new HashMap<String, MaterialInfo>(col.size() * 2);
        int size2 = col.size();
        for (int i = 0; i < size2; ++i) {
            map.put(col.get(i).getId().toString(), col.get(i));
        }
        return map;
    }

    protected Map getMultiMeasureUnitMap(Context ctx, BTPTransformResult result) throws BOSException {
        HashMap<String, MultiMeasureUnitInfo> hm = new HashMap<String, MultiMeasureUnitInfo>();
        if (result.getBills().size() > 0) {
            EntityViewInfo entityViewInfo = this.getMultiMeasureUnitEntityViewInfo(result);
            MultiMeasureUnitCollection collection = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(entityViewInfo);
            if (collection != null && collection.size() > 0) {
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    MultiMeasureUnitInfo mmuInfo = collection.get(i);
                    String key = mmuInfo.getMaterial().getId().toString() + mmuInfo.getMeasureUnit().getId().toString();
                    hm.put(key, mmuInfo);
                }
            }
        }
        return hm;
    }

    private Map getCurrencyMap(Context ctx, BTPTransformResult result) throws BOSException, EASBizException {
        HashMap<String, CurrencyInfo> hm = null;
        CurrencyCollection col = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(this.getCurrencyEntityViewInfo(ctx, result));
        hm = new HashMap<String, CurrencyInfo>(col.size() * 2);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            hm.put(col.get(i).getId().toString(), col.get(i));
        }
        return hm;
    }

    private EntityViewInfo getCurrencyEntityViewInfo(Context ctx, BTPTransformResult result) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet<BOSUuid> currencyIds = new HashSet<BOSUuid>();
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            ChannelInWarehsBillInfo ciwBillInfo = (ChannelInWarehsBillInfo)result.getBills().getObject(i);
            CompanyOrgUnitInfo couInfo = this.getCompanyInfo(ctx, ciwBillInfo.getSaleOrgUnit());
            ciwBillInfo.put("couInfo", couInfo);
            if (couInfo.getBaseCurrency() != null) {
                currencyIds.add(couInfo.getBaseCurrency().getId());
                ciwBillInfo.put("baseCurId", couInfo.getBaseCurrency().getId().toString());
            }
            currencyIds.add(ciwBillInfo.getCurrency().getId());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", currencyIds, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("precision");
        return viewInfo;
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, SaleOrgUnitInfo sou) throws BOSException, EASBizException {
        if (sou == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(sou.getId().toString(), 2, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 2, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    protected EntityViewInfo getMultiMeasureUnitEntityViewInfo(BTPTransformResult result) {
        int i;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        int size = result.getBills().size();
        for (i = 0; i < size; ++i) {
            ChannelInWarehsBillInfo ciwBillInfo = (ChannelInWarehsBillInfo)result.getBills().getObject(i);
            int entrySize = ciwBillInfo.getEntries().size();
            for (int j = 0; j < entrySize; ++j) {
                ChannelInWarehsBillEntryInfo entryInfo = ciwBillInfo.getEntries().get(j);
                if (entryInfo.getUnit() != null) {
                    filterInfo.appendFilterItem("material.id", (Object)entryInfo.getMaterial().getId());
                    filterInfo.appendFilterItem("measureUnit.id", (Object)entryInfo.getUnit().getId());
                }
                if (entryInfo.getBaseUnit() != null) {
                    filterInfo.appendFilterItem("material.id", (Object)entryInfo.getMaterial().getId());
                    filterInfo.appendFilterItem("measureUnit.id", (Object)entryInfo.getBaseUnit().getId());
                }
                if (entryInfo.getAssistUnit() == null) continue;
                filterInfo.appendFilterItem("material.id", (Object)entryInfo.getMaterial().getId());
                filterInfo.appendFilterItem("measureUnit.id", (Object)entryInfo.getAssistUnit().getId());
            }
        }
        size = filterInfo.getFilterItems().size() / 2;
        for (i = 0; i < size; ++i) {
            maskString.append("(#").append(i * 2).append(" and #").append(i * 2 + 1).append(")");
            if (i >= size - 1) continue;
            maskString.append(" or ");
        }
        entityViewInfo.setFilter(filterInfo);
        filterInfo.setMaskString(maskString.toString());
        entityViewInfo.getSelector().add("*");
        entityViewInfo.getSelector().add("material.id");
        entityViewInfo.getSelector().add("measureUnit.id");
        return entityViewInfo;
    }

    @Override
    protected boolean shouldAutoCreate(Context ctx, SCMBillBaseInfo billInfo) throws BOSException {
        return true;
    }
}

