/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.DataCollectionTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.app.DynamicBusinessProcessHelper;
import com.kingdee.eas.dynbusiness.app.IBusinessProcessorBuilder;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.IWriteBackHandler;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.WriteBackHandlerFactory;
import com.kingdee.eas.scm.common.app.bizprocess.processorbuilder.SCMBusinessProcessorBuilder4common;
import com.kingdee.eas.scm.sd.channel.ChannelBillException;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillInfo;
import com.kingdee.eas.scm.sd.channel.ChannelJXCAccountBookFactory;
import com.kingdee.eas.scm.sd.channel.app.AbstractChannelInWarehsBillControllerBean;
import com.kingdee.eas.scm.sd.channel.app.AutoInWarehsProcessor;
import com.kingdee.eas.scm.sd.channel.app.SaleChannelInventoryHelper;
import com.kingdee.eas.scm.sd.channel.app.WriteBackNetOrderHandleFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ChannelInWarehsBillControllerBean
extends AbstractChannelInWarehsBillControllerBean
implements IBatchExecute {
    private static final long serialVersionUID = 43142345324532453L;
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.ChannelInWarehsBillControllerBean");
    private static final BigDecimal DONE = new BigDecimal("-1");
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChannelInWarehsBillInfo billInfo = this.getChannelInWarehsBillInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYSUBMITCANAUDIT, new String[]{billInfo.getNumber()});
        }
        this.wirteBack(ctx, pk, BatchActionEnum.AUDIT);
        WriteBackNetOrderHandleFactory.headHandle(ctx, this.getBOSType().toString(), BizActionEnum.AUDIT, new IObjectPK[]{pk});
        try {
            if (this.isUpdateChannelInventory(ctx, pk, billInfo)) {
                new SaleChannelInventoryHelper().updateInventory(ctx, (IObjectValue)billInfo, BizActionEnum.AUDIT);
            }
            this.writeBack(ctx, pk, (IObjectValue)billInfo, BizActionEnum.AUDIT);
            this.autoCreateBill(ctx, billInfo);
            try {
                ChannelJXCAccountBookFactory.getLocalInstance(ctx).audit(pk.toString(), billInfo.getBizDate(), billInfo.getSaleOrgUnit().getId().toString(), billInfo.getChannel().getId().toString(), true);
            }
            catch (Exception e) {
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"0_ChannelInWarehsBillControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
                throw e;
            }
            this.updateAuditStatus(ctx, (IObjectValue)billInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _alert(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChannelInWarehsBillInfo billInfo = (ChannelInWarehsBillInfo)model;
        ObjectUuidPK pk = new ObjectUuidPK(billInfo.getId());
        ChannelInWarehsBillInfo tempBillInfo = this.getChannelInWarehsBillInfo(ctx, (IObjectPK)pk);
        ChannelInWarehsBillInfo billInfoAlter = this.alterQty(tempBillInfo, billInfo);
        if (this.isUpdateChannelInventory(ctx, (IObjectPK)pk, billInfo)) {
            try {
                new SaleChannelInventoryHelper().updateInventory(ctx, (IObjectValue)billInfoAlter, BizActionEnum.AUDIT);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        tempBillInfo.setId(null);
        tempBillInfo.setVersion(billInfo.getVersion() + 1);
        tempBillInfo.setAlterDate(new Date());
        tempBillInfo.setBaseStatus(BillBaseStatusEnum.VERSION);
        ChannelInWarehsBillEntryCollection entries = tempBillInfo.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entries.get(i).setId(null);
        }
        this.addnew(ctx, tempBillInfo);
        billInfo.setAlterDate(new Date());
        billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
        this.alterWriteBackSaleIssue(ctx, tempBillInfo, billInfo);
        WriteBackNetOrderHandleFactory.headHandle(ctx, this.getBOSType().toString(), BizActionEnum.UNAUDIT, new IObjectPK[]{new ObjectUuidPK(tempBillInfo.getId())});
        WriteBackNetOrderHandleFactory.headHandle(ctx, this.getBOSType().toString(), BizActionEnum.AUDIT, new IObjectPK[]{pk});
    }

    private void alterWriteBackSaleIssue(Context ctx, ChannelInWarehsBillInfo oldBillInfo, ChannelInWarehsBillInfo newBillInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_SALEISSUEENTRY AS IMENTRY SET (FAssociateBaseQty,FConfirmBaseQty,FConfirmQty) = ");
        sql.append("(SELECT IMENTRY.FAssociateBaseQty+FBaseQty,IMENTRY.FConfirmBaseQty-FBaseQty,IMENTRY.FConfirmQty-FQty ");
        sql.append(" FROM T_CHA_CHANNELINWAREHSBILL AS CIH LEFT OUTER JOIN T_CHA_CHANNELINWAREHSBILLENTRY AS CIE ON CIH.FID = CIE.FPARENTID ");
        sql.append(" WHERE CIH.FID = '").append(oldBillInfo.getId().toString()).append("' ");
        sql.append(" AND CIE.FSOURCEBILLENTRYID = IMENTRY.FID) ");
        sql.append(" WHERE IMENTRY.FPARENTID IN ");
        sql.append("(SELECT FSOURCEBILLID FROM T_CHA_CHANNELINWAREHSBILLENTRY WHERE FPARENTID = '").append(oldBillInfo.getId().toString()).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("UPDATE T_IM_SALEISSUEENTRY AS IMENTRY SET (FAssociateBaseQty,FConfirmBaseQty,FConfirmQty) = ");
        sql.append("(SELECT IMENTRY.FAssociateBaseQty-FBaseQty,IMENTRY.FConfirmBaseQty+FBaseQty,IMENTRY.FConfirmQty+FQty ");
        sql.append(" FROM T_CHA_CHANNELINWAREHSBILL AS CIH LEFT OUTER JOIN T_CHA_CHANNELINWAREHSBILLENTRY AS CIE ON CIH.FID = CIE.FPARENTID ");
        sql.append(" WHERE CIH.FID = '").append(newBillInfo.getId().toString()).append("' ");
        sql.append(" AND CIE.FSOURCEBILLENTRYID = IMENTRY.FID) ");
        sql.append(" WHERE IMENTRY.FPARENTID IN ");
        sql.append("(SELECT FSOURCEBILLID FROM T_CHA_CHANNELINWAREHSBILLENTRY WHERE FPARENTID = '").append(newBillInfo.getId().toString()).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _alterSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChannelInWarehsBillInfo billInfo = (ChannelInWarehsBillInfo)model;
        if (billInfo.getBaseStatus().getValue() != 4 && billInfo.getBaseStatus().getValue() != -2) {
            throw new ChannelBillException(ChannelBillException.SUBMIT_IS_AUDIT);
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.ALTERING);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(billInfo.getId()), billInfo);
    }

    private ChannelInWarehsBillInfo alterQty(ChannelInWarehsBillInfo oldInfo, ChannelInWarehsBillInfo newInfo) {
        ChannelInWarehsBillEntryInfo entryInfo;
        ChannelInWarehsBillEntryInfo entryInfoOld;
        ChannelInWarehsBillEntryInfo entryInfoNew;
        int i;
        int size;
        ChannelInWarehsBillEntryCollection entries;
        ChannelInWarehsBillEntryCollection entriesOld;
        ChannelInWarehsBillEntryCollection entriesNew;
        ChannelInWarehsBillInfo tempInfo = (ChannelInWarehsBillInfo)newInfo.clone();
        if (newInfo.getInWarehsType().getValue() == 3) {
            entriesNew = newInfo.getEntries();
            entriesOld = oldInfo.getEntries();
            entries = tempInfo.getEntries();
            size = entriesNew.size();
            for (i = 0; i < size; ++i) {
                entryInfoNew = entriesNew.get(i);
                entryInfoOld = entriesOld.get(i);
                entryInfo = entries.get(i);
                entryInfo.setAssistQty(entryInfoNew.getAssistQty() != null ? entryInfoOld.getAssistQty().subtract(entryInfoNew.getAssistQty()) : entryInfoNew.getAssistQty());
                entryInfo.setAssociateQty(entryInfoNew.getAssociateQty() != null ? entryInfoOld.getAssociateQty().subtract(entryInfoNew.getAssociateQty()) : entryInfoNew.getAssociateQty());
                entryInfo.setBaseQty(entryInfoNew.getBaseQty() != null ? entryInfoOld.getBaseQty().subtract(entryInfoNew.getBaseQty()) : entryInfoNew.getBaseQty());
                entryInfo.setQty(entryInfoNew.getQty() != null ? entryInfoOld.getQty().subtract(entryInfoNew.getQty()) : entryInfoNew.getQty());
                entryInfo.setAmount(entryInfoNew.getAmount() != null ? entryInfoOld.getAmount().subtract(entryInfoNew.getAmount()) : entryInfoNew.getAmount());
                entryInfo.setLocalAmount(entryInfoNew.getAmount() != null ? entryInfoOld.getAmount().subtract(entryInfoNew.getLocalAmount()) : entryInfoNew.getAmount());
            }
        }
        if (newInfo.getInWarehsType().getValue() == 1) {
            entriesNew = newInfo.getEntries();
            entriesOld = oldInfo.getEntries();
            entries = tempInfo.getEntries();
            size = entriesNew.size();
            for (i = 0; i < size; ++i) {
                entryInfoNew = entriesNew.get(i);
                entryInfoOld = entriesOld.get(i);
                entryInfo = entries.get(i);
                entryInfo.setAssistQty(entryInfoNew.getAssistQty() != null ? entryInfoNew.getAssistQty().subtract(entryInfoOld.getAssistQty()) : entryInfoNew.getAssistQty());
                entryInfo.setAssociateQty(entryInfoNew.getAssociateQty() != null ? entryInfoNew.getAssociateQty().subtract(entryInfoOld.getAssociateQty()) : entryInfoNew.getAssociateQty());
                entryInfo.setBaseQty(entryInfoNew.getBaseQty() != null ? entryInfoNew.getBaseQty().subtract(entryInfoOld.getBaseQty()) : entryInfoNew.getBaseQty());
                entryInfo.setQty(entryInfoNew.getQty() != null ? entryInfoNew.getQty().subtract(entryInfoOld.getQty()) : entryInfoNew.getQty());
                entryInfo.setAmount(entryInfoNew.getAmount() != null ? entryInfoNew.getAmount().subtract(entryInfoOld.getAmount()) : entryInfoNew.getAmount());
                entryInfo.setLocalAmount(entryInfoNew.getAmount() != null ? entryInfoNew.getAmount().subtract(entryInfoOld.getLocalAmount()) : entryInfoNew.getAmount());
            }
        }
        return tempInfo;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.audit(ctx, pks[i]);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChannelInWarehsBillInfo billInfo = this.getChannelInWarehsBillInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYAUDITCANUNAUDIT, new String[]{billInfo.getNumber()});
        }
        String orgUnitID = billInfo.getSaleOrgUnit().getId().toString();
        if (!this.isUnAudit(ctx, billInfo, orgUnitID, 2)) {
            throw new ChannelBillException(ChannelBillException.NOALLOWUNADUIT);
        }
        if (!this.isAutoDeleteBill(ctx, billInfo)) {
            throw new ChannelBillException(ChannelBillException.NOALLOWUNADUITFORINWAREHS);
        }
        this.wirteBack(ctx, pk, BatchActionEnum.UNAUDIT);
        try {
            if (this.isUpdateChannelInventory(ctx, pk, billInfo)) {
                ChannelInWarehsBillInfo tempInfo = (ChannelInWarehsBillInfo)billInfo.clone();
                this.updateQtyByBillType(tempInfo);
                new SaleChannelInventoryHelper().updateInventory(ctx, (IObjectValue)tempInfo, BizActionEnum.UNAUDIT);
            }
            this.writeBack(ctx, pk, (IObjectValue)billInfo, BizActionEnum.UNAUDIT);
            WriteBackNetOrderHandleFactory.headHandle(ctx, this.getBOSType().toString(), BizActionEnum.UNAUDIT, new IObjectPK[]{pk});
            this.autoDeleteBill(ctx, billInfo);
            try {
                ChannelJXCAccountBookFactory.getLocalInstance(ctx).unAudit(pk.toString(), billInfo.getBizDate(), billInfo.getSaleOrgUnit().getId().toString(), billInfo.getChannel().getId().toString(), true);
            }
            catch (BOSException e) {
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"0_ChannelInWarehsBillControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
                throw e;
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.unAudit(ctx, pks[i]);
        }
    }

    private void autoCreateBill(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        AutoInWarehsProcessor.getInstance().autoCreate(ctx, billInfo);
    }

    private void autoDeleteBill(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        AutoInWarehsProcessor.getInstance().autoDelete(ctx, billInfo);
    }

    private boolean isAutoDeleteBill(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        return AutoInWarehsProcessor.getInstance().isAutoDelete(ctx, billInfo);
    }

    private boolean isUpdateChannelInventory(Context ctx, IObjectPK pk, ChannelInWarehsBillInfo billInfo) throws BOSException, EASBizException {
        DataCollectionTypeEnum channelUpdateType;
        ChannelBaseInfo channelBaseInfo = billInfo.getChannel();
        if (channelBaseInfo != null) {
            channelBaseInfo = ChannelBaseFactory.getLocalInstance((Context)ctx).getChannelBaseInfo((IObjectPK)new ObjectUuidPK(channelBaseInfo.getId().toString()));
        }
        return (channelUpdateType = channelBaseInfo.getDataCollectionType()).getValue().equals("1");
    }

    private void wirteBack(Context ctx, IObjectPK pk, BatchActionEnum op) throws BOSException, EASBizException {
        try {
            DynamicBusinessProcessHelper.batchExecute((Context)ctx, (BizController)this, (IBusinessProcessorBuilder)new SCMBusinessProcessorBuilder4common(op, this.getBOSType(), "pGdb1wEaEADgAABFwKg9C0Y+1VI="), (Object[])new IObjectPK[]{pk}, (String)this.getXmlFileName(op));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void writeBack(Context ctx, IObjectPK pk, IObjectValue model, BizActionEnum action) throws EASBizException, BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select FSourceBillId, FSourceBillEntryId from ");
            sql.append(" t_cha_channelinwarehsbillentry ");
            sql.append(" where FParentID = ? ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{pk.toString()});
            int rsSize = rs.size();
            String[] srcIdArr = new String[rsSize];
            String[][] idList = new String[rsSize][2];
            int i = 0;
            while (rs.next()) {
                idList[i][0] = rs.getString(1);
                idList[i][1] = rs.getString(2);
                srcIdArr[i] = idList[i][0];
                ++i;
            }
            IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)model.getBOSType(), (String[])srcIdArr);
            int length = handlers.length;
            for (int j = 0; j < length && handlers[j] != null; ++j) {
                handlers[j].handle(ctx, action, new String[]{pk.toString()}, idList);
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChannelInWarehsBillInfo billInfo = (ChannelInWarehsBillInfo)model;
        ObjectUuidPK pk = null;
        if (!this.isAddNew(ctx, (IObjectValue)billInfo)) {
            pk = new ObjectUuidPK(billInfo.getId());
            this.checkSubmit(ctx, billInfo);
        }
        String orgUnitID = billInfo.getSaleOrgUnit().getId().toString();
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("pGdb1wEaEADgAABFwKg9C0Y+1VI="));
        billInfo.setBillType(billTypeInfo);
        if (this.isProvideChannleNotNull(ctx, billInfo, orgUnitID, 2)) {
            ChannelInWarehsBillEntryCollection collection = billInfo.getEntries();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                ChannelInWarehsBillEntryInfo entryInfo = collection.get(i);
                if (entryInfo.getProvideType() != null && entryInfo.getProvideType().getValue() == 1 && entryInfo.getProvideSaleOrgUnit() == null) {
                    throw new ChannelBillException(ChannelBillException.ISPROVIDECHANNELNOTNULL, new String[]{String.valueOf(i + 1)});
                }
                if (entryInfo.getProvideType() != null && entryInfo.getProvideType().getValue() == 2 && entryInfo.getProvideChannel() == null) {
                    throw new ChannelBillException(ChannelBillException.ISPROVIDECHANNELNOTNULL, new String[]{String.valueOf(i + 1)});
                }
                if (entryInfo.getProvideChannel() != null || entryInfo.getProvideSaleOrgUnit() != null) continue;
                throw new ChannelBillException(ChannelBillException.ISPROVIDECHANNELNOTNULL, new String[]{String.valueOf(i + 1)});
            }
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        this.updateQtyByBillType(billInfo);
        this.updateAmout(billInfo);
        pk = super._submit(ctx, model);
        if (this.isAuditAfterSubmit(ctx, billInfo, orgUnitID, 2)) {
            this.auditAndLog(ctx, (IObjectPK)pk, billInfo.getBOSType(), billInfo.getNumber(), null);
        }
        return pk;
    }

    private void updateAmout(ChannelInWarehsBillInfo billInfo) {
        if (null != billInfo.getSourceBillType()) {
            ChannelInWarehsBillEntryCollection entries = billInfo.getEntries();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                ChannelInWarehsBillEntryInfo entryInfo = entries.get(i);
                if (null == entryInfo.getQty()) continue;
                entryInfo.setAmount(entryInfo.getQty().multiply(entryInfo.getPrice()));
                entryInfo.setLocalAmount(entryInfo.getQty().multiply(entryInfo.getPrice()));
            }
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChannelInWarehsBillInfo billInfo = (ChannelInWarehsBillInfo)model;
        this.checkSave(ctx, billInfo);
        this.updateQtyByBillType(billInfo);
        this.updateAmout(billInfo);
        return super._save(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChannelInWarehsBillInfo billInfo = this.getChannelInWarehsBillInfo(ctx, pk);
        this.checkDelete(ctx, billInfo);
        super._delete(ctx, pk);
    }

    private void checkDelete(Context ctx, ChannelInWarehsBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() == 4) {
            throw new ChannelBillException(ChannelBillException.DELETE_IS_AUDIT);
        }
    }

    private void checkSubmit(Context ctx, ChannelInWarehsBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() == 4) {
            throw new ChannelBillException(ChannelBillException.SUBMIT_IS_AUDIT);
        }
    }

    private void updateQtyByBillType(ChannelInWarehsBillInfo billInfo) {
        if (billInfo == null || billInfo != null && billInfo.getInWarehsType() == null) {
            return;
        }
        if (billInfo.getInWarehsType().getValue() == 3) {
            ChannelInWarehsBillEntryCollection entries = billInfo.getEntries();
            ChannelInWarehsBillEntryInfo entryInfo = null;
            BigDecimal tempSumQty = ZERO;
            BigDecimal tempSumMoney = ZERO;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entries.get(i);
                entryInfo.setAssistQty(this.dealNegativeQty(entryInfo.getAssistQty()));
                entryInfo.setAssociateQty(this.dealNegativeQty(entryInfo.getAssociateQty()));
                entryInfo.setBaseQty(this.dealNegativeQty(entryInfo.getBaseQty()));
                entryInfo.setQty(this.dealNegativeQty(entryInfo.getQty()));
                entryInfo.setAmount(this.dealNegativeQty(entryInfo.getAmount()));
                entryInfo.setLocalAmount(this.dealNegativeQty(entryInfo.getAmount()));
                tempSumQty = tempSumQty.add(entryInfo.getQty());
                tempSumMoney = tempSumMoney.add(entryInfo.getAmount());
            }
            billInfo.setSumMoney(tempSumMoney);
            billInfo.setSumQty(tempSumQty);
        }
    }

    private BigDecimal dealNegativeQty(BigDecimal qty) {
        if (qty != null && qty.compareTo(ZERO) > 0) {
            qty = qty.multiply(DONE);
        }
        return qty;
    }

    private void checkSave(Context ctx, ChannelInWarehsBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null) {
            if (billInfo.getBaseStatus().getValue() == 4) {
                throw new ChannelBillException(ChannelBillException.SAVE_IS_AUDIT);
            }
            if (billInfo.getBaseStatus().getValue() == 2) {
                throw new ChannelBillException(ChannelBillException.SAVE_IS_SUBMIT);
            }
        }
    }

    protected boolean isProvideChannleNotNull(Context ctx, SCMBillBaseInfo info, String orgUnitID, int orgType) throws BOSException, EASBizException {
        boolean isProvideChannleNotNull = false;
        if (info.getBillType() != null) {
            String billTypeId = info.getBillType().getId().toString();
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String provideChannleNotNull = scmParam.getParamByBillTypeID("SCM_provideChannel_01", orgType, orgUnitID, billTypeId);
            if (provideChannleNotNull != null && provideChannleNotNull.trim().length() != 0 && provideChannleNotNull.trim().equals("1")) {
                isProvideChannleNotNull = true;
            }
        }
        return isProvideChannleNotNull;
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
    }
}

