/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseCollection;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.DataCollectionTypeEnum;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillCollection;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillFactory;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillInfo;
import com.kingdee.eas.scm.sd.channel.ChannelInwarehsTypeEnum;
import com.kingdee.eas.scm.sd.channel.ChannelProviderTypeEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import java.util.Locale;

public class ChannelInwarehsBillImport
extends AbstractDataTransmission {
    public static final String RES_IMPORT_CLASS = "com.kingdee.eas.scm.sd.channel.ChannelImportResource";
    ChannelInWarehsBillInfo inWarehsBillInfo = null;
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    Locale local = new Locale("l2");
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FEntries_qty", "FEntries_price", "FEntries_amount"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"qty", "price", "amount"};

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ChannelInWarehsBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return this.transmitHead(hsData, ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ChannelInWarehsBillInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        CurrencyInfo baseCurrencyInfo;
        int baseStatus;
        int inWarehsType;
        ChannelBaseCollection collection;
        ChannelBaseInfo channelBaseInfo;
        Object data = ((DataToken)lineData.get((Object)"FNumber")).data;
        if (data == null || data != null && data.toString().trim().length() < 1) {
            data = this.getContextParameter("number");
        }
        ChannelBaseInfo tempChannelBaseInfo = channelBaseInfo = (ChannelBaseInfo)this.getContextParameter("channel");
        this.inWarehsBillInfo = null;
        if (data != null && data.toString().trim().length() >= 1) {
            this.inWarehsBillInfo = this.getBillFromNumber(data.toString().trim(), ctx);
        }
        SaleOrgUnitInfo saleOrgUnitInfo = null;
        SalePersonInfo salePersonInfo = null;
        if (tempChannelBaseInfo == null) {
            if (data == null || data.toString().trim().length() < 1) {
                throw new TaskExternalException(this.getChannelImportResource("NUMBER_CANNOT_NULL"));
            }
            Object channelData = ((DataToken)lineData.get((Object)"FChannel_number")).data;
            if (channelData == null) throw new TaskExternalException(this.getChannelImportResource("CHANNEL_CANNOT_NULL"));
            String channelNumber = channelData.toString();
            if (channelNumber == null || channelNumber.trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("CHANNEL_CANNOT_NULL"));
            collection = null;
            try {
                collection = ChannelBaseFactory.getLocalInstance((Context)ctx).getChannelBaseCollection(this.getFilter(channelNumber.toString().trim()));
            }
            catch (BOSException e) {
                throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_CHANNEL"));
            }
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_CHANNEL"));
            channelBaseInfo = collection.get(0);
            if (!this.verifyCollectionType(channelBaseInfo)) {
                throw new TaskExternalException(this.getChannelImportResource("ERROR_COLLECT_TYPE"));
            }
        } else {
            saleOrgUnitInfo = (SaleOrgUnitInfo)this.getContextParameter("saleOrg");
            data = this.getNumber(ctx, data, saleOrgUnitInfo);
            salePersonInfo = (SalePersonInfo)this.getContextParameter("salePerson");
        }
        if (tempChannelBaseInfo == null) {
            Object saleOrgUnitData = ((DataToken)lineData.get((Object)"FSaleOrgUnit_number")).data;
            if (saleOrgUnitData == null) throw new TaskExternalException(this.getChannelImportResource("SALEORG_CANNOT_NULL"));
            String orgNumber = saleOrgUnitData.toString();
            if (orgNumber == null || orgNumber.trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("SALEORG_CANNOT_NULL"));
            collection = null;
            try {
                collection = SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitCollection(this.getFilter(orgNumber.toString().trim()));
            }
            catch (BOSException e) {
                throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_SALEORG"));
            }
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_SALEORG"));
            saleOrgUnitInfo = collection.get(0);
            data = this.getNumber(ctx, data, saleOrgUnitInfo);
        }
        if (this.inWarehsBillInfo == null) {
            this.inWarehsBillInfo = new ChannelInWarehsBillInfo();
            this.inWarehsBillInfo.setNumber(data.toString().trim());
            this.inWarehsBillInfo.setSumMoney(new BigDecimal("0.00"));
            this.inWarehsBillInfo.setSumQty(new BigDecimal("0.00"));
        } else {
            if (this.inWarehsBillInfo.getChannel() != null && channelBaseInfo != null && !this.inWarehsBillInfo.getChannel().getId().toString().equals(channelBaseInfo.getId().toString())) {
                throw new TaskExternalException(data.toString() + this.getChannelImportResource("SAME_NUMBER"));
            }
            if (this.inWarehsBillInfo.getBaseStatus().getValue() == 4) {
                throw new TaskExternalException(data.toString() + this.getChannelImportResource("HAVE_AUDIT"));
            }
        }
        this.inWarehsBillInfo.setChannel(channelBaseInfo);
        this.inWarehsBillInfo.setSaleOrgUnit(saleOrgUnitInfo);
        if (salePersonInfo == null) {
            String salePersonNumber;
            Object salePersonData = ((DataToken)lineData.get((Object)"FSalePerson_number")).data;
            if (salePersonData != null && (salePersonNumber = salePersonData.toString()) != null && salePersonNumber.trim().length() > 0) {
                collection = null;
                try {
                    collection = PersonFactory.getLocalInstance((Context)ctx).getCollection(this.getFilter(salePersonNumber.toString().trim()));
                }
                catch (BOSException e) {
                    // empty catch block
                }
                if (collection != null && collection.size() > 0) {
                    this.inWarehsBillInfo.setSalePerson((PersonInfo)collection.get(0));
                }
            }
        } else {
            this.inWarehsBillInfo.setSalePerson(salePersonInfo.getPerson());
        }
        Object typedata = ((DataToken)lineData.get((Object)"FInWarehsType")).data;
        this.inWarehsBillInfo.setInWarehsType(ChannelInwarehsTypeEnum.NATURAL);
        if (typedata != null && typedata.toString().trim().length() > 0 && ChannelInwarehsTypeEnum.getEnum(inWarehsType = Integer.parseInt(typedata.toString().trim())) != null) {
            this.inWarehsBillInfo.setInWarehsType(ChannelInwarehsTypeEnum.getEnum(inWarehsType));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object date = ((DataToken)lineData.get((Object)"FBizDate")).data;
        if (date == null || date.toString().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("BIZDATE_CANNOT_NULL"));
        try {
            this.inWarehsBillInfo.setBizDate(df.parse(date.toString()));
        }
        catch (ParseException e) {
            throw new TaskExternalException(this.getChannelImportResource("DATE_FORMAT_ERROR"));
        }
        Object statusdate = ((DataToken)lineData.get((Object)"FBaseStatus")).data;
        this.inWarehsBillInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        if (statusdate != null && statusdate.toString().trim().length() > 0 && 1 == (baseStatus = Integer.parseInt(statusdate.toString()))) {
            this.inWarehsBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        if ((baseCurrencyInfo = (CurrencyInfo)this.getContextParameter("baseCurrencyInfo")) != null) {
            this.inWarehsBillInfo.setCurrency(baseCurrencyInfo);
            this.inWarehsBillInfo.setExchangeRate(new BigDecimal("1.00"));
            int precision = baseCurrencyInfo.getPrecision();
            this.inWarehsBillInfo.setLocalCurPrecision(precision);
            this.inWarehsBillInfo.setCurrencyPrecision(precision);
            this.inWarehsBillInfo.setExRatePrecision(2);
        }
        this.inWarehsBillInfo.setRemark((String)((DataToken)lineData.get((Object)"FRemark")).data);
        try {
            BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("pGdb1wEaEADgAABFwKg9C0Y+1VI="));
            this.inWarehsBillInfo.setBillType(billTypeInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(this.getChannelImportResource("ERROR_SETBILLTYPE"));
        }
        ChannelInWarehsBillEntryInfo entryInfo = null;
        boolean isUpdateEntry = false;
        data = ((DataToken)lineData.get((Object)"FEntries_seq")).data;
        if (data != null && data.toString().trim().length() > 0) {
            int seq = Integer.parseInt(data.toString());
            ChannelInWarehsBillEntryCollection entryCollection = this.inWarehsBillInfo.getEntries();
            int num = entryCollection.size();
            for (int i = 0; i < num; ++i) {
                ChannelInWarehsBillEntryInfo tempentryInfo = entryCollection.get(i);
                if (tempentryInfo.getSeq() != seq) continue;
                entryInfo = tempentryInfo;
                isUpdateEntry = true;
            }
            if (!isUpdateEntry) {
                entryInfo = new ChannelInWarehsBillEntryInfo();
                entryInfo.setParent(this.inWarehsBillInfo);
                entryInfo.setSeq(seq);
                entryCollection.add(entryInfo);
            }
        } else {
            ChannelInWarehsBillEntryCollection entryCollection = this.inWarehsBillInfo.getEntries();
            int seq = entryCollection.size() + 1;
            entryInfo = new ChannelInWarehsBillEntryInfo();
            entryInfo.setParent(this.inWarehsBillInfo);
            entryInfo.setSeq(seq);
            entryCollection.add(entryInfo);
        }
        this.handleEntry(entryInfo, lineData, ctx);
        if (this.inWarehsBillInfo.getSumMoney() == null) return this.inWarehsBillInfo;
        this.inWarehsBillInfo.setSumMoney(this.inWarehsBillInfo.getSumMoney().setScale(this.inWarehsBillInfo.getCurrencyPrecision(), 4));
        return this.inWarehsBillInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleEntry(ChannelInWarehsBillEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        Object assistProperty;
        Object batchNo;
        Object provideChannel;
        for (int i = 0; i < this.BIGDECIMAL_FIELDS_EN.length; ++i) {
            try {
                BigDecimal value;
                if (hsData.get(this.BIGDECIMAL_FIELDS_EN[i]) == null) continue;
                Object dataObj = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS_EN[i])).data;
                if (this.BIGDECIMAL_OBJ_EN[i].equals("qty")) {
                    if (dataObj == null || dataObj.toString().trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("QTY_CANNOT_NULL"));
                    value = new BigDecimal(dataObj.toString());
                    if (value == null) throw new TaskExternalException(this.getChannelImportResource("QTY_CANNOT_NULL"));
                    entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i], value);
                    continue;
                }
                if (dataObj == null || dataObj.toString().trim().length() <= 0 || (value = new BigDecimal(dataObj.toString())) == null) continue;
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i], value);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.BIGDECIMAL_FIELDS_EN[i] + this.getChannelImportResource("ERROR_FORMAT") + "\uff0c" + this.getChannelImportResource("BIGDECIMAL_FORMAT"));
            }
        }
        String str = null;
        Object material = ((DataToken)hsData.get((Object)"FEntries$material_number")).data;
        String materialNumber = null;
        if (material == null) throw new TaskExternalException(this.getChannelImportResource("MATERIAL_CANNOT_NULL"));
        materialNumber = str = material.toString();
        if (str == null || str.trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("MATERIAL_CANNOT_NULL"));
        MaterialCollection collection = null;
        try {
            collection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(this.getFilter(str));
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_MATERIAL"));
        }
        if (collection == null || collection.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_MATERIAL"));
        MaterialInfo info = collection.get(0);
        if (info == null) {
            throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_MATERIAL"));
        }
        entryInfo.setMaterial(info);
        entryInfo.setPricePrecision(info.getPricePrecision());
        MeasureUnitInfo baseUnitinfo = info.getBaseUnit();
        entryInfo.setBaseUnit(baseUnitinfo);
        entryInfo.setBaseUnitPrecision(baseUnitinfo.getQtyPrecision());
        Object unit = ((DataToken)hsData.get((Object)"FEntries$unit_number")).data;
        if (unit == null) throw new TaskExternalException(this.getChannelImportResource("UNIT_CANNOT_NULL"));
        str = unit.toString();
        if (str == null || str.trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("UNIT_CANNOT_NULL"));
        boolean flag = this.isExistMeasureUnit(ctx, materialNumber, str);
        if (!flag) {
            throw new TaskExternalException(this.getChannelImportResource("ERROR_MATERIAL_UNIT"));
        }
        MeasureUnitCollection collection2 = null;
        try {
            collection2 = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(this.getFilter(str));
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_NUIT"));
        }
        if (collection2 == null || collection2.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_NUIT"));
        MeasureUnitInfo info2 = collection2.get(0);
        if (info2 == null) {
            throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_NUIT"));
        }
        entryInfo.setUnit(info2);
        Object provideType = ((DataToken)hsData.get((Object)"FEntries$provideType")).data;
        ChannelProviderTypeEnum provideTypeEnum = null;
        if (provideType != null && provideType.toString().trim().length() > 0) {
            int _provideType = Integer.parseInt(provideType.toString());
            provideTypeEnum = ChannelProviderTypeEnum.getEnum(_provideType);
            if (provideTypeEnum == null) {
                throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_PROVIDETYPE"));
            }
            entryInfo.setProvideType(provideTypeEnum);
        }
        if ((provideChannel = ((DataToken)hsData.get((Object)"FEntries$provideChannel")).data) != null && provideChannel.toString().trim().length() > 0) {
            if (provideTypeEnum == null) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_PROVIDETYPE"));
            try {
                if (provideTypeEnum.getValue() == 2) {
                    ChannelBaseCollection channelBaseCollection = ChannelBaseFactory.getLocalInstance((Context)ctx).getChannelBaseCollection(this.getFilter(provideChannel.toString()));
                    if (channelBaseCollection == null || channelBaseCollection.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_PROVIDECHANNEL"));
                    entryInfo.setProvideChannel(channelBaseCollection.get(0));
                } else {
                    SaleOrgUnitCollection saleOrgUnitcollection = SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitCollection(this.getFilter(provideChannel.toString()));
                    if (saleOrgUnitcollection == null || saleOrgUnitcollection.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_PROVIDECHANNEL"));
                    entryInfo.setProvideSaleOrgUnit(saleOrgUnitcollection.get(0));
                }
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
                throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_PROVIDECHANNEL"));
            }
        }
        if ((batchNo = ((DataToken)hsData.get((Object)"FEntries_batchNo")).data) != null) {
            entryInfo.setBatchNo(batchNo.toString());
        }
        if ((assistProperty = ((DataToken)hsData.get((Object)"FEntries$assistProperty_number")).data) != null && assistProperty.toString().trim().length() > 0) {
            try {
                AsstAttrValueCollection collection3 = AsstAttrValueFactory.getLocalInstance((Context)ctx).getAsstAttrValueCollection(this.getFilter(assistProperty.toString()));
                if (collection3 == null || collection3.size() <= 0) {
                    throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_ASSISTPROPERTY"));
                }
                entryInfo.setAssistProperty(collection3.get(0));
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
                throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_ASSISTPROPERTY"));
            }
        }
        MultiMeasureUnitInfo multiMeasureUnitInfo = null;
        try {
            multiMeasureUnitInfo = this.getMultiMeasureUnit(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getUnit().getId().toString());
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (entryInfo.getAssistQty() == null) {
            entryInfo.setAssistQty(new BigDecimal(0.0));
        }
        if (multiMeasureUnitInfo != null) {
            entryInfo.setUnitPrecision(multiMeasureUnitInfo.getQtyPrecision());
            entryInfo.setQty(entryInfo.getQty().setScale(multiMeasureUnitInfo.getQtyPrecision(), 4));
            entryInfo.setBaseQty(entryInfo.getQty().multiply(multiMeasureUnitInfo.getBaseConvsRate()));
            BigDecimal baseQty = entryInfo.getBaseQty().setScale(entryInfo.getBaseUnitPrecision(), 4);
            entryInfo.setBaseQty(baseQty);
        }
        entryInfo.setRemark((String)((DataToken)hsData.get((Object)"FEntries_remark")).data);
        if (entryInfo.getPrice() == null) {
            entryInfo.setPrice(new BigDecimal(0.0));
        }
        if (entryInfo.getAmount() == null) {
            entryInfo.setAmount(new BigDecimal(0.0));
        }
        entryInfo.setPrice(entryInfo.getPrice().setScale(entryInfo.getPricePrecision(), 4));
        entryInfo.setAmount(entryInfo.getAmount().setScale(this.inWarehsBillInfo.getCurrencyPrecision(), 4));
        this.inWarehsBillInfo.setSumMoney(this.inWarehsBillInfo.getSumMoney().add(entryInfo.getAmount()));
        this.inWarehsBillInfo.setSumQty(this.inWarehsBillInfo.getSumQty().add(entryInfo.getQty()));
    }

    private ChannelInWarehsBillInfo getBillFromNumber(String number, Context ctx) throws TaskExternalException {
        ChannelInWarehsBillCollection collection;
        try {
            collection = ChannelInWarehsBillFactory.getLocalInstance(ctx).getChannelInWarehsBillCollection("where number ='" + number + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            String _pricePrecision = rs.getString("entries.pricePrecision");
            int pricePrecision = _pricePrecision == null ? 2 : Integer.parseInt(_pricePrecision);
            String _qtyPrecision = rs.getString("multiMeasureUnit.qtyPrecision");
            int qtyPrecision = _qtyPrecision == null ? 0 : Integer.parseInt(_qtyPrecision);
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FChannel_number", rs.getString("channel.number"));
            this.putTable(result, "FSaleOrgUnit_number", rs.getString("saleOrgUnit.number"));
            this.putTable(result, "FInWarehsType", rs.getString("inWarehsType"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FSalePerson_number", rs.getString("salePerson.number"));
            this.putTable(result, "FBaseStatus", rs.getString("baseStatus"));
            this.putTable(result, "FRemark", rs.getString("remark"));
            this.putTable(result, "FEntries_seq", rs.getString("entries.seq"));
            this.putTable(result, "FEntries$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntries$material_name_l1", rs.getString("material.name"));
            this.putTable(result, "FEntries$unit_number", rs.getString("unit.number"));
            this.putTable(result, "FEntries_qty", this.dealPrecisioin(rs.getBigDecimal("entries.qty"), qtyPrecision));
            this.putTable(result, "FEntries_price", this.dealPrecisioin(rs.getBigDecimal("entries.price"), pricePrecision));
            this.putTable(result, "FEntries_amount", this.dealPrecisioin(rs.getBigDecimal("entries.amount"), pricePrecision));
            this.putTable(result, "FEntries$provideType", rs.getString("entries.provideType"));
            String provideChannel = null;
            if (rs.getString("entries.provideType") != null && rs.getString("entries.provideType").length() > 0) {
                provideChannel = Integer.parseInt(rs.getString("entries.provideType")) == 2 ? rs.getString("provideChannel.number") : rs.getString("provideSaleOrgUnit.number");
            }
            this.putTable(result, "FEntries$provideChannel", provideChannel);
            this.putTable(result, "FEntries_batchNo", rs.getString("entries.batchNo"));
            this.putTable(result, "FEntries$assistProperty_number", rs.getString("assistProperty.number"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private String dealPrecisioin(BigDecimal number, int precision) {
        if (number != null && number.toString().indexOf("0E") != -1) {
            number = ZERO.setScale(precision);
        } else if (number != null) {
            number = number.setScale(precision, 4);
        }
        return number != null ? number.toString() : null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.channel.app.ChannelInWarehsBillExportQuery";
    }

    private EntityViewInfo getFilter(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo getMultiMeasureUnitEntityViewInfo(String materialId, String unitId) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitId, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1");
        return entityViewInfo;
    }

    private MultiMeasureUnitInfo getMultiMeasureUnit(Context ctx, String materialId, String unitId) throws BOSException {
        EntityViewInfo entityViewInfo = this.getMultiMeasureUnitEntityViewInfo(materialId, unitId);
        MultiMeasureUnitCollection collection = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(entityViewInfo);
        if (collection != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    public String getChannelImportResource(String key) {
        return ResourceBase.getString((String)RES_IMPORT_CLASS, (String)key, (Locale)this.local);
    }

    public boolean verifyCollectionType(ChannelBaseInfo channelBaseInfo) {
        DataCollectionTypeEnum dataCollectionType = channelBaseInfo.getDataCollectionType();
        return dataCollectionType.compareTo((Object)DataCollectionTypeEnum.REPORTINSTORAGE) == 0 || dataCollectionType.compareTo((Object)DataCollectionTypeEnum.REPORTINSALE) == 0;
    }

    private Object getNumber(Context ctx, Object data, SaleOrgUnitInfo saleOrgUnitInfo) throws TaskExternalException {
        data = data != null && data.toString().trim().length() >= 1 ? data : this.getContextParameter("number");
        ChannelInWarehsBillInfo caller = new ChannelInWarehsBillInfo();
        if (data == null || data.toString().trim().length() < 1) {
            boolean isHasCodingRule = this.hasCodingRule(ctx, (IObjectValue)caller, saleOrgUnitInfo.getId().toString());
            if (isHasCodingRule) {
                try {
                    data = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)caller, saleOrgUnitInfo.getId().toString());
                    this.getContextParameter().put("number", data);
                }
                catch (EASBizException e) {
                    Logger.error((Throwable)e);
                    throw new TaskExternalException(this.getChannelImportResource("GETNUMBER_ERROR"));
                }
                catch (BOSException e) {
                    Logger.error((Throwable)e);
                    throw new TaskExternalException(this.getChannelImportResource("GETNUMBER_ERROR"));
                }
            } else {
                throw new TaskExternalException(this.getChannelImportResource("CODINGRULE_UNDEFINED"));
            }
        }
        return data;
    }

    private boolean hasCodingRule(Context ctx, IObjectValue caller, String orgId) {
        try {
            if (orgId != null && orgId.trim().length() > 0 && CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist(caller, orgId)) {
                return true;
            }
            String companyId = this.getNextCompanyId(ctx);
            return companyId != null && companyId.trim().length() > 0 && CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist(caller, companyId);
        }
        catch (Exception err) {
            return false;
        }
    }

    private String getNextCompanyId(Context ctx) throws Exception {
        CompanyOrgUnitInfo comInfo = null;
        ObjectUuidPK pk = new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4");
        CtrlUnitInfo rootCU = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)pk);
        if (rootCU.isIsCompanyOrgUnit()) {
            comInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(rootCU.getId()));
        }
        if (comInfo != null) {
            return comInfo.getId().toString();
        }
        return null;
    }

    private boolean isExistMeasureUnit(Context ctx, String materialNumber, String unitNumber) {
        boolean flag = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) as numbers from T_BD_MultiMeasureUnit t where t.fmaterialid = ");
        sql.append("(select max(fid) from T_BD_Material where fnumber = '").append(materialNumber).append("' group by fnumber) ");
        sql.append(" and t.FMeasureUnitID = ");
        sql.append("(select max(fid) from T_BD_MeasureUnit where fnumber = '").append(unitNumber).append("' group by fnumber)");
        try {
            IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet != null) {
                while (rowSet.next()) {
                    int numbers = rowSet.getInt("numbers");
                    if (numbers <= 0) continue;
                    flag = true;
                }
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return false;
        }
        return flag;
    }
}

