/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.scm.sd.channel.app.AbstractChannelJXCReportControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ChannelJXCReportControllerBean
extends AbstractChannelJXCReportControllerBean {
    private static final long serialVersionUID = 6820866512152962078L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.ChannelJXCReportControllerBean");
    private String where = null;
    private String group = null;
    private String qtyGroup = null;
    private String stattime = null;
    private String userID = null;
    private int billstatus = 4;

    @Override
    protected void _execute(Context ctx, String beginDate, String endDate, String saleOrgUnitID, String channelID, String materialID, String batchNo, String group, String qtyGroup) throws BOSException {
        this.group = group.toLowerCase();
        this.qtyGroup = qtyGroup.toLowerCase();
        this.where = this.getWhereCon(saleOrgUnitID, channelID, materialID, batchNo).toString();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        this.stattime = sdf.format(new Date());
        this.userID = ctx.getUserName();
        try {
            String deleteSql = "delete from t_cha_channeljxcreport where fuserid = ?";
            Object[] value = new Object[]{this.userID};
            DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])value);
            if (beginDate.compareTo(endDate) == 1) {
                return;
            }
            if (!this.isWholeMon(beginDate, endDate)) {
                this.statNotWholeMon(ctx, beginDate, endDate);
            } else {
                this.statWholeMon(ctx, beginDate, endDate);
            }
            DbUtil.execute((Context)ctx, (String)"update t_cha_channeljxcreport set FBatchNo ='~' where FBatchNo is null");
            DbUtil.execute((Context)ctx, (String)"update t_cha_channeljxcreport set fassistpropertyid ='~' where fassistpropertyid is null");
        }
        catch (BOSException e) {
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"1_ChannelJXCReportControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
            throw e;
        }
    }

    private void statNotWholeMon(Context ctx, String beginDate, String endDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String beginYear = beginDate.substring(0, 4);
        String beingMonth = beginDate.substring(5, 7);
        sql.append("insert into t_cha_channeljxcreport(fid, fsaleOrgUnitID, fchannelID, fstatus, fuserid, fstattime, fmaterialid, fbatchno, fassistpropertyid, funitid, fbaseunitid, fassistunitid, finitqty, fbaseinitqty, fassistinitqty) ").append("select newbosid('063C1045'), fsaleOrgUnitID, fchannelID, '1', '" + this.userID + "', '" + this.stattime + "', account.fmaterialid, account.fbatchno, account.fassistpropertyid, account.funitid, account.fbaseunitid, account.fassistunitid, account.fleftqty, account.fbaseleftqty, account.fassistleftqty from t_cha_channeljxcaccountbook account ").append("where 1=1 ").append("and to_date(account.fbizdateyear||'-'||account.fbizdatemon||'-01 00:00:00')=add_months(to_date('" + beginYear + "-" + beingMonth + "-01'), -1)").append(this.where.replaceAll("bill", "account"));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("insert into t_cha_channeljxcreport(fid, fsaleOrgUnitID, fchannelID, fstatus, fuserid, fstattime, fmaterialid, fbatchno, fassistpropertyid, funitid, fbaseunitid, fassistunitid, finitqty, fbaseinitqty, fassistinitqty) ").append("select newbosid('063C1045'), bill.fsaleOrgUnitID, bill.fchannelID, '1', '" + this.userID + "', '" + this.stattime + "', entry.fmaterialid, entry.fbatchno, entry.fassistpropertyid, entry.funitid, entry.fbaseunitid, entry.fassistunitid, entry.fqty, entry.fbaseqty, entry.fassistqty from T_CHA_ChannelInWarehsBillEntry entry ").append("inner join T_CHA_ChannelInWarehsBill bill on bill.fid=entry.fparentid ").append("where 1=1 ").append("and bill.fbasestatus = " + this.billstatus + " ").append("and bill.fbizdate >= to_date('" + beginYear + "-" + beingMonth + "-01') ").append("and bill.fbizdate < to_date('" + beginDate + "') ").append(this.where);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("insert into t_cha_channeljxcreport(fid, fsaleOrgUnitID, fchannelID, fstatus, fuserid, fstattime, fmaterialid, fbatchno, fassistpropertyid, funitid, fbaseunitid, fassistunitid, finitqty, fbaseinitqty, fassistinitqty) ").append("select newbosid('063C1045'), bill.fsaleOrgUnitID, bill.fchannelID, '1', '" + this.userID + "', '" + this.stattime + "', entry.fmaterialid, entry.fbatchno, entry.fassistpropertyid, entry.funitid, entry.fbaseunitid, entry.fassistunitid, 0-entry.fqty, 0-entry.fbaseqty, 0-entry.fassistqty from T_CHA_ChannelSaleIssueEntry entry ").append("inner join T_CHA_ChannelSaleIssueBill bill on bill.fid=entry.fparentid ").append("where 1=1 ").append("and bill.fbasestatus = " + this.billstatus + " ").append("and bill.fbizdate >= to_date('" + beginYear + "-" + beingMonth + "-01') ").append("and bill.fbizdate < to_date('" + beginDate + "') ").append(this.where);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("insert into t_cha_channeljxcreport(fid, fsaleOrgUnitID, fchannelID, fstatus, fuserid, fstattime, fmaterialid, fbatchno, fassistpropertyid, funitid, fbaseunitid, fassistunitid, finqty, fbaseinqty, fassistinqty) ").append("select newbosid('063C1045'), bill.fsaleOrgUnitID, bill.fchannelID, '2', '" + this.userID + "', '" + this.stattime + "', entry.fmaterialid, entry.fbatchno, entry.fassistpropertyid, entry.funitid, entry.fbaseunitid, entry.fassistunitid, entry.fqty, entry.fbaseqty, entry.fassistqty from T_CHA_ChannelInWarehsBillEntry entry ").append("inner join T_CHA_ChannelInWarehsBill bill on bill.fid=entry.fparentid ").append("where 1=1 ").append("and bill.fbasestatus = " + this.billstatus + " ").append("and bill.fbizdate between to_date('" + beginDate + "') and to_date('" + endDate + "') ").append(this.where);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("insert into t_cha_channeljxcreport(fid, fsaleOrgUnitID, fchannelID, fstatus, fuserid, fstattime, fmaterialid, fbatchno, fassistpropertyid, funitid, fbaseunitid, fassistunitid, foutqty, fbaseoutqty, fassistoutqty) ").append("select newbosid('063C1045'), bill.fsaleOrgUnitID, bill.fchannelID, '2', '" + this.userID + "', '" + this.stattime + "', entry.fmaterialid, entry.fbatchno, entry.fassistpropertyid, entry.funitid, entry.fbaseunitid, entry.fassistunitid, entry.fqty, entry.fbaseqty, entry.fassistqty from T_CHA_ChannelSaleIssueEntry entry ").append("inner join T_CHA_ChannelSaleIssueBill bill on bill.fid=entry.fparentid ").append("where 1=1 ").append("and bill.fbasestatus = " + this.billstatus + " ").append("and bill.fbizdate between to_date('" + beginDate + "') and to_date('" + endDate + "') ").append(this.where);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        if (this.isStat()) {
            sql.append("insert into t_cha_channeljxcreport(fid, fsaleOrgUnitID, fchannelID, fstatus, fuserid, fstattime, " + this.group + ", fbaseunitid, finitqty, finqty, foutqty, fleftqty, fbaseinitqty, fbaseinqty, fbaseoutqty, fbaseleftqty, fassistinitqty, fassistinqty, fassistoutqty, fassistleftqty) ");
            sql.append("select newbosid('063C1045'), max(report.fsaleOrgUnitID), max(report.fchannelID), '3', '" + this.userID + "', '" + this.stattime + "', " + this.group.replaceAll("fmaterialid", "report.fmaterialid") + ", " + this.qtyGroup + ", isnull(sum(report.finitqty),0), isnull(sum(report.finqty),0), isnull(sum(report.foutqty),0), isnull(sum(report.fleftqty),0), isnull(sum(round(report.fbaseinitqty/unit.fbaseconvsrate, unit.fqtyprecision)),0), isnull(sum(round(report.fbaseinqty/unit.fbaseconvsrate, unit.fqtyprecision)),0), isnull(sum(round(report.fbaseoutqty/unit.fbaseconvsrate, unit.fqtyprecision)),0), isnull(sum(round(report.fbaseleftqty/unit.fbaseconvsrate, unit.fqtyprecision)),0), isnull(sum(report.fassistinitqty),0), isnull(sum(report.fassistinqty),0), isnull(sum(report.fassistoutqty),0), isnull(sum(report.fassistleftqty),0) from t_cha_channeljxcreport report ").append("left join T_BD_MultiMeasureUnit unit on unit.fmaterialid=report.fmaterialid ").append("where 1=1 ").append("and unit.fisstatunit='1' ");
        } else {
            sql.append("insert into t_cha_channeljxcreport(fid, fsaleOrgUnitID, fchannelID, fstatus, fuserid, fstattime, " + this.group + ", " + this.qtyGroup + ", finitqty, finqty, foutqty, fleftqty, fbaseinitqty, fbaseinqty, fbaseoutqty, fbaseleftqty, fassistinitqty, fassistinqty, fassistoutqty, fassistleftqty) ");
            sql.append("select newbosid('063C1045'), max(report.fsaleOrgUnitID), max(report.fchannelID), '3', '" + this.userID + "', '" + this.stattime + "', " + this.group + ", " + this.qtyGroup + ", isnull(sum(report.finitqty),0), isnull(sum(report.finqty),0), isnull(sum(report.foutqty),0), isnull(sum(report.fleftqty),0), isnull(sum(report.fbaseinitqty),0), isnull(sum(report.fbaseinqty),0), isnull(sum(report.fbaseoutqty),0), isnull(sum(report.fbaseleftqty),0), isnull(sum(report.fassistinitqty),0), isnull(sum(report.fassistinqty),0), isnull(sum(report.fassistoutqty),0), isnull(sum(report.fassistleftqty),0) from t_cha_channeljxcreport report ").append("where 1=1 ");
        }
        sql.append("and report.fstatus in ('1','2') ").append("and report.fuserid='" + this.userID + "' ").append("and report.fstattime='" + this.stattime + "' ");
        if (this.isStat()) {
            sql.append("group by " + this.group.replaceAll("fmaterialid", "report.fmaterialid") + ", " + this.qtyGroup);
        } else {
            sql.append("group by " + this.group + ", " + this.qtyGroup);
        }
        sql.append(this.getTotalSql(sql.toString()));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update t_cha_channeljxcreport as report  ").append("set (fleftqty, fbaseleftqty, fassistleftqty)=(select report_.finitqty+report_.finqty-report_.foutqty, report_.fbaseinitqty+report_.fbaseinqty-report_.fbaseoutqty, report_.fassistinitqty+report_.fassistinqty-report_.fassistoutqty from t_cha_channeljxcreport report_ where report_.fid=report.fid) ").append("where 1=1 ").append("and report.fstatus ='3' ").append("and report.fuserid='" + this.userID + "' ").append("and report.fstattime='" + this.stattime + "' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.updateAssitProperyName(ctx);
    }

    private boolean isStat() {
        return this.qtyGroup.indexOf("fmeasureunitid") != -1;
    }

    private void updateAssitProperyName(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_cha_channeljxcreport as report ").append("set fassistpropertyid=(select FName_l2 from T_BD_AsstAttrValue where fid=report.fassistpropertyid) ").append("where exists(select 1 from T_BD_AsstAttrValue where fid=report.fassistpropertyid)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void statWholeMon(Context ctx, String beginDate, String endDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        if (this.isStat()) {
            sql.append("insert into t_cha_channeljxcreport(fid, fsaleOrgUnitID, fchannelID, fstatus, fuserid, fstattime, " + this.group + ", fbaseunitid, finitqty, finqty, foutqty, fleftqty, fbaseinitqty, fbaseinqty, fbaseoutqty, fbaseleftqty, fassistinitqty, fassistinqty, fassistoutqty, fassistleftqty) ");
            sql.append("select newbosid('063C1045'), max(report.fsaleOrgUnitID), max(report.fchannelID), '3', '" + this.userID + "', '" + this.stattime + "', " + this.group.replaceAll("fmaterialid", "report.fmaterialid") + ", " + this.qtyGroup + ", isnull(sum(report.finitqty),0), isnull(sum(report.finqty),0), isnull(sum(report.foutqty),0), isnull(sum(report.fleftqty),0), isnull(sum(round(report.fbaseinitqty/unit.fbaseconvsrate, unit.fqtyprecision)),0), isnull(sum(round(report.fbaseinqty/unit.fbaseconvsrate, unit.fqtyprecision)),0), isnull(sum(round(report.fbaseoutqty/unit.fbaseconvsrate, unit.fqtyprecision)),0), isnull(sum(round(report.fbaseleftqty/unit.fbaseconvsrate, unit.fqtyprecision)),0), isnull(sum(fassistinitqty),0), isnull(sum(fassistinqty),0), isnull(sum(fassistoutqty),0), isnull(sum(fassistleftqty),0) from t_cha_channeljxcaccountbook report ").append("left join T_BD_MultiMeasureUnit unit on unit.fmaterialid=report.fmaterialid ").append("where 1=1 ").append("and unit.fisstatunit='1' ");
        } else {
            sql.append("insert into t_cha_channeljxcreport(fid, fsaleOrgUnitID, fchannelID, fstatus, fuserid, fstattime, " + this.group + ", " + this.qtyGroup + ", finitqty, finqty, foutqty, fleftqty, fbaseinitqty, fbaseinqty, fbaseoutqty, fbaseleftqty, fassistinitqty, fassistinqty, fassistoutqty, fassistleftqty) ");
            sql.append("select newbosid('063C1045'), max(report.fsaleOrgUnitID), max(report.fchannelID), '3', '" + this.userID + "', '" + this.stattime + "', " + this.group + ", " + this.qtyGroup + ", isnull(sum(report.finitqty),0), isnull(sum(report.finqty),0), isnull(sum(report.foutqty),0), isnull(sum(report.fleftqty),0), isnull(sum(report.fbaseinitqty),0), isnull(sum(report.fbaseinqty),0), isnull(sum(report.fbaseoutqty),0), isnull(sum(report.fbaseleftqty),0), isnull(sum(fassistinitqty),0), isnull(sum(fassistinqty),0), isnull(sum(fassistoutqty),0), isnull(sum(fassistleftqty),0) from t_cha_channeljxcaccountbook report ").append("where 1=1 ");
        }
        sql.append("and to_date(report.fbizdateyear||'-'||report.fbizdatemon||'-01 00:00:00') between to_date('" + beginDate + "') and to_date('" + endDate + "') ");
        sql.append(this.where.replaceAll("bill", "report"));
        if (this.isStat()) {
            sql.append("group by " + this.group.replaceAll("fmaterialid", "report.fmaterialid") + ", " + this.qtyGroup);
        } else {
            sql.append("group by " + this.group + ", " + this.qtyGroup);
        }
        sql.append(this.getTotalSql(sql.toString()));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.updateAssitProperyName(ctx);
    }

    private StringBuffer getTotalSql(String sql) {
        StringBuffer result = new StringBuffer();
        String newGroup = this.group;
        sql = sql.substring(sql.indexOf("select"));
        sql = sql.substring(0, sql.indexOf("group by"));
        int i = 0;
        String str = null;
        while (newGroup.indexOf(",") > 0) {
            int lastIndex = newGroup.lastIndexOf(",");
            newGroup = newGroup.substring(0, lastIndex);
            str = this.getBlank(i);
            str = !str.equals("") ? ", ' ', " + str : ", ' '";
            result.append(" union all " + sql.replaceAll(this.group, newGroup + str + " "));
            if (this.isStat()) {
                result.append(" group by " + newGroup.replaceAll("fmaterialid", "report.fmaterialid") + " ," + this.qtyGroup + " ");
            } else {
                result.append(" group by " + newGroup + " ," + this.qtyGroup + " ");
            }
            ++i;
        }
        newGroup = "'!'";
        str = this.getBlank(i);
        if (!str.equals("")) {
            newGroup = newGroup + "," + str + " ";
        }
        String tempSql = "";
        if (this.isStat()) {
            String select = sql.substring(0, sql.indexOf("left join") - 1);
            tempSql = " union all " + select.replaceAll("report." + this.group, newGroup) + " " + sql.substring(sql.indexOf("left join"));
        } else {
            tempSql = " union all " + sql.replaceAll(this.group, newGroup);
        }
        newGroup = "";
        str = this.getBlank(this.qtyGroup.split(",").length);
        if (!str.equals("")) {
            newGroup = str + " ";
        }
        tempSql = tempSql.replaceAll(this.qtyGroup, newGroup);
        result.append(tempSql);
        return result;
    }

    private String getBlank(int i) {
        String result = "";
        while (i > 0) {
            result = result + ",''";
            --i;
        }
        if (!result.equals("")) {
            result = result.substring(1);
        }
        return result;
    }

    private StringBuffer getWhereCon(String saleOrgUnitID, String channelID, String materialID, String batchNo) {
        StringBuffer where = new StringBuffer();
        if (saleOrgUnitID != null && !saleOrgUnitID.equals("")) {
            where.append("and bill.fsaleorgunitid = '" + saleOrgUnitID + "' ");
        }
        if (channelID != null && !channelID.equals("")) {
            where.append("and bill.fchannelid = '" + channelID + "' ");
        }
        if (materialID != null && !materialID.equals("")) {
            where.append("and fmaterialid in(" + materialID + ") ");
        }
        if (batchNo != null && !batchNo.equals("")) {
            where.append("and fbatchno = '" + batchNo + "' ");
        }
        return where;
    }

    private boolean isWholeMon(String beginDate, String endDate) {
        if (!beginDate.substring(8).equals("01")) {
            return false;
        }
        if (!beginDate.substring(5, 7).equals(endDate.substring(5, 7))) {
            return false;
        }
        String year = endDate.substring(0, 4);
        String month = endDate.substring(5, 7);
        Date firstDayOfMonth = this.parseDate(year + "-" + month + "-01");
        return this.parseDate(endDate).equals(this.getLastDayOfMonth(firstDayOfMonth));
    }

    public String parseDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public Date parseDate(String str) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(str);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return date;
    }

    public Date getFirstDayOfMonth(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        gc.set(5, 1);
        return gc.getTime();
    }

    public Date getLastDayOfMonth(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        switch (gc.get(2)) {
            case 0: {
                gc.set(5, 31);
                break;
            }
            case 1: {
                gc.set(5, 28);
                break;
            }
            case 2: {
                gc.set(5, 31);
                break;
            }
            case 3: {
                gc.set(5, 30);
                break;
            }
            case 4: {
                gc.set(5, 31);
                break;
            }
            case 5: {
                gc.set(5, 30);
                break;
            }
            case 6: {
                gc.set(5, 31);
                break;
            }
            case 7: {
                gc.set(5, 31);
                break;
            }
            case 8: {
                gc.set(5, 30);
                break;
            }
            case 9: {
                gc.set(5, 31);
                break;
            }
            case 10: {
                gc.set(5, 30);
                break;
            }
            case 11: {
                gc.set(5, 31);
            }
        }
        if (gc.get(2) == 1 && this.isLeapYear(gc.get(1))) {
            gc.set(5, 29);
        }
        return gc.getTime();
    }

    public boolean isLeapYear(int year) {
        if (year % 400 == 0) {
            return true;
        }
        if (year % 4 == 0) {
            return year % 100 != 0;
        }
        return false;
    }
}

